/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import java.lang.invoke.MethodHandle;

public class GenericProc
extends MethodProc {
    protected MethodProc[] methods;
    int count;
    int minArgs;
    int maxArgs;
    public static final MethodHandle applyToConsumerGP = GenericProc.lookupApplyHandle(GenericProc.class, "applyToConsumerGP");

    public GenericProc(String name) {
        super(true, applyToConsumerGP);
        this.setName(name);
    }

    public GenericProc() {
        super(true, applyToConsumerGP);
    }

    public int getMethodCount() {
        return this.count;
    }

    public MethodProc getMethod(int i) {
        return i >= this.count ? null : this.methods[i];
    }

    @Override
    public int numArgs() {
        return this.minArgs | this.maxArgs << 12;
    }

    protected synchronized void addAll(MethodProc[] procs) {
        int n = procs.length;
        if (this.methods == null) {
            this.methods = new MethodProc[n];
        }
        for (int i = 0; i < n; ++i) {
            this.add(procs[i]);
        }
    }

    public synchronized void addAtEnd(MethodProc method) {
        int oldCount = this.count;
        if (this.methods == null) {
            this.methods = new MethodProc[8];
        } else if (oldCount >= this.methods.length) {
            MethodProc[] copy = new MethodProc[2 * this.methods.length];
            System.arraycopy(this.methods, 0, copy, 0, oldCount);
            this.methods = copy;
        }
        this.methods[oldCount] = method;
        int n = method.minArgs();
        if (n < this.minArgs || this.count == 0) {
            this.minArgs = n;
        }
        if (((n = method.maxArgs()) < 0 || n > this.maxArgs) && this.maxArgs >= 0) {
            this.maxArgs = n;
        }
        this.count = ++oldCount;
    }

    public synchronized void add(MethodProc method) {
        int oldCount = this.count;
        this.addAtEnd(method);
        for (int i = 0; i < oldCount; ++i) {
            MethodProc best = MethodProc.mostSpecific(method, this.methods[i]);
            if (best != method) continue;
            System.arraycopy(this.methods, i, this.methods, i + 1, oldCount - i);
            this.methods[i] = method;
            break;
        }
    }

    @Override
    public int isApplicable(Type[] args, Type restType) {
        int best = -1;
        int i = this.count;
        while (--i >= 0) {
            MethodProc method = this.methods[i];
            int result = method.isApplicable(args, restType);
            if (result == 1) {
                return 1;
            }
            if (result != 0) continue;
            best = 0;
        }
        return best;
    }

    public static Object applyToConsumerGP(Procedure proc, CallContext ctx) throws Throwable {
        int startState;
        GenericProc gproc = (GenericProc)proc;
        MethodProc[] methods = gproc.methods;
        int count = gproc.count;
        if (count == 0) {
            return methods[0].getApplyToConsumerMethod().invokeExact(methods[0], ctx);
        }
        int methodState = startState = ctx.getMode();
        if (startState == 0) {
            methodState = 1;
        }
        for (int i = 0; i < count; ++i) {
            MethodProc method = methods[i];
            ctx.rewind(methodState);
            Object r = method.getApplyToConsumerMethod().invokeExact(method, ctx);
            if (r == ctx) continue;
            return r;
        }
        ctx.rewind(startState);
        ctx.matchError(-1);
        return ctx;
    }

    public void setProperty(Keyword key, Object value) {
        String name = key.getName();
        if (name == "name") {
            this.setName(value.toString());
        } else if (name == "method") {
            this.add((MethodProc)value);
        } else {
            super.setProperty(key.asSymbol(), value);
        }
    }

    public final void setProperties(Object[] args) {
        int alen = args.length;
        for (int i = 0; i < alen; ++i) {
            Object arg = args[i];
            if (arg instanceof Keyword) {
                this.setProperty((Keyword)arg, args[++i]);
                continue;
            }
            this.add((MethodProc)arg);
        }
    }

    public static GenericProc make(Object[] args) {
        GenericProc result = new GenericProc();
        result.setProperties(args);
        return result;
    }

    public static GenericProc makeWithoutSorting(Object ... args) {
        GenericProc result = new GenericProc();
        int alen = args.length;
        for (int i = 0; i < alen; ++i) {
            Object arg = args[i];
            if (arg instanceof Keyword) {
                result.setProperty((Keyword)arg, args[++i]);
                continue;
            }
            result.addAtEnd((MethodProc)arg);
        }
        return result;
    }
}

