/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Bourgogne for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_26 : {
					width : 122.0026,
					height : 148.27129,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = -129.7769;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3193.03348;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-71" : "m 62.11,82.4 c -1.47,0.74 -0.67,0.34 -2.62,0.83 -1.47,-0.12 -1.21,0.28 -1.64,1.27 -0.33,0.17 -0.77,-0.13 -1.08,0.18 -0.56,0.19 -1.67,-0.27 -1.67,0.68 0.08,0.66 -0.51,1.16 -0.53,1.75 0.4,0.64 1.75,1.14 1.15,2.04 -0.43,0.97 -0.04,2.24 -1.07,2.9 -0.55,0.76 -1.7,0.98 -2.11,1.8 0.34,0.85 1.12,-0.32 1.63,-0.37 0.63,0.26 0.76,1.22 0.89,1.83 -0.13,0.42 -0.58,0.76 -0.38,1.29 -0.35,0.78 -0.39,2.12 0.53,2.48 0.99,0.42 1.85,1.47 2.05,2.54 -0.47,0.91 -1.86,1.05 -2.54,1.8 0.74,0.97 1.09,2.4 0.59,3.54 -0.35,0.67 -1.09,-0.55 -1.54,0.14 -1.15,0.17 -2.36,0.48 -3.11,1.46 -0.49,0.33 -1.01,0.56 -1.32,1.1 -0.95,0.4 -1.91,0.85 -2.96,0.95 -0.72,0.09 -0.91,0.77 -1.32,1.2 -0.53,0.36 -1.2,0.3 -1.81,0.36 -0.36,-1.14 -0.58,-2.66 -2,-2.93 -1.49,-0.66 -2.99,0.83 -4.44,0.47 -0.4,-0.01 -0.77,-0.32 -1.16,-0.19 -0.23,0.55 0.61,0.98 0.45,1.59 -0.12,0.54 0.36,0.75 0.68,0.98 -0.04,0.68 0.49,1.09 0.92,1.51 0.17,0.91 1.4,1.21 1.48,2.18 0.19,0.62 0.78,1.22 0.77,1.85 -0.52,0.44 -0.02,1.03 0.5,1.06 0.34,1.12 0.69,2.47 0.08,3.57 0.1,0.72 1.01,0.77 1.57,0.77 0.74,0.46 1.78,1.55 2.62,0.63 0.48,-0.5 1.05,0.17 0.89,0.67 0.21,0.33 0.88,0.19 0.77,0.76 -0.16,0.87 0.76,1.81 1.57,1.29 0.63,-0.9 1.88,-0.37 2.74,-0.24 0,0.48 0.32,0.85 0.84,0.84 0.89,0.37 1.44,1.29 1.2,2.26 0.01,0.45 -0.43,0.67 -0.25,1.16 -0.34,0.33 -0.41,0.78 -0.35,1.24 -0.46,0.64 -0.32,1.39 0.02,2.06 0.41,0.99 -0.31,2.2 0.2,3.12 0.31,0.01 0.71,0.26 0.26,0.5 -0.6,0.65 -2.03,-0.26 -2.2,0.83 -0.11,1.19 -1.78,0.77 -2.37,1.49 -0.15,0.73 0.69,1.31 0.51,2.1 0.15,0.99 -1.05,1.93 -0.44,2.87 0.94,0.79 2.58,0.01 3.38,0.97 0.09,0.83 0.53,2.07 1.6,1.7 1.3,0.01 2.1,-1.18 3.34,-1.34 0.69,-0.62 1.56,-0.21 2.06,0.44 0.59,0.64 1.82,0.96 2.53,0.39 -0.08,-0.66 0.6,-0.96 1.16,-0.93 0.44,0.32 0.95,1.02 1.48,0.49 0.58,-0.21 1.27,0.16 1,0.84 -0.23,0.29 -0.75,0.79 -0.08,0.95 0.69,0.45 1.22,-0.2 1.49,-0.78 0.38,-0.5 1.18,0.08 1.44,-0.67 0.54,-0.56 1.64,0 2.07,-0.57 -0.34,-0.38 -0.34,-0.89 0.13,-1.2 1.09,-0.77 0.48,-2.43 0.88,-3.53 0.39,-0.73 0.08,-2 1.03,-2.3 0.43,0.03 0.56,-0.66 0.99,-0.24 0.48,0.37 1.21,0.13 1.62,0.65 0.44,0.13 0.99,0.11 1.11,0.68 0.27,1.04 1.62,0.7 2.27,0.27 0.1,-0.5 0.4,-1.45 1.09,-1.18 0.5,0.45 0.2,1.55 1.11,1.61 0.55,0.16 1.31,-0.03 1.19,-0.73 0.23,-0.48 0.64,-0.85 0.81,-1.35 0.49,-0.51 1.05,0.14 1.57,0 0.37,-0.51 1.08,-0.18 1.18,0.38 0.32,0.5 0.85,1.05 0.45,1.68 -0.38,0.14 -1.34,0.13 -0.96,0.8 0.5,0.4 1.27,0.42 1.72,0.99 0.64,0.31 0.69,0.84 0.31,1.37 -0.07,0.4 0.56,0.71 0.01,1.01 -0.53,0.68 -0.34,1.98 0.73,1.92 0.63,0.18 1.53,0.19 1.59,-0.65 0.59,-1.1 0.55,-2.38 1.12,-3.49 0.09,-1.29 0.98,-2.33 1.15,-3.62 0.43,-1.24 1.12,-2.42 0.98,-3.8 0.22,-1.64 1.7,-2.87 1.7,-4.59 -0.03,-0.97 0.35,-1.83 0.97,-2.55 0.34,-1.05 0.31,-2.2 0.94,-3.17 0.16,-0.7 0.92,-0.48 1.12,0.04 0.49,0.11 0.6,-0.79 1.2,-0.47 0.67,0.03 1.45,0.08 1.69,0.81 0.83,0.85 2.36,1.46 3.28,0.37 0.63,-0.16 1.38,0.15 1.92,-0.42 0.38,-0.43 0.92,-0.24 1.36,-0.39 0.08,-0.31 0.16,-0.71 0.55,-0.4 0.48,0.42 1.37,0.18 1.49,1 0.31,1.01 0.58,2.5 1.85,2.69 0.83,0.59 2.05,0.83 3.02,0.5 0.33,-0.52 0.77,-0.91 1.44,-0.75 0.71,0.09 1.38,-0.09 1.93,-0.49 1.04,0.41 2.14,-1.09 1.27,-1.85 -0.86,-0.32 -1.5,-1.14 -2.43,-1.33 -0.11,-1.21 -0.03,-2.46 0.14,-3.61 -0.23,-0.81 1.12,-0.35 1.55,-0.56 0.8,-0.4 0.37,-1.49 0.06,-2.04 0.62,-0.42 1.67,-0.9 1.67,-1.74 -0.2,-0.51 -1.3,-0.78 -0.6,-1.39 0.37,-0.86 -1.15,-1.13 -1.09,-1.85 0.31,-0.38 0.56,-1 0.03,-1.31 -0.28,-0.67 -0.54,-1.46 -1.4,-1.57 -0.52,-0.32 -0.12,-1.22 0.2,-1.6 0.36,-0.25 1.17,-1.25 0.27,-1.31 -0.42,-0.45 -0.86,-0.96 -1.55,-0.97 -0.72,-0.29 -1.08,-1.76 -0.23,-2.06 1.09,0.26 1.89,-0.89 3,-0.75 0.78,-0.1 1.82,0.49 2.45,-0.08 0.24,-0.51 -0.23,-0.87 -0.67,-0.9 -0.28,-0.39 -0.51,-0.92 -1.08,-0.89 -0.78,-0.28 -0.93,-1.13 -1.03,-1.81 -0.6,-0.72 -1.48,0.67 -2.16,-0.06 -0.43,-0.27 -0.83,0.66 -1.04,-0.05 -0.38,-0.93 -1,-1.79 -1.05,-2.83 -0.23,-0.8 -1.28,-0.41 -1.54,0.17 -0.6,0.42 -0.39,-0.56 -0.77,-0.77 -0.47,-0.36 0.54,-0.71 0.23,-1.22 -0.01,-0.77 -0.36,-1.52 -1.22,-1.57 -0.5,-0.11 -0.87,0.27 -1.36,0.18 -0.3,0.22 -0.35,0.72 -0.85,0.62 -0.72,0.31 -1.41,0.62 -2.24,0.57 -0.76,-0.03 -1.25,0.77 -1.8,0.98 0.1,-0.78 -0.91,-0.68 -1.24,-1.2 -0.55,-0.63 -1.66,-1.35 -2.31,-0.46 -0.41,0.06 -0.98,0.21 -0.72,0.76 0.16,0.53 -0.86,-7e-4 -1.1,0.09 -1.2,-0.12 -2.56,-0.68 -3.73,-0.23 -0.21,0.37 -0.13,0.92 -0.72,0.96 -1.16,0.34 -2.34,0.77 -3.45,1.23 -0.79,0.26 -1.54,1.33 -2.45,0.78 -0.77,-0.52 -1.52,0.34 -1.95,0.91 -0.64,0.52 -1.96,0.11 -2.01,-0.73 0.27,-0.33 0.69,-0.9 0.06,-1.11 -0.82,-0.59 -2.06,-0.28 -2.72,-1.07 -0.61,0.05 -0.84,-0.47 -0.88,-0.98 -0.31,-0.48 -1.01,-0.63 -1.03,-1.3 -0.11,-0.53 -1.01,-0.53 -0.71,-1.15 0.14,-0.32 0.36,-1.33 -0.3,-1.02 -0.72,0.35 -1.89,0.46 -2.18,-0.5 -0.21,-0.63 -0.84,-0.32 -1.27,-0.49 -0.67,-0.94 -2.06,-0.22 -2.74,-1.16 -0.86,-0.5 0.44,-1.69 -0.36,-2.1 -0.89,-0.31 -1.55,0.36 -1.89,1.09 -0.33,0.31 -0.71,-0.5 -0.73,-0.8 0.06,-0.62 0.38,-1.78 -0.62,-1.76 -0.65,0.1 -1.17,-0.2 -1.72,-0.43 -0.77,0.14 -1.72,-0.07 -1.85,-0.98 -0.34,-0.39 -0.41,-0.95 -0.77,-1.3 -0.4,-0.07 -0.85,-0.06 -1.02,-0.52 -0.09,-0.07 -0.21,-0.11 -0.32,-0.09 z",
					    "department-58" : "m 11.13,53.77 c -0.8,-0.02 -1.15,0.78 -1.65,1.17 -0.89,0.16 -1.69,1.22 -2.5,0.33 -0.68,-0.54 -1.53,-0.29 -2.07,0.28 -0.77,0.06 -1.75,-0.71 -2.37,0.05 -0.64,0.21 -1.25,0.69 -1.92,0.72 -0.41,-0.27 -0.91,0.16 -0.45,0.51 0.88,1.06 1.83,2.1 2.12,3.48 0.51,1.15 1.43,2.29 1.41,3.58 -0.59,1.03 -0.67,2.26 -1.32,3.28 -0.41,1.08 -1.29,2.12 -1.29,3.3 0.28,1.26 1.86,1.27 2.46,2.3 0.62,0.99 1.91,1.32 2.45,2.33 0.22,1.11 -0.31,2.34 0.46,3.34 0.75,1.62 1.19,3.34 1.47,5.07 0.72,1.45 0.04,3.13 0.1,4.64 0.69,0.91 2.32,1.26 2.2,2.68 0.04,1.33 -0.86,2.73 0.05,3.95 0.53,1.12 -0.67,2.16 -0.87,3.24 -0.24,0.81 0.55,1.5 0.47,2.33 0.19,0.94 0.27,1.93 -0.28,2.76 0.05,0.82 -0.45,1.45 -0.88,2.09 -0.97,2.05 0.89,4.19 2.77,4.81 2.09,0.35 2.46,3.12 4.52,3.53 1.03,-0.13 1.58,-1.32 2.54,-1.69 0.38,-0.33 0.62,-0.83 1.24,-0.66 1.08,-0.27 0.93,1.17 1.57,1.63 0.97,0.87 2.56,0.11 2.84,-1.09 0.32,-0.77 1.41,-0.06 2.09,-0.19 0.86,-0.21 -0.05,0.95 0.68,1.15 0.49,0.16 0.83,0.56 0.58,1.09 -0.18,0.65 -0.11,1.68 0.81,1.57 0.82,0.11 0.86,-0.94 1.48,-1.27 0.43,-0.29 0.83,-1.1 1.37,-1.01 0.24,0.44 1.1,0.63 1.02,-0.1 0.02,-0.66 -0.71,-1.53 -0.25,-2.08 0.45,0.24 0.95,0.31 1.36,-0.03 0.79,0.03 0.25,-1.07 0.07,-1.44 -0.29,-0.5 0.31,-1.22 0.79,-1.27 0.12,0.57 0.69,0.78 1.23,0.71 0.52,0.14 0.69,0.87 1.36,0.77 1.64,0.16 3.3,-1.39 4.84,-0.29 1.26,0.28 1.2,1.68 1.75,2.57 0.49,0.26 1.25,0.09 1.66,-0.31 0.6,-1.18 2.02,-1.34 3.17,-1.64 0.9,-0.2 1.29,-1.1 2.15,-1.35 0.69,-0.75 1.58,-1.44 2.67,-1.42 0.53,0.05 0.91,-0.57 1.35,-0.58 0.26,0.44 1.02,0.53 0.94,-0.15 0.18,-1.08 -0.21,-2.12 -0.66,-3.05 0.56,-0.91 1.97,-0.98 2.49,-1.93 -0.35,-1.2 -1.43,-2.05 -2.47,-2.63 -0.59,-0.73 -0.33,-1.66 -0.16,-2.49 -0.21,-0.58 0.74,-0.96 0.33,-1.58 -0.09,-0.6 -0.67,-1.47 -1.29,-0.83 -0.31,0.58 -1.18,0.3 -1.23,-0.25 0.9,-1.09 2.92,-1.5 2.94,-3.2 -0.15,-0.84 0.95,-1.88 0,-2.51 -0.61,-0.35 -1.15,-1.14 -0.5,-1.72 0.25,-0.57 -0.19,-1.44 0.63,-1.7 0.53,-0.21 1.32,0.25 1.57,-0.46 0.36,0.05 0.82,-0.02 0.76,-0.52 -0,-0.37 -0.05,-0.85 0.47,-0.73 1.28,-0.11 2.69,-0.17 3.84,-0.69 0.3,-0.77 0.08,-1.79 0.82,-2.41 0.63,-1.04 -0.63,-2.04 -1.25,-2.75 -0.44,-0.31 -0.7,-1.41 -1.41,-0.9 -0.57,0.24 -1.3,1.11 -1.62,0.23 -0.52,-1.3 -0.84,-2.76 -0.49,-4.13 -0.15,-0.52 0.58,-0.81 0.24,-1.37 -0.3,-1.1 -1.72,-0.62 -2.56,-0.72 -0.9,-0.04 -1.47,0.74 -1.83,1.42 -0.5,0.54 -1.28,0.46 -1.71,-0.12 -1.23,-0.89 -1.11,-2.54 -1.22,-3.87 -0.23,-0.81 -0.82,-1.02 -1.19,-0.21 -0.66,0.11 -1.5,-0.21 -1.96,0.53 -0.3,0.44 -1.08,0.72 -1.23,0 -0.3,-0.72 -0.6,-1.54 0.32,-1.9 0.62,-0.39 0.83,-1.21 0.11,-1.63 -0.27,-0.35 -1.03,-0.86 -1.15,-0.1 -0.21,0.67 -0.48,1.38 -1.14,1.66 -0.26,0.51 0.45,1.43 -0.5,1.48 -0.52,-0.07 -0.87,-0.68 -1.42,-0.75 -0.23,-0.31 -0.27,-0.93 -0.86,-0.67 -0.8,0.21 -2.02,0.57 -2.44,-0.42 -0.32,-0.89 -1.06,-1.46 -1.86,-1.88 0.15,-0.42 -0.07,-0.88 -0.6,-0.77 -0.79,-0.35 -1.83,-0.31 -2.32,-1.13 -0.49,-0.34 -0.51,0.81 -1.01,0.26 -0.67,-0.6 -0.54,-1.58 -0.6,-2.36 -0.58,-0.37 -1.32,-0.57 -1.75,-1.18 -0.64,-0.45 -1.29,-0.98 -1.19,-1.87 0.13,-0.39 -0.42,-1.25 -0.64,-0.56 -0.24,1.25 0.15,2.68 -0.41,3.84 -1.35,-0.39 -2.77,-1.4 -4.22,-0.8 -0.36,0.51 -0.45,1.33 -1.26,1.31 -0.55,0.09 -0.81,0.7 -1.09,1.01 -0.48,-0.64 -1.05,-1.33 -1.94,-1.44 -0.42,-0.1 -0.66,-0.74 -1.09,-0.18 -0.73,0.25 -1.95,0.84 -2.27,-0.18 -0.53,-0.59 -0.92,-2.08 -1.98,-1.58 -0.57,0.47 -1.1,0.12 -1.45,-0.4 -0.35,-0.41 -0.85,-0.72 -1.32,-0.81 -0.65,-0.83 0.13,-2.32 -0.81,-2.93 -0.19,-0.08 -0.39,-0.13 -0.6,-0.11 z",
					    "department-89" : "m 24.21,0.1 c -0.88,0.14 -0.26,1.7 -1.23,1.54 -1.07,0.08 -2.14,0 -3.14,-0.33 -0.84,-0.04 -1.2,1.3 -2.06,0.71 -0.72,-0.35 -1.5,0.56 -2.13,-0.05 -0.42,0.01 -0.79,-0.62 -1.29,-0.25 -0.68,0.52 -1.81,-0.19 -2.26,0.7 -0.21,0.41 -0.56,1.07 -0.93,0.41 -0.83,-0.39 -2.57,-0.35 -2.47,0.92 0.46,1.08 -1.34,1.7 -0.68,2.76 0.05,0.73 0.04,1.59 0.85,1.87 0.18,0.42 0.29,1.16 0.02,1.49 -1.07,0.2 -1.11,1.69 -1.72,2.41 -0.25,0.77 -1.67,0.03 -1.59,1.07 -0.51,0.42 -1.48,0.46 -1.59,1.31 -0.2,0.48 0.2,0.88 0.59,0.76 0.39,0.5 0.91,0.91 1.61,0.8 0.38,0.13 0.57,0.64 1.07,0.54 0.68,0.17 0.93,0.92 0.8,1.54 0.38,0.38 0.65,0.88 0.77,1.45 0.5,0.53 0.27,1.28 0.58,1.88 0.52,0.7 1.92,0.65 1.87,1.72 0.13,0.53 1.22,0.51 1.12,1.02 -0.57,0.38 -0.96,0.8 -0.2,1.24 0.39,0.78 0.65,1.76 0.51,2.62 -0.77,0.54 -0.8,1.7 -1.78,2.01 -0.8,0.49 -1.42,1.22 -1.93,1.96 -0.8,0.24 -1.79,0.7 -1.62,1.73 0.18,0.45 -0.19,0.75 -0.24,1.1 0.44,0.42 1.31,0.47 1.25,1.32 0.26,0.75 -1.18,1.05 -0.6,1.87 0.23,0.63 0.51,1.51 0.16,2.1 -1.32,0.12 -2.59,0.59 -3.6,1.45 -1.09,0.31 -2.3,-0.07 -3.41,0.27 -0.99,0.01 -0.47,1.37 -0.76,2.02 -0.29,0.43 -0.01,1.55 0.62,1.13 0.29,-0.48 1.01,-0.1 0.72,0.41 0.3,0.88 1.6,1.02 1.84,1.88 -0.26,0.61 0.02,1.23 0.66,1.41 0.41,0.31 1.05,1.02 0.26,1.32 -0.84,0.76 0.18,1.76 -0.04,2.65 0.28,0.49 0.85,0.76 1.11,1.29 0.8,0.54 1.79,1.36 2.81,1.16 0.65,-0.41 1.49,-0.39 1.91,-1.15 0.59,-0.61 1.99,-0.78 2.36,0.11 -0.06,0.77 -0.3,2 0.49,2.45 0.85,0.27 1.4,1.75 2.42,1.15 1.21,-0.45 1.5,1.17 2.17,1.8 0.74,0.85 1.81,-0.15 2.52,-0.4 0.37,0.7 1.34,0.56 1.89,1.11 0.34,0.42 0.86,0.58 1.29,0.14 0.59,-0.39 1.49,-0.5 1.55,-1.4 -0.04,-0.56 0.92,-0.14 1.24,-0.3 0.68,-0.02 1.44,-0.12 1.93,0.43 0.45,0.3 1.52,0.62 1.39,-0.3 0.16,-1.17 -0.18,-2.46 0.15,-3.58 0.75,0.05 0.93,1.14 0.93,1.77 0.2,0.82 1.19,1.04 1.65,1.71 0.37,0.52 1.49,0.37 1.32,1.21 0.08,0.52 -0.19,1.93 0.68,1.8 0.45,-0.51 1.07,-0.11 1.36,0.32 0.74,0.52 1.94,0.12 2.5,0.82 -0.24,0.92 1.08,0.97 1.35,1.7 0.28,0.74 0.94,1.68 1.88,1.28 0.48,0 1.31,-0.55 1.67,-0.11 -0.05,0.54 0.38,0.84 0.86,0.9 0.23,0.42 0.99,0.67 0.96,-0.05 -0.04,-0.47 -0.1,-1.03 0.46,-1.17 0.53,-0.44 0.62,-1.18 0.72,-1.79 0.96,-0.31 2.5,0.97 1.67,1.91 -0.66,0.44 -1.26,1.19 -0.79,2.01 0.33,0.89 1.27,0.17 1.63,-0.28 0.64,-0.32 1.61,0 1.96,-0.83 0.45,-0.08 0.79,0.69 1.01,1.06 -0.3,1.27 0.05,2.84 1.05,3.75 0.51,0.52 1.45,0.45 1.65,-0.31 0.48,-0.87 1.37,-1.34 2.36,-1.14 0.39,0.05 1.52,-0.07 1.05,-0.68 -0.54,-0.33 0.34,-1.43 -0.58,-1.52 -0.69,0.09 -0.55,-0.43 -0.49,-0.88 0.12,-0.74 -1.28,-1.15 -0.41,-1.68 0.62,-0.41 0.41,-1.12 0.49,-1.69 0.24,-0.24 0.66,0.47 0.88,-0.03 0.2,-0.59 0.98,-0.53 0.99,-1.25 0.23,-0.55 0.17,-1.17 -0.32,-1.49 0.11,-0.55 0.04,-1.08 -0.17,-1.58 0.01,-0.99 1.39,-0.96 1.5,-1.95 0.03,-0.76 0.67,-1.32 1.33,-1.55 0.84,-0.83 0.25,-2.44 1.37,-3.06 0.86,-0.43 -0.01,-1.74 0.83,-2.21 0.42,-0.66 1.58,-1.6 0.4,-2.11 -0.44,-0.27 -0.19,-0.84 0.3,-0.75 0.39,-0.17 1.59,-0.29 1.25,-0.88 -0.37,-0.09 -0.03,-0.74 -0.37,-0.98 -0.05,-0.56 -1.05,-0.32 -0.73,-0.94 0.23,-0.38 0.89,-0.37 0.76,-0.99 0.38,-0.73 1.48,0.55 1.91,-0.31 0.21,-0.48 0.6,-0.78 1.08,-0.87 0.59,-0.72 0.07,-1.75 0.44,-2.5 0.45,-0.67 -0.76,-1.06 -0.47,-1.8 -0.02,-0.57 0.42,-1.96 -0.63,-1.78 -0.66,-0.07 -1.49,0.73 -2.06,0.24 -0.24,-0.69 0.25,-1.89 -0.62,-2.11 0.53,-0.83 1.25,-1.85 2.35,-1.84 0.66,-0.5 -0.23,-1.71 -0.98,-1.4 -1.36,0.06 -2.87,-1.22 -2.52,-2.66 -0.07,-0.63 -1.26,-0.58 -0.96,0.16 0.42,0.56 0.1,1.47 -0.63,1.44 -0.49,-0.19 -0.31,-1.36 -1.06,-1.09 -0.89,0.3 -0.99,1.39 -1.89,1.63 -0.51,0.35 -1.52,0.52 -1.57,-0.34 -0.22,-0.6 -1.38,-0.74 -1.45,0.07 -0.1,0.54 -0.61,0.71 -1.04,0.44 -0.57,0.08 -1.12,-0.09 -1.33,-0.7 -0.54,-0.17 -0.87,1.03 -1.52,0.57 -1.13,-0.37 -2.25,0.17 -3.34,0.31 -0.76,-0.14 0.09,-0.92 0.05,-1.37 0.37,-1.09 0.68,-2.57 -0.44,-3.35 -0.85,-0.11 -0.14,1.24 -0.94,1.3 -0.48,0.36 -0.53,-0.36 -0.94,-0.4 -0.18,-0.34 -0.73,-1.05 -0.37,-1.36 0.48,0.07 1.43,-0.23 0.93,-0.86 -0.42,-0.74 -1.35,-1 -1.78,-1.67 0.21,-1.06 -0.35,-2.12 -1.16,-2.76 0.12,-0.82 0.15,-1.71 -0.62,-2.25 -0.35,-0.56 -0.99,-0.92 -1.55,-0.48 -0.68,-0.23 -0.68,-1.02 -0.23,-1.47 0.48,-0.71 -0.58,-1.92 -1.2,-1.29 0.18,0.72 -0.42,1.65 -1.23,1.53 -0.41,0.02 -1.48,0.72 -1.39,-0.14 -0.4,-0.98 -0.77,-2.2 -1.68,-2.79 -0.77,-0.17 -1.41,1.25 -2.06,0.34 -0.56,-0.4 0.48,-0.88 0.63,-1.24 0.39,-0.4 1.46,-1.39 0.56,-1.8 -0.74,-0.14 0.1,-1 0.32,-1.25 0.87,-0.84 -0.32,-1.85 -1.14,-2.09 -0.81,-0.18 0.11,-1.16 -0.61,-1.5 -0.67,-0.25 -0.65,-1.16 -1.42,-1.2 -0.27,-0.64 -0.51,-1.42 -1.08,-1.94 -0.52,-0.76 -1.28,-1.36 -2.24,-1.3 -0.66,-0.61 -1.34,0.37 -1.93,0.61 -0.74,-0.35 -0.74,-1.28 -1.16,-1.85 -0.33,-0.28 -0.77,-0.53 -1.21,-0.51 z",
					    "department-21" : "m 80.38,24.4 c -1.23,0.11 -2.43,0.99 -2.95,2.08 0.12,0.61 0.92,0.85 0.83,1.59 0.13,0.61 -0.89,0.34 -1.23,0.43 -1.33,-0.1 -2.61,0.25 -3.82,0.77 -0.91,-0.61 -2.02,-0.85 -3.05,-0.37 -1,0.33 -2.03,0.28 -3.04,0.09 -0.77,0.35 -0.47,1.45 -0.82,2.07 0.28,0.48 0.64,1.1 0.42,1.68 -0.87,0.27 -2.21,0.77 -2.18,1.86 0.54,0.56 -0.13,1.8 0.69,2.07 0.72,-0.09 1.61,-0.45 2.29,-0.22 0.2,1.06 -0.36,2.41 0.69,3.15 -0.36,0.91 -0.25,2 -0.54,2.93 -0.27,0.43 -0.98,0.24 -1.17,0.84 -0.19,0.32 -0.46,0.97 -0.86,0.45 -0.42,-0.49 -1.19,-0.31 -1.13,0.38 -0.22,0.28 -0.82,0.54 -0.37,0.95 0.5,0.39 0.67,0.94 0.87,1.48 0.19,0.17 1,0.83 0.28,0.8 -0.45,-0.12 -0.95,-0.14 -1.23,0.22 -0.96,-0.14 -1.34,0.37 -0.32,0.89 0.54,0.45 -0.31,1.18 -0.57,1.61 -0.59,0.72 -0.46,1.79 -0.82,2.53 -1.07,0.17 -0.98,1.48 -1.22,2.29 -0.18,0.61 -0.58,1.05 -1.16,1.23 -0.48,0.25 -0.33,0.82 -0.5,1.16 -0.3,0.46 -0.56,0.96 -1.16,1.04 -0.51,0.65 -0.23,1.69 0.02,2.41 0.59,0.76 -0.04,1.87 -0.51,2.56 -0.28,0.43 -0.76,0.47 -1.14,0.63 -0.05,0.69 -0.55,1.19 -0.98,1.67 0.43,0.38 1.1,0.78 0.75,1.46 -0.09,0.75 0.89,0.27 1.14,0.57 -0.19,0.79 -0.28,1.7 0.4,2.3 0.3,-0.2 0.68,-1.45 1.24,-1 -0.31,0.76 -1.06,1.46 -0.6,2.34 -0.21,0.35 0.01,0.7 0.03,1.01 -0.76,0.57 -0.65,1.54 -0.42,2.37 0.12,0.61 0.18,2.11 1.2,1.67 0.69,-0.27 1.44,-1.03 1.83,-0.02 0.72,0.95 2.06,1.87 1.93,3.18 -0.75,0.79 -1.32,2.38 -0.32,3.17 0.39,0.16 1.13,-0.22 0.99,0.5 0.34,0.9 0.98,2.45 2.21,1.87 0.63,0.16 1.2,0.64 1.92,0.59 0.83,-0.04 0.7,0.88 0.59,1.43 -0.23,0.52 0.41,1.48 0.75,0.7 0.25,-0.99 1.79,-1.1 2.31,-0.39 -0.39,0.61 -0.68,1.59 0.12,2.03 0.68,0.57 1.71,0.16 2.33,0.8 0.56,0.15 1.29,0.07 1.5,0.77 0.52,0.86 1.61,0.53 2.32,0.17 0.5,0.35 -0.37,1.64 0.56,1.79 0.31,0.34 0.08,1.02 0.65,1.23 0.65,0.17 0.52,0.84 0.76,1.29 0.47,0.26 0.93,0.48 1.39,0.77 0.84,0.12 1.96,0.2 2.43,1 -0.16,0.44 -0.8,0.86 -0.15,1.28 0.72,0.78 1.84,0.1 2.05,-0.77 0.91,-0.75 2.2,0.61 3.03,-0.31 0.1,-0.34 0.28,-0.68 0.7,-0.51 1.23,-0.37 2.44,-0.85 3.66,-1.28 0.46,-0.29 0.46,-1.1 1.17,-1.04 1.26,-0.16 2.5,0.33 3.73,0.38 0.79,-0.64 1.75,-1.4 2.83,-1.31 0.76,0.6 1.4,1.76 2.58,1.4 1.24,-0.13 2.49,-0.43 3.6,-0.93 0.49,-0.06 0.59,-0.71 1.15,-0.57 0.37,-0.01 0.44,-0.56 0.85,-0.24 0.79,0.47 1.81,0.22 2.05,-0.71 0.47,-0.36 1.48,-0.43 1.37,-1.23 -0.29,-0.56 -1.63,-0.24 -1.27,-1.1 0.21,-1.14 1.17,-1.89 2.04,-2.53 0.9,-1.06 2.85,-0.01 3.4,-1.57 0.22,-0.87 0.55,-1.76 0.93,-2.54 0.46,-0.39 1.08,-0.66 1.13,-1.35 0.54,-0.98 1.15,-2.21 0.28,-3.17 0.53,-0.52 1.71,-0.88 1.31,-1.87 0.44,-1.2 0.19,-2.63 0.73,-3.8 0.4,-0.19 0.99,-0.34 1.03,-0.94 0,-1.03 -1.45,-0.52 -1.88,-1.15 -0.14,-0.68 1.03,-0.81 0.83,-1.58 -0.04,-1.06 0.21,-2.26 -0.21,-3.23 -0.72,-0.23 -1.41,0.92 -2.05,0.15 -0.63,-0.83 -0.23,-2.08 -0.42,-3.06 0.08,-0.73 -0.61,-1.08 -1.11,-1.45 -0.53,-0.13 -1.26,0.96 -1.43,0.01 -0.26,-0.35 -0.26,-0.75 0.26,-0.68 0.53,-0.09 0.65,-0.63 0.29,-0.97 0.08,-0.51 0.35,-1.39 1.06,-1.09 0.59,0.07 1.4,0.51 1.75,-0.25 0.48,-0.45 0.56,-1.29 1.05,-1.67 1.13,-0.22 1.22,-1.71 0.61,-2.48 -0.25,-1.08 0.05,-2.4 -1.02,-3.11 -0.5,-0.34 -0.92,-1.29 -1.57,-1.15 -0.69,0.65 -0.84,1.98 -1.79,2.3 -0.36,-0.17 -0.71,-0.91 -1.1,-0.28 -0.27,0.72 -1.32,0.4 -1.18,-0.33 -0.57,-0.92 -1.69,0.09 -2.19,0.58 -0.49,0.45 -0.65,1.14 -1.4,1.23 -0.66,0.21 -0.72,-0.94 -0.96,-1.32 -0.06,-0.46 0.65,-1.3 -0.17,-1.36 -0.6,-1.04 -1.64,-1.95 -2.87,-2.26 -0.1,-0.52 0.27,-1.42 -0.11,-1.78 -0.64,0.1 -0.86,1.07 -1.41,1.42 -0.34,0.67 -1.15,0.69 -1.68,0.26 -0.78,-0.55 -1.95,-0.61 -2.55,-1.41 0.11,-0.66 -0.04,-1.31 -0.75,-1.43 -0.21,-0.38 -0.29,-1.22 -0.78,-0.5 -0.49,0.63 -1.6,1.57 -2.33,0.72 -0.56,-0.41 -0.61,-1.09 -0.18,-1.59 0.32,-0.51 0.18,-1.03 0.02,-1.53 0.15,-0.65 -0.19,-1.88 -1.08,-1.46 -0.85,0.57 -1.21,-1.1 -0.38,-1.29 0.95,-0.64 2.48,-1.03 2.8,-2.26 -0.33,-0.96 -1.71,-1.43 -1.49,-2.63 -0.06,-0.92 -1.58,-0.58 -1.4,-1.61 -0.24,-0.88 -0.81,-1.64 -1.18,-2.49 -0.84,-0.66 -1.62,0.47 -1.93,1.15 -0.32,0.64 -0.91,-0.33 -1.22,-0.53 -0.63,-0.59 0.63,-0.95 0.81,-1.41 0.72,-0.7 0.32,-1.9 -0.66,-2.04 -0.78,-0.15 -1.84,0.22 -2.35,-0.59 0.09,-0.72 1.06,-1.48 0.21,-2.12 -0.74,-0.67 -1.88,0.1 -2.74,-0.39 -0.76,-0.05 -1.05,-1.26 -1.87,-0.82 -0.96,0.69 -1.84,-0.53 -2.87,-0.36 -0.44,0.04 -0.47,-0.46 -0.96,-0.31 z"
					}
				}
			}
		}
	);
})(jQuery);