/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;

public class Sample {
    private final RrdDb parentDb;
    private long time;
    private final String[] dsNames;
    private final double[] values;

    Sample(RrdDb parentDb, long time) throws IOException {
        this.parentDb = parentDb;
        this.time = time;
        this.dsNames = parentDb.getDsNames();
        this.values = new double[this.dsNames.length];
        this.clearValues();
    }

    private void clearValues() {
        Arrays.fill(this.values, Double.NaN);
    }

    public Sample setValue(String dsName, double value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.dsNames[i].equals(dsName)) continue;
            this.values[i] = value;
            return this;
        }
        throw new IllegalArgumentException("Datasource " + dsName + " not found");
    }

    public Sample setValue(int i, double value) {
        if (i < this.values.length) {
            this.values[i] = value;
            return this;
        }
        throw new IllegalArgumentException("Sample datasource index " + i + " out of bounds");
    }

    public Sample setValues(double ... values) {
        if (values.length <= this.values.length) {
            System.arraycopy(values, 0, this.values, 0, values.length);
            return this;
        }
        throw new IllegalArgumentException("Invalid number of values specified (found " + values.length + ", only " + this.dsNames.length + " allowed)");
    }

    public double[] getValues() {
        return this.values;
    }

    public long getTime() {
        return this.time;
    }

    public Sample setTime(long time) {
        this.time = time;
        return this;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public Sample set(String timeAndValues) {
        StringTokenizer tokenizer = new StringTokenizer(timeAndValues, ":", false);
        int n = tokenizer.countTokens();
        if (n > this.values.length + 1) {
            throw new IllegalArgumentException("Invalid number of values specified (found " + this.values.length + ", " + this.dsNames.length + " allowed)");
        }
        String timeToken = tokenizer.nextToken();
        try {
            this.time = Long.parseLong(timeToken);
        }
        catch (NumberFormatException nfe) {
            if ("N".equalsIgnoreCase(timeToken) || "NOW".equalsIgnoreCase(timeToken)) {
                this.time = Util.getTime();
            }
            throw new IllegalArgumentException("Invalid sample timestamp: " + timeToken);
        }
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            try {
                this.values[i] = Double.parseDouble(tokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return this;
    }

    public void update() throws IOException {
        this.parentDb.store(this);
        this.clearValues();
    }

    public void setAndUpdate(String timeAndValues) throws IOException {
        this.set(timeAndValues);
        this.update();
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder("update \"");
        buffer.append(this.parentDb.getRrdBackend().getPath()).append("\" ").append(this.time);
        for (double value : this.values) {
            buffer.append(':');
            buffer.append(Util.formatDouble(value, "U", false));
        }
        return buffer.toString();
    }

    String getRrdToolCommand() {
        return this.dump();
    }
}

