/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Lines;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java2d.AnimatingSurface;

public class LineAnim
extends AnimatingSurface {
    private static int[] caps = new int[]{0, 2, 1};
    private static int[] joins = new int[]{0, 2, 1};
    private static Color[] colors = new Color[]{Color.GRAY, Color.PINK, Color.LIGHT_GRAY};
    private static BasicStroke bs1 = new BasicStroke(1.0f);
    private static final int CLOCKWISE = 0;
    private Line2D[] lines = new Line2D[3];
    private int[] rAmt = new int[this.lines.length];
    private int[] direction = new int[this.lines.length];
    private int[] speed = new int[this.lines.length];
    private BasicStroke[] strokes = new BasicStroke[this.lines.length];
    private GeneralPath path;
    private Point2D[] pts;
    private float size;
    private Ellipse2D ellipse = new Ellipse2D.Double();

    public LineAnim() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void reset(int w, int h) {
        this.size = w > h ? (float)h / 6.0f : (float)w / 6.0f;
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new Line2D.Float(0.0f, 0.0f, this.size, 0.0f);
            this.strokes[i] = new BasicStroke(this.size / 3.0f, caps[i], joins[i]);
            this.rAmt[i] = i * 360 / this.lines.length;
            this.direction[i] = i % 2;
            this.speed[i] = i + 1;
        }
        this.path = new GeneralPath();
        this.path.moveTo(this.size, -this.size / 2.0f);
        this.path.lineTo(this.size + this.size / 2.0f, 0.0f);
        this.path.lineTo(this.size, this.size / 2.0f);
        this.ellipse.setFrame((float)(w / 2) - this.size * 2.0f - 4.5f, (float)(h / 2) - this.size * 2.0f - 4.5f, this.size * 4.0f, this.size * 4.0f);
        PathIterator pi = this.ellipse.getPathIterator(null, 0.9);
        Point2D[] points = new Point2D[100];
        int num_pts = 0;
        while (!pi.isDone()) {
            float[] pt = new float[6];
            switch (pi.currentSegment(pt)) {
                case 0: 
                case 1: {
                    points[num_pts] = new Point2D.Float(pt[0], pt[1]);
                    ++num_pts;
                }
            }
            pi.next();
        }
        this.pts = new Point2D[num_pts];
        System.arraycopy(points, 0, this.pts, 0, num_pts);
    }

    @Override
    public void step(int w, int h) {
        for (int i = 0; i < this.lines.length; ++i) {
            if (this.direction[i] == 0) {
                int n = i;
                this.rAmt[n] = this.rAmt[n] + this.speed[i];
                if (this.rAmt[i] != 360) continue;
                this.rAmt[i] = 0;
                continue;
            }
            int n = i;
            this.rAmt[n] = this.rAmt[n] - this.speed[i];
            if (this.rAmt[i] != 0) continue;
            this.rAmt[i] = 360;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        int i;
        this.ellipse.setFrame((float)(w / 2) - this.size, (float)(h / 2) - this.size, this.size * 2.0f, this.size * 2.0f);
        g2.setColor(Color.BLACK);
        g2.draw(this.ellipse);
        for (i = 0; i < this.lines.length; ++i) {
            AffineTransform at = AffineTransform.getTranslateInstance(w / 2, h / 2);
            at.rotate(Math.toRadians(this.rAmt[i]));
            g2.setStroke(this.strokes[i]);
            g2.setColor(colors[i]);
            g2.draw(at.createTransformedShape(this.lines[i]));
            g2.draw(at.createTransformedShape(this.path));
            int j = (int)((double)this.rAmt[i] / 360.0 * (double)this.pts.length);
            j = j == this.pts.length ? this.pts.length - 1 : j;
            this.ellipse.setFrame(this.pts[j].getX(), this.pts[j].getY(), 9.0, 9.0);
            g2.fill(this.ellipse);
        }
        g2.setStroke(bs1);
        g2.setColor(Color.BLACK);
        for (i = 0; i < this.pts.length; ++i) {
            this.ellipse.setFrame(this.pts[i].getX(), this.pts[i].getY(), 9.0, 9.0);
            g2.draw(this.ellipse);
        }
    }

    public static void main(String[] argv) {
        LineAnim.createDemoFrame(new LineAnim());
    }
}

