/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-alpha.

Abstract: This is an autogenerated C++ Implementation file for the Node wrapper class 
 of the 3MF Library

Interface version: 2.4.1

*/


#include <node.h>
#include "lib3mf_nodewrapper.h"


using namespace v8;

Persistent<Function> CLib3MFWrapper::constructor;
Persistent<Function> CLib3MFBase::constructor;
Persistent<Function> CLib3MFWriter::constructor;
Persistent<Function> CLib3MFReader::constructor;
Persistent<Function> CLib3MFPackagePart::constructor;
Persistent<Function> CLib3MFResource::constructor;
Persistent<Function> CLib3MFResourceIterator::constructor;
Persistent<Function> CLib3MFSliceStackIterator::constructor;
Persistent<Function> CLib3MFObjectIterator::constructor;
Persistent<Function> CLib3MFMeshObjectIterator::constructor;
Persistent<Function> CLib3MFComponentsObjectIterator::constructor;
Persistent<Function> CLib3MFTexture2DIterator::constructor;
Persistent<Function> CLib3MFBaseMaterialGroupIterator::constructor;
Persistent<Function> CLib3MFColorGroupIterator::constructor;
Persistent<Function> CLib3MFTexture2DGroupIterator::constructor;
Persistent<Function> CLib3MFCompositeMaterialsIterator::constructor;
Persistent<Function> CLib3MFMultiPropertyGroupIterator::constructor;
Persistent<Function> CLib3MFImage3DIterator::constructor;
Persistent<Function> CLib3MFFunctionIterator::constructor;
Persistent<Function> CLib3MFLevelSetIterator::constructor;
Persistent<Function> CLib3MFMetaData::constructor;
Persistent<Function> CLib3MFMetaDataGroup::constructor;
Persistent<Function> CLib3MFTriangleSet::constructor;
Persistent<Function> CLib3MFObject::constructor;
Persistent<Function> CLib3MFMeshObject::constructor;
Persistent<Function> CLib3MFLevelSet::constructor;
Persistent<Function> CLib3MFBeamLattice::constructor;
Persistent<Function> CLib3MFFunctionReference::constructor;
Persistent<Function> CLib3MFVolumeDataColor::constructor;
Persistent<Function> CLib3MFMaterialMapping::constructor;
Persistent<Function> CLib3MFVolumeDataComposite::constructor;
Persistent<Function> CLib3MFVolumeDataProperty::constructor;
Persistent<Function> CLib3MFVolumeData::constructor;
Persistent<Function> CLib3MFComponent::constructor;
Persistent<Function> CLib3MFComponentsObject::constructor;
Persistent<Function> CLib3MFBeamSet::constructor;
Persistent<Function> CLib3MFBaseMaterialGroup::constructor;
Persistent<Function> CLib3MFColorGroup::constructor;
Persistent<Function> CLib3MFTexture2DGroup::constructor;
Persistent<Function> CLib3MFCompositeMaterials::constructor;
Persistent<Function> CLib3MFMultiPropertyGroup::constructor;
Persistent<Function> CLib3MFImage3D::constructor;
Persistent<Function> CLib3MFImageStack::constructor;
Persistent<Function> CLib3MFAttachment::constructor;
Persistent<Function> CLib3MFTexture2D::constructor;
Persistent<Function> CLib3MFImplicitPort::constructor;
Persistent<Function> CLib3MFIterator::constructor;
Persistent<Function> CLib3MFImplicitPortIterator::constructor;
Persistent<Function> CLib3MFImplicitNode::constructor;
Persistent<Function> CLib3MFOneInputNode::constructor;
Persistent<Function> CLib3MFSinNode::constructor;
Persistent<Function> CLib3MFCosNode::constructor;
Persistent<Function> CLib3MFTanNode::constructor;
Persistent<Function> CLib3MFArcSinNode::constructor;
Persistent<Function> CLib3MFArcCosNode::constructor;
Persistent<Function> CLib3MFArcTanNode::constructor;
Persistent<Function> CLib3MFSinhNode::constructor;
Persistent<Function> CLib3MFCoshNode::constructor;
Persistent<Function> CLib3MFTanhNode::constructor;
Persistent<Function> CLib3MFRoundNode::constructor;
Persistent<Function> CLib3MFCeilNode::constructor;
Persistent<Function> CLib3MFFloorNode::constructor;
Persistent<Function> CLib3MFSignNode::constructor;
Persistent<Function> CLib3MFFractNode::constructor;
Persistent<Function> CLib3MFAbsNode::constructor;
Persistent<Function> CLib3MFExpNode::constructor;
Persistent<Function> CLib3MFLogNode::constructor;
Persistent<Function> CLib3MFLog2Node::constructor;
Persistent<Function> CLib3MFLog10Node::constructor;
Persistent<Function> CLib3MFLengthNode::constructor;
Persistent<Function> CLib3MFTransposeNode::constructor;
Persistent<Function> CLib3MFInverseNode::constructor;
Persistent<Function> CLib3MFSqrtNode::constructor;
Persistent<Function> CLib3MFResourceIdNode::constructor;
Persistent<Function> CLib3MFTwoInputNode::constructor;
Persistent<Function> CLib3MFAdditionNode::constructor;
Persistent<Function> CLib3MFSubtractionNode::constructor;
Persistent<Function> CLib3MFMultiplicationNode::constructor;
Persistent<Function> CLib3MFDivisionNode::constructor;
Persistent<Function> CLib3MFDotNode::constructor;
Persistent<Function> CLib3MFCrossNode::constructor;
Persistent<Function> CLib3MFArcTan2Node::constructor;
Persistent<Function> CLib3MFMatVecMultiplicationNode::constructor;
Persistent<Function> CLib3MFMinNode::constructor;
Persistent<Function> CLib3MFMaxNode::constructor;
Persistent<Function> CLib3MFFmodNode::constructor;
Persistent<Function> CLib3MFModNode::constructor;
Persistent<Function> CLib3MFPowNode::constructor;
Persistent<Function> CLib3MFSelectNode::constructor;
Persistent<Function> CLib3MFClampNode::constructor;
Persistent<Function> CLib3MFComposeVectorNode::constructor;
Persistent<Function> CLib3MFVectorFromScalarNode::constructor;
Persistent<Function> CLib3MFDecomposeVectorNode::constructor;
Persistent<Function> CLib3MFComposeMatrixNode::constructor;
Persistent<Function> CLib3MFMatrixFromRowsNode::constructor;
Persistent<Function> CLib3MFMatrixFromColumnsNode::constructor;
Persistent<Function> CLib3MFConstantNode::constructor;
Persistent<Function> CLib3MFConstVecNode::constructor;
Persistent<Function> CLib3MFConstMatNode::constructor;
Persistent<Function> CLib3MFMeshNode::constructor;
Persistent<Function> CLib3MFUnsignedMeshNode::constructor;
Persistent<Function> CLib3MFFunctionCallNode::constructor;
Persistent<Function> CLib3MFNodeIterator::constructor;
Persistent<Function> CLib3MFFunction::constructor;
Persistent<Function> CLib3MFImplicitFunction::constructor;
Persistent<Function> CLib3MFFunctionFromImage3D::constructor;
Persistent<Function> CLib3MFBuildItem::constructor;
Persistent<Function> CLib3MFBuildItemIterator::constructor;
Persistent<Function> CLib3MFSlice::constructor;
Persistent<Function> CLib3MFSliceStack::constructor;
Persistent<Function> CLib3MFConsumer::constructor;
Persistent<Function> CLib3MFAccessRight::constructor;
Persistent<Function> CLib3MFContentEncryptionParams::constructor;
Persistent<Function> CLib3MFResourceData::constructor;
Persistent<Function> CLib3MFResourceDataGroup::constructor;
Persistent<Function> CLib3MFKeyStore::constructor;
Persistent<Function> CLib3MFModel::constructor;

/*************************************************************************************************************************
 Class sLib3MFTriangle Conversion
**************************************************************************************************************************/
sLib3MFTriangle convertObjectToLib3MFTriangle(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTriangle sTriangle;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sTriangle.m_Indices[rowIndex] = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Indices Member
			MaybeLocal<Value> maybeValIndices = obj->Get(context, String::NewFromUtf8(isolate, "Indices"));
			if (!maybeValIndices.IsEmpty()) {
				Local<Value> valIndices = maybeValIndices.ToLocalChecked();
				if (valIndices->IsArray()) {
					Local<Array> arrayIndices = Local<Array>::Cast(valIndices);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayIndices->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sTriangle.m_Indices[rowIndex] = localNumber.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTriangle;
}



Local<Object> convertLib3MFTriangleToObject(Isolate* isolate, sLib3MFTriangle sTriangle)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newIndices = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newIndices->Set(rowIndex, Integer::NewFromUnsigned(isolate, sTriangle.m_Indices[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Indices"), newIndices);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFTriangleProperties Conversion
**************************************************************************************************************************/
sLib3MFTriangleProperties convertObjectToLib3MFTriangleProperties(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTriangleProperties sTriangleProperties;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	sTriangleProperties.m_ResourceID = 0;
	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sTriangleProperties.m_PropertyIDs[rowIndex] = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// ResourceID Member
			MaybeLocal<Value> maybeValResourceID = obj->Get(context, String::NewFromUtf8(isolate, "ResourceID"));
			if (!maybeValResourceID.IsEmpty()) {
				Local<Value> valResourceID = maybeValResourceID.ToLocalChecked();
				if (valResourceID->IsNumber()) {
					MaybeLocal<Number> localValResourceID = valResourceID->ToNumber(context);
					sTriangleProperties.m_ResourceID = localValResourceID.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member not found in object" )));
			}

			// PropertyIDs Member
			MaybeLocal<Value> maybeValPropertyIDs = obj->Get(context, String::NewFromUtf8(isolate, "PropertyIDs"));
			if (!maybeValPropertyIDs.IsEmpty()) {
				Local<Value> valPropertyIDs = maybeValPropertyIDs.ToLocalChecked();
				if (valPropertyIDs->IsArray()) {
					Local<Array> arrayPropertyIDs = Local<Array>::Cast(valPropertyIDs);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayPropertyIDs->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sTriangleProperties.m_PropertyIDs[rowIndex] = localNumber.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyIDs member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTriangleProperties;
}



Local<Object> convertLib3MFTrianglePropertiesToObject(Isolate* isolate, sLib3MFTriangleProperties sTriangleProperties)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "ResourceID"), Integer::NewFromUnsigned (isolate, sTriangleProperties.m_ResourceID));
	Local<Array> newPropertyIDs = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newPropertyIDs->Set(rowIndex, Integer::NewFromUnsigned(isolate, sTriangleProperties.m_PropertyIDs[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "PropertyIDs"), newPropertyIDs);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFPosition Conversion
**************************************************************************************************************************/
sLib3MFPosition convertObjectToLib3MFPosition(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFPosition sPosition;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sPosition.m_Coordinates[rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Coordinates Member
			MaybeLocal<Value> maybeValCoordinates = obj->Get(context, String::NewFromUtf8(isolate, "Coordinates"));
			if (!maybeValCoordinates.IsEmpty()) {
				Local<Value> valCoordinates = maybeValCoordinates.ToLocalChecked();
				if (valCoordinates->IsArray()) {
					Local<Array> arrayCoordinates = Local<Array>::Cast(valCoordinates);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCoordinates->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sPosition.m_Coordinates[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sPosition;
}



Local<Object> convertLib3MFPositionToObject(Isolate* isolate, sLib3MFPosition sPosition)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newCoordinates = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newCoordinates->Set(rowIndex, Number::New(isolate, (double) sPosition.m_Coordinates[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Coordinates"), newCoordinates);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFPosition2D Conversion
**************************************************************************************************************************/
sLib3MFPosition2D convertObjectToLib3MFPosition2D(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFPosition2D sPosition2D;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sPosition2D.m_Coordinates[rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Coordinates Member
			MaybeLocal<Value> maybeValCoordinates = obj->Get(context, String::NewFromUtf8(isolate, "Coordinates"));
			if (!maybeValCoordinates.IsEmpty()) {
				Local<Value> valCoordinates = maybeValCoordinates.ToLocalChecked();
				if (valCoordinates->IsArray()) {
					Local<Array> arrayCoordinates = Local<Array>::Cast(valCoordinates);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCoordinates->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sPosition2D.m_Coordinates[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sPosition2D;
}



Local<Object> convertLib3MFPosition2DToObject(Isolate* isolate, sLib3MFPosition2D sPosition2D)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newCoordinates = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newCoordinates->Set(rowIndex, Number::New(isolate, (double) sPosition2D.m_Coordinates[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Coordinates"), newCoordinates);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFCompositeConstituent Conversion
**************************************************************************************************************************/
sLib3MFCompositeConstituent convertObjectToLib3MFCompositeConstituent(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFCompositeConstituent sCompositeConstituent;
	Local<Context> context = isolate->GetCurrentContext();

	sCompositeConstituent.m_PropertyID = 0;
	sCompositeConstituent.m_MixingRatio = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// PropertyID Member
			MaybeLocal<Value> maybeValPropertyID = obj->Get(context, String::NewFromUtf8(isolate, "PropertyID"));
			if (!maybeValPropertyID.IsEmpty()) {
				Local<Value> valPropertyID = maybeValPropertyID.ToLocalChecked();
				if (valPropertyID->IsNumber()) {
					MaybeLocal<Number> localValPropertyID = valPropertyID->ToNumber(context);
					sCompositeConstituent.m_PropertyID = localValPropertyID.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyID member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "PropertyID member not found in object" )));
			}

			// MixingRatio Member
			MaybeLocal<Value> maybeValMixingRatio = obj->Get(context, String::NewFromUtf8(isolate, "MixingRatio"));
			if (!maybeValMixingRatio.IsEmpty()) {
				Local<Value> valMixingRatio = maybeValMixingRatio.ToLocalChecked();
				if (valMixingRatio->IsNumber()) {
					MaybeLocal<Number> localValMixingRatio = valMixingRatio->ToNumber(context);
					sCompositeConstituent.m_MixingRatio = localValMixingRatio.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MixingRatio member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MixingRatio member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sCompositeConstituent;
}



Local<Object> convertLib3MFCompositeConstituentToObject(Isolate* isolate, sLib3MFCompositeConstituent sCompositeConstituent)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "PropertyID"), Integer::NewFromUnsigned (isolate, sCompositeConstituent.m_PropertyID));
	returnInstance->Set(String::NewFromUtf8(isolate, "MixingRatio"), Number::New (isolate, sCompositeConstituent.m_MixingRatio));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFMultiPropertyLayer Conversion
**************************************************************************************************************************/
sLib3MFMultiPropertyLayer convertObjectToLib3MFMultiPropertyLayer(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFMultiPropertyLayer sMultiPropertyLayer;
	Local<Context> context = isolate->GetCurrentContext();

	sMultiPropertyLayer.m_ResourceID = 0;
	sMultiPropertyLayer.m_TheBlendMethod.m_code = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// ResourceID Member
			MaybeLocal<Value> maybeValResourceID = obj->Get(context, String::NewFromUtf8(isolate, "ResourceID"));
			if (!maybeValResourceID.IsEmpty()) {
				Local<Value> valResourceID = maybeValResourceID.ToLocalChecked();
				if (valResourceID->IsNumber()) {
					MaybeLocal<Number> localValResourceID = valResourceID->ToNumber(context);
					sMultiPropertyLayer.m_ResourceID = localValResourceID.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "ResourceID member not found in object" )));
			}

			// TheBlendMethod Member
			MaybeLocal<Value> maybeValTheBlendMethod = obj->Get(context, String::NewFromUtf8(isolate, "TheBlendMethod"));
			if (!maybeValTheBlendMethod.IsEmpty()) {
				Local<Value> valTheBlendMethod = maybeValTheBlendMethod.ToLocalChecked();
				if (valTheBlendMethod->IsNumber()) {
					MaybeLocal<Number> localValTheBlendMethod = valTheBlendMethod->ToNumber(context);
					sMultiPropertyLayer.m_TheBlendMethod.m_code = localValTheBlendMethod.ToLocalChecked()->Int32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "TheBlendMethod member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "TheBlendMethod member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sMultiPropertyLayer;
}



Local<Object> convertLib3MFMultiPropertyLayerToObject(Isolate* isolate, sLib3MFMultiPropertyLayer sMultiPropertyLayer)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "ResourceID"), Integer::NewFromUnsigned (isolate, sMultiPropertyLayer.m_ResourceID));
	returnInstance->Set(String::NewFromUtf8(isolate, "TheBlendMethod"), Integer::New (isolate, sMultiPropertyLayer.m_TheBlendMethod.m_code));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFTex2Coord Conversion
**************************************************************************************************************************/
sLib3MFTex2Coord convertObjectToLib3MFTex2Coord(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTex2Coord sTex2Coord;
	Local<Context> context = isolate->GetCurrentContext();

	sTex2Coord.m_U = 0.0;
	sTex2Coord.m_V = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// U Member
			MaybeLocal<Value> maybeValU = obj->Get(context, String::NewFromUtf8(isolate, "U"));
			if (!maybeValU.IsEmpty()) {
				Local<Value> valU = maybeValU.ToLocalChecked();
				if (valU->IsNumber()) {
					MaybeLocal<Number> localValU = valU->ToNumber(context);
					sTex2Coord.m_U = localValU.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "U member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "U member not found in object" )));
			}

			// V Member
			MaybeLocal<Value> maybeValV = obj->Get(context, String::NewFromUtf8(isolate, "V"));
			if (!maybeValV.IsEmpty()) {
				Local<Value> valV = maybeValV.ToLocalChecked();
				if (valV->IsNumber()) {
					MaybeLocal<Number> localValV = valV->ToNumber(context);
					sTex2Coord.m_V = localValV.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "V member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "V member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTex2Coord;
}



Local<Object> convertLib3MFTex2CoordToObject(Isolate* isolate, sLib3MFTex2Coord sTex2Coord)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "U"), Number::New (isolate, sTex2Coord.m_U));
	returnInstance->Set(String::NewFromUtf8(isolate, "V"), Number::New (isolate, sTex2Coord.m_V));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFTransform Conversion
**************************************************************************************************************************/
sLib3MFTransform convertObjectToLib3MFTransform(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFTransform sTransform;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;
	int columnIndex;

	for (columnIndex = 0; columnIndex < 4; columnIndex++)
		for (rowIndex = 0; rowIndex < 3; rowIndex++)
			sTransform.m_Fields[columnIndex][rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Fields Member
			MaybeLocal<Value> maybeValFields = obj->Get(context, String::NewFromUtf8(isolate, "Fields"));
			if (!maybeValFields.IsEmpty()) {
				Local<Value> valFields = maybeValFields.ToLocalChecked();
				if (valFields->IsArray()) {
					Local<Array> arrayFields = Local<Array>::Cast(valFields);
					for (int colIndex = 0; colIndex < 4; colIndex++) {
						MaybeLocal<Value> mlocalCol = arrayFields->Get(context, colIndex);
						Local<Value> localCol;
						if (mlocalCol.ToLocal(&localCol)) {
					  if (localCol->IsArray()) {
								Local<Array> localColArray = Local<Array>::Cast(localCol);
								for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
									MaybeLocal<Value> mlocalValue = localColArray->Get(context, rowIndex);
									Local<Value> localValue;
									if (mlocalValue.ToLocal(&localValue)) {
										if (localValue->IsNumber()) {
											MaybeLocal<Number> localNumber = localValue->ToNumber(context);
											sTransform.m_Fields[colIndex][rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
										} else {
											isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is not a number" )));
										}
									} else {
										isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is invalid" )));
									}
								}
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is not an array" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Fields member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sTransform;
}



Local<Object> convertLib3MFTransformToObject(Isolate* isolate, sLib3MFTransform sTransform)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newFields = Array::New(isolate, 4);
	for (int colIndex = 0; colIndex < 4; colIndex++) {
		Local<Array> colArray = Array::New(isolate, 3);
		for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
			colArray->Set(rowIndex, Number::New(isolate, (double) sTransform.m_Fields[colIndex][rowIndex]));
		}
		newFields->Set(colIndex, colArray);
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Fields"), newFields);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFBox Conversion
**************************************************************************************************************************/
sLib3MFBox convertObjectToLib3MFBox(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFBox sBox;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sBox.m_MinCoordinate[rowIndex] = 0.0f;
	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sBox.m_MaxCoordinate[rowIndex] = 0.0f;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// MinCoordinate Member
			MaybeLocal<Value> maybeValMinCoordinate = obj->Get(context, String::NewFromUtf8(isolate, "MinCoordinate"));
			if (!maybeValMinCoordinate.IsEmpty()) {
				Local<Value> valMinCoordinate = maybeValMinCoordinate.ToLocalChecked();
				if (valMinCoordinate->IsArray()) {
					Local<Array> arrayMinCoordinate = Local<Array>::Cast(valMinCoordinate);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayMinCoordinate->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBox.m_MinCoordinate[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MinCoordinate member not found in object" )));
			}

			// MaxCoordinate Member
			MaybeLocal<Value> maybeValMaxCoordinate = obj->Get(context, String::NewFromUtf8(isolate, "MaxCoordinate"));
			if (!maybeValMaxCoordinate.IsEmpty()) {
				Local<Value> valMaxCoordinate = maybeValMaxCoordinate.ToLocalChecked();
				if (valMaxCoordinate->IsArray()) {
					Local<Array> arrayMaxCoordinate = Local<Array>::Cast(valMaxCoordinate);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayMaxCoordinate->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBox.m_MaxCoordinate[rowIndex] = (float)localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "MaxCoordinate member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sBox;
}



Local<Object> convertLib3MFBoxToObject(Isolate* isolate, sLib3MFBox sBox)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newMinCoordinate = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newMinCoordinate->Set(rowIndex, Number::New(isolate, (double) sBox.m_MinCoordinate[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "MinCoordinate"), newMinCoordinate);

	Local<Array> newMaxCoordinate = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newMaxCoordinate->Set(rowIndex, Number::New(isolate, (double) sBox.m_MaxCoordinate[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "MaxCoordinate"), newMaxCoordinate);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFColor Conversion
**************************************************************************************************************************/
sLib3MFColor convertObjectToLib3MFColor(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFColor sColor;
	Local<Context> context = isolate->GetCurrentContext();

	sColor.m_Red = 0;
	sColor.m_Green = 0;
	sColor.m_Blue = 0;
	sColor.m_Alpha = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Red Member
			MaybeLocal<Value> maybeValRed = obj->Get(context, String::NewFromUtf8(isolate, "Red"));
			if (!maybeValRed.IsEmpty()) {
				Local<Value> valRed = maybeValRed.ToLocalChecked();
				if (valRed->IsNumber()) {
					MaybeLocal<Number> localValRed = valRed->ToNumber(context);
					sColor.m_Red = localValRed.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Red member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Red member not found in object" )));
			}

			// Green Member
			MaybeLocal<Value> maybeValGreen = obj->Get(context, String::NewFromUtf8(isolate, "Green"));
			if (!maybeValGreen.IsEmpty()) {
				Local<Value> valGreen = maybeValGreen.ToLocalChecked();
				if (valGreen->IsNumber()) {
					MaybeLocal<Number> localValGreen = valGreen->ToNumber(context);
					sColor.m_Green = localValGreen.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Green member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Green member not found in object" )));
			}

			// Blue Member
			MaybeLocal<Value> maybeValBlue = obj->Get(context, String::NewFromUtf8(isolate, "Blue"));
			if (!maybeValBlue.IsEmpty()) {
				Local<Value> valBlue = maybeValBlue.ToLocalChecked();
				if (valBlue->IsNumber()) {
					MaybeLocal<Number> localValBlue = valBlue->ToNumber(context);
					sColor.m_Blue = localValBlue.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Blue member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Blue member not found in object" )));
			}

			// Alpha Member
			MaybeLocal<Value> maybeValAlpha = obj->Get(context, String::NewFromUtf8(isolate, "Alpha"));
			if (!maybeValAlpha.IsEmpty()) {
				Local<Value> valAlpha = maybeValAlpha.ToLocalChecked();
				if (valAlpha->IsNumber()) {
					MaybeLocal<Number> localValAlpha = valAlpha->ToNumber(context);
					sColor.m_Alpha = localValAlpha.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Alpha member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Alpha member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sColor;
}



Local<Object> convertLib3MFColorToObject(Isolate* isolate, sLib3MFColor sColor)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "Red"), Integer::NewFromUnsigned (isolate, sColor.m_Red));
	returnInstance->Set(String::NewFromUtf8(isolate, "Green"), Integer::NewFromUnsigned (isolate, sColor.m_Green));
	returnInstance->Set(String::NewFromUtf8(isolate, "Blue"), Integer::NewFromUnsigned (isolate, sColor.m_Blue));
	returnInstance->Set(String::NewFromUtf8(isolate, "Alpha"), Integer::NewFromUnsigned (isolate, sColor.m_Alpha));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFBeam Conversion
**************************************************************************************************************************/
sLib3MFBeam convertObjectToLib3MFBeam(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFBeam sBeam;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sBeam.m_Indices[rowIndex] = 0;
	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sBeam.m_Radii[rowIndex] = 0.0;
	for (rowIndex = 0; rowIndex < 2; rowIndex++)
		sBeam.m_CapModes[rowIndex].m_code = 0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Indices Member
			MaybeLocal<Value> maybeValIndices = obj->Get(context, String::NewFromUtf8(isolate, "Indices"));
			if (!maybeValIndices.IsEmpty()) {
				Local<Value> valIndices = maybeValIndices.ToLocalChecked();
				if (valIndices->IsArray()) {
					Local<Array> arrayIndices = Local<Array>::Cast(valIndices);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayIndices->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBeam.m_Indices[rowIndex] = localNumber.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Indices member not found in object" )));
			}

			// Radii Member
			MaybeLocal<Value> maybeValRadii = obj->Get(context, String::NewFromUtf8(isolate, "Radii"));
			if (!maybeValRadii.IsEmpty()) {
				Local<Value> valRadii = maybeValRadii.ToLocalChecked();
				if (valRadii->IsArray()) {
					Local<Array> arrayRadii = Local<Array>::Cast(valRadii);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayRadii->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBeam.m_Radii[rowIndex] = localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radii member not found in object" )));
			}

			// CapModes Member
			MaybeLocal<Value> maybeValCapModes = obj->Get(context, String::NewFromUtf8(isolate, "CapModes"));
			if (!maybeValCapModes.IsEmpty()) {
				Local<Value> valCapModes = maybeValCapModes.ToLocalChecked();
				if (valCapModes->IsArray()) {
					Local<Array> arrayCapModes = Local<Array>::Cast(valCapModes);
					for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCapModes->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sBeam.m_CapModes[rowIndex].m_code = localNumber.ToLocalChecked()->Int32Value(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "CapModes member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sBeam;
}



Local<Object> convertLib3MFBeamToObject(Isolate* isolate, sLib3MFBeam sBeam)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newIndices = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newIndices->Set(rowIndex, Integer::NewFromUnsigned(isolate, sBeam.m_Indices[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Indices"), newIndices);

	Local<Array> newRadii = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newRadii->Set(rowIndex, Number::New(isolate, sBeam.m_Radii[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Radii"), newRadii);

	Local<Array> newCapModes = Array::New(isolate, 2);
	for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
		newCapModes->Set(rowIndex, Integer::New(isolate, sBeam.m_CapModes[rowIndex].m_code));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "CapModes"), newCapModes);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFBall Conversion
**************************************************************************************************************************/
sLib3MFBall convertObjectToLib3MFBall(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFBall sBall;
	Local<Context> context = isolate->GetCurrentContext();

	sBall.m_Index = 0;
	sBall.m_Radius = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Index Member
			MaybeLocal<Value> maybeValIndex = obj->Get(context, String::NewFromUtf8(isolate, "Index"));
			if (!maybeValIndex.IsEmpty()) {
				Local<Value> valIndex = maybeValIndex.ToLocalChecked();
				if (valIndex->IsNumber()) {
					MaybeLocal<Number> localValIndex = valIndex->ToNumber(context);
					sBall.m_Index = localValIndex.ToLocalChecked()->Uint32Value(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Index member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Index member not found in object" )));
			}

			// Radius Member
			MaybeLocal<Value> maybeValRadius = obj->Get(context, String::NewFromUtf8(isolate, "Radius"));
			if (!maybeValRadius.IsEmpty()) {
				Local<Value> valRadius = maybeValRadius.ToLocalChecked();
				if (valRadius->IsNumber()) {
					MaybeLocal<Number> localValRadius = valRadius->ToNumber(context);
					sBall.m_Radius = localValRadius.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radius member is not a number" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Radius member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sBall;
}



Local<Object> convertLib3MFBallToObject(Isolate* isolate, sLib3MFBall sBall)
{
	Local<Object> returnInstance = Object::New(isolate);
	returnInstance->Set(String::NewFromUtf8(isolate, "Index"), Integer::NewFromUnsigned (isolate, sBall.m_Index));
	returnInstance->Set(String::NewFromUtf8(isolate, "Radius"), Number::New (isolate, sBall.m_Radius));

	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFVector Conversion
**************************************************************************************************************************/
sLib3MFVector convertObjectToLib3MFVector(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFVector sVector;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;

	for (rowIndex = 0; rowIndex < 3; rowIndex++)
		sVector.m_Coordinates[rowIndex] = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Coordinates Member
			MaybeLocal<Value> maybeValCoordinates = obj->Get(context, String::NewFromUtf8(isolate, "Coordinates"));
			if (!maybeValCoordinates.IsEmpty()) {
				Local<Value> valCoordinates = maybeValCoordinates.ToLocalChecked();
				if (valCoordinates->IsArray()) {
					Local<Array> arrayCoordinates = Local<Array>::Cast(valCoordinates);
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						MaybeLocal<Value> mlocalValue = arrayCoordinates->Get(context, rowIndex);
						Local<Value> localValue;
						if (mlocalValue.ToLocal(&localValue)) {
							if (localValue->IsNumber()) {
								MaybeLocal<Number> localNumber = localValue->ToNumber(context);
								sVector.m_Coordinates[rowIndex] = localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is not a number" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Coordinates member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sVector;
}



Local<Object> convertLib3MFVectorToObject(Isolate* isolate, sLib3MFVector sVector)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newCoordinates = Array::New(isolate, 3);
	for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
		newCoordinates->Set(rowIndex, Number::New(isolate, sVector.m_Coordinates[rowIndex]));
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Coordinates"), newCoordinates);


	return returnInstance;
}

/*************************************************************************************************************************
 Class sLib3MFMatrix4x4 Conversion
**************************************************************************************************************************/
sLib3MFMatrix4x4 convertObjectToLib3MFMatrix4x4(Isolate* isolate, const Local<Value> & pParamValue)
{
	sLib3MFMatrix4x4 sMatrix4x4;
	Local<Context> context = isolate->GetCurrentContext();
	int rowIndex;
	int columnIndex;

	for (columnIndex = 0; columnIndex < 4; columnIndex++)
		for (rowIndex = 0; rowIndex < 4; rowIndex++)
			sMatrix4x4.m_Field[columnIndex][rowIndex] = 0.0;

	if (pParamValue->IsObject()) {
		MaybeLocal<Object> maybeObject = pParamValue->ToObject(context);

		if (!maybeObject.IsEmpty()) {
			Local<Object> obj = maybeObject.ToLocalChecked();

			// Field Member
			MaybeLocal<Value> maybeValField = obj->Get(context, String::NewFromUtf8(isolate, "Field"));
			if (!maybeValField.IsEmpty()) {
				Local<Value> valField = maybeValField.ToLocalChecked();
				if (valField->IsArray()) {
					Local<Array> arrayField = Local<Array>::Cast(valField);
					for (int colIndex = 0; colIndex < 4; colIndex++) {
						MaybeLocal<Value> mlocalCol = arrayField->Get(context, colIndex);
						Local<Value> localCol;
						if (mlocalCol.ToLocal(&localCol)) {
					  if (localCol->IsArray()) {
								Local<Array> localColArray = Local<Array>::Cast(localCol);
								for (int rowIndex = 0; rowIndex < 4; rowIndex++) {
									MaybeLocal<Value> mlocalValue = localColArray->Get(context, rowIndex);
									Local<Value> localValue;
									if (mlocalValue.ToLocal(&localValue)) {
										if (localValue->IsNumber()) {
											MaybeLocal<Number> localNumber = localValue->ToNumber(context);
											sMatrix4x4.m_Field[colIndex][rowIndex] = localNumber.ToLocalChecked()->NumberValue(isolate->GetCurrentContext()).ToChecked();
										} else {
											isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Field array entry is not a number" )));
										}
									} else {
										isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Field array entry is invalid" )));
									}
								}
							} else {
								isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Field array entry is not an array" )));
							}
						} else {
							isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Field array entry is invalid" )));
						}
					}
				} else {
					isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Field member is not an array" )));
				}
			} else {
				isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "Field member not found in object" )));
			}


		} else {
			isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "invalid object passed." )));
		}
	} else {
		isolate->ThrowException(Exception::TypeError(String::NewFromUtf8(isolate, "expected object parameter." )));
	}

	return sMatrix4x4;
}



Local<Object> convertLib3MFMatrix4x4ToObject(Isolate* isolate, sLib3MFMatrix4x4 sMatrix4x4)
{
	Local<Object> returnInstance = Object::New(isolate);
	Local<Array> newField = Array::New(isolate, 4);
	for (int colIndex = 0; colIndex < 4; colIndex++) {
		Local<Array> colArray = Array::New(isolate, 4);
		for (int rowIndex = 0; rowIndex < 4; rowIndex++) {
			colArray->Set(rowIndex, Number::New(isolate, sMatrix4x4.m_Field[colIndex][rowIndex]));
		}
		newField->Set(colIndex, colArray);
	}
	returnInstance->Set(String::NewFromUtf8(isolate, "Field"), newField);


	return returnInstance;
}

/*************************************************************************************************************************
 Class CLib3MFBaseClass Implementation
**************************************************************************************************************************/

CLib3MFBaseClass::CLib3MFBaseClass()
		: node::ObjectWrap()
{

}

void CLib3MFBaseClass::RaiseError(v8::Isolate * isolate, std::string Message)
{
		if (isolate != nullptr) {
				isolate->ThrowException(Exception::TypeError(
						String::NewFromUtf8(isolate, Message.c_str() )));
		}
}
void CLib3MFBaseClass::CheckError(v8::Isolate * isolate, sLib3MFDynamicWrapperTable * sWrapperTable, Lib3MFHandle pInstance, Lib3MFResult errorCode)
{
		if (errorCode != 0) {
			std::string sMessage;
			if ((sWrapperTable != nullptr) && (pInstance != nullptr)) {
				if (sWrapperTable->m_GetLastError != nullptr) {
					uint32_t neededChars = 0;
					bool hasLastError = 0;
					if (sWrapperTable->m_GetLastError(pInstance, 0, &neededChars, nullptr, &hasLastError) == 0) {
						uint32_t dummyChars = 0;
						std::vector<char> Buffer;
						Buffer.resize(neededChars + 2);
						if (sWrapperTable->m_GetLastError(pInstance, neededChars + 1, &dummyChars, Buffer.data(), &hasLastError) == 0) {
							Buffer[neededChars + 1] = 0;
							sMessage = std::string(": ") + std::string(&Buffer[0]);
						}
					}
				}
			}
			throw std::runtime_error("Lib3MF Error" + sMessage + " (" + std::to_string(errorCode) + ")");
		}
}

void CLib3MFBaseClass::setHandle(Lib3MFHandle pHandle)
{
		
}

Lib3MFHandle CLib3MFBaseClass::getHandle(v8::Local<v8::Object> objecthandle)
{
		auto Field = objecthandle->GetInternalField(NODEWRAPPER_HANDLEINDEX);
		v8::Local<v8::External> externalField = Field.As<v8::External>();
		return (Lib3MFHandle *) externalField->Value();
}

sLib3MFDynamicWrapperTable * CLib3MFBaseClass::getDynamicWrapperTable(v8::Local<v8::Object> objecthandle)
{
		auto Field = objecthandle->GetInternalField(NODEWRAPPER_TABLEINDEX);
		v8::Local<v8::External> externalField = Field.As<v8::External>();
		return (sLib3MFDynamicWrapperTable *) externalField->Value();
}


/*************************************************************************************************************************
 Class CLib3MFBase Implementation
**************************************************************************************************************************/

CLib3MFBase::CLib3MFBase()
		: CLib3MFBaseClass()
{
}

CLib3MFBase::~CLib3MFBase()
{
}

void CLib3MFBase::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBase"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClassTypeId", ClassTypeId);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBase::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBase * baseInstance = new CLib3MFBase();
				baseInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBase: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBase::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBase::ClassTypeId(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnClassTypeId = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClassTypeId.");
        if (wrapperTable->m_Base_ClassTypeId == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Base::ClassTypeId.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Base_ClassTypeId(instanceHandle, &nReturnClassTypeId);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnClassTypeId).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFWriter Implementation
**************************************************************************************************************************/

CLib3MFWriter::CLib3MFWriter()
		: CLib3MFBaseClass()
{
}

CLib3MFWriter::~CLib3MFWriter()
{
}

void CLib3MFWriter::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFWriter"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToFile", WriteToFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStreamSize", GetStreamSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToBuffer", WriteToBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToCallback", WriteToCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetProgressCallback", SetProgressCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDecimalPrecision", GetDecimalPrecision);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDecimalPrecision", SetDecimalPrecision);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetStrictModeActive", SetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStrictModeActive", GetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarning", GetWarning);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarningCount", GetWarningCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddKeyWrappingCallback", AddKeyWrappingCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetContentEncryptionCallback", SetContentEncryptionCallback);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFWriter::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFWriter * writerInstance = new CLib3MFWriter();
				writerInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFWriter: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFWriter::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFWriter::WriteToFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Filename)");
        }
        v8::String::Utf8Value sutf8Filename(isolate, args[0]);
        std::string sFilename = *sutf8Filename;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToFile.");
        if (wrapperTable->m_Writer_WriteToFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::WriteToFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_WriteToFile(instanceHandle, sFilename.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetStreamSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnStreamSize = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStreamSize.");
        if (wrapperTable->m_Writer_GetStreamSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetStreamSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetStreamSize(instanceHandle, &nReturnStreamSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnStreamSize).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::WriteToBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToBuffer.");
        if (wrapperTable->m_Writer_WriteToBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::WriteToBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_WriteToBuffer(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::WriteToCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 2 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[2]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToCallback.");
        if (wrapperTable->m_Writer_WriteToCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::WriteToCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_WriteToCallback(instanceHandle, nullptr, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetProgressCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetProgressCallback.");
        if (wrapperTable->m_Writer_SetProgressCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetProgressCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetProgressCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetDecimalPrecision(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnDecimalPrecision = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDecimalPrecision.");
        if (wrapperTable->m_Writer_GetDecimalPrecision == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetDecimalPrecision.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetDecimalPrecision(instanceHandle, &nReturnDecimalPrecision);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnDecimalPrecision));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetDecimalPrecision(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (DecimalPrecision)");
        }
        unsigned int nDecimalPrecision = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDecimalPrecision.");
        if (wrapperTable->m_Writer_SetDecimalPrecision == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetDecimalPrecision.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetDecimalPrecision(instanceHandle, nDecimalPrecision);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (StrictModeActive)");
        }
        bool bStrictModeActive = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetStrictModeActive.");
        if (wrapperTable->m_Writer_SetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetStrictModeActive(instanceHandle, bStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnStrictModeActive = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStrictModeActive.");
        if (wrapperTable->m_Writer_GetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetStrictModeActive(instanceHandle, &bReturnStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnStrictModeActive));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetWarning(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        Local<Object> outObject = Object::New(isolate);
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nReturnErrorCode = 0;
        unsigned int bytesNeededWarning = 0;
        unsigned int bytesWrittenWarning = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarning.");
        if (wrapperTable->m_Writer_GetWarning == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetWarning.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Writer_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, 0, &bytesNeededWarning, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferWarning;
        bufferWarning.resize(bytesNeededWarning);
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, bytesNeededWarning, &bytesWrittenWarning, &bufferWarning[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ErrorCode"), Integer::NewFromUnsigned(isolate, nReturnErrorCode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Warning"), String::NewFromUtf8(isolate, &bufferWarning[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::GetWarningCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarningCount.");
        if (wrapperTable->m_Writer_GetWarningCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::GetWarningCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_GetWarningCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::AddKeyWrappingCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 2 (UserData)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        v8::String::Utf8Value sutf8UserData(isolate, args[2]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddKeyWrappingCallback.");
        if (wrapperTable->m_Writer_AddKeyWrappingCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::AddKeyWrappingCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_AddKeyWrappingCallback(instanceHandle, sConsumerID.c_str(), nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFWriter::SetContentEncryptionCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetContentEncryptionCallback.");
        if (wrapperTable->m_Writer_SetContentEncryptionCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Writer::SetContentEncryptionCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Writer_SetContentEncryptionCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFReader Implementation
**************************************************************************************************************************/

CLib3MFReader::CLib3MFReader()
		: CLib3MFBaseClass()
{
}

CLib3MFReader::~CLib3MFReader()
{
}

void CLib3MFReader::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFReader"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromFile", ReadFromFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromBuffer", ReadFromBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromCallback", ReadFromCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetProgressCallback", SetProgressCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddRelationToRead", AddRelationToRead);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveRelationToRead", RemoveRelationToRead);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetStrictModeActive", SetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStrictModeActive", GetStrictModeActive);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarning", GetWarning);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWarningCount", GetWarningCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddKeyWrappingCallback", AddKeyWrappingCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetContentEncryptionCallback", SetContentEncryptionCallback);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFReader::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFReader * readerInstance = new CLib3MFReader();
				readerInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFReader: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFReader::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFReader::ReadFromFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Filename)");
        }
        v8::String::Utf8Value sutf8Filename(isolate, args[0]);
        std::string sFilename = *sutf8Filename;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromFile.");
        if (wrapperTable->m_Reader_ReadFromFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::ReadFromFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_ReadFromFile(instanceHandle, sFilename.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::ReadFromBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromBuffer.");
        if (wrapperTable->m_Reader_ReadFromBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::ReadFromBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_ReadFromBuffer(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::ReadFromCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 1 (StreamSize)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 3 (UserData)");
        }
        v8::String::Utf8Value sutf8StreamSize(isolate, args[1]);
        std::string sStreamSize = *sutf8StreamSize;
        uint64_t nStreamSize = stoull(sStreamSize);
        v8::String::Utf8Value sutf8UserData(isolate, args[3]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromCallback.");
        if (wrapperTable->m_Reader_ReadFromCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::ReadFromCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_ReadFromCallback(instanceHandle, nullptr, nStreamSize, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::SetProgressCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetProgressCallback.");
        if (wrapperTable->m_Reader_SetProgressCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::SetProgressCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_SetProgressCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::AddRelationToRead(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (RelationShipType)");
        }
        v8::String::Utf8Value sutf8RelationShipType(isolate, args[0]);
        std::string sRelationShipType = *sutf8RelationShipType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddRelationToRead.");
        if (wrapperTable->m_Reader_AddRelationToRead == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::AddRelationToRead.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_AddRelationToRead(instanceHandle, sRelationShipType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::RemoveRelationToRead(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (RelationShipType)");
        }
        v8::String::Utf8Value sutf8RelationShipType(isolate, args[0]);
        std::string sRelationShipType = *sutf8RelationShipType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveRelationToRead.");
        if (wrapperTable->m_Reader_RemoveRelationToRead == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::RemoveRelationToRead.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_RemoveRelationToRead(instanceHandle, sRelationShipType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::SetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (StrictModeActive)");
        }
        bool bStrictModeActive = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetStrictModeActive.");
        if (wrapperTable->m_Reader_SetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::SetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_SetStrictModeActive(instanceHandle, bStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::GetStrictModeActive(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnStrictModeActive = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStrictModeActive.");
        if (wrapperTable->m_Reader_GetStrictModeActive == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::GetStrictModeActive.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_GetStrictModeActive(instanceHandle, &bReturnStrictModeActive);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnStrictModeActive));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::GetWarning(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        Local<Object> outObject = Object::New(isolate);
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nReturnErrorCode = 0;
        unsigned int bytesNeededWarning = 0;
        unsigned int bytesWrittenWarning = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarning.");
        if (wrapperTable->m_Reader_GetWarning == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::GetWarning.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Reader_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, 0, &bytesNeededWarning, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferWarning;
        bufferWarning.resize(bytesNeededWarning);
        Lib3MFResult errorCode = wrapperTable->m_Reader_GetWarning(instanceHandle, nIndex, &nReturnErrorCode, bytesNeededWarning, &bytesWrittenWarning, &bufferWarning[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ErrorCode"), Integer::NewFromUnsigned(isolate, nReturnErrorCode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "Warning"), String::NewFromUtf8(isolate, &bufferWarning[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::GetWarningCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWarningCount.");
        if (wrapperTable->m_Reader_GetWarningCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::GetWarningCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_GetWarningCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::AddKeyWrappingCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 2 (UserData)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        v8::String::Utf8Value sutf8UserData(isolate, args[2]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddKeyWrappingCallback.");
        if (wrapperTable->m_Reader_AddKeyWrappingCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::AddKeyWrappingCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_AddKeyWrappingCallback(instanceHandle, sConsumerID.c_str(), nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFReader::SetContentEncryptionCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 1 (UserData)");
        }
        v8::String::Utf8Value sutf8UserData(isolate, args[1]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetContentEncryptionCallback.");
        if (wrapperTable->m_Reader_SetContentEncryptionCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Reader::SetContentEncryptionCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Reader_SetContentEncryptionCallback(instanceHandle, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFPackagePart Implementation
**************************************************************************************************************************/

CLib3MFPackagePart::CLib3MFPackagePart()
		: CLib3MFBaseClass()
{
}

CLib3MFPackagePart::~CLib3MFPackagePart()
{
}

void CLib3MFPackagePart::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFPackagePart"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPath", GetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPath", SetPath);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFPackagePart::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFPackagePart * packagepartInstance = new CLib3MFPackagePart();
				packagepartInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFPackagePart: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFPackagePart::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFPackagePart::GetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPath.");
        if (wrapperTable->m_PackagePart_GetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method PackagePart::GetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_PackagePart_GetPath(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_PackagePart_GetPath(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFPackagePart::SetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPath.");
        if (wrapperTable->m_PackagePart_SetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method PackagePart::SetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_PackagePart_SetPath(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResource Implementation
**************************************************************************************************************************/

CLib3MFResource::CLib3MFResource()
		: CLib3MFBaseClass()
{
}

CLib3MFResource::~CLib3MFResource()
{
}

void CLib3MFResource::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResource"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceID", GetResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUniqueResourceID", GetUniqueResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "PackagePart", PackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPackagePart", SetPackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetModelResourceID", GetModelResourceID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResource::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResource * resourceInstance = new CLib3MFResource();
				resourceInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResource: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResource::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResource::GetResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceID.");
        if (wrapperTable->m_Resource_GetResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::GetResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_GetResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::GetUniqueResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUniqueResourceID.");
        if (wrapperTable->m_Resource_GetUniqueResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::GetUniqueResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_GetUniqueResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::PackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPackagePart = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method PackagePart.");
        if (wrapperTable->m_Resource_PackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::PackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_PackagePart(instanceHandle, &hReturnPackagePart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPackagePart = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnPackagePart);
        args.GetReturnValue().Set(instanceObjPackagePart);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::SetPackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (PackagePart)");
        }
        Local<Object> objPackagePart = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instancePackagePart = ObjectWrap::Unwrap<CLib3MFPackagePart>(objPackagePart);
        if (instancePackagePart == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (PackagePart)");
        Lib3MFHandle hPackagePart = instancePackagePart->getHandle( objPackagePart );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPackagePart.");
        if (wrapperTable->m_Resource_SetPackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::SetPackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_SetPackagePart(instanceHandle, hPackagePart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResource::GetModelResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnModelResourceId = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetModelResourceID.");
        if (wrapperTable->m_Resource_GetModelResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Resource::GetModelResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Resource_GetModelResourceID(instanceHandle, &nReturnModelResourceId);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnModelResourceId));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResourceIterator Implementation
**************************************************************************************************************************/

CLib3MFResourceIterator::CLib3MFResourceIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceIterator::~CLib3MFResourceIterator()
{
}

void CLib3MFResourceIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "MoveNext", MoveNext);
		NODE_SET_PROTOTYPE_METHOD(tpl, "MovePrevious", MovePrevious);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrent", GetCurrent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Clone", Clone);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Count", Count);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceIterator * resourceiteratorInstance = new CLib3MFResourceIterator();
				resourceiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceIterator::MoveNext(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasNext = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MoveNext.");
        if (wrapperTable->m_ResourceIterator_MoveNext == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::MoveNext.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_MoveNext(instanceHandle, &bReturnHasNext);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasNext));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::MovePrevious(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasPrevious = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MovePrevious.");
        if (wrapperTable->m_ResourceIterator_MovePrevious == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::MovePrevious.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_MovePrevious(instanceHandle, &bReturnHasPrevious);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasPrevious));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::GetCurrent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrent.");
        if (wrapperTable->m_ResourceIterator_GetCurrent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::GetCurrent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_GetCurrent(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFResource::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::Clone(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnOutResourceIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Clone.");
        if (wrapperTable->m_ResourceIterator_Clone == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::Clone.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_Clone(instanceHandle, &hReturnOutResourceIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjOutResourceIterator = CLib3MFResourceIterator::NewInstance(args.Holder(), hReturnOutResourceIterator);
        args.GetReturnValue().Set(instanceObjOutResourceIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIterator::Count(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Count.");
        if (wrapperTable->m_ResourceIterator_Count == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIterator::Count.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIterator_Count(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSliceStackIterator Implementation
**************************************************************************************************************************/

CLib3MFSliceStackIterator::CLib3MFSliceStackIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFSliceStackIterator::~CLib3MFSliceStackIterator()
{
}

void CLib3MFSliceStackIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSliceStackIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentSliceStack", GetCurrentSliceStack);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSliceStackIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSliceStackIterator * slicestackiteratorInstance = new CLib3MFSliceStackIterator();
				slicestackiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSliceStackIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSliceStackIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSliceStackIterator::GetCurrentSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentSliceStack.");
        if (wrapperTable->m_SliceStackIterator_GetCurrentSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStackIterator::GetCurrentSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStackIterator_GetCurrentSliceStack(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFObjectIterator Implementation
**************************************************************************************************************************/

CLib3MFObjectIterator::CLib3MFObjectIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFObjectIterator::~CLib3MFObjectIterator()
{
}

void CLib3MFObjectIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFObjectIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentObject", GetCurrentObject);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFObjectIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFObjectIterator * objectiteratorInstance = new CLib3MFObjectIterator();
				objectiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFObjectIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFObjectIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFObjectIterator::GetCurrentObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentObject.");
        if (wrapperTable->m_ObjectIterator_GetCurrentObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ObjectIterator::GetCurrentObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ObjectIterator_GetCurrentObject(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFObject::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMeshObjectIterator Implementation
**************************************************************************************************************************/

CLib3MFMeshObjectIterator::CLib3MFMeshObjectIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFMeshObjectIterator::~CLib3MFMeshObjectIterator()
{
}

void CLib3MFMeshObjectIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMeshObjectIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentMeshObject", GetCurrentMeshObject);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMeshObjectIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMeshObjectIterator * meshobjectiteratorInstance = new CLib3MFMeshObjectIterator();
				meshobjectiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMeshObjectIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMeshObjectIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMeshObjectIterator::GetCurrentMeshObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentMeshObject.");
        if (wrapperTable->m_MeshObjectIterator_GetCurrentMeshObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObjectIterator::GetCurrentMeshObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObjectIterator_GetCurrentMeshObject(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFMeshObject::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComponentsObjectIterator Implementation
**************************************************************************************************************************/

CLib3MFComponentsObjectIterator::CLib3MFComponentsObjectIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFComponentsObjectIterator::~CLib3MFComponentsObjectIterator()
{
}

void CLib3MFComponentsObjectIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComponentsObjectIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentComponentsObject", GetCurrentComponentsObject);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComponentsObjectIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComponentsObjectIterator * componentsobjectiteratorInstance = new CLib3MFComponentsObjectIterator();
				componentsobjectiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComponentsObjectIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComponentsObjectIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComponentsObjectIterator::GetCurrentComponentsObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentComponentsObject.");
        if (wrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObjectIterator::GetCurrentComponentsObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFComponentsObject::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2DIterator Implementation
**************************************************************************************************************************/

CLib3MFTexture2DIterator::CLib3MFTexture2DIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2DIterator::~CLib3MFTexture2DIterator()
{
}

void CLib3MFTexture2DIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2DIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentTexture2D", GetCurrentTexture2D);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2DIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2DIterator * texture2diteratorInstance = new CLib3MFTexture2DIterator();
				texture2diteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2DIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2DIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2DIterator::GetCurrentTexture2D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentTexture2D.");
        if (wrapperTable->m_Texture2DIterator_GetCurrentTexture2D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DIterator::GetCurrentTexture2D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DIterator_GetCurrentTexture2D(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFTexture2D::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFBaseMaterialGroupIterator::CLib3MFBaseMaterialGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFBaseMaterialGroupIterator::~CLib3MFBaseMaterialGroupIterator()
{
}

void CLib3MFBaseMaterialGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBaseMaterialGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentBaseMaterialGroup", GetCurrentBaseMaterialGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBaseMaterialGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBaseMaterialGroupIterator * basematerialgroupiteratorInstance = new CLib3MFBaseMaterialGroupIterator();
				basematerialgroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBaseMaterialGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBaseMaterialGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentBaseMaterialGroup.");
        if (wrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroupIterator::GetCurrentBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFColorGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFColorGroupIterator::CLib3MFColorGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFColorGroupIterator::~CLib3MFColorGroupIterator()
{
}

void CLib3MFColorGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFColorGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentColorGroup", GetCurrentColorGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFColorGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFColorGroupIterator * colorgroupiteratorInstance = new CLib3MFColorGroupIterator();
				colorgroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFColorGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFColorGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFColorGroupIterator::GetCurrentColorGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentColorGroup.");
        if (wrapperTable->m_ColorGroupIterator_GetCurrentColorGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroupIterator::GetCurrentColorGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroupIterator_GetCurrentColorGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFColorGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFTexture2DGroupIterator::CLib3MFTexture2DGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2DGroupIterator::~CLib3MFTexture2DGroupIterator()
{
}

void CLib3MFTexture2DGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2DGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentTexture2DGroup", GetCurrentTexture2DGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2DGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2DGroupIterator * texture2dgroupiteratorInstance = new CLib3MFTexture2DGroupIterator();
				texture2dgroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2DGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2DGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2DGroupIterator::GetCurrentTexture2DGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentTexture2DGroup.");
        if (wrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroupIterator::GetCurrentTexture2DGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFTexture2DGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterialsIterator Implementation
**************************************************************************************************************************/

CLib3MFCompositeMaterialsIterator::CLib3MFCompositeMaterialsIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFCompositeMaterialsIterator::~CLib3MFCompositeMaterialsIterator()
{
}

void CLib3MFCompositeMaterialsIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCompositeMaterialsIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentCompositeMaterials", GetCurrentCompositeMaterials);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCompositeMaterialsIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCompositeMaterialsIterator * compositematerialsiteratorInstance = new CLib3MFCompositeMaterialsIterator();
				compositematerialsiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCompositeMaterialsIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCompositeMaterialsIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFCompositeMaterialsIterator::GetCurrentCompositeMaterials(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentCompositeMaterials.");
        if (wrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterialsIterator::GetCurrentCompositeMaterials.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFCompositeMaterials::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroupIterator Implementation
**************************************************************************************************************************/

CLib3MFMultiPropertyGroupIterator::CLib3MFMultiPropertyGroupIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFMultiPropertyGroupIterator::~CLib3MFMultiPropertyGroupIterator()
{
}

void CLib3MFMultiPropertyGroupIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMultiPropertyGroupIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentMultiPropertyGroup", GetCurrentMultiPropertyGroup);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMultiPropertyGroupIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMultiPropertyGroupIterator * multipropertygroupiteratorInstance = new CLib3MFMultiPropertyGroupIterator();
				multipropertygroupiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMultiPropertyGroupIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMultiPropertyGroupIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentMultiPropertyGroup.");
        if (wrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroupIterator::GetCurrentMultiPropertyGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFMultiPropertyGroup::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImage3DIterator Implementation
**************************************************************************************************************************/

CLib3MFImage3DIterator::CLib3MFImage3DIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFImage3DIterator::~CLib3MFImage3DIterator()
{
}

void CLib3MFImage3DIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImage3DIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentImage3D", GetCurrentImage3D);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImage3DIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImage3DIterator * image3diteratorInstance = new CLib3MFImage3DIterator();
				image3diteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImage3DIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImage3DIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImage3DIterator::GetCurrentImage3D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentImage3D.");
        if (wrapperTable->m_Image3DIterator_GetCurrentImage3D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Image3DIterator::GetCurrentImage3D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Image3DIterator_GetCurrentImage3D(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFImage3D::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFFunctionIterator Implementation
**************************************************************************************************************************/

CLib3MFFunctionIterator::CLib3MFFunctionIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFFunctionIterator::~CLib3MFFunctionIterator()
{
}

void CLib3MFFunctionIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFunctionIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentFunction", GetCurrentFunction);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFunctionIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFunctionIterator * functioniteratorInstance = new CLib3MFFunctionIterator();
				functioniteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFunctionIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFunctionIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFFunctionIterator::GetCurrentFunction(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentFunction.");
        if (wrapperTable->m_FunctionIterator_GetCurrentFunction == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionIterator::GetCurrentFunction.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionIterator_GetCurrentFunction(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFFunction::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFLevelSetIterator Implementation
**************************************************************************************************************************/

CLib3MFLevelSetIterator::CLib3MFLevelSetIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFLevelSetIterator::~CLib3MFLevelSetIterator()
{
}

void CLib3MFLevelSetIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFLevelSetIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrentLevelSet", GetCurrentLevelSet);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFLevelSetIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFLevelSetIterator * levelsetiteratorInstance = new CLib3MFLevelSetIterator();
				levelsetiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFLevelSetIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFLevelSetIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFLevelSetIterator::GetCurrentLevelSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrentLevelSet.");
        if (wrapperTable->m_LevelSetIterator_GetCurrentLevelSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSetIterator::GetCurrentLevelSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSetIterator_GetCurrentLevelSet(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFLevelSet::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMetaData Implementation
**************************************************************************************************************************/

CLib3MFMetaData::CLib3MFMetaData()
		: CLib3MFBaseClass()
{
}

CLib3MFMetaData::~CLib3MFMetaData()
{
}

void CLib3MFMetaData::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMetaData"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetNameSpace", GetNameSpace);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetNameSpace", SetNameSpace);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKey", GetKey);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMustPreserve", GetMustPreserve);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMustPreserve", SetMustPreserve);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetType", GetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetType", SetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetValue", GetValue);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetValue", SetValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMetaData::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMetaData * metadataInstance = new CLib3MFMetaData();
				metadataInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMetaData: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMetaData::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMetaData::GetNameSpace(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededNameSpace = 0;
        unsigned int bytesWrittenNameSpace = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetNameSpace.");
        if (wrapperTable->m_MetaData_GetNameSpace == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetNameSpace.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetNameSpace(instanceHandle, 0, &bytesNeededNameSpace, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferNameSpace;
        bufferNameSpace.resize(bytesNeededNameSpace);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetNameSpace(instanceHandle, bytesNeededNameSpace, &bytesWrittenNameSpace, &bufferNameSpace[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferNameSpace[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetNameSpace(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (NameSpace)");
        }
        v8::String::Utf8Value sutf8NameSpace(isolate, args[0]);
        std::string sNameSpace = *sutf8NameSpace;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetNameSpace.");
        if (wrapperTable->m_MetaData_SetNameSpace == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetNameSpace.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetNameSpace(instanceHandle, sNameSpace.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_MetaData_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_MetaData_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetKey(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededKey = 0;
        unsigned int bytesWrittenKey = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKey.");
        if (wrapperTable->m_MetaData_GetKey == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetKey.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetKey(instanceHandle, 0, &bytesNeededKey, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferKey;
        bufferKey.resize(bytesNeededKey);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetKey(instanceHandle, bytesNeededKey, &bytesWrittenKey, &bufferKey[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferKey[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetMustPreserve(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnMustPreserve = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMustPreserve.");
        if (wrapperTable->m_MetaData_GetMustPreserve == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetMustPreserve.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetMustPreserve(instanceHandle, &bReturnMustPreserve);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnMustPreserve));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetMustPreserve(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (MustPreserve)");
        }
        bool bMustPreserve = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMustPreserve.");
        if (wrapperTable->m_MetaData_SetMustPreserve == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetMustPreserve.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetMustPreserve(instanceHandle, bMustPreserve);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededType = 0;
        unsigned int bytesWrittenType = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetType.");
        if (wrapperTable->m_MetaData_GetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetType(instanceHandle, 0, &bytesNeededType, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferType;
        bufferType.resize(bytesNeededType);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetType(instanceHandle, bytesNeededType, &bytesWrittenType, &bufferType[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferType[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Type)");
        }
        v8::String::Utf8Value sutf8Type(isolate, args[0]);
        std::string sType = *sutf8Type;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetType.");
        if (wrapperTable->m_MetaData_SetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetType(instanceHandle, sType.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::GetValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededValue = 0;
        unsigned int bytesWrittenValue = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetValue.");
        if (wrapperTable->m_MetaData_GetValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::GetValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_MetaData_GetValue(instanceHandle, 0, &bytesNeededValue, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferValue;
        bufferValue.resize(bytesNeededValue);
        Lib3MFResult errorCode = wrapperTable->m_MetaData_GetValue(instanceHandle, bytesNeededValue, &bytesWrittenValue, &bufferValue[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferValue[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaData::SetValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Value)");
        }
        v8::String::Utf8Value sutf8Value(isolate, args[0]);
        std::string sValue = *sutf8Value;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetValue.");
        if (wrapperTable->m_MetaData_SetValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaData::SetValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaData_SetValue(instanceHandle, sValue.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMetaDataGroup Implementation
**************************************************************************************************************************/

CLib3MFMetaDataGroup::CLib3MFMetaDataGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFMetaDataGroup::~CLib3MFMetaDataGroup()
{
}

void CLib3MFMetaDataGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMetaDataGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataCount", GetMetaDataCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaData", GetMetaData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataByKey", GetMetaDataByKey);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMetaDataByIndex", RemoveMetaDataByIndex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMetaData", RemoveMetaData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMetaData", AddMetaData);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMetaDataGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMetaDataGroup * metadatagroupInstance = new CLib3MFMetaDataGroup();
				metadatagroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMetaDataGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMetaDataGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMetaDataGroup::GetMetaDataCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataCount.");
        if (wrapperTable->m_MetaDataGroup_GetMetaDataCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::GetMetaDataCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_GetMetaDataCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::GetMetaData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnMetaData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaData.");
        if (wrapperTable->m_MetaDataGroup_GetMetaData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::GetMetaData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_GetMetaData(instanceHandle, nIndex, &hReturnMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaData = CLib3MFMetaData::NewInstance(args.Holder(), hReturnMetaData);
        args.GetReturnValue().Set(instanceObjMetaData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::GetMetaDataByKey(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (NameSpace)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        v8::String::Utf8Value sutf8NameSpace(isolate, args[0]);
        std::string sNameSpace = *sutf8NameSpace;
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        Lib3MFHandle hReturnMetaData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataByKey.");
        if (wrapperTable->m_MetaDataGroup_GetMetaDataByKey == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::GetMetaDataByKey.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_GetMetaDataByKey(instanceHandle, sNameSpace.c_str(), sName.c_str(), &hReturnMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaData = CLib3MFMetaData::NewInstance(args.Holder(), hReturnMetaData);
        args.GetReturnValue().Set(instanceObjMetaData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::RemoveMetaDataByIndex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMetaDataByIndex.");
        if (wrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::RemoveMetaDataByIndex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex(instanceHandle, nIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::RemoveMetaData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheMetaData)");
        }
        Local<Object> objTheMetaData = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFMetaData * instanceTheMetaData = ObjectWrap::Unwrap<CLib3MFMetaData>(objTheMetaData);
        if (instanceTheMetaData == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheMetaData)");
        Lib3MFHandle hTheMetaData = instanceTheMetaData->getHandle( objTheMetaData );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMetaData.");
        if (wrapperTable->m_MetaDataGroup_RemoveMetaData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::RemoveMetaData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_RemoveMetaData(instanceHandle, hTheMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMetaDataGroup::AddMetaData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (NameSpace)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Value)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Type)");
        }
        if (!args[4]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 4 (MustPreserve)");
        }
        v8::String::Utf8Value sutf8NameSpace(isolate, args[0]);
        std::string sNameSpace = *sutf8NameSpace;
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        v8::String::Utf8Value sutf8Value(isolate, args[2]);
        std::string sValue = *sutf8Value;
        v8::String::Utf8Value sutf8Type(isolate, args[3]);
        std::string sType = *sutf8Type;
        bool bMustPreserve = args[4]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnMetaData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMetaData.");
        if (wrapperTable->m_MetaDataGroup_AddMetaData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MetaDataGroup::AddMetaData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MetaDataGroup_AddMetaData(instanceHandle, sNameSpace.c_str(), sName.c_str(), sValue.c_str(), sType.c_str(), bMustPreserve, &hReturnMetaData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaData = CLib3MFMetaData::NewInstance(args.Holder(), hReturnMetaData);
        args.GetReturnValue().Set(instanceObjMetaData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTriangleSet Implementation
**************************************************************************************************************************/

CLib3MFTriangleSet::CLib3MFTriangleSet()
		: CLib3MFBaseClass()
{
}

CLib3MFTriangleSet::~CLib3MFTriangleSet()
{
}

void CLib3MFTriangleSet::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTriangleSet"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIdentifier", SetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentifier", GetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTriangle", AddTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveTriangle", RemoveTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Clear", Clear);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTriangleList", SetTriangleList);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleList", GetTriangleList);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTriangleList", AddTriangleList);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Merge", Merge);
		NODE_SET_PROTOTYPE_METHOD(tpl, "DeleteSet", DeleteSet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Duplicate", Duplicate);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTriangleSet::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTriangleSet * trianglesetInstance = new CLib3MFTriangleSet();
				trianglesetInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTriangleSet: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTriangleSet::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTriangleSet::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_TriangleSet_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_TriangleSet_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_TriangleSet_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::SetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIdentifier.");
        if (wrapperTable->m_TriangleSet_SetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::SetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_SetIdentifier(instanceHandle, sIdentifier.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::GetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededIdentifier = 0;
        unsigned int bytesWrittenIdentifier = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentifier.");
        if (wrapperTable->m_TriangleSet_GetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::GetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_TriangleSet_GetIdentifier(instanceHandle, 0, &bytesNeededIdentifier, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferIdentifier;
        bufferIdentifier.resize(bytesNeededIdentifier);
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_GetIdentifier(instanceHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferIdentifier[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::AddTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (TriangleIndex)");
        }
        unsigned int nTriangleIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTriangle.");
        if (wrapperTable->m_TriangleSet_AddTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::AddTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_AddTriangle(instanceHandle, nTriangleIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::RemoveTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (TriangleIndex)");
        }
        unsigned int nTriangleIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveTriangle.");
        if (wrapperTable->m_TriangleSet_RemoveTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::RemoveTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_RemoveTriangle(instanceHandle, nTriangleIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::Clear(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Clear.");
        if (wrapperTable->m_TriangleSet_Clear == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::Clear.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_Clear(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::SetTriangleList(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTriangleList.");
        if (wrapperTable->m_TriangleSet_SetTriangleList == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::SetTriangleList.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_SetTriangleList(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::GetTriangleList(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleList.");
        if (wrapperTable->m_TriangleSet_GetTriangleList == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::GetTriangleList.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_GetTriangleList(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::AddTriangleList(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTriangleList.");
        if (wrapperTable->m_TriangleSet_AddTriangleList == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::AddTriangleList.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_AddTriangleList(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::Merge(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (OtherTriangleSet)");
        }
        if (!args[1]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 1 (DeleteOther)");
        }
        Local<Object> objOtherTriangleSet = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFTriangleSet * instanceOtherTriangleSet = ObjectWrap::Unwrap<CLib3MFTriangleSet>(objOtherTriangleSet);
        if (instanceOtherTriangleSet == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (OtherTriangleSet)");
        Lib3MFHandle hOtherTriangleSet = instanceOtherTriangleSet->getHandle( objOtherTriangleSet );
        bool bDeleteOther = args[1]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Merge.");
        if (wrapperTable->m_TriangleSet_Merge == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::Merge.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_Merge(instanceHandle, hOtherTriangleSet, bDeleteOther);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::DeleteSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method DeleteSet.");
        if (wrapperTable->m_TriangleSet_DeleteSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::DeleteSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_DeleteSet(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTriangleSet::Duplicate(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        Lib3MFHandle hReturnNewSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Duplicate.");
        if (wrapperTable->m_TriangleSet_Duplicate == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TriangleSet::Duplicate.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TriangleSet_Duplicate(instanceHandle, sIdentifier.c_str(), &hReturnNewSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNewSet = CLib3MFTriangleSet::NewInstance(args.Holder(), hReturnNewSet);
        args.GetReturnValue().Set(instanceObjNewSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFObject Implementation
**************************************************************************************************************************/

CLib3MFObject::CLib3MFObject()
		: CLib3MFBaseClass()
{
}

CLib3MFObject::~CLib3MFObject()
{
}

void CLib3MFObject::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFObject"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetType", GetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetType", SetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPartNumber", GetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPartNumber", SetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsMeshObject", IsMeshObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsComponentsObject", IsComponentsObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsLevelSetObject", IsLevelSetObject);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsValid", IsValid);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAttachmentAsThumbnail", SetAttachmentAsThumbnail);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetThumbnailAttachment", GetThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClearThumbnailAttachment", ClearThumbnailAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutbox", GetOutbox);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataGroup", GetMetaDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetSlicesMeshResolution", SetSlicesMeshResolution);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSlicesMeshResolution", GetSlicesMeshResolution);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasSlices", HasSlices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClearSliceStack", ClearSliceStack);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceStack", GetSliceStack);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AssignSliceStack", AssignSliceStack);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFObject::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFObject * objectInstance = new CLib3MFObject();
				objectInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFObject: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFObject::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFObject::GetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFObjectType eReturnObjectType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetType.");
        if (wrapperTable->m_Object_GetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetType(instanceHandle, &eReturnObjectType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnObjectType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ObjectType)");
        }
        unsigned int eObjectType = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetType.");
        if (wrapperTable->m_Object_SetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetType(instanceHandle, (eLib3MFObjectType) eObjectType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_Object_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Object_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_Object_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_Object_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPartNumber = 0;
        unsigned int bytesWrittenPartNumber = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPartNumber.");
        if (wrapperTable->m_Object_GetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Object_GetPartNumber(instanceHandle, 0, &bytesNeededPartNumber, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPartNumber;
        bufferPartNumber.resize(bytesNeededPartNumber);
        Lib3MFResult errorCode = wrapperTable->m_Object_GetPartNumber(instanceHandle, bytesNeededPartNumber, &bytesWrittenPartNumber, &bufferPartNumber[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPartNumber[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (PartNumber)");
        }
        v8::String::Utf8Value sutf8PartNumber(isolate, args[0]);
        std::string sPartNumber = *sutf8PartNumber;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPartNumber.");
        if (wrapperTable->m_Object_SetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetPartNumber(instanceHandle, sPartNumber.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsMeshObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsMeshObject = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsMeshObject.");
        if (wrapperTable->m_Object_IsMeshObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsMeshObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsMeshObject(instanceHandle, &bReturnIsMeshObject);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsMeshObject));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsComponentsObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsComponentsObject = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsComponentsObject.");
        if (wrapperTable->m_Object_IsComponentsObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsComponentsObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsComponentsObject(instanceHandle, &bReturnIsComponentsObject);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsComponentsObject));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsLevelSetObject(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsLevelSetObject = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsLevelSetObject.");
        if (wrapperTable->m_Object_IsLevelSetObject == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsLevelSetObject.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsLevelSetObject(instanceHandle, &bReturnIsLevelSetObject);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsLevelSetObject));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::IsValid(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsValid = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsValid.");
        if (wrapperTable->m_Object_IsValid == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::IsValid.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_IsValid(instanceHandle, &bReturnIsValid);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsValid));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetAttachmentAsThumbnail(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Attachment)");
        }
        Local<Object> objAttachment = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceAttachment = ObjectWrap::Unwrap<CLib3MFAttachment>(objAttachment);
        if (instanceAttachment == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Attachment)");
        Lib3MFHandle hAttachment = instanceAttachment->getHandle( objAttachment );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAttachmentAsThumbnail.");
        if (wrapperTable->m_Object_SetAttachmentAsThumbnail == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetAttachmentAsThumbnail.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetAttachmentAsThumbnail(instanceHandle, hAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnAttachment = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetThumbnailAttachment.");
        if (wrapperTable->m_Object_GetThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetThumbnailAttachment(instanceHandle, &hReturnAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachment = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachment);
        args.GetReturnValue().Set(instanceObjAttachment);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::ClearThumbnailAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClearThumbnailAttachment.");
        if (wrapperTable->m_Object_ClearThumbnailAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::ClearThumbnailAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_ClearThumbnailAttachment(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetOutbox(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFBox sReturnOutbox;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutbox.");
        if (wrapperTable->m_Object_GetOutbox == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetOutbox.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetOutbox(instanceHandle, &sReturnOutbox);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBoxToObject(isolate, sReturnOutbox));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_Object_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Object_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_Object_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_Object_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetMetaDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMetaDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataGroup.");
        if (wrapperTable->m_Object_GetMetaDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetMetaDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetMetaDataGroup(instanceHandle, &hReturnMetaDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaDataGroup = CLib3MFMetaDataGroup::NewInstance(args.Holder(), hReturnMetaDataGroup);
        args.GetReturnValue().Set(instanceObjMetaDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::SetSlicesMeshResolution(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (MeshResolution)");
        }
        unsigned int eMeshResolution = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetSlicesMeshResolution.");
        if (wrapperTable->m_Object_SetSlicesMeshResolution == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::SetSlicesMeshResolution.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_SetSlicesMeshResolution(instanceHandle, (eLib3MFSlicesMeshResolution) eMeshResolution);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetSlicesMeshResolution(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFSlicesMeshResolution eReturnMeshResolution;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSlicesMeshResolution.");
        if (wrapperTable->m_Object_GetSlicesMeshResolution == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetSlicesMeshResolution.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetSlicesMeshResolution(instanceHandle, &eReturnMeshResolution);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnMeshResolution));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::HasSlices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (Recursive)");
        }
        bool bRecursive = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        bool bReturnHasSlices = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasSlices.");
        if (wrapperTable->m_Object_HasSlices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::HasSlices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_HasSlices(instanceHandle, bRecursive, &bReturnHasSlices);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasSlices));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::ClearSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClearSliceStack.");
        if (wrapperTable->m_Object_ClearSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::ClearSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_ClearSliceStack(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::GetSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnSliceStackInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceStack.");
        if (wrapperTable->m_Object_GetSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::GetSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_GetSliceStack(instanceHandle, &hReturnSliceStackInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSliceStackInstance = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnSliceStackInstance);
        args.GetReturnValue().Set(instanceObjSliceStackInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFObject::AssignSliceStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (SliceStackInstance)");
        }
        Local<Object> objSliceStackInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFSliceStack * instanceSliceStackInstance = ObjectWrap::Unwrap<CLib3MFSliceStack>(objSliceStackInstance);
        if (instanceSliceStackInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (SliceStackInstance)");
        Lib3MFHandle hSliceStackInstance = instanceSliceStackInstance->getHandle( objSliceStackInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AssignSliceStack.");
        if (wrapperTable->m_Object_AssignSliceStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Object::AssignSliceStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Object_AssignSliceStack(instanceHandle, hSliceStackInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMeshObject Implementation
**************************************************************************************************************************/

CLib3MFMeshObject::CLib3MFMeshObject()
		: CLib3MFBaseClass()
{
}

CLib3MFMeshObject::~CLib3MFMeshObject()
{
}

void CLib3MFMeshObject::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMeshObject"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertexCount", GetVertexCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleCount", GetTriangleCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertex", GetVertex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVertex", SetVertex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddVertex", AddVertex);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertices", GetVertices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangle", GetTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTriangle", SetTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTriangle", AddTriangle);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleIndices", GetTriangleIndices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetObjectLevelProperty", SetObjectLevelProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectLevelProperty", GetObjectLevelProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTriangleProperties", SetTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleProperties", GetTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAllTriangleProperties", SetAllTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllTriangleProperties", GetAllTriangleProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ClearAllProperties", ClearAllProperties);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetGeometry", SetGeometry);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsManifoldAndOriented", IsManifoldAndOriented);
		NODE_SET_PROTOTYPE_METHOD(tpl, "BeamLattice", BeamLattice);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVolumeData", GetVolumeData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVolumeData", SetVolumeData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTriangleSet", AddTriangleSet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasTriangleSet", HasTriangleSet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindTriangleSet", FindTriangleSet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleSetCount", GetTriangleSetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTriangleSet", GetTriangleSet);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMeshObject::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMeshObject * meshobjectInstance = new CLib3MFMeshObject();
				meshobjectInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMeshObject: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMeshObject::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMeshObject::GetVertexCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnVertexCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertexCount.");
        if (wrapperTable->m_MeshObject_GetVertexCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVertexCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVertexCount(instanceHandle, &nReturnVertexCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnVertexCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnVertexCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleCount.");
        if (wrapperTable->m_MeshObject_GetTriangleCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleCount(instanceHandle, &nReturnVertexCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnVertexCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetVertex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFPosition sReturnCoordinates;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertex.");
        if (wrapperTable->m_MeshObject_GetVertex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVertex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVertex(instanceHandle, nIndex, &sReturnCoordinates);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFPositionToObject(isolate, sReturnCoordinates));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetVertex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Coordinates)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFPosition sCoordinates = convertObjectToLib3MFPosition(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVertex.");
        if (wrapperTable->m_MeshObject_SetVertex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetVertex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetVertex(instanceHandle, nIndex, &sCoordinates);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::AddVertex(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Coordinates)");
        }
        sLib3MFPosition sCoordinates = convertObjectToLib3MFPosition(isolate, args[0]);
        unsigned int nReturnNewIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddVertex.");
        if (wrapperTable->m_MeshObject_AddVertex == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::AddVertex.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_AddVertex(instanceHandle, &sCoordinates, &nReturnNewIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnNewIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetVertices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertices.");
        if (wrapperTable->m_MeshObject_GetVertices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVertices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVertices(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangle sReturnIndices;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangle.");
        if (wrapperTable->m_MeshObject_GetTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangle(instanceHandle, nIndex, &sReturnIndices);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTriangleToObject(isolate, sReturnIndices));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Indices)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangle sIndices = convertObjectToLib3MFTriangle(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTriangle.");
        if (wrapperTable->m_MeshObject_SetTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetTriangle(instanceHandle, nIndex, &sIndices);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::AddTriangle(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Indices)");
        }
        sLib3MFTriangle sIndices = convertObjectToLib3MFTriangle(isolate, args[0]);
        unsigned int nReturnNewIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTriangle.");
        if (wrapperTable->m_MeshObject_AddTriangle == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::AddTriangle.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_AddTriangle(instanceHandle, &sIndices, &nReturnNewIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnNewIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleIndices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleIndices.");
        if (wrapperTable->m_MeshObject_GetTriangleIndices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleIndices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleIndices(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetObjectLevelProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 1 (PropertyID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nPropertyID = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetObjectLevelProperty.");
        if (wrapperTable->m_MeshObject_SetObjectLevelProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetObjectLevelProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetObjectLevelProperty(instanceHandle, nUniqueResourceID, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetObjectLevelProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        unsigned int nReturnUniqueResourceID = 0;
        unsigned int nReturnPropertyID = 0;
        bool bReturnHasObjectLevelProperty = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectLevelProperty.");
        if (wrapperTable->m_MeshObject_GetObjectLevelProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetObjectLevelProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetObjectLevelProperty(instanceHandle, &nReturnUniqueResourceID, &nReturnPropertyID, &bReturnHasObjectLevelProperty);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UniqueResourceID"), Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "PropertyID"), Integer::NewFromUnsigned(isolate, nReturnPropertyID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasObjectLevelProperty"), Boolean::New(isolate, bReturnHasObjectLevelProperty));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Properties)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangleProperties sProperties = convertObjectToLib3MFTriangleProperties(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTriangleProperties.");
        if (wrapperTable->m_MeshObject_SetTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetTriangleProperties(instanceHandle, nIndex, &sProperties);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTriangleProperties sReturnProperty;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleProperties.");
        if (wrapperTable->m_MeshObject_GetTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleProperties(instanceHandle, nIndex, &sReturnProperty);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTrianglePropertiesToObject(isolate, sReturnProperty));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetAllTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAllTriangleProperties.");
        if (wrapperTable->m_MeshObject_SetAllTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetAllTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetAllTriangleProperties(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetAllTriangleProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllTriangleProperties.");
        if (wrapperTable->m_MeshObject_GetAllTriangleProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetAllTriangleProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetAllTriangleProperties(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::ClearAllProperties(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ClearAllProperties.");
        if (wrapperTable->m_MeshObject_ClearAllProperties == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::ClearAllProperties.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_ClearAllProperties(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetGeometry(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetGeometry.");
        if (wrapperTable->m_MeshObject_SetGeometry == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetGeometry.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetGeometry(instanceHandle, 0, nullptr, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::IsManifoldAndOriented(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsManifoldAndOriented = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsManifoldAndOriented.");
        if (wrapperTable->m_MeshObject_IsManifoldAndOriented == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::IsManifoldAndOriented.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_IsManifoldAndOriented(instanceHandle, &bReturnIsManifoldAndOriented);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsManifoldAndOriented));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::BeamLattice(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheBeamLattice = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method BeamLattice.");
        if (wrapperTable->m_MeshObject_BeamLattice == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::BeamLattice.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_BeamLattice(instanceHandle, &hReturnTheBeamLattice);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheBeamLattice = CLib3MFBeamLattice::NewInstance(args.Holder(), hReturnTheBeamLattice);
        args.GetReturnValue().Set(instanceObjTheBeamLattice);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetVolumeData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheVolumeData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVolumeData.");
        if (wrapperTable->m_MeshObject_GetVolumeData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetVolumeData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetVolumeData(instanceHandle, &hReturnTheVolumeData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheVolumeData = CLib3MFVolumeData::NewInstance(args.Holder(), hReturnTheVolumeData);
        args.GetReturnValue().Set(instanceObjTheVolumeData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::SetVolumeData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheVolumeData)");
        }
        Local<Object> objTheVolumeData = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFVolumeData * instanceTheVolumeData = ObjectWrap::Unwrap<CLib3MFVolumeData>(objTheVolumeData);
        if (instanceTheVolumeData == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheVolumeData)");
        Lib3MFHandle hTheVolumeData = instanceTheVolumeData->getHandle( objTheVolumeData );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVolumeData.");
        if (wrapperTable->m_MeshObject_SetVolumeData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::SetVolumeData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_SetVolumeData(instanceHandle, hTheVolumeData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::AddTriangleSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        Lib3MFHandle hReturnTheTriangleSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTriangleSet.");
        if (wrapperTable->m_MeshObject_AddTriangleSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::AddTriangleSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_AddTriangleSet(instanceHandle, sIdentifier.c_str(), sName.c_str(), &hReturnTheTriangleSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheTriangleSet = CLib3MFTriangleSet::NewInstance(args.Holder(), hReturnTheTriangleSet);
        args.GetReturnValue().Set(instanceObjTheTriangleSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::HasTriangleSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        bool bReturnTriangleSetExists = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasTriangleSet.");
        if (wrapperTable->m_MeshObject_HasTriangleSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::HasTriangleSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_HasTriangleSet(instanceHandle, sIdentifier.c_str(), &bReturnTriangleSetExists);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnTriangleSetExists));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::FindTriangleSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        Lib3MFHandle hReturnTheTriangleSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindTriangleSet.");
        if (wrapperTable->m_MeshObject_FindTriangleSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::FindTriangleSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_FindTriangleSet(instanceHandle, sIdentifier.c_str(), &hReturnTheTriangleSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheTriangleSet = CLib3MFTriangleSet::NewInstance(args.Holder(), hReturnTheTriangleSet);
        args.GetReturnValue().Set(instanceObjTheTriangleSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleSetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleSetCount.");
        if (wrapperTable->m_MeshObject_GetTriangleSetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleSetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleSetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshObject::GetTriangleSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheTriangleSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTriangleSet.");
        if (wrapperTable->m_MeshObject_GetTriangleSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshObject::GetTriangleSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshObject_GetTriangleSet(instanceHandle, nIndex, &hReturnTheTriangleSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheTriangleSet = CLib3MFTriangleSet::NewInstance(args.Holder(), hReturnTheTriangleSet);
        args.GetReturnValue().Set(instanceObjTheTriangleSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFLevelSet Implementation
**************************************************************************************************************************/

CLib3MFLevelSet::CLib3MFLevelSet()
		: CLib3MFBaseClass()
{
}

CLib3MFLevelSet::~CLib3MFLevelSet()
{
}

void CLib3MFLevelSet::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFLevelSet"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFunction", GetFunction);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFunction", SetFunction);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTransform", GetTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTransform", SetTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetChannelName", GetChannelName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetChannelName", SetChannelName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMinFeatureSize", SetMinFeatureSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMinFeatureSize", GetMinFeatureSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFallBackValue", SetFallBackValue);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFallBackValue", GetFallBackValue);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMeshBBoxOnly", SetMeshBBoxOnly);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMeshBBoxOnly", GetMeshBBoxOnly);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMesh", SetMesh);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMesh", GetMesh);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVolumeData", GetVolumeData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVolumeData", SetVolumeData);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFLevelSet::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFLevelSet * levelsetInstance = new CLib3MFLevelSet();
				levelsetInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFLevelSet: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFLevelSet::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFLevelSet::GetFunction(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheFunction = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFunction.");
        if (wrapperTable->m_LevelSet_GetFunction == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetFunction.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetFunction(instanceHandle, &hReturnTheFunction);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheFunction = CLib3MFFunction::NewInstance(args.Holder(), hReturnTheFunction);
        args.GetReturnValue().Set(instanceObjTheFunction);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetFunction(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheFunction)");
        }
        Local<Object> objTheFunction = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFFunction * instanceTheFunction = ObjectWrap::Unwrap<CLib3MFFunction>(objTheFunction);
        if (instanceTheFunction == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheFunction)");
        Lib3MFHandle hTheFunction = instanceTheFunction->getHandle( objTheFunction );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFunction.");
        if (wrapperTable->m_LevelSet_SetFunction == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetFunction.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetFunction(instanceHandle, hTheFunction);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTransform.");
        if (wrapperTable->m_LevelSet_GetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetTransform(instanceHandle, &sReturnTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTransform.");
        if (wrapperTable->m_LevelSet_SetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetTransform(instanceHandle, &sTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetChannelName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededChannelName = 0;
        unsigned int bytesWrittenChannelName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetChannelName.");
        if (wrapperTable->m_LevelSet_GetChannelName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetChannelName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_LevelSet_GetChannelName(instanceHandle, 0, &bytesNeededChannelName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferChannelName;
        bufferChannelName.resize(bytesNeededChannelName);
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetChannelName(instanceHandle, bytesNeededChannelName, &bytesWrittenChannelName, &bufferChannelName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferChannelName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetChannelName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ChannelName)");
        }
        v8::String::Utf8Value sutf8ChannelName(isolate, args[0]);
        std::string sChannelName = *sutf8ChannelName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetChannelName.");
        if (wrapperTable->m_LevelSet_SetChannelName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetChannelName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetChannelName(instanceHandle, sChannelName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetMinFeatureSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (MinFeatureSize)");
        }
        double dMinFeatureSize = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMinFeatureSize.");
        if (wrapperTable->m_LevelSet_SetMinFeatureSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetMinFeatureSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetMinFeatureSize(instanceHandle, dMinFeatureSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetMinFeatureSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnMinFeatureSize = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMinFeatureSize.");
        if (wrapperTable->m_LevelSet_GetMinFeatureSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetMinFeatureSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetMinFeatureSize(instanceHandle, &dReturnMinFeatureSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnMinFeatureSize));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetFallBackValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (FallBackValue)");
        }
        double dFallBackValue = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFallBackValue.");
        if (wrapperTable->m_LevelSet_SetFallBackValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetFallBackValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetFallBackValue(instanceHandle, dFallBackValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetFallBackValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnFallBackValue = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFallBackValue.");
        if (wrapperTable->m_LevelSet_GetFallBackValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetFallBackValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetFallBackValue(instanceHandle, &dReturnFallBackValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnFallBackValue));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetMeshBBoxOnly(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (MeshBBoxOnly)");
        }
        bool bMeshBBoxOnly = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMeshBBoxOnly.");
        if (wrapperTable->m_LevelSet_SetMeshBBoxOnly == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetMeshBBoxOnly.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetMeshBBoxOnly(instanceHandle, bMeshBBoxOnly);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetMeshBBoxOnly(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnMeshBBoxOnly = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMeshBBoxOnly.");
        if (wrapperTable->m_LevelSet_GetMeshBBoxOnly == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetMeshBBoxOnly.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetMeshBBoxOnly(instanceHandle, &bReturnMeshBBoxOnly);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnMeshBBoxOnly));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetMesh(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheMesh)");
        }
        Local<Object> objTheMesh = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFMeshObject * instanceTheMesh = ObjectWrap::Unwrap<CLib3MFMeshObject>(objTheMesh);
        if (instanceTheMesh == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheMesh)");
        Lib3MFHandle hTheMesh = instanceTheMesh->getHandle( objTheMesh );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMesh.");
        if (wrapperTable->m_LevelSet_SetMesh == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetMesh.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetMesh(instanceHandle, hTheMesh);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetMesh(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheMesh = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMesh.");
        if (wrapperTable->m_LevelSet_GetMesh == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetMesh.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetMesh(instanceHandle, &hReturnTheMesh);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheMesh = CLib3MFMeshObject::NewInstance(args.Holder(), hReturnTheMesh);
        args.GetReturnValue().Set(instanceObjTheMesh);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::GetVolumeData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheVolumeData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVolumeData.");
        if (wrapperTable->m_LevelSet_GetVolumeData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::GetVolumeData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_GetVolumeData(instanceHandle, &hReturnTheVolumeData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheVolumeData = CLib3MFVolumeData::NewInstance(args.Holder(), hReturnTheVolumeData);
        args.GetReturnValue().Set(instanceObjTheVolumeData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFLevelSet::SetVolumeData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheVolumeData)");
        }
        Local<Object> objTheVolumeData = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFVolumeData * instanceTheVolumeData = ObjectWrap::Unwrap<CLib3MFVolumeData>(objTheVolumeData);
        if (instanceTheVolumeData == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheVolumeData)");
        Lib3MFHandle hTheVolumeData = instanceTheVolumeData->getHandle( objTheVolumeData );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVolumeData.");
        if (wrapperTable->m_LevelSet_SetVolumeData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method LevelSet::SetVolumeData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_LevelSet_SetVolumeData(instanceHandle, hTheVolumeData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBeamLattice Implementation
**************************************************************************************************************************/

CLib3MFBeamLattice::CLib3MFBeamLattice()
		: CLib3MFBaseClass()
{
}

CLib3MFBeamLattice::~CLib3MFBeamLattice()
{
}

void CLib3MFBeamLattice::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBeamLattice"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMinLength", GetMinLength);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMinLength", SetMinLength);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetClipping", GetClipping);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetClipping", SetClipping);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetRepresentation", GetRepresentation);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetRepresentation", SetRepresentation);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallOptions", GetBallOptions);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBallOptions", SetBallOptions);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeamCount", GetBeamCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeam", GetBeam);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBeam", AddBeam);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBeam", SetBeam);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBeams", SetBeams);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeams", GetBeams);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallCount", GetBallCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBall", GetBall);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBall", AddBall);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBall", SetBall);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBalls", SetBalls);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBalls", GetBalls);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeamSetCount", GetBeamSetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddBeamSet", AddBeamSet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBeamSet", GetBeamSet);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBeamLattice::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBeamLattice * beamlatticeInstance = new CLib3MFBeamLattice();
				beamlatticeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBeamLattice: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBeamLattice::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBeamLattice::GetMinLength(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnMinLength = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMinLength.");
        if (wrapperTable->m_BeamLattice_GetMinLength == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetMinLength.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetMinLength(instanceHandle, &dReturnMinLength);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnMinLength));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetMinLength(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (MinLength)");
        }
        double dMinLength = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMinLength.");
        if (wrapperTable->m_BeamLattice_SetMinLength == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetMinLength.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetMinLength(instanceHandle, dMinLength);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetClipping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFBeamLatticeClipMode eReturnClipMode;
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetClipping.");
        if (wrapperTable->m_BeamLattice_GetClipping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetClipping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetClipping(instanceHandle, &eReturnClipMode, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "ClipMode"), Integer::New(isolate, (int)eReturnClipMode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UniqueResourceID"), Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetClipping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ClipMode)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 1 (UniqueResourceID)");
        }
        unsigned int eClipMode = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int nUniqueResourceID = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetClipping.");
        if (wrapperTable->m_BeamLattice_SetClipping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetClipping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetClipping(instanceHandle, (eLib3MFBeamLatticeClipMode) eClipMode, nUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetRepresentation(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasRepresentation = false;
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetRepresentation.");
        if (wrapperTable->m_BeamLattice_GetRepresentation == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetRepresentation.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetRepresentation(instanceHandle, &bReturnHasRepresentation, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasRepresentation"), Boolean::New(isolate, bReturnHasRepresentation));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UniqueResourceID"), Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetRepresentation(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetRepresentation.");
        if (wrapperTable->m_BeamLattice_SetRepresentation == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetRepresentation.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetRepresentation(instanceHandle, nUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBallOptions(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFBeamLatticeBallMode eReturnBallMode;
        double dReturnBallRadius = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallOptions.");
        if (wrapperTable->m_BeamLattice_GetBallOptions == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBallOptions.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBallOptions(instanceHandle, &eReturnBallMode, &dReturnBallRadius);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "BallMode"), Integer::New(isolate, (int)eReturnBallMode));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "BallRadius"), Number::New(isolate, dReturnBallRadius));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBallOptions(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (BallMode)");
        }
        if (!args[1]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 1 (BallRadius)");
        }
        unsigned int eBallMode = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        double dBallRadius = (double) args[1]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBallOptions.");
        if (wrapperTable->m_BeamLattice_SetBallOptions == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBallOptions.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBallOptions(instanceHandle, (eLib3MFBeamLatticeBallMode) eBallMode, dBallRadius);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeamCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeamCount.");
        if (wrapperTable->m_BeamLattice_GetBeamCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeamCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeamCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeam(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBeam sReturnBeamInfo;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeam.");
        if (wrapperTable->m_BeamLattice_GetBeam == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeam.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeam(instanceHandle, nIndex, &sReturnBeamInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBeamToObject(isolate, sReturnBeamInfo));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::AddBeam(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (BeamInfo)");
        }
        sLib3MFBeam sBeamInfo = convertObjectToLib3MFBeam(isolate, args[0]);
        unsigned int nReturnIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBeam.");
        if (wrapperTable->m_BeamLattice_AddBeam == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::AddBeam.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_AddBeam(instanceHandle, &sBeamInfo, &nReturnIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBeam(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (BeamInfo)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBeam sBeamInfo = convertObjectToLib3MFBeam(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBeam.");
        if (wrapperTable->m_BeamLattice_SetBeam == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBeam.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBeam(instanceHandle, nIndex, &sBeamInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBeams(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBeams.");
        if (wrapperTable->m_BeamLattice_SetBeams == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBeams.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBeams(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeams(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeams.");
        if (wrapperTable->m_BeamLattice_GetBeams == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeams.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeams(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBallCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallCount.");
        if (wrapperTable->m_BeamLattice_GetBallCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBallCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBallCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBall(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBall sReturnBallInfo;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBall.");
        if (wrapperTable->m_BeamLattice_GetBall == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBall.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBall(instanceHandle, nIndex, &sReturnBallInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBallToObject(isolate, sReturnBallInfo));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::AddBall(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (BallInfo)");
        }
        sLib3MFBall sBallInfo = convertObjectToLib3MFBall(isolate, args[0]);
        unsigned int nReturnIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBall.");
        if (wrapperTable->m_BeamLattice_AddBall == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::AddBall.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_AddBall(instanceHandle, &sBallInfo, &nReturnIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBall(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (BallInfo)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFBall sBallInfo = convertObjectToLib3MFBall(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBall.");
        if (wrapperTable->m_BeamLattice_SetBall == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBall.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBall(instanceHandle, nIndex, &sBallInfo);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::SetBalls(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBalls.");
        if (wrapperTable->m_BeamLattice_SetBalls == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::SetBalls.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_SetBalls(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBalls(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBalls.");
        if (wrapperTable->m_BeamLattice_GetBalls == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBalls.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBalls(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeamSetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeamSetCount.");
        if (wrapperTable->m_BeamLattice_GetBeamSetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeamSetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeamSetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::AddBeamSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBeamSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddBeamSet.");
        if (wrapperTable->m_BeamLattice_AddBeamSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::AddBeamSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_AddBeamSet(instanceHandle, &hReturnBeamSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBeamSet = CLib3MFBeamSet::NewInstance(args.Holder(), hReturnBeamSet);
        args.GetReturnValue().Set(instanceObjBeamSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamLattice::GetBeamSet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnBeamSet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBeamSet.");
        if (wrapperTable->m_BeamLattice_GetBeamSet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamLattice::GetBeamSet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamLattice_GetBeamSet(instanceHandle, nIndex, &hReturnBeamSet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBeamSet = CLib3MFBeamSet::NewInstance(args.Holder(), hReturnBeamSet);
        args.GetReturnValue().Set(instanceObjBeamSet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFFunctionReference Implementation
**************************************************************************************************************************/

CLib3MFFunctionReference::CLib3MFFunctionReference()
		: CLib3MFBaseClass()
{
}

CLib3MFFunctionReference::~CLib3MFFunctionReference()
{
}

void CLib3MFFunctionReference::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFunctionReference"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFunctionResourceID", GetFunctionResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFunctionResourceID", SetFunctionResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTransform", GetTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTransform", SetTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetChannelName", GetChannelName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetChannelName", SetChannelName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMinFeatureSize", SetMinFeatureSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMinFeatureSize", GetMinFeatureSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFallBackValue", SetFallBackValue);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFallBackValue", GetFallBackValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFunctionReference::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFunctionReference * functionreferenceInstance = new CLib3MFFunctionReference();
				functionreferenceInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFunctionReference: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFunctionReference::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFFunctionReference::GetFunctionResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFunctionResourceID.");
        if (wrapperTable->m_FunctionReference_GetFunctionResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::GetFunctionResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_GetFunctionResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::SetFunctionResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (UniqueResourceID)");
        }
        unsigned int nUniqueResourceID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFunctionResourceID.");
        if (wrapperTable->m_FunctionReference_SetFunctionResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::SetFunctionResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_SetFunctionResourceID(instanceHandle, nUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::GetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTransform.");
        if (wrapperTable->m_FunctionReference_GetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::GetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_GetTransform(instanceHandle, &sReturnTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::SetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTransform.");
        if (wrapperTable->m_FunctionReference_SetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::SetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_SetTransform(instanceHandle, &sTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::GetChannelName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededChannelName = 0;
        unsigned int bytesWrittenChannelName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetChannelName.");
        if (wrapperTable->m_FunctionReference_GetChannelName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::GetChannelName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_FunctionReference_GetChannelName(instanceHandle, 0, &bytesNeededChannelName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferChannelName;
        bufferChannelName.resize(bytesNeededChannelName);
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_GetChannelName(instanceHandle, bytesNeededChannelName, &bytesWrittenChannelName, &bufferChannelName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferChannelName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::SetChannelName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ChannelName)");
        }
        v8::String::Utf8Value sutf8ChannelName(isolate, args[0]);
        std::string sChannelName = *sutf8ChannelName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetChannelName.");
        if (wrapperTable->m_FunctionReference_SetChannelName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::SetChannelName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_SetChannelName(instanceHandle, sChannelName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::SetMinFeatureSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (MinFeatureSize)");
        }
        double dMinFeatureSize = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMinFeatureSize.");
        if (wrapperTable->m_FunctionReference_SetMinFeatureSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::SetMinFeatureSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_SetMinFeatureSize(instanceHandle, dMinFeatureSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::GetMinFeatureSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnMinFeatureSize = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMinFeatureSize.");
        if (wrapperTable->m_FunctionReference_GetMinFeatureSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::GetMinFeatureSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_GetMinFeatureSize(instanceHandle, &dReturnMinFeatureSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnMinFeatureSize));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::SetFallBackValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (FallBackValue)");
        }
        double dFallBackValue = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFallBackValue.");
        if (wrapperTable->m_FunctionReference_SetFallBackValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::SetFallBackValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_SetFallBackValue(instanceHandle, dFallBackValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionReference::GetFallBackValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnFallBackValue = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFallBackValue.");
        if (wrapperTable->m_FunctionReference_GetFallBackValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionReference::GetFallBackValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionReference_GetFallBackValue(instanceHandle, &dReturnFallBackValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnFallBackValue));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFVolumeDataColor Implementation
**************************************************************************************************************************/

CLib3MFVolumeDataColor::CLib3MFVolumeDataColor()
		: CLib3MFBaseClass()
{
}

CLib3MFVolumeDataColor::~CLib3MFVolumeDataColor()
{
}

void CLib3MFVolumeDataColor::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFVolumeDataColor"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFVolumeDataColor::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFVolumeDataColor * volumedatacolorInstance = new CLib3MFVolumeDataColor();
				volumedatacolorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFVolumeDataColor: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFVolumeDataColor::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFMaterialMapping Implementation
**************************************************************************************************************************/

CLib3MFMaterialMapping::CLib3MFMaterialMapping()
		: CLib3MFBaseClass()
{
}

CLib3MFMaterialMapping::~CLib3MFMaterialMapping()
{
}

void CLib3MFMaterialMapping::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMaterialMapping"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMaterialMapping::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMaterialMapping * materialmappingInstance = new CLib3MFMaterialMapping();
				materialmappingInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMaterialMapping: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMaterialMapping::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFVolumeDataComposite Implementation
**************************************************************************************************************************/

CLib3MFVolumeDataComposite::CLib3MFVolumeDataComposite()
		: CLib3MFBaseClass()
{
}

CLib3MFVolumeDataComposite::~CLib3MFVolumeDataComposite()
{
}

void CLib3MFVolumeDataComposite::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFVolumeDataComposite"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBaseMaterialGroup", GetBaseMaterialGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBaseMaterialGroup", SetBaseMaterialGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMaterialMappingCount", GetMaterialMappingCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMaterialMapping", GetMaterialMapping);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMaterialMapping", AddMaterialMapping);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMaterialMapping", RemoveMaterialMapping);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFVolumeDataComposite::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFVolumeDataComposite * volumedatacompositeInstance = new CLib3MFVolumeDataComposite();
				volumedatacompositeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFVolumeDataComposite: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFVolumeDataComposite::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFVolumeDataComposite::GetBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBaseMaterialGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBaseMaterialGroup.");
        if (wrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataComposite::GetBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup(instanceHandle, &hReturnBaseMaterialGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBaseMaterialGroupInstance = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnBaseMaterialGroupInstance);
        args.GetReturnValue().Set(instanceObjBaseMaterialGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataComposite::SetBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (BaseMaterialGroupInstance)");
        }
        Local<Object> objBaseMaterialGroupInstance = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFBaseMaterialGroup * instanceBaseMaterialGroupInstance = ObjectWrap::Unwrap<CLib3MFBaseMaterialGroup>(objBaseMaterialGroupInstance);
        if (instanceBaseMaterialGroupInstance == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (BaseMaterialGroupInstance)");
        Lib3MFHandle hBaseMaterialGroupInstance = instanceBaseMaterialGroupInstance->getHandle( objBaseMaterialGroupInstance );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBaseMaterialGroup.");
        if (wrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataComposite::SetBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup(instanceHandle, hBaseMaterialGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataComposite::GetMaterialMappingCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMaterialMappingCount.");
        if (wrapperTable->m_VolumeDataComposite_GetMaterialMappingCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataComposite::GetMaterialMappingCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataComposite_GetMaterialMappingCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataComposite::GetMaterialMapping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheMaterialMapping = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMaterialMapping.");
        if (wrapperTable->m_VolumeDataComposite_GetMaterialMapping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataComposite::GetMaterialMapping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataComposite_GetMaterialMapping(instanceHandle, nIndex, &hReturnTheMaterialMapping);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheMaterialMapping = CLib3MFMaterialMapping::NewInstance(args.Holder(), hReturnTheMaterialMapping);
        args.GetReturnValue().Set(instanceObjTheMaterialMapping);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataComposite::AddMaterialMapping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        Lib3MFHandle hReturnTheMaterialMapping = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMaterialMapping.");
        if (wrapperTable->m_VolumeDataComposite_AddMaterialMapping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataComposite::AddMaterialMapping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataComposite_AddMaterialMapping(instanceHandle, &sTransform, &hReturnTheMaterialMapping);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheMaterialMapping = CLib3MFMaterialMapping::NewInstance(args.Holder(), hReturnTheMaterialMapping);
        args.GetReturnValue().Set(instanceObjTheMaterialMapping);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataComposite::RemoveMaterialMapping(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMaterialMapping.");
        if (wrapperTable->m_VolumeDataComposite_RemoveMaterialMapping == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataComposite::RemoveMaterialMapping.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataComposite_RemoveMaterialMapping(instanceHandle, nIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFVolumeDataProperty Implementation
**************************************************************************************************************************/

CLib3MFVolumeDataProperty::CLib3MFVolumeDataProperty()
		: CLib3MFBaseClass()
{
}

CLib3MFVolumeDataProperty::~CLib3MFVolumeDataProperty()
{
}

void CLib3MFVolumeDataProperty::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFVolumeDataProperty"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIsRequired", SetIsRequired);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsRequired", IsRequired);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFVolumeDataProperty::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFVolumeDataProperty * volumedatapropertyInstance = new CLib3MFVolumeDataProperty();
				volumedatapropertyInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFVolumeDataProperty: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFVolumeDataProperty::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFVolumeDataProperty::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPropertyName = 0;
        unsigned int bytesWrittenPropertyName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_VolumeDataProperty_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataProperty::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_VolumeDataProperty_GetName(instanceHandle, 0, &bytesNeededPropertyName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPropertyName;
        bufferPropertyName.resize(bytesNeededPropertyName);
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataProperty_GetName(instanceHandle, bytesNeededPropertyName, &bytesWrittenPropertyName, &bufferPropertyName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPropertyName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataProperty::SetIsRequired(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsBoolean()) {
            throw std::runtime_error("Expected bool parameter 0 (IsRequired)");
        }
        bool bIsRequired = args[0]->BooleanValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIsRequired.");
        if (wrapperTable->m_VolumeDataProperty_SetIsRequired == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataProperty::SetIsRequired.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataProperty_SetIsRequired(instanceHandle, bIsRequired);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeDataProperty::IsRequired(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsRequired = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsRequired.");
        if (wrapperTable->m_VolumeDataProperty_IsRequired == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeDataProperty::IsRequired.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeDataProperty_IsRequired(instanceHandle, &bReturnIsRequired);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsRequired));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFVolumeData Implementation
**************************************************************************************************************************/

CLib3MFVolumeData::CLib3MFVolumeData()
		: CLib3MFBaseClass()
{
}

CLib3MFVolumeData::~CLib3MFVolumeData()
{
}

void CLib3MFVolumeData::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFVolumeData"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComposite", GetComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreateNewComposite", CreateNewComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveComposite", RemoveComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetColor", GetColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreateNewColor", CreateNewColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveColor", RemoveColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPropertyCount", GetPropertyCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetProperty", GetProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddPropertyFromFunction", AddPropertyFromFunction);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveProperty", RemoveProperty);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFVolumeData::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFVolumeData * volumedataInstance = new CLib3MFVolumeData();
				volumedataInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFVolumeData: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFVolumeData::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFVolumeData::GetComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheCompositeData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComposite.");
        if (wrapperTable->m_VolumeData_GetComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::GetComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_GetComposite(instanceHandle, &hReturnTheCompositeData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheCompositeData = CLib3MFVolumeDataComposite::NewInstance(args.Holder(), hReturnTheCompositeData);
        args.GetReturnValue().Set(instanceObjTheCompositeData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::CreateNewComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheCompositeData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreateNewComposite.");
        if (wrapperTable->m_VolumeData_CreateNewComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::CreateNewComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_CreateNewComposite(instanceHandle, &hReturnTheCompositeData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheCompositeData = CLib3MFVolumeDataComposite::NewInstance(args.Holder(), hReturnTheCompositeData);
        args.GetReturnValue().Set(instanceObjTheCompositeData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::RemoveComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveComposite.");
        if (wrapperTable->m_VolumeData_RemoveComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::RemoveComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_RemoveComposite(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::GetColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTheColorData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetColor.");
        if (wrapperTable->m_VolumeData_GetColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::GetColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_GetColor(instanceHandle, &hReturnTheColorData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheColorData = CLib3MFVolumeDataColor::NewInstance(args.Holder(), hReturnTheColorData);
        args.GetReturnValue().Set(instanceObjTheColorData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::CreateNewColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheFunction)");
        }
        Local<Object> objTheFunction = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFFunction * instanceTheFunction = ObjectWrap::Unwrap<CLib3MFFunction>(objTheFunction);
        if (instanceTheFunction == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheFunction)");
        Lib3MFHandle hTheFunction = instanceTheFunction->getHandle( objTheFunction );
        Lib3MFHandle hReturnTheColorData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreateNewColor.");
        if (wrapperTable->m_VolumeData_CreateNewColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::CreateNewColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_CreateNewColor(instanceHandle, hTheFunction, &hReturnTheColorData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheColorData = CLib3MFVolumeDataColor::NewInstance(args.Holder(), hReturnTheColorData);
        args.GetReturnValue().Set(instanceObjTheColorData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::RemoveColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveColor.");
        if (wrapperTable->m_VolumeData_RemoveColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::RemoveColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_RemoveColor(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::GetPropertyCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPropertyCount.");
        if (wrapperTable->m_VolumeData_GetPropertyCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::GetPropertyCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_GetPropertyCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::GetProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheVolumeDataProperty = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetProperty.");
        if (wrapperTable->m_VolumeData_GetProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::GetProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_GetProperty(instanceHandle, nIndex, &hReturnTheVolumeDataProperty);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheVolumeDataProperty = CLib3MFVolumeDataProperty::NewInstance(args.Holder(), hReturnTheVolumeDataProperty);
        args.GetReturnValue().Set(instanceObjTheVolumeDataProperty);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::AddPropertyFromFunction(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected class parameter 1 (TheFunction)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        Local<Object> objTheFunction = args[1]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFFunction * instanceTheFunction = ObjectWrap::Unwrap<CLib3MFFunction>(objTheFunction);
        if (instanceTheFunction == nullptr)
            throw std::runtime_error("Invalid Object parameter 1 (TheFunction)");
        Lib3MFHandle hTheFunction = instanceTheFunction->getHandle( objTheFunction );
        Lib3MFHandle hReturnTheVolumeDataProperty = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddPropertyFromFunction.");
        if (wrapperTable->m_VolumeData_AddPropertyFromFunction == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::AddPropertyFromFunction.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_AddPropertyFromFunction(instanceHandle, sName.c_str(), hTheFunction, &hReturnTheVolumeDataProperty);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheVolumeDataProperty = CLib3MFVolumeDataProperty::NewInstance(args.Holder(), hReturnTheVolumeDataProperty);
        args.GetReturnValue().Set(instanceObjTheVolumeDataProperty);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFVolumeData::RemoveProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveProperty.");
        if (wrapperTable->m_VolumeData_RemoveProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method VolumeData::RemoveProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_VolumeData_RemoveProperty(instanceHandle, nIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComponent Implementation
**************************************************************************************************************************/

CLib3MFComponent::CLib3MFComponent()
		: CLib3MFBaseClass()
{
}

CLib3MFComponent::~CLib3MFComponent()
{
}

void CLib3MFComponent::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComponent"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResource", GetObjectResource);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResourceID", GetObjectResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasTransform", HasTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTransform", GetTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTransform", SetTransform);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComponent::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComponent * componentInstance = new CLib3MFComponent();
				componentInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComponent: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComponent::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComponent::GetObjectResource(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnObjectResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResource.");
        if (wrapperTable->m_Component_GetObjectResource == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetObjectResource.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_GetObjectResource(instanceHandle, &hReturnObjectResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjObjectResource = CLib3MFObject::NewInstance(args.Holder(), hReturnObjectResource);
        args.GetReturnValue().Set(instanceObjObjectResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::GetObjectResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResourceID.");
        if (wrapperTable->m_Component_GetObjectResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetObjectResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_GetObjectResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_Component_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Component_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_Component_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_Component_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::HasTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasTransform = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasTransform.");
        if (wrapperTable->m_Component_HasTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::HasTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_HasTransform(instanceHandle, &bReturnHasTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::GetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTransform.");
        if (wrapperTable->m_Component_GetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::GetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_GetTransform(instanceHandle, &sReturnTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponent::SetTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTransform.");
        if (wrapperTable->m_Component_SetTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Component::SetTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Component_SetTransform(instanceHandle, &sTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComponentsObject Implementation
**************************************************************************************************************************/

CLib3MFComponentsObject::CLib3MFComponentsObject()
		: CLib3MFBaseClass()
{
}

CLib3MFComponentsObject::~CLib3MFComponentsObject()
{
}

void CLib3MFComponentsObject::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComponentsObject"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComponent", AddComponent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComponent", GetComponent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComponentCount", GetComponentCount);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComponentsObject::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComponentsObject * componentsobjectInstance = new CLib3MFComponentsObject();
				componentsobjectInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComponentsObject: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComponentsObject::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComponentsObject::AddComponent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ObjectResource)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (Transform)");
        }
        Local<Object> objObjectResource = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFObject * instanceObjectResource = ObjectWrap::Unwrap<CLib3MFObject>(objObjectResource);
        if (instanceObjectResource == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ObjectResource)");
        Lib3MFHandle hObjectResource = instanceObjectResource->getHandle( objObjectResource );
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[1]);
        Lib3MFHandle hReturnComponentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComponent.");
        if (wrapperTable->m_ComponentsObject_AddComponent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObject::AddComponent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObject_AddComponent(instanceHandle, hObjectResource, &sTransform, &hReturnComponentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjComponentInstance = CLib3MFComponent::NewInstance(args.Holder(), hReturnComponentInstance);
        args.GetReturnValue().Set(instanceObjComponentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponentsObject::GetComponent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnComponentInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComponent.");
        if (wrapperTable->m_ComponentsObject_GetComponent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObject::GetComponent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObject_GetComponent(instanceHandle, nIndex, &hReturnComponentInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjComponentInstance = CLib3MFComponent::NewInstance(args.Holder(), hReturnComponentInstance);
        args.GetReturnValue().Set(instanceObjComponentInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComponentsObject::GetComponentCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComponentCount.");
        if (wrapperTable->m_ComponentsObject_GetComponentCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComponentsObject::GetComponentCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComponentsObject_GetComponentCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBeamSet Implementation
**************************************************************************************************************************/

CLib3MFBeamSet::CLib3MFBeamSet()
		: CLib3MFBaseClass()
{
}

CLib3MFBeamSet::~CLib3MFBeamSet()
{
}

void CLib3MFBeamSet::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBeamSet"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIdentifier", SetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentifier", GetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetReferenceCount", GetReferenceCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetReferences", SetReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetReferences", GetReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallReferenceCount", GetBallReferenceCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetBallReferences", SetBallReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBallReferences", GetBallReferences);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBeamSet::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBeamSet * beamsetInstance = new CLib3MFBeamSet();
				beamsetInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBeamSet: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBeamSet::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBeamSet::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_BeamSet_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_BeamSet_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BeamSet_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::SetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIdentifier.");
        if (wrapperTable->m_BeamSet_SetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetIdentifier(instanceHandle, sIdentifier.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededIdentifier = 0;
        unsigned int bytesWrittenIdentifier = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentifier.");
        if (wrapperTable->m_BeamSet_GetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BeamSet_GetIdentifier(instanceHandle, 0, &bytesNeededIdentifier, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferIdentifier;
        bufferIdentifier.resize(bytesNeededIdentifier);
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetIdentifier(instanceHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferIdentifier[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetReferenceCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetReferenceCount.");
        if (wrapperTable->m_BeamSet_GetReferenceCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetReferenceCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetReferenceCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::SetReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetReferences.");
        if (wrapperTable->m_BeamSet_SetReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetReferences(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetReferences.");
        if (wrapperTable->m_BeamSet_GetReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetReferences(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetBallReferenceCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallReferenceCount.");
        if (wrapperTable->m_BeamSet_GetBallReferenceCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetBallReferenceCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetBallReferenceCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::SetBallReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetBallReferences.");
        if (wrapperTable->m_BeamSet_SetBallReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::SetBallReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_SetBallReferences(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBeamSet::GetBallReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBallReferences.");
        if (wrapperTable->m_BeamSet_GetBallReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BeamSet::GetBallReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BeamSet_GetBallReferences(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroup Implementation
**************************************************************************************************************************/

CLib3MFBaseMaterialGroup::CLib3MFBaseMaterialGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFBaseMaterialGroup::~CLib3MFBaseMaterialGroup()
{
}

void CLib3MFBaseMaterialGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBaseMaterialGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMaterial", AddMaterial);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMaterial", RemoveMaterial);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDisplayColor", SetDisplayColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDisplayColor", GetDisplayColor);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBaseMaterialGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBaseMaterialGroup * basematerialgroupInstance = new CLib3MFBaseMaterialGroup();
				basematerialgroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBaseMaterialGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBaseMaterialGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBaseMaterialGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_BaseMaterialGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::AddMaterial(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (DisplayColor)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFColor sDisplayColor = convertObjectToLib3MFColor(isolate, args[1]);
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMaterial.");
        if (wrapperTable->m_BaseMaterialGroup_AddMaterial == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::AddMaterial.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_AddMaterial(instanceHandle, sName.c_str(), &sDisplayColor, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::RemoveMaterial(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMaterial.");
        if (wrapperTable->m_BaseMaterialGroup_RemoveMaterial == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::RemoveMaterial.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_RemoveMaterial(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_BaseMaterialGroup_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BaseMaterialGroup_GetName(instanceHandle, nPropertyID, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetName(instanceHandle, nPropertyID, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Name)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8Name(isolate, args[1]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_BaseMaterialGroup_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_SetName(instanceHandle, nPropertyID, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::SetDisplayColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (TheColor)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDisplayColor.");
        if (wrapperTable->m_BaseMaterialGroup_SetDisplayColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::SetDisplayColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_SetDisplayColor(instanceHandle, nPropertyID, &sTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBaseMaterialGroup::GetDisplayColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sReturnTheColor;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDisplayColor.");
        if (wrapperTable->m_BaseMaterialGroup_GetDisplayColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BaseMaterialGroup::GetDisplayColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BaseMaterialGroup_GetDisplayColor(instanceHandle, nPropertyID, &sReturnTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFColorToObject(isolate, sReturnTheColor));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFColorGroup Implementation
**************************************************************************************************************************/

CLib3MFColorGroup::CLib3MFColorGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFColorGroup::~CLib3MFColorGroup()
{
}

void CLib3MFColorGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFColorGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddColor", AddColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveColor", RemoveColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetColor", SetColor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetColor", GetColor);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFColorGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFColorGroup * colorgroupInstance = new CLib3MFColorGroup();
				colorgroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFColorGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFColorGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFColorGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_ColorGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_ColorGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::AddColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (TheColor)");
        }
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[0]);
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddColor.");
        if (wrapperTable->m_ColorGroup_AddColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::AddColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_AddColor(instanceHandle, &sTheColor, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::RemoveColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveColor.");
        if (wrapperTable->m_ColorGroup_RemoveColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::RemoveColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_RemoveColor(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::SetColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 1 (TheColor)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sTheColor = convertObjectToLib3MFColor(isolate, args[1]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetColor.");
        if (wrapperTable->m_ColorGroup_SetColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::SetColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_SetColor(instanceHandle, nPropertyID, &sTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFColorGroup::GetColor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFColor sReturnTheColor;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetColor.");
        if (wrapperTable->m_ColorGroup_GetColor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ColorGroup::GetColor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ColorGroup_GetColor(instanceHandle, nPropertyID, &sReturnTheColor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFColorToObject(isolate, sReturnTheColor));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroup Implementation
**************************************************************************************************************************/

CLib3MFTexture2DGroup::CLib3MFTexture2DGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2DGroup::~CLib3MFTexture2DGroup()
{
}

void CLib3MFTexture2DGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2DGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTex2Coord", AddTex2Coord);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTex2Coord", GetTex2Coord);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveTex2Coord", RemoveTex2Coord);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTexture2D", GetTexture2D);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2DGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2DGroup * texture2dgroupInstance = new CLib3MFTexture2DGroup();
				texture2dgroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2DGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2DGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2DGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_Texture2DGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_Texture2DGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::AddTex2Coord(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (UVCoordinate)");
        }
        sLib3MFTex2Coord sUVCoordinate = convertObjectToLib3MFTex2Coord(isolate, args[0]);
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTex2Coord.");
        if (wrapperTable->m_Texture2DGroup_AddTex2Coord == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::AddTex2Coord.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_AddTex2Coord(instanceHandle, &sUVCoordinate, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::GetTex2Coord(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFTex2Coord sReturnUVCoordinate;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTex2Coord.");
        if (wrapperTable->m_Texture2DGroup_GetTex2Coord == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetTex2Coord.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetTex2Coord(instanceHandle, nPropertyID, &sReturnUVCoordinate);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTex2CoordToObject(isolate, sReturnUVCoordinate));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::RemoveTex2Coord(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveTex2Coord.");
        if (wrapperTable->m_Texture2DGroup_RemoveTex2Coord == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::RemoveTex2Coord.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_RemoveTex2Coord(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2DGroup::GetTexture2D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnTexture2DInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTexture2D.");
        if (wrapperTable->m_Texture2DGroup_GetTexture2D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2DGroup::GetTexture2D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2DGroup_GetTexture2D(instanceHandle, &hReturnTexture2DInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTexture2DInstance = CLib3MFTexture2D::NewInstance(args.Holder(), hReturnTexture2DInstance);
        args.GetReturnValue().Set(instanceObjTexture2DInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterials Implementation
**************************************************************************************************************************/

CLib3MFCompositeMaterials::CLib3MFCompositeMaterials()
		: CLib3MFBaseClass()
{
}

CLib3MFCompositeMaterials::~CLib3MFCompositeMaterials()
{
}

void CLib3MFCompositeMaterials::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCompositeMaterials"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBaseMaterialGroup", GetBaseMaterialGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComposite", AddComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveComposite", RemoveComposite);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetComposite", GetComposite);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCompositeMaterials::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCompositeMaterials * compositematerialsInstance = new CLib3MFCompositeMaterials();
				compositematerialsInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCompositeMaterials: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCompositeMaterials::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFCompositeMaterials::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_CompositeMaterials_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_CompositeMaterials_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::GetBaseMaterialGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBaseMaterialGroupInstance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBaseMaterialGroup.");
        if (wrapperTable->m_CompositeMaterials_GetBaseMaterialGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetBaseMaterialGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetBaseMaterialGroup(instanceHandle, &hReturnBaseMaterialGroupInstance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBaseMaterialGroupInstance = CLib3MFBaseMaterialGroup::NewInstance(args.Holder(), hReturnBaseMaterialGroupInstance);
        args.GetReturnValue().Set(instanceObjBaseMaterialGroupInstance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::AddComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComposite.");
        if (wrapperTable->m_CompositeMaterials_AddComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::AddComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_AddComposite(instanceHandle, 0, nullptr, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::RemoveComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveComposite.");
        if (wrapperTable->m_CompositeMaterials_RemoveComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::RemoveComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_RemoveComposite(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFCompositeMaterials::GetComposite(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetComposite.");
        if (wrapperTable->m_CompositeMaterials_GetComposite == nullptr)
            throw std::runtime_error("Could not call Lib3MF method CompositeMaterials::GetComposite.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_CompositeMaterials_GetComposite(instanceHandle, nPropertyID, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroup Implementation
**************************************************************************************************************************/

CLib3MFMultiPropertyGroup::CLib3MFMultiPropertyGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFMultiPropertyGroup::~CLib3MFMultiPropertyGroup()
{
}

void CLib3MFMultiPropertyGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMultiPropertyGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCount", GetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAllPropertyIDs", GetAllPropertyIDs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMultiProperty", AddMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMultiProperty", SetMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMultiProperty", GetMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveMultiProperty", RemoveMultiProperty);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLayerCount", GetLayerCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLayer", AddLayer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetLayer", GetLayer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveLayer", RemoveLayer);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMultiPropertyGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMultiPropertyGroup * multipropertygroupInstance = new CLib3MFMultiPropertyGroup();
				multipropertygroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMultiPropertyGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMultiPropertyGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMultiPropertyGroup::GetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCount.");
        if (wrapperTable->m_MultiPropertyGroup_GetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetAllPropertyIDs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAllPropertyIDs.");
        if (wrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetAllPropertyIDs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::AddMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnPropertyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_AddMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::AddMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_AddMultiProperty(instanceHandle, 0, nullptr, &nReturnPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnPropertyID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::SetMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_SetMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::SetMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_SetMultiProperty(instanceHandle, nPropertyID, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_GetMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetMultiProperty(instanceHandle, nPropertyID, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::RemoveMultiProperty(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (PropertyID)");
        }
        unsigned int nPropertyID = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveMultiProperty.");
        if (wrapperTable->m_MultiPropertyGroup_RemoveMultiProperty == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::RemoveMultiProperty.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_RemoveMultiProperty(instanceHandle, nPropertyID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetLayerCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLayerCount.");
        if (wrapperTable->m_MultiPropertyGroup_GetLayerCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetLayerCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetLayerCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::AddLayer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (TheLayer)");
        }
        sLib3MFMultiPropertyLayer sTheLayer = convertObjectToLib3MFMultiPropertyLayer(isolate, args[0]);
        unsigned int nReturnLayerIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLayer.");
        if (wrapperTable->m_MultiPropertyGroup_AddLayer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::AddLayer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_AddLayer(instanceHandle, &sTheLayer, &nReturnLayerIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnLayerIndex));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::GetLayer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (LayerIndex)");
        }
        unsigned int nLayerIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFMultiPropertyLayer sReturnTheLayer;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetLayer.");
        if (wrapperTable->m_MultiPropertyGroup_GetLayer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::GetLayer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_GetLayer(instanceHandle, nLayerIndex, &sReturnTheLayer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFMultiPropertyLayerToObject(isolate, sReturnTheLayer));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMultiPropertyGroup::RemoveLayer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (LayerIndex)");
        }
        unsigned int nLayerIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveLayer.");
        if (wrapperTable->m_MultiPropertyGroup_RemoveLayer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MultiPropertyGroup::RemoveLayer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MultiPropertyGroup_RemoveLayer(instanceHandle, nLayerIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImage3D Implementation
**************************************************************************************************************************/

CLib3MFImage3D::CLib3MFImage3D()
		: CLib3MFBaseClass()
{
}

CLib3MFImage3D::~CLib3MFImage3D()
{
}

void CLib3MFImage3D::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImage3D"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetName", GetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetName", SetName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "IsImageStack", IsImageStack);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImage3D::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImage3D * image3dInstance = new CLib3MFImage3D();
				image3dInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImage3D: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImage3D::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImage3D::GetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededName = 0;
        unsigned int bytesWrittenName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetName.");
        if (wrapperTable->m_Image3D_GetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Image3D::GetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Image3D_GetName(instanceHandle, 0, &bytesNeededName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferName;
        bufferName.resize(bytesNeededName);
        Lib3MFResult errorCode = wrapperTable->m_Image3D_GetName(instanceHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImage3D::SetName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Name)");
        }
        v8::String::Utf8Value sutf8Name(isolate, args[0]);
        std::string sName = *sutf8Name;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetName.");
        if (wrapperTable->m_Image3D_SetName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Image3D::SetName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Image3D_SetName(instanceHandle, sName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImage3D::IsImageStack(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnIsImageStack = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method IsImageStack.");
        if (wrapperTable->m_Image3D_IsImageStack == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Image3D::IsImageStack.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Image3D_IsImageStack(instanceHandle, &bReturnIsImageStack);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnIsImageStack));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImageStack Implementation
**************************************************************************************************************************/

CLib3MFImageStack::CLib3MFImageStack()
		: CLib3MFBaseClass()
{
}

CLib3MFImageStack::~CLib3MFImageStack()
{
}

void CLib3MFImageStack::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImageStack"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetRowCount", GetRowCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetRowCount", SetRowCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetColumnCount", GetColumnCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetColumnCount", SetColumnCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSheetCount", GetSheetCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSheet", GetSheet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetSheet", SetSheet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreateEmptySheet", CreateEmptySheet);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreateSheetFromBuffer", CreateSheetFromBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CreateSheetFromFile", CreateSheetFromFile);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImageStack::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImageStack * imagestackInstance = new CLib3MFImageStack();
				imagestackInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImageStack: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImageStack::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImageStack::GetRowCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnRowCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetRowCount.");
        if (wrapperTable->m_ImageStack_GetRowCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::GetRowCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_GetRowCount(instanceHandle, &nReturnRowCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnRowCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::SetRowCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (RowCount)");
        }
        unsigned int nRowCount = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetRowCount.");
        if (wrapperTable->m_ImageStack_SetRowCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::SetRowCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_SetRowCount(instanceHandle, nRowCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::GetColumnCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnColumnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetColumnCount.");
        if (wrapperTable->m_ImageStack_GetColumnCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::GetColumnCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_GetColumnCount(instanceHandle, &nReturnColumnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnColumnCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::SetColumnCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (ColumnCount)");
        }
        unsigned int nColumnCount = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetColumnCount.");
        if (wrapperTable->m_ImageStack_SetColumnCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::SetColumnCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_SetColumnCount(instanceHandle, nColumnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::GetSheetCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnSheetCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSheetCount.");
        if (wrapperTable->m_ImageStack_GetSheetCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::GetSheetCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_GetSheetCount(instanceHandle, &nReturnSheetCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnSheetCount));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::GetSheet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnSheet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSheet.");
        if (wrapperTable->m_ImageStack_GetSheet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::GetSheet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_GetSheet(instanceHandle, nIndex, &hReturnSheet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSheet = CLib3MFAttachment::NewInstance(args.Holder(), hReturnSheet);
        args.GetReturnValue().Set(instanceObjSheet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::SetSheet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected class parameter 1 (Sheet)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Local<Object> objSheet = args[1]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceSheet = ObjectWrap::Unwrap<CLib3MFAttachment>(objSheet);
        if (instanceSheet == nullptr)
            throw std::runtime_error("Invalid Object parameter 1 (Sheet)");
        Lib3MFHandle hSheet = instanceSheet->getHandle( objSheet );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetSheet.");
        if (wrapperTable->m_ImageStack_SetSheet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::SetSheet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_SetSheet(instanceHandle, nIndex, hSheet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::CreateEmptySheet(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Path)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8Path(isolate, args[1]);
        std::string sPath = *sutf8Path;
        Lib3MFHandle hReturnSheet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreateEmptySheet.");
        if (wrapperTable->m_ImageStack_CreateEmptySheet == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::CreateEmptySheet.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_CreateEmptySheet(instanceHandle, nIndex, sPath.c_str(), &hReturnSheet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSheet = CLib3MFAttachment::NewInstance(args.Holder(), hReturnSheet);
        args.GetReturnValue().Set(instanceObjSheet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::CreateSheetFromBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Path)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8Path(isolate, args[1]);
        std::string sPath = *sutf8Path;
        Lib3MFHandle hReturnSheet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreateSheetFromBuffer.");
        if (wrapperTable->m_ImageStack_CreateSheetFromBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::CreateSheetFromBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_CreateSheetFromBuffer(instanceHandle, nIndex, sPath.c_str(), 0, nullptr, &hReturnSheet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSheet = CLib3MFAttachment::NewInstance(args.Holder(), hReturnSheet);
        args.GetReturnValue().Set(instanceObjSheet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImageStack::CreateSheetFromFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected uint32 parameter 0 (Index)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Path)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (FileName)");
        }
        unsigned int nIndex = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8Path(isolate, args[1]);
        std::string sPath = *sutf8Path;
        v8::String::Utf8Value sutf8FileName(isolate, args[2]);
        std::string sFileName = *sutf8FileName;
        Lib3MFHandle hReturnSheet = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CreateSheetFromFile.");
        if (wrapperTable->m_ImageStack_CreateSheetFromFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImageStack::CreateSheetFromFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImageStack_CreateSheetFromFile(instanceHandle, nIndex, sPath.c_str(), sFileName.c_str(), &hReturnSheet);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjSheet = CLib3MFAttachment::NewInstance(args.Holder(), hReturnSheet);
        args.GetReturnValue().Set(instanceObjSheet);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFAttachment Implementation
**************************************************************************************************************************/

CLib3MFAttachment::CLib3MFAttachment()
		: CLib3MFBaseClass()
{
}

CLib3MFAttachment::~CLib3MFAttachment()
{
}

void CLib3MFAttachment::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFAttachment"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPath", GetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPath", SetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "PackagePart", PackagePart);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetRelationShipType", GetRelationShipType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetRelationShipType", SetRelationShipType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToFile", WriteToFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromFile", ReadFromFile);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromCallback", ReadFromCallback);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetStreamSize", GetStreamSize);
		NODE_SET_PROTOTYPE_METHOD(tpl, "WriteToBuffer", WriteToBuffer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "ReadFromBuffer", ReadFromBuffer);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFAttachment::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFAttachment * attachmentInstance = new CLib3MFAttachment();
				attachmentInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFAttachment: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFAttachment::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFAttachment::GetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPath.");
        if (wrapperTable->m_Attachment_GetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::GetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Attachment_GetPath(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_Attachment_GetPath(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::SetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPath.");
        if (wrapperTable->m_Attachment_SetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::SetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_SetPath(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::PackagePart(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPackagePart = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method PackagePart.");
        if (wrapperTable->m_Attachment_PackagePart == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::PackagePart.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_PackagePart(instanceHandle, &hReturnPackagePart);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPackagePart = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnPackagePart);
        args.GetReturnValue().Set(instanceObjPackagePart);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::GetRelationShipType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetRelationShipType.");
        if (wrapperTable->m_Attachment_GetRelationShipType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::GetRelationShipType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Attachment_GetRelationShipType(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_Attachment_GetRelationShipType(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::SetRelationShipType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetRelationShipType.");
        if (wrapperTable->m_Attachment_SetRelationShipType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::SetRelationShipType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_SetRelationShipType(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::WriteToFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (FileName)");
        }
        v8::String::Utf8Value sutf8FileName(isolate, args[0]);
        std::string sFileName = *sutf8FileName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToFile.");
        if (wrapperTable->m_Attachment_WriteToFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::WriteToFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_WriteToFile(instanceHandle, sFileName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::ReadFromFile(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (FileName)");
        }
        v8::String::Utf8Value sutf8FileName(isolate, args[0]);
        std::string sFileName = *sutf8FileName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromFile.");
        if (wrapperTable->m_Attachment_ReadFromFile == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::ReadFromFile.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_ReadFromFile(instanceHandle, sFileName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::ReadFromCallback(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 1 (StreamSize)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected pointer parameter 3 (UserData)");
        }
        v8::String::Utf8Value sutf8StreamSize(isolate, args[1]);
        std::string sStreamSize = *sutf8StreamSize;
        uint64_t nStreamSize = stoull(sStreamSize);
        v8::String::Utf8Value sutf8UserData(isolate, args[3]);
        std::string sUserData = *sutf8UserData;
        uint64_t nUserData = stoull(sUserData);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromCallback.");
        if (wrapperTable->m_Attachment_ReadFromCallback == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::ReadFromCallback.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_ReadFromCallback(instanceHandle, nullptr, nStreamSize, nullptr, (void*) nUserData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::GetStreamSize(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnStreamSize = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetStreamSize.");
        if (wrapperTable->m_Attachment_GetStreamSize == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::GetStreamSize.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_GetStreamSize(instanceHandle, &nReturnStreamSize);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnStreamSize).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::WriteToBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method WriteToBuffer.");
        if (wrapperTable->m_Attachment_WriteToBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::WriteToBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_WriteToBuffer(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAttachment::ReadFromBuffer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method ReadFromBuffer.");
        if (wrapperTable->m_Attachment_ReadFromBuffer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Attachment::ReadFromBuffer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Attachment_ReadFromBuffer(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTexture2D Implementation
**************************************************************************************************************************/

CLib3MFTexture2D::CLib3MFTexture2D()
		: CLib3MFBaseClass()
{
}

CLib3MFTexture2D::~CLib3MFTexture2D()
{
}

void CLib3MFTexture2D::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTexture2D"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAttachment", GetAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAttachment", SetAttachment);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetContentType", GetContentType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetContentType", SetContentType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTileStyleUV", GetTileStyleUV);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTileStyleUV", SetTileStyleUV);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFilter", GetFilter);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFilter", SetFilter);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTexture2D::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTexture2D * texture2dInstance = new CLib3MFTexture2D();
				texture2dInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTexture2D: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTexture2D::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTexture2D::GetAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnAttachment = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAttachment.");
        if (wrapperTable->m_Texture2D_GetAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetAttachment(instanceHandle, &hReturnAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjAttachment = CLib3MFAttachment::NewInstance(args.Holder(), hReturnAttachment);
        args.GetReturnValue().Set(instanceObjAttachment);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetAttachment(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Attachment)");
        }
        Local<Object> objAttachment = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFAttachment * instanceAttachment = ObjectWrap::Unwrap<CLib3MFAttachment>(objAttachment);
        if (instanceAttachment == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Attachment)");
        Lib3MFHandle hAttachment = instanceAttachment->getHandle( objAttachment );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAttachment.");
        if (wrapperTable->m_Texture2D_SetAttachment == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetAttachment.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetAttachment(instanceHandle, hAttachment);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::GetContentType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFTextureType eReturnContentType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetContentType.");
        if (wrapperTable->m_Texture2D_GetContentType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetContentType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetContentType(instanceHandle, &eReturnContentType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnContentType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetContentType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ContentType)");
        }
        unsigned int eContentType = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetContentType.");
        if (wrapperTable->m_Texture2D_SetContentType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetContentType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetContentType(instanceHandle, (eLib3MFTextureType) eContentType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::GetTileStyleUV(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFTextureTileStyle eReturnTileStyleU;
        eLib3MFTextureTileStyle eReturnTileStyleV;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTileStyleUV.");
        if (wrapperTable->m_Texture2D_GetTileStyleUV == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetTileStyleUV.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetTileStyleUV(instanceHandle, &eReturnTileStyleU, &eReturnTileStyleV);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleU"), Integer::New(isolate, (int)eReturnTileStyleU));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleV"), Integer::New(isolate, (int)eReturnTileStyleV));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetTileStyleUV(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (TileStyleU)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (TileStyleV)");
        }
        unsigned int eTileStyleU = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eTileStyleV = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTileStyleUV.");
        if (wrapperTable->m_Texture2D_SetTileStyleUV == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetTileStyleUV.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetTileStyleUV(instanceHandle, (eLib3MFTextureTileStyle) eTileStyleU, (eLib3MFTextureTileStyle) eTileStyleV);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::GetFilter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFTextureFilter eReturnFilter;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFilter.");
        if (wrapperTable->m_Texture2D_GetFilter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::GetFilter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_GetFilter(instanceHandle, &eReturnFilter);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnFilter));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFTexture2D::SetFilter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (Filter)");
        }
        unsigned int eFilter = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFilter.");
        if (wrapperTable->m_Texture2D_SetFilter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Texture2D::SetFilter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Texture2D_SetFilter(instanceHandle, (eLib3MFTextureFilter) eFilter);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImplicitPort Implementation
**************************************************************************************************************************/

CLib3MFImplicitPort::CLib3MFImplicitPort()
		: CLib3MFBaseClass()
{
}

CLib3MFImplicitPort::~CLib3MFImplicitPort()
{
}

void CLib3MFImplicitPort::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImplicitPort"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentifier", GetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIdentifier", SetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDisplayName", GetDisplayName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDisplayName", SetDisplayName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetType", SetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetType", GetType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetReference", GetReference);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetReference", SetReference);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImplicitPort::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImplicitPort * implicitportInstance = new CLib3MFImplicitPort();
				implicitportInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImplicitPort: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImplicitPort::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImplicitPort::GetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededIdentifier = 0;
        unsigned int bytesWrittenIdentifier = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentifier.");
        if (wrapperTable->m_ImplicitPort_GetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::GetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitPort_GetIdentifier(instanceHandle, 0, &bytesNeededIdentifier, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferIdentifier;
        bufferIdentifier.resize(bytesNeededIdentifier);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_GetIdentifier(instanceHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferIdentifier[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::SetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIdentifier.");
        if (wrapperTable->m_ImplicitPort_SetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::SetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_SetIdentifier(instanceHandle, sIdentifier.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::GetDisplayName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededDisplayName = 0;
        unsigned int bytesWrittenDisplayName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDisplayName.");
        if (wrapperTable->m_ImplicitPort_GetDisplayName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::GetDisplayName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitPort_GetDisplayName(instanceHandle, 0, &bytesNeededDisplayName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferDisplayName;
        bufferDisplayName.resize(bytesNeededDisplayName);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_GetDisplayName(instanceHandle, bytesNeededDisplayName, &bytesWrittenDisplayName, &bufferDisplayName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferDisplayName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::SetDisplayName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (DisplayName)");
        }
        v8::String::Utf8Value sutf8DisplayName(isolate, args[0]);
        std::string sDisplayName = *sutf8DisplayName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDisplayName.");
        if (wrapperTable->m_ImplicitPort_SetDisplayName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::SetDisplayName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_SetDisplayName(instanceHandle, sDisplayName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::SetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (ImplicitPortType)");
        }
        unsigned int eImplicitPortType = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetType.");
        if (wrapperTable->m_ImplicitPort_SetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::SetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_SetType(instanceHandle, (eLib3MFImplicitPortType) eImplicitPortType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::GetType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFImplicitPortType eReturnImplicitPortType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetType.");
        if (wrapperTable->m_ImplicitPort_GetType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::GetType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_GetType(instanceHandle, &eReturnImplicitPortType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnImplicitPortType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::GetReference(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededReference = 0;
        unsigned int bytesWrittenReference = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetReference.");
        if (wrapperTable->m_ImplicitPort_GetReference == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::GetReference.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitPort_GetReference(instanceHandle, 0, &bytesNeededReference, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferReference;
        bufferReference.resize(bytesNeededReference);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_GetReference(instanceHandle, bytesNeededReference, &bytesWrittenReference, &bufferReference[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferReference[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitPort::SetReference(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Reference)");
        }
        v8::String::Utf8Value sutf8Reference(isolate, args[0]);
        std::string sReference = *sutf8Reference;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetReference.");
        if (wrapperTable->m_ImplicitPort_SetReference == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPort::SetReference.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPort_SetReference(instanceHandle, sReference.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFIterator Implementation
**************************************************************************************************************************/

CLib3MFIterator::CLib3MFIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFIterator::~CLib3MFIterator()
{
}

void CLib3MFIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "MoveNext", MoveNext);
		NODE_SET_PROTOTYPE_METHOD(tpl, "MovePrevious", MovePrevious);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Count", Count);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFIterator * iteratorInstance = new CLib3MFIterator();
				iteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFIterator::MoveNext(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasNext = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MoveNext.");
        if (wrapperTable->m_Iterator_MoveNext == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Iterator::MoveNext.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Iterator_MoveNext(instanceHandle, &bReturnHasNext);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasNext));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFIterator::MovePrevious(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasPrevious = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MovePrevious.");
        if (wrapperTable->m_Iterator_MovePrevious == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Iterator::MovePrevious.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Iterator_MovePrevious(instanceHandle, &bReturnHasPrevious);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasPrevious));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFIterator::Count(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Count.");
        if (wrapperTable->m_Iterator_Count == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Iterator::Count.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Iterator_Count(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImplicitPortIterator Implementation
**************************************************************************************************************************/

CLib3MFImplicitPortIterator::CLib3MFImplicitPortIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFImplicitPortIterator::~CLib3MFImplicitPortIterator()
{
}

void CLib3MFImplicitPortIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImplicitPortIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrent", GetCurrent);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImplicitPortIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImplicitPortIterator * implicitportiteratorInstance = new CLib3MFImplicitPortIterator();
				implicitportiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImplicitPortIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImplicitPortIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImplicitPortIterator::GetCurrent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPort = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrent.");
        if (wrapperTable->m_ImplicitPortIterator_GetCurrent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitPortIterator::GetCurrent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitPortIterator_GetCurrent(instanceHandle, &hReturnPort);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPort = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPort);
        args.GetReturnValue().Set(instanceObjPort);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImplicitNode Implementation
**************************************************************************************************************************/

CLib3MFImplicitNode::CLib3MFImplicitNode()
		: CLib3MFBaseClass()
{
}

CLib3MFImplicitNode::~CLib3MFImplicitNode()
{
}

void CLib3MFImplicitNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImplicitNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentifier", GetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIdentifier", SetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDisplayName", GetDisplayName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDisplayName", SetDisplayName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTag", GetTag);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTag", SetTag);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetNodeType", GetNodeType);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddInput", AddInput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputs", GetInputs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddOutput", AddOutput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputs", GetOutputs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindInput", FindInput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindOutput", FindOutput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AreTypesValid", AreTypesValid);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImplicitNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImplicitNode * implicitnodeInstance = new CLib3MFImplicitNode();
				implicitnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImplicitNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImplicitNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImplicitNode::GetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededIdentifier = 0;
        unsigned int bytesWrittenIdentifier = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentifier.");
        if (wrapperTable->m_ImplicitNode_GetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::GetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitNode_GetIdentifier(instanceHandle, 0, &bytesNeededIdentifier, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferIdentifier;
        bufferIdentifier.resize(bytesNeededIdentifier);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_GetIdentifier(instanceHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferIdentifier[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::SetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIdentifier.");
        if (wrapperTable->m_ImplicitNode_SetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::SetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_SetIdentifier(instanceHandle, sIdentifier.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::GetDisplayName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededDisplayName = 0;
        unsigned int bytesWrittenDisplayName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDisplayName.");
        if (wrapperTable->m_ImplicitNode_GetDisplayName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::GetDisplayName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitNode_GetDisplayName(instanceHandle, 0, &bytesNeededDisplayName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferDisplayName;
        bufferDisplayName.resize(bytesNeededDisplayName);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_GetDisplayName(instanceHandle, bytesNeededDisplayName, &bytesWrittenDisplayName, &bufferDisplayName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferDisplayName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::SetDisplayName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (DisplayName)");
        }
        v8::String::Utf8Value sutf8DisplayName(isolate, args[0]);
        std::string sDisplayName = *sutf8DisplayName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDisplayName.");
        if (wrapperTable->m_ImplicitNode_SetDisplayName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::SetDisplayName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_SetDisplayName(instanceHandle, sDisplayName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::GetTag(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededTag = 0;
        unsigned int bytesWrittenTag = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTag.");
        if (wrapperTable->m_ImplicitNode_GetTag == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::GetTag.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitNode_GetTag(instanceHandle, 0, &bytesNeededTag, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferTag;
        bufferTag.resize(bytesNeededTag);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_GetTag(instanceHandle, bytesNeededTag, &bytesWrittenTag, &bufferTag[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferTag[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::SetTag(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Tag)");
        }
        v8::String::Utf8Value sutf8Tag(isolate, args[0]);
        std::string sTag = *sutf8Tag;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTag.");
        if (wrapperTable->m_ImplicitNode_SetTag == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::SetTag.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_SetTag(instanceHandle, sTag.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::GetNodeType(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFImplicitNodeType eReturnType;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetNodeType.");
        if (wrapperTable->m_ImplicitNode_GetNodeType == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::GetNodeType.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_GetNodeType(instanceHandle, &eReturnType);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnType));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::AddInput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        Lib3MFHandle hReturnPort = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddInput.");
        if (wrapperTable->m_ImplicitNode_AddInput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::AddInput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_AddInput(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), &hReturnPort);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPort = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPort);
        args.GetReturnValue().Set(instanceObjPort);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::GetInputs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputs.");
        if (wrapperTable->m_ImplicitNode_GetInputs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::GetInputs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_GetInputs(instanceHandle, &hReturnIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjIterator = CLib3MFImplicitPortIterator::NewInstance(args.Holder(), hReturnIterator);
        args.GetReturnValue().Set(instanceObjIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::AddOutput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        Lib3MFHandle hReturnPort = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddOutput.");
        if (wrapperTable->m_ImplicitNode_AddOutput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::AddOutput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_AddOutput(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), &hReturnPort);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPort = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPort);
        args.GetReturnValue().Set(instanceObjPort);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::GetOutputs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputs.");
        if (wrapperTable->m_ImplicitNode_GetOutputs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::GetOutputs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_GetOutputs(instanceHandle, &hReturnIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjIterator = CLib3MFImplicitPortIterator::NewInstance(args.Holder(), hReturnIterator);
        args.GetReturnValue().Set(instanceObjIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::FindInput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        Lib3MFHandle hReturnInput = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindInput.");
        if (wrapperTable->m_ImplicitNode_FindInput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::FindInput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_FindInput(instanceHandle, sIdentifier.c_str(), &hReturnInput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjInput = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnInput);
        args.GetReturnValue().Set(instanceObjInput);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::FindOutput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        Lib3MFHandle hReturnOutput = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindOutput.");
        if (wrapperTable->m_ImplicitNode_FindOutput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::FindOutput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_FindOutput(instanceHandle, sIdentifier.c_str(), &hReturnOutput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjOutput = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnOutput);
        args.GetReturnValue().Set(instanceObjOutput);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitNode::AreTypesValid(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnValid = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AreTypesValid.");
        if (wrapperTable->m_ImplicitNode_AreTypesValid == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitNode::AreTypesValid.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitNode_AreTypesValid(instanceHandle, &bReturnValid);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnValid));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFOneInputNode Implementation
**************************************************************************************************************************/

CLib3MFOneInputNode::CLib3MFOneInputNode()
		: CLib3MFBaseClass()
{
}

CLib3MFOneInputNode::~CLib3MFOneInputNode()
{
}

void CLib3MFOneInputNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFOneInputNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputA", GetInputA);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputResult", GetOutputResult);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFOneInputNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFOneInputNode * oneinputnodeInstance = new CLib3MFOneInputNode();
				oneinputnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFOneInputNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFOneInputNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFOneInputNode::GetInputA(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnInput = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputA.");
        if (wrapperTable->m_OneInputNode_GetInputA == nullptr)
            throw std::runtime_error("Could not call Lib3MF method OneInputNode::GetInputA.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_OneInputNode_GetInputA(instanceHandle, &hReturnInput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjInput = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnInput);
        args.GetReturnValue().Set(instanceObjInput);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFOneInputNode::GetOutputResult(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResult = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputResult.");
        if (wrapperTable->m_OneInputNode_GetOutputResult == nullptr)
            throw std::runtime_error("Could not call Lib3MF method OneInputNode::GetOutputResult.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_OneInputNode_GetOutputResult(instanceHandle, &hReturnResult);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResult = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnResult);
        args.GetReturnValue().Set(instanceObjResult);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSinNode Implementation
**************************************************************************************************************************/

CLib3MFSinNode::CLib3MFSinNode()
		: CLib3MFBaseClass()
{
}

CLib3MFSinNode::~CLib3MFSinNode()
{
}

void CLib3MFSinNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSinNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSinNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSinNode * sinnodeInstance = new CLib3MFSinNode();
				sinnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSinNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSinNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFCosNode Implementation
**************************************************************************************************************************/

CLib3MFCosNode::CLib3MFCosNode()
		: CLib3MFBaseClass()
{
}

CLib3MFCosNode::~CLib3MFCosNode()
{
}

void CLib3MFCosNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCosNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCosNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCosNode * cosnodeInstance = new CLib3MFCosNode();
				cosnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCosNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCosNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFTanNode Implementation
**************************************************************************************************************************/

CLib3MFTanNode::CLib3MFTanNode()
		: CLib3MFBaseClass()
{
}

CLib3MFTanNode::~CLib3MFTanNode()
{
}

void CLib3MFTanNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTanNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTanNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTanNode * tannodeInstance = new CLib3MFTanNode();
				tannodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTanNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTanNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFArcSinNode Implementation
**************************************************************************************************************************/

CLib3MFArcSinNode::CLib3MFArcSinNode()
		: CLib3MFBaseClass()
{
}

CLib3MFArcSinNode::~CLib3MFArcSinNode()
{
}

void CLib3MFArcSinNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFArcSinNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFArcSinNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFArcSinNode * arcsinnodeInstance = new CLib3MFArcSinNode();
				arcsinnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFArcSinNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFArcSinNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFArcCosNode Implementation
**************************************************************************************************************************/

CLib3MFArcCosNode::CLib3MFArcCosNode()
		: CLib3MFBaseClass()
{
}

CLib3MFArcCosNode::~CLib3MFArcCosNode()
{
}

void CLib3MFArcCosNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFArcCosNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFArcCosNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFArcCosNode * arccosnodeInstance = new CLib3MFArcCosNode();
				arccosnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFArcCosNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFArcCosNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFArcTanNode Implementation
**************************************************************************************************************************/

CLib3MFArcTanNode::CLib3MFArcTanNode()
		: CLib3MFBaseClass()
{
}

CLib3MFArcTanNode::~CLib3MFArcTanNode()
{
}

void CLib3MFArcTanNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFArcTanNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFArcTanNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFArcTanNode * arctannodeInstance = new CLib3MFArcTanNode();
				arctannodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFArcTanNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFArcTanNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFSinhNode Implementation
**************************************************************************************************************************/

CLib3MFSinhNode::CLib3MFSinhNode()
		: CLib3MFBaseClass()
{
}

CLib3MFSinhNode::~CLib3MFSinhNode()
{
}

void CLib3MFSinhNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSinhNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSinhNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSinhNode * sinhnodeInstance = new CLib3MFSinhNode();
				sinhnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSinhNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSinhNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFCoshNode Implementation
**************************************************************************************************************************/

CLib3MFCoshNode::CLib3MFCoshNode()
		: CLib3MFBaseClass()
{
}

CLib3MFCoshNode::~CLib3MFCoshNode()
{
}

void CLib3MFCoshNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCoshNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCoshNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCoshNode * coshnodeInstance = new CLib3MFCoshNode();
				coshnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCoshNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCoshNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFTanhNode Implementation
**************************************************************************************************************************/

CLib3MFTanhNode::CLib3MFTanhNode()
		: CLib3MFBaseClass()
{
}

CLib3MFTanhNode::~CLib3MFTanhNode()
{
}

void CLib3MFTanhNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTanhNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTanhNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTanhNode * tanhnodeInstance = new CLib3MFTanhNode();
				tanhnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTanhNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTanhNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFRoundNode Implementation
**************************************************************************************************************************/

CLib3MFRoundNode::CLib3MFRoundNode()
		: CLib3MFBaseClass()
{
}

CLib3MFRoundNode::~CLib3MFRoundNode()
{
}

void CLib3MFRoundNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFRoundNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFRoundNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFRoundNode * roundnodeInstance = new CLib3MFRoundNode();
				roundnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFRoundNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFRoundNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFCeilNode Implementation
**************************************************************************************************************************/

CLib3MFCeilNode::CLib3MFCeilNode()
		: CLib3MFBaseClass()
{
}

CLib3MFCeilNode::~CLib3MFCeilNode()
{
}

void CLib3MFCeilNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCeilNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCeilNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCeilNode * ceilnodeInstance = new CLib3MFCeilNode();
				ceilnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCeilNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCeilNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFFloorNode Implementation
**************************************************************************************************************************/

CLib3MFFloorNode::CLib3MFFloorNode()
		: CLib3MFBaseClass()
{
}

CLib3MFFloorNode::~CLib3MFFloorNode()
{
}

void CLib3MFFloorNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFloorNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFloorNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFloorNode * floornodeInstance = new CLib3MFFloorNode();
				floornodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFloorNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFloorNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFSignNode Implementation
**************************************************************************************************************************/

CLib3MFSignNode::CLib3MFSignNode()
		: CLib3MFBaseClass()
{
}

CLib3MFSignNode::~CLib3MFSignNode()
{
}

void CLib3MFSignNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSignNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSignNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSignNode * signnodeInstance = new CLib3MFSignNode();
				signnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSignNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSignNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFFractNode Implementation
**************************************************************************************************************************/

CLib3MFFractNode::CLib3MFFractNode()
		: CLib3MFBaseClass()
{
}

CLib3MFFractNode::~CLib3MFFractNode()
{
}

void CLib3MFFractNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFractNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFractNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFractNode * fractnodeInstance = new CLib3MFFractNode();
				fractnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFractNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFractNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFAbsNode Implementation
**************************************************************************************************************************/

CLib3MFAbsNode::CLib3MFAbsNode()
		: CLib3MFBaseClass()
{
}

CLib3MFAbsNode::~CLib3MFAbsNode()
{
}

void CLib3MFAbsNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFAbsNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFAbsNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFAbsNode * absnodeInstance = new CLib3MFAbsNode();
				absnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFAbsNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFAbsNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFExpNode Implementation
**************************************************************************************************************************/

CLib3MFExpNode::CLib3MFExpNode()
		: CLib3MFBaseClass()
{
}

CLib3MFExpNode::~CLib3MFExpNode()
{
}

void CLib3MFExpNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFExpNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFExpNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFExpNode * expnodeInstance = new CLib3MFExpNode();
				expnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFExpNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFExpNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFLogNode Implementation
**************************************************************************************************************************/

CLib3MFLogNode::CLib3MFLogNode()
		: CLib3MFBaseClass()
{
}

CLib3MFLogNode::~CLib3MFLogNode()
{
}

void CLib3MFLogNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFLogNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFLogNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFLogNode * lognodeInstance = new CLib3MFLogNode();
				lognodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFLogNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFLogNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFLog2Node Implementation
**************************************************************************************************************************/

CLib3MFLog2Node::CLib3MFLog2Node()
		: CLib3MFBaseClass()
{
}

CLib3MFLog2Node::~CLib3MFLog2Node()
{
}

void CLib3MFLog2Node::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFLog2Node"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFLog2Node::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFLog2Node * log2nodeInstance = new CLib3MFLog2Node();
				log2nodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFLog2Node: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFLog2Node::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFLog10Node Implementation
**************************************************************************************************************************/

CLib3MFLog10Node::CLib3MFLog10Node()
		: CLib3MFBaseClass()
{
}

CLib3MFLog10Node::~CLib3MFLog10Node()
{
}

void CLib3MFLog10Node::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFLog10Node"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFLog10Node::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFLog10Node * log10nodeInstance = new CLib3MFLog10Node();
				log10nodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFLog10Node: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFLog10Node::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFLengthNode Implementation
**************************************************************************************************************************/

CLib3MFLengthNode::CLib3MFLengthNode()
		: CLib3MFBaseClass()
{
}

CLib3MFLengthNode::~CLib3MFLengthNode()
{
}

void CLib3MFLengthNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFLengthNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFLengthNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFLengthNode * lengthnodeInstance = new CLib3MFLengthNode();
				lengthnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFLengthNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFLengthNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFTransposeNode Implementation
**************************************************************************************************************************/

CLib3MFTransposeNode::CLib3MFTransposeNode()
		: CLib3MFBaseClass()
{
}

CLib3MFTransposeNode::~CLib3MFTransposeNode()
{
}

void CLib3MFTransposeNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTransposeNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTransposeNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTransposeNode * transposenodeInstance = new CLib3MFTransposeNode();
				transposenodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTransposeNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTransposeNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFInverseNode Implementation
**************************************************************************************************************************/

CLib3MFInverseNode::CLib3MFInverseNode()
		: CLib3MFBaseClass()
{
}

CLib3MFInverseNode::~CLib3MFInverseNode()
{
}

void CLib3MFInverseNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFInverseNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFInverseNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFInverseNode * inversenodeInstance = new CLib3MFInverseNode();
				inversenodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFInverseNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFInverseNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFSqrtNode Implementation
**************************************************************************************************************************/

CLib3MFSqrtNode::CLib3MFSqrtNode()
		: CLib3MFBaseClass()
{
}

CLib3MFSqrtNode::~CLib3MFSqrtNode()
{
}

void CLib3MFSqrtNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSqrtNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSqrtNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSqrtNode * sqrtnodeInstance = new CLib3MFSqrtNode();
				sqrtnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSqrtNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSqrtNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFResourceIdNode Implementation
**************************************************************************************************************************/

CLib3MFResourceIdNode::CLib3MFResourceIdNode()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceIdNode::~CLib3MFResourceIdNode()
{
}

void CLib3MFResourceIdNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceIdNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetResource", SetResource);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResource", GetResource);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputValue", GetOutputValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceIdNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceIdNode * resourceidnodeInstance = new CLib3MFResourceIdNode();
				resourceidnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceIdNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceIdNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceIdNode::SetResource(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Resource)");
        }
        Local<Object> objResource = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResource * instanceResource = ObjectWrap::Unwrap<CLib3MFResource>(objResource);
        if (instanceResource == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Resource)");
        Lib3MFHandle hResource = instanceResource->getHandle( objResource );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetResource.");
        if (wrapperTable->m_ResourceIdNode_SetResource == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIdNode::SetResource.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIdNode_SetResource(instanceHandle, hResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIdNode::GetResource(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResource.");
        if (wrapperTable->m_ResourceIdNode_GetResource == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIdNode::GetResource.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIdNode_GetResource(instanceHandle, &hReturnResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResource = CLib3MFResource::NewInstance(args.Holder(), hReturnResource);
        args.GetReturnValue().Set(instanceObjResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceIdNode::GetOutputValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnValue = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputValue.");
        if (wrapperTable->m_ResourceIdNode_GetOutputValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceIdNode::GetOutputValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceIdNode_GetOutputValue(instanceHandle, &hReturnValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjValue = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnValue);
        args.GetReturnValue().Set(instanceObjValue);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFTwoInputNode Implementation
**************************************************************************************************************************/

CLib3MFTwoInputNode::CLib3MFTwoInputNode()
		: CLib3MFBaseClass()
{
}

CLib3MFTwoInputNode::~CLib3MFTwoInputNode()
{
}

void CLib3MFTwoInputNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFTwoInputNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputB", GetInputB);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFTwoInputNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFTwoInputNode * twoinputnodeInstance = new CLib3MFTwoInputNode();
				twoinputnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFTwoInputNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFTwoInputNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFTwoInputNode::GetInputB(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnB = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputB.");
        if (wrapperTable->m_TwoInputNode_GetInputB == nullptr)
            throw std::runtime_error("Could not call Lib3MF method TwoInputNode::GetInputB.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_TwoInputNode_GetInputB(instanceHandle, &hReturnB);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjB = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnB);
        args.GetReturnValue().Set(instanceObjB);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFAdditionNode Implementation
**************************************************************************************************************************/

CLib3MFAdditionNode::CLib3MFAdditionNode()
		: CLib3MFBaseClass()
{
}

CLib3MFAdditionNode::~CLib3MFAdditionNode()
{
}

void CLib3MFAdditionNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFAdditionNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFAdditionNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFAdditionNode * additionnodeInstance = new CLib3MFAdditionNode();
				additionnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFAdditionNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFAdditionNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFSubtractionNode Implementation
**************************************************************************************************************************/

CLib3MFSubtractionNode::CLib3MFSubtractionNode()
		: CLib3MFBaseClass()
{
}

CLib3MFSubtractionNode::~CLib3MFSubtractionNode()
{
}

void CLib3MFSubtractionNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSubtractionNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSubtractionNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSubtractionNode * subtractionnodeInstance = new CLib3MFSubtractionNode();
				subtractionnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSubtractionNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSubtractionNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFMultiplicationNode Implementation
**************************************************************************************************************************/

CLib3MFMultiplicationNode::CLib3MFMultiplicationNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMultiplicationNode::~CLib3MFMultiplicationNode()
{
}

void CLib3MFMultiplicationNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMultiplicationNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMultiplicationNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMultiplicationNode * multiplicationnodeInstance = new CLib3MFMultiplicationNode();
				multiplicationnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMultiplicationNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMultiplicationNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFDivisionNode Implementation
**************************************************************************************************************************/

CLib3MFDivisionNode::CLib3MFDivisionNode()
		: CLib3MFBaseClass()
{
}

CLib3MFDivisionNode::~CLib3MFDivisionNode()
{
}

void CLib3MFDivisionNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFDivisionNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFDivisionNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFDivisionNode * divisionnodeInstance = new CLib3MFDivisionNode();
				divisionnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFDivisionNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFDivisionNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFDotNode Implementation
**************************************************************************************************************************/

CLib3MFDotNode::CLib3MFDotNode()
		: CLib3MFBaseClass()
{
}

CLib3MFDotNode::~CLib3MFDotNode()
{
}

void CLib3MFDotNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFDotNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFDotNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFDotNode * dotnodeInstance = new CLib3MFDotNode();
				dotnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFDotNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFDotNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFCrossNode Implementation
**************************************************************************************************************************/

CLib3MFCrossNode::CLib3MFCrossNode()
		: CLib3MFBaseClass()
{
}

CLib3MFCrossNode::~CLib3MFCrossNode()
{
}

void CLib3MFCrossNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFCrossNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFCrossNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFCrossNode * crossnodeInstance = new CLib3MFCrossNode();
				crossnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFCrossNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFCrossNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFArcTan2Node Implementation
**************************************************************************************************************************/

CLib3MFArcTan2Node::CLib3MFArcTan2Node()
		: CLib3MFBaseClass()
{
}

CLib3MFArcTan2Node::~CLib3MFArcTan2Node()
{
}

void CLib3MFArcTan2Node::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFArcTan2Node"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFArcTan2Node::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFArcTan2Node * arctan2nodeInstance = new CLib3MFArcTan2Node();
				arctan2nodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFArcTan2Node: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFArcTan2Node::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFMatVecMultiplicationNode Implementation
**************************************************************************************************************************/

CLib3MFMatVecMultiplicationNode::CLib3MFMatVecMultiplicationNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMatVecMultiplicationNode::~CLib3MFMatVecMultiplicationNode()
{
}

void CLib3MFMatVecMultiplicationNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMatVecMultiplicationNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMatVecMultiplicationNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMatVecMultiplicationNode * matvecmultiplicationnodeInstance = new CLib3MFMatVecMultiplicationNode();
				matvecmultiplicationnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMatVecMultiplicationNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMatVecMultiplicationNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFMinNode Implementation
**************************************************************************************************************************/

CLib3MFMinNode::CLib3MFMinNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMinNode::~CLib3MFMinNode()
{
}

void CLib3MFMinNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMinNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMinNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMinNode * minnodeInstance = new CLib3MFMinNode();
				minnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMinNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMinNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFMaxNode Implementation
**************************************************************************************************************************/

CLib3MFMaxNode::CLib3MFMaxNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMaxNode::~CLib3MFMaxNode()
{
}

void CLib3MFMaxNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMaxNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMaxNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMaxNode * maxnodeInstance = new CLib3MFMaxNode();
				maxnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMaxNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMaxNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFFmodNode Implementation
**************************************************************************************************************************/

CLib3MFFmodNode::CLib3MFFmodNode()
		: CLib3MFBaseClass()
{
}

CLib3MFFmodNode::~CLib3MFFmodNode()
{
}

void CLib3MFFmodNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFmodNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFmodNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFmodNode * fmodnodeInstance = new CLib3MFFmodNode();
				fmodnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFmodNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFmodNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFModNode Implementation
**************************************************************************************************************************/

CLib3MFModNode::CLib3MFModNode()
		: CLib3MFBaseClass()
{
}

CLib3MFModNode::~CLib3MFModNode()
{
}

void CLib3MFModNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFModNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFModNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFModNode * modnodeInstance = new CLib3MFModNode();
				modnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFModNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFModNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFPowNode Implementation
**************************************************************************************************************************/

CLib3MFPowNode::CLib3MFPowNode()
		: CLib3MFBaseClass()
{
}

CLib3MFPowNode::~CLib3MFPowNode()
{
}

void CLib3MFPowNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFPowNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFPowNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFPowNode * pownodeInstance = new CLib3MFPowNode();
				pownodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFPowNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFPowNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFSelectNode Implementation
**************************************************************************************************************************/

CLib3MFSelectNode::CLib3MFSelectNode()
		: CLib3MFBaseClass()
{
}

CLib3MFSelectNode::~CLib3MFSelectNode()
{
}

void CLib3MFSelectNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSelectNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputB", GetInputB);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputC", GetInputC);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputD", GetInputD);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSelectNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSelectNode * selectnodeInstance = new CLib3MFSelectNode();
				selectnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSelectNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSelectNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSelectNode::GetInputB(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnB = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputB.");
        if (wrapperTable->m_SelectNode_GetInputB == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SelectNode::GetInputB.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SelectNode_GetInputB(instanceHandle, &hReturnB);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjB = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnB);
        args.GetReturnValue().Set(instanceObjB);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSelectNode::GetInputC(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnC = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputC.");
        if (wrapperTable->m_SelectNode_GetInputC == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SelectNode::GetInputC.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SelectNode_GetInputC(instanceHandle, &hReturnC);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjC = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnC);
        args.GetReturnValue().Set(instanceObjC);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSelectNode::GetInputD(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnD = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputD.");
        if (wrapperTable->m_SelectNode_GetInputD == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SelectNode::GetInputD.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SelectNode_GetInputD(instanceHandle, &hReturnD);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjD = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnD);
        args.GetReturnValue().Set(instanceObjD);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFClampNode Implementation
**************************************************************************************************************************/

CLib3MFClampNode::CLib3MFClampNode()
		: CLib3MFBaseClass()
{
}

CLib3MFClampNode::~CLib3MFClampNode()
{
}

void CLib3MFClampNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFClampNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputMin", GetInputMin);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputMax", GetInputMax);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFClampNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFClampNode * clampnodeInstance = new CLib3MFClampNode();
				clampnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFClampNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFClampNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFClampNode::GetInputMin(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMin = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputMin.");
        if (wrapperTable->m_ClampNode_GetInputMin == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ClampNode::GetInputMin.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ClampNode_GetInputMin(instanceHandle, &hReturnMin);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMin = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnMin);
        args.GetReturnValue().Set(instanceObjMin);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFClampNode::GetInputMax(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMax = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputMax.");
        if (wrapperTable->m_ClampNode_GetInputMax == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ClampNode::GetInputMax.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ClampNode_GetInputMax(instanceHandle, &hReturnMax);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMax = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnMax);
        args.GetReturnValue().Set(instanceObjMax);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComposeVectorNode Implementation
**************************************************************************************************************************/

CLib3MFComposeVectorNode::CLib3MFComposeVectorNode()
		: CLib3MFBaseClass()
{
}

CLib3MFComposeVectorNode::~CLib3MFComposeVectorNode()
{
}

void CLib3MFComposeVectorNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComposeVectorNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputX", GetInputX);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputY", GetInputY);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputZ", GetInputZ);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputResult", GetOutputResult);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComposeVectorNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComposeVectorNode * composevectornodeInstance = new CLib3MFComposeVectorNode();
				composevectornodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComposeVectorNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComposeVectorNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComposeVectorNode::GetInputX(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnX = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputX.");
        if (wrapperTable->m_ComposeVectorNode_GetInputX == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeVectorNode::GetInputX.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeVectorNode_GetInputX(instanceHandle, &hReturnX);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjX = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnX);
        args.GetReturnValue().Set(instanceObjX);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeVectorNode::GetInputY(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnY = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputY.");
        if (wrapperTable->m_ComposeVectorNode_GetInputY == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeVectorNode::GetInputY.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeVectorNode_GetInputY(instanceHandle, &hReturnY);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjY = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnY);
        args.GetReturnValue().Set(instanceObjY);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeVectorNode::GetInputZ(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnZ = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputZ.");
        if (wrapperTable->m_ComposeVectorNode_GetInputZ == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeVectorNode::GetInputZ.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeVectorNode_GetInputZ(instanceHandle, &hReturnZ);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjZ = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnZ);
        args.GetReturnValue().Set(instanceObjZ);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeVectorNode::GetOutputResult(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResult = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputResult.");
        if (wrapperTable->m_ComposeVectorNode_GetOutputResult == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeVectorNode::GetOutputResult.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeVectorNode_GetOutputResult(instanceHandle, &hReturnResult);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResult = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnResult);
        args.GetReturnValue().Set(instanceObjResult);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFVectorFromScalarNode Implementation
**************************************************************************************************************************/

CLib3MFVectorFromScalarNode::CLib3MFVectorFromScalarNode()
		: CLib3MFBaseClass()
{
}

CLib3MFVectorFromScalarNode::~CLib3MFVectorFromScalarNode()
{
}

void CLib3MFVectorFromScalarNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFVectorFromScalarNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFVectorFromScalarNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFVectorFromScalarNode * vectorfromscalarnodeInstance = new CLib3MFVectorFromScalarNode();
				vectorfromscalarnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFVectorFromScalarNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFVectorFromScalarNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}

/*************************************************************************************************************************
 Class CLib3MFDecomposeVectorNode Implementation
**************************************************************************************************************************/

CLib3MFDecomposeVectorNode::CLib3MFDecomposeVectorNode()
		: CLib3MFBaseClass()
{
}

CLib3MFDecomposeVectorNode::~CLib3MFDecomposeVectorNode()
{
}

void CLib3MFDecomposeVectorNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFDecomposeVectorNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputA", GetInputA);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputX", GetOutputX);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputY", GetOutputY);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputZ", GetOutputZ);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFDecomposeVectorNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFDecomposeVectorNode * decomposevectornodeInstance = new CLib3MFDecomposeVectorNode();
				decomposevectornodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFDecomposeVectorNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFDecomposeVectorNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFDecomposeVectorNode::GetInputA(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnA = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputA.");
        if (wrapperTable->m_DecomposeVectorNode_GetInputA == nullptr)
            throw std::runtime_error("Could not call Lib3MF method DecomposeVectorNode::GetInputA.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_DecomposeVectorNode_GetInputA(instanceHandle, &hReturnA);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjA = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnA);
        args.GetReturnValue().Set(instanceObjA);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFDecomposeVectorNode::GetOutputX(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnX = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputX.");
        if (wrapperTable->m_DecomposeVectorNode_GetOutputX == nullptr)
            throw std::runtime_error("Could not call Lib3MF method DecomposeVectorNode::GetOutputX.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_DecomposeVectorNode_GetOutputX(instanceHandle, &hReturnX);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjX = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnX);
        args.GetReturnValue().Set(instanceObjX);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFDecomposeVectorNode::GetOutputY(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnY = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputY.");
        if (wrapperTable->m_DecomposeVectorNode_GetOutputY == nullptr)
            throw std::runtime_error("Could not call Lib3MF method DecomposeVectorNode::GetOutputY.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_DecomposeVectorNode_GetOutputY(instanceHandle, &hReturnY);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjY = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnY);
        args.GetReturnValue().Set(instanceObjY);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFDecomposeVectorNode::GetOutputZ(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnZ = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputZ.");
        if (wrapperTable->m_DecomposeVectorNode_GetOutputZ == nullptr)
            throw std::runtime_error("Could not call Lib3MF method DecomposeVectorNode::GetOutputZ.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_DecomposeVectorNode_GetOutputZ(instanceHandle, &hReturnZ);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjZ = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnZ);
        args.GetReturnValue().Set(instanceObjZ);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFComposeMatrixNode Implementation
**************************************************************************************************************************/

CLib3MFComposeMatrixNode::CLib3MFComposeMatrixNode()
		: CLib3MFBaseClass()
{
}

CLib3MFComposeMatrixNode::~CLib3MFComposeMatrixNode()
{
}

void CLib3MFComposeMatrixNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFComposeMatrixNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM00", GetInputM00);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM01", GetInputM01);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM02", GetInputM02);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM03", GetInputM03);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM10", GetInputM10);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM11", GetInputM11);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM12", GetInputM12);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM13", GetInputM13);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM20", GetInputM20);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM21", GetInputM21);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM22", GetInputM22);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM23", GetInputM23);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM30", GetInputM30);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM31", GetInputM31);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM32", GetInputM32);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputM33", GetInputM33);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputResult", GetOutputResult);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFComposeMatrixNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFComposeMatrixNode * composematrixnodeInstance = new CLib3MFComposeMatrixNode();
				composematrixnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFComposeMatrixNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFComposeMatrixNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFComposeMatrixNode::GetInputM00(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM00 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM00.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM00 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM00.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM00(instanceHandle, &hReturnM00);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM00 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM00);
        args.GetReturnValue().Set(instanceObjM00);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM01(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM01 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM01.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM01 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM01.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM01(instanceHandle, &hReturnM01);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM01 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM01);
        args.GetReturnValue().Set(instanceObjM01);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM02(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM02 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM02.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM02 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM02.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM02(instanceHandle, &hReturnM02);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM02 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM02);
        args.GetReturnValue().Set(instanceObjM02);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM03(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM03 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM03.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM03 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM03.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM03(instanceHandle, &hReturnM03);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM03 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM03);
        args.GetReturnValue().Set(instanceObjM03);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM10(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM10 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM10.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM10 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM10.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM10(instanceHandle, &hReturnM10);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM10 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM10);
        args.GetReturnValue().Set(instanceObjM10);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM11(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM11 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM11.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM11 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM11.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM11(instanceHandle, &hReturnM11);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM11 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM11);
        args.GetReturnValue().Set(instanceObjM11);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM12(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM12 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM12.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM12 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM12.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM12(instanceHandle, &hReturnM12);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM12 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM12);
        args.GetReturnValue().Set(instanceObjM12);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM13(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM13 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM13.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM13 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM13.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM13(instanceHandle, &hReturnM13);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM13 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM13);
        args.GetReturnValue().Set(instanceObjM13);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM20(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM20 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM20.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM20 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM20.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM20(instanceHandle, &hReturnM20);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM20 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM20);
        args.GetReturnValue().Set(instanceObjM20);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM21(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM21 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM21.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM21 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM21.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM21(instanceHandle, &hReturnM21);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM21 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM21);
        args.GetReturnValue().Set(instanceObjM21);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM22(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM22 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM22.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM22 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM22.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM22(instanceHandle, &hReturnM22);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM22 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM22);
        args.GetReturnValue().Set(instanceObjM22);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM23(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM23 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM23.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM23 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM23.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM23(instanceHandle, &hReturnM23);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM23 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM23);
        args.GetReturnValue().Set(instanceObjM23);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM30(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM30 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM30.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM30 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM30.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM30(instanceHandle, &hReturnM30);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM30 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM30);
        args.GetReturnValue().Set(instanceObjM30);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM31(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM31 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM31.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM31 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM31.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM31(instanceHandle, &hReturnM31);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM31 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM31);
        args.GetReturnValue().Set(instanceObjM31);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM32(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM32 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM32.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM32 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM32.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM32(instanceHandle, &hReturnM32);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM32 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM32);
        args.GetReturnValue().Set(instanceObjM32);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetInputM33(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnM33 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputM33.");
        if (wrapperTable->m_ComposeMatrixNode_GetInputM33 == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetInputM33.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetInputM33(instanceHandle, &hReturnM33);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjM33 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnM33);
        args.GetReturnValue().Set(instanceObjM33);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFComposeMatrixNode::GetOutputResult(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResult = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputResult.");
        if (wrapperTable->m_ComposeMatrixNode_GetOutputResult == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ComposeMatrixNode::GetOutputResult.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ComposeMatrixNode_GetOutputResult(instanceHandle, &hReturnResult);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResult = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnResult);
        args.GetReturnValue().Set(instanceObjResult);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMatrixFromRowsNode Implementation
**************************************************************************************************************************/

CLib3MFMatrixFromRowsNode::CLib3MFMatrixFromRowsNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMatrixFromRowsNode::~CLib3MFMatrixFromRowsNode()
{
}

void CLib3MFMatrixFromRowsNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMatrixFromRowsNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputA", GetInputA);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputB", GetInputB);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputC", GetInputC);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputD", GetInputD);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputResult", GetOutputResult);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMatrixFromRowsNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMatrixFromRowsNode * matrixfromrowsnodeInstance = new CLib3MFMatrixFromRowsNode();
				matrixfromrowsnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMatrixFromRowsNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMatrixFromRowsNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMatrixFromRowsNode::GetInputA(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnRow0 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputA.");
        if (wrapperTable->m_MatrixFromRowsNode_GetInputA == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromRowsNode::GetInputA.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromRowsNode_GetInputA(instanceHandle, &hReturnRow0);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjRow0 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnRow0);
        args.GetReturnValue().Set(instanceObjRow0);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromRowsNode::GetInputB(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnRow1 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputB.");
        if (wrapperTable->m_MatrixFromRowsNode_GetInputB == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromRowsNode::GetInputB.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromRowsNode_GetInputB(instanceHandle, &hReturnRow1);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjRow1 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnRow1);
        args.GetReturnValue().Set(instanceObjRow1);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromRowsNode::GetInputC(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnRow2 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputC.");
        if (wrapperTable->m_MatrixFromRowsNode_GetInputC == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromRowsNode::GetInputC.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromRowsNode_GetInputC(instanceHandle, &hReturnRow2);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjRow2 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnRow2);
        args.GetReturnValue().Set(instanceObjRow2);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromRowsNode::GetInputD(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnRow3 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputD.");
        if (wrapperTable->m_MatrixFromRowsNode_GetInputD == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromRowsNode::GetInputD.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromRowsNode_GetInputD(instanceHandle, &hReturnRow3);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjRow3 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnRow3);
        args.GetReturnValue().Set(instanceObjRow3);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromRowsNode::GetOutputResult(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResult = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputResult.");
        if (wrapperTable->m_MatrixFromRowsNode_GetOutputResult == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromRowsNode::GetOutputResult.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromRowsNode_GetOutputResult(instanceHandle, &hReturnResult);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResult = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnResult);
        args.GetReturnValue().Set(instanceObjResult);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMatrixFromColumnsNode Implementation
**************************************************************************************************************************/

CLib3MFMatrixFromColumnsNode::CLib3MFMatrixFromColumnsNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMatrixFromColumnsNode::~CLib3MFMatrixFromColumnsNode()
{
}

void CLib3MFMatrixFromColumnsNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMatrixFromColumnsNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputA", GetInputA);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputB", GetInputB);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputC", GetInputC);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputD", GetInputD);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputResult", GetOutputResult);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMatrixFromColumnsNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMatrixFromColumnsNode * matrixfromcolumnsnodeInstance = new CLib3MFMatrixFromColumnsNode();
				matrixfromcolumnsnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMatrixFromColumnsNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMatrixFromColumnsNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMatrixFromColumnsNode::GetInputA(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnColumn0 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputA.");
        if (wrapperTable->m_MatrixFromColumnsNode_GetInputA == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromColumnsNode::GetInputA.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromColumnsNode_GetInputA(instanceHandle, &hReturnColumn0);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjColumn0 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnColumn0);
        args.GetReturnValue().Set(instanceObjColumn0);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromColumnsNode::GetInputB(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnColumn1 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputB.");
        if (wrapperTable->m_MatrixFromColumnsNode_GetInputB == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromColumnsNode::GetInputB.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromColumnsNode_GetInputB(instanceHandle, &hReturnColumn1);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjColumn1 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnColumn1);
        args.GetReturnValue().Set(instanceObjColumn1);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromColumnsNode::GetInputC(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnColumn2 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputC.");
        if (wrapperTable->m_MatrixFromColumnsNode_GetInputC == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromColumnsNode::GetInputC.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromColumnsNode_GetInputC(instanceHandle, &hReturnColumn2);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjColumn2 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnColumn2);
        args.GetReturnValue().Set(instanceObjColumn2);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromColumnsNode::GetInputD(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnColumn3 = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputD.");
        if (wrapperTable->m_MatrixFromColumnsNode_GetInputD == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromColumnsNode::GetInputD.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromColumnsNode_GetInputD(instanceHandle, &hReturnColumn3);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjColumn3 = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnColumn3);
        args.GetReturnValue().Set(instanceObjColumn3);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMatrixFromColumnsNode::GetOutputResult(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResult = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputResult.");
        if (wrapperTable->m_MatrixFromColumnsNode_GetOutputResult == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MatrixFromColumnsNode::GetOutputResult.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MatrixFromColumnsNode_GetOutputResult(instanceHandle, &hReturnResult);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResult = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnResult);
        args.GetReturnValue().Set(instanceObjResult);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFConstantNode Implementation
**************************************************************************************************************************/

CLib3MFConstantNode::CLib3MFConstantNode()
		: CLib3MFBaseClass()
{
}

CLib3MFConstantNode::~CLib3MFConstantNode()
{
}

void CLib3MFConstantNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFConstantNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetConstant", SetConstant);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConstant", GetConstant);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputValue", GetOutputValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFConstantNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFConstantNode * constantnodeInstance = new CLib3MFConstantNode();
				constantnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFConstantNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFConstantNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFConstantNode::SetConstant(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (Value)");
        }
        double dValue = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetConstant.");
        if (wrapperTable->m_ConstantNode_SetConstant == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstantNode::SetConstant.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstantNode_SetConstant(instanceHandle, dValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConstantNode::GetConstant(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnValue = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConstant.");
        if (wrapperTable->m_ConstantNode_GetConstant == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstantNode::GetConstant.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstantNode_GetConstant(instanceHandle, &dReturnValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnValue));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConstantNode::GetOutputValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnValue = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputValue.");
        if (wrapperTable->m_ConstantNode_GetOutputValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstantNode::GetOutputValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstantNode_GetOutputValue(instanceHandle, &hReturnValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjValue = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnValue);
        args.GetReturnValue().Set(instanceObjValue);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFConstVecNode Implementation
**************************************************************************************************************************/

CLib3MFConstVecNode::CLib3MFConstVecNode()
		: CLib3MFBaseClass()
{
}

CLib3MFConstVecNode::~CLib3MFConstVecNode()
{
}

void CLib3MFConstVecNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFConstVecNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVector", SetVector);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVector", GetVector);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputVector", GetOutputVector);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFConstVecNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFConstVecNode * constvecnodeInstance = new CLib3MFConstVecNode();
				constvecnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFConstVecNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFConstVecNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFConstVecNode::SetVector(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Value)");
        }
        sLib3MFVector sValue = convertObjectToLib3MFVector(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVector.");
        if (wrapperTable->m_ConstVecNode_SetVector == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstVecNode::SetVector.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstVecNode_SetVector(instanceHandle, &sValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConstVecNode::GetVector(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFVector sReturnValue;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVector.");
        if (wrapperTable->m_ConstVecNode_GetVector == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstVecNode::GetVector.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstVecNode_GetVector(instanceHandle, &sReturnValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFVectorToObject(isolate, sReturnValue));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConstVecNode::GetOutputVector(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnVector = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputVector.");
        if (wrapperTable->m_ConstVecNode_GetOutputVector == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstVecNode::GetOutputVector.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstVecNode_GetOutputVector(instanceHandle, &hReturnVector);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjVector = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnVector);
        args.GetReturnValue().Set(instanceObjVector);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFConstMatNode Implementation
**************************************************************************************************************************/

CLib3MFConstMatNode::CLib3MFConstMatNode()
		: CLib3MFBaseClass()
{
}

CLib3MFConstMatNode::~CLib3MFConstMatNode()
{
}

void CLib3MFConstMatNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFConstMatNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetMatrix", SetMatrix);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMatrix", GetMatrix);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputMatrix", GetOutputMatrix);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFConstMatNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFConstMatNode * constmatnodeInstance = new CLib3MFConstMatNode();
				constmatnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFConstMatNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFConstMatNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFConstMatNode::SetMatrix(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Value)");
        }
        sLib3MFMatrix4x4 sValue = convertObjectToLib3MFMatrix4x4(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetMatrix.");
        if (wrapperTable->m_ConstMatNode_SetMatrix == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstMatNode::SetMatrix.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstMatNode_SetMatrix(instanceHandle, &sValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConstMatNode::GetMatrix(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFMatrix4x4 sReturnValue;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMatrix.");
        if (wrapperTable->m_ConstMatNode_GetMatrix == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstMatNode::GetMatrix.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstMatNode_GetMatrix(instanceHandle, &sReturnValue);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFMatrix4x4ToObject(isolate, sReturnValue));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConstMatNode::GetOutputMatrix(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMatrix = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputMatrix.");
        if (wrapperTable->m_ConstMatNode_GetOutputMatrix == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ConstMatNode::GetOutputMatrix.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ConstMatNode_GetOutputMatrix(instanceHandle, &hReturnMatrix);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMatrix = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnMatrix);
        args.GetReturnValue().Set(instanceObjMatrix);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFMeshNode Implementation
**************************************************************************************************************************/

CLib3MFMeshNode::CLib3MFMeshNode()
		: CLib3MFBaseClass()
{
}

CLib3MFMeshNode::~CLib3MFMeshNode()
{
}

void CLib3MFMeshNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFMeshNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputMesh", GetInputMesh);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputPos", GetInputPos);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputDistance", GetOutputDistance);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFMeshNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFMeshNode * meshnodeInstance = new CLib3MFMeshNode();
				meshnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFMeshNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFMeshNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFMeshNode::GetInputMesh(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMesh = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputMesh.");
        if (wrapperTable->m_MeshNode_GetInputMesh == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshNode::GetInputMesh.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshNode_GetInputMesh(instanceHandle, &hReturnMesh);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMesh = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnMesh);
        args.GetReturnValue().Set(instanceObjMesh);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshNode::GetInputPos(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPos = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputPos.");
        if (wrapperTable->m_MeshNode_GetInputPos == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshNode::GetInputPos.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshNode_GetInputPos(instanceHandle, &hReturnPos);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPos = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPos);
        args.GetReturnValue().Set(instanceObjPos);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFMeshNode::GetOutputDistance(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnDistance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputDistance.");
        if (wrapperTable->m_MeshNode_GetOutputDistance == nullptr)
            throw std::runtime_error("Could not call Lib3MF method MeshNode::GetOutputDistance.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_MeshNode_GetOutputDistance(instanceHandle, &hReturnDistance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjDistance = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnDistance);
        args.GetReturnValue().Set(instanceObjDistance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFUnsignedMeshNode Implementation
**************************************************************************************************************************/

CLib3MFUnsignedMeshNode::CLib3MFUnsignedMeshNode()
		: CLib3MFBaseClass()
{
}

CLib3MFUnsignedMeshNode::~CLib3MFUnsignedMeshNode()
{
}

void CLib3MFUnsignedMeshNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFUnsignedMeshNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputMesh", GetInputMesh);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputPos", GetInputPos);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputDistance", GetOutputDistance);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFUnsignedMeshNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFUnsignedMeshNode * unsignedmeshnodeInstance = new CLib3MFUnsignedMeshNode();
				unsignedmeshnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFUnsignedMeshNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFUnsignedMeshNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFUnsignedMeshNode::GetInputMesh(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMesh = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputMesh.");
        if (wrapperTable->m_UnsignedMeshNode_GetInputMesh == nullptr)
            throw std::runtime_error("Could not call Lib3MF method UnsignedMeshNode::GetInputMesh.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_UnsignedMeshNode_GetInputMesh(instanceHandle, &hReturnMesh);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMesh = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnMesh);
        args.GetReturnValue().Set(instanceObjMesh);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFUnsignedMeshNode::GetInputPos(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPos = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputPos.");
        if (wrapperTable->m_UnsignedMeshNode_GetInputPos == nullptr)
            throw std::runtime_error("Could not call Lib3MF method UnsignedMeshNode::GetInputPos.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_UnsignedMeshNode_GetInputPos(instanceHandle, &hReturnPos);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPos = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPos);
        args.GetReturnValue().Set(instanceObjPos);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFUnsignedMeshNode::GetOutputDistance(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnDistance = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputDistance.");
        if (wrapperTable->m_UnsignedMeshNode_GetOutputDistance == nullptr)
            throw std::runtime_error("Could not call Lib3MF method UnsignedMeshNode::GetOutputDistance.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_UnsignedMeshNode_GetOutputDistance(instanceHandle, &hReturnDistance);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjDistance = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnDistance);
        args.GetReturnValue().Set(instanceObjDistance);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFFunctionCallNode Implementation
**************************************************************************************************************************/

CLib3MFFunctionCallNode::CLib3MFFunctionCallNode()
		: CLib3MFBaseClass()
{
}

CLib3MFFunctionCallNode::~CLib3MFFunctionCallNode()
{
}

void CLib3MFFunctionCallNode::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFunctionCallNode"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputFunctionID", GetInputFunctionID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFunctionCallNode::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFunctionCallNode * functioncallnodeInstance = new CLib3MFFunctionCallNode();
				functioncallnodeInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFunctionCallNode: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFunctionCallNode::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFFunctionCallNode::GetInputFunctionID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnFunction = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputFunctionID.");
        if (wrapperTable->m_FunctionCallNode_GetInputFunctionID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionCallNode::GetInputFunctionID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionCallNode_GetInputFunctionID(instanceHandle, &hReturnFunction);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjFunction = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnFunction);
        args.GetReturnValue().Set(instanceObjFunction);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFNodeIterator Implementation
**************************************************************************************************************************/

CLib3MFNodeIterator::CLib3MFNodeIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFNodeIterator::~CLib3MFNodeIterator()
{
}

void CLib3MFNodeIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFNodeIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrent", GetCurrent);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFNodeIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFNodeIterator * nodeiteratorInstance = new CLib3MFNodeIterator();
				nodeiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFNodeIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFNodeIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFNodeIterator::GetCurrent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrent.");
        if (wrapperTable->m_NodeIterator_GetCurrent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method NodeIterator::GetCurrent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_NodeIterator_GetCurrent(instanceHandle, &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFImplicitNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFFunction Implementation
**************************************************************************************************************************/

CLib3MFFunction::CLib3MFFunction()
		: CLib3MFBaseClass()
{
}

CLib3MFFunction::~CLib3MFFunction()
{
}

void CLib3MFFunction::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFunction"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDisplayName", GetDisplayName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetDisplayName", SetDisplayName);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddInput", AddInput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInputs", GetInputs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveInput", RemoveInput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddOutput", AddOutput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutputs", GetOutputs);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveOutput", RemoveOutput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindInput", FindInput);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindOutput", FindOutput);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFunction::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFunction * functionInstance = new CLib3MFFunction();
				functionInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFunction: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFunction::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFFunction::GetDisplayName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededDisplayName = 0;
        unsigned int bytesWrittenDisplayName = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDisplayName.");
        if (wrapperTable->m_Function_GetDisplayName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::GetDisplayName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Function_GetDisplayName(instanceHandle, 0, &bytesNeededDisplayName, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferDisplayName;
        bufferDisplayName.resize(bytesNeededDisplayName);
        Lib3MFResult errorCode = wrapperTable->m_Function_GetDisplayName(instanceHandle, bytesNeededDisplayName, &bytesWrittenDisplayName, &bufferDisplayName[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferDisplayName[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::SetDisplayName(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (DisplayName)");
        }
        v8::String::Utf8Value sutf8DisplayName(isolate, args[0]);
        std::string sDisplayName = *sutf8DisplayName;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetDisplayName.");
        if (wrapperTable->m_Function_SetDisplayName == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::SetDisplayName.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_SetDisplayName(instanceHandle, sDisplayName.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::AddInput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (Type)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        unsigned int eType = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnPort = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddInput.");
        if (wrapperTable->m_Function_AddInput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::AddInput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_AddInput(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), (eLib3MFImplicitPortType) eType, &hReturnPort);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPort = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPort);
        args.GetReturnValue().Set(instanceObjPort);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::GetInputs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInputs.");
        if (wrapperTable->m_Function_GetInputs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::GetInputs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_GetInputs(instanceHandle, &hReturnIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjIterator = CLib3MFImplicitPortIterator::NewInstance(args.Holder(), hReturnIterator);
        args.GetReturnValue().Set(instanceObjIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::RemoveInput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Input)");
        }
        Local<Object> objInput = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFImplicitPort * instanceInput = ObjectWrap::Unwrap<CLib3MFImplicitPort>(objInput);
        if (instanceInput == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Input)");
        Lib3MFHandle hInput = instanceInput->getHandle( objInput );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveInput.");
        if (wrapperTable->m_Function_RemoveInput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::RemoveInput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_RemoveInput(instanceHandle, hInput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::AddOutput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (Type)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        unsigned int eType = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnPort = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddOutput.");
        if (wrapperTable->m_Function_AddOutput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::AddOutput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_AddOutput(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), (eLib3MFImplicitPortType) eType, &hReturnPort);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPort = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnPort);
        args.GetReturnValue().Set(instanceObjPort);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::GetOutputs(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutputs.");
        if (wrapperTable->m_Function_GetOutputs == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::GetOutputs.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_GetOutputs(instanceHandle, &hReturnIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjIterator = CLib3MFImplicitPortIterator::NewInstance(args.Holder(), hReturnIterator);
        args.GetReturnValue().Set(instanceObjIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::RemoveOutput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Output)");
        }
        Local<Object> objOutput = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFImplicitPort * instanceOutput = ObjectWrap::Unwrap<CLib3MFImplicitPort>(objOutput);
        if (instanceOutput == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Output)");
        Lib3MFHandle hOutput = instanceOutput->getHandle( objOutput );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveOutput.");
        if (wrapperTable->m_Function_RemoveOutput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::RemoveOutput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_RemoveOutput(instanceHandle, hOutput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::FindInput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        Lib3MFHandle hReturnInput = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindInput.");
        if (wrapperTable->m_Function_FindInput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::FindInput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_FindInput(instanceHandle, sIdentifier.c_str(), &hReturnInput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjInput = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnInput);
        args.GetReturnValue().Set(instanceObjInput);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunction::FindOutput(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        Lib3MFHandle hReturnOutput = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindOutput.");
        if (wrapperTable->m_Function_FindOutput == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Function::FindOutput.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Function_FindOutput(instanceHandle, sIdentifier.c_str(), &hReturnOutput);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjOutput = CLib3MFImplicitPort::NewInstance(args.Holder(), hReturnOutput);
        args.GetReturnValue().Set(instanceObjOutput);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFImplicitFunction Implementation
**************************************************************************************************************************/

CLib3MFImplicitFunction::CLib3MFImplicitFunction()
		: CLib3MFBaseClass()
{
}

CLib3MFImplicitFunction::~CLib3MFImplicitFunction()
{
}

void CLib3MFImplicitFunction::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFImplicitFunction"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetIdentifier", GetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetIdentifier", SetIdentifier);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddNode", AddNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSinNode", AddSinNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddCosNode", AddCosNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTanNode", AddTanNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddArcSinNode", AddArcSinNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddArcCosNode", AddArcCosNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddArcTan2Node", AddArcTan2Node);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSinhNode", AddSinhNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddCoshNode", AddCoshNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTanhNode", AddTanhNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddRoundNode", AddRoundNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddCeilNode", AddCeilNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddFloorNode", AddFloorNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSignNode", AddSignNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddFractNode", AddFractNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddAbsNode", AddAbsNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddExpNode", AddExpNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLogNode", AddLogNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLog2Node", AddLog2Node);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLog10Node", AddLog10Node);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLengthNode", AddLengthNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddTransposeNode", AddTransposeNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddInverseNode", AddInverseNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSqrtNode", AddSqrtNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddResourceIdNode", AddResourceIdNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddAdditionNode", AddAdditionNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSubtractionNode", AddSubtractionNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMultiplicationNode", AddMultiplicationNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddDivisionNode", AddDivisionNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddDotNode", AddDotNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddCrossNode", AddCrossNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMatVecMultiplicationNode", AddMatVecMultiplicationNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMinNode", AddMinNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMaxNode", AddMaxNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddFmodNode", AddFmodNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddPowNode", AddPowNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSelectNode", AddSelectNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddClampNode", AddClampNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComposeVectorNode", AddComposeVectorNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddVectorFromScalarNode", AddVectorFromScalarNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddDecomposeVectorNode", AddDecomposeVectorNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddComposeMatrixNode", AddComposeMatrixNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMatrixFromRowsNode", AddMatrixFromRowsNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMatrixFromColumnsNode", AddMatrixFromColumnsNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddConstantNode", AddConstantNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddConstVecNode", AddConstVecNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddConstMatNode", AddConstMatNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddMeshNode", AddMeshNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddUnsignedMeshNode", AddUnsignedMeshNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddFunctionCallNode", AddFunctionCallNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetNodes", GetNodes);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveNode", RemoveNode);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLink", AddLink);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddLinkByNames", AddLinkByNames);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Clear", Clear);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SortNodesTopologically", SortNodesTopologically);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFImplicitFunction::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFImplicitFunction * implicitfunctionInstance = new CLib3MFImplicitFunction();
				implicitfunctionInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFImplicitFunction: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFImplicitFunction::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFImplicitFunction::GetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededIdentifier = 0;
        unsigned int bytesWrittenIdentifier = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetIdentifier.");
        if (wrapperTable->m_ImplicitFunction_GetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::GetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ImplicitFunction_GetIdentifier(instanceHandle, 0, &bytesNeededIdentifier, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferIdentifier;
        bufferIdentifier.resize(bytesNeededIdentifier);
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_GetIdentifier(instanceHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferIdentifier[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::SetIdentifier(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetIdentifier.");
        if (wrapperTable->m_ImplicitFunction_SetIdentifier == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::SetIdentifier.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_SetIdentifier(instanceHandle, sIdentifier.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (NodeType)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Identifier)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (Configuration)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (DisplayName)");
        }
        if (!args[4]->IsString()) {
            throw std::runtime_error("Expected string parameter 4 (Tag)");
        }
        unsigned int eNodeType = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8Identifier(isolate, args[1]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[3]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[4]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddNode.");
        if (wrapperTable->m_ImplicitFunction_AddNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddNode(instanceHandle, (eLib3MFImplicitNodeType) eNodeType, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFImplicitNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddSinNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSinNode.");
        if (wrapperTable->m_ImplicitFunction_AddSinNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddSinNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddSinNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFSinNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddCosNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddCosNode.");
        if (wrapperTable->m_ImplicitFunction_AddCosNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddCosNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddCosNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFCosNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddTanNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTanNode.");
        if (wrapperTable->m_ImplicitFunction_AddTanNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddTanNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddTanNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFTanNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddArcSinNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddArcSinNode.");
        if (wrapperTable->m_ImplicitFunction_AddArcSinNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddArcSinNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddArcSinNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFArcSinNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddArcCosNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddArcCosNode.");
        if (wrapperTable->m_ImplicitFunction_AddArcCosNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddArcCosNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddArcCosNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFArcCosNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddArcTan2Node(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddArcTan2Node.");
        if (wrapperTable->m_ImplicitFunction_AddArcTan2Node == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddArcTan2Node.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddArcTan2Node(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFArcTan2Node::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddSinhNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSinhNode.");
        if (wrapperTable->m_ImplicitFunction_AddSinhNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddSinhNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddSinhNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFSinhNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddCoshNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddCoshNode.");
        if (wrapperTable->m_ImplicitFunction_AddCoshNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddCoshNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddCoshNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFCoshNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddTanhNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTanhNode.");
        if (wrapperTable->m_ImplicitFunction_AddTanhNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddTanhNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddTanhNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFTanhNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddRoundNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddRoundNode.");
        if (wrapperTable->m_ImplicitFunction_AddRoundNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddRoundNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddRoundNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFRoundNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddCeilNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddCeilNode.");
        if (wrapperTable->m_ImplicitFunction_AddCeilNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddCeilNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddCeilNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFCeilNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddFloorNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddFloorNode.");
        if (wrapperTable->m_ImplicitFunction_AddFloorNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddFloorNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddFloorNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFFloorNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddSignNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSignNode.");
        if (wrapperTable->m_ImplicitFunction_AddSignNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddSignNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddSignNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFSignNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddFractNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddFractNode.");
        if (wrapperTable->m_ImplicitFunction_AddFractNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddFractNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddFractNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFFractNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddAbsNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddAbsNode.");
        if (wrapperTable->m_ImplicitFunction_AddAbsNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddAbsNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddAbsNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFAbsNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddExpNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddExpNode.");
        if (wrapperTable->m_ImplicitFunction_AddExpNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddExpNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddExpNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFExpNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddLogNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLogNode.");
        if (wrapperTable->m_ImplicitFunction_AddLogNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddLogNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddLogNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFLogNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddLog2Node(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLog2Node.");
        if (wrapperTable->m_ImplicitFunction_AddLog2Node == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddLog2Node.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddLog2Node(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFLog2Node::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddLog10Node(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLog10Node.");
        if (wrapperTable->m_ImplicitFunction_AddLog10Node == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddLog10Node.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddLog10Node(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFLog10Node::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddLengthNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLengthNode.");
        if (wrapperTable->m_ImplicitFunction_AddLengthNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddLengthNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddLengthNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFLengthNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddTransposeNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddTransposeNode.");
        if (wrapperTable->m_ImplicitFunction_AddTransposeNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddTransposeNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddTransposeNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFTransposeNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddInverseNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddInverseNode.");
        if (wrapperTable->m_ImplicitFunction_AddInverseNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddInverseNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddInverseNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFInverseNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddSqrtNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSqrtNode.");
        if (wrapperTable->m_ImplicitFunction_AddSqrtNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddSqrtNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddSqrtNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFSqrtNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddResourceIdNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddResourceIdNode.");
        if (wrapperTable->m_ImplicitFunction_AddResourceIdNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddResourceIdNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddResourceIdNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFResourceIdNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddAdditionNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddAdditionNode.");
        if (wrapperTable->m_ImplicitFunction_AddAdditionNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddAdditionNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddAdditionNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFAdditionNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddSubtractionNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSubtractionNode.");
        if (wrapperTable->m_ImplicitFunction_AddSubtractionNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddSubtractionNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddSubtractionNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFSubtractionNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMultiplicationNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMultiplicationNode.");
        if (wrapperTable->m_ImplicitFunction_AddMultiplicationNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMultiplicationNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMultiplicationNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMultiplicationNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddDivisionNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddDivisionNode.");
        if (wrapperTable->m_ImplicitFunction_AddDivisionNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddDivisionNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddDivisionNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFDivisionNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddDotNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddDotNode.");
        if (wrapperTable->m_ImplicitFunction_AddDotNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddDotNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddDotNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFDotNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddCrossNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddCrossNode.");
        if (wrapperTable->m_ImplicitFunction_AddCrossNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddCrossNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddCrossNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFCrossNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMatVecMultiplicationNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMatVecMultiplicationNode.");
        if (wrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMatVecMultiplicationNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMatVecMultiplicationNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMinNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMinNode.");
        if (wrapperTable->m_ImplicitFunction_AddMinNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMinNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMinNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMinNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMaxNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMaxNode.");
        if (wrapperTable->m_ImplicitFunction_AddMaxNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMaxNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMaxNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMaxNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddFmodNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddFmodNode.");
        if (wrapperTable->m_ImplicitFunction_AddFmodNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddFmodNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddFmodNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFFmodNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddPowNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddPowNode.");
        if (wrapperTable->m_ImplicitFunction_AddPowNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddPowNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddPowNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFPowNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddSelectNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSelectNode.");
        if (wrapperTable->m_ImplicitFunction_AddSelectNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddSelectNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddSelectNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFSelectNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddClampNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (Configuration)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (DisplayName)");
        }
        if (!args[3]->IsString()) {
            throw std::runtime_error("Expected string parameter 3 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        unsigned int eConfiguration = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        v8::String::Utf8Value sutf8DisplayName(isolate, args[2]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[3]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddClampNode.");
        if (wrapperTable->m_ImplicitFunction_AddClampNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddClampNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddClampNode(instanceHandle, sIdentifier.c_str(), (eLib3MFImplicitNodeConfiguration) eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFClampNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddComposeVectorNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComposeVectorNode.");
        if (wrapperTable->m_ImplicitFunction_AddComposeVectorNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddComposeVectorNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddComposeVectorNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFComposeVectorNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddVectorFromScalarNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddVectorFromScalarNode.");
        if (wrapperTable->m_ImplicitFunction_AddVectorFromScalarNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddVectorFromScalarNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddVectorFromScalarNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFVectorFromScalarNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddDecomposeVectorNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddDecomposeVectorNode.");
        if (wrapperTable->m_ImplicitFunction_AddDecomposeVectorNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddDecomposeVectorNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddDecomposeVectorNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFDecomposeVectorNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddComposeMatrixNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddComposeMatrixNode.");
        if (wrapperTable->m_ImplicitFunction_AddComposeMatrixNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddComposeMatrixNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddComposeMatrixNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFComposeMatrixNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMatrixFromRowsNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMatrixFromRowsNode.");
        if (wrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMatrixFromRowsNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMatrixFromRowsNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMatrixFromColumnsNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMatrixFromColumnsNode.");
        if (wrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMatrixFromColumnsNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMatrixFromColumnsNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddConstantNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddConstantNode.");
        if (wrapperTable->m_ImplicitFunction_AddConstantNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddConstantNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddConstantNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFConstantNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddConstVecNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddConstVecNode.");
        if (wrapperTable->m_ImplicitFunction_AddConstVecNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddConstVecNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddConstVecNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFConstVecNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddConstMatNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddConstMatNode.");
        if (wrapperTable->m_ImplicitFunction_AddConstMatNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddConstMatNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddConstMatNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFConstMatNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddMeshNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddMeshNode.");
        if (wrapperTable->m_ImplicitFunction_AddMeshNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddMeshNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddMeshNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFMeshNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddUnsignedMeshNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddUnsignedMeshNode.");
        if (wrapperTable->m_ImplicitFunction_AddUnsignedMeshNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddUnsignedMeshNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddUnsignedMeshNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFUnsignedMeshNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddFunctionCallNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Identifier)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (DisplayName)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (Tag)");
        }
        v8::String::Utf8Value sutf8Identifier(isolate, args[0]);
        std::string sIdentifier = *sutf8Identifier;
        v8::String::Utf8Value sutf8DisplayName(isolate, args[1]);
        std::string sDisplayName = *sutf8DisplayName;
        v8::String::Utf8Value sutf8Tag(isolate, args[2]);
        std::string sTag = *sutf8Tag;
        Lib3MFHandle hReturnNode = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddFunctionCallNode.");
        if (wrapperTable->m_ImplicitFunction_AddFunctionCallNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddFunctionCallNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddFunctionCallNode(instanceHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hReturnNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjNode = CLib3MFFunctionCallNode::NewInstance(args.Holder(), hReturnNode);
        args.GetReturnValue().Set(instanceObjNode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::GetNodes(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetNodes.");
        if (wrapperTable->m_ImplicitFunction_GetNodes == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::GetNodes.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_GetNodes(instanceHandle, &hReturnIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjIterator = CLib3MFNodeIterator::NewInstance(args.Holder(), hReturnIterator);
        args.GetReturnValue().Set(instanceObjIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::RemoveNode(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Node)");
        }
        Local<Object> objNode = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFImplicitNode * instanceNode = ObjectWrap::Unwrap<CLib3MFImplicitNode>(objNode);
        if (instanceNode == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Node)");
        Lib3MFHandle hNode = instanceNode->getHandle( objNode );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveNode.");
        if (wrapperTable->m_ImplicitFunction_RemoveNode == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::RemoveNode.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_RemoveNode(instanceHandle, hNode);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddLink(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Source)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected class parameter 1 (Target)");
        }
        Local<Object> objSource = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFImplicitPort * instanceSource = ObjectWrap::Unwrap<CLib3MFImplicitPort>(objSource);
        if (instanceSource == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Source)");
        Lib3MFHandle hSource = instanceSource->getHandle( objSource );
        Local<Object> objTarget = args[1]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFImplicitPort * instanceTarget = ObjectWrap::Unwrap<CLib3MFImplicitPort>(objTarget);
        if (instanceTarget == nullptr)
            throw std::runtime_error("Invalid Object parameter 1 (Target)");
        Lib3MFHandle hTarget = instanceTarget->getHandle( objTarget );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLink.");
        if (wrapperTable->m_ImplicitFunction_AddLink == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddLink.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddLink(instanceHandle, hSource, hTarget);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::AddLinkByNames(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Source)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (Target)");
        }
        v8::String::Utf8Value sutf8Source(isolate, args[0]);
        std::string sSource = *sutf8Source;
        v8::String::Utf8Value sutf8Target(isolate, args[1]);
        std::string sTarget = *sutf8Target;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddLinkByNames.");
        if (wrapperTable->m_ImplicitFunction_AddLinkByNames == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::AddLinkByNames.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_AddLinkByNames(instanceHandle, sSource.c_str(), sTarget.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::Clear(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Clear.");
        if (wrapperTable->m_ImplicitFunction_Clear == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::Clear.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_Clear(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFImplicitFunction::SortNodesTopologically(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SortNodesTopologically.");
        if (wrapperTable->m_ImplicitFunction_SortNodesTopologically == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ImplicitFunction::SortNodesTopologically.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ImplicitFunction_SortNodesTopologically(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFFunctionFromImage3D Implementation
**************************************************************************************************************************/

CLib3MFFunctionFromImage3D::CLib3MFFunctionFromImage3D()
		: CLib3MFBaseClass()
{
}

CLib3MFFunctionFromImage3D::~CLib3MFFunctionFromImage3D()
{
}

void CLib3MFFunctionFromImage3D::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFFunctionFromImage3D"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetImage3D", GetImage3D);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetImage3D", SetImage3D);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetFilter", SetFilter);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetFilter", GetFilter);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetTileStyles", SetTileStyles);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetTileStyles", GetTileStyles);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOffset", GetOffset);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetOffset", SetOffset);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetScale", GetScale);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetScale", SetScale);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFFunctionFromImage3D::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFFunctionFromImage3D * functionfromimage3dInstance = new CLib3MFFunctionFromImage3D();
				functionfromimage3dInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFFunctionFromImage3D: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFFunctionFromImage3D::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFFunctionFromImage3D::GetImage3D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnImage3D = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetImage3D.");
        if (wrapperTable->m_FunctionFromImage3D_GetImage3D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::GetImage3D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_GetImage3D(instanceHandle, &hReturnImage3D);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjImage3D = CLib3MFImage3D::NewInstance(args.Holder(), hReturnImage3D);
        args.GetReturnValue().Set(instanceObjImage3D);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::SetImage3D(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Image3D)");
        }
        Local<Object> objImage3D = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFImage3D * instanceImage3D = ObjectWrap::Unwrap<CLib3MFImage3D>(objImage3D);
        if (instanceImage3D == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Image3D)");
        Lib3MFHandle hImage3D = instanceImage3D->getHandle( objImage3D );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetImage3D.");
        if (wrapperTable->m_FunctionFromImage3D_SetImage3D == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::SetImage3D.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_SetImage3D(instanceHandle, hImage3D);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::SetFilter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (Filter)");
        }
        unsigned int eFilter = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetFilter.");
        if (wrapperTable->m_FunctionFromImage3D_SetFilter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::SetFilter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_SetFilter(instanceHandle, (eLib3MFTextureFilter) eFilter);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::GetFilter(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFTextureFilter eReturnFilter;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetFilter.");
        if (wrapperTable->m_FunctionFromImage3D_GetFilter == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::GetFilter.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_GetFilter(instanceHandle, &eReturnFilter);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnFilter));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::SetTileStyles(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 0 (TileStyleU)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (TileStyleV)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (TileStyleW)");
        }
        unsigned int eTileStyleU = (unsigned int) args[0]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eTileStyleV = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eTileStyleW = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetTileStyles.");
        if (wrapperTable->m_FunctionFromImage3D_SetTileStyles == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::SetTileStyles.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_SetTileStyles(instanceHandle, (eLib3MFTextureTileStyle) eTileStyleU, (eLib3MFTextureTileStyle) eTileStyleV, (eLib3MFTextureTileStyle) eTileStyleW);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::GetTileStyles(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        eLib3MFTextureTileStyle eReturnTileStyleU;
        eLib3MFTextureTileStyle eReturnTileStyleV;
        eLib3MFTextureTileStyle eReturnTileStyleW;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetTileStyles.");
        if (wrapperTable->m_FunctionFromImage3D_GetTileStyles == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::GetTileStyles.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_GetTileStyles(instanceHandle, &eReturnTileStyleU, &eReturnTileStyleV, &eReturnTileStyleW);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleU"), Integer::New(isolate, (int)eReturnTileStyleU));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleV"), Integer::New(isolate, (int)eReturnTileStyleV));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "TileStyleW"), Integer::New(isolate, (int)eReturnTileStyleW));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::GetOffset(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnOffset = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOffset.");
        if (wrapperTable->m_FunctionFromImage3D_GetOffset == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::GetOffset.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_GetOffset(instanceHandle, &dReturnOffset);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnOffset));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::SetOffset(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (Offset)");
        }
        double dOffset = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetOffset.");
        if (wrapperTable->m_FunctionFromImage3D_SetOffset == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::SetOffset.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_SetOffset(instanceHandle, dOffset);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::GetScale(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnScale = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetScale.");
        if (wrapperTable->m_FunctionFromImage3D_GetScale == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::GetScale.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_GetScale(instanceHandle, &dReturnScale);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnScale));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFFunctionFromImage3D::SetScale(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (Scale)");
        }
        double dScale = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetScale.");
        if (wrapperTable->m_FunctionFromImage3D_SetScale == nullptr)
            throw std::runtime_error("Could not call Lib3MF method FunctionFromImage3D::SetScale.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_FunctionFromImage3D_SetScale(instanceHandle, dScale);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBuildItem Implementation
**************************************************************************************************************************/

CLib3MFBuildItem::CLib3MFBuildItem()
		: CLib3MFBaseClass()
{
}

CLib3MFBuildItem::~CLib3MFBuildItem()
{
}

void CLib3MFBuildItem::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBuildItem"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResource", GetObjectResource);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectResourceID", GetObjectResourceID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "HasObjectTransform", HasObjectTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetObjectTransform", GetObjectTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetObjectTransform", SetObjectTransform);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPartNumber", GetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPartNumber", SetPartNumber);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMetaDataGroup", GetMetaDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOutbox", GetOutbox);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBuildItem::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBuildItem * builditemInstance = new CLib3MFBuildItem();
				builditemInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBuildItem: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBuildItem::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBuildItem::GetObjectResource(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnObjectResource = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResource.");
        if (wrapperTable->m_BuildItem_GetObjectResource == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetObjectResource.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetObjectResource(instanceHandle, &hReturnObjectResource);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjObjectResource = CLib3MFObject::NewInstance(args.Holder(), hReturnObjectResource);
        args.GetReturnValue().Set(instanceObjObjectResource);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Local<Object> outObject = Object::New(isolate);
        bool bReturnHasUUID = false;
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetUUID.");
        if (wrapperTable->m_BuildItem_GetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BuildItem_GetUUID(instanceHandle, &bReturnHasUUID, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetUUID(instanceHandle, &bReturnHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "HasUUID"), Boolean::New(isolate, bReturnHasUUID));
        outObject->Set(isolate->GetCurrentContext(), String::NewFromUtf8(isolate, "UUID"), String::NewFromUtf8(isolate, &bufferUUID[0]));
        args.GetReturnValue().Set(outObject);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::SetUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (UUID)");
        }
        v8::String::Utf8Value sutf8UUID(isolate, args[0]);
        std::string sUUID = *sutf8UUID;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetUUID.");
        if (wrapperTable->m_BuildItem_SetUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::SetUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_SetUUID(instanceHandle, sUUID.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetObjectResourceID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int nReturnUniqueResourceID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectResourceID.");
        if (wrapperTable->m_BuildItem_GetObjectResourceID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetObjectResourceID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetObjectResourceID(instanceHandle, &nReturnUniqueResourceID);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::NewFromUnsigned(isolate, nReturnUniqueResourceID));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::HasObjectTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasTransform = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method HasObjectTransform.");
        if (wrapperTable->m_BuildItem_HasObjectTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::HasObjectTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_HasObjectTransform(instanceHandle, &bReturnHasTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetObjectTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFTransform sReturnTransform;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetObjectTransform.");
        if (wrapperTable->m_BuildItem_GetObjectTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetObjectTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetObjectTransform(instanceHandle, &sReturnTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFTransformToObject(isolate, sReturnTransform));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::SetObjectTransform(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected struct parameter 0 (Transform)");
        }
        sLib3MFTransform sTransform = convertObjectToLib3MFTransform(isolate, args[0]);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetObjectTransform.");
        if (wrapperTable->m_BuildItem_SetObjectTransform == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::SetObjectTransform.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_SetObjectTransform(instanceHandle, &sTransform);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPartNumber = 0;
        unsigned int bytesWrittenPartNumber = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPartNumber.");
        if (wrapperTable->m_BuildItem_GetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_BuildItem_GetPartNumber(instanceHandle, 0, &bytesNeededPartNumber, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPartNumber;
        bufferPartNumber.resize(bytesNeededPartNumber);
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetPartNumber(instanceHandle, bytesNeededPartNumber, &bytesWrittenPartNumber, &bufferPartNumber[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPartNumber[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::SetPartNumber(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (SetPartnumber)");
        }
        v8::String::Utf8Value sutf8SetPartnumber(isolate, args[0]);
        std::string sSetPartnumber = *sutf8SetPartnumber;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPartNumber.");
        if (wrapperTable->m_BuildItem_SetPartNumber == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::SetPartNumber.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_SetPartNumber(instanceHandle, sSetPartnumber.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetMetaDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnMetaDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMetaDataGroup.");
        if (wrapperTable->m_BuildItem_GetMetaDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetMetaDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetMetaDataGroup(instanceHandle, &hReturnMetaDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjMetaDataGroup = CLib3MFMetaDataGroup::NewInstance(args.Holder(), hReturnMetaDataGroup);
        args.GetReturnValue().Set(instanceObjMetaDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItem::GetOutbox(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFBox sReturnOutbox;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOutbox.");
        if (wrapperTable->m_BuildItem_GetOutbox == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItem::GetOutbox.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItem_GetOutbox(instanceHandle, &sReturnOutbox);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(convertLib3MFBoxToObject(isolate, sReturnOutbox));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFBuildItemIterator Implementation
**************************************************************************************************************************/

CLib3MFBuildItemIterator::CLib3MFBuildItemIterator()
		: CLib3MFBaseClass()
{
}

CLib3MFBuildItemIterator::~CLib3MFBuildItemIterator()
{
}

void CLib3MFBuildItemIterator::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFBuildItemIterator"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "MoveNext", MoveNext);
		NODE_SET_PROTOTYPE_METHOD(tpl, "MovePrevious", MovePrevious);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCurrent", GetCurrent);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Clone", Clone);
		NODE_SET_PROTOTYPE_METHOD(tpl, "Count", Count);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFBuildItemIterator::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFBuildItemIterator * builditemiteratorInstance = new CLib3MFBuildItemIterator();
				builditemiteratorInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFBuildItemIterator: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFBuildItemIterator::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFBuildItemIterator::MoveNext(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasNext = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MoveNext.");
        if (wrapperTable->m_BuildItemIterator_MoveNext == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::MoveNext.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_MoveNext(instanceHandle, &bReturnHasNext);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasNext));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::MovePrevious(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        bool bReturnHasPrevious = false;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method MovePrevious.");
        if (wrapperTable->m_BuildItemIterator_MovePrevious == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::MovePrevious.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_MovePrevious(instanceHandle, &bReturnHasPrevious);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Boolean::New(isolate, bReturnHasPrevious));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::GetCurrent(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnBuildItem = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCurrent.");
        if (wrapperTable->m_BuildItemIterator_GetCurrent == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::GetCurrent.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_GetCurrent(instanceHandle, &hReturnBuildItem);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjBuildItem = CLib3MFBuildItem::NewInstance(args.Holder(), hReturnBuildItem);
        args.GetReturnValue().Set(instanceObjBuildItem);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::Clone(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnOutBuildItemIterator = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Clone.");
        if (wrapperTable->m_BuildItemIterator_Clone == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::Clone.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_Clone(instanceHandle, &hReturnOutBuildItemIterator);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjOutBuildItemIterator = CLib3MFBuildItemIterator::NewInstance(args.Holder(), hReturnOutBuildItemIterator);
        args.GetReturnValue().Set(instanceObjOutBuildItemIterator);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFBuildItemIterator::Count(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method Count.");
        if (wrapperTable->m_BuildItemIterator_Count == nullptr)
            throw std::runtime_error("Could not call Lib3MF method BuildItemIterator::Count.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_BuildItemIterator_Count(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSlice Implementation
**************************************************************************************************************************/

CLib3MFSlice::CLib3MFSlice()
		: CLib3MFBaseClass()
{
}

CLib3MFSlice::~CLib3MFSlice()
{
}

void CLib3MFSlice::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSlice"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetVertices", SetVertices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertices", GetVertices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetVertexCount", GetVertexCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddPolygon", AddPolygon);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPolygonCount", GetPolygonCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetPolygonIndices", SetPolygonIndices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPolygonIndices", GetPolygonIndices);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPolygonIndexCount", GetPolygonIndexCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetZTop", GetZTop);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSlice::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSlice * sliceInstance = new CLib3MFSlice();
				sliceInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSlice: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSlice::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSlice::SetVertices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetVertices.");
        if (wrapperTable->m_Slice_SetVertices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::SetVertices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_SetVertices(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetVertices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertices.");
        if (wrapperTable->m_Slice_GetVertices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetVertices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetVertices(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetVertexCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetVertexCount.");
        if (wrapperTable->m_Slice_GetVertexCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetVertexCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetVertexCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::AddPolygon(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnIndex = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddPolygon.");
        if (wrapperTable->m_Slice_AddPolygon == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::AddPolygon.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_AddPolygon(instanceHandle, 0, nullptr, &nReturnIndex);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnIndex).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetPolygonCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPolygonCount.");
        if (wrapperTable->m_Slice_GetPolygonCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetPolygonCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetPolygonCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::SetPolygonIndices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (Index)");
        }
        v8::String::Utf8Value sutf8Index(isolate, args[0]);
        std::string sIndex = *sutf8Index;
        uint64_t nIndex = stoull(sIndex);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetPolygonIndices.");
        if (wrapperTable->m_Slice_SetPolygonIndices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::SetPolygonIndices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_SetPolygonIndices(instanceHandle, nIndex, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetPolygonIndices(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (Index)");
        }
        v8::String::Utf8Value sutf8Index(isolate, args[0]);
        std::string sIndex = *sutf8Index;
        uint64_t nIndex = stoull(sIndex);
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPolygonIndices.");
        if (wrapperTable->m_Slice_GetPolygonIndices == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetPolygonIndices.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetPolygonIndices(instanceHandle, nIndex, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetPolygonIndexCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (Index)");
        }
        v8::String::Utf8Value sutf8Index(isolate, args[0]);
        std::string sIndex = *sutf8Index;
        uint64_t nIndex = stoull(sIndex);
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPolygonIndexCount.");
        if (wrapperTable->m_Slice_GetPolygonIndexCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetPolygonIndexCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetPolygonIndexCount(instanceHandle, nIndex, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSlice::GetZTop(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnZTop = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetZTop.");
        if (wrapperTable->m_Slice_GetZTop == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Slice::GetZTop.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_Slice_GetZTop(instanceHandle, &dReturnZTop);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnZTop));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFSliceStack Implementation
**************************************************************************************************************************/

CLib3MFSliceStack::CLib3MFSliceStack()
		: CLib3MFBaseClass()
{
}

CLib3MFSliceStack::~CLib3MFSliceStack()
{
}

void CLib3MFSliceStack::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFSliceStack"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetBottomZ", GetBottomZ);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceCount", GetSliceCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSlice", GetSlice);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSlice", AddSlice);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceRefCount", GetSliceRefCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddSliceStackReference", AddSliceStackReference);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetSliceStackReference", GetSliceStackReference);
		NODE_SET_PROTOTYPE_METHOD(tpl, "CollapseSliceReferences", CollapseSliceReferences);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetOwnPath", SetOwnPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetOwnPath", GetOwnPath);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFSliceStack::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFSliceStack * slicestackInstance = new CLib3MFSliceStack();
				slicestackInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFSliceStack: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFSliceStack::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFSliceStack::GetBottomZ(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        double dReturnZBottom = 0.0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetBottomZ.");
        if (wrapperTable->m_SliceStack_GetBottomZ == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetBottomZ.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetBottomZ(instanceHandle, &dReturnZBottom);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Number::New(isolate, dReturnZBottom));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSliceCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceCount.");
        if (wrapperTable->m_SliceStack_GetSliceCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSliceCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSliceCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSlice(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (SliceIndex)");
        }
        v8::String::Utf8Value sutf8SliceIndex(isolate, args[0]);
        std::string sSliceIndex = *sutf8SliceIndex;
        uint64_t nSliceIndex = stoull(sSliceIndex);
        Lib3MFHandle hReturnTheSlice = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSlice.");
        if (wrapperTable->m_SliceStack_GetSlice == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSlice.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSlice(instanceHandle, nSliceIndex, &hReturnTheSlice);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheSlice = CLib3MFSlice::NewInstance(args.Holder(), hReturnTheSlice);
        args.GetReturnValue().Set(instanceObjTheSlice);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::AddSlice(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsNumber()) {
            throw std::runtime_error("Expected double parameter 0 (ZTop)");
        }
        double dZTop = (double) args[0]->NumberValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheSlice = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSlice.");
        if (wrapperTable->m_SliceStack_AddSlice == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::AddSlice.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_AddSlice(instanceHandle, dZTop, &hReturnTheSlice);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheSlice = CLib3MFSlice::NewInstance(args.Holder(), hReturnTheSlice);
        args.GetReturnValue().Set(instanceObjTheSlice);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSliceRefCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceRefCount.");
        if (wrapperTable->m_SliceStack_GetSliceRefCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSliceRefCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSliceRefCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::AddSliceStackReference(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (TheSliceStack)");
        }
        Local<Object> objTheSliceStack = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFSliceStack * instanceTheSliceStack = ObjectWrap::Unwrap<CLib3MFSliceStack>(objTheSliceStack);
        if (instanceTheSliceStack == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (TheSliceStack)");
        Lib3MFHandle hTheSliceStack = instanceTheSliceStack->getHandle( objTheSliceStack );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddSliceStackReference.");
        if (wrapperTable->m_SliceStack_AddSliceStackReference == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::AddSliceStackReference.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_AddSliceStackReference(instanceHandle, hTheSliceStack);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetSliceStackReference(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (SliceRefIndex)");
        }
        v8::String::Utf8Value sutf8SliceRefIndex(isolate, args[0]);
        std::string sSliceRefIndex = *sutf8SliceRefIndex;
        uint64_t nSliceRefIndex = stoull(sSliceRefIndex);
        Lib3MFHandle hReturnTheSliceStack = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetSliceStackReference.");
        if (wrapperTable->m_SliceStack_GetSliceStackReference == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetSliceStackReference.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetSliceStackReference(instanceHandle, nSliceRefIndex, &hReturnTheSliceStack);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheSliceStack = CLib3MFSliceStack::NewInstance(args.Holder(), hReturnTheSliceStack);
        args.GetReturnValue().Set(instanceObjTheSliceStack);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::CollapseSliceReferences(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method CollapseSliceReferences.");
        if (wrapperTable->m_SliceStack_CollapseSliceReferences == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::CollapseSliceReferences.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_CollapseSliceReferences(instanceHandle);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::SetOwnPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (Path)");
        }
        v8::String::Utf8Value sutf8Path(isolate, args[0]);
        std::string sPath = *sutf8Path;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetOwnPath.");
        if (wrapperTable->m_SliceStack_SetOwnPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::SetOwnPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_SetOwnPath(instanceHandle, sPath.c_str());
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFSliceStack::GetOwnPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededPath = 0;
        unsigned int bytesWrittenPath = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetOwnPath.");
        if (wrapperTable->m_SliceStack_GetOwnPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method SliceStack::GetOwnPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_SliceStack_GetOwnPath(instanceHandle, 0, &bytesNeededPath, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferPath;
        bufferPath.resize(bytesNeededPath);
        Lib3MFResult errorCode = wrapperTable->m_SliceStack_GetOwnPath(instanceHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferPath[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFConsumer Implementation
**************************************************************************************************************************/

CLib3MFConsumer::CLib3MFConsumer()
		: CLib3MFBaseClass()
{
}

CLib3MFConsumer::~CLib3MFConsumer()
{
}

void CLib3MFConsumer::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFConsumer"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumerID", GetConsumerID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyID", GetKeyID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyValue", GetKeyValue);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFConsumer::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFConsumer * consumerInstance = new CLib3MFConsumer();
				consumerInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFConsumer: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFConsumer::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFConsumer::GetConsumerID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededConsumerID = 0;
        unsigned int bytesWrittenConsumerID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumerID.");
        if (wrapperTable->m_Consumer_GetConsumerID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Consumer::GetConsumerID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Consumer_GetConsumerID(instanceHandle, 0, &bytesNeededConsumerID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferConsumerID;
        bufferConsumerID.resize(bytesNeededConsumerID);
        Lib3MFResult errorCode = wrapperTable->m_Consumer_GetConsumerID(instanceHandle, bytesNeededConsumerID, &bytesWrittenConsumerID, &bufferConsumerID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferConsumerID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConsumer::GetKeyID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededKeyID = 0;
        unsigned int bytesWrittenKeyID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyID.");
        if (wrapperTable->m_Consumer_GetKeyID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Consumer::GetKeyID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Consumer_GetKeyID(instanceHandle, 0, &bytesNeededKeyID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferKeyID;
        bufferKeyID.resize(bytesNeededKeyID);
        Lib3MFResult errorCode = wrapperTable->m_Consumer_GetKeyID(instanceHandle, bytesNeededKeyID, &bytesWrittenKeyID, &bufferKeyID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferKeyID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFConsumer::GetKeyValue(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededKeyValue = 0;
        unsigned int bytesWrittenKeyValue = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyValue.");
        if (wrapperTable->m_Consumer_GetKeyValue == nullptr)
            throw std::runtime_error("Could not call Lib3MF method Consumer::GetKeyValue.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_Consumer_GetKeyValue(instanceHandle, 0, &bytesNeededKeyValue, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferKeyValue;
        bufferKeyValue.resize(bytesNeededKeyValue);
        Lib3MFResult errorCode = wrapperTable->m_Consumer_GetKeyValue(instanceHandle, bytesNeededKeyValue, &bytesWrittenKeyValue, &bufferKeyValue[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferKeyValue[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFAccessRight Implementation
**************************************************************************************************************************/

CLib3MFAccessRight::CLib3MFAccessRight()
		: CLib3MFBaseClass()
{
}

CLib3MFAccessRight::~CLib3MFAccessRight()
{
}

void CLib3MFAccessRight::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFAccessRight"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumer", GetConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetWrappingAlgorithm", GetWrappingAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetMgfAlgorithm", GetMgfAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDigestMethod", GetDigestMethod);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFAccessRight::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFAccessRight * accessrightInstance = new CLib3MFAccessRight();
				accessrightInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFAccessRight: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFAccessRight::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFAccessRight::GetConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumer.");
        if (wrapperTable->m_AccessRight_GetConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetConsumer(instanceHandle, &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAccessRight::GetWrappingAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFWrappingAlgorithm eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetWrappingAlgorithm.");
        if (wrapperTable->m_AccessRight_GetWrappingAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetWrappingAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetWrappingAlgorithm(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAccessRight::GetMgfAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFMgfAlgorithm eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetMgfAlgorithm.");
        if (wrapperTable->m_AccessRight_GetMgfAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetMgfAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetMgfAlgorithm(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFAccessRight::GetDigestMethod(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFDigestMethod eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDigestMethod.");
        if (wrapperTable->m_AccessRight_GetDigestMethod == nullptr)
            throw std::runtime_error("Could not call Lib3MF method AccessRight::GetDigestMethod.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_AccessRight_GetDigestMethod(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFContentEncryptionParams Implementation
**************************************************************************************************************************/

CLib3MFContentEncryptionParams::CLib3MFContentEncryptionParams()
		: CLib3MFBaseClass()
{
}

CLib3MFContentEncryptionParams::~CLib3MFContentEncryptionParams()
{
}

void CLib3MFContentEncryptionParams::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFContentEncryptionParams"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetEncryptionAlgorithm", GetEncryptionAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKey", GetKey);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetInitializationVector", GetInitializationVector);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAuthenticationTag", GetAuthenticationTag);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetAuthenticationTag", SetAuthenticationTag);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAdditionalAuthenticationData", GetAdditionalAuthenticationData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetDescriptor", GetDescriptor);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyUUID", GetKeyUUID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFContentEncryptionParams::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFContentEncryptionParams * contentencryptionparamsInstance = new CLib3MFContentEncryptionParams();
				contentencryptionparamsInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFContentEncryptionParams: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFContentEncryptionParams::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFContentEncryptionParams::GetEncryptionAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFEncryptionAlgorithm eReturnAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetEncryptionAlgorithm.");
        if (wrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetEncryptionAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm(instanceHandle, &eReturnAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetKey(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKey.");
        if (wrapperTable->m_ContentEncryptionParams_GetKey == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetKey.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetKey(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetInitializationVector(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetInitializationVector.");
        if (wrapperTable->m_ContentEncryptionParams_GetInitializationVector == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetInitializationVector.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetInitializationVector(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetAuthenticationTag(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAuthenticationTag.");
        if (wrapperTable->m_ContentEncryptionParams_GetAuthenticationTag == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetAuthenticationTag.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetAuthenticationTag(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::SetAuthenticationTag(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method SetAuthenticationTag.");
        if (wrapperTable->m_ContentEncryptionParams_SetAuthenticationTag == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::SetAuthenticationTag.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_SetAuthenticationTag(instanceHandle, 0, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetAdditionalAuthenticationData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAdditionalAuthenticationData.");
        if (wrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetAdditionalAuthenticationData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetDescriptor(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnDescriptor = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetDescriptor.");
        if (wrapperTable->m_ContentEncryptionParams_GetDescriptor == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetDescriptor.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetDescriptor(instanceHandle, &nReturnDescriptor);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnDescriptor).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFContentEncryptionParams::GetKeyUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyUUID.");
        if (wrapperTable->m_ContentEncryptionParams_GetKeyUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ContentEncryptionParams::GetKeyUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ContentEncryptionParams_GetKeyUUID(instanceHandle, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_ContentEncryptionParams_GetKeyUUID(instanceHandle, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferUUID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResourceData Implementation
**************************************************************************************************************************/

CLib3MFResourceData::CLib3MFResourceData()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceData::~CLib3MFResourceData()
{
}

void CLib3MFResourceData::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceData"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetPath", GetPath);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetEncryptionAlgorithm", GetEncryptionAlgorithm);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetCompression", GetCompression);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetAdditionalAuthenticationData", GetAdditionalAuthenticationData);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceData::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceData * resourcedataInstance = new CLib3MFResourceData();
				resourcedataInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceData: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceData::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceData::GetPath(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnPath = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetPath.");
        if (wrapperTable->m_ResourceData_GetPath == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetPath.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetPath(instanceHandle, &hReturnPath);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjPath = CLib3MFPackagePart::NewInstance(args.Holder(), hReturnPath);
        args.GetReturnValue().Set(instanceObjPath);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceData::GetEncryptionAlgorithm(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFEncryptionAlgorithm eReturnEncryptionAlgorithm;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetEncryptionAlgorithm.");
        if (wrapperTable->m_ResourceData_GetEncryptionAlgorithm == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetEncryptionAlgorithm.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetEncryptionAlgorithm(instanceHandle, &eReturnEncryptionAlgorithm);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnEncryptionAlgorithm));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceData::GetCompression(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        eLib3MFCompression eReturnCompression;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetCompression.");
        if (wrapperTable->m_ResourceData_GetCompression == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetCompression.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetCompression(instanceHandle, &eReturnCompression);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(Integer::New(isolate, (int)eReturnCompression));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceData::GetAdditionalAuthenticationData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetAdditionalAuthenticationData.");
        if (wrapperTable->m_ResourceData_GetAdditionalAuthenticationData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceData::GetAdditionalAuthenticationData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceData_GetAdditionalAuthenticationData(instanceHandle, 0, nullptr, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFResourceDataGroup Implementation
**************************************************************************************************************************/

CLib3MFResourceDataGroup::CLib3MFResourceDataGroup()
		: CLib3MFBaseClass()
{
}

CLib3MFResourceDataGroup::~CLib3MFResourceDataGroup()
{
}

void CLib3MFResourceDataGroup::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFResourceDataGroup"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetKeyUUID", GetKeyUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddAccessRight", AddAccessRight);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindAccessRightByConsumer", FindAccessRightByConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveAccessRight", RemoveAccessRight);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFResourceDataGroup::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFResourceDataGroup * resourcedatagroupInstance = new CLib3MFResourceDataGroup();
				resourcedatagroupInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFResourceDataGroup: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFResourceDataGroup::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFResourceDataGroup::GetKeyUUID(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        unsigned int bytesNeededUUID = 0;
        unsigned int bytesWrittenUUID = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetKeyUUID.");
        if (wrapperTable->m_ResourceDataGroup_GetKeyUUID == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::GetKeyUUID.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult initErrorCode = wrapperTable->m_ResourceDataGroup_GetKeyUUID(instanceHandle, 0, &bytesNeededUUID, nullptr);
        CheckError(isolate, wrapperTable, instanceHandle, initErrorCode);
        std::vector<char> bufferUUID;
        bufferUUID.resize(bytesNeededUUID);
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_GetKeyUUID(instanceHandle, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, &bufferUUID[0]));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceDataGroup::AddAccessRight(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        if (!args[1]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 1 (WrappingAlgorithm)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (MgfAlgorithm)");
        }
        if (!args[3]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 3 (DigestMethod)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        unsigned int eWrappingAlgorithm = (unsigned int) args[1]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eMgfAlgorithm = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eDigestMethod = (unsigned int) args[3]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnTheAccessRight = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddAccessRight.");
        if (wrapperTable->m_ResourceDataGroup_AddAccessRight == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::AddAccessRight.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_AddAccessRight(instanceHandle, hConsumer, (eLib3MFWrappingAlgorithm) eWrappingAlgorithm, (eLib3MFMgfAlgorithm) eMgfAlgorithm, (eLib3MFDigestMethod) eDigestMethod, &hReturnTheAccessRight);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheAccessRight = CLib3MFAccessRight::NewInstance(args.Holder(), hReturnTheAccessRight);
        args.GetReturnValue().Set(instanceObjTheAccessRight);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceDataGroup::FindAccessRightByConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        Lib3MFHandle hReturnTheAccessRight = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindAccessRightByConsumer.");
        if (wrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::FindAccessRightByConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer(instanceHandle, hConsumer, &hReturnTheAccessRight);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjTheAccessRight = CLib3MFAccessRight::NewInstance(args.Holder(), hReturnTheAccessRight);
        args.GetReturnValue().Set(instanceObjTheAccessRight);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFResourceDataGroup::RemoveAccessRight(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveAccessRight.");
        if (wrapperTable->m_ResourceDataGroup_RemoveAccessRight == nullptr)
            throw std::runtime_error("Could not call Lib3MF method ResourceDataGroup::RemoveAccessRight.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_ResourceDataGroup_RemoveAccessRight(instanceHandle, hConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}

/*************************************************************************************************************************
 Class CLib3MFKeyStore Implementation
**************************************************************************************************************************/

CLib3MFKeyStore::CLib3MFKeyStore()
		: CLib3MFBaseClass()
{
}

CLib3MFKeyStore::~CLib3MFKeyStore()
{
}

void CLib3MFKeyStore::Init()
{
		Isolate* isolate = Isolate::GetCurrent();

		// Prepare constructor template
		Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
		tpl->SetClassName(String::NewFromUtf8(isolate, "Lib3MFKeyStore"));
		tpl->InstanceTemplate()->SetInternalFieldCount(NODEWRAPPER_FIELDCOUNT);

		// Prototype
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddConsumer", AddConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumerCount", GetConsumerCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetConsumer", GetConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveConsumer", RemoveConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindConsumer", FindConsumer);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceDataGroupCount", GetResourceDataGroupCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddResourceDataGroup", AddResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceDataGroup", GetResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveResourceDataGroup", RemoveResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindResourceDataGroup", FindResourceDataGroup);
		NODE_SET_PROTOTYPE_METHOD(tpl, "AddResourceData", AddResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "RemoveResourceData", RemoveResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "FindResourceData", FindResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceDataCount", GetResourceDataCount);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetResourceData", GetResourceData);
		NODE_SET_PROTOTYPE_METHOD(tpl, "GetUUID", GetUUID);
		NODE_SET_PROTOTYPE_METHOD(tpl, "SetUUID", SetUUID);
		constructor.Reset(isolate, tpl->GetFunction(isolate->GetCurrentContext()).ToLocalChecked());

}

void CLib3MFKeyStore::New(const FunctionCallbackInfo<Value>& args)
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);

		if (args.IsConstructCall()) {
				CLib3MFBaseClass * holderObj = ObjectWrap::Unwrap<CLib3MFBaseClass>(args.Holder());
				CLib3MFKeyStore * keystoreInstance = new CLib3MFKeyStore();
				keystoreInstance->Wrap(args.This());
				args.GetReturnValue().Set(args.This());
		} else {
				RaiseError(isolate, "Lib3MFKeyStore: Invalid call to Constructor");
		}
}

Local<Object> CLib3MFKeyStore::NewInstance(Local<Object> pParent, Lib3MFHandle pHandle)
{
		Isolate* isolate = Isolate::GetCurrent();
		HandleScope scope(isolate);
		Local<Function> cons = Local<Function>::New(isolate, constructor);
		Local<Object> instance;
		if (cons->NewInstance(isolate->GetCurrentContext()).ToLocal(&instance)) {
			instance->SetInternalField(NODEWRAPPER_TABLEINDEX, External::New(isolate, CLib3MFBaseClass::getDynamicWrapperTable(pParent)));
			instance->SetInternalField(NODEWRAPPER_HANDLEINDEX, External::New(isolate, pHandle));
		}
		return instance;
}


void CLib3MFKeyStore::AddConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        if (!args[1]->IsString()) {
            throw std::runtime_error("Expected string parameter 1 (KeyID)");
        }
        if (!args[2]->IsString()) {
            throw std::runtime_error("Expected string parameter 2 (KeyValue)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        v8::String::Utf8Value sutf8KeyID(isolate, args[1]);
        std::string sKeyID = *sutf8KeyID;
        v8::String::Utf8Value sutf8KeyValue(isolate, args[2]);
        std::string sKeyValue = *sutf8KeyValue;
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddConsumer.");
        if (wrapperTable->m_KeyStore_AddConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::AddConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_AddConsumer(instanceHandle, sConsumerID.c_str(), sKeyID.c_str(), sKeyValue.c_str(), &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetConsumerCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumerCount.");
        if (wrapperTable->m_KeyStore_GetConsumerCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetConsumerCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetConsumerCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (ConsumerIndex)");
        }
        v8::String::Utf8Value sutf8ConsumerIndex(isolate, args[0]);
        std::string sConsumerIndex = *sutf8ConsumerIndex;
        uint64_t nConsumerIndex = stoull(sConsumerIndex);
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetConsumer.");
        if (wrapperTable->m_KeyStore_GetConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetConsumer(instanceHandle, nConsumerIndex, &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::RemoveConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (Consumer)");
        }
        Local<Object> objConsumer = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFConsumer * instanceConsumer = ObjectWrap::Unwrap<CLib3MFConsumer>(objConsumer);
        if (instanceConsumer == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (Consumer)");
        Lib3MFHandle hConsumer = instanceConsumer->getHandle( objConsumer );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveConsumer.");
        if (wrapperTable->m_KeyStore_RemoveConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::RemoveConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_RemoveConsumer(instanceHandle, hConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::FindConsumer(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected string parameter 0 (ConsumerID)");
        }
        v8::String::Utf8Value sutf8ConsumerID(isolate, args[0]);
        std::string sConsumerID = *sutf8ConsumerID;
        Lib3MFHandle hReturnConsumer = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindConsumer.");
        if (wrapperTable->m_KeyStore_FindConsumer == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::FindConsumer.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_FindConsumer(instanceHandle, sConsumerID.c_str(), &hReturnConsumer);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjConsumer = CLib3MFConsumer::NewInstance(args.Holder(), hReturnConsumer);
        args.GetReturnValue().Set(instanceObjConsumer);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetResourceDataGroupCount(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        uint64_t nReturnCount = 0;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceDataGroupCount.");
        if (wrapperTable->m_KeyStore_GetResourceDataGroupCount == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetResourceDataGroupCount.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetResourceDataGroupCount(instanceHandle, &nReturnCount);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        args.GetReturnValue().Set(String::NewFromUtf8(isolate, std::to_string(nReturnCount).c_str()));

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::AddResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        Lib3MFHandle hReturnResourceDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddResourceDataGroup.");
        if (wrapperTable->m_KeyStore_AddResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::AddResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_AddResourceDataGroup(instanceHandle, &hReturnResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceDataGroup = CLib3MFResourceDataGroup::NewInstance(args.Holder(), hReturnResourceDataGroup);
        args.GetReturnValue().Set(instanceObjResourceDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::GetResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsString()) {
            throw std::runtime_error("Expected uint64 parameter 0 (ResourceDataIndex)");
        }
        v8::String::Utf8Value sutf8ResourceDataIndex(isolate, args[0]);
        std::string sResourceDataIndex = *sutf8ResourceDataIndex;
        uint64_t nResourceDataIndex = stoull(sResourceDataIndex);
        Lib3MFHandle hReturnResourceDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method GetResourceDataGroup.");
        if (wrapperTable->m_KeyStore_GetResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::GetResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_GetResourceDataGroup(instanceHandle, nResourceDataIndex, &hReturnResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceDataGroup = CLib3MFResourceDataGroup::NewInstance(args.Holder(), hReturnResourceDataGroup);
        args.GetReturnValue().Set(instanceObjResourceDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::RemoveResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourceDataGroup)");
        }
        Local<Object> objResourceDataGroup = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResourceDataGroup * instanceResourceDataGroup = ObjectWrap::Unwrap<CLib3MFResourceDataGroup>(objResourceDataGroup);
        if (instanceResourceDataGroup == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourceDataGroup)");
        Lib3MFHandle hResourceDataGroup = instanceResourceDataGroup->getHandle( objResourceDataGroup );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveResourceDataGroup.");
        if (wrapperTable->m_KeyStore_RemoveResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::RemoveResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_RemoveResourceDataGroup(instanceHandle, hResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::FindResourceDataGroup(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (PartPath)");
        }
        Local<Object> objPartPath = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instancePartPath = ObjectWrap::Unwrap<CLib3MFPackagePart>(objPartPath);
        if (instancePartPath == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (PartPath)");
        Lib3MFHandle hPartPath = instancePartPath->getHandle( objPartPath );
        Lib3MFHandle hReturnResourceDataGroup = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method FindResourceDataGroup.");
        if (wrapperTable->m_KeyStore_FindResourceDataGroup == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::FindResourceDataGroup.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_FindResourceDataGroup(instanceHandle, hPartPath, &hReturnResourceDataGroup);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceDataGroup = CLib3MFResourceDataGroup::NewInstance(args.Holder(), hReturnResourceDataGroup);
        args.GetReturnValue().Set(instanceObjResourceDataGroup);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::AddResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourceDataGroup)");
        }
        if (!args[1]->IsObject()) {
            throw std::runtime_error("Expected class parameter 1 (PartPath)");
        }
        if (!args[2]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 2 (Algorithm)");
        }
        if (!args[3]->IsUint32()) {
            throw std::runtime_error("Expected enum parameter 3 (Compression)");
        }
        Local<Object> objResourceDataGroup = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResourceDataGroup * instanceResourceDataGroup = ObjectWrap::Unwrap<CLib3MFResourceDataGroup>(objResourceDataGroup);
        if (instanceResourceDataGroup == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourceDataGroup)");
        Lib3MFHandle hResourceDataGroup = instanceResourceDataGroup->getHandle( objResourceDataGroup );
        Local<Object> objPartPath = args[1]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instancePartPath = ObjectWrap::Unwrap<CLib3MFPackagePart>(objPartPath);
        if (instancePartPath == nullptr)
            throw std::runtime_error("Invalid Object parameter 1 (PartPath)");
        Lib3MFHandle hPartPath = instancePartPath->getHandle( objPartPath );
        unsigned int eAlgorithm = (unsigned int) args[2]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        unsigned int eCompression = (unsigned int) args[3]->IntegerValue(isolate->GetCurrentContext()).ToChecked();
        Lib3MFHandle hReturnResourceData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method AddResourceData.");
        if (wrapperTable->m_KeyStore_AddResourceData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::AddResourceData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_AddResourceData(instanceHandle, hResourceDataGroup, hPartPath, (eLib3MFEncryptionAlgorithm) eAlgorithm, (eLib3MFCompression) eCompression, 0, nullptr, &hReturnResourceData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);
        Local<Object> instanceObjResourceData = CLib3MFResourceData::NewInstance(args.Holder(), hReturnResourceData);
        args.GetReturnValue().Set(instanceObjResourceData);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::RemoveResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourceData)");
        }
        Local<Object> objResourceData = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFResourceData * instanceResourceData = ObjectWrap::Unwrap<CLib3MFResourceData>(objResourceData);
        if (instanceResourceData == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourceData)");
        Lib3MFHandle hResourceData = instanceResourceData->getHandle( objResourceData );
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3MFBaseClass::getDynamicWrapperTable(args.Holder());
        if (wrapperTable == nullptr)
            throw std::runtime_error("Could not get wrapper table for Lib3MF method RemoveResourceData.");
        if (wrapperTable->m_KeyStore_RemoveResourceData == nullptr)
            throw std::runtime_error("Could not call Lib3MF method KeyStore::RemoveResourceData.");
        Lib3MFHandle instanceHandle = CLib3MFBaseClass::getHandle(args.Holder());
        Lib3MFResult errorCode = wrapperTable->m_KeyStore_RemoveResourceData(instanceHandle, hResourceData);
        CheckError(isolate, wrapperTable, instanceHandle, errorCode);

		} catch (std::exception & E) {
				RaiseError(isolate, E.what());
		}
}


void CLib3MFKeyStore::FindResourceData(const FunctionCallbackInfo<Value>& args) 
{
		Isolate* isolate = args.GetIsolate();
		HandleScope scope(isolate);
		try {
        if (!args[0]->IsObject()) {
            throw std::runtime_error("Expected class parameter 0 (ResourcePath)");
        }
        Local<Object> objResourcePath = args[0]->ToObject(isolate->GetCurrentContext()).ToLocalChecked();
        CLib3MFPackagePart * instanceResourcePath = ObjectWrap::Unwrap<CLib3MFPackagePart>(objResourcePath);
        if (instanceResourcePath == nullptr)
            throw std::runtime_error("Invalid Object parameter 0 (ResourcePath)");
        Lib3MFHandle hResourcePath = instanceResourcePath->getHandle( objResourcePath );
        Lib3MFHandle hReturnResourceData = nullptr;
        sLib3MFDynamicWrapperTable * wrapperTable = CLib3