/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.services.DependencyAggregator;
import org.netbeans.modules.autoupdate.services.KitModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

public class UpdateManagerImpl {
    private static final UpdateManagerImpl INSTANCE = new UpdateManagerImpl();
    private static final UpdateManager.TYPE[] DEFAULT_TYPES = new UpdateManager.TYPE[]{UpdateManager.TYPE.KIT_MODULE};
    private Reference<Cache> cacheReference = null;
    private Map<String, UpdateUnitProvider> source2UpdateUnitProvider = null;

    public static UpdateManagerImpl getInstance() {
        return INSTANCE;
    }

    private UpdateManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            this.cacheReference = null;
            this.source2UpdateUnitProvider = null;
            Utilities.writeFirstClassModule(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushComputedInfo() {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            Reference<Cache> reference = this.getCacheReference();
            if (reference == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            Cache cache = reference.get();
            if (cache == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            cache.clearMaps();
            return;
        }
    }

    public static List<UpdateUnit> getUpdateUnits(UpdateProvider updateProvider, UpdateManager.TYPE ... tYPEArray) {
        return UpdateManagerImpl.filterUnitsByAskedTypes(UpdateUnitFactory.getDefault().getUpdateUnits(updateProvider).values(), UpdateManagerImpl.type2checkedList(tYPEArray));
    }

    public List<UpdateUnit> getUpdateUnits(UpdateManager.TYPE ... tYPEArray) {
        final Cache cache = this.getCache();
        return new ArrayList<UpdateUnit>(UpdateManagerImpl.filterUnitsByAskedTypes(cache.getUnits(), UpdateManagerImpl.type2checkedList(tYPEArray))){
            Cache keepIt;
            {
                super(collection);
                this.keepIt = cache;
            }
        };
    }

    public Set<UpdateElement> getAvailableEagers() {
        final Cache cache = this.getCache();
        return new HashSet<UpdateElement>(cache.getAvailableEagers()){
            Cache keepIt;
            {
                super(collection);
                this.keepIt = cache;
            }
        };
    }

    public Set<UpdateElement> getInstalledEagers() {
        final Cache cache = this.getCache();
        return new HashSet<UpdateElement>(cache.getInstalledEagers()){
            Cache keepIt;
            {
                super(collection);
                this.keepIt = cache;
            }
        };
    }

    public Collection<ModuleInfo> getInstalledProviders(String string) {
        Collection<ModuleInfo> collection;
        final Cache cache = this.getCache();
        if (string.startsWith("cnb.") && (collection = cache.getUpdateUnit(string.substring(4))) != null && ((UpdateUnit)((Object)collection)).getInstalled() != null) {
            return Trampoline.API.impl(((UpdateUnit)((Object)collection)).getInstalled()).getModuleInfos();
        }
        collection = cache.createMapToken2InstalledProviders().get(string);
        HashSet<ModuleInfo> hashSet = collection == null || collection.isEmpty() ? new HashSet<ModuleInfo>(0){
            Cache keepIt;
            {
                super(n);
                this.keepIt = cache;
            }
        } : new HashSet<ModuleInfo>((Collection)collection){
            Cache keepIt;
            {
                super(collection);
                this.keepIt = cache;
            }
        };
        return hashSet;
    }

    public Collection<ModuleInfo> getAvailableProviders(String string) {
        Collection<ModuleInfo> collection;
        final Cache cache = this.getCache();
        if (string.startsWith("cnb.") && (collection = cache.getUpdateUnit(string.substring(4))) != null && !((UpdateUnit)((Object)collection)).getAvailableUpdates().isEmpty()) {
            return Trampoline.API.impl(((UpdateUnit)((Object)collection)).getAvailableUpdates().get(0)).getModuleInfos();
        }
        collection = cache.createMapToken2AvailableProviders().get(string);
        HashSet<ModuleInfo> hashSet = collection == null || collection.isEmpty() ? new HashSet<ModuleInfo>(0){
            Cache keepIt;
            {
                super(n);
                this.keepIt = cache;
            }
        } : new HashSet<ModuleInfo>((Collection)collection){
            Cache keepIt;
            {
                super(collection);
                this.keepIt = cache;
            }
        };
        return hashSet;
    }

    public TreeSet<UpdateElement> getInstalledKits(String string) {
        final Cache cache = this.getCache();
        TreeSet<UpdateElement> treeSet = cache.createMapCluster2installedKits().get(string);
        TreeSet<UpdateElement> treeSet2 = treeSet == null || treeSet.isEmpty() ? new TreeSet<UpdateElement>(){
            Cache keepIt;
            {
                this.keepIt = cache;
            }
        } : new TreeSet<UpdateElement>(treeSet){
            Cache keepIt;
            {
                super(sortedSet);
                this.keepIt = cache;
            }
        };
        return treeSet2;
    }

    public UpdateUnit getUpdateUnit(String string) {
        if (string.indexOf(47) != -1) {
            int n = string.indexOf(47);
            string = string.substring(0, n);
        }
        return this.getCache().getUpdateUnit(string);
    }

    public List<UpdateUnit> getUpdateUnits() {
        final Cache cache = this.getCache();
        return new ArrayList<UpdateUnit>(cache.getUnits()){
            Cache keepIt;
            {
                super(collection);
                this.keepIt = cache;
            }
        };
    }

    private static List<UpdateUnit> filterUnitsByAskedTypes(Collection<UpdateUnit> collection, List<UpdateManager.TYPE> list) {
        ArrayList<UpdateUnit> arrayList = new ArrayList<UpdateUnit>();
        ArrayList<UpdateManager.TYPE> arrayList2 = new ArrayList<UpdateManager.TYPE>(list);
        if (arrayList2.contains((Object)UpdateManager.TYPE.MODULE) && !arrayList2.contains((Object)UpdateManager.TYPE.KIT_MODULE)) {
            arrayList2.add(UpdateManager.TYPE.KIT_MODULE);
        }
        for (UpdateUnit updateUnit : collection) {
            UpdateUnitImpl updateUnitImpl = Trampoline.API.impl(updateUnit);
            if (!arrayList2.contains((Object)updateUnitImpl.getType())) continue;
            arrayList.add(updateUnit);
        }
        return arrayList;
    }

    private static List<UpdateManager.TYPE> type2checkedList(UpdateManager.TYPE ... tYPEArray) {
        List<UpdateManager.TYPE> list = Arrays.asList(tYPEArray);
        if (tYPEArray != null && tYPEArray.length > 1) {
            if (list.contains((Object)UpdateManager.TYPE.MODULE) && list.contains((Object)UpdateManager.TYPE.KIT_MODULE)) {
                throw new IllegalArgumentException("Cannot mix types MODULE and KIT_MODULE into once list.");
            }
        } else if (tYPEArray == null || tYPEArray.length == 0) {
            list = Arrays.asList(DEFAULT_TYPES);
        }
        return list;
    }

    private Cache getCache() {
        Cache cache;
        Reference<Cache> reference = this.getCacheReference();
        Cache cache2 = cache = reference != null ? reference.get() : null;
        if (cache == null) {
            cache = new Cache();
            this.initCache(cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reference<Cache> getCacheReference() {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cacheReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCache(Cache cache) {
        Class<Cache> clazz = Cache.class;
        synchronized (Cache.class) {
            this.cacheReference = new WeakReference<Cache>(cache);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public UpdateUnitProvider getUpdateUnitProvider(String string) {
        if (this.source2UpdateUnitProvider == null) {
            List<UpdateUnitProvider> list = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false);
            this.source2UpdateUnitProvider = new HashMap<String, UpdateUnitProvider>(list.size());
            for (UpdateUnitProvider updateUnitProvider : list) {
                this.source2UpdateUnitProvider.put(updateUnitProvider.getDisplayName(), updateUnitProvider);
            }
        }
        return this.source2UpdateUnitProvider.get(string);
    }

    private class Cache {
        private final Map<String, UpdateUnit> units = UpdateUnitFactory.getDefault().getUpdateUnits();
        private Set<UpdateElement> availableEagers = null;
        private Set<UpdateElement> installedEagers = null;
        private Map<String, Collection<ModuleInfo>> token2installedProviders = null;
        private Map<String, Collection<ModuleInfo>> token2availableProviders = null;
        private Map<String, TreeSet<UpdateElement>> cluster2installedKits = null;

        Cache() {
        }

        synchronized void clearMaps() {
            this.availableEagers = null;
            this.installedEagers = null;
            this.token2installedProviders = null;
            this.token2availableProviders = null;
            this.cluster2installedKits = null;
        }

        public synchronized Set<UpdateElement> getAvailableEagers() {
            if (this.availableEagers == null) {
                this.createMaps();
            }
            assert (this.availableEagers != null) : "availableEagers initialized";
            return this.availableEagers;
        }

        public synchronized Set<UpdateElement> getInstalledEagers() {
            if (this.installedEagers == null) {
                this.createMaps();
            }
            assert (this.installedEagers != null) : "installedEagers initialized";
            return this.installedEagers;
        }

        public synchronized Map<String, Collection<ModuleInfo>> createMapToken2InstalledProviders() {
            if (this.token2installedProviders == null) {
                this.createMaps();
            }
            assert (this.token2installedProviders != null) : "token2installedProviders initialized";
            return this.token2installedProviders;
        }

        public synchronized Map<String, Collection<ModuleInfo>> createMapToken2AvailableProviders() {
            if (this.token2availableProviders == null) {
                this.createMaps();
            }
            assert (this.token2availableProviders != null) : "token2availableProviders initialized";
            return this.token2availableProviders;
        }

        public synchronized Map<String, TreeSet<UpdateElement>> createMapCluster2installedKits() {
            if (this.cluster2installedKits == null) {
                this.createMaps();
            }
            assert (this.cluster2installedKits != null) : "cluster2installedKits initialized";
            return this.cluster2installedKits;
        }

        public Collection<UpdateUnit> getUnits() {
            return this.units.values();
        }

        public UpdateUnit getUpdateUnit(String string) {
            return this.units.get(string);
        }

        private synchronized void createMaps() {
            this.availableEagers = new HashSet<UpdateElement>(this.getUnits().size());
            this.installedEagers = new HashSet<UpdateElement>(this.getUnits().size());
            this.token2installedProviders = new HashMap<String, Collection<ModuleInfo>>(11);
            this.token2availableProviders = new HashMap<String, Collection<ModuleInfo>>(11);
            this.cluster2installedKits = new HashMap<String, TreeSet<UpdateElement>>();
            DependencyAggregator.clearMaps();
            for (UpdateUnit updateUnit : this.getUnits()) {
                Object object2;
                UpdateElement updateElement = updateUnit.getInstalled();
                if (updateElement != null) {
                    String string;
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                    if (updateElementImpl.isEager()) {
                        this.installedEagers.add(updateElement);
                    }
                    for (Object object2 : updateElementImpl.getModuleInfos()) {
                        for (String[] stringArray : object2.getDependencies()) {
                            DependencyAggregator dependencyAggregator = DependencyAggregator.getAggregator((Dependency)stringArray);
                            dependencyAggregator.addDependee((ModuleInfo)object2);
                        }
                        String[] stringArray = object2.getProvides();
                        if (stringArray == null || stringArray.length == 0) continue;
                        for (String string2 : stringArray) {
                            if (this.token2installedProviders.get(string2) == null) {
                                this.token2installedProviders.put(string2, new HashSet());
                            }
                            this.token2installedProviders.get(string2).add((ModuleInfo)object2);
                        }
                    }
                    if (updateElementImpl instanceof KitModuleUpdateElementImpl && (string = ((KitModuleUpdateElementImpl)updateElementImpl).getInstallationCluster()) != null) {
                        if (this.cluster2installedKits.get(string) == null) {
                            object2 = new TreeSet<UpdateElement>(new Comparator<UpdateElement>(){

                                @Override
                                public int compare(UpdateElement updateElement, UpdateElement updateElement2) {
                                    return updateElement.getCodeName().compareTo(updateElement2.getCodeName());
                                }
                            });
                            this.cluster2installedKits.put(string, (TreeSet<UpdateElement>)object2);
                        }
                        this.cluster2installedKits.get(string).add(updateElement);
                    }
                }
                if (updateUnit.getAvailableUpdates().isEmpty()) continue;
                updateElement = updateUnit.getAvailableUpdates().get(0);
                if (Trampoline.API.impl(updateElement).isEager()) {
                    this.availableEagers.add(updateElement);
                }
                for (ModuleInfo moduleInfo : Trampoline.API.impl(updateElement).getModuleInfos()) {
                    for (Dependency dependency : moduleInfo.getDependencies()) {
                        DependencyAggregator dependencyAggregator = DependencyAggregator.getAggregator(dependency);
                        dependencyAggregator.addDependee(moduleInfo);
                    }
                    object2 = moduleInfo.getProvides();
                    if (object2 == null || ((Object)object2).length == 0) continue;
                    for (Object object3 : object2) {
                        if (this.token2availableProviders.get(object3) == null) {
                            this.token2availableProviders.put((String)object3, new HashSet());
                        }
                        this.token2availableProviders.get(object3).add(moduleInfo);
                    }
                }
            }
        }
    }
}

