/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.rosterstore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;

public final class DirectoryRosterStore
implements RosterStore {
    private final File fileDir;
    private static final String ENTRY_PREFIX = "entry-";
    private static final String VERSION_FILE_NAME = "__version__";
    private static final String STORE_ID = "DEFAULT_ROSTER_STORE";
    private static final Logger LOGGER = Logger.getLogger(DirectoryRosterStore.class.getName());

    private static boolean rosterDirFilter(File file) {
        String name = file.getName();
        return name.startsWith(ENTRY_PREFIX);
    }

    private DirectoryRosterStore(File baseDir) {
        this.fileDir = baseDir;
    }

    public static DirectoryRosterStore init(File baseDir) {
        DirectoryRosterStore store = new DirectoryRosterStore(baseDir);
        if (store.setRosterVersion("")) {
            return store;
        }
        return null;
    }

    public static DirectoryRosterStore open(File baseDir) {
        DirectoryRosterStore store = new DirectoryRosterStore(baseDir);
        String s2 = FileUtils.readFile(store.getVersionFile());
        if (s2 != null && s2.startsWith("DEFAULT_ROSTER_STORE\n")) {
            return store;
        }
        return null;
    }

    private File getVersionFile() {
        return new File(this.fileDir, VERSION_FILE_NAME);
    }

    @Override
    public List<RosterPacket.Item> getEntries() {
        ArrayList<RosterPacket.Item> entries = new ArrayList<RosterPacket.Item>();
        for (File file : this.fileDir.listFiles(DirectoryRosterStore::rosterDirFilter)) {
            RosterPacket.Item entry = DirectoryRosterStore.readEntry(file);
            if (entry == null) {
                return null;
            }
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public RosterPacket.Item getEntry(Jid bareJid) {
        return DirectoryRosterStore.readEntry(this.getBareJidFile(bareJid));
    }

    @Override
    public String getRosterVersion() {
        String s2 = FileUtils.readFile(this.getVersionFile());
        if (s2 == null) {
            return null;
        }
        String[] lines = s2.split("\n", 2);
        if (lines.length < 2) {
            return null;
        }
        return lines[1];
    }

    private boolean setRosterVersion(String version) {
        return FileUtils.writeFile(this.getVersionFile(), "DEFAULT_ROSTER_STORE\n" + version);
    }

    @Override
    public boolean addEntry(RosterPacket.Item item, String version) {
        return this.addEntryRaw(item) && this.setRosterVersion(version);
    }

    @Override
    public boolean removeEntry(Jid bareJid, String version) {
        return this.getBareJidFile(bareJid).delete() && this.setRosterVersion(version);
    }

    @Override
    public boolean resetEntries(Collection<RosterPacket.Item> items, String version) {
        for (File file : this.fileDir.listFiles(DirectoryRosterStore::rosterDirFilter)) {
            file.delete();
        }
        for (RosterPacket.Item item : items) {
            if (this.addEntryRaw(item)) continue;
            return false;
        }
        return this.setRosterVersion(version);
    }

    @Override
    public void resetStore() {
        this.resetEntries(Collections.emptyList(), "");
    }

    private static RosterPacket.Item readEntry(File file) {
        FileReader reader;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINE, "Roster entry file not found", e);
            return null;
        }
        try {
            XmlPullParser parser2 = PacketParserUtils.getParserFor(reader);
            RosterPacket.Item item = RosterPacketProvider.parseItem(parser2);
            ((Reader)reader).close();
            return item;
        }
        catch (IOException | IllegalArgumentException | XmlPullParserException e) {
            boolean deleted = file.delete();
            String message = "Exception while parsing roster entry.";
            if (deleted) {
                message = message + " File was deleted.";
            }
            LOGGER.log(Level.SEVERE, message, e);
            return null;
        }
    }

    private boolean addEntryRaw(RosterPacket.Item item) {
        return FileUtils.writeFile(this.getBareJidFile(item.getJid()), item.toXML());
    }

    private File getBareJidFile(Jid bareJid) {
        String encodedJid = Base32.encode(bareJid.toString());
        return new File(this.fileDir, ENTRY_PREFIX + encodedJid);
    }
}

