/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.ClassesContainer;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesContainer;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.GCTypeNode;
import org.graalvm.visualvm.heapviewer.model.ContainerNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public class JavaClassesProvider {
    public static HeapViewerNode[] getHeapClasses(HeapViewerNode parent, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        NodesComputer<JavaClass> computer = new NodesComputer<JavaClass>(heap.getAllClasses().size(), UIThresholds.MAX_TOPLEVEL_CLASSES){

            @Override
            protected boolean sorts(DataType dataType) {
                return true;
            }

            @Override
            protected HeapViewerNode createNode(JavaClass javaClass) {
                return new ClassNode(javaClass);
            }

            @Override
            protected ProgressIterator<JavaClass> objectsIterator(int index, Progress progress) {
                ListIterator iterator = heap.getAllClasses().listIterator(index);
                return new ProgressIterator<JavaClass>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Classes_Messages.getMoreNodesString(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Classes_Messages.getSamplesContainerString(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Classes_Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
            }
        };
        HeapViewerNode[] nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
        if (nodes.length == 0) {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(Classes_Messages.getNoClassesString(viewFilter));
        } else {
            heapViewerNodeArray = nodes;
        }
        return heapViewerNodeArray;
    }

    public static HeapViewerNode[] getHeapPackages(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        ArrayList<HeapViewerNode> nodes = new ArrayList<HeapViewerNode>();
        HashMap<String, ClassesContainer.Objects> packages = new HashMap<String, ClassesContainer.Objects>();
        Thread worker = Thread.currentThread();
        List classes = heap.getAllClasses();
        for (JavaClass cls : classes) {
            String className = cls.getName();
            int nameIdx = className.lastIndexOf(46);
            if (nameIdx == -1) {
                ClassNode clsn = new ClassNode(cls);
                if (viewFilter == null || viewFilter.passes(clsn, heap)) {
                    nodes.add(clsn);
                }
            } else {
                if (viewFilter != null && !viewFilter.passes(new ClassNode(cls), heap)) continue;
                String pkgName = className.substring(0, nameIdx);
                ClassesContainer.Objects node = (ClassesContainer.Objects)((Object)packages.get(pkgName));
                if (node == null) {
                    node = new ClassesContainer.Objects(pkgName);
                    nodes.add(node);
                    packages.put(pkgName, node);
                }
                node.add(cls, heap);
            }
            if (!worker.isInterrupted()) continue;
            throw new InterruptedException();
        }
        if (nodes.isEmpty()) {
            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray2;
            heapViewerNodeArray2[0] = new TextNode(Classes_Messages.getNoPackagesString(viewFilter));
        } else {
            heapViewerNodeArray = nodes.toArray(HeapViewerNode.NO_NODES);
        }
        return heapViewerNodeArray;
    }

    public static HeapViewerNode[] getHeapGCRoots(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        Collection gcroots = heap.getGCRoots();
        final List gcrootInstances = gcroots.stream().map(GCRoot::getInstance).filter(i -> i != null).distinct().collect(Collectors.toList());
        if (aggregation == 0) {
            HeapViewerNode[] heapViewerNodeArray2;
            NodesComputer<Instance> computer = new NodesComputer<Instance>(gcrootInstances.size(), UIThresholds.MAX_TOPLEVEL_INSTANCES){

                @Override
                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                @Override
                protected HeapViewerNode createNode(Instance gcRootInstance) {
                    return new InstanceNode(gcRootInstance);
                }

                @Override
                protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                    ListIterator iterator = gcrootInstances.listIterator(index);
                    return new ProgressIterator<Instance>(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return GCRoots_Messages.getMoreNodesString(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return GCRoots_Messages.getSamplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return GCRoots_Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                }
            };
            HeapViewerNode[] nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            if (nodes.length == 0) {
                HeapViewerNode[] heapViewerNodeArray3 = new HeapViewerNode[1];
                heapViewerNodeArray2 = heapViewerNodeArray3;
                heapViewerNodeArray3[0] = new TextNode(GCRoots_Messages.getNoItemsString(viewFilter));
            } else {
                heapViewerNodeArray2 = nodes;
            }
            return heapViewerNodeArray2;
        }
        if (viewFilter != null) {
            Iterator gcrootsI = gcrootInstances.iterator();
            while (gcrootsI.hasNext()) {
                if (viewFilter.passes(new InstanceNode((Instance)gcrootsI.next()), heap)) continue;
                gcrootsI.remove();
            }
        }
        if (aggregation == 3) {
            HeapViewerNode[] heapViewerNodeArray4;
            HashMap<String, GCTypeNode> types = new HashMap<String, GCTypeNode>();
            for (Instance instance : gcrootInstances) {
                Collection igcroots = heap.getGCRoots(instance);
                for (GCRoot gcroot : igcroots) {
                    String tname = gcroot.getKind();
                    GCTypeNode tnode = (GCTypeNode)((Object)types.get(tname));
                    if (tnode == null) {
                        tnode = new GCTypeNode(tname);
                        types.put(tname, tnode);
                    }
                    tnode.addRoot(gcroot, instance, heap);
                }
            }
            if (types.isEmpty()) {
                HeapViewerNode[] heapViewerNodeArray5 = new HeapViewerNode[1];
                heapViewerNodeArray4 = heapViewerNodeArray5;
                heapViewerNodeArray5[0] = new TextNode(GCRoots_Messages.getNoItemsString(viewFilter));
            } else {
                heapViewerNodeArray4 = types.values().toArray(HeapViewerNode.NO_NODES);
            }
            return heapViewerNodeArray4;
        }
        ArrayList<InstancesContainer.Objects> cnodes = new ArrayList<InstancesContainer.Objects>();
        HashMap<String, InstancesContainer.Objects> classes = new HashMap<String, InstancesContainer.Objects>();
        for (Instance instance : gcrootInstances) {
            JavaClass javaClass = instance.getJavaClass();
            String className = javaClass.getName();
            InstancesContainer.Objects cnode = (InstancesContainer.Objects)((Object)classes.get(className));
            if (cnode == null) {
                cnode = new InstancesContainer.Objects(className, javaClass){

                    @Override
                    protected String getMoreNodesString(String moreNodesCount) {
                        return GCRoots_Messages.getMoreNodesString(moreNodesCount);
                    }

                    @Override
                    protected String getSamplesContainerString(String objectsCount) {
                        return GCRoots_Messages.getSamplesContainerString(objectsCount);
                    }

                    @Override
                    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                        return GCRoots_Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                    }
                };
                classes.put(className, cnode);
                cnodes.add(cnode);
            }
            cnode.add(instance, heap);
        }
        if (aggregation == 1) {
            HeapViewerNode[] heapViewerNodeArray6;
            if (cnodes.isEmpty()) {
                HeapViewerNode[] heapViewerNodeArray7 = new HeapViewerNode[1];
                heapViewerNodeArray6 = heapViewerNodeArray7;
                heapViewerNodeArray7[0] = new TextNode(GCRoots_Messages.getNoItemsString(viewFilter));
            } else {
                heapViewerNodeArray6 = cnodes.toArray(HeapViewerNode.NO_NODES);
            }
            return heapViewerNodeArray6;
        }
        ArrayList<ContainerNode> pnodes = new ArrayList<ContainerNode>();
        HashMap<String, ClassesContainer.ContainerNodes> packages = new HashMap<String, ClassesContainer.ContainerNodes>();
        for (InstancesContainer.Objects cnode : cnodes) {
            String className = cnode.getName();
            int nameIdx = className.lastIndexOf(46);
            if (nameIdx == -1) {
                pnodes.add(cnode);
                continue;
            }
            String pkgName = className.substring(0, nameIdx);
            ClassesContainer.ContainerNodes node = (ClassesContainer.ContainerNodes)((Object)packages.get(pkgName));
            if (node == null) {
                node = new ClassesContainer.ContainerNodes(pkgName);
                pnodes.add(node);
                packages.put(pkgName, node);
            }
            node.add(cnode, heap);
        }
        if (pnodes.isEmpty()) {
            HeapViewerNode[] heapViewerNodeArray8 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray8;
            heapViewerNodeArray8[0] = new TextNode(GCRoots_Messages.getNoItemsString(viewFilter));
        } else {
            heapViewerNodeArray = pnodes.toArray(HeapViewerNode.NO_NODES);
        }
        return heapViewerNodeArray;
    }

    public static HeapViewerNode[] getHeapDominators(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress, int aggregation) throws InterruptedException {
        HeapViewerNode[] heapViewerNodeArray;
        if (!DataType.RETAINED_SIZE.valuesAvailable(heap)) {
            return new HeapViewerNode[]{new TextNode(Bundle.Dominators_Messages_NoRetainedSizes())};
        }
        final ArrayList<Instance> dominators = new ArrayList<Instance>(JavaClassesProvider.getDominatorRoots(heap));
        if (aggregation == 0) {
            HeapViewerNode[] heapViewerNodeArray2;
            NodesComputer<Instance> computer = new NodesComputer<Instance>(dominators.size(), UIThresholds.MAX_TOPLEVEL_INSTANCES){

                @Override
                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                @Override
                protected HeapViewerNode createNode(Instance instance) {
                    return new InstanceNode(instance);
                }

                @Override
                protected ProgressIterator<Instance> objectsIterator(int index, Progress progress) {
                    ListIterator iterator = dominators.listIterator(index);
                    return new ProgressIterator<Instance>(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Dominators_Messages.getMoreNodesString(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Dominators_Messages.getSamplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Dominators_Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                }
            };
            HeapViewerNode[] nodes = computer.computeNodes(parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            if (nodes.length == 0) {
                HeapViewerNode[] heapViewerNodeArray3 = new HeapViewerNode[1];
                heapViewerNodeArray2 = heapViewerNodeArray3;
                heapViewerNodeArray3[0] = new TextNode(Dominators_Messages.getNoItemsString(viewFilter));
            } else {
                heapViewerNodeArray2 = nodes;
            }
            return heapViewerNodeArray2;
        }
        if (viewFilter != null) {
            Iterator dominatorsI = dominators.iterator();
            while (dominatorsI.hasNext()) {
                if (viewFilter.passes(new InstanceNode((Instance)dominatorsI.next()), heap)) continue;
                dominatorsI.remove();
            }
        }
        ArrayList<InstancesContainer.Objects> cnodes = new ArrayList<InstancesContainer.Objects>();
        HashMap<String, InstancesContainer.Objects> classes = new HashMap<String, InstancesContainer.Objects>();
        for (Instance instance : dominators) {
            JavaClass javaClass = instance.getJavaClass();
            String className = javaClass.getName();
            InstancesContainer.Objects cnode = (InstancesContainer.Objects)((Object)classes.get(className));
            if (cnode == null) {
                cnode = new InstancesContainer.Objects(className, javaClass){

                    @Override
                    protected String getMoreNodesString(String moreNodesCount) {
                        return Dominators_Messages.getMoreNodesString(moreNodesCount);
                    }

                    @Override
                    protected String getSamplesContainerString(String objectsCount) {
                        return Dominators_Messages.getSamplesContainerString(objectsCount);
                    }

                    @Override
                    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                        return Dominators_Messages.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                    }
                };
                classes.put(className, cnode);
                cnodes.add(cnode);
            }
            cnode.add(instance, heap);
        }
        if (aggregation == 1) {
            HeapViewerNode[] heapViewerNodeArray4;
            if (cnodes.isEmpty()) {
                HeapViewerNode[] heapViewerNodeArray5 = new HeapViewerNode[1];
                heapViewerNodeArray4 = heapViewerNodeArray5;
                heapViewerNodeArray5[0] = new TextNode(Dominators_Messages.getNoItemsString(viewFilter));
            } else {
                heapViewerNodeArray4 = cnodes.toArray(HeapViewerNode.NO_NODES);
            }
            return heapViewerNodeArray4;
        }
        ArrayList<ContainerNode> pnodes = new ArrayList<ContainerNode>();
        HashMap<String, ClassesContainer.ContainerNodes> packages = new HashMap<String, ClassesContainer.ContainerNodes>();
        for (InstancesContainer.Objects cnode : cnodes) {
            String className = cnode.getName();
            int nameIdx = className.lastIndexOf(46);
            if (nameIdx == -1) {
                pnodes.add(cnode);
                continue;
            }
            String pkgName = className.substring(0, nameIdx);
            ClassesContainer.ContainerNodes node = (ClassesContainer.ContainerNodes)((Object)packages.get(pkgName));
            if (node == null) {
                node = new ClassesContainer.ContainerNodes(pkgName);
                pnodes.add(node);
                packages.put(pkgName, node);
            }
            node.add(cnode, heap);
        }
        if (pnodes.isEmpty()) {
            HeapViewerNode[] heapViewerNodeArray6 = new HeapViewerNode[1];
            heapViewerNodeArray = heapViewerNodeArray6;
            heapViewerNodeArray6[0] = new TextNode(Dominators_Messages.getNoItemsString(viewFilter));
        } else {
            heapViewerNodeArray = pnodes.toArray(HeapViewerNode.NO_NODES);
        }
        return heapViewerNodeArray;
    }

    static Set<Instance> getDominatorRoots(Heap heap) {
        int searchScope = 1000;
        List searchInstances = heap.getBiggestObjectsByRetainedSize(searchScope);
        HashSet<Instance> dominators = new HashSet<Instance>(searchInstances);
        HashSet<Instance> removed = new HashSet<Instance>();
        block0: for (Instance instance : searchInstances) {
            if (!dominators.contains(instance)) continue;
            Instance dom = instance;
            long retainedSize = instance.getRetainedSize();
            while (!instance.isGCRoot()) {
                if (dominators.contains(instance = instance.getNearestGCRootPointer()) && instance.getRetainedSize() >= retainedSize) {
                    dominators.remove(dom);
                    removed.add(dom);
                    dom = instance;
                    retainedSize = instance.getRetainedSize();
                }
                if (!removed.contains(instance)) continue;
                dominators.remove(dom);
                removed.add(dom);
                continue block0;
            }
        }
        return dominators;
    }

    private static final class Dominators_Messages {
        private Dominators_Messages() {
        }

        private static String getMoreNodesString(String moreNodesCount) {
            return Bundle.Dominators_Messages_MoreNodes(moreNodesCount);
        }

        private static String getSamplesContainerString(String objectsCount) {
            return Bundle.Dominators_Messages_SamplesContainer(objectsCount);
        }

        private static String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return Bundle.Dominators_Messages_NodesContainer(firstNodeIdx, lastNodeIdx);
        }

        private static String getNoItemsString(HeapViewerNodeFilter viewFilter) {
            return viewFilter == null ? Bundle.Dominators_Messages_NoDominators() : Bundle.Dominators_Messages_NoDominatorsFilter();
        }
    }

    private static final class GCRoots_Messages {
        private GCRoots_Messages() {
        }

        private static String getMoreNodesString(String moreNodesCount) {
            return Bundle.GCRoots_Messages_MoreNodes(moreNodesCount);
        }

        private static String getSamplesContainerString(String objectsCount) {
            return Bundle.GCRoots_Messages_SamplesContainer(objectsCount);
        }

        private static String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return Bundle.GCRoots_Messages_NodesContainer(firstNodeIdx, lastNodeIdx);
        }

        private static String getNoItemsString(HeapViewerNodeFilter viewFilter) {
            return viewFilter == null ? Bundle.GCRoots_Messages_NoGCRoots() : Bundle.GCRoots_Messages_NoGCRootsFilter();
        }
    }

    static final class Classes_Messages {
        Classes_Messages() {
        }

        static String getMoreNodesString(String moreNodesCount) {
            return Bundle.Classes_Messages_MoreNodes(moreNodesCount);
        }

        static String getSamplesContainerString(String objectsCount) {
            return Bundle.Classes_Messages_SamplesContainer(objectsCount);
        }

        static String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return Bundle.Classes_Messages_NodesContainer(firstNodeIdx, lastNodeIdx);
        }

        static String getNoClassesString(HeapViewerNodeFilter viewFilter) {
            return viewFilter == null ? Bundle.Classes_Messages_NoClasses() : Bundle.Classes_Messages_NoClassesFilter();
        }

        static String getNoPackagesString(HeapViewerNodeFilter viewFilter) {
            return viewFilter == null ? Bundle.Classes_Messages_NoPackages() : Bundle.Classes_Messages_NoPackagesFilter();
        }
    }
}

