/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css21;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssWidth
extends org.w3c.css.properties.css.CssWidth {
    public CssWidth() {
    }

    public CssWidth(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        switch (val.getType()) {
            case 0: {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(val)) {
                    this.value = inherit;
                    break;
                }
                if (auto.equals(val)) {
                    this.value = auto;
                    break;
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            case 5: {
                val = ((CssNumber)val).getLength();
            }
            case 6: {
                CssLength lenVal = (CssLength)val;
                if (!lenVal.isPositive()) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.value = lenVal;
                break;
            }
            case 4: {
                CssPercentage perVal = (CssPercentage)val;
                if (!perVal.isPositive()) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
                this.value = perVal;
                break;
            }
            default: {
                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssWidth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return this.value == auto;
    }
}

