/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;

public class CssFontFamily
extends org.w3c.css.properties.css.CssFontFamily {
    public static final ArrayList<CssIdent> genericNames;
    public static final String[] _genericNames;

    public static CssIdent getGenericFontName(CssIdent ident) {
        int pos = genericNames.indexOf(ident);
        if (pos >= 0) {
            return genericNames.get(pos);
        }
        return null;
    }

    private void checkExpression(ApplContext ac, ArrayList<CssValue> curval, ArrayList<CssIdent> values, boolean check) {
        if (values.size() > 1) {
            StringBuilder sb = new StringBuilder("\"");
            boolean addSpace = false;
            for (CssIdent id : values) {
                if (addSpace) {
                    sb.append(' ');
                } else {
                    addSpace = true;
                }
                sb.append(id);
            }
            sb.append('\"');
            ac.getFrame().addWarning("with-space", 1);
            curval.add(new CssString(sb.toString()));
        } else {
            CssIdent val = values.get(0);
            if (null != CssFontFamily.getGenericFontName(val)) {
                this.hasGenericFontFamily = true;
            }
            if (CssIdent.isCssWide(val)) {
                // empty if block
            }
            curval.add(val);
        }
    }

    private void checkValues(ApplContext ac, ArrayList<CssValue> values) throws InvalidParamException {
        if (values.size() > 1) {
            for (CssValue val : values) {
                if (val.getType() != 0 || !CssIdent.isCssWide(val.getIdent())) continue;
                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
            }
        }
    }

    public CssFontFamily(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            char op = expression.getOperator();
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 1: {
                    CssIdent id;
                    String s = val.toString();
                    if (s.length() > 2 && CssFontFamily.getGenericFontName(id = new CssIdent(s.substring(1, s.length() - 1))) != null) {
                        ac.getFrame().addWarning("generic-family.quote", 2);
                    }
                    values.add(val);
                    break;
                }
                case 0: {
                    ArrayList<CssIdent> idval = new ArrayList<CssIdent>();
                    idval.add(val.getIdent());
                    while (op == ' ' && expression.getRemainingCount() > 1) {
                        expression.next();
                        op = expression.getOperator();
                        val = expression.getValue();
                        if (val.getType() == 0) {
                            idval.add(val.getIdent());
                            continue;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    this.checkExpression(ac, values, idval, check);
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        this.checkValues(ac, values);
        this.value = values.size() > 1 ? new CssLayerList(values) : values.get(0);
    }

    public CssFontFamily(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssFontFamily() {
        this.value = initial;
    }

    static {
        _genericNames = new String[]{"serif", "sans-serif", "cursive", "fantasy", "monospace", "system-ui", "emoji", "math", "fangsong", "ui-serif", "ui-sans-serif", "ui-monospace", "ui-rounded"};
        genericNames = new ArrayList(_genericNames.length);
        for (String s : _genericNames) {
            genericNames.add(CssIdent.getIdent(s));
        }
    }
}

