#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Flashout 3D
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250704.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='flashout-3d-enhanced-edition'
GAME_NAME='Flashout 3D: Enhanced Edition'

ARCHIVE_BASE_0_NAME='setup_flashout_3d_enhanced_edition_1.0.4_(58979).exe'
ARCHIVE_BASE_0_MD5='f1a898a6f1a5d50f1f482170221557a5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='830000'
ARCHIVE_BASE_0_VERSION='1.0.4-gog58979'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/flashout_3d_enhanced_edition'

UNITY3D_NAME='flashout3d-ee'

CONTENT_PATH_DEFAULT='.'

WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\Jujubee S.A.\Flashout3D-EE'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Work around regedit inability to handle long paths.
## FIXME: regedit_convert_key_to_path should automatically cut paths going over a maximum length.
##        (./play.it 2.32)
wine_launcher_regedit_environment() {
	cat <<- EOF
	# Set environment for registry keys persistent storage

	REGEDIT_DUMPS_WINEPREFIX_PATH="\${WINEPREFIX}/drive_c/${GAME_ID}/wine/regedit"
	REGEDIT_PERSISTENT_KEYS='$WINE_REGEDIT_PERSISTENT_KEYS'

	EOF
	cat <<- 'EOF'
	## Convert registry key name to file path
	regedit_convert_key_to_path() {
	    printf 'flashout3d-ee.reg'
	}

	EOF
}
launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
