#ifndef BUILDBOXCASD_REQUEST_CONTEXT_MANAGER
#define BUILDBOXCASD_REQUEST_CONTEXT_MANAGER

#include <buildboxcommon_grpcclient.h>
#include <buildboxcommon_protos.h>
#include <grpcpp/client_context.h>

namespace buildboxcasd {

using namespace build::bazel::remote::execution::v2;

class RequestContextManager {
  public:
    static RequestMetadata getRequestMetadata();
    static void setRequestMetadata(const RequestMetadata &metadata);
    static void attachMetadata(grpc::ClientContext *ctx);
    static void setServerContext(const grpc::ServerContext *ctx);
    static const grpc::ServerContext *getServerContext();
    static void reset();
    static void configureGrpcClient(buildboxcommon::GrpcClient *client);

  private:
    thread_local static RequestMetadata s_requestMetadata;
    thread_local static bool s_metadataSet;
    thread_local static const grpc::ServerContext *s_serverContext;
};

} // namespace buildboxcasd

#endif
