#include <gtest/gtest.h>
#include <iostream>

#include <buildboxcommon_argvec.h>
#include <processargs.h>

using buildboxcommon::Argvec;

TEST(CasDownloadArgs, HelpTest)
{
    auto argvec = Argvec({"casdownload", "--help"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());
    ASSERT_FALSE(args.d_valid);
}

TEST(CasDownloadArgs, NoRemoteTest)
{
    // Either --remote or --cas-server are required
    auto argvec = Argvec({"casdownload"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());
    ASSERT_FALSE(args.d_valid);
}

TEST(CasDownloadTest, DefaultsAndRootDigestTest)
{
    auto argvec =
        Argvec({"casdownload", "--remote=http://a", "--destination-dir=/foo",
                "--root-digest=deadbeef/123"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());

    ASSERT_TRUE(args.d_valid);
    ASSERT_EQ(args.d_logLevel, buildboxcommon::LogLevel::ERROR);
    ASSERT_EQ(args.d_casConnectionOptions.d_url, "http://a");
    ASSERT_EQ(args.d_destinationDir, "/foo");
    ASSERT_EQ(args.d_digestType, casdownload::DIGEST_ROOT);
    ASSERT_EQ(args.d_digest.hash(), "deadbeef");
    ASSERT_EQ(args.d_digest.size_bytes(), 123);
}

TEST(CasDownloadTest, ActionDigestTest)
{
    auto argvec =
        Argvec({"casdownload", "--remote=http://a", "--destination-dir=/foo",
                "--action-digest=deadbeef/123"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());

    ASSERT_TRUE(args.d_valid);
    ASSERT_EQ(args.d_digestType, casdownload::DIGEST_ACTION);
    ASSERT_EQ(args.d_digest.hash(), "deadbeef");
    ASSERT_EQ(args.d_digest.size_bytes(), 123);
}

TEST(CasDownloadTest, FileDigestTest)
{
    auto argvec =
        Argvec({"casdownload", "--remote=http://a", "--destination-dir=/foo",
                "--file-digest=deadbeef/123"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());

    ASSERT_TRUE(args.d_valid);
    ASSERT_EQ(args.d_digestType, casdownload::DIGEST_FILE);
    ASSERT_EQ(args.d_digest.hash(), "deadbeef");
    ASSERT_EQ(args.d_digest.size_bytes(), 123);
}

TEST(CasDownloadArgs, LogLevelTest)
{
    auto argvec =
        Argvec({"casdownload", "--log-level=warning", "--remote=http://a",
                "--destination-dir=/foo", "--root-digest=deadbeef/123"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());
    ASSERT_TRUE(args.d_valid);
    ASSERT_EQ(args.d_logLevel, buildboxcommon::LogLevel::WARNING);
}

TEST(CasDownloadArgs, VerboseTest)
{
    auto argvec =
        Argvec({"casdownload", "--verbose", "--remote=http://a",
                "--destination-dir=/foo", "--root-digest=deadbeef/123"});
    auto args = casdownload::processArgs(argvec.argc(), argvec.argv());
    ASSERT_TRUE(args.d_valid);
    ASSERT_EQ(args.d_logLevel, buildboxcommon::LogLevel::DEBUG);
}
