// Copyright 2021 Bloomberg Finance L.P
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef INCLUDED_RUMBAD_WRITER
#define INCLUDED_RUMBAD_WRITER

#include <chrono>
#include <vector>

#include <build/buildbox/local_execution.pb.h>

namespace rumbad {

struct Message {
    std::chrono::time_point<std::chrono::system_clock> timestamp;
    build::buildbox::CompilerExecutionData data;
};

class Writer {
  public:
    virtual ~Writer() = default;
    virtual void write(const std::vector<Message> &messages) {};
};

} // namespace rumbad

#endif
