#include <gtest/gtest.h>

#include <buildboxcommon_logging.h>
#include <buildboxworker_expiretime.h>

#include <google/protobuf/timestamp.pb.h>

using namespace buildboxworker;

using namespace testing;

TEST(ExpireTime, convertToTimePoint)
{
    constexpr int64_t NANOS_PER_SECOND = 1000000;
    constexpr int32_t NANOS_PER_MICRO = 1000;

    std::chrono::system_clock::time_point now =
        std::chrono::system_clock::now();

    int64_t seconds = std::chrono::duration_cast<std::chrono::seconds>(
                          now.time_since_epoch())
                          .count();
    int32_t micros = static_cast<int32_t>(
        std::chrono::duration_cast<std::chrono::microseconds>(
            now.time_since_epoch())
            .count() -
        (seconds * NANOS_PER_SECOND));

    google::protobuf::Timestamp timestamp;
    timestamp.set_seconds(seconds);
    timestamp.set_nanos(micros * NANOS_PER_MICRO);
    const std::chrono::system_clock::time_point result =
        ExpireTime::convertToTimePoint(timestamp);

    EXPECT_EQ(std::chrono::duration_cast<std::chrono::microseconds>(
                  now.time_since_epoch()),
              std::chrono::duration_cast<std::chrono::microseconds>(
                  result.time_since_epoch()));
}
