//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <memory>

// template <class X> class auto_ptr;

// X& operator*() const throw();

// REQUIRES: c++98 || c++03 || c++11 || c++14

#define _LIBCUDACXX_DISABLE_DEPRECATION_WARNINGS

#include <memory>
#include <cassert>

#include "test_macros.h"
#include "../A.h"

void
test()
{
    {
    A* p = new A(1);
    const std::auto_ptr<A> ap(p);
    assert((*ap).id() == 1);
    *ap = A(3);
    assert((*ap).id() == 3);
    }
    assert(A::count == 0);
}

int main(int, char**)
{
    test();

  return 0;
}
