/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#include "cbd-test.h"

#include "cbd-service-providers.h"

#include <gio/gio.h>
#include <glib.h>


static void
test_service_providers_parse_de (void)
{
  g_autoptr (GError) err = NULL;
  g_autoptr (GArray) channels = NULL;
  g_autoptr (GArray) expected = NULL;

  channels = cbd_service_provider_get_channels_sync (TEST_DATABASE, "de", &err);

  g_assert_no_error (err);
  g_assert_nonnull (channels);

  expected = cbd_test_channels_get_expected ("de");
  cbd_assert_cmp_channels (channels, expected);
}


static void
test_service_providers_parse_us (void)
{
  g_autoptr (GError) err = NULL;
  g_autoptr (GArray) channels = NULL;
  g_autoptr (GArray) expected = NULL;

  channels = cbd_service_provider_get_channels_sync (TEST_DATABASE, "us", &err);

  g_assert_no_error (err);
  g_assert_nonnull (channels);
  expected = cbd_test_channels_get_expected ("us");
  cbd_assert_cmp_channels (channels, expected);
}


static void
test_service_providers_parse_doesnotexist (void)
{
  g_autoptr (GError) err = NULL;
  g_autoptr (GArray) channels = NULL;

  channels = cbd_service_provider_get_channels_sync (TEST_DATABASE, "doesnotexist", &err);

  g_assert_error (err, G_IO_ERROR, G_IO_ERROR_FAILED);
}


gint
main (gint argc, gchar *argv[])
{
  g_test_init (&argc, &argv, NULL);

  g_test_add_func ("/cbd/service-providers/parse/de", test_service_providers_parse_de);
  g_test_add_func ("/cbd/service-providers/parse/us", test_service_providers_parse_us);
  g_test_add_func ("/cbd/service-providers/parse/doesnotexist",
                   test_service_providers_parse_doesnotexist);

  return g_test_run ();
}
