/*
  Copyright 2024 Northern.tech AS

  This file is part of CFEngine 3 - written and maintained by Northern.tech AS.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  To the extent this program is licensed as part of the Enterprise
  versions of CFEngine, the applicable Commercial Open Source License
  (COSL) may apply to this file if you as a licensee so wish it. See
  included file COSL.txt.
*/

#ifndef CFENGINE_JSON_YAML_H
#define CFENGINE_JSON_YAML_H

#include <json.h>

/* Set by ./configure allowing us to avoid #include <config.h> here. */
// #undef HAVE_LIBYAML

#ifdef HAVE_LIBYAML
#include <yaml.h>
#endif

/**
  @brief Parse a YAML string to create a JsonElement
  @param data [in Pointer to the string to parse
  @param json_out Resulting JSON object
  @returns See JsonParseError and JsonParseErrorToString
  */
JsonParseError JsonParseYamlString(const char **data, JsonElement **json_out);

/**
 * @brief Convenience function to parse JSON from a YAML file
 * @param path Path to the file
 * @param size_max Maximum size to read in memory
 * @param json_out Resulting JSON object
 * @return See JsonParseError and JsonParseErrorToString
 */
JsonParseError JsonParseYamlFile(const char *path, size_t size_max, JsonElement **json_out);

#endif // CFENGINE_JSON_YAML_H
