/*
   Copyright 2021 Northern.tech AS

   This file is part of CFEngine 3 - written and maintained by Northern.tech AS.

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; version 3.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

  To the extent this program is licensed as part of the Enterprise
  versions of CFEngine, the applicable Commercial Open Source License
  (COSL) may apply to this file if you as a licensee so wish it. See
  included file COSL.txt.
*/

/*******************************************************************/
/*                                                                 */
/*  LEXER for cfengine 3                                           */
/*                                                                 */
/*******************************************************************/

#include <platform.h>

#include <cf3parse.h>
#include <parser_state.h>
#include <file_lib.h>
#include <regex.h>
#include <feature.h>
#include <version_comparison.h>

#line 41 "cf3lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 1
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yynoreturn yy_fatal_error (yyconst char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 31
#define YY_END_OF_BUFFER 32
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[339] =
    {   0,
        0,    0,    0,    0,   32,   30,   28,    1,   30,   30,
       30,   29,   30,   30,   30,   19,   30,   30,   19,   30,
       19,   19,   10,   14,   15,   15,   28,    1,    1,    0,
        0,    0,   26,    0,    0,   29,    0,    0,    0,    0,
        0,   22,   19,    0,   21,    0,    0,   25,   19,    0,
       26,   19,   19,   19,   10,   14,    0,   24,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   20,    0,    0,
        0,   19,   19,   19,    0,    0,   23,    0,   27,    0,
        0,    0,    0,    0,    0,   17,   19,   19,    0,    0,
       23,    0,   27,    0,    0,    0,   27,   23,   12,    0,

        0,    0,    0,    0,   19,   19,   11,    0,    0,    0,
        0,    0,    9,    0,    0,    0,    0,    0,    0,   16,
       19,   13,   27,    0,    0,    0,    0,    0,    0,    0,
       18,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    8,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    5,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    6,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    4,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    3,    0,    0,    2,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    7,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    9,    1,    6,   10,   11,
       12,    1,    1,   13,   14,   15,    1,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   17,    1,    1,
       18,   19,    1,   20,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       22,   23,   24,    1,   25,   26,   27,   28,   21,   29,

       30,   31,   21,   21,   32,   21,   21,   33,   34,   35,
       36,   37,   21,   38,   39,   40,   41,   42,   43,   44,
       45,   21,   46,    6,   47,    1,    1,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,

       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48
    } ;

static yyconst YY_CHAR yy_meta[50] =
    {   0,
        1,    2,    3,    1,    2,    2,    1,    1,    4,    1,
        5,    6,    1,    1,    7,    8,    7,    1,    1,    1,
        8,    9,    1,   10,    8,    1,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    4,   11,    7,    1
    } ;

static yyconst flex_uint16_t yy_base[361] =
    {   0,
        0,    0,   47,   49,  834,  835,   52,    0,  830,  815,
       48,    0,   45,   49,  812,   68,  811,   54,   99,  803,
      146,   22,    0,  835,  825,  797,   59,    0,    0,  809,
      808,   59,  807,   68,   55,    0,   65,   66,   58,   82,
       83,  835,  107,  121,  835,   61,  792,  138,   84,  796,
      835,  101,   93,  105,    0,  835,  121,  804,  803,  152,
        0,  148,  807,  142,  771,  157,    0,  800,  777,  786,
      809,  132,  142,  145,  774,  783,  835,  178,  835,  181,
      187,  174,  781,  778,  179,  176,  182,  184,  779,  776,
      181,  783,  782,  220,  781,  226,  780,  198,  835,  772,

      199,  772,  771,  187,  210,  213,  835,  769,  212,  229,
       52,  198,  835,  759,  773,  216,  770,  752,  760,  219,
      227,  835,  835,  764,  751,  756,  748,  750,  757,  756,
      223,  749,  756,  747,  754,  742,  748,  747,  755,  741,
      748,  747,  738,  734,  733,  731,  733,  746,  735,  739,
      734,  733,  736,  733,  722,  738,  751,  736,  735,  721,
      722,  727,  714,    0,  713,  712,  714,  717,  713,  720,
      737,  718,  717,  714,  734,  705,  705,  835,  704,  703,
      704,  721,  697,  654,  653,  613,  599,  246,  597,  595,
      594,  573,  576,  835,  570,  259,  541,  525,  524,  517,

      536,  264,  266,  527,  485,  465,  456,  271,  457,  273,
      278,  447,  414,  437,  425,  835,  412,  280,  123,  285,
      287,  291,  405,  387,  382,  293,  298,  253,  300,  835,
      376,  305,  362,  307,  312,  351,  314,  319,  320,  325,
      326,  331,  339,  835,  302,  333,  835,  295,  341,  346,
      348,  353,  354,  288,  357,  359,   90,  160,  282,  371,
      365,  367,  373,  378,  379,  384,  279,  385,  390,  392,
      334,  396,  404,  408,  268,  410,  415,  261,  417,  422,
      398,  403,  423,  428,  835,  254,  430,  227,  436,  442,
      438,  444,  449,  450,  453,  455,  459,  460,  462,  466,

      468,  474,  480,  346,  476,  482,  487,  489,  214,  490,
      186,  495,  497,  503,  509,  505,  474,  511,  503,  188,
      514,  516,  521,  524,  529,  523,  529,  531,  534,  543,
      133,  109,  539,  542,  320,  546,   90,  835,  562,  573,
      583,  591,  602,  613,  623,  630,  638,  649,  660,  665,
      669,  679,  689,  692,  696,  704,  712,  720,  728,   69
    } ;

static yyconst flex_int16_t yy_def[361] =
    {   0,
      338,    1,  339,  339,  338,  338,  338,  340,  338,  341,
      342,  343,  338,  344,  338,  345,  338,  338,  346,  347,
      346,   21,  348,  338,  338,  338,  338,  340,  340,  341,
      341,  342,  338,  342,  349,  343,  350,  351,  344,  344,
      352,  338,  345,  353,  338,  338,  338,  353,   21,  347,
      338,   21,   21,   21,  348,  338,  338,  341,  338,  349,
      349,  350,  354,  351,  355,  352,  352,   48,  338,  338,
      338,   21,   21,   21,  338,  338,  338,  349,  338,  356,
      357,  352,  338,  338,  338,   21,   21,   21,  338,  338,
      349,  358,  358,  356,  359,  357,  359,  352,  338,  338,

      338,  338,  338,  338,   21,   21,  338,  338,  338,  354,
      338,  355,  338,  338,  338,  338,  338,  338,  338,   21,
       21,  338,  338,  338,  338,  338,  338,  338,  338,  338,
       21,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  360,  338,  338,  338,  338,  338,  338,
      360,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,

      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,

      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,    0,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338
    } ;

static yyconst flex_uint16_t yy_nxt[885] =
    {   0,
        6,    7,    8,    9,    7,   10,   11,   12,   13,   14,
       10,   10,    6,   15,   10,   16,   10,   17,    6,   18,
       19,    6,    6,    6,   19,   20,   19,   21,   19,   19,
       19,   19,   19,   19,   19,   19,   22,   19,   19,   19,
       19,   19,   19,   19,   19,    6,    6,   16,    6,   24,
       25,   24,   25,   27,   33,   37,   27,   49,   33,   54,
       27,   51,   49,   27,   37,   33,   26,   33,   26,   30,
       34,   40,   30,   30,   60,  111,  171,   61,   30,   30,
       40,   34,   30,   46,   44,   47,   63,   65,   63,   65,
       38,   66,   51,   69,  257,   70,   35,   41,   79,   38,

       30,  285,  258,   30,   30,   67,   41,   35,   30,   30,
       30,   30,   30,   30,   43,   48,   35,   30,   30,   49,
      247,   30,   30,   44,   49,   30,   30,   73,   49,   72,
       41,   30,   30,   49,  194,   30,   49,   58,  228,   30,
       74,   49,   30,   30,  244,   49,   43,   30,   30,   30,
       30,   30,   30,   75,   58,   76,   30,   30,   51,   79,
       30,   43,   48,   81,  271,   65,   51,   49,   78,   80,
       87,   63,   49,   82,   61,  272,   86,   49,   88,   67,
       49,   52,   49,   51,   51,   49,   53,   51,   79,   92,
       98,   92,   93,   43,   91,   95,   67,   95,   95,  230,

       61,  321,   63,   61,   63,  101,  102,   51,   65,  103,
       65,   49,  104,  118,  105,  106,   49,   49,  119,   49,
       67,  112,   49,   79,   49,  216,   92,   92,   92,  114,
       92,   93,   95,   97,   95,  109,   95,   95,  115,  120,
      123,   63,  302,  110,  123,   49,  126,   65,   49,  112,
       49,  121,  110,   49,   49,  127,  131,  194,   49,   49,
      195,  196,   49,   49,  194,   92,   92,   49,  239,  300,
      194,   95,   97,  195,  203,  194,  294,  194,  209,  210,
      195,  211,  216,  291,  194,  217,  218,  209,  220,  194,
      194,  216,  195,  221,  217,  227,  194,  273,  194,  209,

      229,  195,  230,  268,  216,  231,  232,  236,  237,  216,
      263,  194,  217,  238,  209,  240,  230,  261,  244,  231,
      242,  245,  246,  247,  257,  216,  248,  249,  236,  251,
      216,  194,  258,  217,  252,  253,  194,  230,  271,  209,
      254,  255,  230,  257,  244,  231,  256,  245,  262,  272,
      257,  258,  247,  259,  260,  248,  264,  216,  258,  216,
      259,  265,  236,  266,  216,  194,  250,  217,  230,  267,
      230,  254,  269,  231,  270,  257,  244,  243,  244,  275,
      276,  245,  277,  258,  247,  259,  274,  278,  279,  247,
      216,  241,  248,  280,  281,  216,  230,  235,  236,  282,

      283,  230,  234,  230,  254,  284,  231,  285,  257,  216,
      286,  287,  257,  297,  216,  233,  258,  236,  288,  289,
      258,  244,  259,  290,  275,  292,  244,  226,  247,  245,
      293,  278,  295,  247,  230,  225,  248,  296,  298,  230,
      257,  285,  254,  299,  286,  301,  257,  224,  258,  244,
      288,  303,  223,  305,  258,  244,  259,  304,  275,  306,
      244,  247,  222,  245,  247,  307,  247,  278,  308,  248,
      216,  230,  219,  230,  309,  310,  254,  285,  257,  285,
      311,  312,  286,  313,  257,  244,  258,  244,  275,  314,
      215,  316,  258,  244,  288,  315,  275,  317,  247,  214,

      247,  230,  318,  278,  319,  320,  285,  257,  285,  311,
      322,  286,  323,  257,  247,  258,  244,  278,  324,  213,
      326,  258,  247,  288,  325,  285,  327,  285,  257,  328,
      311,  329,  285,  257,  244,  286,  258,  212,  331,  330,
      247,  258,  285,  288,  332,  285,  333,  257,  311,  334,
      285,  208,  207,  285,  336,  258,  311,  285,  335,  206,
      205,  337,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   28,   28,  204,   28,   28,   28,   28,
       28,   28,   28,   28,   30,  202,  201,   30,   30,   30,
       30,   32,   32,   32,   32,   32,   32,   32,   32,   32,

       32,   32,   36,   36,  200,   36,   36,   36,   36,   36,
       36,   36,   36,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,   43,  199,  198,   43,   43,   43,
       43,   49,  197,  193,   49,   49,   49,   49,   50,   50,
       50,   50,   50,   50,   50,   50,   50,   50,   50,   55,
       55,  192,   55,   55,   55,   55,   55,   55,   55,   55,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   62,   62,   62,   62,   64,   64,   64,   64,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       68,  191,  190,   68,   68,   68,   68,   63,   63,   63,

       63,   63,   65,   65,   65,   65,   65,   94,   94,   94,
       94,   94,   94,   94,   94,   96,   96,   96,   96,   96,
       96,   96,   96,   92,   92,   92,   92,   92,  189,   92,
       92,   95,   95,   95,   95,   95,  188,   95,   95,  187,
      186,  185,  184,  183,  182,  181,  180,  179,  178,  177,
      176,  175,  174,  173,  172,  170,  169,  168,  167,  166,
      165,  164,  163,  162,  161,  160,  159,  158,  157,  156,
      155,  154,  153,  152,  151,  150,  149,  148,  147,  146,
      145,  144,  143,  142,  141,  140,  139,  138,  137,  136,
      135,  134,  133,  132,  130,  129,  128,  125,  124,  122,

      117,  116,  113,  111,  111,  109,  109,  108,  107,  100,
       99,   90,   89,   85,   84,   83,   31,   79,   79,   77,
       58,   51,   71,   59,   58,   31,   57,   56,   51,   45,
       42,   31,   29,  338,    5,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338
    } ;

static yyconst flex_int16_t yy_chk[885] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
        3,    4,    4,    7,   11,   13,    7,   22,   14,   22,
       27,   35,   22,   27,   18,   32,    3,   39,    4,   16,
       11,   14,   16,   16,   34,  111,  360,   35,   16,   16,
       39,   32,   16,   18,   16,   18,   37,   38,   37,   38,
       13,   40,   41,   46,  257,   46,   11,   14,  111,   18,

       19,  337,  257,   19,   19,   41,   39,   32,   43,   19,
       19,   43,   43,   19,   19,   19,   34,   43,   43,   49,
      332,   43,   44,   43,   49,   44,   44,   53,   53,   52,
       40,   44,   44,   53,  219,   44,   52,   44,  219,   48,
       54,   52,   48,   48,  331,   54,   19,   21,   48,   48,
       21,   21,   48,   57,   48,   57,   21,   21,   60,   62,
       21,   21,   21,   64,  258,   64,   66,   72,   60,   62,
       73,   62,   72,   66,   60,  258,   72,   73,   74,   66,
       74,   21,   73,   82,   78,   74,   21,   91,   64,   80,
       82,   80,   80,   21,   78,   81,   82,   81,   81,  320,

       78,  311,   80,   91,   80,   85,   85,   98,   81,   85,
       81,   86,   85,  104,   87,   88,   86,   87,  104,   88,
       98,  112,   87,  109,   88,  309,   80,   80,   94,  101,
       94,   94,   81,   81,   96,  109,   96,   96,  101,  105,
      110,   94,  288,   94,  112,  105,  116,   96,  106,   96,
      105,  106,  110,  106,  120,  116,  121,  188,  131,  120,
      188,  188,  121,  131,  228,   94,   94,  121,  228,  286,
      196,   96,   96,  196,  196,  202,  278,  203,  202,  202,
      203,  203,  208,  275,  210,  208,  208,  210,  210,  211,
      267,  218,  211,  211,  218,  218,  220,  259,  221,  220,

      220,  221,  222,  254,  226,  222,  222,  226,  226,  227,
      248,  229,  227,  227,  229,  229,  232,  245,  234,  232,
      232,  234,  234,  235,  335,  237,  235,  235,  237,  237,
      238,  239,  335,  238,  238,  239,  240,  241,  271,  240,
      241,  241,  242,  243,  246,  242,  242,  246,  246,  271,
      304,  243,  249,  243,  243,  249,  249,  250,  304,  251,
      304,  250,  251,  251,  252,  253,  236,  252,  255,  253,
      256,  255,  255,  256,  256,  260,  261,  233,  262,  261,
      261,  262,  262,  260,  263,  260,  260,  263,  263,  264,
      265,  231,  264,  264,  265,  266,  268,  225,  266,  266,

      268,  269,  224,  270,  269,  269,  270,  272,  273,  281,
      272,  272,  274,  281,  282,  223,  273,  282,  273,  273,
      274,  276,  274,  274,  276,  276,  277,  217,  279,  277,
      277,  279,  279,  280,  283,  215,  280,  280,  283,  284,
      289,  287,  284,  284,  287,  287,  290,  214,  289,  291,
      289,  289,  213,  291,  290,  292,  290,  290,  292,  292,
      293,  294,  212,  293,  295,  294,  296,  295,  295,  296,
      297,  298,  209,  299,  297,  298,  299,  300,  302,  301,
      300,  300,  301,  301,  303,  317,  302,  305,  317,  302,
      207,  305,  303,  306,  303,  303,  306,  306,  307,  206,

      308,  310,  307,  308,  308,  310,  312,  314,  313,  312,
      312,  313,  313,  315,  319,  314,  316,  319,  314,  205,
      316,  315,  318,  315,  315,  321,  318,  322,  324,  321,
      322,  322,  323,  325,  326,  323,  324,  204,  326,  324,
      327,  325,  328,  325,  327,  329,  328,  330,  329,  329,
      333,  201,  200,  334,  333,  330,  334,  336,  330,  199,
      198,  336,  339,  339,  339,  339,  339,  339,  339,  339,
      339,  339,  339,  340,  340,  197,  340,  340,  340,  340,
      340,  340,  340,  340,  341,  195,  193,  341,  341,  341,
      341,  342,  342,  342,  342,  342,  342,  342,  342,  342,

      342,  342,  343,  343,  192,  343,  343,  343,  343,  343,
      343,  343,  343,  344,  344,  344,  344,  344,  344,  344,
      344,  344,  344,  344,  345,  191,  190,  345,  345,  345,
      345,  346,  189,  187,  346,  346,  346,  346,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  348,
      348,  186,  348,  348,  348,  348,  348,  348,  348,  348,
      349,  349,  349,  349,  349,  349,  349,  349,  349,  349,
      349,  350,  350,  350,  350,  351,  351,  351,  351,  352,
      352,  352,  352,  352,  352,  352,  352,  352,  352,  352,
      353,  185,  184,  353,  353,  353,  353,  354,  354,  354,

      354,  354,  355,  355,  355,  355,  355,  356,  356,  356,
      356,  356,  356,  356,  356,  357,  357,  357,  357,  357,
      357,  357,  357,  358,  358,  358,  358,  358,  183,  358,
      358,  359,  359,  359,  359,  359,  182,  359,  359,  181,
      180,  179,  177,  176,  175,  174,  173,  172,  171,  170,
      169,  168,  167,  166,  165,  163,  162,  161,  160,  159,
      158,  157,  156,  155,  154,  153,  152,  151,  150,  149,
      148,  147,  146,  145,  144,  143,  142,  141,  140,  139,
      138,  137,  136,  135,  134,  133,  132,  130,  129,  128,
      127,  126,  125,  124,  119,  118,  117,  115,  114,  108,

      103,  102,  100,   97,   95,   93,   92,   90,   89,   84,
       83,   76,   75,   71,   70,   69,   68,   65,   63,   59,
       58,   50,   47,   33,   31,   30,   26,   25,   20,   17,
       15,   10,    9,    5,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "cf3lex.l"

#line 43 "cf3lex.l"
/* yyinput/input are generated and unused */

#if defined(__GNUC__)
# define GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)
# if GCC_VERSION >= 40200
#  pragma GCC diagnostic ignored "-Wunused-function"
# endif
#endif

#undef malloc
#undef realloc
#define malloc xmalloc
#define realloc xrealloc

//#define ParserDebug if (LogGetGlobalLevel() >= LOG_LEVEL_DEBUG) printf
#define ParserDebug(...) ((void) 0)
#define P PARSER_STATE

static Regex *context_expression_whitespace_rx = NULL;

static int DeEscapeQuotedString(const char *from, char *to);

int yywrap(void)
{
return 1;
}

static void yyuseraction()
{
P.offsets.current += yyleng;
}

#define YY_USER_ACTION yyuseraction();

// Do not use lex - flex only


/*
 * Three types of quoted strings:
 *
 * - string in double quotes, starts with double quote, runs until another
 *   double quote, \" masks the double quote.
 * - string in single quotes, starts with single quote, runs until another
 *   single quote, \' masks the single quote.
 * - string in backquotes, starts with backquote, runs until another backquote.
 *
 * The same rule formatted for the better readability:
 *
 * <qstring> := \" <dq> \" | \' <sq> \' | ` <bq> `
 * <dq> = <dqs>*
 * <dqs> = \\ <any> | [^"\\]
 * <sq> = <sqs>*
 * <sqs> = \\ <any> | [^'\\]
 * <bq> = <bqs>*
 * <bqs> = [^`]
 * <any> = . | \n
 *
 */
#line 856 "cf3lex.c"

#define INITIAL 0
#define if_ignore_state 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

			int yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput (int c,char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 147 "cf3lex.l"

#line 1077 "cf3lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 339 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 835 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 148 "cf3lex.l"
{
                          free(P.current_line);
                          P.current_line = xstrdup(yytext+1);
                          ParserDebug("L:line %s\n", P.current_line);
                          P.line_no++;
                          P.line_pos = 1;
                          // push back on stack and skip first char
                          yyless(1);
                      }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 158 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                             yyerror("fatal: macro @if must be at beginning of the line.");
                             return 0;
                        }
                        if (P.if_depth > 0)
                        {
                          yyerror("fatal: nested @if macros are not allowed");
                          return 0;
                        }

                        P.if_depth++;

                        const char* minimum = yytext+20;
                        ParserDebug("\tL:macro @if %d:version=%s\n", P.line_pos, minimum);

                        VersionComparison result = CompareVersion(Version(), minimum);
                        if (result == VERSION_GREATER || result == VERSION_EQUAL)
                        {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                        }
                        else if (result == VERSION_SMALLER)
                        {
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                        }
                        else
                        {
                            assert(result == VERSION_ERROR);
                            yyerror("fatal: macro @if requested an unparseable version");
                        }
                      }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 192 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                             yyerror("fatal: macro @if must be at beginning of the line.");
                             return 0;
                        }
                        if (P.if_depth > 0)
                        {
                          yyerror("fatal: nested @if macros are not allowed");
                          return 0;
                        }

                        P.if_depth++;

                        const char* maximum = yytext+20;
                        ParserDebug("\tL:macro @if %d:version=%s\n", P.line_pos, maximum);

                        VersionComparison result = CompareVersion(Version(), maximum);
                        if (result == VERSION_SMALLER || result == VERSION_EQUAL)
                        {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                        }
                        else if (result == VERSION_GREATER)
                        {
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                        }
                        else
                        {
                            assert(result == VERSION_ERROR);
                            yyerror("fatal: macro @if requested an unparseable version");
                        }
                      }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 226 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                             yyerror("fatal: macro @if must be at beginning of the line.");
                             return 0;
                        }
                        if (P.if_depth > 0)
                        {
                          yyerror("fatal: nested @if macros are not allowed");
                          return 0;
                        }

                        P.if_depth++;

                        const char* target = yytext + strlen("@if before_version(");
                        ParserDebug("\tL:macro @if %d:version=%s\n", P.line_pos, target);

                        VersionComparison result = CompareVersion(Version(), target);
                        if (result == VERSION_SMALLER)
                        {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                        }
                        else if (result == VERSION_GREATER || result == VERSION_EQUAL)
                        {
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                        }
                        else
                        {
                            assert(result == VERSION_ERROR);
                            yyerror("fatal: macro @if requested an unparseable version");
                        }
                      }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 260 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                             yyerror("fatal: macro @if must be at beginning of the line.");
                             return 0;
                        }
                        if (P.if_depth > 0)
                        {
                          yyerror("fatal: nested @if macros are not allowed");
                          return 0;
                        }

                        P.if_depth++;

                        const char* target = yytext + strlen("@if at_version(");
                        ParserDebug("\tL:macro @if %d:version=%s\n", P.line_pos, target);

                        VersionComparison result = CompareVersion(Version(), target);
                        if (result == VERSION_EQUAL)
                        {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                        }
                        else if (result == VERSION_GREATER || result == VERSION_SMALLER)
                        {
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                        }
                        else
                        {
                            assert(result == VERSION_ERROR);
                            yyerror("fatal: macro @if requested an unparseable version");
                        }
                      }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 294 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                             yyerror("fatal: macro @if must be at beginning of the line.");
                             return 0;
                        }
                        if (P.if_depth > 0)
                        {
                          yyerror("fatal: nested @if macros are not allowed");
                          return 0;
                        }

                        P.if_depth++;

                        const char* target = yytext + strlen("@if after_version(");
                        ParserDebug("\tL:macro @if %d:version=%s\n", P.line_pos, target);

                        VersionComparison result = CompareVersion(Version(), target);
                        if (result == VERSION_GREATER)
                        {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                        }
                        else if (result == VERSION_EQUAL || result == VERSION_SMALLER)
                        {
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                        }
                        else
                        {
                            assert(result == VERSION_ERROR);
                            yyerror("fatal: macro @if requested an unparseable version");
                        }
                      }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 328 "cf3lex.l"
{
                        if ( P.line_pos != 1 )
                        {
                             yyerror("fatal: macro @if must be at beginning of the line.");
                             return 0;
                        }
                        if (P.if_depth > 0)
                        {
                          yyerror("fatal: nested @if macros are not allowed");
                          return 0;
                        }

                        P.if_depth++;

                        const char* from = yytext + strlen("@if between_versions(");

                        const char *to = strchr(from, ',');
                        to += 1;
                        while (*to == ' ')
                        {
                            to += 1;
                        }

                        ParserDebug("\tL:macro @if %d:between_versions(%s\n", P.line_pos, from);

                        VersionComparison a = CompareVersion(Version(), from);
                        VersionComparison b = CompareVersion(Version(), to);
                        if ((a == VERSION_EQUAL || a == VERSION_GREATER)
                            && (b == VERSION_EQUAL || b == VERSION_SMALLER))
                        {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                        }
                        else
                        {
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                        }
                      }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 367 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                          yyerror("fatal: macro @if must be at beginning of the line.");
                          return 0;
                        }

                        char* feature_text = yytext+12;
                        // remove trailing ')'
                        feature_text[strlen(feature_text)-1] = 0;
                        ParserDebug("\tL:macro @if %d:feature=%s\n", P.line_pos, feature_text);
                        {
                          if (P.if_depth > 0)
                          {
                            yyerror("fatal: nested @if macros are not allowed");
                            return 0;
                          }

                          P.if_depth++;

                          if (KnownFeature(feature_text))
                          {
                            ParserDebug("\tL:macro @if %d:accepted to next @endif\n", P.line_pos);
                          }
                          else
                          {
                            /* ignore to the next @endif */
                            ParserDebug("\tL:macro @if %d:ignoring to next @endif or EOF\n", P.line_pos);
                            BEGIN(if_ignore_state);
                          }
                        }
                      }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 400 "cf3lex.l"
{
                        if (  P.line_pos != 1 )
                        {
                          yyerror("fatal: macro @endif must be at beginning of the line.");
                          return 0;
                        }

                        ParserDebug("\tL:macro @endif %d\n", P.line_pos);
                        BEGIN(INITIAL);
                        if (P.if_depth <= 0)
                        {
                          yyerror("fatal: @endif macros without a matching @if are not allowed");
                          return 0;
                        }
                        P.if_depth--;
                      }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 418 "cf3lex.l"
{
                                  ParserDebug("\tL:inside macro @if, ignoring line text:\"%s\"\n", yytext);
                               }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 422 "cf3lex.l"
{
                                ParserDebug("\tL:macro @else, will no longer ignore lines\n", P.line_pos);
                                BEGIN(INITIAL);
                              }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 426 "cf3lex.l"
{
                                if (P.if_depth <= 0)
                                {
                                  yyerror("fatal: @else macro without a matching @if are not allowed");
                                  return 0;
                                }
                                ParserDebug("\tL:macro @else, will now ignore lines\n", P.line_pos);
                                BEGIN(if_ignore_state);
                              }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 436 "cf3lex.l"
{
                                 ParserDebug("\tL:macro @endif %d\n", P.line_pos);
                                 BEGIN(INITIAL);
                                 if (P.if_depth <= 0)
                                 {
                                   yyerror("fatal: @endif macros without a matching @if are not allowed");
                                   return 0;
                                 }
                                 P.if_depth--;
                               }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 447 "cf3lex.l"
{
                           }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 450 "cf3lex.l"
{
                          /* eat up al unknown chars when line starts with @*/
                          ParserDebug("\tL:inside macro @if, ignoring char text:\"%s\"\n", yytext);
                      }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 455 "cf3lex.l"
{
                          /* Note this has to come before "id" since it is a subset of id */

                          if (P.currentclasses != NULL)
                          {
                              free(P.currentclasses);
                              P.currentclasses = NULL;
                          }

                          if (P.currentvarclasses != NULL)
                          {
                              free(P.currentvarclasses);
                              P.currentvarclasses = NULL;
                          }

                          P.line_pos += yyleng;
                          ParserDebug("\tL:bundle %d\n", P.line_pos);
                          return BUNDLE;
                      }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 475 "cf3lex.l"
{
                          /* Note this has to come before "id" since it is a subset of id */

                          if (P.currentclasses != NULL)
                          {
                              free(P.currentclasses);
                              P.currentclasses = NULL;
                          }

                          if (P.currentvarclasses != NULL)
                          {
                              free(P.currentvarclasses);
                              P.currentvarclasses = NULL;
                          }

                          P.line_pos += yyleng;
                          ParserDebug("\tL:body %d\n", P.line_pos);
                          return BODY;
                      }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 495 "cf3lex.l"
{
                          /* Note this has to come before "id" since it is a subset of id */

                          if (P.currentclasses != NULL)
                          {
                              free(P.currentclasses);
                              P.currentclasses = NULL;
                          }

                          if (P.currentvarclasses != NULL)
                          {
                              free(P.currentvarclasses);
                              P.currentvarclasses = NULL;
                          }

                          P.line_pos += yyleng;
                          ParserDebug("\tL:promise %d\n", P.line_pos);
                          return PROMISE;
                      }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 515 "cf3lex.l"
{
                          P.offsets.last_id = P.offsets.current - yyleng;
                          P.line_pos += yyleng;
                          ParserDebug("\tL:id %s %d\n", yytext, P.line_pos);
                          if (yyleng  > CF_MAXVARSIZE-1)
                          {
                              yyerror("identifier too long");
                          }
                          strncpy(P.currentid, yytext, CF_MAXVARSIZE - 1);
                          return IDENTIFIER;
                      }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 528 "cf3lex.l"
{
                          P.offsets.last_id = P.offsets.current - yyleng;
                          P.line_pos += yyleng;
                          ParserDebug("\tL:symbol %s %d\n", yytext, P.line_pos);
                          if (yyleng > CF_MAXVARSIZE-1)
                          {
                              yyerror("qualified identifier too long");
                          }
                          strncpy(P.currentid, yytext, CF_MAXVARSIZE - 1);
                          return IDENTIFIER;
                      }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 541 "cf3lex.l"
{
                          P.line_pos += yyleng;
                          ParserDebug("\tL:assign %d\n", P.line_pos);
                          return FAT_ARROW;
                      }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 547 "cf3lex.l"
{
                          P.line_pos += yyleng;
                          ParserDebug("\tL:arrow %d\n", P.line_pos);
                          return THIN_ARROW;
                      }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 553 "cf3lex.l"
{
                          char *tmp = NULL;

                          P.line_pos += yyleng;
                          ParserDebug("\tL:varclass %s %d\n", yytext, P.line_pos);

                          tmp = xstrdup(yytext+1); // remove leading quote
                          tmp[yyleng-4] = '\0'; // remove tail quote plus ::

                          if (P.currentclasses != NULL)
                          {
                              free(P.currentclasses);
                              P.currentclasses = NULL;
                          }

                          if (P.currentvarclasses != NULL)
                          {
                              free(P.currentvarclasses);
                              P.currentvarclasses = NULL;
                          }

                          P.currentvarclasses = xstrdup(tmp);

                          free(tmp);
                          return CLASS_GUARD;
                      }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 580 "cf3lex.l"
{
                          char *tmp = NULL;

                          P.line_pos += yyleng;
                          ParserDebug("\tL:class %s %d\n", yytext, P.line_pos);
                          if (context_expression_whitespace_rx == NULL)
                          {
                              context_expression_whitespace_rx = CompileRegex(CFENGINE_REGEX_WHITESPACE_IN_CONTEXTS);
                          }

                          if (context_expression_whitespace_rx == NULL)
                          {
                              yyerror("The context expression whitespace regular expression could not be compiled, aborting.");
                          }

                          if (StringMatchFullWithPrecompiledRegex(context_expression_whitespace_rx, yytext))
                          {
                              yyerror("class names can't be separated by whitespace without an intervening operator");
                          }

                          tmp = xstrdup(yytext);
                          tmp[yyleng-2] = '\0';

                          if (P.currentclasses != NULL)
                          {
                              free(P.currentclasses);
                              P.currentclasses = NULL;
                          }

                          if (P.currentvarclasses != NULL)
                          {
                              free(P.currentvarclasses);
                              P.currentvarclasses = NULL;
                          }

                          P.currentclasses = xstrdup(tmp);

                          free(tmp);
                          return CLASS_GUARD;
                      }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 621 "cf3lex.l"
{
                          char *tmp = NULL;

                          P.line_pos += yyleng;
                          ParserDebug("\tL:promise_guard %s %d\n", yytext, P.line_pos);
                          P.offsets.last_promise_guard_id = P.offsets.current - yyleng;

                          tmp = xstrdup(yytext);
                          assert(tmp[yyleng - 1] == ':');
                          tmp[yyleng - 1] = '\0'; // Exclude trailing colon in promise guard
                          assert(strlen(tmp) > 0);
                          assert(tmp[strlen(tmp) - 1] != ':');

                          strncpy(P.currenttype, tmp, CF_MAXVARSIZE - 1);

                          if (P.currentclasses != NULL)
                          {
                              free(P.currentclasses);
                              P.currentclasses = NULL;
                          }

                          if (P.currentvarclasses != NULL)
                          {
                              free(P.currentvarclasses);
                              P.currentvarclasses = NULL;
                          }

                          free(tmp);
                          return PROMISE_GUARD;
                      }
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 652 "cf3lex.l"
{
                          char *tmp = NULL;
                          int less = 0;

                          P.offsets.last_string = P.offsets.current - yyleng;
                          P.line_pos += yyleng;
                          ParserDebug("\tL:qstring %s %d\n", yytext, P.line_pos);

                          for (char *c = yytext; *c; ++c)
                          {
                              if (*c == '\n')
                              {
                                  P.line_no++;
                              }
                          }

                          tmp = xmalloc(yyleng + 1);

                          if ((less = DeEscapeQuotedString(yytext,tmp)) > 0)
                          {
                              yyless(less);
                              P.offsets.current -= less;
                          }

                          if (P.currentstring)
                          {
                              free(P.currentstring);
                          }

                          P.currentstring = xstrdup(tmp);

                          free(tmp);
                          return QUOTED_STRING;
                      }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 688 "cf3lex.l"
{
                          P.line_pos += yyleng;
                          ParserDebug("\tL: %s %d\n", yytext, P.line_pos);
                          if (P.currentstring)
                          {
                              free(P.currentstring);
                          }
                          P.currentstring = xstrdup(yytext);
                          return NAKEDVAR;
                      }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 699 "cf3lex.l"
{
                          P.line_pos += yyleng;
                      }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 703 "cf3lex.l"
{
                      }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 707 "cf3lex.l"
{
                          P.line_pos++;
                          return yytext[0];
                      }
	YY_BREAK
case YY_STATE_EOF(if_ignore_state):
#line 712 "cf3lex.l"
{
                               if (P.if_depth > 0)
                               {
                                 yyerror("EOF seen while @if was waiting for @endif in ignore_state");
                                 return 0;
                               }
                             }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 720 "cf3lex.l"
{
              if (P.if_depth > 0)
              {
                yyerror("EOF seen while @if was waiting for @endif without ignore_state");
              }
              return 0; // loops forever without this
            }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 728 "cf3lex.l"
ECHO;
	YY_BREAK
#line 1813 "cf3lex.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 49);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 339 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 49;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 339 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
	yy_is_jam = (yy_current_state == 338);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,(int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 728 "cf3lex.l"



static int DeEscapeQuotedString(const char *from, char *to)
{
    char *cp;
    const char *sp;
    char start = *from;
    int len = strlen(from);

    if (len == 0)
    {
        return 0;
    }

    for (sp = from + 1, cp = to; (sp - from) < len; sp++, cp++)
    {
        if ((*sp == start))
        {
            *(cp) = '\0';

            if (*(sp + 1) != '\0')
            {
                return (2 + (sp - from));
            }

            return 0;
        }

      if (*sp == '\\')
      {
            switch (*(sp + 1))
            {
            case '\n':
                sp += 2;
                break;

            case ' ':
                break;

            case '\\':
            case '\"':
            case '\'':
                sp++;
                break;
            }
        }

        *cp = *sp;
    }

    yyerror("Runaway string");
    *(cp) = '\0';
    return 0;
}


/* EOF */

