#pragma once
/*
 *  $Id: gwyglsetup.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2006-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GL_SETUP_H__
#define __GWYUI_GL_SETUP_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
    GWY_GL_MOVEMENT_NONE = 0,
    GWY_GL_MOVEMENT_ROTATION,
    GWY_GL_MOVEMENT_SCALE,
    GWY_GL_MOVEMENT_DEFORMATION,
    GWY_GL_MOVEMENT_LIGHT
} GwyGLMovement;

typedef enum {
    GWY_GL_PROJECTION_ORTHOGRAPHIC = 0,
    GWY_GL_PROJECTION_PERSPECTIVE
} GwyGLProjection;

typedef enum {
    GWY_GL_VISUALIZATION_GRADIENT = 0,
    GWY_GL_VISUALIZATION_LIGHTING,
    GWY_GL_VISUALIZATION_OVERLAY,
    GWY_GL_VISUALIZATION_OVERLAY_NO_LIGHT
} GwyGLVisualization;

typedef enum {
    GWY_GL_VIEW_LABEL_X = 0,
    GWY_GL_VIEW_LABEL_Y,
    GWY_GL_VIEW_LABEL_MIN,
    GWY_GL_VIEW_LABEL_MAX,
    GWY_GL_VIEW_NLABELS
} GwyGLViewLabel;

#define GWY_TYPE_GL_SETUP            (gwy_gl_setup_get_type())
#define GWY_GL_SETUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GL_SETUP, GwyGLSetup))
#define GWY_GL_SETUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GL_SETUP, GwyGLSetupClass))
#define GWY_IS_GL_SETUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GL_SETUP))
#define GWY_IS_GL_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GL_SETUP))
#define GWY_GL_SETUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GL_SETUP, GwyGLSetupClass))

typedef struct _GwyGLSetup        GwyGLSetup;
typedef struct _GwyGLSetupClass   GwyGLSetupClass;
typedef struct _GwyGLSetupPrivate GwyGLSetupPrivate;

struct _GwyGLSetup {
    GObject parent_instance;
    GwyGLSetupPrivate *priv;
};

struct _GwyGLSetupClass {
    GObjectClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType       gwy_gl_setup_get_type(void)  G_GNUC_CONST;
GwyGLSetup* gwy_gl_setup_new     (void);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
