/*
 *  $Id: xy.c 28135 2025-06-24 14:51:47Z yeti-dn $
 *  Copyright (C) 2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "tests/testlibgwy.h"

static void
serialize_and_back(GwyXY xy)
{
    GwyXY *copy = serialize_boxed_and_back(&xy, GWY_TYPE_XY, TRUE);
    g_assert_cmpfloat(xy.x, ==, copy->x);
    g_assert_cmpfloat(xy.y, ==, copy->y);
    g_boxed_free(GWY_TYPE_XY, copy);
}

void
test_xy_boxed_serialization(void)
{
    serialize_and_back((GwyXY){ G_PI, -1 });
    serialize_and_back((GwyXY){ 0.0, 7.2 });
    serialize_and_back((GwyXY){ 31.125, 0.0 });
    serialize_and_back((GwyXY){ 0.0, 0.0 });
}

void
test_xy_boxed_equal(void)
{
    GwyXY xy1 = { 3.6, 1e14 };
    GwyXY xy2 = { 3.6, 3.6 };
    GwyXY xy3 = { 1e14, 1e14 };
    GwyXY xy4 = { 3.6, 1e14 };

    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XY, &xy1, &xy2));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XY, &xy1, &xy3));
    g_assert_false(gwy_serializable_boxed_equal(GWY_TYPE_XY, &xy2, &xy3));
    g_assert_true(gwy_serializable_boxed_equal(GWY_TYPE_XY, &xy1, &xy4));
}

void
test_xy_boxed_assign(void)
{
    GwyXY xy1 = { 3.6, 1e14 };
    GwyXY xy2 = { 7.7, 1e-6 };
    GwyXY xy3, xy0;

    xy0 = xy1;
    gwy_serializable_boxed_assign(GWY_TYPE_XY, &xy3, &xy1);
    g_assert_cmpfloat(xy1.x, ==, xy0.x);
    g_assert_cmpfloat(xy1.y, ==, xy0.y);
    g_assert_cmpfloat(xy3.x, ==, xy1.x);
    g_assert_cmpfloat(xy3.y, ==, xy1.y);

    xy0 = xy2;
    gwy_serializable_boxed_assign(GWY_TYPE_XY, &xy3, &xy2);
    g_assert_cmpfloat(xy2.x, ==, xy0.x);
    g_assert_cmpfloat(xy2.y, ==, xy0.y);
    g_assert_cmpfloat(xy3.x, ==, xy2.x);
    g_assert_cmpfloat(xy3.y, ==, xy2.y);
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
