/*
 * Copyright (C) 2024-2025, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Yunhe Liu <liuyunhe@kylinos.cn>
 *
 */
/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifndef __LIBSYNCCONFIG_H__
#define __LIBSYNCCONFIG_H__

#include <gio/gio.h>

G_BEGIN_DECLS


/* ------------------------------------------------------------------------ */
/* Declarations for com.kylin.kysdk.SyncConfig */

#define SYNC_CONFIG_TYPE_ (sync_config__get_type ())
#define SYNC_CONFIG_(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), SYNC_CONFIG_TYPE_, SyncConfig))
#define SYNC_CONFIG_IS_(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), SYNC_CONFIG_TYPE_))
#define SYNC_CONFIG__GET_IFACE(o) (G_TYPE_INSTANCE_GET_INTERFACE ((o), SYNC_CONFIG_TYPE_, SyncConfigIface))

struct _SyncConfig;
typedef struct _SyncConfig SyncConfig;
typedef struct _SyncConfigIface SyncConfigIface;

struct _SyncConfigIface
{
  GTypeInterface parent_iface;


  gboolean (*handle_register_schema) (
    SyncConfig *object,
    GDBusMethodInvocation *invocation,
    const gchar *arg_Conf2Id,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath);

  gboolean (*handle_unregister_schema) (
    SyncConfig *object,
    GDBusMethodInvocation *invocation,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath);

  void (*state) (
    SyncConfig *object,
    gint arg_state);

};

GType sync_config__get_type (void) G_GNUC_CONST;

GDBusInterfaceInfo *sync_config__interface_info (void);
guint sync_config__override_properties (GObjectClass *klass, guint property_id_begin);


/* D-Bus method call completion functions: */
void sync_config__complete_register_schema (
    SyncConfig *object,
    GDBusMethodInvocation *invocation,
    gboolean ArgOut);

void sync_config__complete_unregister_schema (
    SyncConfig *object,
    GDBusMethodInvocation *invocation,
    gboolean ArgOut);



/* D-Bus signal emissions functions: */
void sync_config__emit_state (
    SyncConfig *object,
    gint arg_state);



/* D-Bus method calls: */
void sync_config__call_register_schema (
    SyncConfig *proxy,
    const gchar *arg_Conf2Id,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

gboolean sync_config__call_register_schema_finish (
    SyncConfig *proxy,
    gboolean *out_ArgOut,
    GAsyncResult *res,
    GError **error);

gboolean sync_config__call_register_schema_sync (
    SyncConfig *proxy,
    const gchar *arg_Conf2Id,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    gboolean *out_ArgOut,
    GCancellable *cancellable,
    GError **error);

void sync_config__call_unregister_schema (
    SyncConfig *proxy,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

gboolean sync_config__call_unregister_schema_finish (
    SyncConfig *proxy,
    gboolean *out_ArgOut,
    GAsyncResult *res,
    GError **error);

gboolean sync_config__call_unregister_schema_sync (
    SyncConfig *proxy,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    gboolean *out_ArgOut,
    GCancellable *cancellable,
    GError **error);



/* ---- */

#define SYNC_CONFIG_TYPE__PROXY (sync_config__proxy_get_type ())
#define SYNC_CONFIG__PROXY(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), SYNC_CONFIG_TYPE__PROXY, SyncConfigProxy))
#define SYNC_CONFIG__PROXY_CLASS(k) (G_TYPE_CHECK_CLASS_CAST ((k), SYNC_CONFIG_TYPE__PROXY, SyncConfigProxyClass))
#define SYNC_CONFIG__PROXY_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), SYNC_CONFIG_TYPE__PROXY, SyncConfigProxyClass))
#define SYNC_CONFIG_IS__PROXY(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), SYNC_CONFIG_TYPE__PROXY))
#define SYNC_CONFIG_IS__PROXY_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k), SYNC_CONFIG_TYPE__PROXY))

typedef struct _SyncConfigProxy SyncConfigProxy;
typedef struct _SyncConfigProxyClass SyncConfigProxyClass;
typedef struct _SyncConfigProxyPrivate SyncConfigProxyPrivate;

struct _SyncConfigProxy
{
  /*< private >*/
  GDBusProxy parent_instance;
  SyncConfigProxyPrivate *priv;
};

struct _SyncConfigProxyClass
{
  GDBusProxyClass parent_class;
};

GType sync_config__proxy_get_type (void) G_GNUC_CONST;

#if GLIB_CHECK_VERSION(2, 44, 0)
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SyncConfigProxy, g_object_unref)
#endif

void sync_config__proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data);
SyncConfig *sync_config__proxy_new_finish (
    GAsyncResult        *res,
    GError             **error);
SyncConfig *sync_config__proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error);

void sync_config__proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data);
SyncConfig *sync_config__proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error);
SyncConfig *sync_config__proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error);


/* ---- */

#define SYNC_CONFIG_TYPE__SKELETON (sync_config__skeleton_get_type ())
#define SYNC_CONFIG__SKELETON(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), SYNC_CONFIG_TYPE__SKELETON, SyncConfigSkeleton))
#define SYNC_CONFIG__SKELETON_CLASS(k) (G_TYPE_CHECK_CLASS_CAST ((k), SYNC_CONFIG_TYPE__SKELETON, SyncConfigSkeletonClass))
#define SYNC_CONFIG__SKELETON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), SYNC_CONFIG_TYPE__SKELETON, SyncConfigSkeletonClass))
#define SYNC_CONFIG_IS__SKELETON(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), SYNC_CONFIG_TYPE__SKELETON))
#define SYNC_CONFIG_IS__SKELETON_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k), SYNC_CONFIG_TYPE__SKELETON))

typedef struct _SyncConfigSkeleton SyncConfigSkeleton;
typedef struct _SyncConfigSkeletonClass SyncConfigSkeletonClass;
typedef struct _SyncConfigSkeletonPrivate SyncConfigSkeletonPrivate;

struct _SyncConfigSkeleton
{
  /*< private >*/
  GDBusInterfaceSkeleton parent_instance;
  SyncConfigSkeletonPrivate *priv;
};

struct _SyncConfigSkeletonClass
{
  GDBusInterfaceSkeletonClass parent_class;
};

GType sync_config__skeleton_get_type (void) G_GNUC_CONST;

#if GLIB_CHECK_VERSION(2, 44, 0)
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SyncConfigSkeleton, g_object_unref)
#endif

SyncConfig *sync_config__skeleton_new (void);


G_END_DECLS

#endif /* __LIBSYNCCONFIG_H__ */
