// license:BSD-3-Clause
// copyright-holders:David Haywood

#include "emu.h"
#include "arcompact_helper.ipp"

// #######################################################################################################################
//                                 IIII ISS
// LD_S r0,[gp,s11]                1100 100s ssss ssss
// #######################################################################################################################

uint32_t arcompact_device::handleop_LD_S_r0_gp_s11(uint16_t op)
{
	uint32_t s = common16_get_s9(op);
	m_regs[0] = READ32(m_regs[REG_GP] + (s << 2));
	return m_pc + 2;
}

// #######################################################################################################################
//                                 IIII ISS
// LDB_S r0,[gp,s9]                1100 101s ssss ssss
// #######################################################################################################################

uint32_t arcompact_device::handleop_LDB_S_r0_gp_s9(uint16_t op)
{
	uint32_t s = common16_get_s9(op);
	m_regs[0] = READ8(m_regs[REG_GP] + s);
	return m_pc + 2;
}

// #######################################################################################################################
//                                 IIII ISS
// LDW_S r0,[gp,s10]               1100 110s ssss ssss
// #######################################################################################################################

uint32_t arcompact_device::handleop_LDW_S_r0_gp_s10(uint16_t op)
{
	uint32_t s = common16_get_s9(op);
	m_regs[0] = READ16(m_regs[REG_GP] + (s << 1));
	return m_pc + 2;
}

// #######################################################################################################################
//                                 IIII ISS
// ADD_S r0,gp,s11                 1100 111s ssss ssss
// #######################################################################################################################

uint32_t arcompact_device::handleop_ADD_S_r0_gp_s11(uint16_t op)
{
	uint32_t s = common16_get_s9(op);
	m_regs[0] = m_regs[REG_GP] + (s << 2);
	return m_pc + 2;
}
