--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
INCLUDE PERFETTO MODULE wattson.curves.tg5_cpu_1d;

-- Device specific device curves with 1D dependency (i.e. curve characteristics
-- are dependent only on one CPU policy). See go/wattson for more info.
CREATE PERFETTO TABLE _device_curves_1d AS
WITH
  data(device, policy, freq_khz, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("monaco", 0, 614400, 4.8, 9.41, 0.76, 0),
      ("monaco", 0, 864000, 6.68, 13.64, 0.83, 0),
      ("monaco", 0, 1363200, 12.6, 24.83, 1.1, 0),
      ("monaco", 0, 1708800, 18.39, 39.69, 1.34, 0),
      ("MT6897", 4, 400000, 0, 29.25, 11.23, 0),
      ("MT6897", 4, 500000, 0, 39.06, 11.84, 0),
      ("MT6897", 4, 600000, 0, 49.47, 11.9, 0),
      ("MT6897", 4, 700000, 0, 65.82, 12.1, 0),
      ("MT6897", 4, 800000, 0, 74.15, 12.6, 0),
      ("MT6897", 4, 900000, 0, 87.02, 13.38, 0),
      ("MT6897", 4, 1000000, 0, 100.83, 14.52, 0),
      ("MT6897", 4, 1100000, 0, 100.05, 15.82, 0),
      ("MT6897", 4, 1200000, 0, 121.01, 18.25, 0),
      ("MT6897", 4, 1300000, 0, 150.09, 18.3, 0),
      ("MT6897", 4, 1400000, 0, 223.43, 19.5, 0),
      ("MT6897", 4, 1500000, 0, 199.07, 20.75, 0),
      ("MT6897", 4, 1600000, 0, 209.55, 21.62, 0),
      ("MT6897", 4, 1700000, 0, 295.03, 21.22, 0),
      ("MT6897", 4, 1800000, 0, 319.53, 20.61, 0),
      ("MT6897", 4, 1900000, 0, 360.2, 22.04, 0),
      ("MT6897", 4, 2000000, 0, 384.4, 21.22, 0),
      ("MT6897", 4, 2100000, 0, 457.82, 21.22, 0),
      ("MT6897", 4, 2200000, 0, 500.01, 21.57, 0),
      ("MT6897", 4, 2300000, 0, 600.3, 21.97, 0),
      ("MT6897", 4, 2400000, 0, 670.14, 20.7, 0),
      ("MT6897", 4, 2500000, 0, 713.7, 20.65, 0),
      ("MT6897", 4, 2600000, 0, 725.46, 20.9, 0),
      ("MT6897", 4, 2660000, 0, 730.67, 20.99, 0),
      ("MT6897", 4, 2800000, 0, 732.42, 21.99, 0),
      ("MT6897", 4, 2850000, 0, 680.9, 21.88, 0),
      ("MT6897", 4, 2900000, 0, 699.43, 22.59, 0),
      ("MT6897", 4, 3000000, 0, 770.16, 22.53, 0),
      ("MT6897", 4, 3100000, 0, 773.6, 23.32, 0),
      ("MT6897", 4, 3200000, 0, 834.88, 24.71, 0),
      ("MT6897", 7, 400000, 0, 101.36, 20.52, 0),
      ("MT6897", 7, 500000, 0, 106.28, 22.58, 0),
      ("MT6897", 7, 600000, 0, 109.04, 26.36, 0),
      ("MT6897", 7, 700000, 0, 122.6, 25.42, 0),
      ("MT6897", 7, 800000, 0, 173.25, 24.19, 0),
      ("MT6897", 7, 900000, 0, 153.15, 25.09, 0),
      ("MT6897", 7, 1000000, 0, 173.16, 25.39, 0),
      ("MT6897", 7, 1100000, 0, 199.87, 26.86, 0),
      ("MT6897", 7, 1200000, 0, 217.21, 28.56, 0),
      ("MT6897", 7, 1300000, 0, 231.8, 30.59, 0),
      ("MT6897", 7, 1400000, 0, 233.98, 30.16, 0),
      ("MT6897", 7, 1500000, 0, 271.58, 31.78, 0),
      ("MT6897", 7, 1600000, 0, 278.6, 32.65, 0),
      ("MT6897", 7, 1700000, 0, 323.91, 29.51, 0),
      ("MT6897", 7, 1800000, 0, 376.93, 30.7, 0),
      ("MT6897", 7, 1900000, 0, 420.25, 30.07, 0),
      ("MT6897", 7, 2000000, 0, 487.31, 29.89, 0),
      ("MT6897", 7, 2100000, 0, 571.85, 28.68, 0),
      ("MT6897", 7, 2200000, 0, 500.23, 30.0, 0),
      ("MT6897", 7, 2300000, 0, 623.76, 30.82, 0),
      ("MT6897", 7, 2400000, 0, 628.35, 31.01, 0),
      ("MT6897", 7, 2500000, 0, 757.08, 30.8, 0),
      ("MT6897", 7, 2600000, 0, 844.37, 31.21, 0),
      ("MT6897", 7, 2700000, 0, 1172.63, 30.59, 0),
      ("MT6897", 7, 2800000, 0, 1155.18, 29.72, 0),
      ("MT6897", 7, 2900000, 0, 1349.02, 34.16, 0),
      ("MT6897", 7, 3000000, 0, 1350.29, 32.44, 0),
      ("MT6897", 7, 3050000, 0, 1290.29, 30.12, 0),
      ("MT6897", 7, 3100000, 0, 1200.61, 31.2, 0),
      ("MT6897", 7, 3200000, 0, 1244.75, 32.06, 0),
      ("MT6897", 7, 3350000, 0, 1300.78, 36.92, 0),
      ("neo", 0, 691200, 3.1, 19.54, 0.61, 0),
      ("neo", 0, 940800, 4.33, 26.65, 0.79, 0),
      ("neo", 0, 1113600, 5.65, 32.33, 0.99, 0),
      ("neo", 0, 1497600, 7.19, 45.89, 1.51, 0),
      ("neo", 0, 1804800, 11.7, 99.98, 2.22, 0),
      ("neo", 0, 1996800, 12.5, 101.04, 2.62, 0),
      ("SXR2230P", 2, 691200, 3.76, 65.57, 3.98, 0),
      ("SXR2230P", 2, 960000, 5.44, 98.39, 4.11, 0),
      ("SXR2230P", 2, 1094400, 6.05, 115.23, 4.79, 0),
      ("SXR2230P", 2, 1228800, 6.35, 134.18, 5.24, 0),
      ("SXR2230P", 2, 1382400, 8.54, 157.71, 5.15, 0),
      ("SXR2230P", 2, 1516800, 9.25, 184.53, 5.85, 0),
      ("SXR2230P", 2, 1651200, 10.4, 212.52, 6.91, 0),
      ("SXR2230P", 2, 1920000, 13.83, 341.62, 11.75, 0),
      ("SXR2230P", 2, 2054400, 17.58, 392.53, 12.91, 0),
      ("SXR2230P", 2, 2208000, 20.74, 447.06, 16.72, 0),
      ("SXR2230P", 2, 2361600, 23.88, 529.69, 22.69, 0),
      ("Tensor", 4, 400000, 0, 28.51, 5.24, 0),
      ("Tensor", 4, 553000, 0, 43.63, 6.1, 0),
      ("Tensor", 4, 696000, 0, 54.73, 6.76, 0),
      ("Tensor", 4, 799000, 0, 65.01, 6.89, 0),
      ("Tensor", 4, 910000, 0, 80.33, 7.61, 0),
      ("Tensor", 4, 1024000, 0, 92.91, 8.32, 0),
      ("Tensor", 4, 1197000, 0, 132.46, 8.09, 0),
      ("Tensor", 4, 1328000, 0, 146.82, 9.6, 0),
      ("Tensor", 4, 1491000, 0, 183.2, 11.58, 0),
      ("Tensor", 4, 1663000, 0, 238.55, 12.02, 0),
      ("Tensor", 4, 1836000, 0, 259.04, 16.11, 0),
      ("Tensor", 4, 1999000, 0, 361.98, 15.7, 0),
      ("Tensor", 4, 2130000, 0, 428.51, 18.94, 0),
      ("Tensor", 4, 2253000, 0, 527.05, 23.5, 0),
      ("Tensor", 6, 500000, 0, 87.31, 16.14, 0),
      ("Tensor", 6, 851000, 0, 170.29, 19.88, 0),
      ("Tensor", 6, 984000, 0, 207.43, 20.55, 0),
      ("Tensor", 6, 1106000, 0, 251.88, 23.06, 0),
      ("Tensor", 6, 1277000, 0, 306.57, 25.12, 0),
      ("Tensor", 6, 1426000, 0, 382.61, 26.76, 0),
      ("Tensor", 6, 1582000, 0, 465.9, 29.74, 0),
      ("Tensor", 6, 1745000, 0, 556.25, 32.87, 0),
      ("Tensor", 6, 1826000, 0, 613.51, 36.01, 0),
      ("Tensor", 6, 2048000, 0, 758.89, 41.67, 0),
      ("Tensor", 6, 2188000, 0, 874.03, 47.92, 0),
      ("Tensor", 6, 2252000, 0, 949.55, 51.07, 0),
      ("Tensor", 6, 2401000, 0, 1099.53, 57.42, 0),
      ("Tensor", 6, 2507000, 0, 1267.19, 66.14, 0),
      ("Tensor", 6, 2630000, 0, 1500.6, 82.36, 0),
      ("Tensor", 6, 2704000, 0, 1660.81, 95.11, 0),
      ("Tensor", 6, 2802000, 0, 1942.89, 121.43, 0),
      ("Tensor G4", 4, 357000, 0, 39.49, 6.1, 0),
      ("Tensor G4", 4, 578000, 0, 62.09, 6.5, 0),
      ("Tensor G4", 4, 648000, 0, 70.05, 6.93, 0),
      ("Tensor G4", 4, 787000, 0, 83.26, 7.31, 0),
      ("Tensor G4", 4, 910000, 0, 97.12, 7.55, 0),
      ("Tensor G4", 4, 1065000, 0, 116.15, 7.9, 0),
      ("Tensor G4", 4, 1221000, 0, 138.37, 8.47, 0),
      ("Tensor G4", 4, 1328000, 0, 155.59, 8.94, 0),
      ("Tensor G4", 4, 1418000, 0, 172.52, 9.37, 0),
      ("Tensor G4", 4, 1549000, 0, 200.69, 10.21, 0),
      ("Tensor G4", 4, 1795000, 0, 267.18, 11.89, 0),
      ("Tensor G4", 4, 1945000, 0, 317.06, 13.58, 0),
      ("Tensor G4", 4, 2130000, 0, 388.15, 16.02, 0),
      ("Tensor G4", 4, 2245000, 0, 430.4, 17.54, 0),
      ("Tensor G4", 4, 2367000, 0, 504.35, 20.92, 0),
      ("Tensor G4", 4, 2450000, 0, 579.03, 23.39, 0),
      ("Tensor G4", 4, 2600000, 0, 674.24, 31.07, 0),
      ("Tensor G4", 7, 700000, 0, 211.41, 17.97, 0),
      ("Tensor G4", 7, 1164000, 0, 375.49, 20.24, 0),
      ("Tensor G4", 7, 1396000, 0, 491.17, 22.35, 0),
      ("Tensor G4", 7, 1557000, 0, 589.06, 24.29, 0),
      ("Tensor G4", 7, 1745000, 0, 742.95, 26.79, 0),
      ("Tensor G4", 7, 1885000, 0, 862.73, 28.61, 0),
      ("Tensor G4", 7, 1999000, 0, 965.94, 30.04, 0),
      ("Tensor G4", 7, 2147000, 0, 1136.58, 32.65, 0),
      ("Tensor G4", 7, 2294000, 0, 1309.39, 35.62, 0),
      ("Tensor G4", 7, 2363000, 0, 1415.82, 37.93, 0),
      ("Tensor G4", 7, 2499000, 0, 1669.61, 42.96, 0),
      ("Tensor G4", 7, 2687000, 0, 2052.32, 52.16, 0),
      ("Tensor G4", 7, 2802000, 0, 2354.18, 60.2, 0),
      ("Tensor G4", 7, 2914000, 0, 2789.17, 77.16, 0),
      ("Tensor G4", 7, 2943000, 0, 2840.06, 79.64, 0),
      ("Tensor G4", 7, 2970000, 0, 2949.03, 84.78, 0),
      ("Tensor G4", 7, 3015000, 0, 3029.38, 87.22, 0),
      ("Tensor G4", 7, 3105000, 0, 3327.56, 99.47, 0)) AS _values
  )
SELECT
  *
FROM data
UNION ALL
SELECT
  *
FROM _tg5_1d_lut;
