# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice.aio import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceLoadBalancersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_load_balancers_list_by_managed_cluster(self, resource_group):
        response = self.client.load_balancers.list_by_managed_cluster(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2025-10-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_load_balancers_get(self, resource_group):
        response = await self.client.load_balancers.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            load_balancer_name="str",
            api_version="2025-10-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_load_balancers_create_or_update(self, resource_group):
        response = await self.client.load_balancers.create_or_update(
            resource_group_name=resource_group.name,
            resource_name="str",
            load_balancer_name="str",
            parameters={
                "allowServicePlacement": bool,
                "id": "str",
                "name": "str",
                "nodeSelector": {
                    "matchExpressions": [{"key": "str", "operator": "str", "values": ["str"]}],
                    "matchLabels": ["str"],
                },
                "primaryAgentPoolName": "str",
                "provisioningState": "str",
                "serviceLabelSelector": {
                    "matchExpressions": [{"key": "str", "operator": "str", "values": ["str"]}],
                    "matchLabels": ["str"],
                },
                "serviceNamespaceSelector": {
                    "matchExpressions": [{"key": "str", "operator": "str", "values": ["str"]}],
                    "matchLabels": ["str"],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-10-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_load_balancers_begin_delete(self, resource_group):
        response = await (
            await self.client.load_balancers.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                load_balancer_name="str",
                api_version="2025-10-02-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
