% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{CFfactor_units}
\alias{CFfactor_units}
\title{Number of base time units in each factor level}
\usage{
CFfactor_units(t, f)
}
\arguments{
\item{t}{An instance of \code{CFTime}.}

\item{f}{A factor or a list of factors derived from the
parameter \code{t}. The factor or list thereof should generally be generated by
the function \code{\link[=CFfactor]{CFfactor()}}.}
}
\value{
If \code{f} is a factor, a numeric vector with a length equal to the
number of levels in the factor, indicating the number of time units in each
level of the factor. If \code{f} is a list of factors, a list with each element
a numeric vector as above.
}
\description{
Given a factor as returned by \code{\link[=CFfactor]{CFfactor()}} and the \link{CFTime} instance from
which the factor was derived, this function will return a numeric vector with
the number of time units in each level of the factor.
}
\details{
The result of this function is useful to convert between absolute and
relative values. Climate change anomalies, for instance, are usually computed
by differencing average values between a future period and a baseline period.
Going from average values back to absolute values for an aggregate period
(which is typical for temperature and precipitation, among other variables)
is easily done with the result of this function, without having to consider
the specifics of the calendar of the data set.

If the factor \code{f} is for an era (e.g. spanning multiple years and the
levels do not indicate the specific year), then the result will indicate the
number of time units of the period in a regular single year. In other words,
for an era of 2041-2060 and a monthly factor on a standard calendar with a
\code{days} unit, the result will be \code{c(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31)}.
Leap days are thus only considered for the \verb{366_day} and \code{all_leap} calendars.

Note that this function gives the number of time units in each level of the
factor - the actual number of data points in the \code{cf} instance per factor
level may be different. Use \code{\link[=CFfactor_coverage]{CFfactor_coverage()}} to determine the actual
number of data points or the coverage of data points relative to the factor
level.
}
\examples{
t <- CFtime("days since 2001-01-01", "365_day", 0:364)
f <- CFfactor(t, "dekad")
CFfactor_units(t, f)
}
