% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{decimal_dot}
\alias{decimal_dot}
\title{Evaluate an expression after forcing the decimal point to be a dot}
\usage{
decimal_dot(x)
}
\arguments{
\item{x}{An expression.}
}
\value{
The value of \code{x}.
}
\description{
Sometimes it is necessary to use the dot character as the decimal separator.
In R, this could be affected by two settings: the global option
\code{options(OutDec)} and the \code{LC_NUMERIC} locale. This function sets the former
to \code{.} and the latter to \code{C} before evaluating an expression, such as
coercing a number to character.
}
\examples{
opts = options(OutDec = ",")
as.character(1.234)  # using ',' as the decimal separator
print(1.234)  # same
xfun::decimal_dot(as.character(1.234))  # using dot
xfun::decimal_dot(print(1.234))  # using dot
options(opts)
}
