// Copyright 2025 the Fearless_SIMD Authors
// SPDX-License-Identifier: Apache-2.0 OR MIT

// This file is autogenerated by fearless_simd_gen

#![expect(
    unused_variables,
    clippy::todo,
    reason = "TODO: https://github.com/linebender/fearless_simd/issues/40"
)]
use crate::{Level, Simd, SimdFrom, SimdInto, seal::Seal};
use crate::{
    f32x4, f32x8, f32x16, f64x2, f64x4, f64x8, i8x16, i8x32, i8x64, i16x8, i16x16, i16x32, i32x4,
    i32x8, i32x16, mask8x16, mask8x32, mask8x64, mask16x8, mask16x16, mask16x32, mask32x4,
    mask32x8, mask32x16, mask64x2, mask64x4, mask64x8, u8x16, u8x32, u8x64, u16x8, u16x16, u16x32,
    u32x4, u32x8, u32x16,
};
#[cfg(target_arch = "x86")]
use core::arch::x86::*;
#[cfg(target_arch = "x86_64")]
use core::arch::x86_64::*;
use core::ops::*;
#[doc = r#" The SIMD token for the "SSE 4.2" level."#]
#[derive(Clone, Copy, Debug)]
pub struct Sse4_2 {
    pub sse4_2: crate::core_arch::x86::Sse4_2,
}
impl Sse4_2 {
    #[doc = r" Create a SIMD token."]
    #[doc = r""]
    #[doc = r" # Safety"]
    #[doc = r""]
    #[doc = r" The SSE4.2 CPU feature must be available."]
    #[inline]
    pub const unsafe fn new_unchecked() -> Self {
        Sse4_2 {
            sse4_2: unsafe { crate::core_arch::x86::Sse4_2::new_unchecked() },
        }
    }
}
impl Seal for Sse4_2 {}
impl Simd for Sse4_2 {
    type f32s = f32x4<Self>;
    type u8s = u8x16<Self>;
    type i8s = i8x16<Self>;
    type u16s = u16x8<Self>;
    type i16s = i16x8<Self>;
    type u32s = u32x4<Self>;
    type i32s = i32x4<Self>;
    type mask8s = mask8x16<Self>;
    type mask16s = mask16x8<Self>;
    type mask32s = mask32x4<Self>;
    #[inline(always)]
    fn level(self) -> Level {
        Level::Sse4_2(self)
    }
    #[inline]
    fn vectorize<F: FnOnce() -> R, R>(self, f: F) -> R {
        #[target_feature(enable = "sse4.2")]
        #[inline]
        unsafe fn vectorize_sse4_2<F: FnOnce() -> R, R>(f: F) -> R {
            f()
        }
        unsafe { vectorize_sse4_2(f) }
    }
    #[inline(always)]
    fn splat_f32x4(self, val: f32) -> f32x4<Self> {
        unsafe { _mm_set1_ps(val).simd_into(self) }
    }
    #[inline(always)]
    fn abs_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_andnot_ps(_mm_set1_ps(-0.0), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn neg_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_xor_ps(a.into(), _mm_set1_ps(-0.0)).simd_into(self) }
    }
    #[inline(always)]
    fn sqrt_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_sqrt_ps(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_add_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_sub_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_mul_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn div_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_div_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn copysign_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe {
            let mask = _mm_set1_ps(-0.0);
            _mm_or_ps(_mm_and_ps(mask, b.into()), _mm_andnot_ps(mask, a.into())).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_castps_si128(_mm_cmpeq_ps(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_castps_si128(_mm_cmplt_ps(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_castps_si128(_mm_cmple_ps(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_castps_si128(_mm_cmpge_ps(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_castps_si128(_mm_cmpgt_ps(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_unpacklo_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_unpackhi_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_shuffle_ps::<0b10_00_10_00>(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_shuffle_ps::<0b11_01_11_01>(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_max_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_max_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_min_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_precise_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_min_ps(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn madd_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        a * b + c
    }
    #[inline(always)]
    fn msub_f32x4(self, a: f32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        a * b - c
    }
    #[inline(always)]
    fn floor_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_floor_ps(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn fract_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        a - a.trunc()
    }
    #[inline(always)]
    fn trunc_f32x4(self, a: f32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_round_ps(a.into(), _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC).simd_into(self) }
    }
    #[inline(always)]
    fn select_f32x4(self, a: mask32x4<Self>, b: f32x4<Self>, c: f32x4<Self>) -> f32x4<Self> {
        unsafe {
            let mask = _mm_castsi128_ps(a.into());
            _mm_or_ps(_mm_and_ps(mask, b.into()), _mm_andnot_ps(mask, c.into())).simd_into(self)
        }
    }
    #[inline(always)]
    fn combine_f32x4(self, a: f32x4<Self>, b: f32x4<Self>) -> f32x8<Self> {
        let mut result = [0.0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_f64_f32x4(self, a: f32x4<Self>) -> f64x2<Self> {
        f64x2 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self> {
        i32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_u8_f32x4(self, a: f32x4<Self>) -> u8x16<Self> {
        u8x16 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self> {
        u32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn cvt_u32_f32x4(self, a: f32x4<Self>) -> u32x4<Self> {
        unsafe {
            _mm_cvtps_epi32(_mm_max_ps(_mm_floor_ps(a.into()), _mm_set1_ps(0.0))).simd_into(self)
        }
    }
    #[inline(always)]
    fn cvt_i32_f32x4(self, a: f32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_cvtps_epi32(a.trunc().into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_i8x16(self, val: i8) -> i8x16<Self> {
        unsafe { _mm_set1_epi8(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_i8x16(self, a: i8x16<Self>) -> i8x16<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn add_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_add_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_sub_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        todo!()
    }
    #[inline(always)]
    fn and_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self> {
        unsafe {
            let val = a.into();
            let shift_count = _mm_cvtsi32_si128(shift as i32);
            let lo_16 = _mm_unpacklo_epi8(val, _mm_cmplt_epi8(val, _mm_setzero_si128()));
            let hi_16 = _mm_unpackhi_epi8(val, _mm_cmplt_epi8(val, _mm_setzero_si128()));
            let lo_shifted = _mm_sra_epi16(lo_16, shift_count);
            let hi_shifted = _mm_sra_epi16(hi_16, shift_count);
            _mm_packs_epi16(lo_shifted, hi_shifted).simd_into(self)
        }
    }
    #[inline(always)]
    fn shrv_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_i8x16(self, a: i8x16<Self>, shift: u32) -> i8x16<Self> {
        unsafe {
            let val = a.into();
            let shift_count = _mm_cvtsi32_si128(shift as i32);
            let lo_16 = _mm_unpacklo_epi8(val, _mm_cmplt_epi8(val, _mm_setzero_si128()));
            let hi_16 = _mm_unpackhi_epi8(val, _mm_cmplt_epi8(val, _mm_setzero_si128()));
            let lo_shifted = _mm_sll_epi16(lo_16, shift_count);
            let hi_shifted = _mm_sll_epi16(hi_16, shift_count);
            _mm_packs_epi16(lo_shifted, hi_shifted).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpeq_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmplt_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpeq_epi8(_mm_min_epi8(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpeq_epi8(_mm_max_epi8(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpgt_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_unpacklo_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_unpackhi_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe {
            let mask = _mm_setr_epi8(0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn unzip_high_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe {
            let mask = _mm_setr_epi8(1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn select_i8x16(self, a: mask8x16<Self>, b: i8x16<Self>, c: i8x16<Self>) -> i8x16<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn min_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_min_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_max_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_i8x16(self, a: i8x16<Self>, b: i8x16<Self>) -> i8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i8x16(self, a: i8x16<Self>) -> i8x16<Self> {
        unsafe { _mm_sub_epi8(_mm_setzero_si128(), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_i8x16(self, a: i8x16<Self>) -> u8x16<Self> {
        u8x16 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_u32_i8x16(self, a: i8x16<Self>) -> u32x4<Self> {
        u32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn splat_u8x16(self, val: u8) -> u8x16<Self> {
        unsafe { _mm_set1_epi8(val as _).simd_into(self) }
    }
    #[inline(always)]
    fn not_u8x16(self, a: u8x16<Self>) -> u8x16<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn add_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_add_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_sub_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        todo!()
    }
    #[inline(always)]
    fn and_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self> {
        unsafe {
            let val = a.into();
            let shift_count = _mm_cvtsi32_si128(shift as i32);
            let lo_16 = _mm_unpacklo_epi8(val, _mm_setzero_si128());
            let hi_16 = _mm_unpackhi_epi8(val, _mm_setzero_si128());
            let lo_shifted = _mm_srl_epi16(lo_16, shift_count);
            let hi_shifted = _mm_srl_epi16(hi_16, shift_count);
            _mm_packus_epi16(lo_shifted, hi_shifted).simd_into(self)
        }
    }
    #[inline(always)]
    fn shrv_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_u8x16(self, a: u8x16<Self>, shift: u32) -> u8x16<Self> {
        unsafe {
            let val = a.into();
            let shift_count = _mm_cvtsi32_si128(shift as i32);
            let lo_16 = _mm_unpacklo_epi8(val, _mm_setzero_si128());
            let hi_16 = _mm_unpackhi_epi8(val, _mm_setzero_si128());
            let lo_shifted = _mm_sll_epi16(lo_16, shift_count);
            let hi_shifted = _mm_sll_epi16(hi_16, shift_count);
            _mm_packus_epi16(lo_shifted, hi_shifted).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi8(0x80u8 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi8(a_signed, b_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_lt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi8(0x80u8 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi8(b_signed, a_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_le_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpeq_epi8(_mm_min_epu8(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpeq_epi8(_mm_max_epu8(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> mask8x16<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi8(0x80u8 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi8(a_signed, b_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn zip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_unpacklo_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_unpackhi_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe {
            let mask = _mm_setr_epi8(0, 2, 4, 6, 8, 10, 12, 14, 0, 2, 4, 6, 8, 10, 12, 14);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn unzip_high_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe {
            let mask = _mm_setr_epi8(1, 3, 5, 7, 9, 11, 13, 15, 1, 3, 5, 7, 9, 11, 13, 15);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn select_u8x16(self, a: mask8x16<Self>, b: u8x16<Self>, c: u8x16<Self>) -> u8x16<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn min_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_min_epu8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x16<Self> {
        unsafe { _mm_max_epu8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_u8x16(self, a: u8x16<Self>, b: u8x16<Self>) -> u8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn widen_u8x16(self, a: u8x16<Self>) -> u16x16<Self> {
        unsafe {
            let raw = a.into();
            let high = _mm_cvtepu8_epi16(raw).simd_into(self);
            let low = _mm_cvtepu8_epi16(_mm_srli_si128::<8>(raw)).simd_into(self);
            self.combine_u16x8(high, low)
        }
    }
    #[inline(always)]
    fn reinterpret_u32_u8x16(self, a: u8x16<Self>) -> u32x4<Self> {
        u32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn splat_mask8x16(self, val: i8) -> mask8x16<Self> {
        unsafe { _mm_set1_epi8(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask8x16(self, a: mask8x16<Self>) -> mask8x16<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn and_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask8x16(
        self,
        a: mask8x16<Self>,
        b: mask8x16<Self>,
        c: mask8x16<Self>,
    ) -> mask8x16<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x16<Self> {
        unsafe { _mm_cmpeq_epi8(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask8x16(self, a: mask8x16<Self>, b: mask8x16<Self>) -> mask8x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_i16x8(self, val: i16) -> i16x8<Self> {
        unsafe { _mm_set1_epi16(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_i16x8(self, a: i16x8<Self>) -> i16x8<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn add_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_add_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_sub_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_mullo_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self> {
        unsafe { _mm_sra_epi16(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_i16x8(self, a: i16x8<Self>, shift: u32) -> i16x8<Self> {
        unsafe { _mm_sll_epi16(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpeq_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmplt_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpeq_epi16(_mm_min_epi16(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpeq_epi16(_mm_max_epi16(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpgt_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_unpacklo_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_unpackhi_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe {
            let mask = _mm_setr_epi8(0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 4, 5, 8, 9, 12, 13);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn unzip_high_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe {
            let mask = _mm_setr_epi8(2, 3, 6, 7, 10, 11, 14, 15, 2, 3, 6, 7, 10, 11, 14, 15);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn select_i16x8(self, a: mask16x8<Self>, b: i16x8<Self>, c: i16x8<Self>) -> i16x8<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn min_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_min_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_max_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_i16x8(self, a: i16x8<Self>, b: i16x8<Self>) -> i16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i16x8(self, a: i16x8<Self>) -> i16x8<Self> {
        unsafe { _mm_sub_epi16(_mm_setzero_si128(), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_i16x8(self, a: i16x8<Self>) -> u8x16<Self> {
        u8x16 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_u32_i16x8(self, a: i16x8<Self>) -> u32x4<Self> {
        u32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn splat_u16x8(self, val: u16) -> u16x8<Self> {
        unsafe { _mm_set1_epi16(val as _).simd_into(self) }
    }
    #[inline(always)]
    fn not_u16x8(self, a: u16x8<Self>) -> u16x8<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn add_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_add_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_sub_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_mullo_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self> {
        unsafe { _mm_srl_epi16(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_u16x8(self, a: u16x8<Self>, shift: u32) -> u16x8<Self> {
        unsafe { _mm_sll_epi16(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi16(0x8000u16 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi16(a_signed, b_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_lt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi16(0x8000u16 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi16(b_signed, a_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_le_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpeq_epi16(_mm_min_epu16(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpeq_epi16(_mm_max_epu16(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> mask16x8<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi16(0x8000u16 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi16(a_signed, b_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn zip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_unpacklo_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_unpackhi_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe {
            let mask = _mm_setr_epi8(0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 4, 5, 8, 9, 12, 13);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn unzip_high_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe {
            let mask = _mm_setr_epi8(2, 3, 6, 7, 10, 11, 14, 15, 2, 3, 6, 7, 10, 11, 14, 15);
            let t1 = _mm_shuffle_epi8(a.into(), mask);
            let t2 = _mm_shuffle_epi8(b.into(), mask);
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn select_u16x8(self, a: mask16x8<Self>, b: u16x8<Self>, c: u16x8<Self>) -> u16x8<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn min_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_min_epu16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x8<Self> {
        unsafe { _mm_max_epu16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_u16x8(self, a: u16x8<Self>, b: u16x8<Self>) -> u16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u16x8(self, a: u16x8<Self>) -> u8x16<Self> {
        u8x16 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_u32_u16x8(self, a: u16x8<Self>) -> u32x4<Self> {
        u32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn splat_mask16x8(self, val: i16) -> mask16x8<Self> {
        unsafe { _mm_set1_epi16(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask16x8(self, a: mask16x8<Self>) -> mask16x8<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn and_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask16x8(
        self,
        a: mask16x8<Self>,
        b: mask16x8<Self>,
        c: mask16x8<Self>,
    ) -> mask16x8<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x8<Self> {
        unsafe { _mm_cmpeq_epi16(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask16x8(self, a: mask16x8<Self>, b: mask16x8<Self>) -> mask16x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_i32x4(self, val: i32) -> i32x4<Self> {
        unsafe { _mm_set1_epi32(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_i32x4(self, a: i32x4<Self>) -> i32x4<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn add_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_add_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_sub_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_mullo_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self> {
        unsafe { _mm_sra_epi32(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_i32x4(self, a: i32x4<Self>, shift: u32) -> i32x4<Self> {
        unsafe { _mm_sll_epi32(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpeq_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmplt_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpeq_epi32(_mm_min_epi32(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpeq_epi32(_mm_max_epi32(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpgt_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_unpacklo_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_unpackhi_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe {
            let t1 = _mm_shuffle_epi32::<0b11_01_10_00>(a.into());
            let t2 = _mm_shuffle_epi32::<0b11_01_10_00>(b.into());
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn unzip_high_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe {
            let t1 = _mm_shuffle_epi32::<0b11_01_10_00>(a.into());
            let t2 = _mm_shuffle_epi32::<0b11_01_10_00>(b.into());
            _mm_unpackhi_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn select_i32x4(self, a: mask32x4<Self>, b: i32x4<Self>, c: i32x4<Self>) -> i32x4<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn min_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_min_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_max_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_i32x4(self, a: i32x4<Self>, b: i32x4<Self>) -> i32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn neg_i32x4(self, a: i32x4<Self>) -> i32x4<Self> {
        unsafe { _mm_sub_epi32(_mm_setzero_si128(), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn reinterpret_u8_i32x4(self, a: i32x4<Self>) -> u8x16<Self> {
        u8x16 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn reinterpret_u32_i32x4(self, a: i32x4<Self>) -> u32x4<Self> {
        u32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn cvt_f32_i32x4(self, a: i32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_cvtepi32_ps(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_u32x4(self, val: u32) -> u32x4<Self> {
        unsafe { _mm_set1_epi32(val as _).simd_into(self) }
    }
    #[inline(always)]
    fn not_u32x4(self, a: u32x4<Self>) -> u32x4<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn add_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_add_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_sub_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_mullo_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn and_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn shr_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self> {
        unsafe { _mm_srl_epi32(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn shrv_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        core::array::from_fn(|i| core::ops::Shr::shr(a.val[i], b.val[i])).simd_into(self)
    }
    #[inline(always)]
    fn shl_u32x4(self, a: u32x4<Self>, shift: u32) -> u32x4<Self> {
        unsafe { _mm_sll_epi32(a.into(), _mm_cvtsi32_si128(shift as _)).simd_into(self) }
    }
    #[inline(always)]
    fn simd_eq_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi32(0x80000000u32 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi32(a_signed, b_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_lt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi32(0x80000000u32 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi32(b_signed, a_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_le_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpeq_epi32(_mm_min_epu32(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpeq_epi32(_mm_max_epu32(a.into(), b.into()), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> mask32x4<Self> {
        unsafe {
            let sign_bit = _mm_set1_epi32(0x80000000u32 as _);
            let a_signed = _mm_xor_si128(a.into(), sign_bit);
            let b_signed = _mm_xor_si128(b.into(), sign_bit);
            _mm_cmpgt_epi32(a_signed, b_signed).simd_into(self)
        }
    }
    #[inline(always)]
    fn zip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_unpacklo_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_unpackhi_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe {
            let t1 = _mm_shuffle_epi32::<0b11_01_10_00>(a.into());
            let t2 = _mm_shuffle_epi32::<0b11_01_10_00>(b.into());
            _mm_unpacklo_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn unzip_high_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe {
            let t1 = _mm_shuffle_epi32::<0b11_01_10_00>(a.into());
            let t2 = _mm_shuffle_epi32::<0b11_01_10_00>(b.into());
            _mm_unpackhi_epi64(t1, t2).simd_into(self)
        }
    }
    #[inline(always)]
    fn select_u32x4(self, a: mask32x4<Self>, b: u32x4<Self>, c: u32x4<Self>) -> u32x4<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn min_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_min_epu32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x4<Self> {
        unsafe { _mm_max_epu32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_u32x4(self, a: u32x4<Self>, b: u32x4<Self>) -> u32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_u8_u32x4(self, a: u32x4<Self>) -> u8x16<Self> {
        u8x16 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn cvt_f32_u32x4(self, a: u32x4<Self>) -> f32x4<Self> {
        unsafe { _mm_cvtepi32_ps(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn splat_mask32x4(self, val: i32) -> mask32x4<Self> {
        unsafe { _mm_set1_epi32(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask32x4(self, a: mask32x4<Self>) -> mask32x4<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn and_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask32x4(
        self,
        a: mask32x4<Self>,
        b: mask32x4<Self>,
        c: mask32x4<Self>,
    ) -> mask32x4<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x4<Self> {
        unsafe { _mm_cmpeq_epi32(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask32x4(self, a: mask32x4<Self>, b: mask32x4<Self>) -> mask32x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_f64x2(self, val: f64) -> f64x2<Self> {
        unsafe { _mm_set1_pd(val).simd_into(self) }
    }
    #[inline(always)]
    fn abs_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_andnot_pd(_mm_set1_pd(-0.0), a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn neg_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_xor_pd(a.into(), _mm_set1_pd(-0.0)).simd_into(self) }
    }
    #[inline(always)]
    fn sqrt_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_sqrt_pd(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn add_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_add_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn sub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_sub_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn mul_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_mul_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn div_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_div_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn copysign_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe {
            let mask = _mm_set1_pd(-0.0);
            _mm_or_pd(_mm_and_pd(mask, b.into()), _mm_andnot_pd(mask, a.into())).simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_castpd_si128(_mm_cmpeq_pd(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_lt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_castpd_si128(_mm_cmplt_pd(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_le_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_castpd_si128(_mm_cmple_pd(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_ge_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_castpd_si128(_mm_cmpge_pd(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn simd_gt_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_castpd_si128(_mm_cmpgt_pd(a.into(), b.into())).simd_into(self) }
    }
    #[inline(always)]
    fn zip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_unpacklo_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn zip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_unpackhi_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_low_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_shuffle_pd::<0b00>(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn unzip_high_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_shuffle_pd::<0b11>(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_max_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn max_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_max_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_min_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn min_precise_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_min_pd(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn madd_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        a * b + c
    }
    #[inline(always)]
    fn msub_f64x2(self, a: f64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        a * b - c
    }
    #[inline(always)]
    fn floor_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_floor_pd(a.into()).simd_into(self) }
    }
    #[inline(always)]
    fn fract_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        a - a.trunc()
    }
    #[inline(always)]
    fn trunc_f64x2(self, a: f64x2<Self>) -> f64x2<Self> {
        unsafe { _mm_round_pd(a.into(), _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC).simd_into(self) }
    }
    #[inline(always)]
    fn select_f64x2(self, a: mask64x2<Self>, b: f64x2<Self>, c: f64x2<Self>) -> f64x2<Self> {
        unsafe {
            let mask = _mm_castsi128_pd(a.into());
            _mm_or_pd(_mm_and_pd(mask, b.into()), _mm_andnot_pd(mask, c.into())).simd_into(self)
        }
    }
    #[inline(always)]
    fn combine_f64x2(self, a: f64x2<Self>, b: f64x2<Self>) -> f64x4<Self> {
        let mut result = [0.0; 4usize];
        result[0..2usize].copy_from_slice(&a.val);
        result[2usize..4usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn reinterpret_f32_f64x2(self, a: f64x2<Self>) -> f32x4<Self> {
        f32x4 {
            val: bytemuck::cast(a.val),
            simd: a.simd,
        }
    }
    #[inline(always)]
    fn splat_mask64x2(self, val: i64) -> mask64x2<Self> {
        unsafe { _mm_set1_epi64x(val).simd_into(self) }
    }
    #[inline(always)]
    fn not_mask64x2(self, a: mask64x2<Self>) -> mask64x2<Self> {
        a ^ !0
    }
    #[inline(always)]
    fn and_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_and_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn or_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_or_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn xor_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_xor_si128(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn select_mask64x2(
        self,
        a: mask64x2<Self>,
        b: mask64x2<Self>,
        c: mask64x2<Self>,
    ) -> mask64x2<Self> {
        unsafe {
            _mm_or_si128(
                _mm_and_si128(a.into(), b.into()),
                _mm_andnot_si128(a.into(), c.into()),
            )
            .simd_into(self)
        }
    }
    #[inline(always)]
    fn simd_eq_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x2<Self> {
        unsafe { _mm_cmpeq_epi64(a.into(), b.into()).simd_into(self) }
    }
    #[inline(always)]
    fn combine_mask64x2(self, a: mask64x2<Self>, b: mask64x2<Self>) -> mask64x4<Self> {
        let mut result = [0; 4usize];
        result[0..2usize].copy_from_slice(&a.val);
        result[2usize..4usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn splat_f32x8(self, a: f32) -> f32x8<Self> {
        let half = self.splat_f32x4(a);
        self.combine_f32x4(half, half)
    }
    #[inline(always)]
    fn abs_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.abs_f32x4(a0), self.abs_f32x4(a1))
    }
    #[inline(always)]
    fn neg_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.neg_f32x4(a0), self.neg_f32x4(a1))
    }
    #[inline(always)]
    fn sqrt_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.sqrt_f32x4(a0), self.sqrt_f32x4(a1))
    }
    #[inline(always)]
    fn add_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.add_f32x4(a0, b0), self.add_f32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.sub_f32x4(a0, b0), self.sub_f32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.mul_f32x4(a0, b0), self.mul_f32x4(a1, b1))
    }
    #[inline(always)]
    fn div_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.div_f32x4(a0, b0), self.div_f32x4(a1, b1))
    }
    #[inline(always)]
    fn copysign_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.copysign_f32x4(a0, b0), self.copysign_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_eq_f32x4(a0, b0), self.simd_eq_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_lt_f32x4(a0, b0), self.simd_lt_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_le_f32x4(a0, b0), self.simd_le_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_ge_f32x4(a0, b0), self.simd_ge_f32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_mask32x4(self.simd_gt_f32x4(a0, b0), self.simd_gt_f32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, _) = self.split_f32x8(a);
        let (b0, _) = self.split_f32x8(b);
        self.combine_f32x4(self.zip_low_f32x4(a0, b0), self.zip_high_f32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (_, a1) = self.split_f32x8(a);
        let (_, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.zip_low_f32x4(a1, b1), self.zip_high_f32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.unzip_low_f32x4(a0, a1), self.unzip_low_f32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.unzip_high_f32x4(a0, a1), self.unzip_high_f32x4(b0, b1))
    }
    #[inline(always)]
    fn max_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.max_f32x4(a0, b0), self.max_f32x4(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(
            self.max_precise_f32x4(a0, b0),
            self.max_precise_f32x4(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(self.min_f32x4(a0, b0), self.min_f32x4(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        self.combine_f32x4(
            self.min_precise_f32x4(a0, b0),
            self.min_precise_f32x4(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.madd_f32x4(a0, b0, c0), self.madd_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f32x8(self, a: f32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.msub_f32x4(a0, b0, c0), self.msub_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.floor_f32x4(a0), self.floor_f32x4(a1))
    }
    #[inline(always)]
    fn fract_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.fract_f32x4(a0), self.fract_f32x4(a1))
    }
    #[inline(always)]
    fn trunc_f32x8(self, a: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f32x4(self.trunc_f32x4(a0), self.trunc_f32x4(a1))
    }
    #[inline(always)]
    fn select_f32x8(self, a: mask32x8<Self>, b: f32x8<Self>, c: f32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_f32x8(b);
        let (c0, c1) = self.split_f32x8(c);
        self.combine_f32x4(self.select_f32x4(a0, b0, c0), self.select_f32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn combine_f32x8(self, a: f32x8<Self>, b: f32x8<Self>) -> f32x16<Self> {
        let mut result = [0.0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_f32x8(self, a: f32x8<Self>) -> (f32x4<Self>, f32x4<Self>) {
        let mut b0 = [0.0; 4usize];
        let mut b1 = [0.0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f64_f32x8(self, a: f32x8<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_f64x2(
            self.reinterpret_f64_f32x4(a0),
            self.reinterpret_f64_f32x4(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_i32x4(
            self.reinterpret_i32_f32x4(a0),
            self.reinterpret_i32_f32x4(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u8_f32x8(self, a: f32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u8x16(self.reinterpret_u8_f32x4(a0), self.reinterpret_u8_f32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u32x4(
            self.reinterpret_u32_f32x4(a0),
            self.reinterpret_u32_f32x4(a1),
        )
    }
    #[inline(always)]
    fn cvt_u32_f32x8(self, a: f32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_u32x4(self.cvt_u32_f32x4(a0), self.cvt_u32_f32x4(a1))
    }
    #[inline(always)]
    fn cvt_i32_f32x8(self, a: f32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_f32x8(a);
        self.combine_i32x4(self.cvt_i32_f32x4(a0), self.cvt_i32_f32x4(a1))
    }
    #[inline(always)]
    fn splat_i8x32(self, a: i8) -> i8x32<Self> {
        let half = self.splat_i8x16(a);
        self.combine_i8x16(half, half)
    }
    #[inline(always)]
    fn not_i8x32(self, a: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.not_i8x16(a0), self.not_i8x16(a1))
    }
    #[inline(always)]
    fn add_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.add_i8x16(a0, b0), self.add_i8x16(a1, b1))
    }
    #[inline(always)]
    fn sub_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.sub_i8x16(a0, b0), self.sub_i8x16(a1, b1))
    }
    #[inline(always)]
    fn mul_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.mul_i8x16(a0, b0), self.mul_i8x16(a1, b1))
    }
    #[inline(always)]
    fn and_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.and_i8x16(a0, b0), self.and_i8x16(a1, b1))
    }
    #[inline(always)]
    fn or_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.or_i8x16(a0, b0), self.or_i8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.xor_i8x16(a0, b0), self.xor_i8x16(a1, b1))
    }
    #[inline(always)]
    fn shr_i8x32(self, a: i8x32<Self>, b: u32) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.shr_i8x16(a0, b), self.shr_i8x16(a1, b))
    }
    #[inline(always)]
    fn shrv_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.shrv_i8x16(a0, b0), self.shrv_i8x16(a1, b1))
    }
    #[inline(always)]
    fn shl_i8x32(self, a: i8x32<Self>, b: u32) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.shl_i8x16(a0, b), self.shl_i8x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_eq_i8x16(a0, b0), self.simd_eq_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_lt_i8x16(a0, b0), self.simd_lt_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_le_i8x16(a0, b0), self.simd_le_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_ge_i8x16(a0, b0), self.simd_ge_i8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_mask8x16(self.simd_gt_i8x16(a0, b0), self.simd_gt_i8x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, _) = self.split_i8x32(a);
        let (b0, _) = self.split_i8x32(b);
        self.combine_i8x16(self.zip_low_i8x16(a0, b0), self.zip_high_i8x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (_, a1) = self.split_i8x32(a);
        let (_, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.zip_low_i8x16(a1, b1), self.zip_high_i8x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.unzip_low_i8x16(a0, a1), self.unzip_low_i8x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.unzip_high_i8x16(a0, a1), self.unzip_high_i8x16(b0, b1))
    }
    #[inline(always)]
    fn select_i8x32(self, a: mask8x32<Self>, b: i8x32<Self>, c: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        let (c0, c1) = self.split_i8x32(c);
        self.combine_i8x16(self.select_i8x16(a0, b0, c0), self.select_i8x16(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.min_i8x16(a0, b0), self.min_i8x16(a1, b1))
    }
    #[inline(always)]
    fn max_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        let (b0, b1) = self.split_i8x32(b);
        self.combine_i8x16(self.max_i8x16(a0, b0), self.max_i8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_i8x32(self, a: i8x32<Self>, b: i8x32<Self>) -> i8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i8x32(self, a: i8x32<Self>) -> (i8x16<Self>, i8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i8x32(self, a: i8x32<Self>) -> i8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_i8x16(self.neg_i8x16(a0), self.neg_i8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i8x32(self, a: i8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_u8x16(self.reinterpret_u8_i8x16(a0), self.reinterpret_u8_i8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i8x32(self, a: i8x32<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i8x32(a);
        self.combine_u32x4(
            self.reinterpret_u32_i8x16(a0),
            self.reinterpret_u32_i8x16(a1),
        )
    }
    #[inline(always)]
    fn splat_u8x32(self, a: u8) -> u8x32<Self> {
        let half = self.splat_u8x16(a);
        self.combine_u8x16(half, half)
    }
    #[inline(always)]
    fn not_u8x32(self, a: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.not_u8x16(a0), self.not_u8x16(a1))
    }
    #[inline(always)]
    fn add_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.add_u8x16(a0, b0), self.add_u8x16(a1, b1))
    }
    #[inline(always)]
    fn sub_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.sub_u8x16(a0, b0), self.sub_u8x16(a1, b1))
    }
    #[inline(always)]
    fn mul_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.mul_u8x16(a0, b0), self.mul_u8x16(a1, b1))
    }
    #[inline(always)]
    fn and_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.and_u8x16(a0, b0), self.and_u8x16(a1, b1))
    }
    #[inline(always)]
    fn or_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.or_u8x16(a0, b0), self.or_u8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.xor_u8x16(a0, b0), self.xor_u8x16(a1, b1))
    }
    #[inline(always)]
    fn shr_u8x32(self, a: u8x32<Self>, b: u32) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.shr_u8x16(a0, b), self.shr_u8x16(a1, b))
    }
    #[inline(always)]
    fn shrv_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.shrv_u8x16(a0, b0), self.shrv_u8x16(a1, b1))
    }
    #[inline(always)]
    fn shl_u8x32(self, a: u8x32<Self>, b: u32) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u8x16(self.shl_u8x16(a0, b), self.shl_u8x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_eq_u8x16(a0, b0), self.simd_eq_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_lt_u8x16(a0, b0), self.simd_lt_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_le_u8x16(a0, b0), self.simd_le_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_ge_u8x16(a0, b0), self.simd_ge_u8x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_mask8x16(self.simd_gt_u8x16(a0, b0), self.simd_gt_u8x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, _) = self.split_u8x32(a);
        let (b0, _) = self.split_u8x32(b);
        self.combine_u8x16(self.zip_low_u8x16(a0, b0), self.zip_high_u8x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (_, a1) = self.split_u8x32(a);
        let (_, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.zip_low_u8x16(a1, b1), self.zip_high_u8x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.unzip_low_u8x16(a0, a1), self.unzip_low_u8x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.unzip_high_u8x16(a0, a1), self.unzip_high_u8x16(b0, b1))
    }
    #[inline(always)]
    fn select_u8x32(self, a: mask8x32<Self>, b: u8x32<Self>, c: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        let (c0, c1) = self.split_u8x32(c);
        self.combine_u8x16(self.select_u8x16(a0, b0, c0), self.select_u8x16(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.min_u8x16(a0, b0), self.min_u8x16(a1, b1))
    }
    #[inline(always)]
    fn max_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        let (b0, b1) = self.split_u8x32(b);
        self.combine_u8x16(self.max_u8x16(a0, b0), self.max_u8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_u8x32(self, a: u8x32<Self>, b: u8x32<Self>) -> u8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u8x32(self, a: u8x32<Self>) -> (u8x16<Self>, u8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn widen_u8x32(self, a: u8x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u16x16(self.widen_u8x16(a0), self.widen_u8x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_u8x32(self, a: u8x32<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u8x32(a);
        self.combine_u32x4(
            self.reinterpret_u32_u8x16(a0),
            self.reinterpret_u32_u8x16(a1),
        )
    }
    #[inline(always)]
    fn splat_mask8x32(self, a: i8) -> mask8x32<Self> {
        let half = self.splat_mask8x16(a);
        self.combine_mask8x16(half, half)
    }
    #[inline(always)]
    fn not_mask8x32(self, a: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        self.combine_mask8x16(self.not_mask8x16(a0), self.not_mask8x16(a1))
    }
    #[inline(always)]
    fn and_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.and_mask8x16(a0, b0), self.and_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn or_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.or_mask8x16(a0, b0), self.or_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn xor_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.xor_mask8x16(a0, b0), self.xor_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn select_mask8x32(
        self,
        a: mask8x32<Self>,
        b: mask8x32<Self>,
        c: mask8x32<Self>,
    ) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        let (c0, c1) = self.split_mask8x32(c);
        self.combine_mask8x16(
            self.select_mask8x16(a0, b0, c0),
            self.select_mask8x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x32<Self> {
        let (a0, a1) = self.split_mask8x32(a);
        let (b0, b1) = self.split_mask8x32(b);
        self.combine_mask8x16(self.simd_eq_mask8x16(a0, b0), self.simd_eq_mask8x16(a1, b1))
    }
    #[inline(always)]
    fn combine_mask8x32(self, a: mask8x32<Self>, b: mask8x32<Self>) -> mask8x64<Self> {
        let mut result = [0; 64usize];
        result[0..32usize].copy_from_slice(&a.val);
        result[32usize..64usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask8x32(self, a: mask8x32<Self>) -> (mask8x16<Self>, mask8x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i16x16(self, a: i16) -> i16x16<Self> {
        let half = self.splat_i16x8(a);
        self.combine_i16x8(half, half)
    }
    #[inline(always)]
    fn not_i16x16(self, a: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.not_i16x8(a0), self.not_i16x8(a1))
    }
    #[inline(always)]
    fn add_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.add_i16x8(a0, b0), self.add_i16x8(a1, b1))
    }
    #[inline(always)]
    fn sub_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.sub_i16x8(a0, b0), self.sub_i16x8(a1, b1))
    }
    #[inline(always)]
    fn mul_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.mul_i16x8(a0, b0), self.mul_i16x8(a1, b1))
    }
    #[inline(always)]
    fn and_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.and_i16x8(a0, b0), self.and_i16x8(a1, b1))
    }
    #[inline(always)]
    fn or_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.or_i16x8(a0, b0), self.or_i16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.xor_i16x8(a0, b0), self.xor_i16x8(a1, b1))
    }
    #[inline(always)]
    fn shr_i16x16(self, a: i16x16<Self>, b: u32) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.shr_i16x8(a0, b), self.shr_i16x8(a1, b))
    }
    #[inline(always)]
    fn shrv_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.shrv_i16x8(a0, b0), self.shrv_i16x8(a1, b1))
    }
    #[inline(always)]
    fn shl_i16x16(self, a: i16x16<Self>, b: u32) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.shl_i16x8(a0, b), self.shl_i16x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_eq_i16x8(a0, b0), self.simd_eq_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_lt_i16x8(a0, b0), self.simd_lt_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_le_i16x8(a0, b0), self.simd_le_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_ge_i16x8(a0, b0), self.simd_ge_i16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_mask16x8(self.simd_gt_i16x8(a0, b0), self.simd_gt_i16x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, _) = self.split_i16x16(a);
        let (b0, _) = self.split_i16x16(b);
        self.combine_i16x8(self.zip_low_i16x8(a0, b0), self.zip_high_i16x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (_, a1) = self.split_i16x16(a);
        let (_, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.zip_low_i16x8(a1, b1), self.zip_high_i16x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.unzip_low_i16x8(a0, a1), self.unzip_low_i16x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.unzip_high_i16x8(a0, a1), self.unzip_high_i16x8(b0, b1))
    }
    #[inline(always)]
    fn select_i16x16(self, a: mask16x16<Self>, b: i16x16<Self>, c: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        let (c0, c1) = self.split_i16x16(c);
        self.combine_i16x8(self.select_i16x8(a0, b0, c0), self.select_i16x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.min_i16x8(a0, b0), self.min_i16x8(a1, b1))
    }
    #[inline(always)]
    fn max_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        let (b0, b1) = self.split_i16x16(b);
        self.combine_i16x8(self.max_i16x8(a0, b0), self.max_i16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_i16x16(self, a: i16x16<Self>, b: i16x16<Self>) -> i16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i16x16(self, a: i16x16<Self>) -> (i16x8<Self>, i16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i16x16(self, a: i16x16<Self>) -> i16x16<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_i16x8(self.neg_i16x8(a0), self.neg_i16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i16x16(self, a: i16x16<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_u8x16(self.reinterpret_u8_i16x8(a0), self.reinterpret_u8_i16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i16x16(self, a: i16x16<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i16x16(a);
        self.combine_u32x4(
            self.reinterpret_u32_i16x8(a0),
            self.reinterpret_u32_i16x8(a1),
        )
    }
    #[inline(always)]
    fn splat_u16x16(self, a: u16) -> u16x16<Self> {
        let half = self.splat_u16x8(a);
        self.combine_u16x8(half, half)
    }
    #[inline(always)]
    fn not_u16x16(self, a: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.not_u16x8(a0), self.not_u16x8(a1))
    }
    #[inline(always)]
    fn add_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.add_u16x8(a0, b0), self.add_u16x8(a1, b1))
    }
    #[inline(always)]
    fn sub_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.sub_u16x8(a0, b0), self.sub_u16x8(a1, b1))
    }
    #[inline(always)]
    fn mul_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.mul_u16x8(a0, b0), self.mul_u16x8(a1, b1))
    }
    #[inline(always)]
    fn and_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.and_u16x8(a0, b0), self.and_u16x8(a1, b1))
    }
    #[inline(always)]
    fn or_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.or_u16x8(a0, b0), self.or_u16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.xor_u16x8(a0, b0), self.xor_u16x8(a1, b1))
    }
    #[inline(always)]
    fn shr_u16x16(self, a: u16x16<Self>, b: u32) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.shr_u16x8(a0, b), self.shr_u16x8(a1, b))
    }
    #[inline(always)]
    fn shrv_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.shrv_u16x8(a0, b0), self.shrv_u16x8(a1, b1))
    }
    #[inline(always)]
    fn shl_u16x16(self, a: u16x16<Self>, b: u32) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u16x8(self.shl_u16x8(a0, b), self.shl_u16x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_eq_u16x8(a0, b0), self.simd_eq_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_lt_u16x8(a0, b0), self.simd_lt_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_le_u16x8(a0, b0), self.simd_le_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_ge_u16x8(a0, b0), self.simd_ge_u16x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_mask16x8(self.simd_gt_u16x8(a0, b0), self.simd_gt_u16x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, _) = self.split_u16x16(a);
        let (b0, _) = self.split_u16x16(b);
        self.combine_u16x8(self.zip_low_u16x8(a0, b0), self.zip_high_u16x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (_, a1) = self.split_u16x16(a);
        let (_, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.zip_low_u16x8(a1, b1), self.zip_high_u16x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.unzip_low_u16x8(a0, a1), self.unzip_low_u16x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.unzip_high_u16x8(a0, a1), self.unzip_high_u16x8(b0, b1))
    }
    #[inline(always)]
    fn select_u16x16(self, a: mask16x16<Self>, b: u16x16<Self>, c: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        let (c0, c1) = self.split_u16x16(c);
        self.combine_u16x8(self.select_u16x8(a0, b0, c0), self.select_u16x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.min_u16x8(a0, b0), self.min_u16x8(a1, b1))
    }
    #[inline(always)]
    fn max_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x16<Self> {
        let (a0, a1) = self.split_u16x16(a);
        let (b0, b1) = self.split_u16x16(b);
        self.combine_u16x8(self.max_u16x8(a0, b0), self.max_u16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_u16x16(self, a: u16x16<Self>, b: u16x16<Self>) -> u16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u16x16(self, a: u16x16<Self>) -> (u16x8<Self>, u16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn narrow_u16x16(self, a: u16x16<Self>) -> u8x16<Self> {
        let (a, b) = self.split_u16x16(a);
        unsafe {
            let mask = _mm_set1_epi16(0xFF);
            let lo_masked = _mm_and_si128(a.into(), mask);
            let hi_masked = _mm_and_si128(b.into(), mask);
            let result = _mm_packus_epi16(lo_masked, hi_masked);
            result.simd_into(self)
        }
    }
    #[inline(always)]
    fn reinterpret_u8_u16x16(self, a: u16x16<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u8x16(self.reinterpret_u8_u16x8(a0), self.reinterpret_u8_u16x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_u16x16(self, a: u16x16<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u16x16(a);
        self.combine_u32x4(
            self.reinterpret_u32_u16x8(a0),
            self.reinterpret_u32_u16x8(a1),
        )
    }
    #[inline(always)]
    fn splat_mask16x16(self, a: i16) -> mask16x16<Self> {
        let half = self.splat_mask16x8(a);
        self.combine_mask16x8(half, half)
    }
    #[inline(always)]
    fn not_mask16x16(self, a: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        self.combine_mask16x8(self.not_mask16x8(a0), self.not_mask16x8(a1))
    }
    #[inline(always)]
    fn and_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.and_mask16x8(a0, b0), self.and_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn or_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.or_mask16x8(a0, b0), self.or_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn xor_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.xor_mask16x8(a0, b0), self.xor_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn select_mask16x16(
        self,
        a: mask16x16<Self>,
        b: mask16x16<Self>,
        c: mask16x16<Self>,
    ) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        let (c0, c1) = self.split_mask16x16(c);
        self.combine_mask16x8(
            self.select_mask16x8(a0, b0, c0),
            self.select_mask16x8(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x16<Self> {
        let (a0, a1) = self.split_mask16x16(a);
        let (b0, b1) = self.split_mask16x16(b);
        self.combine_mask16x8(self.simd_eq_mask16x8(a0, b0), self.simd_eq_mask16x8(a1, b1))
    }
    #[inline(always)]
    fn combine_mask16x16(self, a: mask16x16<Self>, b: mask16x16<Self>) -> mask16x32<Self> {
        let mut result = [0; 32usize];
        result[0..16usize].copy_from_slice(&a.val);
        result[16usize..32usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask16x16(self, a: mask16x16<Self>) -> (mask16x8<Self>, mask16x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i32x8(self, a: i32) -> i32x8<Self> {
        let half = self.splat_i32x4(a);
        self.combine_i32x4(half, half)
    }
    #[inline(always)]
    fn not_i32x8(self, a: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.not_i32x4(a0), self.not_i32x4(a1))
    }
    #[inline(always)]
    fn add_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.add_i32x4(a0, b0), self.add_i32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.sub_i32x4(a0, b0), self.sub_i32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.mul_i32x4(a0, b0), self.mul_i32x4(a1, b1))
    }
    #[inline(always)]
    fn and_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.and_i32x4(a0, b0), self.and_i32x4(a1, b1))
    }
    #[inline(always)]
    fn or_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.or_i32x4(a0, b0), self.or_i32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.xor_i32x4(a0, b0), self.xor_i32x4(a1, b1))
    }
    #[inline(always)]
    fn shr_i32x8(self, a: i32x8<Self>, b: u32) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.shr_i32x4(a0, b), self.shr_i32x4(a1, b))
    }
    #[inline(always)]
    fn shrv_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.shrv_i32x4(a0, b0), self.shrv_i32x4(a1, b1))
    }
    #[inline(always)]
    fn shl_i32x8(self, a: i32x8<Self>, b: u32) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.shl_i32x4(a0, b), self.shl_i32x4(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_eq_i32x4(a0, b0), self.simd_eq_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_lt_i32x4(a0, b0), self.simd_lt_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_le_i32x4(a0, b0), self.simd_le_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_ge_i32x4(a0, b0), self.simd_ge_i32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_mask32x4(self.simd_gt_i32x4(a0, b0), self.simd_gt_i32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, _) = self.split_i32x8(a);
        let (b0, _) = self.split_i32x8(b);
        self.combine_i32x4(self.zip_low_i32x4(a0, b0), self.zip_high_i32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (_, a1) = self.split_i32x8(a);
        let (_, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.zip_low_i32x4(a1, b1), self.zip_high_i32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.unzip_low_i32x4(a0, a1), self.unzip_low_i32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.unzip_high_i32x4(a0, a1), self.unzip_high_i32x4(b0, b1))
    }
    #[inline(always)]
    fn select_i32x8(self, a: mask32x8<Self>, b: i32x8<Self>, c: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        let (c0, c1) = self.split_i32x8(c);
        self.combine_i32x4(self.select_i32x4(a0, b0, c0), self.select_i32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.min_i32x4(a0, b0), self.min_i32x4(a1, b1))
    }
    #[inline(always)]
    fn max_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        let (b0, b1) = self.split_i32x8(b);
        self.combine_i32x4(self.max_i32x4(a0, b0), self.max_i32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_i32x8(self, a: i32x8<Self>, b: i32x8<Self>) -> i32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_i32x8(self, a: i32x8<Self>) -> (i32x4<Self>, i32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i32x8(self, a: i32x8<Self>) -> i32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_i32x4(self.neg_i32x4(a0), self.neg_i32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i32x8(self, a: i32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_u8x16(self.reinterpret_u8_i32x4(a0), self.reinterpret_u8_i32x4(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i32x8(self, a: i32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_u32x4(
            self.reinterpret_u32_i32x4(a0),
            self.reinterpret_u32_i32x4(a1),
        )
    }
    #[inline(always)]
    fn cvt_f32_i32x8(self, a: i32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_i32x8(a);
        self.combine_f32x4(self.cvt_f32_i32x4(a0), self.cvt_f32_i32x4(a1))
    }
    #[inline(always)]
    fn splat_u32x8(self, a: u32) -> u32x8<Self> {
        let half = self.splat_u32x4(a);
        self.combine_u32x4(half, half)
    }
    #[inline(always)]
    fn not_u32x8(self, a: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.not_u32x4(a0), self.not_u32x4(a1))
    }
    #[inline(always)]
    fn add_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.add_u32x4(a0, b0), self.add_u32x4(a1, b1))
    }
    #[inline(always)]
    fn sub_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.sub_u32x4(a0, b0), self.sub_u32x4(a1, b1))
    }
    #[inline(always)]
    fn mul_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.mul_u32x4(a0, b0), self.mul_u32x4(a1, b1))
    }
    #[inline(always)]
    fn and_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.and_u32x4(a0, b0), self.and_u32x4(a1, b1))
    }
    #[inline(always)]
    fn or_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.or_u32x4(a0, b0), self.or_u32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.xor_u32x4(a0, b0), self.xor_u32x4(a1, b1))
    }
    #[inline(always)]
    fn shr_u32x8(self, a: u32x8<Self>, b: u32) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.shr_u32x4(a0, b), self.shr_u32x4(a1, b))
    }
    #[inline(always)]
    fn shrv_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.shrv_u32x4(a0, b0), self.shrv_u32x4(a1, b1))
    }
    #[inline(always)]
    fn shl_u32x8(self, a: u32x8<Self>, b: u32) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u32x4(self.shl_u32x4(a0, b), self.shl_u32x4(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_eq_u32x4(a0, b0), self.simd_eq_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_lt_u32x4(a0, b0), self.simd_lt_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_le_u32x4(a0, b0), self.simd_le_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_ge_u32x4(a0, b0), self.simd_ge_u32x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_mask32x4(self.simd_gt_u32x4(a0, b0), self.simd_gt_u32x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, _) = self.split_u32x8(a);
        let (b0, _) = self.split_u32x8(b);
        self.combine_u32x4(self.zip_low_u32x4(a0, b0), self.zip_high_u32x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (_, a1) = self.split_u32x8(a);
        let (_, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.zip_low_u32x4(a1, b1), self.zip_high_u32x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.unzip_low_u32x4(a0, a1), self.unzip_low_u32x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.unzip_high_u32x4(a0, a1), self.unzip_high_u32x4(b0, b1))
    }
    #[inline(always)]
    fn select_u32x8(self, a: mask32x8<Self>, b: u32x8<Self>, c: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        let (c0, c1) = self.split_u32x8(c);
        self.combine_u32x4(self.select_u32x4(a0, b0, c0), self.select_u32x4(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.min_u32x4(a0, b0), self.min_u32x4(a1, b1))
    }
    #[inline(always)]
    fn max_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        let (b0, b1) = self.split_u32x8(b);
        self.combine_u32x4(self.max_u32x4(a0, b0), self.max_u32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_u32x8(self, a: u32x8<Self>, b: u32x8<Self>) -> u32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_u32x8(self, a: u32x8<Self>) -> (u32x4<Self>, u32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_u8_u32x8(self, a: u32x8<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_u8x16(self.reinterpret_u8_u32x4(a0), self.reinterpret_u8_u32x4(a1))
    }
    #[inline(always)]
    fn cvt_f32_u32x8(self, a: u32x8<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_u32x8(a);
        self.combine_f32x4(self.cvt_f32_u32x4(a0), self.cvt_f32_u32x4(a1))
    }
    #[inline(always)]
    fn splat_mask32x8(self, a: i32) -> mask32x8<Self> {
        let half = self.splat_mask32x4(a);
        self.combine_mask32x4(half, half)
    }
    #[inline(always)]
    fn not_mask32x8(self, a: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        self.combine_mask32x4(self.not_mask32x4(a0), self.not_mask32x4(a1))
    }
    #[inline(always)]
    fn and_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.and_mask32x4(a0, b0), self.and_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn or_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.or_mask32x4(a0, b0), self.or_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn xor_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.xor_mask32x4(a0, b0), self.xor_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn select_mask32x8(
        self,
        a: mask32x8<Self>,
        b: mask32x8<Self>,
        c: mask32x8<Self>,
    ) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        let (c0, c1) = self.split_mask32x8(c);
        self.combine_mask32x4(
            self.select_mask32x4(a0, b0, c0),
            self.select_mask32x4(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x8<Self> {
        let (a0, a1) = self.split_mask32x8(a);
        let (b0, b1) = self.split_mask32x8(b);
        self.combine_mask32x4(self.simd_eq_mask32x4(a0, b0), self.simd_eq_mask32x4(a1, b1))
    }
    #[inline(always)]
    fn combine_mask32x8(self, a: mask32x8<Self>, b: mask32x8<Self>) -> mask32x16<Self> {
        let mut result = [0; 16usize];
        result[0..8usize].copy_from_slice(&a.val);
        result[8usize..16usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask32x8(self, a: mask32x8<Self>) -> (mask32x4<Self>, mask32x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f64x4(self, a: f64) -> f64x4<Self> {
        let half = self.splat_f64x2(a);
        self.combine_f64x2(half, half)
    }
    #[inline(always)]
    fn abs_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.abs_f64x2(a0), self.abs_f64x2(a1))
    }
    #[inline(always)]
    fn neg_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.neg_f64x2(a0), self.neg_f64x2(a1))
    }
    #[inline(always)]
    fn sqrt_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.sqrt_f64x2(a0), self.sqrt_f64x2(a1))
    }
    #[inline(always)]
    fn add_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.add_f64x2(a0, b0), self.add_f64x2(a1, b1))
    }
    #[inline(always)]
    fn sub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.sub_f64x2(a0, b0), self.sub_f64x2(a1, b1))
    }
    #[inline(always)]
    fn mul_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.mul_f64x2(a0, b0), self.mul_f64x2(a1, b1))
    }
    #[inline(always)]
    fn div_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.div_f64x2(a0, b0), self.div_f64x2(a1, b1))
    }
    #[inline(always)]
    fn copysign_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.copysign_f64x2(a0, b0), self.copysign_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_eq_f64x2(a0, b0), self.simd_eq_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_lt_f64x2(a0, b0), self.simd_lt_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_le_f64x2(a0, b0), self.simd_le_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_ge_f64x2(a0, b0), self.simd_ge_f64x2(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_mask64x2(self.simd_gt_f64x2(a0, b0), self.simd_gt_f64x2(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, _) = self.split_f64x4(a);
        let (b0, _) = self.split_f64x4(b);
        self.combine_f64x2(self.zip_low_f64x2(a0, b0), self.zip_high_f64x2(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (_, a1) = self.split_f64x4(a);
        let (_, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.zip_low_f64x2(a1, b1), self.zip_high_f64x2(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.unzip_low_f64x2(a0, a1), self.unzip_low_f64x2(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.unzip_high_f64x2(a0, a1), self.unzip_high_f64x2(b0, b1))
    }
    #[inline(always)]
    fn max_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.max_f64x2(a0, b0), self.max_f64x2(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(
            self.max_precise_f64x2(a0, b0),
            self.max_precise_f64x2(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(self.min_f64x2(a0, b0), self.min_f64x2(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        self.combine_f64x2(
            self.min_precise_f64x2(a0, b0),
            self.min_precise_f64x2(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.madd_f64x2(a0, b0, c0), self.madd_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f64x4(self, a: f64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.msub_f64x2(a0, b0, c0), self.msub_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.floor_f64x2(a0), self.floor_f64x2(a1))
    }
    #[inline(always)]
    fn fract_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.fract_f64x2(a0), self.fract_f64x2(a1))
    }
    #[inline(always)]
    fn trunc_f64x4(self, a: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f64x2(self.trunc_f64x2(a0), self.trunc_f64x2(a1))
    }
    #[inline(always)]
    fn select_f64x4(self, a: mask64x4<Self>, b: f64x4<Self>, c: f64x4<Self>) -> f64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_f64x4(b);
        let (c0, c1) = self.split_f64x4(c);
        self.combine_f64x2(self.select_f64x2(a0, b0, c0), self.select_f64x2(a1, b1, c1))
    }
    #[inline(always)]
    fn combine_f64x4(self, a: f64x4<Self>, b: f64x4<Self>) -> f64x8<Self> {
        let mut result = [0.0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_f64x4(self, a: f64x4<Self>) -> (f64x2<Self>, f64x2<Self>) {
        let mut b0 = [0.0; 2usize];
        let mut b1 = [0.0; 2usize];
        b0.copy_from_slice(&a.val[0..2usize]);
        b1.copy_from_slice(&a.val[2usize..4usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f32_f64x4(self, a: f64x4<Self>) -> f32x8<Self> {
        let (a0, a1) = self.split_f64x4(a);
        self.combine_f32x4(
            self.reinterpret_f32_f64x2(a0),
            self.reinterpret_f32_f64x2(a1),
        )
    }
    #[inline(always)]
    fn splat_mask64x4(self, a: i64) -> mask64x4<Self> {
        let half = self.splat_mask64x2(a);
        self.combine_mask64x2(half, half)
    }
    #[inline(always)]
    fn not_mask64x4(self, a: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        self.combine_mask64x2(self.not_mask64x2(a0), self.not_mask64x2(a1))
    }
    #[inline(always)]
    fn and_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.and_mask64x2(a0, b0), self.and_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn or_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.or_mask64x2(a0, b0), self.or_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn xor_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.xor_mask64x2(a0, b0), self.xor_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn select_mask64x4(
        self,
        a: mask64x4<Self>,
        b: mask64x4<Self>,
        c: mask64x4<Self>,
    ) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        let (c0, c1) = self.split_mask64x4(c);
        self.combine_mask64x2(
            self.select_mask64x2(a0, b0, c0),
            self.select_mask64x2(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x4<Self> {
        let (a0, a1) = self.split_mask64x4(a);
        let (b0, b1) = self.split_mask64x4(b);
        self.combine_mask64x2(self.simd_eq_mask64x2(a0, b0), self.simd_eq_mask64x2(a1, b1))
    }
    #[inline(always)]
    fn combine_mask64x4(self, a: mask64x4<Self>, b: mask64x4<Self>) -> mask64x8<Self> {
        let mut result = [0; 8usize];
        result[0..4usize].copy_from_slice(&a.val);
        result[4usize..8usize].copy_from_slice(&b.val);
        result.simd_into(self)
    }
    #[inline(always)]
    fn split_mask64x4(self, a: mask64x4<Self>) -> (mask64x2<Self>, mask64x2<Self>) {
        let mut b0 = [0; 2usize];
        let mut b1 = [0; 2usize];
        b0.copy_from_slice(&a.val[0..2usize]);
        b1.copy_from_slice(&a.val[2usize..4usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f32x16(self, a: f32) -> f32x16<Self> {
        let half = self.splat_f32x8(a);
        self.combine_f32x8(half, half)
    }
    #[inline(always)]
    fn abs_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.abs_f32x8(a0), self.abs_f32x8(a1))
    }
    #[inline(always)]
    fn neg_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.neg_f32x8(a0), self.neg_f32x8(a1))
    }
    #[inline(always)]
    fn sqrt_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.sqrt_f32x8(a0), self.sqrt_f32x8(a1))
    }
    #[inline(always)]
    fn add_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.add_f32x8(a0, b0), self.add_f32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.sub_f32x8(a0, b0), self.sub_f32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.mul_f32x8(a0, b0), self.mul_f32x8(a1, b1))
    }
    #[inline(always)]
    fn div_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.div_f32x8(a0, b0), self.div_f32x8(a1, b1))
    }
    #[inline(always)]
    fn copysign_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.copysign_f32x8(a0, b0), self.copysign_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_eq_f32x8(a0, b0), self.simd_eq_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_lt_f32x8(a0, b0), self.simd_lt_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_le_f32x8(a0, b0), self.simd_le_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_ge_f32x8(a0, b0), self.simd_ge_f32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_mask32x8(self.simd_gt_f32x8(a0, b0), self.simd_gt_f32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, _) = self.split_f32x16(a);
        let (b0, _) = self.split_f32x16(b);
        self.combine_f32x8(self.zip_low_f32x8(a0, b0), self.zip_high_f32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (_, a1) = self.split_f32x16(a);
        let (_, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.zip_low_f32x8(a1, b1), self.zip_high_f32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.unzip_low_f32x8(a0, a1), self.unzip_low_f32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.unzip_high_f32x8(a0, a1), self.unzip_high_f32x8(b0, b1))
    }
    #[inline(always)]
    fn max_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.max_f32x8(a0, b0), self.max_f32x8(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(
            self.max_precise_f32x8(a0, b0),
            self.max_precise_f32x8(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(self.min_f32x8(a0, b0), self.min_f32x8(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f32x16(self, a: f32x16<Self>, b: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        self.combine_f32x8(
            self.min_precise_f32x8(a0, b0),
            self.min_precise_f32x8(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.madd_f32x8(a0, b0, c0), self.madd_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f32x16(self, a: f32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.msub_f32x8(a0, b0, c0), self.msub_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.floor_f32x8(a0), self.floor_f32x8(a1))
    }
    #[inline(always)]
    fn fract_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.fract_f32x8(a0), self.fract_f32x8(a1))
    }
    #[inline(always)]
    fn trunc_f32x16(self, a: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f32x8(self.trunc_f32x8(a0), self.trunc_f32x8(a1))
    }
    #[inline(always)]
    fn select_f32x16(self, a: mask32x16<Self>, b: f32x16<Self>, c: f32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_f32x16(b);
        let (c0, c1) = self.split_f32x16(c);
        self.combine_f32x8(self.select_f32x8(a0, b0, c0), self.select_f32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn split_f32x16(self, a: f32x16<Self>) -> (f32x8<Self>, f32x8<Self>) {
        let mut b0 = [0.0; 8usize];
        let mut b1 = [0.0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f64_f32x16(self, a: f32x16<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_f64x4(
            self.reinterpret_f64_f32x8(a0),
            self.reinterpret_f64_f32x8(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_i32x8(
            self.reinterpret_i32_f32x8(a0),
            self.reinterpret_i32_f32x8(a1),
        )
    }
    #[inline(always)]
    fn load_interleaved_128_f32x16(self, src: &[f32; 16usize]) -> f32x16<Self> {
        crate::Fallback::new()
            .load_interleaved_128_f32x16(src)
            .val
            .simd_into(self)
    }
    #[inline(always)]
    fn store_interleaved_128_f32x16(self, a: f32x16<Self>, dest: &mut [f32; 16usize]) -> () {
        let fb = crate::Fallback::new();
        fb.store_interleaved_128_f32x16(a.val.simd_into(fb), dest);
    }
    #[inline(always)]
    fn reinterpret_u8_f32x16(self, a: f32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u8x32(self.reinterpret_u8_f32x8(a0), self.reinterpret_u8_f32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u32x8(
            self.reinterpret_u32_f32x8(a0),
            self.reinterpret_u32_f32x8(a1),
        )
    }
    #[inline(always)]
    fn cvt_u32_f32x16(self, a: f32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_u32x8(self.cvt_u32_f32x8(a0), self.cvt_u32_f32x8(a1))
    }
    #[inline(always)]
    fn cvt_i32_f32x16(self, a: f32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_f32x16(a);
        self.combine_i32x8(self.cvt_i32_f32x8(a0), self.cvt_i32_f32x8(a1))
    }
    #[inline(always)]
    fn splat_i8x64(self, a: i8) -> i8x64<Self> {
        let half = self.splat_i8x32(a);
        self.combine_i8x32(half, half)
    }
    #[inline(always)]
    fn not_i8x64(self, a: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.not_i8x32(a0), self.not_i8x32(a1))
    }
    #[inline(always)]
    fn add_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.add_i8x32(a0, b0), self.add_i8x32(a1, b1))
    }
    #[inline(always)]
    fn sub_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.sub_i8x32(a0, b0), self.sub_i8x32(a1, b1))
    }
    #[inline(always)]
    fn mul_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.mul_i8x32(a0, b0), self.mul_i8x32(a1, b1))
    }
    #[inline(always)]
    fn and_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.and_i8x32(a0, b0), self.and_i8x32(a1, b1))
    }
    #[inline(always)]
    fn or_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.or_i8x32(a0, b0), self.or_i8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.xor_i8x32(a0, b0), self.xor_i8x32(a1, b1))
    }
    #[inline(always)]
    fn shr_i8x64(self, a: i8x64<Self>, b: u32) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.shr_i8x32(a0, b), self.shr_i8x32(a1, b))
    }
    #[inline(always)]
    fn shrv_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.shrv_i8x32(a0, b0), self.shrv_i8x32(a1, b1))
    }
    #[inline(always)]
    fn shl_i8x64(self, a: i8x64<Self>, b: u32) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.shl_i8x32(a0, b), self.shl_i8x32(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_eq_i8x32(a0, b0), self.simd_eq_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_lt_i8x32(a0, b0), self.simd_lt_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_le_i8x32(a0, b0), self.simd_le_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_ge_i8x32(a0, b0), self.simd_ge_i8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_mask8x32(self.simd_gt_i8x32(a0, b0), self.simd_gt_i8x32(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, _) = self.split_i8x64(a);
        let (b0, _) = self.split_i8x64(b);
        self.combine_i8x32(self.zip_low_i8x32(a0, b0), self.zip_high_i8x32(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (_, a1) = self.split_i8x64(a);
        let (_, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.zip_low_i8x32(a1, b1), self.zip_high_i8x32(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.unzip_low_i8x32(a0, a1), self.unzip_low_i8x32(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.unzip_high_i8x32(a0, a1), self.unzip_high_i8x32(b0, b1))
    }
    #[inline(always)]
    fn select_i8x64(self, a: mask8x64<Self>, b: i8x64<Self>, c: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        let (c0, c1) = self.split_i8x64(c);
        self.combine_i8x32(self.select_i8x32(a0, b0, c0), self.select_i8x32(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.min_i8x32(a0, b0), self.min_i8x32(a1, b1))
    }
    #[inline(always)]
    fn max_i8x64(self, a: i8x64<Self>, b: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        let (b0, b1) = self.split_i8x64(b);
        self.combine_i8x32(self.max_i8x32(a0, b0), self.max_i8x32(a1, b1))
    }
    #[inline(always)]
    fn split_i8x64(self, a: i8x64<Self>) -> (i8x32<Self>, i8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i8x64(self, a: i8x64<Self>) -> i8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_i8x32(self.neg_i8x32(a0), self.neg_i8x32(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i8x64(self, a: i8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_u8x32(self.reinterpret_u8_i8x32(a0), self.reinterpret_u8_i8x32(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i8x64(self, a: i8x64<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i8x64(a);
        self.combine_u32x8(
            self.reinterpret_u32_i8x32(a0),
            self.reinterpret_u32_i8x32(a1),
        )
    }
    #[inline(always)]
    fn splat_u8x64(self, a: u8) -> u8x64<Self> {
        let half = self.splat_u8x32(a);
        self.combine_u8x32(half, half)
    }
    #[inline(always)]
    fn not_u8x64(self, a: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.not_u8x32(a0), self.not_u8x32(a1))
    }
    #[inline(always)]
    fn add_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.add_u8x32(a0, b0), self.add_u8x32(a1, b1))
    }
    #[inline(always)]
    fn sub_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.sub_u8x32(a0, b0), self.sub_u8x32(a1, b1))
    }
    #[inline(always)]
    fn mul_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.mul_u8x32(a0, b0), self.mul_u8x32(a1, b1))
    }
    #[inline(always)]
    fn and_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.and_u8x32(a0, b0), self.and_u8x32(a1, b1))
    }
    #[inline(always)]
    fn or_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.or_u8x32(a0, b0), self.or_u8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.xor_u8x32(a0, b0), self.xor_u8x32(a1, b1))
    }
    #[inline(always)]
    fn shr_u8x64(self, a: u8x64<Self>, b: u32) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.shr_u8x32(a0, b), self.shr_u8x32(a1, b))
    }
    #[inline(always)]
    fn shrv_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.shrv_u8x32(a0, b0), self.shrv_u8x32(a1, b1))
    }
    #[inline(always)]
    fn shl_u8x64(self, a: u8x64<Self>, b: u32) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u8x32(self.shl_u8x32(a0, b), self.shl_u8x32(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_eq_u8x32(a0, b0), self.simd_eq_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_lt_u8x32(a0, b0), self.simd_lt_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_le_u8x32(a0, b0), self.simd_le_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_ge_u8x32(a0, b0), self.simd_ge_u8x32(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_mask8x32(self.simd_gt_u8x32(a0, b0), self.simd_gt_u8x32(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, _) = self.split_u8x64(a);
        let (b0, _) = self.split_u8x64(b);
        self.combine_u8x32(self.zip_low_u8x32(a0, b0), self.zip_high_u8x32(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (_, a1) = self.split_u8x64(a);
        let (_, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.zip_low_u8x32(a1, b1), self.zip_high_u8x32(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.unzip_low_u8x32(a0, a1), self.unzip_low_u8x32(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.unzip_high_u8x32(a0, a1), self.unzip_high_u8x32(b0, b1))
    }
    #[inline(always)]
    fn select_u8x64(self, a: mask8x64<Self>, b: u8x64<Self>, c: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        let (c0, c1) = self.split_u8x64(c);
        self.combine_u8x32(self.select_u8x32(a0, b0, c0), self.select_u8x32(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.min_u8x32(a0, b0), self.min_u8x32(a1, b1))
    }
    #[inline(always)]
    fn max_u8x64(self, a: u8x64<Self>, b: u8x64<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u8x64(a);
        let (b0, b1) = self.split_u8x64(b);
        self.combine_u8x32(self.max_u8x32(a0, b0), self.max_u8x32(a1, b1))
    }
    #[inline(always)]
    fn split_u8x64(self, a: u8x64<Self>) -> (u8x32<Self>, u8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u8x64(self, src: &[u8; 64usize]) -> u8x64<Self> {
        crate::Fallback::new()
            .load_interleaved_128_u8x64(src)
            .val
            .simd_into(self)
    }
    #[inline(always)]
    fn store_interleaved_128_u8x64(self, a: u8x64<Self>, dest: &mut [u8; 64usize]) -> () {
        let fb = crate::Fallback::new();
        fb.store_interleaved_128_u8x64(a.val.simd_into(fb), dest);
    }
    #[inline(always)]
    fn reinterpret_u32_u8x64(self, a: u8x64<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u8x64(a);
        self.combine_u32x8(
            self.reinterpret_u32_u8x32(a0),
            self.reinterpret_u32_u8x32(a1),
        )
    }
    #[inline(always)]
    fn splat_mask8x64(self, a: i8) -> mask8x64<Self> {
        let half = self.splat_mask8x32(a);
        self.combine_mask8x32(half, half)
    }
    #[inline(always)]
    fn not_mask8x64(self, a: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        self.combine_mask8x32(self.not_mask8x32(a0), self.not_mask8x32(a1))
    }
    #[inline(always)]
    fn and_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.and_mask8x32(a0, b0), self.and_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn or_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.or_mask8x32(a0, b0), self.or_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn xor_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.xor_mask8x32(a0, b0), self.xor_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn select_mask8x64(
        self,
        a: mask8x64<Self>,
        b: mask8x64<Self>,
        c: mask8x64<Self>,
    ) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        let (c0, c1) = self.split_mask8x64(c);
        self.combine_mask8x32(
            self.select_mask8x32(a0, b0, c0),
            self.select_mask8x32(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask8x64(self, a: mask8x64<Self>, b: mask8x64<Self>) -> mask8x64<Self> {
        let (a0, a1) = self.split_mask8x64(a);
        let (b0, b1) = self.split_mask8x64(b);
        self.combine_mask8x32(self.simd_eq_mask8x32(a0, b0), self.simd_eq_mask8x32(a1, b1))
    }
    #[inline(always)]
    fn split_mask8x64(self, a: mask8x64<Self>) -> (mask8x32<Self>, mask8x32<Self>) {
        let mut b0 = [0; 32usize];
        let mut b1 = [0; 32usize];
        b0.copy_from_slice(&a.val[0..32usize]);
        b1.copy_from_slice(&a.val[32usize..64usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i16x32(self, a: i16) -> i16x32<Self> {
        let half = self.splat_i16x16(a);
        self.combine_i16x16(half, half)
    }
    #[inline(always)]
    fn not_i16x32(self, a: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.not_i16x16(a0), self.not_i16x16(a1))
    }
    #[inline(always)]
    fn add_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.add_i16x16(a0, b0), self.add_i16x16(a1, b1))
    }
    #[inline(always)]
    fn sub_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.sub_i16x16(a0, b0), self.sub_i16x16(a1, b1))
    }
    #[inline(always)]
    fn mul_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.mul_i16x16(a0, b0), self.mul_i16x16(a1, b1))
    }
    #[inline(always)]
    fn and_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.and_i16x16(a0, b0), self.and_i16x16(a1, b1))
    }
    #[inline(always)]
    fn or_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.or_i16x16(a0, b0), self.or_i16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.xor_i16x16(a0, b0), self.xor_i16x16(a1, b1))
    }
    #[inline(always)]
    fn shr_i16x32(self, a: i16x32<Self>, b: u32) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.shr_i16x16(a0, b), self.shr_i16x16(a1, b))
    }
    #[inline(always)]
    fn shrv_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.shrv_i16x16(a0, b0), self.shrv_i16x16(a1, b1))
    }
    #[inline(always)]
    fn shl_i16x32(self, a: i16x32<Self>, b: u32) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.shl_i16x16(a0, b), self.shl_i16x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_eq_i16x16(a0, b0), self.simd_eq_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_lt_i16x16(a0, b0), self.simd_lt_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_le_i16x16(a0, b0), self.simd_le_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_ge_i16x16(a0, b0), self.simd_ge_i16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_mask16x16(self.simd_gt_i16x16(a0, b0), self.simd_gt_i16x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, _) = self.split_i16x32(a);
        let (b0, _) = self.split_i16x32(b);
        self.combine_i16x16(self.zip_low_i16x16(a0, b0), self.zip_high_i16x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (_, a1) = self.split_i16x32(a);
        let (_, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.zip_low_i16x16(a1, b1), self.zip_high_i16x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.unzip_low_i16x16(a0, a1), self.unzip_low_i16x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(
            self.unzip_high_i16x16(a0, a1),
            self.unzip_high_i16x16(b0, b1),
        )
    }
    #[inline(always)]
    fn select_i16x32(self, a: mask16x32<Self>, b: i16x32<Self>, c: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        let (c0, c1) = self.split_i16x32(c);
        self.combine_i16x16(
            self.select_i16x16(a0, b0, c0),
            self.select_i16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn min_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.min_i16x16(a0, b0), self.min_i16x16(a1, b1))
    }
    #[inline(always)]
    fn max_i16x32(self, a: i16x32<Self>, b: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        let (b0, b1) = self.split_i16x32(b);
        self.combine_i16x16(self.max_i16x16(a0, b0), self.max_i16x16(a1, b1))
    }
    #[inline(always)]
    fn split_i16x32(self, a: i16x32<Self>) -> (i16x16<Self>, i16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i16x32(self, a: i16x32<Self>) -> i16x32<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_i16x16(self.neg_i16x16(a0), self.neg_i16x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i16x32(self, a: i16x32<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_u8x32(
            self.reinterpret_u8_i16x16(a0),
            self.reinterpret_u8_i16x16(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u32_i16x32(self, a: i16x32<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i16x32(a);
        self.combine_u32x8(
            self.reinterpret_u32_i16x16(a0),
            self.reinterpret_u32_i16x16(a1),
        )
    }
    #[inline(always)]
    fn splat_u16x32(self, a: u16) -> u16x32<Self> {
        let half = self.splat_u16x16(a);
        self.combine_u16x16(half, half)
    }
    #[inline(always)]
    fn not_u16x32(self, a: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.not_u16x16(a0), self.not_u16x16(a1))
    }
    #[inline(always)]
    fn add_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.add_u16x16(a0, b0), self.add_u16x16(a1, b1))
    }
    #[inline(always)]
    fn sub_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.sub_u16x16(a0, b0), self.sub_u16x16(a1, b1))
    }
    #[inline(always)]
    fn mul_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.mul_u16x16(a0, b0), self.mul_u16x16(a1, b1))
    }
    #[inline(always)]
    fn and_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.and_u16x16(a0, b0), self.and_u16x16(a1, b1))
    }
    #[inline(always)]
    fn or_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.or_u16x16(a0, b0), self.or_u16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.xor_u16x16(a0, b0), self.xor_u16x16(a1, b1))
    }
    #[inline(always)]
    fn shr_u16x32(self, a: u16x32<Self>, b: u32) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.shr_u16x16(a0, b), self.shr_u16x16(a1, b))
    }
    #[inline(always)]
    fn shrv_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.shrv_u16x16(a0, b0), self.shrv_u16x16(a1, b1))
    }
    #[inline(always)]
    fn shl_u16x32(self, a: u16x32<Self>, b: u32) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u16x16(self.shl_u16x16(a0, b), self.shl_u16x16(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_eq_u16x16(a0, b0), self.simd_eq_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_lt_u16x16(a0, b0), self.simd_lt_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_le_u16x16(a0, b0), self.simd_le_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_ge_u16x16(a0, b0), self.simd_ge_u16x16(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_mask16x16(self.simd_gt_u16x16(a0, b0), self.simd_gt_u16x16(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, _) = self.split_u16x32(a);
        let (b0, _) = self.split_u16x32(b);
        self.combine_u16x16(self.zip_low_u16x16(a0, b0), self.zip_high_u16x16(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (_, a1) = self.split_u16x32(a);
        let (_, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.zip_low_u16x16(a1, b1), self.zip_high_u16x16(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.unzip_low_u16x16(a0, a1), self.unzip_low_u16x16(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(
            self.unzip_high_u16x16(a0, a1),
            self.unzip_high_u16x16(b0, b1),
        )
    }
    #[inline(always)]
    fn select_u16x32(self, a: mask16x32<Self>, b: u16x32<Self>, c: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        let (c0, c1) = self.split_u16x32(c);
        self.combine_u16x16(
            self.select_u16x16(a0, b0, c0),
            self.select_u16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn min_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.min_u16x16(a0, b0), self.min_u16x16(a1, b1))
    }
    #[inline(always)]
    fn max_u16x32(self, a: u16x32<Self>, b: u16x32<Self>) -> u16x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        let (b0, b1) = self.split_u16x32(b);
        self.combine_u16x16(self.max_u16x16(a0, b0), self.max_u16x16(a1, b1))
    }
    #[inline(always)]
    fn split_u16x32(self, a: u16x32<Self>) -> (u16x16<Self>, u16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u16x32(self, src: &[u16; 32usize]) -> u16x32<Self> {
        crate::Fallback::new()
            .load_interleaved_128_u16x32(src)
            .val
            .simd_into(self)
    }
    #[inline(always)]
    fn store_interleaved_128_u16x32(self, a: u16x32<Self>, dest: &mut [u16; 32usize]) -> () {
        let fb = crate::Fallback::new();
        fb.store_interleaved_128_u16x32(a.val.simd_into(fb), dest);
    }
    #[inline(always)]
    fn narrow_u16x32(self, a: u16x32<Self>) -> u8x32<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u8x16(self.narrow_u16x16(a0), self.narrow_u16x16(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_u16x32(self, a: u16x32<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u8x32(
            self.reinterpret_u8_u16x16(a0),
            self.reinterpret_u8_u16x16(a1),
        )
    }
    #[inline(always)]
    fn reinterpret_u32_u16x32(self, a: u16x32<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u16x32(a);
        self.combine_u32x8(
            self.reinterpret_u32_u16x16(a0),
            self.reinterpret_u32_u16x16(a1),
        )
    }
    #[inline(always)]
    fn splat_mask16x32(self, a: i16) -> mask16x32<Self> {
        let half = self.splat_mask16x16(a);
        self.combine_mask16x16(half, half)
    }
    #[inline(always)]
    fn not_mask16x32(self, a: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        self.combine_mask16x16(self.not_mask16x16(a0), self.not_mask16x16(a1))
    }
    #[inline(always)]
    fn and_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.and_mask16x16(a0, b0), self.and_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn or_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.or_mask16x16(a0, b0), self.or_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn xor_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(self.xor_mask16x16(a0, b0), self.xor_mask16x16(a1, b1))
    }
    #[inline(always)]
    fn select_mask16x32(
        self,
        a: mask16x32<Self>,
        b: mask16x32<Self>,
        c: mask16x32<Self>,
    ) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        let (c0, c1) = self.split_mask16x32(c);
        self.combine_mask16x16(
            self.select_mask16x16(a0, b0, c0),
            self.select_mask16x16(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask16x32(self, a: mask16x32<Self>, b: mask16x32<Self>) -> mask16x32<Self> {
        let (a0, a1) = self.split_mask16x32(a);
        let (b0, b1) = self.split_mask16x32(b);
        self.combine_mask16x16(
            self.simd_eq_mask16x16(a0, b0),
            self.simd_eq_mask16x16(a1, b1),
        )
    }
    #[inline(always)]
    fn split_mask16x32(self, a: mask16x32<Self>) -> (mask16x16<Self>, mask16x16<Self>) {
        let mut b0 = [0; 16usize];
        let mut b1 = [0; 16usize];
        b0.copy_from_slice(&a.val[0..16usize]);
        b1.copy_from_slice(&a.val[16usize..32usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_i32x16(self, a: i32) -> i32x16<Self> {
        let half = self.splat_i32x8(a);
        self.combine_i32x8(half, half)
    }
    #[inline(always)]
    fn not_i32x16(self, a: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.not_i32x8(a0), self.not_i32x8(a1))
    }
    #[inline(always)]
    fn add_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.add_i32x8(a0, b0), self.add_i32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.sub_i32x8(a0, b0), self.sub_i32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.mul_i32x8(a0, b0), self.mul_i32x8(a1, b1))
    }
    #[inline(always)]
    fn and_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.and_i32x8(a0, b0), self.and_i32x8(a1, b1))
    }
    #[inline(always)]
    fn or_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.or_i32x8(a0, b0), self.or_i32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.xor_i32x8(a0, b0), self.xor_i32x8(a1, b1))
    }
    #[inline(always)]
    fn shr_i32x16(self, a: i32x16<Self>, b: u32) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.shr_i32x8(a0, b), self.shr_i32x8(a1, b))
    }
    #[inline(always)]
    fn shrv_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.shrv_i32x8(a0, b0), self.shrv_i32x8(a1, b1))
    }
    #[inline(always)]
    fn shl_i32x16(self, a: i32x16<Self>, b: u32) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.shl_i32x8(a0, b), self.shl_i32x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_eq_i32x8(a0, b0), self.simd_eq_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_lt_i32x8(a0, b0), self.simd_lt_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_le_i32x8(a0, b0), self.simd_le_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_ge_i32x8(a0, b0), self.simd_ge_i32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_mask32x8(self.simd_gt_i32x8(a0, b0), self.simd_gt_i32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, _) = self.split_i32x16(a);
        let (b0, _) = self.split_i32x16(b);
        self.combine_i32x8(self.zip_low_i32x8(a0, b0), self.zip_high_i32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (_, a1) = self.split_i32x16(a);
        let (_, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.zip_low_i32x8(a1, b1), self.zip_high_i32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.unzip_low_i32x8(a0, a1), self.unzip_low_i32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.unzip_high_i32x8(a0, a1), self.unzip_high_i32x8(b0, b1))
    }
    #[inline(always)]
    fn select_i32x16(self, a: mask32x16<Self>, b: i32x16<Self>, c: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        let (c0, c1) = self.split_i32x16(c);
        self.combine_i32x8(self.select_i32x8(a0, b0, c0), self.select_i32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.min_i32x8(a0, b0), self.min_i32x8(a1, b1))
    }
    #[inline(always)]
    fn max_i32x16(self, a: i32x16<Self>, b: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        let (b0, b1) = self.split_i32x16(b);
        self.combine_i32x8(self.max_i32x8(a0, b0), self.max_i32x8(a1, b1))
    }
    #[inline(always)]
    fn split_i32x16(self, a: i32x16<Self>) -> (i32x8<Self>, i32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn neg_i32x16(self, a: i32x16<Self>) -> i32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_i32x8(self.neg_i32x8(a0), self.neg_i32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u8_i32x16(self, a: i32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_u8x32(self.reinterpret_u8_i32x8(a0), self.reinterpret_u8_i32x8(a1))
    }
    #[inline(always)]
    fn reinterpret_u32_i32x16(self, a: i32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_u32x8(
            self.reinterpret_u32_i32x8(a0),
            self.reinterpret_u32_i32x8(a1),
        )
    }
    #[inline(always)]
    fn cvt_f32_i32x16(self, a: i32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_i32x16(a);
        self.combine_f32x8(self.cvt_f32_i32x8(a0), self.cvt_f32_i32x8(a1))
    }
    #[inline(always)]
    fn splat_u32x16(self, a: u32) -> u32x16<Self> {
        let half = self.splat_u32x8(a);
        self.combine_u32x8(half, half)
    }
    #[inline(always)]
    fn not_u32x16(self, a: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.not_u32x8(a0), self.not_u32x8(a1))
    }
    #[inline(always)]
    fn add_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.add_u32x8(a0, b0), self.add_u32x8(a1, b1))
    }
    #[inline(always)]
    fn sub_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.sub_u32x8(a0, b0), self.sub_u32x8(a1, b1))
    }
    #[inline(always)]
    fn mul_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.mul_u32x8(a0, b0), self.mul_u32x8(a1, b1))
    }
    #[inline(always)]
    fn and_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.and_u32x8(a0, b0), self.and_u32x8(a1, b1))
    }
    #[inline(always)]
    fn or_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.or_u32x8(a0, b0), self.or_u32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.xor_u32x8(a0, b0), self.xor_u32x8(a1, b1))
    }
    #[inline(always)]
    fn shr_u32x16(self, a: u32x16<Self>, b: u32) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.shr_u32x8(a0, b), self.shr_u32x8(a1, b))
    }
    #[inline(always)]
    fn shrv_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.shrv_u32x8(a0, b0), self.shrv_u32x8(a1, b1))
    }
    #[inline(always)]
    fn shl_u32x16(self, a: u32x16<Self>, b: u32) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u32x8(self.shl_u32x8(a0, b), self.shl_u32x8(a1, b))
    }
    #[inline(always)]
    fn simd_eq_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_eq_u32x8(a0, b0), self.simd_eq_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_lt_u32x8(a0, b0), self.simd_lt_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_le_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_le_u32x8(a0, b0), self.simd_le_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_ge_u32x8(a0, b0), self.simd_ge_u32x8(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_mask32x8(self.simd_gt_u32x8(a0, b0), self.simd_gt_u32x8(a1, b1))
    }
    #[inline(always)]
    fn zip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, _) = self.split_u32x16(a);
        let (b0, _) = self.split_u32x16(b);
        self.combine_u32x8(self.zip_low_u32x8(a0, b0), self.zip_high_u32x8(a0, b0))
    }
    #[inline(always)]
    fn zip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (_, a1) = self.split_u32x16(a);
        let (_, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.zip_low_u32x8(a1, b1), self.zip_high_u32x8(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.unzip_low_u32x8(a0, a1), self.unzip_low_u32x8(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.unzip_high_u32x8(a0, a1), self.unzip_high_u32x8(b0, b1))
    }
    #[inline(always)]
    fn select_u32x16(self, a: mask32x16<Self>, b: u32x16<Self>, c: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        let (c0, c1) = self.split_u32x16(c);
        self.combine_u32x8(self.select_u32x8(a0, b0, c0), self.select_u32x8(a1, b1, c1))
    }
    #[inline(always)]
    fn min_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.min_u32x8(a0, b0), self.min_u32x8(a1, b1))
    }
    #[inline(always)]
    fn max_u32x16(self, a: u32x16<Self>, b: u32x16<Self>) -> u32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        let (b0, b1) = self.split_u32x16(b);
        self.combine_u32x8(self.max_u32x8(a0, b0), self.max_u32x8(a1, b1))
    }
    #[inline(always)]
    fn split_u32x16(self, a: u32x16<Self>) -> (u32x8<Self>, u32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn load_interleaved_128_u32x16(self, src: &[u32; 16usize]) -> u32x16<Self> {
        unsafe {
            let v0 = _mm_loadu_si128(src.as_ptr().add(0) as *const __m128i);
            let v1 = _mm_loadu_si128(src.as_ptr().add(4) as *const __m128i);
            let v2 = _mm_loadu_si128(src.as_ptr().add(8) as *const __m128i);
            let v3 = _mm_loadu_si128(src.as_ptr().add(12) as *const __m128i);
            let tmp0 = _mm_unpacklo_epi32(v0, v1);
            let tmp1 = _mm_unpackhi_epi32(v0, v1);
            let tmp2 = _mm_unpacklo_epi32(v2, v3);
            let tmp3 = _mm_unpackhi_epi32(v2, v3);
            let out0 = _mm_unpacklo_epi64(tmp0, tmp2);
            let out1 = _mm_unpackhi_epi64(tmp0, tmp2);
            let out2 = _mm_unpacklo_epi64(tmp1, tmp3);
            let out3 = _mm_unpackhi_epi64(tmp1, tmp3);
            self.combine_u32x8(
                self.combine_u32x4(out0.simd_into(self), out1.simd_into(self)),
                self.combine_u32x4(out2.simd_into(self), out3.simd_into(self)),
            )
        }
    }
    #[inline(always)]
    fn store_interleaved_128_u32x16(self, a: u32x16<Self>, dest: &mut [u32; 16usize]) -> () {
        let fb = crate::Fallback::new();
        fb.store_interleaved_128_u32x16(a.val.simd_into(fb), dest);
    }
    #[inline(always)]
    fn reinterpret_u8_u32x16(self, a: u32x16<Self>) -> u8x64<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_u8x32(self.reinterpret_u8_u32x8(a0), self.reinterpret_u8_u32x8(a1))
    }
    #[inline(always)]
    fn cvt_f32_u32x16(self, a: u32x16<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_u32x16(a);
        self.combine_f32x8(self.cvt_f32_u32x8(a0), self.cvt_f32_u32x8(a1))
    }
    #[inline(always)]
    fn splat_mask32x16(self, a: i32) -> mask32x16<Self> {
        let half = self.splat_mask32x8(a);
        self.combine_mask32x8(half, half)
    }
    #[inline(always)]
    fn not_mask32x16(self, a: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        self.combine_mask32x8(self.not_mask32x8(a0), self.not_mask32x8(a1))
    }
    #[inline(always)]
    fn and_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.and_mask32x8(a0, b0), self.and_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn or_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.or_mask32x8(a0, b0), self.or_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn xor_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.xor_mask32x8(a0, b0), self.xor_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn select_mask32x16(
        self,
        a: mask32x16<Self>,
        b: mask32x16<Self>,
        c: mask32x16<Self>,
    ) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        let (c0, c1) = self.split_mask32x16(c);
        self.combine_mask32x8(
            self.select_mask32x8(a0, b0, c0),
            self.select_mask32x8(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask32x16(self, a: mask32x16<Self>, b: mask32x16<Self>) -> mask32x16<Self> {
        let (a0, a1) = self.split_mask32x16(a);
        let (b0, b1) = self.split_mask32x16(b);
        self.combine_mask32x8(self.simd_eq_mask32x8(a0, b0), self.simd_eq_mask32x8(a1, b1))
    }
    #[inline(always)]
    fn split_mask32x16(self, a: mask32x16<Self>) -> (mask32x8<Self>, mask32x8<Self>) {
        let mut b0 = [0; 8usize];
        let mut b1 = [0; 8usize];
        b0.copy_from_slice(&a.val[0..8usize]);
        b1.copy_from_slice(&a.val[8usize..16usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn splat_f64x8(self, a: f64) -> f64x8<Self> {
        let half = self.splat_f64x4(a);
        self.combine_f64x4(half, half)
    }
    #[inline(always)]
    fn abs_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.abs_f64x4(a0), self.abs_f64x4(a1))
    }
    #[inline(always)]
    fn neg_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.neg_f64x4(a0), self.neg_f64x4(a1))
    }
    #[inline(always)]
    fn sqrt_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.sqrt_f64x4(a0), self.sqrt_f64x4(a1))
    }
    #[inline(always)]
    fn add_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.add_f64x4(a0, b0), self.add_f64x4(a1, b1))
    }
    #[inline(always)]
    fn sub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.sub_f64x4(a0, b0), self.sub_f64x4(a1, b1))
    }
    #[inline(always)]
    fn mul_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.mul_f64x4(a0, b0), self.mul_f64x4(a1, b1))
    }
    #[inline(always)]
    fn div_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.div_f64x4(a0, b0), self.div_f64x4(a1, b1))
    }
    #[inline(always)]
    fn copysign_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.copysign_f64x4(a0, b0), self.copysign_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_eq_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_eq_f64x4(a0, b0), self.simd_eq_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_lt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_lt_f64x4(a0, b0), self.simd_lt_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_le_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_le_f64x4(a0, b0), self.simd_le_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_ge_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_ge_f64x4(a0, b0), self.simd_ge_f64x4(a1, b1))
    }
    #[inline(always)]
    fn simd_gt_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_mask64x4(self.simd_gt_f64x4(a0, b0), self.simd_gt_f64x4(a1, b1))
    }
    #[inline(always)]
    fn zip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, _) = self.split_f64x8(a);
        let (b0, _) = self.split_f64x8(b);
        self.combine_f64x4(self.zip_low_f64x4(a0, b0), self.zip_high_f64x4(a0, b0))
    }
    #[inline(always)]
    fn zip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (_, a1) = self.split_f64x8(a);
        let (_, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.zip_low_f64x4(a1, b1), self.zip_high_f64x4(a1, b1))
    }
    #[inline(always)]
    fn unzip_low_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.unzip_low_f64x4(a0, a1), self.unzip_low_f64x4(b0, b1))
    }
    #[inline(always)]
    fn unzip_high_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.unzip_high_f64x4(a0, a1), self.unzip_high_f64x4(b0, b1))
    }
    #[inline(always)]
    fn max_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.max_f64x4(a0, b0), self.max_f64x4(a1, b1))
    }
    #[inline(always)]
    fn max_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(
            self.max_precise_f64x4(a0, b0),
            self.max_precise_f64x4(a1, b1),
        )
    }
    #[inline(always)]
    fn min_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(self.min_f64x4(a0, b0), self.min_f64x4(a1, b1))
    }
    #[inline(always)]
    fn min_precise_f64x8(self, a: f64x8<Self>, b: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        self.combine_f64x4(
            self.min_precise_f64x4(a0, b0),
            self.min_precise_f64x4(a1, b1),
        )
    }
    #[inline(always)]
    fn madd_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.madd_f64x4(a0, b0, c0), self.madd_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn msub_f64x8(self, a: f64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.msub_f64x4(a0, b0, c0), self.msub_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn floor_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.floor_f64x4(a0), self.floor_f64x4(a1))
    }
    #[inline(always)]
    fn fract_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.fract_f64x4(a0), self.fract_f64x4(a1))
    }
    #[inline(always)]
    fn trunc_f64x8(self, a: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f64x4(self.trunc_f64x4(a0), self.trunc_f64x4(a1))
    }
    #[inline(always)]
    fn select_f64x8(self, a: mask64x8<Self>, b: f64x8<Self>, c: f64x8<Self>) -> f64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_f64x8(b);
        let (c0, c1) = self.split_f64x8(c);
        self.combine_f64x4(self.select_f64x4(a0, b0, c0), self.select_f64x4(a1, b1, c1))
    }
    #[inline(always)]
    fn split_f64x8(self, a: f64x8<Self>) -> (f64x4<Self>, f64x4<Self>) {
        let mut b0 = [0.0; 4usize];
        let mut b1 = [0.0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
    #[inline(always)]
    fn reinterpret_f32_f64x8(self, a: f64x8<Self>) -> f32x16<Self> {
        let (a0, a1) = self.split_f64x8(a);
        self.combine_f32x8(
            self.reinterpret_f32_f64x4(a0),
            self.reinterpret_f32_f64x4(a1),
        )
    }
    #[inline(always)]
    fn splat_mask64x8(self, a: i64) -> mask64x8<Self> {
        let half = self.splat_mask64x4(a);
        self.combine_mask64x4(half, half)
    }
    #[inline(always)]
    fn not_mask64x8(self, a: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        self.combine_mask64x4(self.not_mask64x4(a0), self.not_mask64x4(a1))
    }
    #[inline(always)]
    fn and_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.and_mask64x4(a0, b0), self.and_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn or_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.or_mask64x4(a0, b0), self.or_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn xor_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.xor_mask64x4(a0, b0), self.xor_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn select_mask64x8(
        self,
        a: mask64x8<Self>,
        b: mask64x8<Self>,
        c: mask64x8<Self>,
    ) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        let (c0, c1) = self.split_mask64x8(c);
        self.combine_mask64x4(
            self.select_mask64x4(a0, b0, c0),
            self.select_mask64x4(a1, b1, c1),
        )
    }
    #[inline(always)]
    fn simd_eq_mask64x8(self, a: mask64x8<Self>, b: mask64x8<Self>) -> mask64x8<Self> {
        let (a0, a1) = self.split_mask64x8(a);
        let (b0, b1) = self.split_mask64x8(b);
        self.combine_mask64x4(self.simd_eq_mask64x4(a0, b0), self.simd_eq_mask64x4(a1, b1))
    }
    #[inline(always)]
    fn split_mask64x8(self, a: mask64x8<Self>) -> (mask64x4<Self>, mask64x4<Self>) {
        let mut b0 = [0; 4usize];
        let mut b1 = [0; 4usize];
        b0.copy_from_slice(&a.val[0..4usize]);
        b1.copy_from_slice(&a.val[4usize..8usize]);
        (b0.simd_into(self), b1.simd_into(self))
    }
}
impl<S: Simd> SimdFrom<__m128, S> for f32x4<S> {
    #[inline(always)]
    fn simd_from(arch: __m128, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f32x4<S>> for __m128 {
    #[inline(always)]
    fn from(value: f32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for i8x16<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i8x16<S>> for __m128i {
    #[inline(always)]
    fn from(value: i8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for u8x16<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u8x16<S>> for __m128i {
    #[inline(always)]
    fn from(value: u8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for mask8x16<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask8x16<S>> for __m128i {
    #[inline(always)]
    fn from(value: mask8x16<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for i16x8<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i16x8<S>> for __m128i {
    #[inline(always)]
    fn from(value: i16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for u16x8<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u16x8<S>> for __m128i {
    #[inline(always)]
    fn from(value: u16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for mask16x8<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask16x8<S>> for __m128i {
    #[inline(always)]
    fn from(value: mask16x8<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for i32x4<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<i32x4<S>> for __m128i {
    #[inline(always)]
    fn from(value: i32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for u32x4<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<u32x4<S>> for __m128i {
    #[inline(always)]
    fn from(value: u32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for mask32x4<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask32x4<S>> for __m128i {
    #[inline(always)]
    fn from(value: mask32x4<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128d, S> for f64x2<S> {
    #[inline(always)]
    fn simd_from(arch: __m128d, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<f64x2<S>> for __m128d {
    #[inline(always)]
    fn from(value: f64x2<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
impl<S: Simd> SimdFrom<__m128i, S> for mask64x2<S> {
    #[inline(always)]
    fn simd_from(arch: __m128i, simd: S) -> Self {
        Self {
            val: unsafe { core::mem::transmute(arch) },
            simd,
        }
    }
}
impl<S: Simd> From<mask64x2<S>> for __m128i {
    #[inline(always)]
    fn from(value: mask64x2<S>) -> Self {
        unsafe { core::mem::transmute(value.val) }
    }
}
