// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(ldr)                       \
  M(ldrb)                      \
  M(str)                       \
  M(strb)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  Register rm;
  ShiftType shift;
  uint32_t amount;
  AddrMode addr_mode;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{pl, r8, r11, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "pl r8 r11 plus r6 LSL 1 Offset",
                            "pl_r8_r11_plus_r6_LSL_1_Offset"},
                           {{le, r4, r8, plus, r5, LSL, 1, Offset},
                            false,
                            al,
                            "le r4 r8 plus r5 LSL 1 Offset",
                            "le_r4_r8_plus_r5_LSL_1_Offset"},
                           {{vs, r2, r6, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "vs r2 r6 plus r14 LSL 1 Offset",
                            "vs_r2_r6_plus_r14_LSL_1_Offset"},
                           {{ls, r1, r7, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "ls r1 r7 plus r8 LSL 1 Offset",
                            "ls_r1_r7_plus_r8_LSL_1_Offset"},
                           {{ge, r14, r6, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "ge r14 r6 plus r14 LSL 1 Offset",
                            "ge_r14_r6_plus_r14_LSL_1_Offset"},
                           {{cs, r7, r0, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "cs r7 r0 plus r7 LSL 1 Offset",
                            "cs_r7_r0_plus_r7_LSL_1_Offset"},
                           {{ge, r11, r0, plus, r9, LSL, 1, Offset},
                            false,
                            al,
                            "ge r11 r0 plus r9 LSL 1 Offset",
                            "ge_r11_r0_plus_r9_LSL_1_Offset"},
                           {{eq, r7, r10, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "eq r7 r10 plus r4 LSL 1 Offset",
                            "eq_r7_r10_plus_r4_LSL_1_Offset"},
                           {{al, r9, r2, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "al r9 r2 plus r3 LSL 1 Offset",
                            "al_r9_r2_plus_r3_LSL_1_Offset"},
                           {{cc, r11, r10, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "cc r11 r10 plus r6 LSL 1 Offset",
                            "cc_r11_r10_plus_r6_LSL_1_Offset"},
                           {{lt, r9, r6, plus, r1, LSL, 1, Offset},
                            false,
                            al,
                            "lt r9 r6 plus r1 LSL 1 Offset",
                            "lt_r9_r6_plus_r1_LSL_1_Offset"},
                           {{ge, r4, r0, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "ge r4 r0 plus r4 LSL 1 Offset",
                            "ge_r4_r0_plus_r4_LSL_1_Offset"},
                           {{al, r9, r13, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "al r9 r13 plus r14 LSL 1 Offset",
                            "al_r9_r13_plus_r14_LSL_1_Offset"},
                           {{cc, r9, r0, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "cc r9 r0 plus r7 LSL 1 Offset",
                            "cc_r9_r0_plus_r7_LSL_1_Offset"},
                           {{cs, r11, r7, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "cs r11 r7 plus r8 LSL 1 Offset",
                            "cs_r11_r7_plus_r8_LSL_1_Offset"},
                           {{eq, r8, r0, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "eq r8 r0 plus r8 LSL 1 Offset",
                            "eq_r8_r0_plus_r8_LSL_1_Offset"},
                           {{hi, r9, r10, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "hi r9 r10 plus r8 LSL 1 Offset",
                            "hi_r9_r10_plus_r8_LSL_1_Offset"},
                           {{le, r8, r0, plus, r0, LSL, 1, Offset},
                            false,
                            al,
                            "le r8 r0 plus r0 LSL 1 Offset",
                            "le_r8_r0_plus_r0_LSL_1_Offset"},
                           {{cs, r4, r5, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "cs r4 r5 plus r2 LSL 1 Offset",
                            "cs_r4_r5_plus_r2_LSL_1_Offset"},
                           {{eq, r14, r11, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "eq r14 r11 plus r8 LSL 1 Offset",
                            "eq_r14_r11_plus_r8_LSL_1_Offset"},
                           {{cs, r7, r6, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "cs r7 r6 plus r14 LSL 1 Offset",
                            "cs_r7_r6_plus_r14_LSL_1_Offset"},
                           {{ne, r0, r9, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "ne r0 r9 plus r7 LSL 1 Offset",
                            "ne_r0_r9_plus_r7_LSL_1_Offset"},
                           {{le, r7, r3, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "le r7 r3 plus r11 LSL 1 Offset",
                            "le_r7_r3_plus_r11_LSL_1_Offset"},
                           {{gt, r7, r9, plus, r9, LSL, 1, Offset},
                            false,
                            al,
                            "gt r7 r9 plus r9 LSL 1 Offset",
                            "gt_r7_r9_plus_r9_LSL_1_Offset"},
                           {{le, r9, r12, plus, r9, LSL, 1, Offset},
                            false,
                            al,
                            "le r9 r12 plus r9 LSL 1 Offset",
                            "le_r9_r12_plus_r9_LSL_1_Offset"},
                           {{pl, r2, r11, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "pl r2 r11 plus r14 LSL 1 Offset",
                            "pl_r2_r11_plus_r14_LSL_1_Offset"},
                           {{cs, r1, r7, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "cs r1 r7 plus r2 LSL 1 Offset",
                            "cs_r1_r7_plus_r2_LSL_1_Offset"},
                           {{al, r5, r1, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "al r5 r1 plus r12 LSL 1 Offset",
                            "al_r5_r1_plus_r12_LSL_1_Offset"},
                           {{eq, r10, r13, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "eq r10 r13 plus r12 LSL 1 Offset",
                            "eq_r10_r13_plus_r12_LSL_1_Offset"},
                           {{eq, r10, r11, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "eq r10 r11 plus r3 LSL 1 Offset",
                            "eq_r10_r11_plus_r3_LSL_1_Offset"},
                           {{al, r9, r12, plus, r0, LSL, 1, Offset},
                            false,
                            al,
                            "al r9 r12 plus r0 LSL 1 Offset",
                            "al_r9_r12_plus_r0_LSL_1_Offset"},
                           {{ls, r3, r14, plus, r1, LSL, 1, Offset},
                            false,
                            al,
                            "ls r3 r14 plus r1 LSL 1 Offset",
                            "ls_r3_r14_plus_r1_LSL_1_Offset"},
                           {{le, r13, r4, plus, r9, LSL, 1, Offset},
                            false,
                            al,
                            "le r13 r4 plus r9 LSL 1 Offset",
                            "le_r13_r4_plus_r9_LSL_1_Offset"},
                           {{ls, r3, r14, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "ls r3 r14 plus r3 LSL 1 Offset",
                            "ls_r3_r14_plus_r3_LSL_1_Offset"},
                           {{cc, r7, r4, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "cc r7 r4 plus r4 LSL 1 Offset",
                            "cc_r7_r4_plus_r4_LSL_1_Offset"},
                           {{ls, r5, r9, plus, r5, LSL, 1, Offset},
                            false,
                            al,
                            "ls r5 r9 plus r5 LSL 1 Offset",
                            "ls_r5_r9_plus_r5_LSL_1_Offset"},
                           {{ge, r6, r4, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "ge r6 r4 plus r13 LSL 1 Offset",
                            "ge_r6_r4_plus_r13_LSL_1_Offset"},
                           {{al, r1, r11, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "al r1 r11 plus r12 LSL 1 Offset",
                            "al_r1_r11_plus_r12_LSL_1_Offset"},
                           {{le, r6, r11, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "le r6 r11 plus r3 LSL 1 Offset",
                            "le_r6_r11_plus_r3_LSL_1_Offset"},
                           {{al, r6, r6, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "al r6 r6 plus r13 LSL 1 Offset",
                            "al_r6_r6_plus_r13_LSL_1_Offset"},
                           {{gt, r14, r11, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "gt r14 r11 plus r2 LSL 1 Offset",
                            "gt_r14_r11_plus_r2_LSL_1_Offset"},
                           {{vs, r5, r8, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "vs r5 r8 plus r12 LSL 1 Offset",
                            "vs_r5_r8_plus_r12_LSL_1_Offset"},
                           {{ls, r8, r12, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "ls r8 r12 plus r6 LSL 1 Offset",
                            "ls_r8_r12_plus_r6_LSL_1_Offset"},
                           {{vs, r6, r12, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "vs r6 r12 plus r14 LSL 1 Offset",
                            "vs_r6_r12_plus_r14_LSL_1_Offset"},
                           {{pl, r7, r2, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "pl r7 r2 plus r7 LSL 1 Offset",
                            "pl_r7_r2_plus_r7_LSL_1_Offset"},
                           {{gt, r5, r4, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "gt r5 r4 plus r13 LSL 1 Offset",
                            "gt_r5_r4_plus_r13_LSL_1_Offset"},
                           {{hi, r2, r7, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "hi r2 r7 plus r12 LSL 1 Offset",
                            "hi_r2_r7_plus_r12_LSL_1_Offset"},
                           {{ne, r2, r3, plus, r10, LSL, 1, Offset},
                            false,
                            al,
                            "ne r2 r3 plus r10 LSL 1 Offset",
                            "ne_r2_r3_plus_r10_LSL_1_Offset"},
                           {{lt, r13, r2, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "lt r13 r2 plus r6 LSL 1 Offset",
                            "lt_r13_r2_plus_r6_LSL_1_Offset"},
                           {{hi, r14, r10, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "hi r14 r10 plus r11 LSL 1 Offset",
                            "hi_r14_r10_plus_r11_LSL_1_Offset"},
                           {{hi, r7, r10, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "hi r7 r10 plus r12 LSL 1 Offset",
                            "hi_r7_r10_plus_r12_LSL_1_Offset"},
                           {{cs, r3, r12, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "cs r3 r12 plus r2 LSL 1 Offset",
                            "cs_r3_r12_plus_r2_LSL_1_Offset"},
                           {{ls, r11, r5, plus, r1, LSL, 1, Offset},
                            false,
                            al,
                            "ls r11 r5 plus r1 LSL 1 Offset",
                            "ls_r11_r5_plus_r1_LSL_1_Offset"},
                           {{hi, r5, r2, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "hi r5 r2 plus r11 LSL 1 Offset",
                            "hi_r5_r2_plus_r11_LSL_1_Offset"},
                           {{cc, r11, r8, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "cc r11 r8 plus r6 LSL 1 Offset",
                            "cc_r11_r8_plus_r6_LSL_1_Offset"},
                           {{lt, r11, r3, plus, r9, LSL, 1, Offset},
                            false,
                            al,
                            "lt r11 r3 plus r9 LSL 1 Offset",
                            "lt_r11_r3_plus_r9_LSL_1_Offset"},
                           {{ne, r11, r9, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "ne r11 r9 plus r8 LSL 1 Offset",
                            "ne_r11_r9_plus_r8_LSL_1_Offset"},
                           {{lt, r7, r0, plus, r14, LSL, 1, Offset},
                            false,
                            al,
                            "lt r7 r0 plus r14 LSL 1 Offset",
                            "lt_r7_r0_plus_r14_LSL_1_Offset"},
                           {{ge, r12, r3, plus, r1, LSL, 1, Offset},
                            false,
                            al,
                            "ge r12 r3 plus r1 LSL 1 Offset",
                            "ge_r12_r3_plus_r1_LSL_1_Offset"},
                           {{le, r0, r8, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "le r0 r8 plus r13 LSL 1 Offset",
                            "le_r0_r8_plus_r13_LSL_1_Offset"},
                           {{vc, r5, r13, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "vc r5 r13 plus r7 LSL 1 Offset",
                            "vc_r5_r13_plus_r7_LSL_1_Offset"},
                           {{ge, r7, r5, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "ge r7 r5 plus r11 LSL 1 Offset",
                            "ge_r7_r5_plus_r11_LSL_1_Offset"},
                           {{ge, r10, r9, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "ge r10 r9 plus r3 LSL 1 Offset",
                            "ge_r10_r9_plus_r3_LSL_1_Offset"},
                           {{vs, r9, r5, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "vs r9 r5 plus r2 LSL 1 Offset",
                            "vs_r9_r5_plus_r2_LSL_1_Offset"},
                           {{hi, r2, r10, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "hi r2 r10 plus r4 LSL 1 Offset",
                            "hi_r2_r10_plus_r4_LSL_1_Offset"},
                           {{ge, r1, r11, plus, r1, LSL, 1, Offset},
                            false,
                            al,
                            "ge r1 r11 plus r1 LSL 1 Offset",
                            "ge_r1_r11_plus_r1_LSL_1_Offset"},
                           {{ls, r9, r14, plus, r12, LSL, 1, Offset},
                            false,
                            al,
                            "ls r9 r14 plus r12 LSL 1 Offset",
                            "ls_r9_r14_plus_r12_LSL_1_Offset"},
                           {{mi, r1, r9, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "mi r1 r9 plus r4 LSL 1 Offset",
                            "mi_r1_r9_plus_r4_LSL_1_Offset"},
                           {{mi, r7, r10, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "mi r7 r10 plus r4 LSL 1 Offset",
                            "mi_r7_r10_plus_r4_LSL_1_Offset"},
                           {{gt, r6, r2, plus, r5, LSL, 1, Offset},
                            false,
                            al,
                            "gt r6 r2 plus r5 LSL 1 Offset",
                            "gt_r6_r2_plus_r5_LSL_1_Offset"},
                           {{eq, r10, r8, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "eq r10 r8 plus r11 LSL 1 Offset",
                            "eq_r10_r8_plus_r11_LSL_1_Offset"},
                           {{le, r10, r1, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "le r10 r1 plus r7 LSL 1 Offset",
                            "le_r10_r1_plus_r7_LSL_1_Offset"},
                           {{pl, r8, r14, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "pl r8 r14 plus r8 LSL 1 Offset",
                            "pl_r8_r14_plus_r8_LSL_1_Offset"},
                           {{gt, r5, r1, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "gt r5 r1 plus r3 LSL 1 Offset",
                            "gt_r5_r1_plus_r3_LSL_1_Offset"},
                           {{cs, r10, r4, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "cs r10 r4 plus r13 LSL 1 Offset",
                            "cs_r10_r4_plus_r13_LSL_1_Offset"},
                           {{mi, r10, r5, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "mi r10 r5 plus r2 LSL 1 Offset",
                            "mi_r10_r5_plus_r2_LSL_1_Offset"},
                           {{cc, r6, r0, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "cc r6 r0 plus r11 LSL 1 Offset",
                            "cc_r6_r0_plus_r11_LSL_1_Offset"},
                           {{eq, r3, r9, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "eq r3 r9 plus r2 LSL 1 Offset",
                            "eq_r3_r9_plus_r2_LSL_1_Offset"},
                           {{al, r1, r0, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "al r1 r0 plus r3 LSL 1 Offset",
                            "al_r1_r0_plus_r3_LSL_1_Offset"},
                           {{mi, r1, r0, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "mi r1 r0 plus r13 LSL 1 Offset",
                            "mi_r1_r0_plus_r13_LSL_1_Offset"},
                           {{cc, r4, r4, plus, r5, LSL, 1, Offset},
                            false,
                            al,
                            "cc r4 r4 plus r5 LSL 1 Offset",
                            "cc_r4_r4_plus_r5_LSL_1_Offset"},
                           {{al, r2, r6, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "al r2 r6 plus r11 LSL 1 Offset",
                            "al_r2_r6_plus_r11_LSL_1_Offset"},
                           {{ls, r1, r5, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "ls r1 r5 plus r4 LSL 1 Offset",
                            "ls_r1_r5_plus_r4_LSL_1_Offset"},
                           {{eq, r0, r3, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "eq r0 r3 plus r4 LSL 1 Offset",
                            "eq_r0_r3_plus_r4_LSL_1_Offset"},
                           {{lt, r7, r11, plus, r10, LSL, 1, Offset},
                            false,
                            al,
                            "lt r7 r11 plus r10 LSL 1 Offset",
                            "lt_r7_r11_plus_r10_LSL_1_Offset"},
                           {{vc, r3, r0, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "vc r3 r0 plus r13 LSL 1 Offset",
                            "vc_r3_r0_plus_r13_LSL_1_Offset"},
                           {{ls, r3, r3, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "ls r3 r3 plus r7 LSL 1 Offset",
                            "ls_r3_r3_plus_r7_LSL_1_Offset"},
                           {{al, r5, r14, plus, r3, LSL, 1, Offset},
                            false,
                            al,
                            "al r5 r14 plus r3 LSL 1 Offset",
                            "al_r5_r14_plus_r3_LSL_1_Offset"},
                           {{ne, r2, r13, plus, r9, LSL, 1, Offset},
                            false,
                            al,
                            "ne r2 r13 plus r9 LSL 1 Offset",
                            "ne_r2_r13_plus_r9_LSL_1_Offset"},
                           {{lt, r6, r2, plus, r11, LSL, 1, Offset},
                            false,
                            al,
                            "lt r6 r2 plus r11 LSL 1 Offset",
                            "lt_r6_r2_plus_r11_LSL_1_Offset"},
                           {{vc, r9, r2, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "vc r9 r2 plus r13 LSL 1 Offset",
                            "vc_r9_r2_plus_r13_LSL_1_Offset"},
                           {{ne, r5, r9, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "ne r5 r9 plus r6 LSL 1 Offset",
                            "ne_r5_r9_plus_r6_LSL_1_Offset"},
                           {{vc, r4, r9, plus, r8, LSL, 1, Offset},
                            false,
                            al,
                            "vc r4 r9 plus r8 LSL 1 Offset",
                            "vc_r4_r9_plus_r8_LSL_1_Offset"},
                           {{cc, r6, r9, plus, r2, LSL, 1, Offset},
                            false,
                            al,
                            "cc r6 r9 plus r2 LSL 1 Offset",
                            "cc_r6_r9_plus_r2_LSL_1_Offset"},
                           {{vs, r8, r7, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "vs r8 r7 plus r13 LSL 1 Offset",
                            "vs_r8_r7_plus_r13_LSL_1_Offset"},
                           {{pl, r14, r14, plus, r7, LSL, 1, Offset},
                            false,
                            al,
                            "pl r14 r14 plus r7 LSL 1 Offset",
                            "pl_r14_r14_plus_r7_LSL_1_Offset"},
                           {{eq, r8, r2, plus, r6, LSL, 1, Offset},
                            false,
                            al,
                            "eq r8 r2 plus r6 LSL 1 Offset",
                            "eq_r8_r2_plus_r6_LSL_1_Offset"},
                           {{al, r13, r13, plus, r13, LSL, 1, Offset},
                            false,
                            al,
                            "al r13 r13 plus r13 LSL 1 Offset",
                            "al_r13_r13_plus_r13_LSL_1_Offset"},
                           {{gt, r12, r14, plus, r5, LSL, 1, Offset},
                            false,
                            al,
                            "gt r12 r14 plus r5 LSL 1 Offset",
                            "gt_r12_r14_plus_r5_LSL_1_Offset"},
                           {{lt, r14, r7, plus, r1, LSL, 1, Offset},
                            false,
                            al,
                            "lt r14 r7 plus r1 LSL 1 Offset",
                            "lt_r14_r7_plus_r1_LSL_1_Offset"},
                           {{al, r0, r2, plus, r14, ROR, 9, Offset},
                            false,
                            al,
                            "al r0 r2 plus r14 ROR 9 Offset",
                            "al_r0_r2_plus_r14_ROR_9_Offset"},
                           {{al, r0, r4, plus, r8, LSL, 19, Offset},
                            false,
                            al,
                            "al r0 r4 plus r8 LSL 19 Offset",
                            "al_r0_r4_plus_r8_LSL_19_Offset"},
                           {{al, r0, r13, minus, r1, LSL, 8, Offset},
                            false,
                            al,
                            "al r0 r13 minus r1 LSL 8 Offset",
                            "al_r0_r13_minus_r1_LSL_8_Offset"},
                           {{al, r0, r4, plus, r12, ROR, 13, Offset},
                            false,
                            al,
                            "al r0 r4 plus r12 ROR 13 Offset",
                            "al_r0_r4_plus_r12_ROR_13_Offset"},
                           {{al, r0, r9, minus, r11, LSL, 10, Offset},
                            false,
                            al,
                            "al r0 r9 minus r11 LSL 10 Offset",
                            "al_r0_r9_minus_r11_LSL_10_Offset"},
                           {{al, r0, r7, plus, r0, ROR, 25, Offset},
                            false,
                            al,
                            "al r0 r7 plus r0 ROR 25 Offset",
                            "al_r0_r7_plus_r0_ROR_25_Offset"},
                           {{al, r0, r0, plus, r14, LSL, 9, Offset},
                            false,
                            al,
                            "al r0 r0 plus r14 LSL 9 Offset",
                            "al_r0_r0_plus_r14_LSL_9_Offset"},
                           {{al, r0, r10, plus, r2, LSL, 19, Offset},
                            false,
                            al,
                            "al r0 r10 plus r2 LSL 19 Offset",
                            "al_r0_r10_plus_r2_LSL_19_Offset"},
                           {{al, r0, r14, plus, r4, LSL, 9, Offset},
                            false,
                            al,
                            "al r0 r14 plus r4 LSL 9 Offset",
                            "al_r0_r14_plus_r4_LSL_9_Offset"},
                           {{al, r0, r7, plus, r12, ROR, 11, Offset},
                            false,
                            al,
                            "al r0 r7 plus r12 ROR 11 Offset",
                            "al_r0_r7_plus_r12_ROR_11_Offset"},
                           {{al, r0, r3, minus, r10, LSL, 2, Offset},
                            false,
                            al,
                            "al r0 r3 minus r10 LSL 2 Offset",
                            "al_r0_r3_minus_r10_LSL_2_Offset"},
                           {{al, r0, r7, plus, r12, LSL, 23, Offset},
                            false,
                            al,
                            "al r0 r7 plus r12 LSL 23 Offset",
                            "al_r0_r7_plus_r12_LSL_23_Offset"},
                           {{al, r0, r2, minus, r8, LSL, 25, Offset},
                            false,
                            al,
                            "al r0 r2 minus r8 LSL 25 Offset",
                            "al_r0_r2_minus_r8_LSL_25_Offset"},
                           {{al, r0, r11, plus, r3, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r11 plus r3 LSL 12 Offset",
                            "al_r0_r11_plus_r3_LSL_12_Offset"},
                           {{al, r0, r0, minus, r2, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r0 minus r2 LSL 12 Offset",
                            "al_r0_r0_minus_r2_LSL_12_Offset"},
                           {{al, r0, r8, minus, r7, ROR, 30, Offset},
                            false,
                            al,
                            "al r0 r8 minus r7 ROR 30 Offset",
                            "al_r0_r8_minus_r7_ROR_30_Offset"},
                           {{al, r0, r4, minus, r11, ROR, 19, Offset},
                            false,
                            al,
                            "al r0 r4 minus r11 ROR 19 Offset",
                            "al_r0_r4_minus_r11_ROR_19_Offset"},
                           {{al, r0, r9, minus, r11, ROR, 23, Offset},
                            false,
                            al,
                            "al r0 r9 minus r11 ROR 23 Offset",
                            "al_r0_r9_minus_r11_ROR_23_Offset"},
                           {{al, r0, r12, plus, r12, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r12 plus r12 ROR 28 Offset",
                            "al_r0_r12_plus_r12_ROR_28_Offset"},
                           {{al, r0, r9, plus, r12, ROR, 25, Offset},
                            false,
                            al,
                            "al r0 r9 plus r12 ROR 25 Offset",
                            "al_r0_r9_plus_r12_ROR_25_Offset"},
                           {{al, r0, r6, minus, r5, LSL, 26, Offset},
                            false,
                            al,
                            "al r0 r6 minus r5 LSL 26 Offset",
                            "al_r0_r6_minus_r5_LSL_26_Offset"},
                           {{al, r0, r6, minus, r12, ROR, 24, Offset},
                            false,
                            al,
                            "al r0 r6 minus r12 ROR 24 Offset",
                            "al_r0_r6_minus_r12_ROR_24_Offset"},
                           {{al, r0, r12, minus, r5, ROR, 7, Offset},
                            false,
                            al,
                            "al r0 r12 minus r5 ROR 7 Offset",
                            "al_r0_r12_minus_r5_ROR_7_Offset"},
                           {{al, r0, r0, plus, r7, ROR, 15, Offset},
                            false,
                            al,
                            "al r0 r0 plus r7 ROR 15 Offset",
                            "al_r0_r0_plus_r7_ROR_15_Offset"},
                           {{al, r0, r10, minus, r12, ROR, 6, Offset},
                            false,
                            al,
                            "al r0 r10 minus r12 ROR 6 Offset",
                            "al_r0_r10_minus_r12_ROR_6_Offset"},
                           {{al, r0, r2, plus, r3, LSL, 31, Offset},
                            false,
                            al,
                            "al r0 r2 plus r3 LSL 31 Offset",
                            "al_r0_r2_plus_r3_LSL_31_Offset"},
                           {{al, r0, r14, plus, r9, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r14 plus r9 LSL 28 Offset",
                            "al_r0_r14_plus_r9_LSL_28_Offset"},
                           {{al, r0, r8, minus, r4, LSL, 16, Offset},
                            false,
                            al,
                            "al r0 r8 minus r4 LSL 16 Offset",
                            "al_r0_r8_minus_r4_LSL_16_Offset"},
                           {{al, r0, r0, plus, r8, ROR, 18, Offset},
                            false,
                            al,
                            "al r0 r0 plus r8 ROR 18 Offset",
                            "al_r0_r0_plus_r8_ROR_18_Offset"},
                           {{al, r0, r4, minus, r11, LSL, 18, Offset},
                            false,
                            al,
                            "al r0 r4 minus r11 LSL 18 Offset",
                            "al_r0_r4_minus_r11_LSL_18_Offset"},
                           {{al, r0, r2, minus, r4, LSL, 23, Offset},
                            false,
                            al,
                            "al r0 r2 minus r4 LSL 23 Offset",
                            "al_r0_r2_minus_r4_LSL_23_Offset"},
                           {{al, r0, r12, minus, r3, LSL, 9, Offset},
                            false,
                            al,
                            "al r0 r12 minus r3 LSL 9 Offset",
                            "al_r0_r12_minus_r3_LSL_9_Offset"},
                           {{al, r0, r6, minus, r3, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r6 minus r3 ROR 31 Offset",
                            "al_r0_r6_minus_r3_ROR_31_Offset"},
                           {{al, r0, r9, minus, r7, LSL, 23, Offset},
                            false,
                            al,
                            "al r0 r9 minus r7 LSL 23 Offset",
                            "al_r0_r9_minus_r7_LSL_23_Offset"},
                           {{al, r0, r6, plus, r12, LSL, 26, Offset},
                            false,
                            al,
                            "al r0 r6 plus r12 LSL 26 Offset",
                            "al_r0_r6_plus_r12_LSL_26_Offset"},
                           {{al, r0, r4, minus, r14, LSL, 24, Offset},
                            false,
                            al,
                            "al r0 r4 minus r14 LSL 24 Offset",
                            "al_r0_r4_minus_r14_LSL_24_Offset"},
                           {{al, r0, r0, plus, r7, ROR, 21, Offset},
                            false,
                            al,
                            "al r0 r0 plus r7 ROR 21 Offset",
                            "al_r0_r0_plus_r7_ROR_21_Offset"},
                           {{al, r0, r14, minus, r7, LSL, 29, Offset},
                            false,
                            al,
                            "al r0 r14 minus r7 LSL 29 Offset",
                            "al_r0_r14_minus_r7_LSL_29_Offset"},
                           {{al, r0, r10, minus, r1, ROR, 29, Offset},
                            false,
                            al,
                            "al r0 r10 minus r1 ROR 29 Offset",
                            "al_r0_r10_minus_r1_ROR_29_Offset"},
                           {{al, r0, r11, plus, r13, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r11 plus r13 ROR 28 Offset",
                            "al_r0_r11_plus_r13_ROR_28_Offset"},
                           {{al, r0, r13, minus, r1, LSL, 5, Offset},
                            false,
                            al,
                            "al r0 r13 minus r1 LSL 5 Offset",
                            "al_r0_r13_minus_r1_LSL_5_Offset"},
                           {{al, r0, r4, plus, r7, ROR, 12, Offset},
                            false,
                            al,
                            "al r0 r4 plus r7 ROR 12 Offset",
                            "al_r0_r4_plus_r7_ROR_12_Offset"},
                           {{al, r0, r4, minus, r6, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r4 minus r6 LSL 28 Offset",
                            "al_r0_r4_minus_r6_LSL_28_Offset"},
                           {{al, r0, r14, plus, r5, LSL, 19, Offset},
                            false,
                            al,
                            "al r0 r14 plus r5 LSL 19 Offset",
                            "al_r0_r14_plus_r5_LSL_19_Offset"},
                           {{al, r0, r11, plus, r4, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r11 plus r4 ROR 4 Offset",
                            "al_r0_r11_plus_r4_ROR_4_Offset"},
                           {{al, r0, r0, plus, r0, LSL, 10, Offset},
                            false,
                            al,
                            "al r0 r0 plus r0 LSL 10 Offset",
                            "al_r0_r0_plus_r0_LSL_10_Offset"},
                           {{al, r0, r5, minus, r6, ROR, 14, Offset},
                            false,
                            al,
                            "al r0 r5 minus r6 ROR 14 Offset",
                            "al_r0_r5_minus_r6_ROR_14_Offset"},
                           {{al, r0, r3, plus, r13, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r3 plus r13 ROR 4 Offset",
                            "al_r0_r3_plus_r13_ROR_4_Offset"},
                           {{al, r0, r1, plus, r13, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r1 plus r13 LSL 12 Offset",
                            "al_r0_r1_plus_r13_LSL_12_Offset"},
                           {{al, r0, r4, minus, r11, ROR, 1, Offset},
                            false,
                            al,
                            "al r0 r4 minus r11 ROR 1 Offset",
                            "al_r0_r4_minus_r11_ROR_1_Offset"},
                           {{al, r0, r4, plus, r14, ROR, 10, Offset},
                            false,
                            al,
                            "al r0 r4 plus r14 ROR 10 Offset",
                            "al_r0_r4_plus_r14_ROR_10_Offset"},
                           {{al, r0, r4, plus, r7, LSL, 8, Offset},
                            false,
                            al,
                            "al r0 r4 plus r7 LSL 8 Offset",
                            "al_r0_r4_plus_r7_LSL_8_Offset"},
                           {{al, r0, r5, plus, r8, LSL, 2, Offset},
                            false,
                            al,
                            "al r0 r5 plus r8 LSL 2 Offset",
                            "al_r0_r5_plus_r8_LSL_2_Offset"},
                           {{al, r0, r3, minus, r13, LSL, 30, Offset},
                            false,
                            al,
                            "al r0 r3 minus r13 LSL 30 Offset",
                            "al_r0_r3_minus_r13_LSL_30_Offset"},
                           {{al, r0, r3, minus, r14, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r3 minus r14 ROR 4 Offset",
                            "al_r0_r3_minus_r14_ROR_4_Offset"},
                           {{al, r0, r9, minus, r13, ROR, 23, Offset},
                            false,
                            al,
                            "al r0 r9 minus r13 ROR 23 Offset",
                            "al_r0_r9_minus_r13_ROR_23_Offset"},
                           {{al, r0, r4, plus, r11, LSL, 29, Offset},
                            false,
                            al,
                            "al r0 r4 plus r11 LSL 29 Offset",
                            "al_r0_r4_plus_r11_LSL_29_Offset"},
                           {{al, r0, r4, plus, r13, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r4 plus r13 ROR 28 Offset",
                            "al_r0_r4_plus_r13_ROR_28_Offset"},
                           {{al, r0, r2, plus, r3, ROR, 13, Offset},
                            false,
                            al,
                            "al r0 r2 plus r3 ROR 13 Offset",
                            "al_r0_r2_plus_r3_ROR_13_Offset"},
                           {{al, r0, r7, minus, r11, LSL, 6, Offset},
                            false,
                            al,
                            "al r0 r7 minus r11 LSL 6 Offset",
                            "al_r0_r7_minus_r11_LSL_6_Offset"},
                           {{al, r0, r6, minus, r14, LSL, 15, Offset},
                            false,
                            al,
                            "al r0 r6 minus r14 LSL 15 Offset",
                            "al_r0_r6_minus_r14_LSL_15_Offset"},
                           {{al, r0, r3, minus, r3, LSL, 17, Offset},
                            false,
                            al,
                            "al r0 r3 minus r3 LSL 17 Offset",
                            "al_r0_r3_minus_r3_LSL_17_Offset"},
                           {{al, r0, r5, plus, r13, LSL, 20, Offset},
                            false,
                            al,
                            "al r0 r5 plus r13 LSL 20 Offset",
                            "al_r0_r5_plus_r13_LSL_20_Offset"},
                           {{al, r0, r6, plus, r1, ROR, 21, Offset},
                            false,
                            al,
                            "al r0 r6 plus r1 ROR 21 Offset",
                            "al_r0_r6_plus_r1_ROR_21_Offset"},
                           {{al, r0, r0, plus, r12, LSL, 6, Offset},
                            false,
                            al,
                            "al r0 r0 plus r12 LSL 6 Offset",
                            "al_r0_r0_plus_r12_LSL_6_Offset"},
                           {{al, r0, r9, minus, r6, LSL, 21, Offset},
                            false,
                            al,
                            "al r0 r9 minus r6 LSL 21 Offset",
                            "al_r0_r9_minus_r6_LSL_21_Offset"},
                           {{al, r0, r3, minus, r11, LSL, 11, Offset},
                            false,
                            al,
                            "al r0 r3 minus r11 LSL 11 Offset",
                            "al_r0_r3_minus_r11_LSL_11_Offset"},
                           {{al, r0, r4, minus, r12, ROR, 11, Offset},
                            false,
                            al,
                            "al r0 r4 minus r12 ROR 11 Offset",
                            "al_r0_r4_minus_r12_ROR_11_Offset"},
                           {{al, r0, r5, plus, r4, ROR, 1, Offset},
                            false,
                            al,
                            "al r0 r5 plus r4 ROR 1 Offset",
                            "al_r0_r5_plus_r4_ROR_1_Offset"},
                           {{al, r0, r1, plus, r2, ROR, 11, Offset},
                            false,
                            al,
                            "al r0 r1 plus r2 ROR 11 Offset",
                            "al_r0_r1_plus_r2_ROR_11_Offset"},
                           {{al, r0, r5, plus, r12, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r5 plus r12 LSL 28 Offset",
                            "al_r0_r5_plus_r12_LSL_28_Offset"},
                           {{al, r0, r10, plus, r11, ROR, 25, Offset},
                            false,
                            al,
                            "al r0 r10 plus r11 ROR 25 Offset",
                            "al_r0_r10_plus_r11_ROR_25_Offset"},
                           {{al, r0, r14, plus, r1, ROR, 8, Offset},
                            false,
                            al,
                            "al r0 r14 plus r1 ROR 8 Offset",
                            "al_r0_r14_plus_r1_ROR_8_Offset"},
                           {{al, r0, r9, plus, r1, ROR, 21, Offset},
                            false,
                            al,
                            "al r0 r9 plus r1 ROR 21 Offset",
                            "al_r0_r9_plus_r1_ROR_21_Offset"},
                           {{al, r0, r12, minus, r7, LSL, 6, Offset},
                            false,
                            al,
                            "al r0 r12 minus r7 LSL 6 Offset",
                            "al_r0_r12_minus_r7_LSL_6_Offset"},
                           {{al, r0, r3, minus, r0, ROR, 12, Offset},
                            false,
                            al,
                            "al r0 r3 minus r0 ROR 12 Offset",
                            "al_r0_r3_minus_r0_ROR_12_Offset"},
                           {{al, r0, r2, minus, r0, ROR, 27, Offset},
                            false,
                            al,
                            "al r0 r2 minus r0 ROR 27 Offset",
                            "al_r0_r2_minus_r0_ROR_27_Offset"},
                           {{al, r0, r6, minus, r2, ROR, 3, Offset},
                            false,
                            al,
                            "al r0 r6 minus r2 ROR 3 Offset",
                            "al_r0_r6_minus_r2_ROR_3_Offset"},
                           {{al, r0, r1, plus, r6, LSL, 16, Offset},
                            false,
                            al,
                            "al r0 r1 plus r6 LSL 16 Offset",
                            "al_r0_r1_plus_r6_LSL_16_Offset"},
                           {{al, r0, r6, minus, r14, ROR, 15, Offset},
                            false,
                            al,
                            "al r0 r6 minus r14 ROR 15 Offset",
                            "al_r0_r6_minus_r14_ROR_15_Offset"},
                           {{al, r0, r4, plus, r10, LSL, 20, Offset},
                            false,
                            al,
                            "al r0 r4 plus r10 LSL 20 Offset",
                            "al_r0_r4_plus_r10_LSL_20_Offset"},
                           {{al, r0, r7, minus, r4, LSL, 16, Offset},
                            false,
                            al,
                            "al r0 r7 minus r4 LSL 16 Offset",
                            "al_r0_r7_minus_r4_LSL_16_Offset"},
                           {{al, r0, r12, minus, r5, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r12 minus r5 ROR 4 Offset",
                            "al_r0_r12_minus_r5_ROR_4_Offset"},
                           {{al, r0, r11, minus, r12, LSL, 27, Offset},
                            false,
                            al,
                            "al r0 r11 minus r12 LSL 27 Offset",
                            "al_r0_r11_minus_r12_LSL_27_Offset"},
                           {{al, r0, r4, minus, r4, LSL, 30, Offset},
                            false,
                            al,
                            "al r0 r4 minus r4 LSL 30 Offset",
                            "al_r0_r4_minus_r4_LSL_30_Offset"},
                           {{al, r0, r6, plus, r4, ROR, 19, Offset},
                            false,
                            al,
                            "al r0 r6 plus r4 ROR 19 Offset",
                            "al_r0_r6_plus_r4_ROR_19_Offset"},
                           {{al, r0, r11, plus, r3, ROR, 19, Offset},
                            false,
                            al,
                            "al r0 r11 plus r3 ROR 19 Offset",
                            "al_r0_r11_plus_r3_ROR_19_Offset"},
                           {{al, r0, r9, plus, r6, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r9 plus r6 LSL 12 Offset",
                            "al_r0_r9_plus_r6_LSL_12_Offset"},
                           {{al, r0, r3, minus, r8, LSL, 29, Offset},
                            false,
                            al,
                            "al r0 r3 minus r8 LSL 29 Offset",
                            "al_r0_r3_minus_r8_LSL_29_Offset"},
                           {{al, r0, r13, plus, r5, ROR, 16, Offset},
                            false,
                            al,
                            "al r0 r13 plus r5 ROR 16 Offset",
                            "al_r0_r13_plus_r5_ROR_16_Offset"},
                           {{al, r0, r11, plus, r8, ROR, 10, Offset},
                            false,
                            al,
                            "al r0 r11 plus r8 ROR 10 Offset",
                            "al_r0_r11_plus_r8_ROR_10_Offset"},
                           {{al, r0, r0, minus, r9, LSL, 10, Offset},
                            false,
                            al,
                            "al r0 r0 minus r9 LSL 10 Offset",
                            "al_r0_r0_minus_r9_LSL_10_Offset"},
                           {{al, r0, r4, minus, r5, ROR, 11, Offset},
                            false,
                            al,
                            "al r0 r4 minus r5 ROR 11 Offset",
                            "al_r0_r4_minus_r5_ROR_11_Offset"},
                           {{al, r0, r3, plus, r7, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r3 plus r7 LSL 28 Offset",
                            "al_r0_r3_plus_r7_LSL_28_Offset"},
                           {{al, r0, r6, plus, r7, LSL, 17, Offset},
                            false,
                            al,
                            "al r0 r6 plus r7 LSL 17 Offset",
                            "al_r0_r6_plus_r7_LSL_17_Offset"},
                           {{al, r0, r6, plus, r4, LSL, 9, Offset},
                            false,
                            al,
                            "al r0 r6 plus r4 LSL 9 Offset",
                            "al_r0_r6_plus_r4_LSL_9_Offset"},
                           {{al, r0, r6, minus, r9, LSL, 15, Offset},
                            false,
                            al,
                            "al r0 r6 minus r9 LSL 15 Offset",
                            "al_r0_r6_minus_r9_LSL_15_Offset"},
                           {{al, r0, r14, plus, r1, LSL, 31, Offset},
                            false,
                            al,
                            "al r0 r14 plus r1 LSL 31 Offset",
                            "al_r0_r14_plus_r1_LSL_31_Offset"},
                           {{al, r0, r13, plus, r4, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r13 plus r4 ROR 31 Offset",
                            "al_r0_r13_plus_r4_ROR_31_Offset"},
                           {{al, r0, r0, plus, r0, ROR, 20, Offset},
                            false,
                            al,
                            "al r0 r0 plus r0 ROR 20 Offset",
                            "al_r0_r0_plus_r0_ROR_20_Offset"},
                           {{al, r0, r9, minus, r5, LSL, 8, Offset},
                            false,
                            al,
                            "al r0 r9 minus r5 LSL 8 Offset",
                            "al_r0_r9_minus_r5_LSL_8_Offset"},
                           {{al, r0, r11, plus, r8, ROR, 1, Offset},
                            false,
                            al,
                            "al r0 r11 plus r8 ROR 1 Offset",
                            "al_r0_r11_plus_r8_ROR_1_Offset"},
                           {{al, r0, r1, minus, r4, ROR, 18, Offset},
                            false,
                            al,
                            "al r0 r1 minus r4 ROR 18 Offset",
                            "al_r0_r1_minus_r4_ROR_18_Offset"},
                           {{al, r0, r0, plus, r3, LSL, 11, Offset},
                            false,
                            al,
                            "al r0 r0 plus r3 LSL 11 Offset",
                            "al_r0_r0_plus_r3_LSL_11_Offset"},
                           {{al, r0, r2, plus, r11, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r2 plus r11 ROR 31 Offset",
                            "al_r0_r2_plus_r11_ROR_31_Offset"},
                           {{al, r0, r7, minus, r11, LSL, 22, Offset},
                            false,
                            al,
                            "al r0 r7 minus r11 LSL 22 Offset",
                            "al_r0_r7_minus_r11_LSL_22_Offset"},
                           {{al, r0, r10, minus, r12, LSL, 13, Offset},
                            false,
                            al,
                            "al r0 r10 minus r12 LSL 13 Offset",
                            "al_r0_r10_minus_r12_LSL_13_Offset"},
                           {{al, r0, r12, plus, r3, ROR, 17, Offset},
                            false,
                            al,
                            "al r0 r12 plus r3 ROR 17 Offset",
                            "al_r0_r12_plus_r3_ROR_17_Offset"},
                           {{al, r0, r0, minus, r4, ROR, 15, Offset},
                            false,
                            al,
                            "al r0 r0 minus r4 ROR 15 Offset",
                            "al_r0_r0_minus_r4_ROR_15_Offset"},
                           {{al, r0, r3, plus, r4, LSL, 1, Offset},
                            false,
                            al,
                            "al r0 r3 plus r4 LSL 1 Offset",
                            "al_r0_r3_plus_r4_LSL_1_Offset"},
                           {{al, r0, r2, plus, r10, ROR, 20, Offset},
                            false,
                            al,
                            "al r0 r2 plus r10 ROR 20 Offset",
                            "al_r0_r2_plus_r10_ROR_20_Offset"},
                           {{al, r0, r11, minus, r8, ROR, 10, Offset},
                            false,
                            al,
                            "al r0 r11 minus r8 ROR 10 Offset",
                            "al_r0_r11_minus_r8_ROR_10_Offset"},
                           {{al, r0, r14, minus, r5, LSL, 3, Offset},
                            false,
                            al,
                            "al r0 r14 minus r5 LSL 3 Offset",
                            "al_r0_r14_minus_r5_LSL_3_Offset"},
                           {{al, r0, r0, minus, r7, LSL, 24, Offset},
                            false,
                            al,
                            "al r0 r0 minus r7 LSL 24 Offset",
                            "al_r0_r0_minus_r7_LSL_24_Offset"},
                           {{al, r0, r2, minus, r11, LSL, 4, Offset},
                            false,
                            al,
                            "al r0 r2 minus r11 LSL 4 Offset",
                            "al_r0_r2_minus_r11_LSL_4_Offset"},
                           {{al, r0, r3, plus, r0, ROR, 25, Offset},
                            false,
                            al,
                            "al r0 r3 plus r0 ROR 25 Offset",
                            "al_r0_r3_plus_r0_ROR_25_Offset"},
                           {{al, r0, r12, plus, r8, ROR, 7, Offset},
                            false,
                            al,
                            "al r0 r12 plus r8 ROR 7 Offset",
                            "al_r0_r12_plus_r8_ROR_7_Offset"},
                           {{al, r0, r0, plus, r9, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r0 plus r9 ROR 31 Offset",
                            "al_r0_r0_plus_r9_ROR_31_Offset"},
                           {{al, r0, r5, minus, r0, LSL, 3, Offset},
                            false,
                            al,
                            "al r0 r5 minus r0 LSL 3 Offset",
                            "al_r0_r5_minus_r0_LSL_3_Offset"},
                           {{al, r0, r0, minus, r9, ROR, 8, Offset},
                            false,
                            al,
                            "al r0 r0 minus r9 ROR 8 Offset",
                            "al_r0_r0_minus_r9_ROR_8_Offset"},
                           {{al, r0, r8, plus, r12, ROR, 22, Offset},
                            false,
                            al,
                            "al r0 r8 plus r12 ROR 22 Offset",
                            "al_r0_r8_plus_r12_ROR_22_Offset"},
                           {{al, r0, r0, minus, r1, ROR, 26, Offset},
                            false,
                            al,
                            "al r0 r0 minus r1 ROR 26 Offset",
                            "al_r0_r0_minus_r1_ROR_26_Offset"},
                           {{al, r0, r1, minus, r1, ROR, 22, Offset},
                            false,
                            al,
                            "al r0 r1 minus r1 ROR 22 Offset",
                            "al_r0_r1_minus_r1_ROR_22_Offset"},
                           {{al, r0, r2, minus, r0, ROR, 23, Offset},
                            false,
                            al,
                            "al r0 r2 minus r0 ROR 23 Offset",
                            "al_r0_r2_minus_r0_ROR_23_Offset"},
                           {{al, r0, r9, plus, r11, ROR, 29, Offset},
                            false,
                            al,
                            "al r0 r9 plus r11 ROR 29 Offset",
                            "al_r0_r9_plus_r11_ROR_29_Offset"},
                           {{al, r0, r5, minus, r9, ROR, 18, Offset},
                            false,
                            al,
                            "al r0 r5 minus r9 ROR 18 Offset",
                            "al_r0_r5_minus_r9_ROR_18_Offset"},
                           {{al, r0, r2, minus, r8, LSL, 4, Offset},
                            false,
                            al,
                            "al r0 r2 minus r8 LSL 4 Offset",
                            "al_r0_r2_minus_r8_LSL_4_Offset"},
                           {{al, r0, r2, plus, r10, ROR, 7, Offset},
                            false,
                            al,
                            "al r0 r2 plus r10 ROR 7 Offset",
                            "al_r0_r2_plus_r10_ROR_7_Offset"},
                           {{al, r0, r6, plus, r1, LSL, 22, Offset},
                            false,
                            al,
                            "al r0 r6 plus r1 LSL 22 Offset",
                            "al_r0_r6_plus_r1_LSL_22_Offset"},
                           {{al, r0, r14, minus, r14, ROR, 24, Offset},
                            false,
                            al,
                            "al r0 r14 minus r14 ROR 24 Offset",
                            "al_r0_r14_minus_r14_ROR_24_Offset"},
                           {{al, r0, r5, plus, r11, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r5 plus r11 ROR 4 Offset",
                            "al_r0_r5_plus_r11_ROR_4_Offset"},
                           {{al, r0, r3, minus, r7, LSL, 16, Offset},
                            false,
                            al,
                            "al r0 r3 minus r7 LSL 16 Offset",
                            "al_r0_r3_minus_r7_LSL_16_Offset"},
                           {{al, r0, r12, plus, r11, ROR, 17, Offset},
                            false,
                            al,
                            "al r0 r12 plus r11 ROR 17 Offset",
                            "al_r0_r12_plus_r11_ROR_17_Offset"},
                           {{al, r0, r11, minus, r1, LSL, 25, Offset},
                            false,
                            al,
                            "al r0 r11 minus r1 LSL 25 Offset",
                            "al_r0_r11_minus_r1_LSL_25_Offset"},
                           {{al, r0, r4, plus, r0, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r4 plus r0 ROR 4 Offset",
                            "al_r0_r4_plus_r0_ROR_4_Offset"},
                           {{al, r0, r4, minus, r9, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r4 minus r9 ROR 28 Offset",
                            "al_r0_r4_minus_r9_ROR_28_Offset"},
                           {{al, r0, r3, plus, r8, ROR, 22, Offset},
                            false,
                            al,
                            "al r0 r3 plus r8 ROR 22 Offset",
                            "al_r0_r3_plus_r8_ROR_22_Offset"},
                           {{al, r0, r8, plus, r13, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r8 plus r13 LSL 12 Offset",
                            "al_r0_r8_plus_r13_LSL_12_Offset"},
                           {{al, r0, r8, minus, r4, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r8 minus r4 ROR 31 Offset",
                            "al_r0_r8_minus_r4_ROR_31_Offset"},
                           {{al, r0, r10, minus, r7, ROR, 3, Offset},
                            false,
                            al,
                            "al r0 r10 minus r7 ROR 3 Offset",
                            "al_r0_r10_minus_r7_ROR_3_Offset"},
                           {{al, r0, r8, minus, r11, ROR, 30, Offset},
                            false,
                            al,
                            "al r0 r8 minus r11 ROR 30 Offset",
                            "al_r0_r8_minus_r11_ROR_30_Offset"},
                           {{al, r0, r11, minus, r5, ROR, 8, Offset},
                            false,
                            al,
                            "al r0 r11 minus r5 ROR 8 Offset",
                            "al_r0_r11_minus_r5_ROR_8_Offset"},
                           {{al, r0, r10, minus, r2, LSL, 16, Offset},
                            false,
                            al,
                            "al r0 r10 minus r2 LSL 16 Offset",
                            "al_r0_r10_minus_r2_LSL_16_Offset"},
                           {{al, r0, r10, minus, r2, ROR, 8, Offset},
                            false,
                            al,
                            "al r0 r10 minus r2 ROR 8 Offset",
                            "al_r0_r10_minus_r2_ROR_8_Offset"},
                           {{al, r0, r7, minus, r5, ROR, 2, Offset},
                            false,
                            al,
                            "al r0 r7 minus r5 ROR 2 Offset",
                            "al_r0_r7_minus_r5_ROR_2_Offset"},
                           {{al, r0, r12, minus, r13, LSL, 24, Offset},
                            false,
                            al,
                            "al r0 r12 minus r13 LSL 24 Offset",
                            "al_r0_r12_minus_r13_LSL_24_Offset"},
                           {{al, r0, r2, minus, r4, ROR, 3, Offset},
                            false,
                            al,
                            "al r0 r2 minus r4 ROR 3 Offset",
                            "al_r0_r2_minus_r4_ROR_3_Offset"},
                           {{al, r0, r14, plus, r12, LSL, 19, Offset},
                            false,
                            al,
                            "al r0 r14 plus r12 LSL 19 Offset",
                            "al_r0_r14_plus_r12_LSL_19_Offset"},
                           {{al, r0, r2, plus, r6, LSL, 17, Offset},
                            false,
                            al,
                            "al r0 r2 plus r6 LSL 17 Offset",
                            "al_r0_r2_plus_r6_LSL_17_Offset"},
                           {{al, r0, r9, plus, r10, LSL, 16, Offset},
                            false,
                            al,
                            "al r0 r9 plus r10 LSL 16 Offset",
                            "al_r0_r9_plus_r10_LSL_16_Offset"},
                           {{al, r0, r3, plus, r9, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r3 plus r9 ROR 28 Offset",
                            "al_r0_r3_plus_r9_ROR_28_Offset"},
                           {{al, r0, r2, plus, r3, LSL, 3, Offset},
                            false,
                            al,
                            "al r0 r2 plus r3 LSL 3 Offset",
                            "al_r0_r2_plus_r3_LSL_3_Offset"},
                           {{al, r0, r0, minus, r12, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r0 minus r12 LSL 28 Offset",
                            "al_r0_r0_minus_r12_LSL_28_Offset"},
                           {{al, r0, r2, minus, r12, ROR, 14, Offset},
                            false,
                            al,
                            "al r0 r2 minus r12 ROR 14 Offset",
                            "al_r0_r2_minus_r12_ROR_14_Offset"},
                           {{al, r0, r0, plus, r11, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r0 plus r11 LSL 28 Offset",
                            "al_r0_r0_plus_r11_LSL_28_Offset"},
                           {{al, r0, r11, plus, r6, ROR, 15, Offset},
                            false,
                            al,
                            "al r0 r11 plus r6 ROR 15 Offset",
                            "al_r0_r11_plus_r6_ROR_15_Offset"},
                           {{al, r0, r0, plus, r14, ROR, 21, Offset},
                            false,
                            al,
                            "al r0 r0 plus r14 ROR 21 Offset",
                            "al_r0_r0_plus_r14_ROR_21_Offset"},
                           {{al, r0, r0, plus, r2, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r0 plus r2 LSL 12 Offset",
                            "al_r0_r0_plus_r2_LSL_12_Offset"},
                           {{al, r0, r14, plus, r11, LSL, 8, Offset},
                            false,
                            al,
                            "al r0 r14 plus r11 LSL 8 Offset",
                            "al_r0_r14_plus_r11_LSL_8_Offset"},
                           {{al, r0, r2, plus, r4, LSL, 12, Offset},
                            false,
                            al,
                            "al r0 r2 plus r4 LSL 12 Offset",
                            "al_r0_r2_plus_r4_LSL_12_Offset"},
                           {{al, r0, r12, minus, r7, LSL, 26, Offset},
                            false,
                            al,
                            "al r0 r12 minus r7 LSL 26 Offset",
                            "al_r0_r12_minus_r7_LSL_26_Offset"},
                           {{al, r0, r8, minus, r8, ROR, 24, Offset},
                            false,
                            al,
                            "al r0 r8 minus r8 ROR 24 Offset",
                            "al_r0_r8_minus_r8_ROR_24_Offset"},
                           {{al, r0, r10, plus, r0, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r10 plus r0 LSL 28 Offset",
                            "al_r0_r10_plus_r0_LSL_28_Offset"},
                           {{al, r0, r3, minus, r2, ROR, 26, Offset},
                            false,
                            al,
                            "al r0 r3 minus r2 ROR 26 Offset",
                            "al_r0_r3_minus_r2_ROR_26_Offset"},
                           {{al, r0, r7, minus, r0, LSL, 7, Offset},
                            false,
                            al,
                            "al r0 r7 minus r0 LSL 7 Offset",
                            "al_r0_r7_minus_r0_LSL_7_Offset"},
                           {{al, r0, r0, minus, r14, ROR, 12, Offset},
                            false,
                            al,
                            "al r0 r0 minus r14 ROR 12 Offset",
                            "al_r0_r0_minus_r14_ROR_12_Offset"},
                           {{al, r0, r3, minus, r10, ROR, 9, Offset},
                            false,
                            al,
                            "al r0 r3 minus r10 ROR 9 Offset",
                            "al_r0_r3_minus_r10_ROR_9_Offset"},
                           {{al, r0, r9, plus, r2, LSL, 15, Offset},
                            false,
                            al,
                            "al r0 r9 plus r2 LSL 15 Offset",
                            "al_r0_r9_plus_r2_LSL_15_Offset"},
                           {{al, r0, r13, minus, r10, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r13 minus r10 ROR 28 Offset",
                            "al_r0_r13_minus_r10_ROR_28_Offset"},
                           {{al, r0, r10, plus, r14, LSL, 10, Offset},
                            false,
                            al,
                            "al r0 r10 plus r14 LSL 10 Offset",
                            "al_r0_r10_plus_r14_LSL_10_Offset"},
                           {{al, r0, r2, plus, r3, ROR, 23, Offset},
                            false,
                            al,
                            "al r0 r2 plus r3 ROR 23 Offset",
                            "al_r0_r2_plus_r3_ROR_23_Offset"},
                           {{al, r0, r3, plus, r4, LSL, 2, Offset},
                            false,
                            al,
                            "al r0 r3 plus r4 LSL 2 Offset",
                            "al_r0_r3_plus_r4_LSL_2_Offset"},
                           {{al, r0, r7, plus, r12, LSL, 28, Offset},
                            false,
                            al,
                            "al r0 r7 plus r12 LSL 28 Offset",
                            "al_r0_r7_plus_r12_LSL_28_Offset"},
                           {{al, r0, r12, minus, r3, LSL, 18, Offset},
                            false,
                            al,
                            "al r0 r12 minus r3 LSL 18 Offset",
                            "al_r0_r12_minus_r3_LSL_18_Offset"},
                           {{al, r0, r13, minus, r11, ROR, 7, Offset},
                            false,
                            al,
                            "al r0 r13 minus r11 ROR 7 Offset",
                            "al_r0_r13_minus_r11_ROR_7_Offset"},
                           {{al, r0, r14, minus, r14, LSL, 6, Offset},
                            false,
                            al,
                            "al r0 r14 minus r14 LSL 6 Offset",
                            "al_r0_r14_minus_r14_LSL_6_Offset"},
                           {{al, r0, r7, minus, r11, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r7 minus r11 ROR 31 Offset",
                            "al_r0_r7_minus_r11_ROR_31_Offset"},
                           {{al, r0, r9, minus, r7, ROR, 14, Offset},
                            false,
                            al,
                            "al r0 r9 minus r7 ROR 14 Offset",
                            "al_r0_r9_minus_r7_ROR_14_Offset"},
                           {{al, r0, r8, minus, r2, LSL, 7, Offset},
                            false,
                            al,
                            "al r0 r8 minus r2 LSL 7 Offset",
                            "al_r0_r8_minus_r2_LSL_7_Offset"},
                           {{al, r0, r3, plus, r14, LSL, 23, Offset},
                            false,
                            al,
                            "al r0 r3 plus r14 LSL 23 Offset",
                            "al_r0_r3_plus_r14_LSL_23_Offset"},
                           {{al, r0, r5, plus, r7, LSL, 5, Offset},
                            false,
                            al,
                            "al r0 r5 plus r7 LSL 5 Offset",
                            "al_r0_r5_plus_r7_LSL_5_Offset"},
                           {{al, r0, r10, minus, r14, LSL, 30, Offset},
                            false,
                            al,
                            "al r0 r10 minus r14 LSL 30 Offset",
                            "al_r0_r10_minus_r14_LSL_30_Offset"},
                           {{al, r0, r0, minus, r1, LSL, 25, Offset},
                            false,
                            al,
                            "al r0 r0 minus r1 LSL 25 Offset",
                            "al_r0_r0_minus_r1_LSL_25_Offset"},
                           {{al, r0, r14, plus, r8, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r14 plus r8 ROR 31 Offset",
                            "al_r0_r14_plus_r8_ROR_31_Offset"},
                           {{al, r0, r11, plus, r11, ROR, 31, Offset},
                            false,
                            al,
                            "al r0 r11 plus r11 ROR 31 Offset",
                            "al_r0_r11_plus_r11_ROR_31_Offset"},
                           {{al, r0, r14, plus, r8, LSL, 27, Offset},
                            false,
                            al,
                            "al r0 r14 plus r8 LSL 27 Offset",
                            "al_r0_r14_plus_r8_LSL_27_Offset"},
                           {{al, r0, r6, minus, r0, ROR, 9, Offset},
                            false,
                            al,
                            "al r0 r6 minus r0 ROR 9 Offset",
                            "al_r0_r6_minus_r0_ROR_9_Offset"},
                           {{al, r0, r4, minus, r12, LSL, 29, Offset},
                            false,
                            al,
                            "al r0 r4 minus r12 LSL 29 Offset",
                            "al_r0_r4_minus_r12_LSL_29_Offset"},
                           {{al, r0, r14, plus, r8, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r14 plus r8 ROR 4 Offset",
                            "al_r0_r14_plus_r8_ROR_4_Offset"},
                           {{al, r0, r9, minus, r9, LSL, 27, Offset},
                            false,
                            al,
                            "al r0 r9 minus r9 LSL 27 Offset",
                            "al_r0_r9_minus_r9_LSL_27_Offset"},
                           {{al, r0, r3, plus, r8, ROR, 28, Offset},
                            false,
                            al,
                            "al r0 r3 plus r8 ROR 28 Offset",
                            "al_r0_r3_plus_r8_ROR_28_Offset"},
                           {{al, r0, r12, plus, r0, ROR, 13, Offset},
                            false,
                            al,
                            "al r0 r12 plus r0 ROR 13 Offset",
                            "al_r0_r12_plus_r0_ROR_13_Offset"},
                           {{al, r0, r8, minus, r4, ROR, 20, Offset},
                            false,
                            al,
                            "al r0 r8 minus r4 ROR 20 Offset",
                            "al_r0_r8_minus_r4_ROR_20_Offset"},
                           {{al, r0, r1, plus, r14, ROR, 4, Offset},
                            false,
                            al,
                            "al r0 r1 plus r14 ROR 4 Offset",
                            "al_r0_r1_plus_r14_ROR_4_Offset"},
                           {{al, r0, r11, plus, r2, ROR, 10, Offset},
                            false,
                            al,
                            "al r0 r11 plus r2 ROR 10 Offset",
                            "al_r0_r11_plus_r2_ROR_10_Offset"},
                           {{al, r0, r0, plus, r10, ROR, 18, Offset},
                            false,
                            al,
                            "al r0 r0 plus r10 ROR 18 Offset",
                            "al_r0_r0_plus_r10_ROR_18_Offset"},
                           {{al, r0, r11, minus, r7, ROR, 3, Offset},
                            false,
                            al,
                            "al r0 r11 minus r7 ROR 3 Offset",
                            "al_r0_r11_minus_r7_ROR_3_Offset"},
                           {{al, r0, r0, plus, r14, LSL, 10, Offset},
                            false,
                            al,
                            "al r0 r0 plus r14 LSL 10 Offset",
                            "al_r0_r0_plus_r14_LSL_10_Offset"},
                           {{al, r0, r12, minus, r9, ROR, 5, Offset},
                            false,
                            al,
                            "al r0 r12 minus r9 ROR 5 Offset",
                            "al_r0_r12_minus_r9_ROR_5_Offset"},
                           {{al, r0, r11, plus, r14, ROR, 26, Offset},
                            false,
                            al,
                            "al r0 r11 plus r14 ROR 26 Offset",
                            "al_r0_r11_plus_r14_ROR_26_Offset"},
                           {{al, r8, r3, minus, r4, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r8 r3 minus r4 ROR 30 PreIndex",
                            "al_r8_r3_minus_r4_ROR_30_PreIndex"},
                           {{al, r1, r0, plus, r5, LSL, 13, PreIndex},
                            false,
                            al,
                            "al r1 r0 plus r5 LSL 13 PreIndex",
                            "al_r1_r0_plus_r5_LSL_13_PreIndex"},
                           {{al, r13, r3, minus, r1, ROR, 31, PostIndex},
                            false,
                            al,
                            "al r13 r3 minus r1 ROR 31 PostIndex",
                            "al_r13_r3_minus_r1_ROR_31_PostIndex"},
                           {{al, r9, r7, minus, r1, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r9 r7 minus r1 LSL 8 PostIndex",
                            "al_r9_r7_minus_r1_LSL_8_PostIndex"},
                           {{al, r2, r6, plus, r7, ROR, 18, PreIndex},
                            false,
                            al,
                            "al r2 r6 plus r7 ROR 18 PreIndex",
                            "al_r2_r6_plus_r7_ROR_18_PreIndex"},
                           {{al, r0, r11, minus, r11, ROR, 26, PreIndex},
                            false,
                            al,
                            "al r0 r11 minus r11 ROR 26 PreIndex",
                            "al_r0_r11_minus_r11_ROR_26_PreIndex"},
                           {{al, r14, r4, plus, r14, LSL, 12, PreIndex},
                            false,
                            al,
                            "al r14 r4 plus r14 LSL 12 PreIndex",
                            "al_r14_r4_plus_r14_LSL_12_PreIndex"},
                           {{al, r10, r6, minus, r13, LSL, 15, PreIndex},
                            false,
                            al,
                            "al r10 r6 minus r13 LSL 15 PreIndex",
                            "al_r10_r6_minus_r13_LSL_15_PreIndex"},
                           {{al, r0, r2, minus, r13, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r0 r2 minus r13 ROR 30 PreIndex",
                            "al_r0_r2_minus_r13_ROR_30_PreIndex"},
                           {{al, r0, r14, plus, r2, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r0 r14 plus r2 LSL 10 PostIndex",
                            "al_r0_r14_plus_r2_LSL_10_PostIndex"},
                           {{al, r8, r3, plus, r8, ROR, 26, PreIndex},
                            false,
                            al,
                            "al r8 r3 plus r8 ROR 26 PreIndex",
                            "al_r8_r3_plus_r8_ROR_26_PreIndex"},
                           {{al, r0, r4, minus, r12, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r0 r4 minus r12 LSL 31 PostIndex",
                            "al_r0_r4_minus_r12_LSL_31_PostIndex"},
                           {{al, r11, r12, plus, r7, LSL, 25, PostIndex},
                            false,
                            al,
                            "al r11 r12 plus r7 LSL 25 PostIndex",
                            "al_r11_r12_plus_r7_LSL_25_PostIndex"},
                           {{al, r2, r10, minus, r7, ROR, 22, PostIndex},
                            false,
                            al,
                            "al r2 r10 minus r7 ROR 22 PostIndex",
                            "al_r2_r10_minus_r7_ROR_22_PostIndex"},
                           {{al, r3, r6, plus, r8, LSL, 28, PreIndex},
                            false,
                            al,
                            "al r3 r6 plus r8 LSL 28 PreIndex",
                            "al_r3_r6_plus_r8_LSL_28_PreIndex"},
                           {{al, r9, r3, plus, r12, ROR, 21, PreIndex},
                            false,
                            al,
                            "al r9 r3 plus r12 ROR 21 PreIndex",
                            "al_r9_r3_plus_r12_ROR_21_PreIndex"},
                           {{al, r11, r5, plus, r3, ROR, 29, PostIndex},
                            false,
                            al,
                            "al r11 r5 plus r3 ROR 29 PostIndex",
                            "al_r11_r5_plus_r3_ROR_29_PostIndex"},
                           {{al, r4, r9, plus, r3, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r4 r9 plus r3 LSL 4 PreIndex",
                            "al_r4_r9_plus_r3_LSL_4_PreIndex"},
                           {{al, r8, r11, plus, r12, LSL, 14, PreIndex},
                            false,
                            al,
                            "al r8 r11 plus r12 LSL 14 PreIndex",
                            "al_r8_r11_plus_r12_LSL_14_PreIndex"},
                           {{al, r4, r7, plus, r14, LSL, 24, PreIndex},
                            false,
                            al,
                            "al r4 r7 plus r14 LSL 24 PreIndex",
                            "al_r4_r7_plus_r14_LSL_24_PreIndex"},
                           {{al, r5, r14, plus, r14, ROR, 15, PostIndex},
                            false,
                            al,
                            "al r5 r14 plus r14 ROR 15 PostIndex",
                            "al_r5_r14_plus_r14_ROR_15_PostIndex"},
                           {{al, r12, r10, plus, r9, ROR, 24, PreIndex},
                            false,
                            al,
                            "al r12 r10 plus r9 ROR 24 PreIndex",
                            "al_r12_r10_plus_r9_ROR_24_PreIndex"},
                           {{al, r6, r0, plus, r5, ROR, 11, PreIndex},
                            false,
                            al,
                            "al r6 r0 plus r5 ROR 11 PreIndex",
                            "al_r6_r0_plus_r5_ROR_11_PreIndex"},
                           {{al, r8, r7, plus, r6, ROR, 27, PostIndex},
                            false,
                            al,
                            "al r8 r7 plus r6 ROR 27 PostIndex",
                            "al_r8_r7_plus_r6_ROR_27_PostIndex"},
                           {{al, r2, r12, plus, r12, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r2 r12 plus r12 LSL 8 PreIndex",
                            "al_r2_r12_plus_r12_LSL_8_PreIndex"},
                           {{al, r6, r5, plus, r13, ROR, 7, PreIndex},
                            false,
                            al,
                            "al r6 r5 plus r13 ROR 7 PreIndex",
                            "al_r6_r5_plus_r13_ROR_7_PreIndex"},
                           {{al, r10, r7, plus, r3, LSL, 14, PreIndex},
                            false,
                            al,
                            "al r10 r7 plus r3 LSL 14 PreIndex",
                            "al_r10_r7_plus_r3_LSL_14_PreIndex"},
                           {{al, r7, r0, plus, r0, ROR, 23, PostIndex},
                            false,
                            al,
                            "al r7 r0 plus r0 ROR 23 PostIndex",
                            "al_r7_r0_plus_r0_ROR_23_PostIndex"},
                           {{al, r12, r0, plus, r3, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r12 r0 plus r3 LSL 15 PostIndex",
                            "al_r12_r0_plus_r3_LSL_15_PostIndex"},
                           {{al, r2, r4, plus, r11, ROR, 17, PostIndex},
                            false,
                            al,
                            "al r2 r4 plus r11 ROR 17 PostIndex",
                            "al_r2_r4_plus_r11_ROR_17_PostIndex"},
                           {{al, r1, r7, plus, r9, ROR, 18, PostIndex},
                            false,
                            al,
                            "al r1 r7 plus r9 ROR 18 PostIndex",
                            "al_r1_r7_plus_r9_ROR_18_PostIndex"},
                           {{al, r8, r10, plus, r14, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r8 r10 plus r14 ROR 3 PreIndex",
                            "al_r8_r10_plus_r14_ROR_3_PreIndex"},
                           {{al, r2, r3, minus, r13, LSL, 26, PostIndex},
                            false,
                            al,
                            "al r2 r3 minus r13 LSL 26 PostIndex",
                            "al_r2_r3_minus_r13_LSL_26_PostIndex"},
                           {{al, r8, r1, plus, r4, LSL, 20, PostIndex},
                            false,
                            al,
                            "al r8 r1 plus r4 LSL 20 PostIndex",
                            "al_r8_r1_plus_r4_LSL_20_PostIndex"},
                           {{al, r8, r10, minus, r6, ROR, 31, PreIndex},
                            false,
                            al,
                            "al r8 r10 minus r6 ROR 31 PreIndex",
                            "al_r8_r10_minus_r6_ROR_31_PreIndex"},
                           {{al, r8, r7, minus, r8, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r8 r7 minus r8 LSL 9 PreIndex",
                            "al_r8_r7_minus_r8_LSL_9_PreIndex"},
                           {{al, r2, r1, minus, r13, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r2 r1 minus r13 LSL 3 PostIndex",
                            "al_r2_r1_minus_r13_LSL_3_PostIndex"},
                           {{al, r7, r1, minus, r12, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r7 r1 minus r12 LSL 8 PostIndex",
                            "al_r7_r1_minus_r12_LSL_8_PostIndex"},
                           {{al, r3, r8, plus, r5, LSL, 28, PostIndex},
                            false,
                            al,
                            "al r3 r8 plus r5 LSL 28 PostIndex",
                            "al_r3_r8_plus_r5_LSL_28_PostIndex"},
                           {{al, r13, r0, plus, r0, ROR, 9, PreIndex},
                            false,
                            al,
                            "al r13 r0 plus r0 ROR 9 PreIndex",
                            "al_r13_r0_plus_r0_ROR_9_PreIndex"},
                           {{al, r2, r5, plus, r4, ROR, 22, PreIndex},
                            false,
                            al,
                            "al r2 r5 plus r4 ROR 22 PreIndex",
                            "al_r2_r5_plus_r4_ROR_22_PreIndex"},
                           {{al, r4, r0, plus, r0, LSL, 12, PreIndex},
                            false,
                            al,
                            "al r4 r0 plus r0 LSL 12 PreIndex",
                            "al_r4_r0_plus_r0_LSL_12_PreIndex"},
                           {{al, r11, r7, plus, r0, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r11 r7 plus r0 LSL 10 PostIndex",
                            "al_r11_r7_plus_r0_LSL_10_PostIndex"},
                           {{al, r13, r0, minus, r12, LSL, 25, PostIndex},
                            false,
                            al,
                            "al r13 r0 minus r12 LSL 25 PostIndex",
                            "al_r13_r0_minus_r12_LSL_25_PostIndex"},
                           {{al, r1, r3, minus, r12, ROR, 22, PreIndex},
                            false,
                            al,
                            "al r1 r3 minus r12 ROR 22 PreIndex",
                            "al_r1_r3_minus_r12_ROR_22_PreIndex"},
                           {{al, r10, r6, minus, r5, LSL, 26, PostIndex},
                            false,
                            al,
                            "al r10 r6 minus r5 LSL 26 PostIndex",
                            "al_r10_r6_minus_r5_LSL_26_PostIndex"},
                           {{al, r0, r7, plus, r11, LSL, 17, PreIndex},
                            false,
                            al,
                            "al r0 r7 plus r11 LSL 17 PreIndex",
                            "al_r0_r7_plus_r11_LSL_17_PreIndex"},
                           {{al, r12, r13, minus, r9, ROR, 28, PreIndex},
                            false,
                            al,
                            "al r12 r13 minus r9 ROR 28 PreIndex",
                            "al_r12_r13_minus_r9_ROR_28_PreIndex"},
                           {{al, r11, r1, plus, r6, ROR, 10, PostIndex},
                            false,
                            al,
                            "al r11 r1 plus r6 ROR 10 PostIndex",
                            "al_r11_r1_plus_r6_ROR_10_PostIndex"},
                           {{al, r3, r0, minus, r8, ROR, 31, PreIndex},
                            false,
                            al,
                            "al r3 r0 minus r8 ROR 31 PreIndex",
                            "al_r3_r0_minus_r8_ROR_31_PreIndex"},
                           {{al, r13, r6, plus, r12, ROR, 29, PreIndex},
                            false,
                            al,
                            "al r13 r6 plus r12 ROR 29 PreIndex",
                            "al_r13_r6_plus_r12_ROR_29_PreIndex"},
                           {{al, r2, r5, minus, r9, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r2 r5 minus r9 LSL 10 PostIndex",
                            "al_r2_r5_minus_r9_LSL_10_PostIndex"},
                           {{al, r11, r3, minus, r6, ROR, 5, PostIndex},
                            false,
                            al,
                            "al r11 r3 minus r6 ROR 5 PostIndex",
                            "al_r11_r3_minus_r6_ROR_5_PostIndex"},
                           {{al, r6, r2, minus, r14, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r6 r2 minus r14 LSL 10 PostIndex",
                            "al_r6_r2_minus_r14_LSL_10_PostIndex"},
                           {{al, r3, r10, minus, r10, LSL, 24, PreIndex},
                            false,
                            al,
                            "al r3 r10 minus r10 LSL 24 PreIndex",
                            "al_r3_r10_minus_r10_LSL_24_PreIndex"},
                           {{al, r4, r3, plus, r11, LSL, 12, PreIndex},
                            false,
                            al,
                            "al r4 r3 plus r11 LSL 12 PreIndex",
                            "al_r4_r3_plus_r11_LSL_12_PreIndex"},
                           {{al, r4, r13, minus, r0, ROR, 22, PostIndex},
                            false,
                            al,
                            "al r4 r13 minus r0 ROR 22 PostIndex",
                            "al_r4_r13_minus_r0_ROR_22_PostIndex"},
                           {{al, r2, r13, plus, r1, ROR, 2, PostIndex},
                            false,
                            al,
                            "al r2 r13 plus r1 ROR 2 PostIndex",
                            "al_r2_r13_plus_r1_ROR_2_PostIndex"},
                           {{al, r11, r9, plus, r8, LSL, 3, PreIndex},
                            false,
                            al,
                            "al r11 r9 plus r8 LSL 3 PreIndex",
                            "al_r11_r9_plus_r8_LSL_3_PreIndex"},
                           {{al, r10, r6, minus, r6, ROR, 23, PostIndex},
                            false,
                            al,
                            "al r10 r6 minus r6 ROR 23 PostIndex",
                            "al_r10_r6_minus_r6_ROR_23_PostIndex"},
                           {{al, r4, r0, minus, r4, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r4 r0 minus r4 LSL 8 PreIndex",
                            "al_r4_r0_minus_r4_LSL_8_PreIndex"},
                           {{al, r14, r9, plus, r2, ROR, 6, PreIndex},
                            false,
                            al,
                            "al r14 r9 plus r2 ROR 6 PreIndex",
                            "al_r14_r9_plus_r2_ROR_6_PreIndex"},
                           {{al, r8, r10, plus, r9, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r8 r10 plus r9 LSL 3 PostIndex",
                            "al_r8_r10_plus_r9_LSL_3_PostIndex"},
                           {{al, r9, r14, plus, r13, ROR, 25, PostIndex},
                            false,
                            al,
                            "al r9 r14 plus r13 ROR 25 PostIndex",
                            "al_r9_r14_plus_r13_ROR_25_PostIndex"},
                           {{al, r13, r3, plus, r6, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r13 r3 plus r6 LSL 3 PostIndex",
                            "al_r13_r3_plus_r6_LSL_3_PostIndex"},
                           {{al, r9, r14, plus, r4, LSL, 24, PreIndex},
                            false,
                            al,
                            "al r9 r14 plus r4 LSL 24 PreIndex",
                            "al_r9_r14_plus_r4_LSL_24_PreIndex"},
                           {{al, r5, r10, plus, r4, LSL, 29, PreIndex},
                            false,
                            al,
                            "al r5 r10 plus r4 LSL 29 PreIndex",
                            "al_r5_r10_plus_r4_LSL_29_PreIndex"},
                           {{al, r7, r5, minus, r11, LSL, 13, PreIndex},
                            false,
                            al,
                            "al r7 r5 minus r11 LSL 13 PreIndex",
                            "al_r7_r5_minus_r11_LSL_13_PreIndex"},
                           {{al, r8, r1, plus, r2, ROR, 27, PreIndex},
                            false,
                            al,
                            "al r8 r1 plus r2 ROR 27 PreIndex",
                            "al_r8_r1_plus_r2_ROR_27_PreIndex"},
                           {{al, r14, r11, minus, r8, ROR, 1, PreIndex},
                            false,
                            al,
                            "al r14 r11 minus r8 ROR 1 PreIndex",
                            "al_r14_r11_minus_r8_ROR_1_PreIndex"},
                           {{al, r14, r6, plus, r4, ROR, 29, PostIndex},
                            false,
                            al,
                            "al r14 r6 plus r4 ROR 29 PostIndex",
                            "al_r14_r6_plus_r4_ROR_29_PostIndex"},
                           {{al, r13, r0, plus, r1, LSL, 21, PreIndex},
                            false,
                            al,
                            "al r13 r0 plus r1 LSL 21 PreIndex",
                            "al_r13_r0_plus_r1_LSL_21_PreIndex"},
                           {{al, r1, r8, plus, r2, LSL, 22, PostIndex},
                            false,
                            al,
                            "al r1 r8 plus r2 LSL 22 PostIndex",
                            "al_r1_r8_plus_r2_LSL_22_PostIndex"},
                           {{al, r11, r8, plus, r5, LSL, 19, PreIndex},
                            false,
                            al,
                            "al r11 r8 plus r5 LSL 19 PreIndex",
                            "al_r11_r8_plus_r5_LSL_19_PreIndex"},
                           {{al, r12, r10, plus, r7, ROR, 15, PostIndex},
                            false,
                            al,
                            "al r12 r10 plus r7 ROR 15 PostIndex",
                            "al_r12_r10_plus_r7_ROR_15_PostIndex"},
                           {{al, r2, r6, plus, r14, ROR, 4, PostIndex},
                            false,
                            al,
                            "al r2 r6 plus r14 ROR 4 PostIndex",
                            "al_r2_r6_plus_r14_ROR_4_PostIndex"},
                           {{al, r3, r6, plus, r12, LSL, 9, PostIndex},
                            false,
                            al,
                            "al r3 r6 plus r12 LSL 9 PostIndex",
                            "al_r3_r6_plus_r12_LSL_9_PostIndex"},
                           {{al, r1, r0, minus, r6, LSL, 24, PreIndex},
                            false,
                            al,
                            "al r1 r0 minus r6 LSL 24 PreIndex",
                            "al_r1_r0_minus_r6_LSL_24_PreIndex"},
                           {{al, r5, r12, plus, r2, ROR, 30, PostIndex},
                            false,
                            al,
                            "al r5 r12 plus r2 ROR 30 PostIndex",
                            "al_r5_r12_plus_r2_ROR_30_PostIndex"},
                           {{al, r14, r3, plus, r8, ROR, 6, PostIndex},
                            false,
                            al,
                            "al r14 r3 plus r8 ROR 6 PostIndex",
                            "al_r14_r3_plus_r8_ROR_6_PostIndex"},
                           {{al, r8, r14, minus, r10, ROR, 25, PostIndex},
                            false,
                            al,
                            "al r8 r14 minus r10 ROR 25 PostIndex",
                            "al_r8_r14_minus_r10_ROR_25_PostIndex"},
                           {{al, r7, r12, plus, r2, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r7 r12 plus r2 ROR 3 PreIndex",
                            "al_r7_r12_plus_r2_ROR_3_PreIndex"},
                           {{al, r9, r13, plus, r11, ROR, 29, PreIndex},
                            false,
                            al,
                            "al r9 r13 plus r11 ROR 29 PreIndex",
                            "al_r9_r13_plus_r11_ROR_29_PreIndex"},
                           {{al, r5, r2, plus, r10, ROR, 21, PostIndex},
                            false,
                            al,
                            "al r5 r2 plus r10 ROR 21 PostIndex",
                            "al_r5_r2_plus_r10_ROR_21_PostIndex"},
                           {{al, r13, r8, minus, r2, LSL, 21, PreIndex},
                            false,
                            al,
                            "al r13 r8 minus r2 LSL 21 PreIndex",
                            "al_r13_r8_minus_r2_LSL_21_PreIndex"},
                           {{al, r1, r13, plus, r5, LSL, 20, PostIndex},
                            false,
                            al,
                            "al r1 r13 plus r5 LSL 20 PostIndex",
                            "al_r1_r13_plus_r5_LSL_20_PostIndex"},
                           {{al, r6, r0, plus, r6, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r6 r0 plus r6 LSL 15 PostIndex",
                            "al_r6_r0_plus_r6_LSL_15_PostIndex"},
                           {{al, r7, r3, minus, r6, LSL, 31, PreIndex},
                            false,
                            al,
                            "al r7 r3 minus r6 LSL 31 PreIndex",
                            "al_r7_r3_minus_r6_LSL_31_PreIndex"},
                           {{al, r5, r10, minus, r11, ROR, 6, PostIndex},
                            false,
                            al,
                            "al r5 r10 minus r11 ROR 6 PostIndex",
                            "al_r5_r10_minus_r11_ROR_6_PostIndex"},
                           {{al, r7, r3, minus, r13, ROR, 29, PreIndex},
                            false,
                            al,
                            "al r7 r3 minus r13 ROR 29 PreIndex",
                            "al_r7_r3_minus_r13_ROR_29_PreIndex"},
                           {{al, r4, r6, plus, r3, LSL, 10, PreIndex},
                            false,
                            al,
                            "al r4 r6 plus r3 LSL 10 PreIndex",
                            "al_r4_r6_plus_r3_LSL_10_PreIndex"},
                           {{al, r7, r13, plus, r4, ROR, 8, PreIndex},
                            false,
                            al,
                            "al r7 r13 plus r4 ROR 8 PreIndex",
                            "al_r7_r13_plus_r4_ROR_8_PreIndex"},
                           {{al, r2, r5, plus, r0, LSL, 30, PreIndex},
                            false,
                            al,
                            "al r2 r5 plus r0 LSL 30 PreIndex",
                            "al_r2_r5_plus_r0_LSL_30_PreIndex"},
                           {{al, r10, r12, plus, r5, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r10 r12 plus r5 LSL 8 PreIndex",
                            "al_r10_r12_plus_r5_LSL_8_PreIndex"},
                           {{al, r4, r10, minus, r11, ROR, 2, PreIndex},
                            false,
                            al,
                            "al r4 r10 minus r11 ROR 2 PreIndex",
                            "al_r4_r10_minus_r11_ROR_2_PreIndex"},
                           {{al, r4, r11, plus, r12, LSL, 14, PreIndex},
                            false,
                            al,
                            "al r4 r11 plus r12 LSL 14 PreIndex",
                            "al_r4_r11_plus_r12_LSL_14_PreIndex"},
                           {{al, r1, r6, plus, r1, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r1 r6 plus r1 LSL 10 PostIndex",
                            "al_r1_r6_plus_r1_LSL_10_PostIndex"},
                           {{al, r8, r11, plus, r11, LSL, 11, PreIndex},
                            false,
                            al,
                            "al r8 r11 plus r11 LSL 11 PreIndex",
                            "al_r8_r11_plus_r11_LSL_11_PreIndex"},
                           {{al, r12, r8, minus, r7, ROR, 10, PostIndex},
                            false,
                            al,
                            "al r12 r8 minus r7 ROR 10 PostIndex",
                            "al_r12_r8_minus_r7_ROR_10_PostIndex"},
                           {{al, r13, r11, plus, r1, LSL, 11, PreIndex},
                            false,
                            al,
                            "al r13 r11 plus r1 LSL 11 PreIndex",
                            "al_r13_r11_plus_r1_LSL_11_PreIndex"},
                           {{al, r5, r3, plus, r9, ROR, 9, PreIndex},
                            false,
                            al,
                            "al r5 r3 plus r9 ROR 9 PreIndex",
                            "al_r5_r3_plus_r9_ROR_9_PreIndex"},
                           {{al, r6, r10, plus, r6, LSL, 18, PreIndex},
                            false,
                            al,
                            "al r6 r10 plus r6 LSL 18 PreIndex",
                            "al_r6_r10_plus_r6_LSL_18_PreIndex"},
                           {{al, r6, r1, minus, r14, LSL, 14, PostIndex},
                            false,
                            al,
                            "al r6 r1 minus r14 LSL 14 PostIndex",
                            "al_r6_r1_minus_r14_LSL_14_PostIndex"},
                           {{al, r10, r3, minus, r6, LSL, 5, PreIndex},
                            false,
                            al,
                            "al r10 r3 minus r6 LSL 5 PreIndex",
                            "al_r10_r3_minus_r6_LSL_5_PreIndex"},
                           {{al, r6, r7, minus, r13, ROR, 26, PreIndex},
                            false,
                            al,
                            "al r6 r7 minus r13 ROR 26 PreIndex",
                            "al_r6_r7_minus_r13_ROR_26_PreIndex"},
                           {{al, r8, r12, minus, r7, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r8 r12 minus r7 ROR 30 PreIndex",
                            "al_r8_r12_minus_r7_ROR_30_PreIndex"},
                           {{al, r9, r7, plus, r5, LSL, 27, PostIndex},
                            false,
                            al,
                            "al r9 r7 plus r5 LSL 27 PostIndex",
                            "al_r9_r7_plus_r5_LSL_27_PostIndex"},
                           {{al, r8, r10, minus, r14, LSL, 26, PreIndex},
                            false,
                            al,
                            "al r8 r10 minus r14 LSL 26 PreIndex",
                            "al_r8_r10_minus_r14_LSL_26_PreIndex"},
                           {{al, r9, r13, minus, r2, LSL, 30, PostIndex},
                            false,
                            al,
                            "al r9 r13 minus r2 LSL 30 PostIndex",
                            "al_r9_r13_minus_r2_LSL_30_PostIndex"},
                           {{al, r12, r9, minus, r8, ROR, 7, PostIndex},
                            false,
                            al,
                            "al r12 r9 minus r8 ROR 7 PostIndex",
                            "al_r12_r9_minus_r8_ROR_7_PostIndex"},
                           {{al, r4, r9, minus, r5, ROR, 2, PreIndex},
                            false,
                            al,
                            "al r4 r9 minus r5 ROR 2 PreIndex",
                            "al_r4_r9_minus_r5_ROR_2_PreIndex"},
                           {{al, r1, r5, plus, r9, ROR, 16, PostIndex},
                            false,
                            al,
                            "al r1 r5 plus r9 ROR 16 PostIndex",
                            "al_r1_r5_plus_r9_ROR_16_PostIndex"},
                           {{al, r3, r2, minus, r9, LSL, 25, PostIndex},
                            false,
                            al,
                            "al r3 r2 minus r9 LSL 25 PostIndex",
                            "al_r3_r2_minus_r9_LSL_25_PostIndex"},
                           {{al, r14, r0, minus, r4, LSL, 22, PreIndex},
                            false,
                            al,
                            "al r14 r0 minus r4 LSL 22 PreIndex",
                            "al_r14_r0_minus_r4_LSL_22_PreIndex"},
                           {{al, r1, r4, plus, r2, LSL, 7, PostIndex},
                            false,
                            al,
                            "al r1 r4 plus r2 LSL 7 PostIndex",
                            "al_r1_r4_plus_r2_LSL_7_PostIndex"},
                           {{al, r13, r9, minus, r4, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r13 r9 minus r4 LSL 31 PostIndex",
                            "al_r13_r9_minus_r4_LSL_31_PostIndex"},
                           {{al, r11, r14, minus, r2, LSL, 13, PostIndex},
                            false,
                            al,
                            "al r11 r14 minus r2 LSL 13 PostIndex",
                            "al_r11_r14_minus_r2_LSL_13_PostIndex"},
                           {{al, r10, r5, plus, r1, LSL, 22, PreIndex},
                            false,
                            al,
                            "al r10 r5 plus r1 LSL 22 PreIndex",
                            "al_r10_r5_plus_r1_LSL_22_PreIndex"},
                           {{al, r13, r2, minus, r10, LSL, 25, PreIndex},
                            false,
                            al,
                            "al r13 r2 minus r10 LSL 25 PreIndex",
                            "al_r13_r2_minus_r10_LSL_25_PreIndex"},
                           {{al, r12, r2, plus, r0, ROR, 27, PostIndex},
                            false,
                            al,
                            "al r12 r2 plus r0 ROR 27 PostIndex",
                            "al_r12_r2_plus_r0_ROR_27_PostIndex"},
                           {{al, r5, r13, plus, r13, LSL, 5, PostIndex},
                            false,
                            al,
                            "al r5 r13 plus r13 LSL 5 PostIndex",
                            "al_r5_r13_plus_r13_LSL_5_PostIndex"},
                           {{al, r14, r0, minus, r11, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r14 r0 minus r11 ROR 3 PreIndex",
                            "al_r14_r0_minus_r11_ROR_3_PreIndex"},
                           {{al, r1, r10, minus, r8, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r1 r10 minus r8 LSL 4 PreIndex",
                            "al_r1_r10_minus_r8_LSL_4_PreIndex"},
                           {{al, r11, r4, plus, r3, ROR, 23, PostIndex},
                            false,
                            al,
                            "al r11 r4 plus r3 ROR 23 PostIndex",
                            "al_r11_r4_plus_r3_ROR_23_PostIndex"},
                           {{al, r1, r4, plus, r11, LSL, 29, PreIndex},
                            false,
                            al,
                            "al r1 r4 plus r11 LSL 29 PreIndex",
                            "al_r1_r4_plus_r11_LSL_29_PreIndex"},
                           {{al, r12, r4, plus, r7, ROR, 4, PreIndex},
                            false,
                            al,
                            "al r12 r4 plus r7 ROR 4 PreIndex",
                            "al_r12_r4_plus_r7_ROR_4_PreIndex"},
                           {{al, r4, r11, plus, r14, ROR, 17, PostIndex},
                            false,
                            al,
                            "al r4 r11 plus r14 ROR 17 PostIndex",
                            "al_r4_r11_plus_r14_ROR_17_PostIndex"},
                           {{al, r3, r10, plus, r0, LSL, 2, PostIndex},
                            false,
                            al,
                            "al r3 r10 plus r0 LSL 2 PostIndex",
                            "al_r3_r10_plus_r0_LSL_2_PostIndex"},
                           {{al, r11, r13, minus, r8, ROR, 26, PostIndex},
                            false,
                            al,
                            "al r11 r13 minus r8 ROR 26 PostIndex",
                            "al_r11_r13_minus_r8_ROR_26_PostIndex"},
                           {{al, r0, r8, plus, r14, ROR, 21, PostIndex},
                            false,
                            al,
                            "al r0 r8 plus r14 ROR 21 PostIndex",
                            "al_r0_r8_plus_r14_ROR_21_PostIndex"},
                           {{al, r8, r5, plus, r7, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r8 r5 plus r7 LSL 9 PreIndex",
                            "al_r8_r5_plus_r7_LSL_9_PreIndex"},
                           {{al, r9, r10, plus, r14, LSL, 14, PostIndex},
                            false,
                            al,
                            "al r9 r10 plus r14 LSL 14 PostIndex",
                            "al_r9_r10_plus_r14_LSL_14_PostIndex"},
                           {{al, r1, r9, minus, r4, LSL, 26, PostIndex},
                            false,
                            al,
                            "al r1 r9 minus r4 LSL 26 PostIndex",
                            "al_r1_r9_minus_r4_LSL_26_PostIndex"},
                           {{al, r8, r4, plus, r1, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r8 r4 plus r1 LSL 8 PreIndex",
                            "al_r8_r4_plus_r1_LSL_8_PreIndex"},
                           {{al, r13, r6, minus, r7, ROR, 23, PostIndex},
                            false,
                            al,
                            "al r13 r6 minus r7 ROR 23 PostIndex",
                            "al_r13_r6_minus_r7_ROR_23_PostIndex"},
                           {{al, r12, r9, plus, r4, LSL, 15, PreIndex},
                            false,
                            al,
                            "al r12 r9 plus r4 LSL 15 PreIndex",
                            "al_r12_r9_plus_r4_LSL_15_PreIndex"},
                           {{al, r7, r8, plus, r1, ROR, 24, PostIndex},
                            false,
                            al,
                            "al r7 r8 plus r1 ROR 24 PostIndex",
                            "al_r7_r8_plus_r1_ROR_24_PostIndex"},
                           {{al, r5, r7, minus, r2, LSL, 20, PreIndex},
                            false,
                            al,
                            "al r5 r7 minus r2 LSL 20 PreIndex",
                            "al_r5_r7_minus_r2_LSL_20_PreIndex"},
                           {{al, r3, r11, minus, r6, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r3 r11 minus r6 LSL 16 PostIndex",
                            "al_r3_r11_minus_r6_LSL_16_PostIndex"},
                           {{al, r6, r14, minus, r8, ROR, 15, PostIndex},
                            false,
                            al,
                            "al r6 r14 minus r8 ROR 15 PostIndex",
                            "al_r6_r14_minus_r8_ROR_15_PostIndex"},
                           {{al, r13, r14, minus, r7, LSL, 28, PreIndex},
                            false,
                            al,
                            "al r13 r14 minus r7 LSL 28 PreIndex",
                            "al_r13_r14_minus_r7_LSL_28_PreIndex"},
                           {{al, r3, r12, plus, r9, LSL, 3, PreIndex},
                            false,
                            al,
                            "al r3 r12 plus r9 LSL 3 PreIndex",
                            "al_r3_r12_plus_r9_LSL_3_PreIndex"},
                           {{al, r1, r3, plus, r10, ROR, 14, PreIndex},
                            false,
                            al,
                            "al r1 r3 plus r10 ROR 14 PreIndex",
                            "al_r1_r3_plus_r10_ROR_14_PreIndex"},
                           {{al, r1, r3, minus, r12, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r1 r3 minus r12 LSL 9 PreIndex",
                            "al_r1_r3_minus_r12_LSL_9_PreIndex"},
                           {{al, r3, r6, plus, r8, ROR, 21, PostIndex},
                            false,
                            al,
                            "al r3 r6 plus r8 ROR 21 PostIndex",
                            "al_r3_r6_plus_r8_ROR_21_PostIndex"},
                           {{al, r14, r3, plus, r9, LSL, 7, PreIndex},
                            false,
                            al,
                            "al r14 r3 plus r9 LSL 7 PreIndex",
                            "al_r14_r3_plus_r9_LSL_7_PreIndex"},
                           {{al, r4, r8, plus, r1, ROR, 27, PreIndex},
                            false,
                            al,
                            "al r4 r8 plus r1 ROR 27 PreIndex",
                            "al_r4_r8_plus_r1_ROR_27_PreIndex"},
                           {{al, r1, r13, minus, r5, ROR, 19, PreIndex},
                            false,
                            al,
                            "al r1 r13 minus r5 ROR 19 PreIndex",
                            "al_r1_r13_minus_r5_ROR_19_PreIndex"},
                           {{al, r5, r1, plus, r14, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r5 r1 plus r14 LSL 15 PostIndex",
                            "al_r5_r1_plus_r14_LSL_15_PostIndex"},
                           {{al, r12, r3, minus, r11, ROR, 28, PreIndex},
                            false,
                            al,
                            "al r12 r3 minus r11 ROR 28 PreIndex",
                            "al_r12_r3_minus_r11_ROR_28_PreIndex"},
                           {{al, r14, r3, plus, r4, LSL, 20, PostIndex},
                            false,
                            al,
                            "al r14 r3 plus r4 LSL 20 PostIndex",
                            "al_r14_r3_plus_r4_LSL_20_PostIndex"},
                           {{al, r6, r2, plus, r10, ROR, 14, PreIndex},
                            false,
                            al,
                            "al r6 r2 plus r10 ROR 14 PreIndex",
                            "al_r6_r2_plus_r10_ROR_14_PreIndex"},
                           {{al, r8, r12, plus, r13, ROR, 26, PreIndex},
                            false,
                            al,
                            "al r8 r12 plus r13 ROR 26 PreIndex",
                            "al_r8_r12_plus_r13_ROR_26_PreIndex"},
                           {{al, r12, r13, minus, r13, LSL, 11, PostIndex},
                            false,
                            al,
                            "al r12 r13 minus r13 LSL 11 PostIndex",
                            "al_r12_r13_minus_r13_LSL_11_PostIndex"},
                           {{al, r0, r6, minus, r10, LSL, 24, PostIndex},
                            false,
                            al,
                            "al r0 r6 minus r10 LSL 24 PostIndex",
                            "al_r0_r6_minus_r10_LSL_24_PostIndex"},
                           {{al, r6, r0, minus, r13, LSL, 29, PreIndex},
                            false,
                            al,
                            "al r6 r0 minus r13 LSL 29 PreIndex",
                            "al_r6_r0_minus_r13_LSL_29_PreIndex"},
                           {{al, r4, r2, plus, r10, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r4 r2 plus r10 LSL 15 PostIndex",
                            "al_r4_r2_plus_r10_LSL_15_PostIndex"},
                           {{al, r13, r9, plus, r14, ROR, 21, PreIndex},
                            false,
                            al,
                            "al r13 r9 plus r14 ROR 21 PreIndex",
                            "al_r13_r9_plus_r14_ROR_21_PreIndex"},
                           {{al, r4, r1, minus, r0, ROR, 26, PostIndex},
                            false,
                            al,
                            "al r4 r1 minus r0 ROR 26 PostIndex",
                            "al_r4_r1_minus_r0_ROR_26_PostIndex"},
                           {{al, r12, r7, minus, r12, ROR, 28, PreIndex},
                            false,
                            al,
                            "al r12 r7 minus r12 ROR 28 PreIndex",
                            "al_r12_r7_minus_r12_ROR_28_PreIndex"},
                           {{al, r10, r0, minus, r5, LSL, 7, PreIndex},
                            false,
                            al,
                            "al r10 r0 minus r5 LSL 7 PreIndex",
                            "al_r10_r0_minus_r5_LSL_7_PreIndex"},
                           {{al, r4, r1, plus, r2, ROR, 23, PreIndex},
                            false,
                            al,
                            "al r4 r1 plus r2 ROR 23 PreIndex",
                            "al_r4_r1_plus_r2_ROR_23_PreIndex"},
                           {{al, r12, r6, minus, r1, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r12 r6 minus r1 LSL 31 PostIndex",
                            "al_r12_r6_minus_r1_LSL_31_PostIndex"},
                           {{al, r4, r8, plus, r3, LSL, 28, PreIndex},
                            false,
                            al,
                            "al r4 r8 plus r3 LSL 28 PreIndex",
                            "al_r4_r8_plus_r3_LSL_28_PreIndex"},
                           {{al, r11, r7, minus, r5, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r11 r7 minus r5 ROR 3 PreIndex",
                            "al_r11_r7_minus_r5_ROR_3_PreIndex"},
                           {{al, r4, r3, plus, r11, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r4 r3 plus r11 LSL 16 PostIndex",
                            "al_r4_r3_plus_r11_LSL_16_PostIndex"},
                           {{al, r12, r11, plus, r12, ROR, 11, PreIndex},
                            false,
                            al,
                            "al r12 r11 plus r12 ROR 11 PreIndex",
                            "al_r12_r11_plus_r12_ROR_11_PreIndex"},
                           {{al, r11, r5, minus, r0, ROR, 29, PreIndex},
                            false,
                            al,
                            "al r11 r5 minus r0 ROR 29 PreIndex",
                            "al_r11_r5_minus_r0_ROR_29_PreIndex"},
                           {{al, r11, r7, plus, r12, LSL, 24, PostIndex},
                            false,
                            al,
                            "al r11 r7 plus r12 LSL 24 PostIndex",
                            "al_r11_r7_plus_r12_LSL_24_PostIndex"},
                           {{al, r13, r4, plus, r4, ROR, 9, PostIndex},
                            false,
                            al,
                            "al r13 r4 plus r4 ROR 9 PostIndex",
                            "al_r13_r4_plus_r4_ROR_9_PostIndex"},
                           {{al, r0, r9, minus, r11, LSL, 17, PostIndex},
                            false,
                            al,
                            "al r0 r9 minus r11 LSL 17 PostIndex",
                            "al_r0_r9_minus_r11_LSL_17_PostIndex"},
                           {{al, r1, r11, plus, r5, ROR, 27, PostIndex},
                            false,
                            al,
                            "al r1 r11 plus r5 ROR 27 PostIndex",
                            "al_r1_r11_plus_r5_ROR_27_PostIndex"},
                           {{al, r6, r0, plus, r5, ROR, 16, PostIndex},
                            false,
                            al,
                            "al r6 r0 plus r5 ROR 16 PostIndex",
                            "al_r6_r0_plus_r5_ROR_16_PostIndex"},
                           {{al, r14, r8, plus, r8, LSL, 23, PreIndex},
                            false,
                            al,
                            "al r14 r8 plus r8 LSL 23 PreIndex",
                            "al_r14_r8_plus_r8_LSL_23_PreIndex"},
                           {{al, r7, r0, plus, r12, LSL, 29, PostIndex},
                            false,
                            al,
                            "al r7 r0 plus r12 LSL 29 PostIndex",
                            "al_r7_r0_plus_r12_LSL_29_PostIndex"},
                           {{al, r5, r4, minus, r12, ROR, 28, PreIndex},
                            false,
                            al,
                            "al r5 r4 minus r12 ROR 28 PreIndex",
                            "al_r5_r4_minus_r12_ROR_28_PreIndex"},
                           {{al, r1, r13, plus, r1, LSL, 12, PreIndex},
                            false,
                            al,
                            "al r1 r13 plus r1 LSL 12 PreIndex",
                            "al_r1_r13_plus_r1_LSL_12_PreIndex"},
                           {{al, r7, r9, minus, r11, ROR, 24, PostIndex},
                            false,
                            al,
                            "al r7 r9 minus r11 ROR 24 PostIndex",
                            "al_r7_r9_minus_r11_ROR_24_PostIndex"},
                           {{al, r4, r8, minus, r0, ROR, 6, PreIndex},
                            false,
                            al,
                            "al r4 r8 minus r0 ROR 6 PreIndex",
                            "al_r4_r8_minus_r0_ROR_6_PreIndex"},
                           {{al, r6, r9, plus, r9, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r6 r9 plus r9 ROR 30 PreIndex",
                            "al_r6_r9_plus_r9_ROR_30_PreIndex"},
                           {{al, r1, r14, minus, r10, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r1 r14 minus r10 LSL 4 PreIndex",
                            "al_r1_r14_minus_r10_LSL_4_PreIndex"},
                           {{al, r6, r0, minus, r13, ROR, 12, PreIndex},
                            false,
                            al,
                            "al r6 r0 minus r13 ROR 12 PreIndex",
                            "al_r6_r0_minus_r13_ROR_12_PreIndex"},
                           {{al, r1, r4, minus, r2, LSL, 23, PreIndex},
                            false,
                            al,
                            "al r1 r4 minus r2 LSL 23 PreIndex",
                            "al_r1_r4_minus_r2_LSL_23_PreIndex"},
                           {{al, r0, r12, minus, r11, ROR, 26, PostIndex},
                            false,
                            al,
                            "al r0 r12 minus r11 ROR 26 PostIndex",
                            "al_r0_r12_minus_r11_ROR_26_PostIndex"},
                           {{al, r5, r8, plus, r4, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r5 r8 plus r4 LSL 31 PostIndex",
                            "al_r5_r8_plus_r4_LSL_31_PostIndex"},
                           {{al, r14, r11, plus, r10, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r14 r11 plus r10 LSL 8 PreIndex",
                            "al_r14_r11_plus_r10_LSL_8_PreIndex"},
                           {{al, r4, r14, minus, r2, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r4 r14 minus r2 LSL 31 PostIndex",
                            "al_r4_r14_minus_r2_LSL_31_PostIndex"},
                           {{al, r9, r6, plus, r11, LSL, 30, PostIndex},
                            false,
                            al,
                            "al r9 r6 plus r11 LSL 30 PostIndex",
                            "al_r9_r6_plus_r11_LSL_30_PostIndex"},
                           {{al, r14, r5, minus, r1, ROR, 9, PostIndex},
                            false,
                            al,
                            "al r14 r5 minus r1 ROR 9 PostIndex",
                            "al_r14_r5_minus_r1_ROR_9_PostIndex"},
                           {{al, r2, r8, minus, r14, ROR, 28, PreIndex},
                            false,
                            al,
                            "al r2 r8 minus r14 ROR 28 PreIndex",
                            "al_r2_r8_minus_r14_ROR_28_PreIndex"},
                           {{al, r0, r4, plus, r12, ROR, 8, PostIndex},
                            false,
                            al,
                            "al r0 r4 plus r12 ROR 8 PostIndex",
                            "al_r0_r4_plus_r12_ROR_8_PostIndex"},
                           {{al, r6, r12, minus, r10, LSL, 19, PostIndex},
                            false,
                            al,
                            "al r6 r12 minus r10 LSL 19 PostIndex",
                            "al_r6_r12_minus_r10_LSL_19_PostIndex"},
                           {{al, r7, r8, minus, r11, LSL, 9, PostIndex},
                            false,
                            al,
                            "al r7 r8 minus r11 LSL 9 PostIndex",
                            "al_r7_r8_minus_r11_LSL_9_PostIndex"},
                           {{al, r6, r4, plus, r4, ROR, 6, PostIndex},
                            false,
                            al,
                            "al r6 r4 plus r4 ROR 6 PostIndex",
                            "al_r6_r4_plus_r4_ROR_6_PostIndex"},
                           {{al, r12, r14, minus, r3, LSL, 19, PostIndex},
                            false,
                            al,
                            "al r12 r14 minus r3 LSL 19 PostIndex",
                            "al_r12_r14_minus_r3_LSL_19_PostIndex"},
                           {{al, r14, r4, plus, r14, ROR, 22, PostIndex},
                            false,
                            al,
                            "al r14 r4 plus r14 ROR 22 PostIndex",
                            "al_r14_r4_plus_r14_ROR_22_PostIndex"},
                           {{al, r2, r5, minus, r2, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r2 r5 minus r2 LSL 15 PostIndex",
                            "al_r2_r5_minus_r2_LSL_15_PostIndex"},
                           {{al, r6, r5, minus, r12, ROR, 24, PreIndex},
                            false,
                            al,
                            "al r6 r5 minus r12 ROR 24 PreIndex",
                            "al_r6_r5_minus_r12_ROR_24_PreIndex"},
                           {{al, r0, r1, plus, r0, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r0 r1 plus r0 LSL 8 PostIndex",
                            "al_r0_r1_plus_r0_LSL_8_PostIndex"},
                           {{al, r6, r3, plus, r10, LSL, 23, PostIndex},
                            false,
                            al,
                            "al r6 r3 plus r10 LSL 23 PostIndex",
                            "al_r6_r3_plus_r10_LSL_23_PostIndex"},
                           {{al, r10, r1, plus, r0, ROR, 15, PostIndex},
                            false,
                            al,
                            "al r10 r1 plus r0 ROR 15 PostIndex",
                            "al_r10_r1_plus_r0_ROR_15_PostIndex"},
                           {{al, r1, r14, plus, r8, ROR, 31, PostIndex},
                            false,
                            al,
                            "al r1 r14 plus r8 ROR 31 PostIndex",
                            "al_r1_r14_plus_r8_ROR_31_PostIndex"},
                           {{al, r14, r10, plus, r6, LSL, 6, PreIndex},
                            false,
                            al,
                            "al r14 r10 plus r6 LSL 6 PreIndex",
                            "al_r14_r10_plus_r6_LSL_6_PreIndex"},
                           {{al, r12, r2, plus, r10, ROR, 18, PostIndex},
                            false,
                            al,
                            "al r12 r2 plus r10 ROR 18 PostIndex",
                            "al_r12_r2_plus_r10_ROR_18_PostIndex"},
                           {{al, r4, r8, minus, r0, LSL, 9, PostIndex},
                            false,
                            al,
                            "al r4 r8 minus r0 LSL 9 PostIndex",
                            "al_r4_r8_minus_r0_LSL_9_PostIndex"},
                           {{al, r9, r3, plus, r3, ROR, 16, PreIndex},
                            false,
                            al,
                            "al r9 r3 plus r3 ROR 16 PreIndex",
                            "al_r9_r3_plus_r3_ROR_16_PreIndex"},
                           {{al, r1, r7, minus, r3, LSL, 2, PostIndex},
                            false,
                            al,
                            "al r1 r7 minus r3 LSL 2 PostIndex",
                            "al_r1_r7_minus_r3_LSL_2_PostIndex"},
                           {{al, r8, r13, plus, r14, ROR, 16, PreIndex},
                            false,
                            al,
                            "al r8 r13 plus r14 ROR 16 PreIndex",
                            "al_r8_r13_plus_r14_ROR_16_PreIndex"},
                           {{al, r3, r0, minus, r3, LSL, 30, PreIndex},
                            false,
                            al,
                            "al r3 r0 minus r3 LSL 30 PreIndex",
                            "al_r3_r0_minus_r3_LSL_30_PreIndex"},
                           {{al, r1, r11, plus, r13, ROR, 26, PostIndex},
                            false,
                            al,
                            "al r1 r11 plus r13 ROR 26 PostIndex",
                            "al_r1_r11_plus_r13_ROR_26_PostIndex"},
                           {{al, r3, r1, plus, r9, ROR, 3, PostIndex},
                            false,
                            al,
                            "al r3 r1 plus r9 ROR 3 PostIndex",
                            "al_r3_r1_plus_r9_ROR_3_PostIndex"},
                           {{al, r14, r11, minus, r4, ROR, 22, PostIndex},
                            false,
                            al,
                            "al r14 r11 minus r4 ROR 22 PostIndex",
                            "al_r14_r11_minus_r4_ROR_22_PostIndex"},
                           {{al, r3, r1, plus, r10, LSL, 29, PostIndex},
                            false,
                            al,
                            "al r3 r1 plus r10 LSL 29 PostIndex",
                            "al_r3_r1_plus_r10_LSL_29_PostIndex"},
                           {{al, r12, r6, plus, r13, ROR, 6, PostIndex},
                            false,
                            al,
                            "al r12 r6 plus r13 ROR 6 PostIndex",
                            "al_r12_r6_plus_r13_ROR_6_PostIndex"},
                           {{al, r12, r11, plus, r2, LSL, 19, PostIndex},
                            false,
                            al,
                            "al r12 r11 plus r2 LSL 19 PostIndex",
                            "al_r12_r11_plus_r2_LSL_19_PostIndex"},
                           {{al, r14, r10, plus, r4, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r14 r10 plus r4 LSL 31 PostIndex",
                            "al_r14_r10_plus_r4_LSL_31_PostIndex"},
                           {{al, r1, r4, minus, r2, ROR, 28, PostIndex},
                            false,
                            al,
                            "al r1 r4 minus r2 ROR 28 PostIndex",
                            "al_r1_r4_minus_r2_ROR_28_PostIndex"},
                           {{al, r3, r4, minus, r6, ROR, 20, PreIndex},
                            false,
                            al,
                            "al r3 r4 minus r6 ROR 20 PreIndex",
                            "al_r3_r4_minus_r6_ROR_20_PreIndex"},
                           {{al, r6, r8, plus, r13, ROR, 11, PostIndex},
                            false,
                            al,
                            "al r6 r8 plus r13 ROR 11 PostIndex",
                            "al_r6_r8_plus_r13_ROR_11_PostIndex"},
                           {{al, r8, r0, plus, r14, LSL, 27, PreIndex},
                            false,
                            al,
                            "al r8 r0 plus r14 LSL 27 PreIndex",
                            "al_r8_r0_plus_r14_LSL_27_PreIndex"},
                           {{al, r10, r2, minus, r9, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r10 r2 minus r9 ROR 3 PreIndex",
                            "al_r10_r2_minus_r9_ROR_3_PreIndex"},
                           {{al, r7, r9, minus, r3, ROR, 11, PostIndex},
                            false,
                            al,
                            "al r7 r9 minus r3 ROR 11 PostIndex",
                            "al_r7_r9_minus_r3_ROR_11_PostIndex"},
                           {{al, r12, r14, minus, r3, LSL, 24, PostIndex},
                            false,
                            al,
                            "al r12 r14 minus r3 LSL 24 PostIndex",
                            "al_r12_r14_minus_r3_LSL_24_PostIndex"},
                           {{al, r1, r6, plus, r8, LSL, 26, PreIndex},
                            false,
                            al,
                            "al r1 r6 plus r8 LSL 26 PreIndex",
                            "al_r1_r6_plus_r8_LSL_26_PreIndex"},
                           {{al, r12, r10, minus, r7, LSL, 11, PostIndex},
                            false,
                            al,
                            "al r12 r10 minus r7 LSL 11 PostIndex",
                            "al_r12_r10_minus_r7_LSL_11_PostIndex"},
                           {{al, r11, r2, minus, r8, LSL, 13, PreIndex},
                            false,
                            al,
                            "al r11 r2 minus r8 LSL 13 PreIndex",
                            "al_r11_r2_minus_r8_LSL_13_PreIndex"},
                           {{al, r13, r8, plus, r3, ROR, 9, PreIndex},
                            false,
                            al,
                            "al r13 r8 plus r3 ROR 9 PreIndex",
                            "al_r13_r8_plus_r3_ROR_9_PreIndex"},
                           {{al, r7, r4, minus, r10, ROR, 19, PostIndex},
                            false,
                            al,
                            "al r7 r4 minus r10 ROR 19 PostIndex",
                            "al_r7_r4_minus_r10_ROR_19_PostIndex"},
                           {{al, r7, r4, plus, r11, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r7 r4 plus r11 LSL 8 PostIndex",
                            "al_r7_r4_plus_r11_LSL_8_PostIndex"},
                           {{al, r7, r3, plus, r8, ROR, 24, PostIndex},
                            false,
                            al,
                            "al r7 r3 plus r8 ROR 24 PostIndex",
                            "al_r7_r3_plus_r8_ROR_24_PostIndex"},
                           {{al, r5, r14, plus, r12, LSL, 9, PostIndex},
                            false,
                            al,
                            "al r5 r14 plus r12 LSL 9 PostIndex",
                            "al_r5_r14_plus_r12_LSL_9_PostIndex"},
                           {{al, r10, r1, minus, r5, LSL, 17, PostIndex},
                            false,
                            al,
                            "al r10 r1 minus r5 LSL 17 PostIndex",
                            "al_r10_r1_minus_r5_LSL_17_PostIndex"},
                           {{al, r10, r5, plus, r11, LSL, 26, PostIndex},
                            false,
                            al,
                            "al r10 r5 plus r11 LSL 26 PostIndex",
                            "al_r10_r5_plus_r11_LSL_26_PostIndex"},
                           {{al, r6, r0, plus, r2, ROR, 29, PostIndex},
                            false,
                            al,
                            "al r6 r0 plus r2 ROR 29 PostIndex",
                            "al_r6_r0_plus_r2_ROR_29_PostIndex"},
                           {{al, r14, r4, plus, r11, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r14 r4 plus r11 LSL 4 PreIndex",
                            "al_r14_r4_plus_r11_LSL_4_PreIndex"},
                           {{al, r5, r0, minus, r14, LSL, 6, PreIndex},
                            false,
                            al,
                            "al r5 r0 minus r14 LSL 6 PreIndex",
                            "al_r5_r0_minus_r14_LSL_6_PreIndex"},
                           {{al, r2, r14, plus, r6, LSL, 17, PostIndex},
                            false,
                            al,
                            "al r2 r14 plus r6 LSL 17 PostIndex",
                            "al_r2_r14_plus_r6_LSL_17_PostIndex"},
                           {{al, r14, r0, minus, r0, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r14 r0 minus r0 LSL 16 PostIndex",
                            "al_r14_r0_minus_r0_LSL_16_PostIndex"},
                           {{al, r6, r9, minus, r9, ROR, 7, PostIndex},
                            false,
                            al,
                            "al r6 r9 minus r9 ROR 7 PostIndex",
                            "al_r6_r9_minus_r9_ROR_7_PostIndex"},
                           {{al, r10, r1, minus, r13, LSL, 3, PreIndex},
                            false,
                            al,
                            "al r10 r1 minus r13 LSL 3 PreIndex",
                            "al_r10_r1_minus_r13_LSL_3_PreIndex"},
                           {{al, r13, r14, minus, r9, LSL, 21, PreIndex},
                            false,
                            al,
                            "al r13 r14 minus r9 LSL 21 PreIndex",
                            "al_r13_r14_minus_r9_LSL_21_PreIndex"},
                           {{al, r14, r11, plus, r8, LSL, 20, PostIndex},
                            false,
                            al,
                            "al r14 r11 plus r8 LSL 20 PostIndex",
                            "al_r14_r11_plus_r8_LSL_20_PostIndex"},
                           {{al, r1, r4, minus, r11, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r1 r4 minus r11 LSL 4 PreIndex",
                            "al_r1_r4_minus_r11_LSL_4_PreIndex"},
                           {{al, r11, r14, minus, r5, LSL, 24, PostIndex},
                            false,
                            al,
                            "al r11 r14 minus r5 LSL 24 PostIndex",
                            "al_r11_r14_minus_r5_LSL_24_PostIndex"},
                           {{al, r3, r1, minus, r0, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r3 r1 minus r0 LSL 8 PreIndex",
                            "al_r3_r1_minus_r0_LSL_8_PreIndex"},
                           {{al, r9, r13, plus, r12, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r9 r13 plus r12 LSL 3 PostIndex",
                            "al_r9_r13_plus_r12_LSL_3_PostIndex"},
                           {{al, r6, r13, plus, r5, ROR, 7, PostIndex},
                            false,
                            al,
                            "al r6 r13 plus r5 ROR 7 PostIndex",
                            "al_r6_r13_plus_r5_ROR_7_PostIndex"},
                           {{al, r13, r4, minus, r7, ROR, 19, PreIndex},
                            false,
                            al,
                            "al r13 r4 minus r7 ROR 19 PreIndex",
                            "al_r13_r4_minus_r7_ROR_19_PreIndex"},
                           {{al, r12, r7, minus, r9, ROR, 2, PostIndex},
                            false,
                            al,
                            "al r12 r7 minus r9 ROR 2 PostIndex",
                            "al_r12_r7_minus_r9_ROR_2_PostIndex"},
                           {{al, r12, r4, plus, r4, ROR, 7, PreIndex},
                            false,
                            al,
                            "al r12 r4 plus r4 ROR 7 PreIndex",
                            "al_r12_r4_plus_r4_ROR_7_PreIndex"},
                           {{al, r6, r8, minus, r7, LSL, 1, PreIndex},
                            false,
                            al,
                            "al r6 r8 minus r7 LSL 1 PreIndex",
                            "al_r6_r8_minus_r7_LSL_1_PreIndex"},
                           {{al, r3, r7, minus, r2, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r3 r7 minus r2 LSL 16 PostIndex",
                            "al_r3_r7_minus_r2_LSL_16_PostIndex"},
                           {{al, r9, r6, plus, r4, ROR, 16, PreIndex},
                            false,
                            al,
                            "al r9 r6 plus r4 ROR 16 PreIndex",
                            "al_r9_r6_plus_r4_ROR_16_PreIndex"},
                           {{al, r8, r9, minus, r2, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r8 r9 minus r2 LSL 15 PostIndex",
                            "al_r8_r9_minus_r2_LSL_15_PostIndex"},
                           {{al, r0, r12, minus, r0, ROR, 31, PostIndex},
                            false,
                            al,
                            "al r0 r12 minus r0 ROR 31 PostIndex",
                            "al_r0_r12_minus_r0_ROR_31_PostIndex"},
                           {{al, r6, r9, plus, r0, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r6 r9 plus r0 LSL 15 PostIndex",
                            "al_r6_r9_plus_r0_LSL_15_PostIndex"},
                           {{al, r0, r2, minus, r13, ROR, 5, PostIndex},
                            false,
                            al,
                            "al r0 r2 minus r13 ROR 5 PostIndex",
                            "al_r0_r2_minus_r13_ROR_5_PostIndex"},
                           {{al, r11, r4, minus, r5, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r11 r4 minus r5 ROR 30 PreIndex",
                            "al_r11_r4_minus_r5_ROR_30_PreIndex"},
                           {{al, r2, r11, minus, r5, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r2 r11 minus r5 LSL 16 PostIndex",
                            "al_r2_r11_minus_r5_LSL_16_PostIndex"},
                           {{al, r8, r2, minus, r0, ROR, 25, PreIndex},
                            false,
                            al,
                            "al r8 r2 minus r0 ROR 25 PreIndex",
                            "al_r8_r2_minus_r0_ROR_25_PreIndex"},
                           {{al, r6, r1, minus, r7, LSL, 11, PreIndex},
                            false,
                            al,
                            "al r6 r1 minus r7 LSL 11 PreIndex",
                            "al_r6_r1_minus_r7_LSL_11_PreIndex"},
                           {{al, r7, r11, minus, r5, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r7 r11 minus r5 LSL 4 PreIndex",
                            "al_r7_r11_minus_r5_LSL_4_PreIndex"},
                           {{al, r6, r11, plus, r5, LSL, 17, PostIndex},
                            false,
                            al,
                            "al r6 r11 plus r5 LSL 17 PostIndex",
                            "al_r6_r11_plus_r5_LSL_17_PostIndex"},
                           {{al, r9, r4, minus, r2, LSL, 29, PostIndex},
                            false,
                            al,
                            "al r9 r4 minus r2 LSL 29 PostIndex",
                            "al_r9_r4_minus_r2_LSL_29_PostIndex"},
                           {{al, r14, r5, minus, r0, ROR, 26, PostIndex},
                            false,
                            al,
                            "al r14 r5 minus r0 ROR 26 PostIndex",
                            "al_r14_r5_minus_r0_ROR_26_PostIndex"},
                           {{al, r5, r11, plus, r0, ROR, 27, PostIndex},
                            false,
                            al,
                            "al r5 r11 plus r0 ROR 27 PostIndex",
                            "al_r5_r11_plus_r0_ROR_27_PostIndex"},
                           {{al, r1, r9, minus, r11, ROR, 8, PostIndex},
                            false,
                            al,
                            "al r1 r9 minus r11 ROR 8 PostIndex",
                            "al_r1_r9_minus_r11_ROR_8_PostIndex"},
                           {{al, r7, r0, plus, r14, ROR, 11, PostIndex},
                            false,
                            al,
                            "al r7 r0 plus r14 ROR 11 PostIndex",
                            "al_r7_r0_plus_r14_ROR_11_PostIndex"},
                           {{al, r7, r0, minus, r9, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r7 r0 minus r9 LSL 9 PreIndex",
                            "al_r7_r0_minus_r9_LSL_9_PreIndex"},
                           {{al, r4, r3, plus, r10, LSL, 6, PostIndex},
                            false,
                            al,
                            "al r4 r3 plus r10 LSL 6 PostIndex",
                            "al_r4_r3_plus_r10_LSL_6_PostIndex"},
                           {{al, r10, r0, minus, r5, ROR, 14, PostIndex},
                            false,
                            al,
                            "al r10 r0 minus r5 ROR 14 PostIndex",
                            "al_r10_r0_minus_r5_ROR_14_PostIndex"},
                           {{al, r1, r2, plus, r13, LSL, 17, PostIndex},
                            false,
                            al,
                            "al r1 r2 plus r13 LSL 17 PostIndex",
                            "al_r1_r2_plus_r13_LSL_17_PostIndex"},
                           {{al, r11, r2, plus, r9, ROR, 22, PostIndex},
                            false,
                            al,
                            "al r11 r2 plus r9 ROR 22 PostIndex",
                            "al_r11_r2_plus_r9_ROR_22_PostIndex"},
                           {{al, r2, r9, plus, r3, LSL, 19, PostIndex},
                            false,
                            al,
                            "al r2 r9 plus r3 LSL 19 PostIndex",
                            "al_r2_r9_plus_r3_LSL_19_PostIndex"},
                           {{al, r7, r3, plus, r4, ROR, 23, PostIndex},
                            false,
                            al,
                            "al r7 r3 plus r4 ROR 23 PostIndex",
                            "al_r7_r3_plus_r4_ROR_23_PostIndex"},
                           {{al, r2, r9, plus, r11, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r2 r9 plus r11 LSL 8 PostIndex",
                            "al_r2_r9_plus_r11_LSL_8_PostIndex"},
                           {{al, r5, r13, minus, r1, ROR, 15, PreIndex},
                            false,
                            al,
                            "al r5 r13 minus r1 ROR 15 PreIndex",
                            "al_r5_r13_minus_r1_ROR_15_PreIndex"},
                           {{al, r8, r12, plus, r2, LSL, 15, PreIndex},
                            false,
                            al,
                            "al r8 r12 plus r2 LSL 15 PreIndex",
                            "al_r8_r12_plus_r2_LSL_15_PreIndex"},
                           {{al, r7, r1, plus, r13, LSL, 24, PreIndex},
                            false,
                            al,
                            "al r7 r1 plus r13 LSL 24 PreIndex",
                            "al_r7_r1_plus_r13_LSL_24_PreIndex"},
                           {{al, r0, r9, minus, r1, ROR, 13, PostIndex},
                            false,
                            al,
                            "al r0 r9 minus r1 ROR 13 PostIndex",
                            "al_r0_r9_minus_r1_ROR_13_PostIndex"},
                           {{al, r5, r9, minus, r1, LSL, 1, PostIndex},
                            false,
                            al,
                            "al r5 r9 minus r1 LSL 1 PostIndex",
                            "al_r5_r9_minus_r1_LSL_1_PostIndex"},
                           {{al, r3, r4, minus, r2, LSL, 4, PreIndex},
                            false,
                            al,
                            "al r3 r4 minus r2 LSL 4 PreIndex",
                            "al_r3_r4_minus_r2_LSL_4_PreIndex"},
                           {{al, r3, r10, minus, r6, ROR, 5, PreIndex},
                            false,
                            al,
                            "al r3 r10 minus r6 ROR 5 PreIndex",
                            "al_r3_r10_minus_r6_ROR_5_PreIndex"},
                           {{al, r2, r14, minus, r6, ROR, 16, PreIndex},
                            false,
                            al,
                            "al r2 r14 minus r6 ROR 16 PreIndex",
                            "al_r2_r14_minus_r6_ROR_16_PreIndex"},
                           {{al, r2, r1, plus, r14, ROR, 3, PostIndex},
                            false,
                            al,
                            "al r2 r1 plus r14 ROR 3 PostIndex",
                            "al_r2_r1_plus_r14_ROR_3_PostIndex"},
                           {{al, r6, r2, plus, r2, LSL, 22, PreIndex},
                            false,
                            al,
                            "al r6 r2 plus r2 LSL 22 PreIndex",
                            "al_r6_r2_plus_r2_LSL_22_PreIndex"},
                           {{al, r5, r7, plus, r4, ROR, 3, PostIndex},
                            false,
                            al,
                            "al r5 r7 plus r4 ROR 3 PostIndex",
                            "al_r5_r7_plus_r4_ROR_3_PostIndex"},
                           {{al, r12, r9, plus, r6, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r12 r9 plus r6 ROR 3 PreIndex",
                            "al_r12_r9_plus_r6_ROR_3_PreIndex"},
                           {{al, r3, r7, plus, r10, ROR, 29, PreIndex},
                            false,
                            al,
                            "al r3 r7 plus r10 ROR 29 PreIndex",
                            "al_r3_r7_plus_r10_ROR_29_PreIndex"},
                           {{al, r2, r0, minus, r9, ROR, 9, PreIndex},
                            false,
                            al,
                            "al r2 r0 minus r9 ROR 9 PreIndex",
                            "al_r2_r0_minus_r9_ROR_9_PreIndex"},
                           {{al, r7, r12, plus, r7, LSL, 3, PreIndex},
                            false,
                            al,
                            "al r7 r12 plus r7 LSL 3 PreIndex",
                            "al_r7_r12_plus_r7_LSL_3_PreIndex"},
                           {{al, r7, r5, plus, r10, LSL, 15, PostIndex},
                            false,
                            al,
                            "al r7 r5 plus r10 LSL 15 PostIndex",
                            "al_r7_r5_plus_r10_LSL_15_PostIndex"},
                           {{al, r14, r4, minus, r6, ROR, 13, PreIndex},
                            false,
                            al,
                            "al r14 r4 minus r6 ROR 13 PreIndex",
                            "al_r14_r4_minus_r6_ROR_13_PreIndex"},
                           {{al, r0, r6, plus, r7, ROR, 27, PreIndex},
                            false,
                            al,
                            "al r0 r6 plus r7 ROR 27 PreIndex",
                            "al_r0_r6_plus_r7_ROR_27_PreIndex"},
                           {{al, r0, r14, plus, r13, ROR, 23, PreIndex},
                            false,
                            al,
                            "al r0 r14 plus r13 ROR 23 PreIndex",
                            "al_r0_r14_plus_r13_ROR_23_PreIndex"},
                           {{al, r9, r5, plus, r1, LSL, 8, PreIndex},
                            false,
                            al,
                            "al r9 r5 plus r1 LSL 8 PreIndex",
                            "al_r9_r5_plus_r1_LSL_8_PreIndex"},
                           {{al, r8, r3, plus, r7, LSL, 12, PostIndex},
                            false,
                            al,
                            "al r8 r3 plus r7 LSL 12 PostIndex",
                            "al_r8_r3_plus_r7_LSL_12_PostIndex"},
                           {{al, r2, r5, plus, r3, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r2 r5 plus r3 LSL 16 PostIndex",
                            "al_r2_r5_plus_r3_LSL_16_PostIndex"},
                           {{al, r4, r12, minus, r7, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r4 r12 minus r7 LSL 8 PostIndex",
                            "al_r4_r12_minus_r7_LSL_8_PostIndex"},
                           {{al, r0, r7, minus, r5, LSL, 6, PostIndex},
                            false,
                            al,
                            "al r0 r7 minus r5 LSL 6 PostIndex",
                            "al_r0_r7_minus_r5_LSL_6_PostIndex"},
                           {{al, r9, r4, plus, r12, ROR, 14, PreIndex},
                            false,
                            al,
                            "al r9 r4 plus r12 ROR 14 PreIndex",
                            "al_r9_r4_plus_r12_ROR_14_PreIndex"},
                           {{al, r6, r2, minus, r14, LSL, 8, PostIndex},
                            false,
                            al,
                            "al r6 r2 minus r14 LSL 8 PostIndex",
                            "al_r6_r2_minus_r14_LSL_8_PostIndex"},
                           {{al, r6, r12, minus, r9, ROR, 14, PostIndex},
                            false,
                            al,
                            "al r6 r12 minus r9 ROR 14 PostIndex",
                            "al_r6_r12_minus_r9_ROR_14_PostIndex"},
                           {{al, r13, r7, minus, r9, LSL, 3, PreIndex},
                            false,
                            al,
                            "al r13 r7 minus r9 LSL 3 PreIndex",
                            "al_r13_r7_minus_r9_LSL_3_PreIndex"},
                           {{al, r13, r1, plus, r13, ROR, 20, PostIndex},
                            false,
                            al,
                            "al r13 r1 plus r13 ROR 20 PostIndex",
                            "al_r13_r1_plus_r13_ROR_20_PostIndex"},
                           {{al, r8, r11, minus, r6, ROR, 4, PreIndex},
                            false,
                            al,
                            "al r8 r11 minus r6 ROR 4 PreIndex",
                            "al_r8_r11_minus_r6_ROR_4_PreIndex"},
                           {{al, r0, r14, plus, r8, ROR, 17, PostIndex},
                            false,
                            al,
                            "al r0 r14 plus r8 ROR 17 PostIndex",
                            "al_r0_r14_plus_r8_ROR_17_PostIndex"},
                           {{al, r12, r9, plus, r10, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r12 r9 plus r10 LSL 9 PreIndex",
                            "al_r12_r9_plus_r10_LSL_9_PreIndex"},
                           {{al, r10, r13, plus, r1, LSL, 18, PostIndex},
                            false,
                            al,
                            "al r10 r13 plus r1 LSL 18 PostIndex",
                            "al_r10_r13_plus_r1_LSL_18_PostIndex"},
                           {{al, r10, r9, plus, r3, LSL, 13, PreIndex},
                            false,
                            al,
                            "al r10 r9 plus r3 LSL 13 PreIndex",
                            "al_r10_r9_plus_r3_LSL_13_PreIndex"},
                           {{al, r8, r14, plus, r5, LSL, 19, PreIndex},
                            false,
                            al,
                            "al r8 r14 plus r5 LSL 19 PreIndex",
                            "al_r8_r14_plus_r5_LSL_19_PreIndex"},
                           {{al, r2, r10, minus, r6, ROR, 21, PostIndex},
                            false,
                            al,
                            "al r2 r10 minus r6 ROR 21 PostIndex",
                            "al_r2_r10_minus_r6_ROR_21_PostIndex"},
                           {{al, r9, r6, plus, r5, LSL, 3, PreIndex},
                            false,
                            al,
                            "al r9 r6 plus r5 LSL 3 PreIndex",
                            "al_r9_r6_plus_r5_LSL_3_PreIndex"},
                           {{al, r13, r10, plus, r4, ROR, 29, PreIndex},
                            false,
                            al,
                            "al r13 r10 plus r4 ROR 29 PreIndex",
                            "al_r13_r10_plus_r4_ROR_29_PreIndex"},
                           {{al, r3, r4, plus, r5, LSL, 22, PostIndex},
                            false,
                            al,
                            "al r3 r4 plus r5 LSL 22 PostIndex",
                            "al_r3_r4_plus_r5_LSL_22_PostIndex"},
                           {{al, r0, r5, minus, r10, LSL, 11, PreIndex},
                            false,
                            al,
                            "al r0 r5 minus r10 LSL 11 PreIndex",
                            "al_r0_r5_minus_r10_LSL_11_PreIndex"},
                           {{al, r11, r12, minus, r14, ROR, 30, PostIndex},
                            false,
                            al,
                            "al r11 r12 minus r14 ROR 30 PostIndex",
                            "al_r11_r12_minus_r14_ROR_30_PostIndex"},
                           {{al, r12, r14, minus, r10, LSL, 23, PostIndex},
                            false,
                            al,
                            "al r12 r14 minus r10 LSL 23 PostIndex",
                            "al_r12_r14_minus_r10_LSL_23_PostIndex"},
                           {{al, r3, r7, plus, r5, ROR, 5, PostIndex},
                            false,
                            al,
                            "al r3 r7 plus r5 ROR 5 PostIndex",
                            "al_r3_r7_plus_r5_ROR_5_PostIndex"},
                           {{al, r1, r0, minus, r14, LSL, 23, PostIndex},
                            false,
                            al,
                            "al r1 r0 minus r14 LSL 23 PostIndex",
                            "al_r1_r0_minus_r14_LSL_23_PostIndex"},
                           {{al, r14, r0, plus, r13, LSL, 16, PostIndex},
                            false,
                            al,
                            "al r14 r0 plus r13 LSL 16 PostIndex",
                            "al_r14_r0_plus_r13_LSL_16_PostIndex"},
                           {{al, r1, r7, minus, r10, ROR, 31, PreIndex},
                            false,
                            al,
                            "al r1 r7 minus r10 ROR 31 PreIndex",
                            "al_r1_r7_minus_r10_ROR_31_PreIndex"},
                           {{al, r14, r10, minus, r12, LSL, 12, PostIndex},
                            false,
                            al,
                            "al r14 r10 minus r12 LSL 12 PostIndex",
                            "al_r14_r10_minus_r12_LSL_12_PostIndex"},
                           {{al, r14, r9, minus, r9, ROR, 18, PreIndex},
                            false,
                            al,
                            "al r14 r9 minus r9 ROR 18 PreIndex",
                            "al_r14_r9_minus_r9_ROR_18_PreIndex"},
                           {{al, r10, r12, plus, r2, ROR, 15, PreIndex},
                            false,
                            al,
                            "al r10 r12 plus r2 ROR 15 PreIndex",
                            "al_r10_r12_plus_r2_ROR_15_PreIndex"},
                           {{al, r13, r14, minus, r0, LSL, 11, PreIndex},
                            false,
                            al,
                            "al r13 r14 minus r0 LSL 11 PreIndex",
                            "al_r13_r14_minus_r0_LSL_11_PreIndex"},
                           {{al, r3, r5, plus, r6, ROR, 2, PreIndex},
                            false,
                            al,
                            "al r3 r5 plus r6 ROR 2 PreIndex",
                            "al_r3_r5_plus_r6_ROR_2_PreIndex"},
                           {{al, r9, r3, minus, r14, ROR, 27, PostIndex},
                            false,
                            al,
                            "al r9 r3 minus r14 ROR 27 PostIndex",
                            "al_r9_r3_minus_r14_ROR_27_PostIndex"},
                           {{al, r2, r10, minus, r7, ROR, 19, PostIndex},
                            false,
                            al,
                            "al r2 r10 minus r7 ROR 19 PostIndex",
                            "al_r2_r10_minus_r7_ROR_19_PostIndex"},
                           {{al, r12, r5, plus, r11, LSL, 29, PostIndex},
                            false,
                            al,
                            "al r12 r5 plus r11 LSL 29 PostIndex",
                            "al_r12_r5_plus_r11_LSL_29_PostIndex"},
                           {{al, r2, r9, minus, r12, ROR, 13, PreIndex},
                            false,
                            al,
                            "al r2 r9 minus r12 ROR 13 PreIndex",
                            "al_r2_r9_minus_r12_ROR_13_PreIndex"},
                           {{al, r11, r1, plus, r13, LSL, 26, PreIndex},
                            false,
                            al,
                            "al r11 r1 plus r13 LSL 26 PreIndex",
                            "al_r11_r1_plus_r13_LSL_26_PreIndex"},
                           {{al, r12, r0, minus, r1, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r12 r0 minus r1 ROR 3 PreIndex",
                            "al_r12_r0_minus_r1_ROR_3_PreIndex"},
                           {{al, r11, r14, plus, r4, LSL, 19, PreIndex},
                            false,
                            al,
                            "al r11 r14 plus r4 LSL 19 PreIndex",
                            "al_r11_r14_plus_r4_LSL_19_PreIndex"},
                           {{al, r8, r12, plus, r3, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r8 r12 plus r3 ROR 30 PreIndex",
                            "al_r8_r12_plus_r3_ROR_30_PreIndex"},
                           {{al, r6, r0, plus, r6, LSL, 24, PostIndex},
                            false,
                            al,
                            "al r6 r0 plus r6 LSL 24 PostIndex",
                            "al_r6_r0_plus_r6_LSL_24_PostIndex"},
                           {{al, r4, r6, minus, r11, ROR, 16, PreIndex},
                            false,
                            al,
                            "al r4 r6 minus r11 ROR 16 PreIndex",
                            "al_r4_r6_minus_r11_ROR_16_PreIndex"},
                           {{al, r8, r0, plus, r11, ROR, 8, PostIndex},
                            false,
                            al,
                            "al r8 r0 plus r11 ROR 8 PostIndex",
                            "al_r8_r0_plus_r11_ROR_8_PostIndex"},
                           {{al, r7, r5, plus, r1, ROR, 25, PostIndex},
                            false,
                            al,
                            "al r7 r5 plus r1 ROR 25 PostIndex",
                            "al_r7_r5_plus_r1_ROR_25_PostIndex"},
                           {{al, r1, r12, plus, r11, ROR, 12, PreIndex},
                            false,
                            al,
                            "al r1 r12 plus r11 ROR 12 PreIndex",
                            "al_r1_r12_plus_r11_ROR_12_PreIndex"},
                           {{al, r4, r2, plus, r14, ROR, 8, PostIndex},
                            false,
                            al,
                            "al r4 r2 plus r14 ROR 8 PostIndex",
                            "al_r4_r2_plus_r14_ROR_8_PostIndex"},
                           {{al, r5, r0, plus, r1, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r5 r0 plus r1 LSL 10 PostIndex",
                            "al_r5_r0_plus_r1_LSL_10_PostIndex"},
                           {{al, r0, r11, minus, r4, ROR, 30, PostIndex},
                            false,
                            al,
                            "al r0 r11 minus r4 ROR 30 PostIndex",
                            "al_r0_r11_minus_r4_ROR_30_PostIndex"},
                           {{al, r14, r3, minus, r7, LSL, 2, PostIndex},
                            false,
                            al,
                            "al r14 r3 minus r7 LSL 2 PostIndex",
                            "al_r14_r3_minus_r7_LSL_2_PostIndex"},
                           {{al, r4, r8, plus, r10, LSL, 26, PostIndex},
                            false,
                            al,
                            "al r4 r8 plus r10 LSL 26 PostIndex",
                            "al_r4_r8_plus_r10_LSL_26_PostIndex"},
                           {{al, r12, r2, minus, r8, LSL, 21, PreIndex},
                            false,
                            al,
                            "al r12 r2 minus r8 LSL 21 PreIndex",
                            "al_r12_r2_minus_r8_LSL_21_PreIndex"},
                           {{al, r9, r14, minus, r14, LSL, 24, PreIndex},
                            false,
                            al,
                            "al r9 r14 minus r14 LSL 24 PreIndex",
                            "al_r9_r14_minus_r14_LSL_24_PreIndex"},
                           {{al, r7, r13, minus, r11, LSL, 2, PostIndex},
                            false,
                            al,
                            "al r7 r13 minus r11 LSL 2 PostIndex",
                            "al_r7_r13_minus_r11_LSL_2_PostIndex"},
                           {{al, r0, r2, plus, r0, ROR, 30, PreIndex},
                            false,
                            al,
                            "al r0 r2 plus r0 ROR 30 PreIndex",
                            "al_r0_r2_plus_r0_ROR_30_PreIndex"},
                           {{al, r1, r6, minus, r0, ROR, 1, PreIndex},
                            false,
                            al,
                            "al r1 r6 minus r0 ROR 1 PreIndex",
                            "al_r1_r6_minus_r0_ROR_1_PreIndex"},
                           {{al, r6, r5, plus, r12, LSL, 4, PostIndex},
                            false,
                            al,
                            "al r6 r5 plus r12 LSL 4 PostIndex",
                            "al_r6_r5_plus_r12_LSL_4_PostIndex"},
                           {{al, r7, r9, plus, r13, LSL, 11, PostIndex},
                            false,
                            al,
                            "al r7 r9 plus r13 LSL 11 PostIndex",
                            "al_r7_r9_plus_r13_LSL_11_PostIndex"},
                           {{al, r5, r12, minus, r2, ROR, 5, PostIndex},
                            false,
                            al,
                            "al r5 r12 minus r2 ROR 5 PostIndex",
                            "al_r5_r12_minus_r2_ROR_5_PostIndex"},
                           {{al, r6, r7, plus, r14, LSL, 30, PreIndex},
                            false,
                            al,
                            "al r6 r7 plus r14 LSL 30 PreIndex",
                            "al_r6_r7_plus_r14_LSL_30_PreIndex"},
                           {{al, r2, r11, minus, r0, ROR, 20, PostIndex},
                            false,
                            al,
                            "al r2 r11 minus r0 ROR 20 PostIndex",
                            "al_r2_r11_minus_r0_ROR_20_PostIndex"},
                           {{al, r6, r2, minus, r10, ROR, 11, PostIndex},
                            false,
                            al,
                            "al r6 r2 minus r10 ROR 11 PostIndex",
                            "al_r6_r2_minus_r10_ROR_11_PostIndex"},
                           {{al, r3, r2, plus, r0, ROR, 4, PostIndex},
                            false,
                            al,
                            "al r3 r2 plus r0 ROR 4 PostIndex",
                            "al_r3_r2_plus_r0_ROR_4_PostIndex"},
                           {{al, r8, r6, plus, r12, LSL, 11, PostIndex},
                            false,
                            al,
                            "al r8 r6 plus r12 LSL 11 PostIndex",
                            "al_r8_r6_plus_r12_LSL_11_PostIndex"},
                           {{al, r0, r6, minus, r4, ROR, 8, PreIndex},
                            false,
                            al,
                            "al r0 r6 minus r4 ROR 8 PreIndex",
                            "al_r0_r6_minus_r4_ROR_8_PreIndex"},
                           {{al, r10, r1, minus, r3, ROR, 5, PostIndex},
                            false,
                            al,
                            "al r10 r1 minus r3 ROR 5 PostIndex",
                            "al_r10_r1_minus_r3_ROR_5_PostIndex"},
                           {{al, r10, r4, plus, r12, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r10 r4 plus r12 LSL 9 PreIndex",
                            "al_r10_r4_plus_r12_LSL_9_PreIndex"},
                           {{al, r1, r9, minus, r5, ROR, 7, PostIndex},
                            false,
                            al,
                            "al r1 r9 minus r5 ROR 7 PostIndex",
                            "al_r1_r9_minus_r5_ROR_7_PostIndex"},
                           {{al, r5, r7, plus, r1, ROR, 14, PreIndex},
                            false,
                            al,
                            "al r5 r7 plus r1 ROR 14 PreIndex",
                            "al_r5_r7_plus_r1_ROR_14_PreIndex"},
                           {{al, r9, r1, plus, r2, LSL, 20, PreIndex},
                            false,
                            al,
                            "al r9 r1 plus r2 LSL 20 PreIndex",
                            "al_r9_r1_plus_r2_LSL_20_PreIndex"},
                           {{al, r6, r8, minus, r5, ROR, 13, PostIndex},
                            false,
                            al,
                            "al r6 r8 minus r5 ROR 13 PostIndex",
                            "al_r6_r8_minus_r5_ROR_13_PostIndex"},
                           {{al, r4, r8, plus, r1, LSL, 17, PreIndex},
                            false,
                            al,
                            "al r4 r8 plus r1 LSL 17 PreIndex",
                            "al_r4_r8_plus_r1_LSL_17_PreIndex"},
                           {{al, r11, r13, plus, r6, LSL, 31, PostIndex},
                            false,
                            al,
                            "al r11 r13 plus r6 LSL 31 PostIndex",
                            "al_r11_r13_plus_r6_LSL_31_PostIndex"},
                           {{al, r9, r0, minus, r4, LSL, 7, PostIndex},
                            false,
                            al,
                            "al r9 r0 minus r4 LSL 7 PostIndex",
                            "al_r9_r0_minus_r4_LSL_7_PostIndex"},
                           {{al, r4, r1, minus, r6, LSL, 11, PreIndex},
                            false,
                            al,
                            "al r4 r1 minus r6 LSL 11 PreIndex",
                            "al_r4_r1_minus_r6_LSL_11_PreIndex"},
                           {{al, r10, r13, plus, r11, ROR, 14, PostIndex},
                            false,
                            al,
                            "al r10 r13 plus r11 ROR 14 PostIndex",
                            "al_r10_r13_plus_r11_ROR_14_PostIndex"},
                           {{al, r12, r11, plus, r9, ROR, 31, PreIndex},
                            false,
                            al,
                            "al r12 r11 plus r9 ROR 31 PreIndex",
                            "al_r12_r11_plus_r9_ROR_31_PreIndex"},
                           {{al, r9, r1, minus, r2, ROR, 5, PreIndex},
                            false,
                            al,
                            "al r9 r1 minus r2 ROR 5 PreIndex",
                            "al_r9_r1_minus_r2_ROR_5_PreIndex"},
                           {{al, r1, r10, minus, r4, LSL, 18, PostIndex},
                            false,
                            al,
                            "al r1 r10 minus r4 LSL 18 PostIndex",
                            "al_r1_r10_minus_r4_LSL_18_PostIndex"},
                           {{al, r5, r14, plus, r0, ROR, 24, PostIndex},
                            false,
                            al,
                            "al r5 r14 plus r0 ROR 24 PostIndex",
                            "al_r5_r14_plus_r0_ROR_24_PostIndex"},
                           {{al, r9, r10, plus, r1, ROR, 22, PreIndex},
                            false,
                            al,
                            "al r9 r10 plus r1 ROR 22 PreIndex",
                            "al_r9_r10_plus_r1_ROR_22_PreIndex"},
                           {{al, r12, r0, plus, r9, LSL, 9, PostIndex},
                            false,
                            al,
                            "al r12 r0 plus r9 LSL 9 PostIndex",
                            "al_r12_r0_plus_r9_LSL_9_PostIndex"},
                           {{al, r3, r11, plus, r11, ROR, 22, PreIndex},
                            false,
                            al,
                            "al r3 r11 plus r11 ROR 22 PreIndex",
                            "al_r3_r11_plus_r11_ROR_22_PreIndex"},
                           {{al, r0, r4, minus, r12, LSL, 23, PostIndex},
                            false,
                            al,
                            "al r0 r4 minus r12 LSL 23 PostIndex",
                            "al_r0_r4_minus_r12_LSL_23_PostIndex"},
                           {{al, r13, r3, minus, r6, ROR, 6, PostIndex},
                            false,
                            al,
                            "al r13 r3 minus r6 ROR 6 PostIndex",
                            "al_r13_r3_minus_r6_ROR_6_PostIndex"},
                           {{al, r10, r2, plus, r8, ROR, 10, PostIndex},
                            false,
                            al,
                            "al r10 r2 plus r8 ROR 10 PostIndex",
                            "al_r10_r2_plus_r8_ROR_10_PostIndex"},
                           {{al, r6, r13, minus, r6, ROR, 19, PostIndex},
                            false,
                            al,
                            "al r6 r13 minus r6 ROR 19 PostIndex",
                            "al_r6_r13_minus_r6_ROR_19_PostIndex"},
                           {{al, r4, r3, plus, r5, LSL, 20, PostIndex},
                            false,
                            al,
                            "al r4 r3 plus r5 LSL 20 PostIndex",
                            "al_r4_r3_plus_r5_LSL_20_PostIndex"},
                           {{al, r1, r12, minus, r6, ROR, 28, PostIndex},
                            false,
                            al,
                            "al r1 r12 minus r6 ROR 28 PostIndex",
                            "al_r1_r12_minus_r6_ROR_28_PostIndex"},
                           {{al, r2, r8, plus, r7, ROR, 17, PreIndex},
                            false,
                            al,
                            "al r2 r8 plus r7 ROR 17 PreIndex",
                            "al_r2_r8_plus_r7_ROR_17_PreIndex"},
                           {{al, r2, r5, minus, r10, ROR, 3, PreIndex},
                            false,
                            al,
                            "al r2 r5 minus r10 ROR 3 PreIndex",
                            "al_r2_r5_minus_r10_ROR_3_PreIndex"},
                           {{al, r9, r14, minus, r0, LSL, 16, PreIndex},
                            false,
                            al,
                            "al r9 r14 minus r0 LSL 16 PreIndex",
                            "al_r9_r14_minus_r0_LSL_16_PreIndex"},
                           {{al, r6, r3, minus, r10, ROR, 23, PreIndex},
                            false,
                            al,
                            "al r6 r3 minus r10 ROR 23 PreIndex",
                            "al_r6_r3_minus_r10_ROR_23_PreIndex"},
                           {{al, r0, r9, minus, r8, LSL, 11, PostIndex},
                            false,
                            al,
                            "al r0 r9 minus r8 LSL 11 PostIndex",
                            "al_r0_r9_minus_r8_LSL_11_PostIndex"},
                           {{al, r9, r2, plus, r14, LSL, 9, PreIndex},
                            false,
                            al,
                            "al r9 r2 plus r14 LSL 9 PreIndex",
                            "al_r9_r2_plus_r14_LSL_9_PreIndex"},
                           {{al, r13, r7, minus, r6, LSL, 19, PreIndex},
                            false,
                            al,
                            "al r13 r7 minus r6 LSL 19 PreIndex",
                            "al_r13_r7_minus_r6_LSL_19_PreIndex"},
                           {{al, r13, r4, minus, r2, LSL, 10, PostIndex},
                            false,
                            al,
                            "al r13 r4 minus r2 LSL 10 PostIndex",
                            "al_r13_r4_minus_r2_LSL_10_PostIndex"},
                           {{al, r9, r11, minus, r0, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r9 r11 minus r0 LSL 3 PostIndex",
                            "al_r9_r11_minus_r0_LSL_3_PostIndex"},
                           {{al, r11, r13, plus, r8, LSL, 28, PreIndex},
                            false,
                            al,
                            "al r11 r13 plus r8 LSL 28 PreIndex",
                            "al_r11_r13_plus_r8_LSL_28_PreIndex"},
                           {{al, r7, r9, minus, r7, ROR, 13, PreIndex},
                            false,
                            al,
                            "al r7 r9 minus r7 ROR 13 PreIndex",
                            "al_r7_r9_minus_r7_ROR_13_PreIndex"},
                           {{al, r13, r7, plus, r5, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r13 r7 plus r5 LSL 3 PostIndex",
                            "al_r13_r7_plus_r5_LSL_3_PostIndex"},
                           {{al, r14, r10, plus, r14, ROR, 1, PostIndex},
                            false,
                            al,
                            "al r14 r10 plus r14 ROR 1 PostIndex",
                            "al_r14_r10_plus_r14_ROR_1_PostIndex"},
                           {{al, r1, r6, plus, r14, ROR, 3, PostIndex},
                            false,
                            al,
                            "al r1 r6 plus r14 ROR 3 PostIndex",
                            "al_r1_r6_plus_r14_ROR_3_PostIndex"},
                           {{al, r12, r14, minus, r11, ROR, 17, PreIndex},
                            false,
                            al,
                            "al r12 r14 minus r11 ROR 17 PreIndex",
                            "al_r12_r14_minus_r11_ROR_17_PreIndex"},
                           {{al, r4, r5, minus, r10, LSL, 3, PostIndex},
                            false,
                            al,
                            "al r4 r5 minus r10 LSL 3 PostIndex",
                            "al_r4_r5_minus_r10_LSL_3_PostIndex"},
                           {{al, r0, r14, minus, r5, ROR, 16, PreIndex},
                            false,
                            al,
                            "al r0 r14 minus r5 ROR 16 PreIndex",
                            "al_r0_r14_minus_r5_ROR_16_PreIndex"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-memop-rs-shift-amount-1to31-ldr-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-rs-shift-amount-1to31-ldrb-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-rs-shift-amount-1to31-str-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-rs-shift-amount-1to31-strb-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseA32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    Register rm = kTests[i].operands.rm;
    ShiftType shift = kTests[i].operands.shift;
    uint32_t amount = kTests[i].operands.amount;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, rm, shift, amount, addr_mode);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, memop);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_MEMOP_RS_SHIFT_AMOUNT_1TO31_" #mnemonic    \
      "_A32",                                                               \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
