// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-simulator-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/disasm-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define __ masm.
#define BUF_SIZE (4096)

#ifdef VIXL_INCLUDE_SIMULATOR_AARCH32
// Run tests with the simulator.

#define SETUP() MacroAssembler masm(BUF_SIZE)

#define START() masm.GetBuffer()->Reset()

#define END() \
  __ Hlt(0);  \
  __ FinalizeCode();

// TODO: Run the tests in the simulator.
#define RUN()

#else  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32.

#define SETUP()                  \
  MacroAssembler masm(BUF_SIZE); \
  UseScratchRegisterScope harness_scratch;

#define START()                 \
  harness_scratch.Open(&masm);  \
  harness_scratch.ExcludeAll(); \
  masm.GetBuffer()->Reset();    \
  __ Push(r4);                  \
  __ Push(r5);                  \
  __ Push(r6);                  \
  __ Push(r7);                  \
  __ Push(r8);                  \
  __ Push(r9);                  \
  __ Push(r10);                 \
  __ Push(r11);                 \
  __ Push(lr);                  \
  harness_scratch.Include(ip);

#define END()                  \
  harness_scratch.Exclude(ip); \
  __ Pop(lr);                  \
  __ Pop(r11);                 \
  __ Pop(r10);                 \
  __ Pop(r9);                  \
  __ Pop(r8);                  \
  __ Pop(r7);                  \
  __ Pop(r6);                  \
  __ Pop(r5);                  \
  __ Pop(r4);                  \
  __ Bx(lr);                   \
  __ FinalizeCode();           \
  harness_scratch.Close();

#define RUN()                                                 \
  {                                                           \
    int pcs_offset = masm.IsUsingT32() ? 1 : 0;               \
    masm.GetBuffer()->SetExecutable();                        \
    ExecuteMemory(masm.GetBuffer()->GetStartAddress<byte*>(), \
                  masm.GetSizeOfCodeGenerated(),              \
                  pcs_offset);                                \
    masm.GetBuffer()->SetWritable();                          \
  }

#endif  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32

namespace vixl {
namespace aarch32 {

// List of instruction encodings:
#define FOREACH_INSTRUCTION(M) \
  M(Ldrh)                      \
  M(Ldrsh)                     \
  M(Ldrsb)                     \
  M(Strh)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` and
// `Inputs` have various layouts across generated tests so they absolutely
// cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  int32_t offset;
  AddrMode addr_mode;
};

// Input data to feed to the instruction.
struct Inputs {
  uint32_t apsr;
  uint32_t rd;
  uint32_t memop[2];
};

// This structure contains all input data needed to test one specific encoding.
// It used to generate a loop over an instruction.
struct TestLoopData {
  // The `operands` fields represents the values to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
  // Array of values to be fed to the instruction.
  size_t input_size;
  const Inputs* inputs;
};

static const Inputs kCondition[] = {{NFlag, 0xabababab, {0, 0x77777777}},
                                    {ZFlag, 0xabababab, {0, 0x77777777}},
                                    {CFlag, 0xabababab, {0, 0x77777777}},
                                    {VFlag, 0xabababab, {0, 0x77777777}},
                                    {NZFlag, 0xabababab, {0, 0x77777777}},
                                    {NCFlag, 0xabababab, {0, 0x77777777}},
                                    {NVFlag, 0xabababab, {0, 0x77777777}},
                                    {ZCFlag, 0xabababab, {0, 0x77777777}},
                                    {ZVFlag, 0xabababab, {0, 0x77777777}},
                                    {CVFlag, 0xabababab, {0, 0x77777777}},
                                    {NZCFlag, 0xabababab, {0, 0x77777777}},
                                    {NZVFlag, 0xabababab, {0, 0x77777777}},
                                    {NCVFlag, 0xabababab, {0, 0x77777777}},
                                    {ZCVFlag, 0xabababab, {0, 0x77777777}},
                                    {NZCVFlag, 0xabababab, {0, 0x77777777}}};

static const Inputs kPositiveOffset[] = {{NoFlag, 0x00000000, {0, 0x0badbeef}},
                                         {NoFlag, 0x00000020, {0, 0x0badbeef}},
                                         {NoFlag, 0x00000020, {0, 0x55555555}},
                                         {NoFlag, 0x33333333, {0, 0x0badbeef}},
                                         {NoFlag, 0x00000002, {0, 0x0cabba9e}},
                                         {NoFlag, 0x7fffffff, {0, 0x0cabba9e}},
                                         {NoFlag, 0xcccccccc, {0, 0x77777777}},
                                         {NoFlag, 0x7ffffffd, {0, 0x55555555}},
                                         {NoFlag, 0xffffff83, {0, 0x77777777}},
                                         {NoFlag, 0xaaaaaaaa, {0, 0x77777777}}};

static const Inputs kNegativeOffset[] = {{NoFlag, 0xcccccccc, {0, 0x0badbeef}},
                                         {NoFlag, 0x0000007f, {0, 0x0cabba9e}},
                                         {NoFlag, 0x00007ffe, {0, 0x55555555}},
                                         {NoFlag, 0xffffffff, {0, 0x0cabba9e}},
                                         {NoFlag, 0x00007ffd, {0, 0x77777777}},
                                         {NoFlag, 0x0000007d, {0, 0x0badbeef}},
                                         {NoFlag, 0xffff8001, {0, 0x0cabba9e}},
                                         {NoFlag, 0xaaaaaaaa, {0, 0x55555555}},
                                         {NoFlag, 0x55555555, {0, 0x0badbeef}},
                                         {NoFlag, 0xffffff82, {0, 0x77777777}}};

static const Inputs kPositivePostIndex[] =
    {{NoFlag, 0xffff8003, {0, 0x77777777}},
     {NoFlag, 0xfffffffd, {0, 0x55555555}},
     {NoFlag, 0xffffff83, {0, 0x0cabba9e}},
     {NoFlag, 0x7ffffffd, {0, 0x0badbeef}},
     {NoFlag, 0xcccccccc, {0, 0x55555555}},
     {NoFlag, 0x00007ffd, {0, 0x55555555}},
     {NoFlag, 0x00007fff, {0, 0x0badbeef}},
     {NoFlag, 0x00000020, {0, 0x77777777}},
     {NoFlag, 0x80000000, {0, 0x0cabba9e}},
     {NoFlag, 0x80000001, {0, 0x0badbeef}}};

static const Inputs kNegativePostIndex[] =
    {{NoFlag, 0x80000001, {0, 0x77777777}},
     {NoFlag, 0x7ffffffe, {0, 0x0badbeef}},
     {NoFlag, 0x0000007d, {0, 0x0badbeef}},
     {NoFlag, 0x0000007d, {0, 0x77777777}},
     {NoFlag, 0xcccccccc, {0, 0x77777777}},
     {NoFlag, 0xffff8003, {0, 0x77777777}},
     {NoFlag, 0x00000001, {0, 0x77777777}},
     {NoFlag, 0xffff8003, {0, 0x0badbeef}},
     {NoFlag, 0xffff8000, {0, 0x0badbeef}},
     {NoFlag, 0xffffff80, {0, 0x0badbeef}}};

static const Inputs kPositivePreIndex[] =
    {{NoFlag, 0xffff8003, {0, 0x55555555}},
     {NoFlag, 0x7ffffffd, {0, 0x55555555}},
     {NoFlag, 0x33333333, {0, 0x77777777}},
     {NoFlag, 0xcccccccc, {0, 0x0cabba9e}},
     {NoFlag, 0xffffffff, {0, 0x0cabba9e}},
     {NoFlag, 0x33333333, {0, 0x55555555}},
     {NoFlag, 0xffffff82, {0, 0x77777777}},
     {NoFlag, 0x55555555, {0, 0x0cabba9e}},
     {NoFlag, 0xfffffffe, {0, 0x77777777}},
     {NoFlag, 0x0000007e, {0, 0x0cabba9e}}};

static const Inputs kNegativePreIndex[] =
    {{NoFlag, 0x00007ffd, {0, 0x0badbeef}},
     {NoFlag, 0xffffffff, {0, 0x77777777}},
     {NoFlag, 0x00000002, {0, 0x0cabba9e}},
     {NoFlag, 0xfffffffd, {0, 0x0cabba9e}},
     {NoFlag, 0x7ffffffd, {0, 0x77777777}},
     {NoFlag, 0xffffffff, {0, 0x55555555}},
     {NoFlag, 0x00007ffe, {0, 0x77777777}},
     {NoFlag, 0xffffff82, {0, 0x0cabba9e}},
     {NoFlag, 0x0000007e, {0, 0x55555555}},
     {NoFlag, 0x7ffffffe, {0, 0x77777777}}};


// A loop will be generated for each element of this array.
const TestLoopData kTests[] =
    {{{eq, r0, r1, plus, 0, Offset},
      "eq r0 r1 plus 0 Offset",
      "Condition_eq_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ne, r0, r1, plus, 0, Offset},
      "ne r0 r1 plus 0 Offset",
      "Condition_ne_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cs, r0, r1, plus, 0, Offset},
      "cs r0 r1 plus 0 Offset",
      "Condition_cs_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cc, r0, r1, plus, 0, Offset},
      "cc r0 r1 plus 0 Offset",
      "Condition_cc_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{mi, r0, r1, plus, 0, Offset},
      "mi r0 r1 plus 0 Offset",
      "Condition_mi_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{pl, r0, r1, plus, 0, Offset},
      "pl r0 r1 plus 0 Offset",
      "Condition_pl_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vs, r0, r1, plus, 0, Offset},
      "vs r0 r1 plus 0 Offset",
      "Condition_vs_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vc, r0, r1, plus, 0, Offset},
      "vc r0 r1 plus 0 Offset",
      "Condition_vc_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{hi, r0, r1, plus, 0, Offset},
      "hi r0 r1 plus 0 Offset",
      "Condition_hi_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ls, r0, r1, plus, 0, Offset},
      "ls r0 r1 plus 0 Offset",
      "Condition_ls_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ge, r0, r1, plus, 0, Offset},
      "ge r0 r1 plus 0 Offset",
      "Condition_ge_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{lt, r0, r1, plus, 0, Offset},
      "lt r0 r1 plus 0 Offset",
      "Condition_lt_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{gt, r0, r1, plus, 0, Offset},
      "gt r0 r1 plus 0 Offset",
      "Condition_gt_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{le, r0, r1, plus, 0, Offset},
      "le r0 r1 plus 0 Offset",
      "Condition_le_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r1, plus, 0, Offset},
      "al r0 r1 plus 0 Offset",
      "Condition_al_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r6, plus, 126, Offset},
      "al r0 r6 plus 126 Offset",
      "PositiveOffset_al_r0_r6_plus_126_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r4, plus, 106, Offset},
      "al r2 r4 plus 106 Offset",
      "PositiveOffset_al_r2_r4_plus_106_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r1, plus, 108, Offset},
      "al r2 r1 plus 108 Offset",
      "PositiveOffset_al_r2_r1_plus_108_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r8, plus, 186, Offset},
      "al r6 r8 plus 186 Offset",
      "PositiveOffset_al_r6_r8_plus_186_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r11, plus, 233, Offset},
      "al r1 r11 plus 233 Offset",
      "PositiveOffset_al_r1_r11_plus_233_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r2, plus, 89, Offset},
      "al r9 r2 plus 89 Offset",
      "PositiveOffset_al_r9_r2_plus_89_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r1, plus, 103, Offset},
      "al r11 r1 plus 103 Offset",
      "PositiveOffset_al_r11_r1_plus_103_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r8, plus, 42, Offset},
      "al r7 r8 plus 42 Offset",
      "PositiveOffset_al_r7_r8_plus_42_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r6, plus, 158, Offset},
      "al r10 r6 plus 158 Offset",
      "PositiveOffset_al_r10_r6_plus_158_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r11, plus, 164, Offset},
      "al r10 r11 plus 164 Offset",
      "PositiveOffset_al_r10_r11_plus_164_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r14, plus, 211, Offset},
      "al r8 r14 plus 211 Offset",
      "PositiveOffset_al_r8_r14_plus_211_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r7, plus, 46, Offset},
      "al r2 r7 plus 46 Offset",
      "PositiveOffset_al_r2_r7_plus_46_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r4, plus, 196, Offset},
      "al r1 r4 plus 196 Offset",
      "PositiveOffset_al_r1_r4_plus_196_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r9, plus, 232, Offset},
      "al r5 r9 plus 232 Offset",
      "PositiveOffset_al_r5_r9_plus_232_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r4, plus, 204, Offset},
      "al r8 r4 plus 204 Offset",
      "PositiveOffset_al_r8_r4_plus_204_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r2, plus, 210, Offset},
      "al r4 r2 plus 210 Offset",
      "PositiveOffset_al_r4_r2_plus_210_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r1, plus, 136, Offset},
      "al r14 r1 plus 136 Offset",
      "PositiveOffset_al_r14_r1_plus_136_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r10, plus, 32, Offset},
      "al r11 r10 plus 32 Offset",
      "PositiveOffset_al_r11_r10_plus_32_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r11, plus, 23, Offset},
      "al r10 r11 plus 23 Offset",
      "PositiveOffset_al_r10_r11_plus_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r0, plus, 199, Offset},
      "al r3 r0 plus 199 Offset",
      "PositiveOffset_al_r3_r0_plus_199_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r6, plus, 46, Offset},
      "al r0 r6 plus 46 Offset",
      "PositiveOffset_al_r0_r6_plus_46_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r3, plus, 31, Offset},
      "al r5 r3 plus 31 Offset",
      "PositiveOffset_al_r5_r3_plus_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r8, plus, 143, Offset},
      "al r9 r8 plus 143 Offset",
      "PositiveOffset_al_r9_r8_plus_143_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r9, plus, 224, Offset},
      "al r11 r9 plus 224 Offset",
      "PositiveOffset_al_r11_r9_plus_224_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r14, plus, 48, Offset},
      "al r5 r14 plus 48 Offset",
      "PositiveOffset_al_r5_r14_plus_48_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r3, plus, 252, Offset},
      "al r14 r3 plus 252 Offset",
      "PositiveOffset_al_r14_r3_plus_252_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r11, plus, 159, Offset},
      "al r0 r11 plus 159 Offset",
      "PositiveOffset_al_r0_r11_plus_159_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r4, plus, 181, Offset},
      "al r12 r4 plus 181 Offset",
      "PositiveOffset_al_r12_r4_plus_181_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r1, plus, 28, Offset},
      "al r9 r1 plus 28 Offset",
      "PositiveOffset_al_r9_r1_plus_28_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r5, plus, 245, Offset},
      "al r1 r5 plus 245 Offset",
      "PositiveOffset_al_r1_r5_plus_245_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r5, plus, 186, Offset},
      "al r3 r5 plus 186 Offset",
      "PositiveOffset_al_r3_r5_plus_186_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r0, plus, 238, Offset},
      "al r1 r0 plus 238 Offset",
      "PositiveOffset_al_r1_r0_plus_238_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r8, plus, 228, Offset},
      "al r4 r8 plus 228 Offset",
      "PositiveOffset_al_r4_r8_plus_228_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r9, plus, 17, Offset},
      "al r5 r9 plus 17 Offset",
      "PositiveOffset_al_r5_r9_plus_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r7, plus, 190, Offset},
      "al r5 r7 plus 190 Offset",
      "PositiveOffset_al_r5_r7_plus_190_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r4, plus, 6, Offset},
      "al r14 r4 plus 6 Offset",
      "PositiveOffset_al_r14_r4_plus_6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r3, plus, 24, Offset},
      "al r0 r3 plus 24 Offset",
      "PositiveOffset_al_r0_r3_plus_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r14, plus, 247, Offset},
      "al r12 r14 plus 247 Offset",
      "PositiveOffset_al_r12_r14_plus_247_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r3, plus, 242, Offset},
      "al r12 r3 plus 242 Offset",
      "PositiveOffset_al_r12_r3_plus_242_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r8, plus, 211, Offset},
      "al r7 r8 plus 211 Offset",
      "PositiveOffset_al_r7_r8_plus_211_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r14, plus, 203, Offset},
      "al r12 r14 plus 203 Offset",
      "PositiveOffset_al_r12_r14_plus_203_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r12, plus, 119, Offset},
      "al r9 r12 plus 119 Offset",
      "PositiveOffset_al_r9_r12_plus_119_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r7, plus, 132, Offset},
      "al r1 r7 plus 132 Offset",
      "PositiveOffset_al_r1_r7_plus_132_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r4, plus, 96, Offset},
      "al r3 r4 plus 96 Offset",
      "PositiveOffset_al_r3_r4_plus_96_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r8, plus, 230, Offset},
      "al r0 r8 plus 230 Offset",
      "PositiveOffset_al_r0_r8_plus_230_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r5, plus, 10, Offset},
      "al r0 r5 plus 10 Offset",
      "PositiveOffset_al_r0_r5_plus_10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r5, plus, 185, Offset},
      "al r14 r5 plus 185 Offset",
      "PositiveOffset_al_r14_r5_plus_185_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r3, plus, 180, Offset},
      "al r6 r3 plus 180 Offset",
      "PositiveOffset_al_r6_r3_plus_180_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r11, plus, 5, Offset},
      "al r10 r11 plus 5 Offset",
      "PositiveOffset_al_r10_r11_plus_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r11, plus, 78, Offset},
      "al r4 r11 plus 78 Offset",
      "PositiveOffset_al_r4_r11_plus_78_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r6, plus, 101, Offset},
      "al r11 r6 plus 101 Offset",
      "PositiveOffset_al_r11_r6_plus_101_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r6, plus, 203, Offset},
      "al r3 r6 plus 203 Offset",
      "PositiveOffset_al_r3_r6_plus_203_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r2, plus, 93, Offset},
      "al r4 r2 plus 93 Offset",
      "PositiveOffset_al_r4_r2_plus_93_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, 213, Offset},
      "al r8 r2 plus 213 Offset",
      "PositiveOffset_al_r8_r2_plus_213_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r14, plus, 92, Offset},
      "al r4 r14 plus 92 Offset",
      "PositiveOffset_al_r4_r14_plus_92_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r12, plus, 250, Offset},
      "al r11 r12 plus 250 Offset",
      "PositiveOffset_al_r11_r12_plus_250_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r14, plus, 181, Offset},
      "al r8 r14 plus 181 Offset",
      "PositiveOffset_al_r8_r14_plus_181_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r2, plus, 30, Offset},
      "al r11 r2 plus 30 Offset",
      "PositiveOffset_al_r11_r2_plus_30_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r11, plus, 102, Offset},
      "al r7 r11 plus 102 Offset",
      "PositiveOffset_al_r7_r11_plus_102_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r8, plus, 135, Offset},
      "al r6 r8 plus 135 Offset",
      "PositiveOffset_al_r6_r8_plus_135_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r6, plus, 19, Offset},
      "al r10 r6 plus 19 Offset",
      "PositiveOffset_al_r10_r6_plus_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r12, plus, 130, Offset},
      "al r6 r12 plus 130 Offset",
      "PositiveOffset_al_r6_r12_plus_130_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r2, plus, 187, Offset},
      "al r9 r2 plus 187 Offset",
      "PositiveOffset_al_r9_r2_plus_187_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r5, plus, 134, Offset},
      "al r12 r5 plus 134 Offset",
      "PositiveOffset_al_r12_r5_plus_134_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r4, plus, 101, Offset},
      "al r5 r4 plus 101 Offset",
      "PositiveOffset_al_r5_r4_plus_101_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r9, plus, 124, Offset},
      "al r14 r9 plus 124 Offset",
      "PositiveOffset_al_r14_r9_plus_124_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r14, plus, 119, Offset},
      "al r9 r14 plus 119 Offset",
      "PositiveOffset_al_r9_r14_plus_119_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r1, plus, 9, Offset},
      "al r8 r1 plus 9 Offset",
      "PositiveOffset_al_r8_r1_plus_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, 6, Offset},
      "al r6 r14 plus 6 Offset",
      "PositiveOffset_al_r6_r14_plus_6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, 162, Offset},
      "al r6 r14 plus 162 Offset",
      "PositiveOffset_al_r6_r14_plus_162_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r8, plus, 36, Offset},
      "al r3 r8 plus 36 Offset",
      "PositiveOffset_al_r3_r8_plus_36_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r1, plus, 32, Offset},
      "al r3 r1 plus 32 Offset",
      "PositiveOffset_al_r3_r1_plus_32_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r0, plus, 90, Offset},
      "al r9 r0 plus 90 Offset",
      "PositiveOffset_al_r9_r0_plus_90_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r10, plus, 131, Offset},
      "al r11 r10 plus 131 Offset",
      "PositiveOffset_al_r11_r10_plus_131_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r12, plus, 34, Offset},
      "al r7 r12 plus 34 Offset",
      "PositiveOffset_al_r7_r12_plus_34_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r9, plus, 145, Offset},
      "al r0 r9 plus 145 Offset",
      "PositiveOffset_al_r0_r9_plus_145_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r2, plus, 101, Offset},
      "al r3 r2 plus 101 Offset",
      "PositiveOffset_al_r3_r2_plus_101_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r6, plus, 236, Offset},
      "al r12 r6 plus 236 Offset",
      "PositiveOffset_al_r12_r6_plus_236_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, 111, Offset},
      "al r8 r2 plus 111 Offset",
      "PositiveOffset_al_r8_r2_plus_111_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r6, plus, 80, Offset},
      "al r12 r6 plus 80 Offset",
      "PositiveOffset_al_r12_r6_plus_80_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r0, plus, 17, Offset},
      "al r6 r0 plus 17 Offset",
      "PositiveOffset_al_r6_r0_plus_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r3, plus, 50, Offset},
      "al r0 r3 plus 50 Offset",
      "PositiveOffset_al_r0_r3_plus_50_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r7, plus, 238, Offset},
      "al r8 r7 plus 238 Offset",
      "PositiveOffset_al_r8_r7_plus_238_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r0, plus, 101, Offset},
      "al r5 r0 plus 101 Offset",
      "PositiveOffset_al_r5_r0_plus_101_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r9, plus, 38, Offset},
      "al r2 r9 plus 38 Offset",
      "PositiveOffset_al_r2_r9_plus_38_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r7, plus, 169, Offset},
      "al r8 r7 plus 169 Offset",
      "PositiveOffset_al_r8_r7_plus_169_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r8, plus, 241, Offset},
      "al r11 r8 plus 241 Offset",
      "PositiveOffset_al_r11_r8_plus_241_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r5, plus, 218, Offset},
      "al r6 r5 plus 218 Offset",
      "PositiveOffset_al_r6_r5_plus_218_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r5, plus, 126, Offset},
      "al r11 r5 plus 126 Offset",
      "PositiveOffset_al_r11_r5_plus_126_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r3, plus, 250, Offset},
      "al r5 r3 plus 250 Offset",
      "PositiveOffset_al_r5_r3_plus_250_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, 46, Offset},
      "al r0 r12 plus 46 Offset",
      "PositiveOffset_al_r0_r12_plus_46_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, 124, Offset},
      "al r6 r14 plus 124 Offset",
      "PositiveOffset_al_r6_r14_plus_124_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r3, plus, 237, Offset},
      "al r1 r3 plus 237 Offset",
      "PositiveOffset_al_r1_r3_plus_237_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r1, plus, 42, Offset},
      "al r9 r1 plus 42 Offset",
      "PositiveOffset_al_r9_r1_plus_42_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r9, plus, 17, Offset},
      "al r2 r9 plus 17 Offset",
      "PositiveOffset_al_r2_r9_plus_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r0, plus, 206, Offset},
      "al r7 r0 plus 206 Offset",
      "PositiveOffset_al_r7_r0_plus_206_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r14, plus, 248, Offset},
      "al r2 r14 plus 248 Offset",
      "PositiveOffset_al_r2_r14_plus_248_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r11, plus, 2, Offset},
      "al r4 r11 plus 2 Offset",
      "PositiveOffset_al_r4_r11_plus_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r5, plus, 213, Offset},
      "al r0 r5 plus 213 Offset",
      "PositiveOffset_al_r0_r5_plus_213_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r9, plus, 229, Offset},
      "al r0 r9 plus 229 Offset",
      "PositiveOffset_al_r0_r9_plus_229_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r6, minus, 4, Offset},
      "al r11 r6 minus 4 Offset",
      "NegativeOffset_al_r11_r6_minus_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r3, minus, 59, Offset},
      "al r4 r3 minus 59 Offset",
      "NegativeOffset_al_r4_r3_minus_59_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r2, minus, 23, Offset},
      "al r5 r2 minus 23 Offset",
      "NegativeOffset_al_r5_r2_minus_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r6, minus, 97, Offset},
      "al r11 r6 minus 97 Offset",
      "NegativeOffset_al_r11_r6_minus_97_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r6, minus, 239, Offset},
      "al r4 r6 minus 239 Offset",
      "NegativeOffset_al_r4_r6_minus_239_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r12, minus, 36, Offset},
      "al r2 r12 minus 36 Offset",
      "NegativeOffset_al_r2_r12_minus_36_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r11, minus, 6, Offset},
      "al r12 r11 minus 6 Offset",
      "NegativeOffset_al_r12_r11_minus_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r9, minus, 11, Offset},
      "al r10 r9 minus 11 Offset",
      "NegativeOffset_al_r10_r9_minus_11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r1, minus, 0, Offset},
      "al r7 r1 minus 0 Offset",
      "NegativeOffset_al_r7_r1_minus_0_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r9, minus, 148, Offset},
      "al r10 r9 minus 148 Offset",
      "NegativeOffset_al_r10_r9_minus_148_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r2, minus, 249, Offset},
      "al r11 r2 minus 249 Offset",
      "NegativeOffset_al_r11_r2_minus_249_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r8, minus, 99, Offset},
      "al r9 r8 minus 99 Offset",
      "NegativeOffset_al_r9_r8_minus_99_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r4, minus, 43, Offset},
      "al r9 r4 minus 43 Offset",
      "NegativeOffset_al_r9_r4_minus_43_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r9, minus, 43, Offset},
      "al r14 r9 minus 43 Offset",
      "NegativeOffset_al_r14_r9_minus_43_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r7, minus, 52, Offset},
      "al r8 r7 minus 52 Offset",
      "NegativeOffset_al_r8_r7_minus_52_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r3, minus, 171, Offset},
      "al r9 r3 minus 171 Offset",
      "NegativeOffset_al_r9_r3_minus_171_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r1, minus, 119, Offset},
      "al r5 r1 minus 119 Offset",
      "NegativeOffset_al_r5_r1_minus_119_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r12, minus, 144, Offset},
      "al r14 r12 minus 144 Offset",
      "NegativeOffset_al_r14_r12_minus_144_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r5, minus, 111, Offset},
      "al r0 r5 minus 111 Offset",
      "NegativeOffset_al_r0_r5_minus_111_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r1, minus, 85, Offset},
      "al r2 r1 minus 85 Offset",
      "NegativeOffset_al_r2_r1_minus_85_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r3, minus, 68, Offset},
      "al r7 r3 minus 68 Offset",
      "NegativeOffset_al_r7_r3_minus_68_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r3, minus, 4, Offset},
      "al r11 r3 minus 4 Offset",
      "NegativeOffset_al_r11_r3_minus_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r5, minus, 178, Offset},
      "al r3 r5 minus 178 Offset",
      "NegativeOffset_al_r3_r5_minus_178_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r5, minus, 40, Offset},
      "al r7 r5 minus 40 Offset",
      "NegativeOffset_al_r7_r5_minus_40_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r7, minus, 117, Offset},
      "al r5 r7 minus 117 Offset",
      "NegativeOffset_al_r5_r7_minus_117_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r10, minus, 118, Offset},
      "al r14 r10 minus 118 Offset",
      "NegativeOffset_al_r14_r10_minus_118_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, 118, Offset},
      "al r3 r10 minus 118 Offset",
      "NegativeOffset_al_r3_r10_minus_118_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r9, minus, 34, Offset},
      "al r14 r9 minus 34 Offset",
      "NegativeOffset_al_r14_r9_minus_34_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r8, minus, 135, Offset},
      "al r5 r8 minus 135 Offset",
      "NegativeOffset_al_r5_r8_minus_135_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r1, minus, 121, Offset},
      "al r3 r1 minus 121 Offset",
      "NegativeOffset_al_r3_r1_minus_121_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r1, minus, 150, Offset},
      "al r2 r1 minus 150 Offset",
      "NegativeOffset_al_r2_r1_minus_150_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r2, minus, 10, Offset},
      "al r0 r2 minus 10 Offset",
      "NegativeOffset_al_r0_r2_minus_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r6, minus, 222, Offset},
      "al r5 r6 minus 222 Offset",
      "NegativeOffset_al_r5_r6_minus_222_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r9, minus, 150, Offset},
      "al r3 r9 minus 150 Offset",
      "NegativeOffset_al_r3_r9_minus_150_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r0, minus, 154, Offset},
      "al r5 r0 minus 154 Offset",
      "NegativeOffset_al_r5_r0_minus_154_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r0, minus, 11, Offset},
      "al r5 r0 minus 11 Offset",
      "NegativeOffset_al_r5_r0_minus_11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, 149, Offset},
      "al r1 r11 minus 149 Offset",
      "NegativeOffset_al_r1_r11_minus_149_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r9, minus, 146, Offset},
      "al r0 r9 minus 146 Offset",
      "NegativeOffset_al_r0_r9_minus_146_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r8, minus, 129, Offset},
      "al r9 r8 minus 129 Offset",
      "NegativeOffset_al_r9_r8_minus_129_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r0, minus, 88, Offset},
      "al r11 r0 minus 88 Offset",
      "NegativeOffset_al_r11_r0_minus_88_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r12, minus, 5, Offset},
      "al r10 r12 minus 5 Offset",
      "NegativeOffset_al_r10_r12_minus_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r5, minus, 90, Offset},
      "al r9 r5 minus 90 Offset",
      "NegativeOffset_al_r9_r5_minus_90_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r6, minus, 28, Offset},
      "al r8 r6 minus 28 Offset",
      "NegativeOffset_al_r8_r6_minus_28_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r7, minus, 66, Offset},
      "al r0 r7 minus 66 Offset",
      "NegativeOffset_al_r0_r7_minus_66_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r14, minus, 2, Offset},
      "al r6 r14 minus 2 Offset",
      "NegativeOffset_al_r6_r14_minus_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r2, minus, 240, Offset},
      "al r4 r2 minus 240 Offset",
      "NegativeOffset_al_r4_r2_minus_240_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r9, minus, 66, Offset},
      "al r3 r9 minus 66 Offset",
      "NegativeOffset_al_r3_r9_minus_66_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r10, minus, 52, Offset},
      "al r9 r10 minus 52 Offset",
      "NegativeOffset_al_r9_r10_minus_52_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r6, minus, 38, Offset},
      "al r7 r6 minus 38 Offset",
      "NegativeOffset_al_r7_r6_minus_38_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r12, minus, 7, Offset},
      "al r5 r12 minus 7 Offset",
      "NegativeOffset_al_r5_r12_minus_7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r5, minus, 6, Offset},
      "al r8 r5 minus 6 Offset",
      "NegativeOffset_al_r8_r5_minus_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r10, minus, 251, Offset},
      "al r2 r10 minus 251 Offset",
      "NegativeOffset_al_r2_r10_minus_251_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r8, minus, 11, Offset},
      "al r11 r8 minus 11 Offset",
      "NegativeOffset_al_r11_r8_minus_11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r11, minus, 97, Offset},
      "al r4 r11 minus 97 Offset",
      "NegativeOffset_al_r4_r11_minus_97_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r2, minus, 21, Offset},
      "al r14 r2 minus 21 Offset",
      "NegativeOffset_al_r14_r2_minus_21_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r1, minus, 127, Offset},
      "al r12 r1 minus 127 Offset",
      "NegativeOffset_al_r12_r1_minus_127_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r9, minus, 144, Offset},
      "al r0 r9 minus 144 Offset",
      "NegativeOffset_al_r0_r9_minus_144_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r4, minus, 6, Offset},
      "al r8 r4 minus 6 Offset",
      "NegativeOffset_al_r8_r4_minus_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r2, minus, 128, Offset},
      "al r7 r2 minus 128 Offset",
      "NegativeOffset_al_r7_r2_minus_128_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r9, minus, 79, Offset},
      "al r0 r9 minus 79 Offset",
      "NegativeOffset_al_r0_r9_minus_79_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r6, minus, 53, Offset},
      "al r7 r6 minus 53 Offset",
      "NegativeOffset_al_r7_r6_minus_53_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, 32, Offset},
      "al r4 r9 minus 32 Offset",
      "NegativeOffset_al_r4_r9_minus_32_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r8, minus, 146, Offset},
      "al r4 r8 minus 146 Offset",
      "NegativeOffset_al_r4_r8_minus_146_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r3, minus, 228, Offset},
      "al r5 r3 minus 228 Offset",
      "NegativeOffset_al_r5_r3_minus_228_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r0, minus, 42, Offset},
      "al r2 r0 minus 42 Offset",
      "NegativeOffset_al_r2_r0_minus_42_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r8, minus, 85, Offset},
      "al r1 r8 minus 85 Offset",
      "NegativeOffset_al_r1_r8_minus_85_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r1, minus, 137, Offset},
      "al r3 r1 minus 137 Offset",
      "NegativeOffset_al_r3_r1_minus_137_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r8, minus, 6, Offset},
      "al r5 r8 minus 6 Offset",
      "NegativeOffset_al_r5_r8_minus_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r4, minus, 58, Offset},
      "al r5 r4 minus 58 Offset",
      "NegativeOffset_al_r5_r4_minus_58_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r11, minus, 41, Offset},
      "al r5 r11 minus 41 Offset",
      "NegativeOffset_al_r5_r11_minus_41_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r8, minus, 27, Offset},
      "al r7 r8 minus 27 Offset",
      "NegativeOffset_al_r7_r8_minus_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r7, minus, 58, Offset},
      "al r6 r7 minus 58 Offset",
      "NegativeOffset_al_r6_r7_minus_58_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r5, minus, 6, Offset},
      "al r7 r5 minus 6 Offset",
      "NegativeOffset_al_r7_r5_minus_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r3, minus, 167, Offset},
      "al r9 r3 minus 167 Offset",
      "NegativeOffset_al_r9_r3_minus_167_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r4, minus, 44, Offset},
      "al r6 r4 minus 44 Offset",
      "NegativeOffset_al_r6_r4_minus_44_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r1, minus, 115, Offset},
      "al r8 r1 minus 115 Offset",
      "NegativeOffset_al_r8_r1_minus_115_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r8, minus, 127, Offset},
      "al r4 r8 minus 127 Offset",
      "NegativeOffset_al_r4_r8_minus_127_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r1, minus, 247, Offset},
      "al r6 r1 minus 247 Offset",
      "NegativeOffset_al_r6_r1_minus_247_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r2, minus, 113, Offset},
      "al r5 r2 minus 113 Offset",
      "NegativeOffset_al_r5_r2_minus_113_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r5, minus, 197, Offset},
      "al r10 r5 minus 197 Offset",
      "NegativeOffset_al_r10_r5_minus_197_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r14, minus, 149, Offset},
      "al r3 r14 minus 149 Offset",
      "NegativeOffset_al_r3_r14_minus_149_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, 71, Offset},
      "al r4 r9 minus 71 Offset",
      "NegativeOffset_al_r4_r9_minus_71_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r5, minus, 65, Offset},
      "al r9 r5 minus 65 Offset",
      "NegativeOffset_al_r9_r5_minus_65_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r12, minus, 238, Offset},
      "al r1 r12 minus 238 Offset",
      "NegativeOffset_al_r1_r12_minus_238_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r12, minus, 102, Offset},
      "al r8 r12 minus 102 Offset",
      "NegativeOffset_al_r8_r12_minus_102_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r0, minus, 49, Offset},
      "al r14 r0 minus 49 Offset",
      "NegativeOffset_al_r14_r0_minus_49_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r5, minus, 63, Offset},
      "al r12 r5 minus 63 Offset",
      "NegativeOffset_al_r12_r5_minus_63_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r3, minus, 146, Offset},
      "al r9 r3 minus 146 Offset",
      "NegativeOffset_al_r9_r3_minus_146_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r0, minus, 36, Offset},
      "al r14 r0 minus 36 Offset",
      "NegativeOffset_al_r14_r0_minus_36_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r5, minus, 154, Offset},
      "al r1 r5 minus 154 Offset",
      "NegativeOffset_al_r1_r5_minus_154_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, 139, Offset},
      "al r4 r9 minus 139 Offset",
      "NegativeOffset_al_r4_r9_minus_139_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r11, minus, 131, Offset},
      "al r8 r11 minus 131 Offset",
      "NegativeOffset_al_r8_r11_minus_131_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, 45, Offset},
      "al r4 r10 minus 45 Offset",
      "NegativeOffset_al_r4_r10_minus_45_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r2, minus, 77, Offset},
      "al r11 r2 minus 77 Offset",
      "NegativeOffset_al_r11_r2_minus_77_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r5, minus, 75, Offset},
      "al r9 r5 minus 75 Offset",
      "NegativeOffset_al_r9_r5_minus_75_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r6, minus, 86, Offset},
      "al r12 r6 minus 86 Offset",
      "NegativeOffset_al_r12_r6_minus_86_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r7, minus, 191, Offset},
      "al r0 r7 minus 191 Offset",
      "NegativeOffset_al_r0_r7_minus_191_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, 125, Offset},
      "al r3 r10 minus 125 Offset",
      "NegativeOffset_al_r3_r10_minus_125_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r8, minus, 23, Offset},
      "al r2 r8 minus 23 Offset",
      "NegativeOffset_al_r2_r8_minus_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, 105, Offset},
      "al r1 r11 minus 105 Offset",
      "NegativeOffset_al_r1_r11_minus_105_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r7, plus, 211, PostIndex},
      "al r14 r7 plus 211 PostIndex",
      "PositivePostIndex_al_r14_r7_plus_211_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r11, plus, 202, PostIndex},
      "al r7 r11 plus 202 PostIndex",
      "PositivePostIndex_al_r7_r11_plus_202_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r3, plus, 175, PostIndex},
      "al r11 r3 plus 175 PostIndex",
      "PositivePostIndex_al_r11_r3_plus_175_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r8, plus, 129, PostIndex},
      "al r4 r8 plus 129 PostIndex",
      "PositivePostIndex_al_r4_r8_plus_129_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r7, plus, 71, PostIndex},
      "al r4 r7 plus 71 PostIndex",
      "PositivePostIndex_al_r4_r7_plus_71_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r12, plus, 226, PostIndex},
      "al r5 r12 plus 226 PostIndex",
      "PositivePostIndex_al_r5_r12_plus_226_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r14, plus, 53, PostIndex},
      "al r1 r14 plus 53 PostIndex",
      "PositivePostIndex_al_r1_r14_plus_53_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r10, plus, 116, PostIndex},
      "al r9 r10 plus 116 PostIndex",
      "PositivePostIndex_al_r9_r10_plus_116_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r2, plus, 137, PostIndex},
      "al r10 r2 plus 137 PostIndex",
      "PositivePostIndex_al_r10_r2_plus_137_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r7, plus, 157, PostIndex},
      "al r5 r7 plus 157 PostIndex",
      "PositivePostIndex_al_r5_r7_plus_157_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r9, plus, 19, PostIndex},
      "al r11 r9 plus 19 PostIndex",
      "PositivePostIndex_al_r11_r9_plus_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r11, plus, 229, PostIndex},
      "al r6 r11 plus 229 PostIndex",
      "PositivePostIndex_al_r6_r11_plus_229_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r7, plus, 91, PostIndex},
      "al r5 r7 plus 91 PostIndex",
      "PositivePostIndex_al_r5_r7_plus_91_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, 32, PostIndex},
      "al r0 r2 plus 32 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_32_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r9, plus, 244, PostIndex},
      "al r12 r9 plus 244 PostIndex",
      "PositivePostIndex_al_r12_r9_plus_244_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r7, plus, 180, PostIndex},
      "al r0 r7 plus 180 PostIndex",
      "PositivePostIndex_al_r0_r7_plus_180_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r1, plus, 49, PostIndex},
      "al r5 r1 plus 49 PostIndex",
      "PositivePostIndex_al_r5_r1_plus_49_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r2, plus, 149, PostIndex},
      "al r7 r2 plus 149 PostIndex",
      "PositivePostIndex_al_r7_r2_plus_149_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r11, plus, 128, PostIndex},
      "al r3 r11 plus 128 PostIndex",
      "PositivePostIndex_al_r3_r11_plus_128_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r14, plus, 139, PostIndex},
      "al r3 r14 plus 139 PostIndex",
      "PositivePostIndex_al_r3_r14_plus_139_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r4, plus, 104, PostIndex},
      "al r1 r4 plus 104 PostIndex",
      "PositivePostIndex_al_r1_r4_plus_104_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r8, plus, 26, PostIndex},
      "al r6 r8 plus 26 PostIndex",
      "PositivePostIndex_al_r6_r8_plus_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r14, plus, 98, PostIndex},
      "al r0 r14 plus 98 PostIndex",
      "PositivePostIndex_al_r0_r14_plus_98_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r0, plus, 148, PostIndex},
      "al r3 r0 plus 148 PostIndex",
      "PositivePostIndex_al_r3_r0_plus_148_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r0, plus, 158, PostIndex},
      "al r2 r0 plus 158 PostIndex",
      "PositivePostIndex_al_r2_r0_plus_158_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r1, plus, 136, PostIndex},
      "al r3 r1 plus 136 PostIndex",
      "PositivePostIndex_al_r3_r1_plus_136_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r1, plus, 248, PostIndex},
      "al r7 r1 plus 248 PostIndex",
      "PositivePostIndex_al_r7_r1_plus_248_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r2, plus, 34, PostIndex},
      "al r9 r2 plus 34 PostIndex",
      "PositivePostIndex_al_r9_r2_plus_34_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r2, plus, 142, PostIndex},
      "al r1 r2 plus 142 PostIndex",
      "PositivePostIndex_al_r1_r2_plus_142_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r4, plus, 111, PostIndex},
      "al r8 r4 plus 111 PostIndex",
      "PositivePostIndex_al_r8_r4_plus_111_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r14, plus, 156, PostIndex},
      "al r11 r14 plus 156 PostIndex",
      "PositivePostIndex_al_r11_r14_plus_156_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 87, PostIndex},
      "al r0 r5 plus 87 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_87_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r12, plus, 244, PostIndex},
      "al r10 r12 plus 244 PostIndex",
      "PositivePostIndex_al_r10_r12_plus_244_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r8, plus, 135, PostIndex},
      "al r6 r8 plus 135 PostIndex",
      "PositivePostIndex_al_r6_r8_plus_135_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 177, PostIndex},
      "al r0 r5 plus 177 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_177_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r12, plus, 160, PostIndex},
      "al r6 r12 plus 160 PostIndex",
      "PositivePostIndex_al_r6_r12_plus_160_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r5, plus, 69, PostIndex},
      "al r6 r5 plus 69 PostIndex",
      "PositivePostIndex_al_r6_r5_plus_69_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r6, plus, 6, PostIndex},
      "al r4 r6 plus 6 PostIndex",
      "PositivePostIndex_al_r4_r6_plus_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r8, plus, 10, PostIndex},
      "al r7 r8 plus 10 PostIndex",
      "PositivePostIndex_al_r7_r8_plus_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, 76, PostIndex},
      "al r0 r2 plus 76 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_76_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r5, plus, 46, PostIndex},
      "al r2 r5 plus 46 PostIndex",
      "PositivePostIndex_al_r2_r5_plus_46_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r0, plus, 93, PostIndex},
      "al r8 r0 plus 93 PostIndex",
      "PositivePostIndex_al_r8_r0_plus_93_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r12, plus, 243, PostIndex},
      "al r7 r12 plus 243 PostIndex",
      "PositivePostIndex_al_r7_r12_plus_243_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r8, plus, 223, PostIndex},
      "al r1 r8 plus 223 PostIndex",
      "PositivePostIndex_al_r1_r8_plus_223_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r8, plus, 95, PostIndex},
      "al r12 r8 plus 95 PostIndex",
      "PositivePostIndex_al_r12_r8_plus_95_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r11, plus, 191, PostIndex},
      "al r8 r11 plus 191 PostIndex",
      "PositivePostIndex_al_r8_r11_plus_191_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r2, plus, 120, PostIndex},
      "al r11 r2 plus 120 PostIndex",
      "PositivePostIndex_al_r11_r2_plus_120_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, 161, PostIndex},
      "al r14 r0 plus 161 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_161_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r12, plus, 143, PostIndex},
      "al r5 r12 plus 143 PostIndex",
      "PositivePostIndex_al_r5_r12_plus_143_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, plus, 208, PostIndex},
      "al r12 r11 plus 208 PostIndex",
      "PositivePostIndex_al_r12_r11_plus_208_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r10, plus, 111, PostIndex},
      "al r1 r10 plus 111 PostIndex",
      "PositivePostIndex_al_r1_r10_plus_111_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r11, plus, 36, PostIndex},
      "al r9 r11 plus 36 PostIndex",
      "PositivePostIndex_al_r9_r11_plus_36_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r1, plus, 36, PostIndex},
      "al r9 r1 plus 36 PostIndex",
      "PositivePostIndex_al_r9_r1_plus_36_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r1, plus, 227, PostIndex},
      "al r5 r1 plus 227 PostIndex",
      "PositivePostIndex_al_r5_r1_plus_227_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r8, plus, 23, PostIndex},
      "al r0 r8 plus 23 PostIndex",
      "PositivePostIndex_al_r0_r8_plus_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 200, PostIndex},
      "al r0 r5 plus 200 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_200_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, 43, PostIndex},
      "al r1 r5 plus 43 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_43_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r4, plus, 101, PostIndex},
      "al r9 r4 plus 101 PostIndex",
      "PositivePostIndex_al_r9_r4_plus_101_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r5, plus, 68, PostIndex},
      "al r14 r5 plus 68 PostIndex",
      "PositivePostIndex_al_r14_r5_plus_68_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r1, plus, 29, PostIndex},
      "al r10 r1 plus 29 PostIndex",
      "PositivePostIndex_al_r10_r1_plus_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r2, plus, 102, PostIndex},
      "al r7 r2 plus 102 PostIndex",
      "PositivePostIndex_al_r7_r2_plus_102_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r4, plus, 233, PostIndex},
      "al r2 r4 plus 233 PostIndex",
      "PositivePostIndex_al_r2_r4_plus_233_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r10, plus, 134, PostIndex},
      "al r8 r10 plus 134 PostIndex",
      "PositivePostIndex_al_r8_r10_plus_134_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r0, plus, 136, PostIndex},
      "al r4 r0 plus 136 PostIndex",
      "PositivePostIndex_al_r4_r0_plus_136_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r7, plus, 194, PostIndex},
      "al r9 r7 plus 194 PostIndex",
      "PositivePostIndex_al_r9_r7_plus_194_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r14, plus, 9, PostIndex},
      "al r8 r14 plus 9 PostIndex",
      "PositivePostIndex_al_r8_r14_plus_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r10, plus, 93, PostIndex},
      "al r2 r10 plus 93 PostIndex",
      "PositivePostIndex_al_r2_r10_plus_93_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r8, plus, 29, PostIndex},
      "al r10 r8 plus 29 PostIndex",
      "PositivePostIndex_al_r10_r8_plus_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r3, plus, 219, PostIndex},
      "al r11 r3 plus 219 PostIndex",
      "PositivePostIndex_al_r11_r3_plus_219_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r5, plus, 122, PostIndex},
      "al r7 r5 plus 122 PostIndex",
      "PositivePostIndex_al_r7_r5_plus_122_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r7, plus, 115, PostIndex},
      "al r3 r7 plus 115 PostIndex",
      "PositivePostIndex_al_r3_r7_plus_115_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, 168, PostIndex},
      "al r14 r0 plus 168 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_168_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, 102, PostIndex},
      "al r1 r5 plus 102 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_102_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r0, plus, 131, PostIndex},
      "al r8 r0 plus 131 PostIndex",
      "PositivePostIndex_al_r8_r0_plus_131_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r1, plus, 161, PostIndex},
      "al r4 r1 plus 161 PostIndex",
      "PositivePostIndex_al_r4_r1_plus_161_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r6, plus, 140, PostIndex},
      "al r1 r6 plus 140 PostIndex",
      "PositivePostIndex_al_r1_r6_plus_140_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r8, plus, 73, PostIndex},
      "al r2 r8 plus 73 PostIndex",
      "PositivePostIndex_al_r2_r8_plus_73_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r8, plus, 68, PostIndex},
      "al r3 r8 plus 68 PostIndex",
      "PositivePostIndex_al_r3_r8_plus_68_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r2, plus, 185, PostIndex},
      "al r12 r2 plus 185 PostIndex",
      "PositivePostIndex_al_r12_r2_plus_185_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r12, plus, 95, PostIndex},
      "al r0 r12 plus 95 PostIndex",
      "PositivePostIndex_al_r0_r12_plus_95_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r2, plus, 172, PostIndex},
      "al r12 r2 plus 172 PostIndex",
      "PositivePostIndex_al_r12_r2_plus_172_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, 14, PostIndex},
      "al r1 r5 plus 14 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r9, plus, 229, PostIndex},
      "al r6 r9 plus 229 PostIndex",
      "PositivePostIndex_al_r6_r9_plus_229_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r6, plus, 31, PostIndex},
      "al r10 r6 plus 31 PostIndex",
      "PositivePostIndex_al_r10_r6_plus_31_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r5, plus, 229, PostIndex},
      "al r8 r5 plus 229 PostIndex",
      "PositivePostIndex_al_r8_r5_plus_229_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r10, plus, 132, PostIndex},
      "al r11 r10 plus 132 PostIndex",
      "PositivePostIndex_al_r11_r10_plus_132_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r0, plus, 192, PostIndex},
      "al r4 r0 plus 192 PostIndex",
      "PositivePostIndex_al_r4_r0_plus_192_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r0, plus, 176, PostIndex},
      "al r5 r0 plus 176 PostIndex",
      "PositivePostIndex_al_r5_r0_plus_176_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r4, plus, 106, PostIndex},
      "al r5 r4 plus 106 PostIndex",
      "PositivePostIndex_al_r5_r4_plus_106_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r12, plus, 69, PostIndex},
      "al r2 r12 plus 69 PostIndex",
      "PositivePostIndex_al_r2_r12_plus_69_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r10, plus, 15, PostIndex},
      "al r11 r10 plus 15 PostIndex",
      "PositivePostIndex_al_r11_r10_plus_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r6, plus, 159, PostIndex},
      "al r10 r6 plus 159 PostIndex",
      "PositivePostIndex_al_r10_r6_plus_159_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r8, plus, 78, PostIndex},
      "al r12 r8 plus 78 PostIndex",
      "PositivePostIndex_al_r12_r8_plus_78_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 227, PostIndex},
      "al r0 r5 plus 227 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_227_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r10, plus, 73, PostIndex},
      "al r8 r10 plus 73 PostIndex",
      "PositivePostIndex_al_r8_r10_plus_73_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r5, plus, 10, PostIndex},
      "al r9 r5 plus 10 PostIndex",
      "PositivePostIndex_al_r9_r5_plus_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r14, plus, 214, PostIndex},
      "al r12 r14 plus 214 PostIndex",
      "PositivePostIndex_al_r12_r14_plus_214_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r14, plus, 246, PostIndex},
      "al r7 r14 plus 246 PostIndex",
      "PositivePostIndex_al_r7_r14_plus_246_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r1, plus, 78, PostIndex},
      "al r11 r1 plus 78 PostIndex",
      "PositivePostIndex_al_r11_r1_plus_78_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r9, plus, 26, PostIndex},
      "al r5 r9 plus 26 PostIndex",
      "PositivePostIndex_al_r5_r9_plus_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r14, minus, 12, PostIndex},
      "al r9 r14 minus 12 PostIndex",
      "NegativePostIndex_al_r9_r14_minus_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r4, minus, 212, PostIndex},
      "al r8 r4 minus 212 PostIndex",
      "NegativePostIndex_al_r8_r4_minus_212_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r11, minus, 14, PostIndex},
      "al r2 r11 minus 14 PostIndex",
      "NegativePostIndex_al_r2_r11_minus_14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r7, minus, 225, PostIndex},
      "al r2 r7 minus 225 PostIndex",
      "NegativePostIndex_al_r2_r7_minus_225_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r2, minus, 77, PostIndex},
      "al r11 r2 minus 77 PostIndex",
      "NegativePostIndex_al_r11_r2_minus_77_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r8, minus, 23, PostIndex},
      "al r14 r8 minus 23 PostIndex",
      "NegativePostIndex_al_r14_r8_minus_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r9, minus, 250, PostIndex},
      "al r0 r9 minus 250 PostIndex",
      "NegativePostIndex_al_r0_r9_minus_250_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r11, minus, 121, PostIndex},
      "al r14 r11 minus 121 PostIndex",
      "NegativePostIndex_al_r14_r11_minus_121_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r1, minus, 122, PostIndex},
      "al r12 r1 minus 122 PostIndex",
      "NegativePostIndex_al_r12_r1_minus_122_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r5, minus, 75, PostIndex},
      "al r11 r5 minus 75 PostIndex",
      "NegativePostIndex_al_r11_r5_minus_75_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r5, minus, 123, PostIndex},
      "al r9 r5 minus 123 PostIndex",
      "NegativePostIndex_al_r9_r5_minus_123_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r10, minus, 31, PostIndex},
      "al r0 r10 minus 31 PostIndex",
      "NegativePostIndex_al_r0_r10_minus_31_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r2, minus, 154, PostIndex},
      "al r9 r2 minus 154 PostIndex",
      "NegativePostIndex_al_r9_r2_minus_154_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r3, minus, 39, PostIndex},
      "al r10 r3 minus 39 PostIndex",
      "NegativePostIndex_al_r10_r3_minus_39_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r8, minus, 40, PostIndex},
      "al r9 r8 minus 40 PostIndex",
      "NegativePostIndex_al_r9_r8_minus_40_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r11, minus, 19, PostIndex},
      "al r2 r11 minus 19 PostIndex",
      "NegativePostIndex_al_r2_r11_minus_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, 62, PostIndex},
      "al r7 r12 minus 62 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_62_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r5, minus, 94, PostIndex},
      "al r12 r5 minus 94 PostIndex",
      "NegativePostIndex_al_r12_r5_minus_94_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r12, minus, 177, PostIndex},
      "al r3 r12 minus 177 PostIndex",
      "NegativePostIndex_al_r3_r12_minus_177_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r3, minus, 22, PostIndex},
      "al r10 r3 minus 22 PostIndex",
      "NegativePostIndex_al_r10_r3_minus_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r4, minus, 136, PostIndex},
      "al r5 r4 minus 136 PostIndex",
      "NegativePostIndex_al_r5_r4_minus_136_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r11, minus, 186, PostIndex},
      "al r9 r11 minus 186 PostIndex",
      "NegativePostIndex_al_r9_r11_minus_186_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r9, minus, 205, PostIndex},
      "al r12 r9 minus 205 PostIndex",
      "NegativePostIndex_al_r12_r9_minus_205_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r1, minus, 10, PostIndex},
      "al r2 r1 minus 10 PostIndex",
      "NegativePostIndex_al_r2_r1_minus_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r4, minus, 95, PostIndex},
      "al r7 r4 minus 95 PostIndex",
      "NegativePostIndex_al_r7_r4_minus_95_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r11, minus, 221, PostIndex},
      "al r12 r11 minus 221 PostIndex",
      "NegativePostIndex_al_r12_r11_minus_221_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r6, minus, 235, PostIndex},
      "al r9 r6 minus 235 PostIndex",
      "NegativePostIndex_al_r9_r6_minus_235_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r0, minus, 144, PostIndex},
      "al r3 r0 minus 144 PostIndex",
      "NegativePostIndex_al_r3_r0_minus_144_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r4, minus, 230, PostIndex},
      "al r6 r4 minus 230 PostIndex",
      "NegativePostIndex_al_r6_r4_minus_230_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r10, minus, 156, PostIndex},
      "al r7 r10 minus 156 PostIndex",
      "NegativePostIndex_al_r7_r10_minus_156_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r10, minus, 232, PostIndex},
      "al r14 r10 minus 232 PostIndex",
      "NegativePostIndex_al_r14_r10_minus_232_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r3, minus, 242, PostIndex},
      "al r14 r3 minus 242 PostIndex",
      "NegativePostIndex_al_r14_r3_minus_242_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r8, minus, 10, PostIndex},
      "al r3 r8 minus 10 PostIndex",
      "NegativePostIndex_al_r3_r8_minus_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r7, minus, 37, PostIndex},
      "al r4 r7 minus 37 PostIndex",
      "NegativePostIndex_al_r4_r7_minus_37_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r4, minus, 23, PostIndex},
      "al r10 r4 minus 23 PostIndex",
      "NegativePostIndex_al_r10_r4_minus_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r10, minus, 52, PostIndex},
      "al r7 r10 minus 52 PostIndex",
      "NegativePostIndex_al_r7_r10_minus_52_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r7, minus, 59, PostIndex},
      "al r0 r7 minus 59 PostIndex",
      "NegativePostIndex_al_r0_r7_minus_59_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r10, minus, 253, PostIndex},
      "al r1 r10 minus 253 PostIndex",
      "NegativePostIndex_al_r1_r10_minus_253_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r9, minus, 213, PostIndex},
      "al r8 r9 minus 213 PostIndex",
      "NegativePostIndex_al_r8_r9_minus_213_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r0, minus, 22, PostIndex},
      "al r3 r0 minus 22 PostIndex",
      "NegativePostIndex_al_r3_r0_minus_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r1, minus, 13, PostIndex},
      "al r10 r1 minus 13 PostIndex",
      "NegativePostIndex_al_r10_r1_minus_13_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r0, minus, 107, PostIndex},
      "al r10 r0 minus 107 PostIndex",
      "NegativePostIndex_al_r10_r0_minus_107_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r6, minus, 6, PostIndex},
      "al r9 r6 minus 6 PostIndex",
      "NegativePostIndex_al_r9_r6_minus_6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r8, minus, 78, PostIndex},
      "al r14 r8 minus 78 PostIndex",
      "NegativePostIndex_al_r14_r8_minus_78_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r6, minus, 164, PostIndex},
      "al r5 r6 minus 164 PostIndex",
      "NegativePostIndex_al_r5_r6_minus_164_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r7, minus, 155, PostIndex},
      "al r9 r7 minus 155 PostIndex",
      "NegativePostIndex_al_r9_r7_minus_155_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r0, minus, 45, PostIndex},
      "al r7 r0 minus 45 PostIndex",
      "NegativePostIndex_al_r7_r0_minus_45_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r4, minus, 182, PostIndex},
      "al r9 r4 minus 182 PostIndex",
      "NegativePostIndex_al_r9_r4_minus_182_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r12, minus, 238, PostIndex},
      "al r14 r12 minus 238 PostIndex",
      "NegativePostIndex_al_r14_r12_minus_238_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r10, minus, 93, PostIndex},
      "al r12 r10 minus 93 PostIndex",
      "NegativePostIndex_al_r12_r10_minus_93_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r2, minus, 255, PostIndex},
      "al r1 r2 minus 255 PostIndex",
      "NegativePostIndex_al_r1_r2_minus_255_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r6, minus, 65, PostIndex},
      "al r11 r6 minus 65 PostIndex",
      "NegativePostIndex_al_r11_r6_minus_65_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r14, minus, 30, PostIndex},
      "al r1 r14 minus 30 PostIndex",
      "NegativePostIndex_al_r1_r14_minus_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r12, minus, 128, PostIndex},
      "al r9 r12 minus 128 PostIndex",
      "NegativePostIndex_al_r9_r12_minus_128_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r2, minus, 2, PostIndex},
      "al r1 r2 minus 2 PostIndex",
      "NegativePostIndex_al_r1_r2_minus_2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r7, minus, 122, PostIndex},
      "al r0 r7 minus 122 PostIndex",
      "NegativePostIndex_al_r0_r7_minus_122_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, 170, PostIndex},
      "al r7 r8 minus 170 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_170_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r7, minus, 242, PostIndex},
      "al r14 r7 minus 242 PostIndex",
      "NegativePostIndex_al_r14_r7_minus_242_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r0, minus, 211, PostIndex},
      "al r4 r0 minus 211 PostIndex",
      "NegativePostIndex_al_r4_r0_minus_211_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r8, minus, 122, PostIndex},
      "al r2 r8 minus 122 PostIndex",
      "NegativePostIndex_al_r2_r8_minus_122_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r5, minus, 40, PostIndex},
      "al r12 r5 minus 40 PostIndex",
      "NegativePostIndex_al_r12_r5_minus_40_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r10, minus, 138, PostIndex},
      "al r4 r10 minus 138 PostIndex",
      "NegativePostIndex_al_r4_r10_minus_138_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r7, minus, 80, PostIndex},
      "al r2 r7 minus 80 PostIndex",
      "NegativePostIndex_al_r2_r7_minus_80_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r12, minus, 150, PostIndex},
      "al r6 r12 minus 150 PostIndex",
      "NegativePostIndex_al_r6_r12_minus_150_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r1, minus, 167, PostIndex},
      "al r4 r1 minus 167 PostIndex",
      "NegativePostIndex_al_r4_r1_minus_167_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r2, minus, 67, PostIndex},
      "al r6 r2 minus 67 PostIndex",
      "NegativePostIndex_al_r6_r2_minus_67_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r5, minus, 180, PostIndex},
      "al r12 r5 minus 180 PostIndex",
      "NegativePostIndex_al_r12_r5_minus_180_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r7, minus, 115, PostIndex},
      "al r14 r7 minus 115 PostIndex",
      "NegativePostIndex_al_r14_r7_minus_115_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r5, minus, 238, PostIndex},
      "al r2 r5 minus 238 PostIndex",
      "NegativePostIndex_al_r2_r5_minus_238_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r6, minus, 34, PostIndex},
      "al r14 r6 minus 34 PostIndex",
      "NegativePostIndex_al_r14_r6_minus_34_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r12, minus, 74, PostIndex},
      "al r4 r12 minus 74 PostIndex",
      "NegativePostIndex_al_r4_r12_minus_74_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r11, minus, 197, PostIndex},
      "al r12 r11 minus 197 PostIndex",
      "NegativePostIndex_al_r12_r11_minus_197_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r12, minus, 53, PostIndex},
      "al r8 r12 minus 53 PostIndex",
      "NegativePostIndex_al_r8_r12_minus_53_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r1, minus, 189, PostIndex},
      "al r4 r1 minus 189 PostIndex",
      "NegativePostIndex_al_r4_r1_minus_189_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r2, minus, 101, PostIndex},
      "al r1 r2 minus 101 PostIndex",
      "NegativePostIndex_al_r1_r2_minus_101_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, 152, PostIndex},
      "al r8 r2 minus 152 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_152_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r0, minus, 238, PostIndex},
      "al r9 r0 minus 238 PostIndex",
      "NegativePostIndex_al_r9_r0_minus_238_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r8, minus, 34, PostIndex},
      "al r1 r8 minus 34 PostIndex",
      "NegativePostIndex_al_r1_r8_minus_34_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r0, minus, 216, PostIndex},
      "al r8 r0 minus 216 PostIndex",
      "NegativePostIndex_al_r8_r0_minus_216_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r7, minus, 235, PostIndex},
      "al r4 r7 minus 235 PostIndex",
      "NegativePostIndex_al_r4_r7_minus_235_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r14, minus, 235, PostIndex},
      "al r5 r14 minus 235 PostIndex",
      "NegativePostIndex_al_r5_r14_minus_235_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r4, minus, 230, PostIndex},
      "al r11 r4 minus 230 PostIndex",
      "NegativePostIndex_al_r11_r4_minus_230_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r2, minus, 52, PostIndex},
      "al r7 r2 minus 52 PostIndex",
      "NegativePostIndex_al_r7_r2_minus_52_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r11, minus, 229, PostIndex},
      "al r1 r11 minus 229 PostIndex",
      "NegativePostIndex_al_r1_r11_minus_229_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r5, minus, 62, PostIndex},
      "al r6 r5 minus 62 PostIndex",
      "NegativePostIndex_al_r6_r5_minus_62_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r7, minus, 247, PostIndex},
      "al r9 r7 minus 247 PostIndex",
      "NegativePostIndex_al_r9_r7_minus_247_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r0, minus, 121, PostIndex},
      "al r6 r0 minus 121 PostIndex",
      "NegativePostIndex_al_r6_r0_minus_121_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r3, minus, 104, PostIndex},
      "al r12 r3 minus 104 PostIndex",
      "NegativePostIndex_al_r12_r3_minus_104_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r3, minus, 169, PostIndex},
      "al r1 r3 minus 169 PostIndex",
      "NegativePostIndex_al_r1_r3_minus_169_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r1, minus, 240, PostIndex},
      "al r3 r1 minus 240 PostIndex",
      "NegativePostIndex_al_r3_r1_minus_240_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r6, minus, 173, PostIndex},
      "al r2 r6 minus 173 PostIndex",
      "NegativePostIndex_al_r2_r6_minus_173_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r8, minus, 58, PostIndex},
      "al r12 r8 minus 58 PostIndex",
      "NegativePostIndex_al_r12_r8_minus_58_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r3, minus, 134, PostIndex},
      "al r0 r3 minus 134 PostIndex",
      "NegativePostIndex_al_r0_r3_minus_134_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r2, minus, 75, PostIndex},
      "al r6 r2 minus 75 PostIndex",
      "NegativePostIndex_al_r6_r2_minus_75_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r0, minus, 53, PostIndex},
      "al r5 r0 minus 53 PostIndex",
      "NegativePostIndex_al_r5_r0_minus_53_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r12, minus, 160, PostIndex},
      "al r10 r12 minus 160 PostIndex",
      "NegativePostIndex_al_r10_r12_minus_160_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r9, minus, 55, PostIndex},
      "al r8 r9 minus 55 PostIndex",
      "NegativePostIndex_al_r8_r9_minus_55_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r7, minus, 175, PostIndex},
      "al r3 r7 minus 175 PostIndex",
      "NegativePostIndex_al_r3_r7_minus_175_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r4, minus, 179, PostIndex},
      "al r12 r4 minus 179 PostIndex",
      "NegativePostIndex_al_r12_r4_minus_179_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r14, minus, 16, PostIndex},
      "al r7 r14 minus 16 PostIndex",
      "NegativePostIndex_al_r7_r14_minus_16_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r9, plus, 41, PreIndex},
      "al r14 r9 plus 41 PreIndex",
      "PositivePreIndex_al_r14_r9_plus_41_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r9, plus, 78, PreIndex},
      "al r7 r9 plus 78 PreIndex",
      "PositivePreIndex_al_r7_r9_plus_78_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r3, plus, 255, PreIndex},
      "al r6 r3 plus 255 PreIndex",
      "PositivePreIndex_al_r6_r3_plus_255_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r8, plus, 139, PreIndex},
      "al r11 r8 plus 139 PreIndex",
      "PositivePreIndex_al_r11_r8_plus_139_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r3, plus, 170, PreIndex},
      "al r6 r3 plus 170 PreIndex",
      "PositivePreIndex_al_r6_r3_plus_170_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r4, plus, 221, PreIndex},
      "al r6 r4 plus 221 PreIndex",
      "PositivePreIndex_al_r6_r4_plus_221_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r8, plus, 229, PreIndex},
      "al r7 r8 plus 229 PreIndex",
      "PositivePreIndex_al_r7_r8_plus_229_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r4, plus, 18, PreIndex},
      "al r7 r4 plus 18 PreIndex",
      "PositivePreIndex_al_r7_r4_plus_18_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r8, plus, 157, PreIndex},
      "al r3 r8 plus 157 PreIndex",
      "PositivePreIndex_al_r3_r8_plus_157_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r5, plus, 82, PreIndex},
      "al r8 r5 plus 82 PreIndex",
      "PositivePreIndex_al_r8_r5_plus_82_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r10, plus, 63, PreIndex},
      "al r5 r10 plus 63 PreIndex",
      "PositivePreIndex_al_r5_r10_plus_63_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r11, plus, 179, PreIndex},
      "al r1 r11 plus 179 PreIndex",
      "PositivePreIndex_al_r1_r11_plus_179_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r11, plus, 124, PreIndex},
      "al r12 r11 plus 124 PreIndex",
      "PositivePreIndex_al_r12_r11_plus_124_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r12, plus, 102, PreIndex},
      "al r9 r12 plus 102 PreIndex",
      "PositivePreIndex_al_r9_r12_plus_102_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r1, plus, 157, PreIndex},
      "al r12 r1 plus 157 PreIndex",
      "PositivePreIndex_al_r12_r1_plus_157_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r2, plus, 10, PreIndex},
      "al r6 r2 plus 10 PreIndex",
      "PositivePreIndex_al_r6_r2_plus_10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r4, plus, 100, PreIndex},
      "al r9 r4 plus 100 PreIndex",
      "PositivePreIndex_al_r9_r4_plus_100_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r7, plus, 62, PreIndex},
      "al r2 r7 plus 62 PreIndex",
      "PositivePreIndex_al_r2_r7_plus_62_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r12, plus, 191, PreIndex},
      "al r9 r12 plus 191 PreIndex",
      "PositivePreIndex_al_r9_r12_plus_191_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r7, plus, 241, PreIndex},
      "al r2 r7 plus 241 PreIndex",
      "PositivePreIndex_al_r2_r7_plus_241_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r12, plus, 220, PreIndex},
      "al r2 r12 plus 220 PreIndex",
      "PositivePreIndex_al_r2_r12_plus_220_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r12, plus, 98, PreIndex},
      "al r0 r12 plus 98 PreIndex",
      "PositivePreIndex_al_r0_r12_plus_98_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r4, plus, 218, PreIndex},
      "al r11 r4 plus 218 PreIndex",
      "PositivePreIndex_al_r11_r4_plus_218_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r10, plus, 211, PreIndex},
      "al r11 r10 plus 211 PreIndex",
      "PositivePreIndex_al_r11_r10_plus_211_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r1, plus, 160, PreIndex},
      "al r4 r1 plus 160 PreIndex",
      "PositivePreIndex_al_r4_r1_plus_160_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r0, plus, 107, PreIndex},
      "al r12 r0 plus 107 PreIndex",
      "PositivePreIndex_al_r12_r0_plus_107_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r4, plus, 239, PreIndex},
      "al r9 r4 plus 239 PreIndex",
      "PositivePreIndex_al_r9_r4_plus_239_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r14, plus, 54, PreIndex},
      "al r2 r14 plus 54 PreIndex",
      "PositivePreIndex_al_r2_r14_plus_54_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r8, plus, 89, PreIndex},
      "al r9 r8 plus 89 PreIndex",
      "PositivePreIndex_al_r9_r8_plus_89_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r7, plus, 162, PreIndex},
      "al r8 r7 plus 162 PreIndex",
      "PositivePreIndex_al_r8_r7_plus_162_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r0, plus, 91, PreIndex},
      "al r11 r0 plus 91 PreIndex",
      "PositivePreIndex_al_r11_r0_plus_91_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r5, plus, 62, PreIndex},
      "al r6 r5 plus 62 PreIndex",
      "PositivePreIndex_al_r6_r5_plus_62_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r12, plus, 140, PreIndex},
      "al r7 r12 plus 140 PreIndex",
      "PositivePreIndex_al_r7_r12_plus_140_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r1, plus, 38, PreIndex},
      "al r11 r1 plus 38 PreIndex",
      "PositivePreIndex_al_r11_r1_plus_38_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, 185, PreIndex},
      "al r11 r12 plus 185 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_185_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r7, plus, 27, PreIndex},
      "al r11 r7 plus 27 PreIndex",
      "PositivePreIndex_al_r11_r7_plus_27_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r6, plus, 81, PreIndex},
      "al r2 r6 plus 81 PreIndex",
      "PositivePreIndex_al_r2_r6_plus_81_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r8, plus, 60, PreIndex},
      "al r11 r8 plus 60 PreIndex",
      "PositivePreIndex_al_r11_r8_plus_60_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r9, plus, 39, PreIndex},
      "al r6 r9 plus 39 PreIndex",
      "PositivePreIndex_al_r6_r9_plus_39_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r14, plus, 46, PreIndex},
      "al r12 r14 plus 46 PreIndex",
      "PositivePreIndex_al_r12_r14_plus_46_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r9, plus, 188, PreIndex},
      "al r3 r9 plus 188 PreIndex",
      "PositivePreIndex_al_r3_r9_plus_188_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, 58, PreIndex},
      "al r4 r12 plus 58 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_58_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r5, plus, 220, PreIndex},
      "al r4 r5 plus 220 PreIndex",
      "PositivePreIndex_al_r4_r5_plus_220_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r10, plus, 249, PreIndex},
      "al r4 r10 plus 249 PreIndex",
      "PositivePreIndex_al_r4_r10_plus_249_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r0, plus, 23, PreIndex},
      "al r9 r0 plus 23 PreIndex",
      "PositivePreIndex_al_r9_r0_plus_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r11, plus, 190, PreIndex},
      "al r10 r11 plus 190 PreIndex",
      "PositivePreIndex_al_r10_r11_plus_190_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r11, plus, 33, PreIndex},
      "al r4 r11 plus 33 PreIndex",
      "PositivePreIndex_al_r4_r11_plus_33_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r3, plus, 163, PreIndex},
      "al r7 r3 plus 163 PreIndex",
      "PositivePreIndex_al_r7_r3_plus_163_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r9, plus, 147, PreIndex},
      "al r10 r9 plus 147 PreIndex",
      "PositivePreIndex_al_r10_r9_plus_147_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r10, plus, 8, PreIndex},
      "al r8 r10 plus 8 PreIndex",
      "PositivePreIndex_al_r8_r10_plus_8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r10, plus, 0, PreIndex},
      "al r0 r10 plus 0 PreIndex",
      "PositivePreIndex_al_r0_r10_plus_0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r7, plus, 83, PreIndex},
      "al r5 r7 plus 83 PreIndex",
      "PositivePreIndex_al_r5_r7_plus_83_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r9, plus, 233, PreIndex},
      "al r3 r9 plus 233 PreIndex",
      "PositivePreIndex_al_r3_r9_plus_233_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r5, plus, 14, PreIndex},
      "al r11 r5 plus 14 PreIndex",
      "PositivePreIndex_al_r11_r5_plus_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, 21, PreIndex},
      "al r11 r12 plus 21 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r2, plus, 117, PreIndex},
      "al r6 r2 plus 117 PreIndex",
      "PositivePreIndex_al_r6_r2_plus_117_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r0, plus, 0, PreIndex},
      "al r10 r0 plus 0 PreIndex",
      "PositivePreIndex_al_r10_r0_plus_0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, 109, PreIndex},
      "al r4 r12 plus 109 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_109_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r4, plus, 212, PreIndex},
      "al r3 r4 plus 212 PreIndex",
      "PositivePreIndex_al_r3_r4_plus_212_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r4, plus, 152, PreIndex},
      "al r9 r4 plus 152 PreIndex",
      "PositivePreIndex_al_r9_r4_plus_152_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r12, plus, 89, PreIndex},
      "al r0 r12 plus 89 PreIndex",
      "PositivePreIndex_al_r0_r12_plus_89_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r0, plus, 184, PreIndex},
      "al r3 r0 plus 184 PreIndex",
      "PositivePreIndex_al_r3_r0_plus_184_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, 168, PreIndex},
      "al r4 r12 plus 168 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_168_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r12, plus, 236, PreIndex},
      "al r7 r12 plus 236 PreIndex",
      "PositivePreIndex_al_r7_r12_plus_236_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r5, plus, 98, PreIndex},
      "al r1 r5 plus 98 PreIndex",
      "PositivePreIndex_al_r1_r5_plus_98_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r11, plus, 213, PreIndex},
      "al r3 r11 plus 213 PreIndex",
      "PositivePreIndex_al_r3_r11_plus_213_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r6, plus, 123, PreIndex},
      "al r14 r6 plus 123 PreIndex",
      "PositivePreIndex_al_r14_r6_plus_123_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r7, plus, 211, PreIndex},
      "al r10 r7 plus 211 PreIndex",
      "PositivePreIndex_al_r10_r7_plus_211_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r8, plus, 11, PreIndex},
      "al r6 r8 plus 11 PreIndex",
      "PositivePreIndex_al_r6_r8_plus_11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r1, plus, 35, PreIndex},
      "al r3 r1 plus 35 PreIndex",
      "PositivePreIndex_al_r3_r1_plus_35_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r0, plus, 248, PreIndex},
      "al r14 r0 plus 248 PreIndex",
      "PositivePreIndex_al_r14_r0_plus_248_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r4, plus, 103, PreIndex},
      "al r9 r4 plus 103 PreIndex",
      "PositivePreIndex_al_r9_r4_plus_103_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r1, plus, 6, PreIndex},
      "al r2 r1 plus 6 PreIndex",
      "PositivePreIndex_al_r2_r1_plus_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r1, plus, 33, PreIndex},
      "al r14 r1 plus 33 PreIndex",
      "PositivePreIndex_al_r14_r1_plus_33_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r3, plus, 206, PreIndex},
      "al r4 r3 plus 206 PreIndex",
      "PositivePreIndex_al_r4_r3_plus_206_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r14, plus, 201, PreIndex},
      "al r5 r14 plus 201 PreIndex",
      "PositivePreIndex_al_r5_r14_plus_201_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r5, plus, 86, PreIndex},
      "al r10 r5 plus 86 PreIndex",
      "PositivePreIndex_al_r10_r5_plus_86_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r8, plus, 160, PreIndex},
      "al r6 r8 plus 160 PreIndex",
      "PositivePreIndex_al_r6_r8_plus_160_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r5, plus, 81, PreIndex},
      "al r12 r5 plus 81 PreIndex",
      "PositivePreIndex_al_r12_r5_plus_81_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r14, plus, 184, PreIndex},
      "al r3 r14 plus 184 PreIndex",
      "PositivePreIndex_al_r3_r14_plus_184_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r11, plus, 95, PreIndex},
      "al r9 r11 plus 95 PreIndex",
      "PositivePreIndex_al_r9_r11_plus_95_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r9, plus, 227, PreIndex},
      "al r2 r9 plus 227 PreIndex",
      "PositivePreIndex_al_r2_r9_plus_227_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r7, plus, 103, PreIndex},
      "al r2 r7 plus 103 PreIndex",
      "PositivePreIndex_al_r2_r7_plus_103_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r1, plus, 72, PreIndex},
      "al r5 r1 plus 72 PreIndex",
      "PositivePreIndex_al_r5_r1_plus_72_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r10, plus, 82, PreIndex},
      "al r4 r10 plus 82 PreIndex",
      "PositivePreIndex_al_r4_r10_plus_82_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r0, plus, 46, PreIndex},
      "al r7 r0 plus 46 PreIndex",
      "PositivePreIndex_al_r7_r0_plus_46_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r14, plus, 24, PreIndex},
      "al r7 r14 plus 24 PreIndex",
      "PositivePreIndex_al_r7_r14_plus_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r1, plus, 2, PreIndex},
      "al r9 r1 plus 2 PreIndex",
      "PositivePreIndex_al_r9_r1_plus_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r12, plus, 91, PreIndex},
      "al r3 r12 plus 91 PreIndex",
      "PositivePreIndex_al_r3_r12_plus_91_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r7, plus, 158, PreIndex},
      "al r6 r7 plus 158 PreIndex",
      "PositivePreIndex_al_r6_r7_plus_158_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r7, plus, 47, PreIndex},
      "al r2 r7 plus 47 PreIndex",
      "PositivePreIndex_al_r2_r7_plus_47_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r3, plus, 119, PreIndex},
      "al r7 r3 plus 119 PreIndex",
      "PositivePreIndex_al_r7_r3_plus_119_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r3, plus, 214, PreIndex},
      "al r12 r3 plus 214 PreIndex",
      "PositivePreIndex_al_r12_r3_plus_214_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r10, plus, 180, PreIndex},
      "al r11 r10 plus 180 PreIndex",
      "PositivePreIndex_al_r11_r10_plus_180_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r9, plus, 241, PreIndex},
      "al r4 r9 plus 241 PreIndex",
      "PositivePreIndex_al_r4_r9_plus_241_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r9, plus, 100, PreIndex},
      "al r10 r9 plus 100 PreIndex",
      "PositivePreIndex_al_r10_r9_plus_100_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r8, plus, 117, PreIndex},
      "al r1 r8 plus 117 PreIndex",
      "PositivePreIndex_al_r1_r8_plus_117_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r4, plus, 167, PreIndex},
      "al r8 r4 plus 167 PreIndex",
      "PositivePreIndex_al_r8_r4_plus_167_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r11, plus, 158, PreIndex},
      "al r10 r11 plus 158 PreIndex",
      "PositivePreIndex_al_r10_r11_plus_158_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r0, plus, 85, PreIndex},
      "al r11 r0 plus 85 PreIndex",
      "PositivePreIndex_al_r11_r0_plus_85_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r9, minus, 228, PreIndex},
      "al r4 r9 minus 228 PreIndex",
      "NegativePreIndex_al_r4_r9_minus_228_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r10, minus, 109, PreIndex},
      "al r1 r10 minus 109 PreIndex",
      "NegativePreIndex_al_r1_r10_minus_109_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r6, minus, 59, PreIndex},
      "al r7 r6 minus 59 PreIndex",
      "NegativePreIndex_al_r7_r6_minus_59_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r14, minus, 243, PreIndex},
      "al r4 r14 minus 243 PreIndex",
      "NegativePreIndex_al_r4_r14_minus_243_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r4, minus, 140, PreIndex},
      "al r3 r4 minus 140 PreIndex",
      "NegativePreIndex_al_r3_r4_minus_140_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r0, minus, 103, PreIndex},
      "al r8 r0 minus 103 PreIndex",
      "NegativePreIndex_al_r8_r0_minus_103_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r2, minus, 13, PreIndex},
      "al r14 r2 minus 13 PreIndex",
      "NegativePreIndex_al_r14_r2_minus_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r3, minus, 81, PreIndex},
      "al r5 r3 minus 81 PreIndex",
      "NegativePreIndex_al_r5_r3_minus_81_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r10, minus, 138, PreIndex},
      "al r9 r10 minus 138 PreIndex",
      "NegativePreIndex_al_r9_r10_minus_138_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r14, minus, 81, PreIndex},
      "al r6 r14 minus 81 PreIndex",
      "NegativePreIndex_al_r6_r14_minus_81_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r6, minus, 242, PreIndex},
      "al r14 r6 minus 242 PreIndex",
      "NegativePreIndex_al_r14_r6_minus_242_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r11, minus, 70, PreIndex},
      "al r7 r11 minus 70 PreIndex",
      "NegativePreIndex_al_r7_r11_minus_70_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r7, minus, 169, PreIndex},
      "al r1 r7 minus 169 PreIndex",
      "NegativePreIndex_al_r1_r7_minus_169_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r6, minus, 244, PreIndex},
      "al r10 r6 minus 244 PreIndex",
      "NegativePreIndex_al_r10_r6_minus_244_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r2, minus, 252, PreIndex},
      "al r14 r2 minus 252 PreIndex",
      "NegativePreIndex_al_r14_r2_minus_252_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, 15, PreIndex},
      "al r1 r14 minus 15 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_15_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r6, minus, 31, PreIndex},
      "al r1 r6 minus 31 PreIndex",
      "NegativePreIndex_al_r1_r6_minus_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, 26, PreIndex},
      "al r3 r5 minus 26 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r6, minus, 9, PreIndex},
      "al r7 r6 minus 9 PreIndex",
      "NegativePreIndex_al_r7_r6_minus_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r0, minus, 112, PreIndex},
      "al r2 r0 minus 112 PreIndex",
      "NegativePreIndex_al_r2_r0_minus_112_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r9, minus, 237, PreIndex},
      "al r0 r9 minus 237 PreIndex",
      "NegativePreIndex_al_r0_r9_minus_237_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r11, minus, 112, PreIndex},
      "al r1 r11 minus 112 PreIndex",
      "NegativePreIndex_al_r1_r11_minus_112_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r5, minus, 220, PreIndex},
      "al r12 r5 minus 220 PreIndex",
      "NegativePreIndex_al_r12_r5_minus_220_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r8, minus, 166, PreIndex},
      "al r3 r8 minus 166 PreIndex",
      "NegativePreIndex_al_r3_r8_minus_166_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r14, minus, 128, PreIndex},
      "al r2 r14 minus 128 PreIndex",
      "NegativePreIndex_al_r2_r14_minus_128_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r11, minus, 182, PreIndex},
      "al r9 r11 minus 182 PreIndex",
      "NegativePreIndex_al_r9_r11_minus_182_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r14, minus, 16, PreIndex},
      "al r8 r14 minus 16 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r14, minus, 165, PreIndex},
      "al r4 r14 minus 165 PreIndex",
      "NegativePreIndex_al_r4_r14_minus_165_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r6, minus, 32, PreIndex},
      "al r1 r6 minus 32 PreIndex",
      "NegativePreIndex_al_r1_r6_minus_32_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r10, minus, 224, PreIndex},
      "al r4 r10 minus 224 PreIndex",
      "NegativePreIndex_al_r4_r10_minus_224_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r2, minus, 27, PreIndex},
      "al r5 r2 minus 27 PreIndex",
      "NegativePreIndex_al_r5_r2_minus_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r1, minus, 207, PreIndex},
      "al r14 r1 minus 207 PreIndex",
      "NegativePreIndex_al_r14_r1_minus_207_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r14, minus, 236, PreIndex},
      "al r9 r14 minus 236 PreIndex",
      "NegativePreIndex_al_r9_r14_minus_236_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r2, minus, 20, PreIndex},
      "al r9 r2 minus 20 PreIndex",
      "NegativePreIndex_al_r9_r2_minus_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r4, minus, 247, PreIndex},
      "al r3 r4 minus 247 PreIndex",
      "NegativePreIndex_al_r3_r4_minus_247_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r12, minus, 53, PreIndex},
      "al r4 r12 minus 53 PreIndex",
      "NegativePreIndex_al_r4_r12_minus_53_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r3, minus, 17, PreIndex},
      "al r0 r3 minus 17 PreIndex",
      "NegativePreIndex_al_r0_r3_minus_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r9, minus, 11, PreIndex},
      "al r11 r9 minus 11 PreIndex",
      "NegativePreIndex_al_r11_r9_minus_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r5, minus, 107, PreIndex},
      "al r0 r5 minus 107 PreIndex",
      "NegativePreIndex_al_r0_r5_minus_107_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r11, minus, 44, PreIndex},
      "al r9 r11 minus 44 PreIndex",
      "NegativePreIndex_al_r9_r11_minus_44_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r12, minus, 32, PreIndex},
      "al r9 r12 minus 32 PreIndex",
      "NegativePreIndex_al_r9_r12_minus_32_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r1, minus, 135, PreIndex},
      "al r4 r1 minus 135 PreIndex",
      "NegativePreIndex_al_r4_r1_minus_135_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r14, minus, 39, PreIndex},
      "al r6 r14 minus 39 PreIndex",
      "NegativePreIndex_al_r6_r14_minus_39_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r12, minus, 80, PreIndex},
      "al r5 r12 minus 80 PreIndex",
      "NegativePreIndex_al_r5_r12_minus_80_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r11, minus, 55, PreIndex},
      "al r8 r11 minus 55 PreIndex",
      "NegativePreIndex_al_r8_r11_minus_55_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r4, minus, 122, PreIndex},
      "al r5 r4 minus 122 PreIndex",
      "NegativePreIndex_al_r5_r4_minus_122_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r1, minus, 82, PreIndex},
      "al r11 r1 minus 82 PreIndex",
      "NegativePreIndex_al_r11_r1_minus_82_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r7, minus, 3, PreIndex},
      "al r5 r7 minus 3 PreIndex",
      "NegativePreIndex_al_r5_r7_minus_3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r5, minus, 199, PreIndex},
      "al r8 r5 minus 199 PreIndex",
      "NegativePreIndex_al_r8_r5_minus_199_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r10, minus, 23, PreIndex},
      "al r6 r10 minus 23 PreIndex",
      "NegativePreIndex_al_r6_r10_minus_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r11, minus, 221, PreIndex},
      "al r8 r11 minus 221 PreIndex",
      "NegativePreIndex_al_r8_r11_minus_221_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r6, minus, 206, PreIndex},
      "al r2 r6 minus 206 PreIndex",
      "NegativePreIndex_al_r2_r6_minus_206_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r3, minus, 198, PreIndex},
      "al r12 r3 minus 198 PreIndex",
      "NegativePreIndex_al_r12_r3_minus_198_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r12, minus, 94, PreIndex},
      "al r2 r12 minus 94 PreIndex",
      "NegativePreIndex_al_r2_r12_minus_94_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r9, minus, 69, PreIndex},
      "al r2 r9 minus 69 PreIndex",
      "NegativePreIndex_al_r2_r9_minus_69_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r14, minus, 120, PreIndex},
      "al r10 r14 minus 120 PreIndex",
      "NegativePreIndex_al_r10_r14_minus_120_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r5, minus, 138, PreIndex},
      "al r8 r5 minus 138 PreIndex",
      "NegativePreIndex_al_r8_r5_minus_138_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r12, minus, 206, PreIndex},
      "al r8 r12 minus 206 PreIndex",
      "NegativePreIndex_al_r8_r12_minus_206_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r4, minus, 27, PreIndex},
      "al r11 r4 minus 27 PreIndex",
      "NegativePreIndex_al_r11_r4_minus_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r3, minus, 34, PreIndex},
      "al r0 r3 minus 34 PreIndex",
      "NegativePreIndex_al_r0_r3_minus_34_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r10, minus, 216, PreIndex},
      "al r9 r10 minus 216 PreIndex",
      "NegativePreIndex_al_r9_r10_minus_216_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r14, minus, 186, PreIndex},
      "al r2 r14 minus 186 PreIndex",
      "NegativePreIndex_al_r2_r14_minus_186_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r12, minus, 92, PreIndex},
      "al r3 r12 minus 92 PreIndex",
      "NegativePreIndex_al_r3_r12_minus_92_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r7, minus, 248, PreIndex},
      "al r8 r7 minus 248 PreIndex",
      "NegativePreIndex_al_r8_r7_minus_248_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r0, minus, 63, PreIndex},
      "al r11 r0 minus 63 PreIndex",
      "NegativePreIndex_al_r11_r0_minus_63_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r2, minus, 217, PreIndex},
      "al r12 r2 minus 217 PreIndex",
      "NegativePreIndex_al_r12_r2_minus_217_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r2, minus, 19, PreIndex},
      "al r1 r2 minus 19 PreIndex",
      "NegativePreIndex_al_r1_r2_minus_19_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r4, minus, 160, PreIndex},
      "al r11 r4 minus 160 PreIndex",
      "NegativePreIndex_al_r11_r4_minus_160_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r8, minus, 121, PreIndex},
      "al r7 r8 minus 121 PreIndex",
      "NegativePreIndex_al_r7_r8_minus_121_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r3, minus, 105, PreIndex},
      "al r14 r3 minus 105 PreIndex",
      "NegativePreIndex_al_r14_r3_minus_105_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r2, minus, 136, PreIndex},
      "al r11 r2 minus 136 PreIndex",
      "NegativePreIndex_al_r11_r2_minus_136_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r7, minus, 145, PreIndex},
      "al r14 r7 minus 145 PreIndex",
      "NegativePreIndex_al_r14_r7_minus_145_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r11, minus, 152, PreIndex},
      "al r3 r11 minus 152 PreIndex",
      "NegativePreIndex_al_r3_r11_minus_152_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r0, minus, 234, PreIndex},
      "al r6 r0 minus 234 PreIndex",
      "NegativePreIndex_al_r6_r0_minus_234_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r9, minus, 30, PreIndex},
      "al r4 r9 minus 30 PreIndex",
      "NegativePreIndex_al_r4_r9_minus_30_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r4, minus, 103, PreIndex},
      "al r3 r4 minus 103 PreIndex",
      "NegativePreIndex_al_r3_r4_minus_103_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r9, minus, 212, PreIndex},
      "al r10 r9 minus 212 PreIndex",
      "NegativePreIndex_al_r10_r9_minus_212_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r8, minus, 184, PreIndex},
      "al r3 r8 minus 184 PreIndex",
      "NegativePreIndex_al_r3_r8_minus_184_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r5, minus, 28, PreIndex},
      "al r14 r5 minus 28 PreIndex",
      "NegativePreIndex_al_r14_r5_minus_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r1, minus, 182, PreIndex},
      "al r14 r1 minus 182 PreIndex",
      "NegativePreIndex_al_r14_r1_minus_182_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r0, minus, 42, PreIndex},
      "al r14 r0 minus 42 PreIndex",
      "NegativePreIndex_al_r14_r0_minus_42_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r10, minus, 167, PreIndex},
      "al r7 r10 minus 167 PreIndex",
      "NegativePreIndex_al_r7_r10_minus_167_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r12, minus, 31, PreIndex},
      "al r4 r12 minus 31 PreIndex",
      "NegativePreIndex_al_r4_r12_minus_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r3, minus, 36, PreIndex},
      "al r10 r3 minus 36 PreIndex",
      "NegativePreIndex_al_r10_r3_minus_36_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r4, minus, 228, PreIndex},
      "al r11 r4 minus 228 PreIndex",
      "NegativePreIndex_al_r11_r4_minus_228_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r11, minus, 117, PreIndex},
      "al r12 r11 minus 117 PreIndex",
      "NegativePreIndex_al_r12_r11_minus_117_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r0, minus, 124, PreIndex},
      "al r5 r0 minus 124 PreIndex",
      "NegativePreIndex_al_r5_r0_minus_124_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r9, minus, 8, PreIndex},
      "al r7 r9 minus 8 PreIndex",
      "NegativePreIndex_al_r7_r9_minus_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, 10, PreIndex},
      "al r9 r1 minus 10 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r14, minus, 123, PreIndex},
      "al r7 r14 minus 123 PreIndex",
      "NegativePreIndex_al_r7_r14_minus_123_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r12, minus, 160, PreIndex},
      "al r2 r12 minus 160 PreIndex",
      "NegativePreIndex_al_r2_r12_minus_160_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r0, minus, 111, PreIndex},
      "al r3 r0 minus 111 PreIndex",
      "NegativePreIndex_al_r3_r0_minus_111_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r9, minus, 168, PreIndex},
      "al r0 r9 minus 168 PreIndex",
      "NegativePreIndex_al_r0_r9_minus_168_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r6, minus, 190, PreIndex},
      "al r14 r6 minus 190 PreIndex",
      "NegativePreIndex_al_r14_r6_minus_190_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r2, minus, 142, PreIndex},
      "al r4 r2 minus 142 PreIndex",
      "NegativePreIndex_al_r4_r2_minus_142_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r6, minus, 253, PreIndex},
      "al r8 r6 minus 253 PreIndex",
      "NegativePreIndex_al_r8_r6_minus_253_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r4, minus, 101, PreIndex},
      "al r5 r4 minus 101 PreIndex",
      "NegativePreIndex_al_r5_r4_minus_101_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r3, minus, 79, PreIndex},
      "al r2 r3 minus 79 PreIndex",
      "NegativePreIndex_al_r2_r3_minus_79_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r4, minus, 13, PreIndex},
      "al r14 r4 minus 13 PreIndex",
      "NegativePreIndex_al_r14_r4_minus_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r2, minus, 132, PreIndex},
      "al r4 r2 minus 132 PreIndex",
      "NegativePreIndex_al_r4_r2_minus_132_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex}};

// We record all inputs to the instructions as outputs. This way, we also check
// that what shouldn't change didn't change.
struct TestResult {
  size_t output_size;
  const Inputs* outputs;
};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/simulator-cond-rd-memop-immediate-512-ldrh-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-immediate-512-ldrsb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-immediate-512-ldrsh-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-immediate-512-strh-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  SETUP();
  masm.UseA32();
  START();

  // Data to compare to `reference`.
  TestResult* results[ARRAY_SIZE(kTests)];

  // Test cases for memory bound instructions may allocate a buffer and save its
  // address in this array.
  byte* scratch_memory_buffers[ARRAY_SIZE(kTests)];

  // Generate a loop for each element in `kTests`. Each loop tests one specific
  // instruction.
  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Allocate results on the heap for this test.
    results[i] = new TestResult;
    results[i]->outputs = new Inputs[kTests[i].input_size];
    results[i]->output_size = kTests[i].input_size;

    size_t input_stride = sizeof(kTests[i].inputs[0]) * kTests[i].input_size;
    VIXL_ASSERT(IsUint32(input_stride));

    scratch_memory_buffers[i] = NULL;

    Label loop;
    UseScratchRegisterScope scratch_registers(&masm);
    // Include all registers from r0 ro r12.
    scratch_registers.Include(RegisterList(0x1fff));

    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    int32_t offset = kTests[i].operands.offset;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, offset, addr_mode);
    scratch_registers.Exclude(rd);
    scratch_registers.Exclude(rn);

    // Allocate reserved registers for our own use.
    Register input_ptr = scratch_registers.Acquire();
    Register input_end = scratch_registers.Acquire();
    Register result_ptr = scratch_registers.Acquire();

    // Initialize `input_ptr` to the first element and `input_end` the address
    // after the array.
    __ Mov(input_ptr, Operand::From(kTests[i].inputs));
    __ Add(input_end, input_ptr, static_cast<uint32_t>(input_stride));
    __ Mov(result_ptr, Operand::From(results[i]->outputs));
    __ Bind(&loop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      Register saved_q_bit = temp_registers.Acquire();
      // Save the `Q` bit flag.
      __ Mrs(saved_q_bit, APSR);
      __ And(saved_q_bit, saved_q_bit, QFlag);
      // Set the `NZCV` and `Q` flags together.
      __ Ldr(nzcv_bits, MemOperand(input_ptr, offsetof(Inputs, apsr)));
      __ Orr(nzcv_bits, nzcv_bits, saved_q_bit);
      __ Msr(APSR_nzcvq, nzcv_bits);
    }
    __ Ldr(rd, MemOperand(input_ptr, offsetof(Inputs, rd)));
    // Allocate 4 bytes for the instruction to work with.
    scratch_memory_buffers[i] = new byte[4];
    {
      UseScratchRegisterScope temp_registers(&masm);

      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Write the expected data into the scratch buffer.
      __ Mov(base_register, Operand::From(scratch_memory_buffers[i]));
      __ Ldr(memop_tmp, MemOperand(input_ptr, offsetof(Inputs, memop) + 4));
      __ Str(memop_tmp, MemOperand(base_register));

      // Compute the address to put into the base register so that the
      // `MemOperand` points to the right location.
      // TODO: Support more kinds of `MemOperand`.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Add(base_register, base_register, memop_tmp);
          }
        }
      }
    }


    (masm.*instruction)(cond, rd, memop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      __ Mrs(nzcv_bits, APSR);
      // Only record the NZCV bits.
      __ And(nzcv_bits, nzcv_bits, NZCVFlag);
      __ Str(nzcv_bits, MemOperand(result_ptr, offsetof(Inputs, apsr)));
    }
    __ Str(rd, MemOperand(result_ptr, offsetof(Inputs, rd)));
    {
      UseScratchRegisterScope temp_registers(&masm);
      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Compute the address of the scratch buffer by from the base register. If
      // the instruction has updated the base register, we will be able to
      // record it.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Sub(base_register, base_register, memop_tmp);
          }
        }
      }

      // Record the value of the base register, as an offset from the scratch
      // buffer's address.
      __ Mov(memop_tmp, Operand::From(scratch_memory_buffers[i]));
      __ Sub(base_register, base_register, memop_tmp);
      __ Str(base_register, MemOperand(result_ptr, offsetof(Inputs, memop)));

      // Record the 32 bit word from memory.
      __ Ldr(memop_tmp, MemOperand(memop_tmp));
      __ Str(memop_tmp, MemOperand(result_ptr, offsetof(Inputs, memop) + 4));
    }


    // Advance the result pointer.
    __ Add(result_ptr, result_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    // Loop back until `input_ptr` is lower than `input_base`.
    __ Add(input_ptr, input_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    __ Cmp(input_ptr, input_end);
    __ B(ne, &loop);
  }

  END();

  RUN();

  if (Test::generate_test_trace()) {
    // Print the results.
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("const Inputs kOutputs_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (size_t j = 0; j < results[i]->output_size; j++) {
        printf("  { ");
        printf("0x%08" PRIx32, results[i]->outputs[j].apsr);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rd);
        printf(", ");
        printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
               results[i]->outputs[j].memop[0],
               results[i]->outputs[j].memop[1]);
        printf(" },\n");
      }
      printf("};\n");
    }
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kOutputs_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kOutputs_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else if (kCheckSimulatorTestResults) {
    // Check the results.
    unsigned total_error_count = 0;
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      bool instruction_has_errors = false;
      for (size_t j = 0; j < kTests[i].input_size; j++) {
        uint32_t apsr = results[i]->outputs[j].apsr;
        uint32_t rd = results[i]->outputs[j].rd;
        uint32_t memop[2] = {results[i]->outputs[j].memop[0],
                             results[i]->outputs[j].memop[1]};

        uint32_t apsr_input = kTests[i].inputs[j].apsr;
        uint32_t rd_input = kTests[i].inputs[j].rd;
        uint32_t memop_input[2] = {kTests[i].inputs[j].memop[0],
                                   kTests[i].inputs[j].memop[1]};

        uint32_t apsr_ref = reference[i].outputs[j].apsr;
        uint32_t rd_ref = reference[i].outputs[j].rd;
        uint32_t memop_ref[2] = {results[i]->outputs[j].memop[0],
                                 results[i]->outputs[j].memop[1]};


        if (((apsr != apsr_ref) || (rd != rd_ref) ||
             ((memop[0] != memop_ref[0]) && (memop[1] != memop_ref[1]))) &&
            (++total_error_count <= kErrorReportLimit)) {
          // Print the instruction once even if it triggered multiple failures.
          if (!instruction_has_errors) {
            printf("Error(s) when testing \"%s %s\":\n",
                   mnemonic,
                   kTests[i].operands_description);
            instruction_has_errors = true;
          }
          // Print subsequent errors.
          printf("  Input:    ");
          printf("0x%08" PRIx32, apsr_input);
          printf(", ");
          printf("0x%08" PRIx32, rd_input);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_input[0],
                 memop_input[1]);
          printf("\n");
          printf("  Expected: ");
          printf("0x%08" PRIx32, apsr_ref);
          printf(", ");
          printf("0x%08" PRIx32, rd_ref);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_ref[0],
                 memop_ref[1]);
          printf("\n");
          printf("  Found:    ");
          printf("0x%08" PRIx32, apsr);
          printf(", ");
          printf("0x%08" PRIx32, rd);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}", memop[0], memop[1]);
          printf("\n\n");
        }
      }
    }

    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    VIXL_CHECK(total_error_count == 0);
  } else {
    VIXL_WARNING("Assembled the code, but did not run anything.\n");
  }

  for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
    delete[] results[i]->outputs;
    delete results[i];
    delete[] scratch_memory_buffers[i];
  }
}

// Instantiate tests for each instruction in the list.
// TODO: Remove this limitation by having a sandboxing mechanism.
#if defined(VIXL_HOST_POINTER_32)
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_IMMEDIATE_512_" #mnemonic "_A32",    \
      &Test_##mnemonic);
#else
#define TEST(mnemonic)                                                   \
  void Test_##mnemonic() {                                               \
    VIXL_WARNING("This test can only run on a 32-bit host.\n");          \
    USE(TestHelper);                                                     \
  }                                                                      \
  Test test_##mnemonic(                                                  \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_IMMEDIATE_512_" #mnemonic "_A32", \
      &Test_##mnemonic);
#endif

FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
