package ONVIF::Device::Types::VideoEncoderConfigurationOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %QualityRange_of :ATTR(:get<QualityRange>);
my %JPEG_of :ATTR(:get<JPEG>);
my %MPEG4_of :ATTR(:get<MPEG4>);
my %H264_of :ATTR(:get<H264>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        QualityRange
        JPEG
        MPEG4
        H264
        Extension

    ) ],
    {
        'QualityRange' => \%QualityRange_of,
        'JPEG' => \%JPEG_of,
        'MPEG4' => \%MPEG4_of,
        'H264' => \%H264_of,
        'Extension' => \%Extension_of,
    },
    {
        'QualityRange' => 'ONVIF::Device::Types::IntRange',
        'JPEG' => 'ONVIF::Device::Types::JpegOptions',
        'MPEG4' => 'ONVIF::Device::Types::Mpeg4Options',
        'H264' => 'ONVIF::Device::Types::H264Options',
        'Extension' => 'ONVIF::Device::Types::VideoEncoderOptionsExtension',
    },
    {

        'QualityRange' => 'QualityRange',
        'JPEG' => 'JPEG',
        'MPEG4' => 'MPEG4',
        'H264' => 'H264',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::VideoEncoderConfigurationOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoEncoderConfigurationOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * QualityRange


=item * JPEG


=item * MPEG4


=item * H264


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::VideoEncoderConfigurationOptions
   QualityRange =>  { # ONVIF::Device::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   JPEG =>  { # ONVIF::Device::Types::JpegOptions
     ResolutionsAvailable =>  { # ONVIF::Device::Types::VideoResolution
       Width =>  $some_value, # int
       Height =>  $some_value, # int
     },
     FrameRateRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     EncodingIntervalRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
   },
   MPEG4 =>  { # ONVIF::Device::Types::Mpeg4Options
     ResolutionsAvailable =>  { # ONVIF::Device::Types::VideoResolution
       Width =>  $some_value, # int
       Height =>  $some_value, # int
     },
     GovLengthRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     FrameRateRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     EncodingIntervalRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     Mpeg4ProfilesSupported => $some_value, # Mpeg4Profile
   },
   H264 =>  { # ONVIF::Device::Types::H264Options
     ResolutionsAvailable =>  { # ONVIF::Device::Types::VideoResolution
       Width =>  $some_value, # int
       Height =>  $some_value, # int
     },
     GovLengthRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     FrameRateRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     EncodingIntervalRange =>  { # ONVIF::Device::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     H264ProfilesSupported => $some_value, # H264Profile
   },
   Extension =>  { # ONVIF::Device::Types::VideoEncoderOptionsExtension
     JPEG =>  { # ONVIF::Device::Types::JpegOptions2
       BitrateRange =>  { # ONVIF::Device::Types::IntRange
         Min =>  $some_value, # int
         Max =>  $some_value, # int
       },
     },
     MPEG4 =>  { # ONVIF::Device::Types::Mpeg4Options2
       BitrateRange =>  { # ONVIF::Device::Types::IntRange
         Min =>  $some_value, # int
         Max =>  $some_value, # int
       },
     },
     H264 =>  { # ONVIF::Device::Types::H264Options2
       BitrateRange =>  { # ONVIF::Device::Types::IntRange
         Min =>  $some_value, # int
         Max =>  $some_value, # int
       },
     },
     Extension =>  { # ONVIF::Device::Types::VideoEncoderOptionsExtension2
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

