'''OpenGL extension OES.matrix_get

This module customises the behaviour of the 
OpenGL.raw.GLES1.OES.matrix_get to provide a more 
Python-friendly API

Overview (from the spec)
	
	Many applications require the ability to be able to read the
	GL matrices.  OpenGL ES 1.1 will allow an application to read
	the matrices using the GetFloatv command for the common profile
	and the GetFixedv command for the common-lite profile.
	
	In cases where the common-lite implementation stores matrices
	and performs matrix operations internally using floating pt 
	(example would be OpenGL ES implementations that support JSR184 etc.)
	the GL cannot return the floating pt matrix elements since the float
	data type is not supported by the common-lite profile.
	Using GetFixedv to get the matrix data will result in a loss of
	information.
	
	To take care of this issue, new tokens are proposed by this
	extension.  These tokens will allow the GL to return a 
	representation of the floating pt matrix elements as as an array
	of integers, according to the IEEE 754 floating pt "single format"
	bit layout.
	
	Bit 31 represents the sign of the floating pt number.
	Bits 30 - 23 represent the exponent of the floating pt number.
	Bits 22 - 0 represent the mantissa of the floating pt number.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/matrix_get.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.OES.matrix_get import *
from OpenGL.raw.GLES1.OES.matrix_get import _EXTENSION_NAME

def glInitMatrixGetOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION