.\"
.\" Copyright (c) 2023 Andrea Biscuola <a@abiscuola.com>
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.Dd September 3, 2023
.Dt IRCTK-IRC n
.Os
.Sh NAME
.Nm irctk-exts
.Nd irctk extensions subsystem
.Sh SYNOPSIS
.Cm exts bootstrapped
.Pp
.Cm exts init
.Pp
.Cm exts killbyname Ar name
.Pp
.Cm exts list
.Pp
.Cm exts load Ar path Ar cb
.Pp
.Cm exts newmsg
.Pp
.Cm exts readmsg Ar ch Ar cb
.Pp
.Cm exts writemsg Ar msg
.Sh DESCRIPTION
The exts namespace, takes care of loading, and running, irctk extension
executables.
The subsystem completely takes care of the extensions management, with
the only communications with the other layers defined by the exported
functions.
.Pp
.Cm exts bootstrapped
checks, during application startup, if all the configured extensions are
started properly, before continuing with the other parts of the process.
.Pp
.Cm exts init
initializes the subsystem, loading the extensions at startup, both from the
extension default directory and the irctk extensions configurations file.
.Pp
.Cm exts killbyname
unloads an extension identified by the
.Ar name
it communicated to irctk.
All the unloaded extension related resources are cleared by this command.
.Pp
.Cm exts list
provides a tcl list with all the extensions actually running.
Every extension is represented in the list by three fields, in the following
order:
.Pp
.Bl -tag -width tenletters -offset indent -compact
.It Name
The extension name, as reported during the handshake.
.It Version
Extension version number.
.It Path
The extension executable file path.
.El
.Pp
.Cm exts load
runs a new extension from the file at
.Ar path .
If the handshake between the application and the extension is successful,
messages coming from the extension are passed to the callback command
.Ar cb
after being processed.
.Pp
.Cm exts newmsg
returns an empty dictionary ready to be filled to be sent to the extensions
subsystem.
.Pp
.Cm exts readmsg
read a message from the extension channel
.Ar ch
and passes it to the callback
.Ar cb
after processing it.
The callback is called with the form:
.Bd -literal -offset indent
$cb $msg
.Ed
.Pp
Where
.Dq $msg
is a dictionary containing all the values of the received message.
.Pp
.Cm exts writemsg
is used to pass an extension message to be written to all the running extensions
from irctk.
The message is a dictionary containing the fields related to the message type.
A message can be of type irc or plumb.
Please refer to the extensions protocol specification for additional details.
.Sh RETURN VALUES
.Cm exts list
returns the list of loaded extensions.
.Pp
.Cm exts killbyname
always return the empty string.
.Pp
.Cm exts writemsg
returns 0 on success or <0 if an error occur.
.\" XXX actually it always return 0
.Pp
.Cm exts load
return 0 if the extension already exists, the new communication channel if
the load of the extension is successful and <0 if an error occur.
.Sh FILES
.Bl -tag -compact -width "${HOME}/.config/irctk/extensions.confXXXXXX"
.It Pa ${PREFIX}/libexec
Default extensions directory.
.It Pa ${HOME}/.config/irctk/extensions.conf
.Xr irctk 1
loaded extensions save file.
.El
.Sh SEE ALSO
.Xr irctk 1 ,
.Xr irctk-gui n ,
.Xr irctk-irc n ,
.Xr irctk-irctk n ,
.Xr irctk-log n
.Sh AUTHORS
.An Andrea Biscuola Aq Mt a@abiscuola.com
