/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_so extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Jarmal";
        final String metaValue_FR = "Faransiis";
        final String metaValue_IT = "Talyaani";
        final String metaValue_RU = "Ruush";
        final String metaValue_ZZ = "Far aan la aqoon amase aan saxnayn";
        final Object[][] data = new Object[][] {
            { "PR", "Puerto Rico" },
            { "PS", "Falastiin Daanka galbeed iyo Qasa" },
            { "PT", "Bortuqaal" },
            { "pt", "Boortaqiis" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qadar" },
            { "AD", "Andora" },
            { "AE", "Imaaraadka Carabta ee Midoobay" },
            { "AF", "Afgaanistaan" },
            { "AG", "Antigua iyo Barbuda" },
            { "AI", "Anguilla" },
            { "ak", "Akan" },
            { "AL", "Albaaniya" },
            { "AM", "Armeeniya" },
            { "am", "Axmaari" },
            { "AO", "Angoola" },
            { "AR", "Arjantiin" },
            { "ar", "Carabi" },
            { "AS", "Samowa Ameerika" },
            { "AT", "Awsteriya" },
            { "RE", "R\u00e9union" },
            { "AU", "Awstaraaliya" },
            { "AW", "Aruba" },
            { "AZ", "Azerbajaan" },
            { "RO", "Rumaaniya" },
            { "ro", "Romanka" },
            { "BA", "Bosniya Hersigoviina" },
            { "BB", "Baarbadoos" },
            { "BD", "Bangaaladheesh" },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "BE", "Biljam" },
            { "be", "Beleruusiyaan" },
            { "BF", "Burkiina Faaso" },
            { "BG", "Bulgaariya" },
            { "RW", "Ruwanda" },
            { "bg", "Bulgeeriyaan" },
            { "rw", "Rwanda" },
            { "BH", "Baxreyn" },
            { "BI", "Burundi" },
            { "BJ", "Biniin" },
            { "BM", "Bermuuda" },
            { "BN", "Buruneeya" },
            { "bn", "Bangaali" },
            { "BO", "Boliifiya" },
            { "SA", "Sacuudi Carabiya" },
            { "SB", "Solomon Islands" },
            { "BR", "Braasiil" },
            { "SC", "Sishelis" },
            { "BS", "Bahaamas" },
            { "SD", "Suudaan" },
            { "BT", "Bhutan" },
            { "SE", "Iswidhan" },
            { "SG", "Singaboor" },
            { "BW", "Botuswaana" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenia" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "SK", "Slovakia" },
            { "SL", "Siraaliyoon" },
            { "SM", "San Marino" },
            { "SN", "Sinigaal" },
            { "SO", "Soomaaliya" },
            { "so", "Soomaali" },
            { "CA", "Kanada" },
            { "SR", "Suriname" },
            { "CD", "Jamhuuriyadda Dimuquraadiga Kongo" },
            { "ST", "S\u00e3o Tom\u00e9 and Pr\u00edncipe" },
            { "CF", "Jamhuuriyadda Afrikada Dhexe" },
            { "SV", "El Salvador" },
            { "sv", "Swiidhis" },
            { "CG", "Kongo" },
            { "CH", "Swiiserlaand" },
            { "CI", "Ivory coast" },
            { "SY", "Suuriya" },
            { "SZ", "Iswaasilaand" },
            { "CK", "Jaziiradda Cook" },
            { "CL", "Jili" },
            { "CM", "Kaameruun" },
            { "CN", "Shiinaha" },
            { "CO", "Kolombiya" },
            { "ta", "Tamiil" },
            { "CR", "Kosta Riika" },
            { "TC", "Turks and Caicos Islands" },
            { "TD", "Jaad" },
            { "cs", "Jeeg" },
            { "CU", "Kuuba" },
            { "CV", "Cape Verde Islands" },
            { "TG", "Toogo" },
            { "TH", "Taylaand" },
            { "th", "Taaylandays" },
            { "CY", "Qubrus" },
            { "TJ", "Tajikistan" },
            { "CZ", "Jamhuuriyadda Jek" },
            { "TK", "Tokelau" },
            { "TL", "Timorka bari" },
            { "TM", "Turkmenistan" },
            { "TN", "Tuniisiya" },
            { "TO", "Tonga" },
            { "TR", "Turki" },
            { "tr", "Turkish" },
            { "TT", "Trinidad and Tobago" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "TV", "Tuvalu" },
            { "TW", "Taywaan" },
            { "DJ", "Jabuuti" },
            { "TZ", "Tansaaniya" },
            { "DK", "Denmark" },
            { "DM", "Domeenika" },
            { "Zzzz", metaValue_ZZ },
            { "DO", "Jamhuuriyadda Domeenika" },
            { "UA", "Ukrayn" },
            { "UG", "Ugaanda" },
            { "DZ", "Aljeeriya" },
            { "uk", "Yukreeniyaan" },
            { "ur", "Urduu" },
            { "EC", "Ikuwadoor" },
            { "US", "Maraykanka" },
            { "EE", "Estooniya" },
            { "EG", "Masar" },
            { "UY", "Uruguwaay" },
            { "UZ", "Uusbakistaan" },
            { "el", "Giriik" },
            { "en", "Ingiriisi" },
            { "VA", "Faatikaan" },
            { "ER", "Eretereeya" },
            { "VC", "Saint Vincent and the Grenadines" },
            { "ES", "Isbeyn" },
            { "es", "Isbaanish" },
            { "ET", "Itoobiya" },
            { "VE", "Fenisuweela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "vi", "Fiitnaamays" },
            { "VN", "Fiyetnaam" },
            { "fa", "Faarisi" },
            { "VU", "Vanuatu" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Jaziiradaha Fooklaan" },
            { "FM", "Micronesia" },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "WF", "Wallis and Futuna" },
            { "fy", "Firiisiyan Galbeed" },
            { "GA", "Gaaboon" },
            { "GB", "United Kingdom" },
            { "WS", "Samoa" },
            { "GD", "Giriinaada" },
            { "GE", "Joorjiya" },
            { "GF", "French Guiana" },
            { "GH", "Gaana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Giriig" },
            { "GT", "Guwaatamaala" },
            { "GU", "Guam" },
            { "GW", "Gini-Bisaaw" },
            { "GY", "Guyana" },
            { "Zxxx", "Aan la qorin" },
            { "ha", "Hawsa" },
            { "hi", "Hindi" },
            { "HN", "Honduras" },
            { "HR", "Korweeshiya" },
            { "HT", "Hayti" },
            { "YE", "Yaman" },
            { "HU", "Hangeri" },
            { "hu", "Hangariyaan" },
            { "yo", "Yoruuba" },
            { "ID", "Indoneesiya" },
            { "YT", "Mayotte" },
            { "id", "Indunuusiyaan" },
            { "IE", "Ayrlaand" },
            { "ig", "Igbo" },
            { "IL", "Israa\u02bciil" },
            { "IN", "Hindiya" },
            { "IO", "British Indian Ocean Territory" },
            { "ZA", "Koonfur Afrika" },
            { "IQ", "Ciraaq" },
            { "IR", "Iiraan" },
            { "IS", "Iislaand" },
            { "it", metaValue_IT },
            { "IT", metaValue_IT },
            { "zh", "Jayniis" },
            { "ZM", "Saambiya" },
            { "ja", "Jabbaaniis" },
            { "zu", "Zuulu" },
            { "ZW", "Simbaabwe" },
            { "ZZ", metaValue_ZZ },
            { "JM", "Jameyka" },
            { "JO", "Urdun" },
            { "JP", "Jabaan" },
            { "jv", "Jafaaniis" },
            { "KE", "Kiiniya" },
            { "KG", "Kirgistaan" },
            { "KH", "Kamboodiya" },
            { "KI", "Kiribati" },
            { "KM", "Komooros" },
            { "km", "Kamboodhian" },
            { "KN", "Saint Kitts and Nevis" },
            { "ko", "Kuuriyaan" },
            { "KP", "Kuuriyada Waqooyi" },
            { "KR", "Kuuriyada Koonfureed" },
            { "KW", "Kuwayt" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kasaakhistaan" },
            { "LA", "Laos" },
            { "LB", "Lubnaan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sirilaanka" },
            { "LR", "Laybeeriya" },
            { "LS", "Losooto" },
            { "LT", "Lituweeniya" },
            { "LU", "Luksemboorg" },
            { "LV", "Latfiya" },
            { "LY", "Liibiya" },
            { "MA", "Marooko" },
            { "MC", "Moonako" },
            { "MD", "Moldofa" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Islands" },
            { "MK", "Makadooniya" },
            { "ML", "Maali" },
            { "MM", "Miyanmar" },
            { "MN", "Mongooliya" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Muritaaniya" },
            { "MS", "Montserrat" },
            { "ms", "Malaay" },
            { "MT", "Maalda" },
            { "MU", "Murishiyoos" },
            { "MV", "Maaldiqeen" },
            { "MW", "Malaawi" },
            { "MX", "Meksiko" },
            { "MY", "Malaysia" },
            { "my", "Burmese" },
            { "MZ", "Musambiig" },
            { "NA", "Namiibiya" },
            { "NC", "New Caledonia" },
            { "NE", "Nayjer" },
            { "ne", "Nebaali" },
            { "NF", "Norfolk Island" },
            { "NG", "Nayjeeriya" },
            { "NI", "Nikaraaguwa" },
            { "NL", "Netherlands" },
            { "nl", "Holandays" },
            { "NO", "Noorweey" },
            { "NP", "Nebaal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Neyuusilaand" },
            { "OM", "Cumaan" },
            { "PA", "Panama" },
            { "pa", "Bunjaabi" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Filibiin" },
            { "PK", "Bakistaan" },
            { "PL", "Booland" },
            { "pl", "Boolish" },
            { "PM", "Saint Pierre and Miquelon" },
            { "PN", "Pitcairn" },
        };
        return data;
    }
}
