/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Kiarabu";
        final String metaValue_bn = "Kibengali";
        final String metaValue_bo = "Kitibeti";
        final String metaValue_el = "Kigiriki";
        final String metaValue_gu = "Kigujarati";
        final String metaValue_he = "Kiebrania";
        final String metaValue_hy = "Kiarmenia";
        final String metaValue_ja = "Kijapani";
        final String metaValue_ka = "Kijojia";
        final String metaValue_km = "Kikambodia";
        final String metaValue_kn = "Kikannada";
        final String metaValue_ko = "Kikorea";
        final String metaValue_la = "Kilatini";
        final String metaValue_lo = "Kilaosi";
        final String metaValue_ml = "Kimalayalam";
        final String metaValue_mn = "Kimongolia";
        final String metaValue_or = "Kioriya";
        final String metaValue_si = "Kisinhala";
        final String metaValue_ta = "Kitamil";
        final String metaValue_te = "Kitelugu";
        final String metaValue_type_co_standard = "Mpangilio wa Kawaida";
        final Object[][] data = new Object[][] {
            { "ksh", "Kicologne" },
            { "mwl", "Kimirandi" },
            { "Zsym", "Alama" },
            { "Zsye", "Emoji" },
            { "egy", "Kimisri" },
            { "tem", "Kitemne" },
            { "teo", "Kiteso" },
            { "rap", "Kirapanui" },
            { "AC", "Kisiwa cha Ascension" },
            { "rar", "Kirarotonga" },
            { "tet", "Kitetum" },
            { "AD", "Andorra" },
            { "AE", "Falme za Kiarabu" },
            { "nl_BE", "Kiflemi" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua na Barbuda" },
            { "type.ca.ethiopic", "Kalenda ya Kiethiopia" },
            { "AI", "Anguilla" },
            { "key.tz", "Ukanda Saa" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antaktiki" },
            { "AR", "Ajentina" },
            { "AS", "Samoa ya Marekani" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Visiwa vya Aland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia na Hezegovina" },
            { "BB", "Babadosi" },
            { "ceb", "Kichebuano" },
            { "BD", "Bangladeshi" },
            { "kum", "Kumyk" },
            { "BE", "Ubelgiji" },
            { "BF", "Bukinafaso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahareni" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemy" },
            { "BM", "Bermuda" },
            { "myv", "Kierzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Uholanzi ya Karibiani" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "xog", "Kisoga" },
            { "BT", "Bhutan" },
            { "BV", "Kisiwa cha Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kalenda ya Kiajemi" },
            { "type.nu.hebr", "Nambari za Kiebrania" },
            { "CA", "Kanada" },
            { "CC", "Visiwa vya Cocos (Keeling)" },
            { "mzn", "Kimazanderani" },
            { "CD", "Jamhuri ya Kidemokrasia ya Kongo" },
            { "CF", "Jamhuri ya Afrika ya Kati" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Uswisi" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Visiwa vya Cook" },
            { "CL", "Chile" },
            { "CM", "Kameruni" },
            { "CN", "Uchina" },
            { "CO", "Kolombia" },
            { "CP", "Kisiwa cha Clipperton" },
            { "CR", "Kostarika" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curacao" },
            { "CX", "Kisiwa cha Krismasi" },
            { "CY", "Cyprus" },
            { "CZ", "Chechia" },
            { "eka", "Kiekajuk" },
            { "DE", "Ujerumani" },
            { "ace", "Kiacheni" },
            { "cgg", "Kichiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Nambari za Kidevanagari" },
            { "DJ", "Jibuti" },
            { "DK", "Denmark" },
            { "ach", "Kiakoli" },
            { "Brai", "Braille" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Nambari Ndogo za Kiarmenia" },
            { "DO", "Jamhuri ya Dominika" },
            { "gor", "Kigorontalo" },
            { "zun", "Kizuni" },
            { "tig", "Kitigre" },
            { "DZ", "Aljeria" },
            { "pag", "Kipangasinan" },
            { "type.d0.hwidth", "Nusu upana" },
            { "EA", "Ceuta na Melilla" },
            { "pam", "Kipampanga" },
            { "EC", "Ecuador" },
            { "pap", "Kipapiamento" },
            { "ada", "Kiadangme" },
            { "EE", "Estonia" },
            { "EG", "Misri" },
            { "EH", "Sahara Magharibi" },
            { "pau", "Kipalau" },
            { "chk", "Kichukisi" },
            { "chm", "Kimari" },
            { "cho", "Kichoktao" },
            { "chr", "Kicherokee" },
            { "ER", "Eritrea" },
            { "ES", "Uhispania" },
            { "ET", "Ethiopia" },
            { "EU", "Umoja wa Ulaya" },
            { "type.ca.gregorian", "Kalenda ya Kigregori" },
            { "EZ", "EZ" },
            { "chy", "Kicheyeni" },
            { "type.nu.gujr", "Nambari za Kigujarati" },
            { "ady", "Kiadyghe" },
            { "FI", "Ufini" },
            { "FJ", "Fiji" },
            { "FK", "Visiwa vya Falkland" },
            { "FM", "Micronesia" },
            { "key.va", "Tofauti ya Mandhari" },
            { "FO", "Visiwa vya Faroe" },
            { "Taml", metaValue_ta },
            { "FR", "Ufaransa" },
            { "root", "Root" },
            { "type.ca.indian", "Kalenda ya Taifa ya India" },
            { "grc", "Kiyunani" },
            { "GA", "Gabon" },
            { "GB", "Uingereza" },
            { "pcm", "Pijini ya Nigeria" },
            { "GD", "Grenada" },
            { "GE", "Jojia" },
            { "GF", "Guiana ya Ufaransa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Gine" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea ya Ikweta" },
            { "GR", "Ugiriki" },
            { "GS", "Georgia Kusini na Visiwa vya Sandwich Kusini" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginebisau" },
            { "tlh", "Kiklingoni" },
            { "GY", "Guyana" },
            { "ckb", "Kikurdi cha Sorani" },
            { "zxx", "Hakuna maudhui ya lugha" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kisiwa cha Heard na Visiwa vya McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "Kiaghem" },
            { "gsw", "Kijerumani cha Uswisi" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Visiwa vya Kanari" },
            { "ID", "Indonesia" },
            { "peo", "Kiajemi cha Kale" },
            { "IE", "Ayalandi" },
            { "nap", "Kinapoli" },
            { "naq", "Kinama" },
            { "zza", "Kizaza" },
            { "IL", "Israeli" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Eneo la Uingereza katika Bahari Hindi" },
            { "IQ", "Iraki" },
            { "IR", "Iran" },
            { "IS", "Aislandi" },
            { "IT", "Italia" },
            { "Zmth", "Hati za kihisabati" },
            { "type.nu.thai", "Nambari za Kithai" },
            { "type.nu.beng", "Nambari za Kibengali" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalenda ya Kiislamu" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japani" },
            { "ain", "Kiainu" },
            { "guz", "Kikisii" },
            { "type.nu.knda", "Nambari za Kikannada" },
            { "type.co.phonetic", "Utaratibu wa Kupanga Fonetiki" },
            { "type.ca.buddhist", "Kalenda ya Kibuddha" },
            { "KE", "Kenya" },
            { "419", "Amerika ya Kilatini" },
            { "KG", "Kirigizistani" },
            { "KH", "Kambodia" },
            { "KI", "Kiribati" },
            { "KM", "Komoro" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts na Nevis" },
            { "fr_CA", "Kifaransa (Canada)" },
            { "KP", "Korea Kaskazini" },
            { "KR", "Korea Kusini" },
            { "KW", "Kuwait" },
            { "tpi", "Kitokpisin" },
            { "KY", "Visiwa vya Cayman" },
            { "KZ", "Kazakistani" },
            { "Cyrl", "Kisiriliki" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "St. Lucia" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Kisaksoni" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "cop", "Kikhufti" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "Kana", "Kikatakana" },
            { "LY", "Libya" },
            { "lad", "Kiladino" },
            { "vun", "Kivunjo" },
            { "lag", "Kirangi" },
            { "Thaa", "Kithaana" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaska" },
            { "MH", "Visiwa vya Marshall" },
            { "ale", "Kialeut" },
            { "Thai", "Kithai" },
            { "type.nu.vaii", "Dijiti za Vai" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "Kinewari" },
            { "MO", "Macau SAR China" },
            { "MP", "Visiwa vya Mariana vya Kaskazini" },
            { "MQ", "Martinique" },
            { "MR", "Moritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "Mtindo wa kunukuu wa UN GEGN" },
            { "MU", "Morisi" },
            { "alt", "Kialtai" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "Kalenda ya Kijapani" },
            { "MY", "Malesia" },
            { "MZ", "Msumbiji" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "Kalenda ya Kiebrania" },
            { "type.co.dictionary", "Mpangilio wa Kamusi" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Kisiwa cha Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Kitaroko" },
            { "NI", "Nikaragwa" },
            { "NL", "Uholanzi" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Kirombo" },
            { "NZ", "Nyuzilandi" },
            { "ang", "Kiingereza cha Kale" },
            { "OM", "Oman" },
            { "anp", "Kiangika" },
            { "crs", "Krioli ya Shelisheli" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Kalenda ya Kiislamu/Rasmi" },
            { "PE", "Peru" },
            { "PF", "Polynesia ya Ufaransa" },
            { "PG", "Papua New Guinea" },
            { "PH", "Ufilipino" },
            { "PK", "Pakistani" },
            { "PL", "Poland" },
            { "ewo", "Kiewondo" },
            { "PM", "Santapierre na Miquelon" },
            { "PN", "Visiwa vya Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Maeneo ya Palestina" },
            { "PT", "Ureno" },
            { "PW", "Palau" },
            { "nia", "Kiniasi" },
            { "type.nu.greklow", "Nambari Ndogo za Kigiriki" },
            { "PY", "Paraguay" },
            { "tum", "Kitumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "niu", "Kiniuea" },
            { "QO", "Oceania ya Nje" },
            { "lez", "Kilezighian" },
            { "tvl", "Kituvalu" },
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Kaskazini" },
            { "RE", "Reunion" },
            { "005", "Amerika Kusini" },
            { "jbo", "Lojban" },
            { "009", "Oceania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Urusi" },
            { "RW", "Rwanda" },
            { "SA", "Saudia" },
            { "SB", "Visiwa vya Solomon" },
            { "twq", "Kitasawaq" },
            { "011", "Afrika ya Magharibi" },
            { "SC", "Ushelisheli" },
            { "SD", "Sudan" },
            { "013", "Amerika ya Kati" },
            { "SE", "Uswidi" },
            { "014", "Afrika ya Mashariki" },
            { "arc", "Kiaramu" },
            { "015", "Afrika ya Kaskazini" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "type.lb.strict", "Mtindo Finyu wa Kukata Mstari" },
            { "017", "Afrika ya Kati" },
            { "SI", "Slovenia" },
            { "018", "Afrika ya Kusini" },
            { "SJ", "Svalbard na Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "SL", "Siera Leoni" },
            { "SM", "San Marino" },
            { "SN", "Senegali" },
            { "SO", "Somalia" },
            { "arn", "Kimapuche" },
            { "arp", "Kiarapaho" },
            { "type.nu.taml", "Nambari za Kitamil cha Jadi" },
            { "SR", "Suriname" },
            { "SS", "Sudan Kusini" },
            { "ST", "S\u00e3o Tom\u00e9 na Pr\u00edncipe" },
            { "arq", "Kiarabu cha Algeria" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "Kiyao" },
            { "SZ", "Uswazi" },
            { "arz", "Kiarabu cha Misri" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Kiasu" },
            { "type.ms.ussystem", "Mfumo wa US" },
            { "021", "Amerika ya Kaskazini" },
            { "TC", "Visiwa vya Turks na Caicos" },
            { "yav", "Kiyangben" },
            { "TD", "Chad" },
            { "TF", "Maeneo ya Kusini ya Ufaransa" },
            { "TG", "Togo" },
            { "TH", "Tailandi" },
            { "TJ", "Tajikistani" },
            { "029", "Karibiani" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Kiyemba" },
            { "type.co.searchjl", "Tafuta kwa Konsonanti Halisi ya Hangul" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Uturuki" },
            { "TT", "Trinidad na Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Kiasturia" },
            { "TZ", "Tanzania" },
            { "nmg", "Kikwasio" },
            { "Zzzz", "Hati isiyojulikana" },
            { "UA", "Ukraine" },
            { "rup", "Kiaromania" },
            { "030", "Asia ya Mashariki" },
            { "tyv", "Kituva" },
            { "sw_CD", "Kingwana" },
            { "034", "Asia ya Kusini" },
            { "035", "Asia ya Kusini Mashariki" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Mpangilio wa Kipinyin" },
            { "039", "Ulaya ya Kusini" },
            { "Sinh", metaValue_si },
            { "UM", "Visiwa Vidogo vya Nje vya Marekani" },
            { "UN", "Umoja wa Mataifa" },
            { "US", "Marekani" },
            { "haw", "Kihawai" },
            { "type.co.gb2312han", "Mpangilio wa Kichina Rahisi - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Kiprussia" },
            { "UZ", "Uzibekistani" },
            { "tzm", "Central Atlas Tamazight" },
            { "type.co.stroke", "Mpangilio wa Mikwaju" },
            { "nnh", "Lugha ya Ngiemboon" },
            { "VA", "Mji wa Vatican" },
            { "VC", "St. Vincent na Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Visiwa vya Virgin, Uingereza" },
            { "VI", "Visiwa vya Virgin, Marekani" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Kinogai" },
            { "rwk", "Lugha ya Rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis na Futuna" },
            { "type.co.traditional", metaValue_type_co_standard },
            { "057", "Eneo la Mikronesia" },
            { "jgo", "Kingomba" },
            { "lkt", "Kilakota" },
            { "type.nu.finance", "Tarakimu za Kifedha" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "wal", "Kiwolaytta" },
            { "war", "Kiwaray" },
            { "awa", "Kiawadhi" },
            { "061", "Polynesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Haijaandikwa" },
            { "wbp", "Kiwarlpiri" },
            { "YE", "Yemeni" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", metaValue_type_co_standard },
            { "YT", "Mayotte" },
            { "ZA", "Afrika Kusini" },
            { "type.lb.loose", "Mtindo Pana wa Kukata Mstari" },
            { "Deva", "Kidevanagari" },
            { "type.nu.geor", "Nambari za Kigeorgia" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Eneo lisilojulikana" },
            { "type.ms.metric", "Mfumo wa Metriki" },
            { "type.ca.iso8601", "Kalenda ya ISO-8601" },
            { "lol", "Kimongo" },
            { "nso", "Kisotho cha Kaskazini" },
            { "type.nu.telu", "Nambari za Kitelugu" },
            { "loz", "Kilozi" },
            { "jmc", "Kimachame" },
            { "type.nu.hansfin", "Nambari za Kifedha za Kichina Rahisi" },
            { "hil", "Kihiligaynon" },
            { "type.nu.arabext", "Nambari za Kiarabu/Kihindi Zilizopanuliwa" },
            { "nus", "Kinuer" },
            { "dak", "Kidakota" },
            { "type.nu.fullwide", "Nambari za Upana Kamili" },
            { "hit", "Kihiti" },
            { "dar", "Kidaragwa" },
            { "dav", "Kitaita" },
            { "lrc", "Kiluri cha Kaskazini" },
            { "nwc", "Kinewari cha kale" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "sad", "Kisandawe" },
            { "type.nu.roman", "Nambari za Kirumi" },
            { "sah", "Kisakha" },
            { "sam", "Kiaramu cha Wasamaria" },
            { "saq", "Kisamburu" },
            { "sat", "Kisantali" },
            { "type.d0.npinyin", "Ya Nambari" },
            { "type.nu.native", "Digiti Asili" },
            { "sba", "Kingambay" },
            { "Guru", "Kigurmukhi" },
            { "lua", "Kiluba-Lulua" },
            { "type.d0.fwidth", "Upana kamili" },
            { "sbp", "Kisangu" },
            { "nyn", "Kinyankole" },
            { "nym", "Kinyamwezi" },
            { "lun", "Kilunda" },
            { "nyo", "Kinyoro" },
            { "luo", "Kijaluo" },
            { "fil", "Kifilipino" },
            { "hmn", "Kihmong" },
            { "lus", "Kimizo" },
            { "ban", "Kibali" },
            { "luy", "Kiluhya" },
            { "bas", "Kibasaa" },
            { "bax", "Kibamun" },
            { "nzi", "Kinzema" },
            { "sco", "Kiskoti" },
            { "scn", "Kisicilia" },
            { "aa", "Kiafar" },
            { "ab", "Kiabkhazi" },
            { "af", "Kiafrikana" },
            { "ak", "Kiakani" },
            { "bbj", "Kighomala" },
            { "am", "Kiamhari" },
            { "Arab", metaValue_ar },
            { "an", "Kiaragoni" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Hati za Kijapani" },
            { "as", "Kiassam" },
            { "av", "Kiavari" },
            { "sdh", "Kikurdi cha Kusini" },
            { "ay", "Kiaymara" },
            { "az", "Kiazerbaijani" },
            { "ba", "Kibashkir" },
            { "type.co.unihan", "Mpangilio wa Mikwaju ya Shina" },
            { "be", "Kibelarusi" },
            { "bg", "Kibulgaria" },
            { "bi", "Kibislama" },
            { "bm", "Kibambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Kidogrib" },
            { "br", "Kibretoni" },
            { "bs", "Kibosnia" },
            { "Mymr", "Myama" },
            { "type.nu.laoo", "Nambari za Kilao" },
            { "seh", "Kisena" },
            { "ca", "Kikatalani" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Kichechenia" },
            { "ch", "Kichamorro" },
            { "co", "Kikosikani" },
            { "Orya", metaValue_or },
            { "cs", "Kicheki" },
            { "cu", "Kislovakia cha Church" },
            { "cv", "Kichuvash" },
            { "cy", "Kiwelisi" },
            { "type.nu.ethi", "Nambari za Kiethiopia" },
            { "da", "Kidenmaki" },
            { "de", "Kijerumani" },
            { "type.cf.standard", "Mpangilio wa Kawaida wa Sarafu" },
            { "bej", "Kibeja" },
            { "bem", "Kibemba" },
            { "type.nu.mong", "Nambari za Kimongolia" },
            { "dv", "Kidivehi" },
            { "dz", "Kizongkha" },
            { "bez", "Kibena" },
            { "type.ca.chinese", "Kalenda ya Kichina" },
            { "dje", "Kizarma" },
            { "type.nu.grek", "Nambari za Kigiriki" },
            { "ee", "Kiewe" },
            { "bfd", "Kibafut" },
            { "type.lb.normal", "Mtindo wa Kawaida wa Kukata Mstari" },
            { "el", metaValue_el },
            { "en", "Kiingereza" },
            { "eo", "Kiesperanto" },
            { "type.co.big5han", "Mpangilio wa Kichina cha Jadi - Big5" },
            { "es", "Kihispania" },
            { "et", "Kiestonia" },
            { "Hanb", "Hanb" },
            { "eu", "Kibasque" },
            { "Hang", "Kihangul" },
            { "shi", "Kitachelhit" },
            { "hsb", "Kisobia cha Ukanda wa Juu" },
            { "Hani", "Kihan" },
            { "shn", "Kishan" },
            { "fa", "Kiajemi" },
            { "Hans", "Rahisi" },
            { "type.nu.latn", "Nambari za Magharibi" },
            { "Hant", "Cha jadi" },
            { "ff", "Kifula" },
            { "fi", "Kifini" },
            { "fj", "Kifiji" },
            { "fon", "Kifon" },
            { "bgn", "Kibalochi cha Magharibi" },
            { "yue", "Kikantoni" },
            { "fo", "Kifaroe" },
            { "type.m0.bgn", "Mtindo wa kunukuu wa US BGN" },
            { "umb", "Umbundu" },
            { "fr", "Kifaransa" },
            { "fy", "Kifrisia cha Magharibi" },
            { "ga", "Kiayalandi" },
            { "gd", "Kigaeli cha Uskoti" },
            { "gl", "Kigalisi" },
            { "gn", "Kiguarani" },
            { "bho", "Kibhojpuri" },
            { "und", "Lugha Isiyojulikana" },
            { "type.ca.ethiopic-amete-alem", "Kalenda ya Kiethiopia ya Amete Alem" },
            { "gu", metaValue_gu },
            { "gv", "Kimanx" },
            { "ha", "Kihausa" },
            { "he", metaValue_he },
            { "hi", "Kihindi" },
            { "hup", "Hupa" },
            { "bin", "Kibini" },
            { "hr", "Kikroeshia" },
            { "ht", "Kihaiti" },
            { "hu", "Kihangari" },
            { "hy", metaValue_hy },
            { "hz", "Kiherero" },
            { "ia", "Kiintalingua" },
            { "Jamo", "Jamo" },
            { "id", "Kiindonesia" },
            { "type.nu.tibt", "Nambari za Kitibeti" },
            { "ig", "Kiigbo" },
            { "ii", "Sichuan Yi" },
            { "fro", "Kifaransa cha Kale" },
            { "io", "Kiido" },
            { "frs", "Kifrisia cha Mashariki" },
            { "frr", "Kifrisia cha Kaskazini" },
            { "is", "Kiaisilandi" },
            { "it", "Kiitaliano" },
            { "iu", "Kiinuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "bkm", "Kikom" },
            { "sma", "Kisami cha Kusini" },
            { "jv", "Kijava" },
            { "mad", "Kimadura" },
            { "smj", "Kisami cha Lule" },
            { "mag", "Kimagahi" },
            { "maf", "Kimafa" },
            { "mai", "Kimaithili" },
            { "smn", "Kisami cha Inari" },
            { "ka", metaValue_ka },
            { "bla", "Kisiksika" },
            { "mak", "Kimakasar" },
            { "sms", "Kisami cha Skolt" },
            { "kg", "Kikongo" },
            { "ki", "Kikikuyu" },
            { "mas", "Kimaasai" },
            { "kj", "Kikwanyama" },
            { "kk", "Kikazakh" },
            { "kl", "Kikalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kikanuri" },
            { "ks", "Kikashmiri" },
            { "ku", "Kikurdi" },
            { "kv", "Kikomi" },
            { "kw", "Kikorni" },
            { "ky", "Kikyrgyz" },
            { "snk", "Kisoninke" },
            { "la", metaValue_la },
            { "lb", "Kilasembagi" },
            { "type.nu.mlym", "Nambari za Malayalam" },
            { "lg", "Kiganda" },
            { "li", "Limburgish" },
            { "Tibt", metaValue_bo },
            { "ln", "Kilingala" },
            { "fur", "Kifriulian" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Mfumo wa UK" },
            { "lt", "Kilithuania" },
            { "lu", "Kiluba-Katanga" },
            { "lv", "Kilatvia" },
            { "mg", "Kimalagasi" },
            { "mh", "Kimashale" },
            { "type.co.ducet", "Mpangilio Chaguo-Msingi wa Unicode" },
            { "mi", "Kimaori" },
            { "mk", "Kimacedonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Kimarathi" },
            { "ms", "Kimalei" },
            { "mt", "Kimalta" },
            { "my", "Kiburma" },
            { "Armn", metaValue_hy },
            { "mdf", "Lugha ya Moksha" },
            { "mde", "Kimaba" },
            { "dsb", "Kidolnoserbski" },
            { "na", "Kinauru" },
            { "type.co.search", "Utafutaji wa Kijumla" },
            { "nb", "Kinorwe cha Bokmal" },
            { "nd", "Kindebele cha Kaskazini" },
            { "ne", "Kinepali" },
            { "ng", "Kindonga" },
            { "nl", "Kiholanzi" },
            { "nn", "Kinorwe cha Nynorsk" },
            { "no", "Kinorwe" },
            { "nr", "Kindebele" },
            { "nv", "Kinavajo" },
            { "ny", "Kinyanja" },
            { "kac", "Kachin" },
            { "kab", "Kikabylia" },
            { "oc", "Kiokitani" },
            { "kaj", "Kijju" },
            { "kam", "Kikamba" },
            { "men", "Kimende" },
            { "mer", "Kimeru" },
            { "type.nu.armn", "Nambari za Kiarmenia" },
            { "om", "Kioromo" },
            { "or", metaValue_or },
            { "os", "Kiosetia" },
            { "kbd", "Kikabardian" },
            { "mfe", "Kimoriseni" },
            { "srn", "Lugha ya Sranan Tongo" },
            { "pa", "Kipunjabi" },
            { "dua", "Kiduala" },
            { "kbl", "Kikanembu" },
            { "pl", "Kipolandi" },
            { "type.ca.dangi", "Kalenda ya Dangi" },
            { "ps", "Kipashto" },
            { "pt", "Kireno" },
            { "key.co", "Mpangilio" },
            { "kcg", "Kityap" },
            { "mgh", "Kimakhuwa-Meetto" },
            { "key.cf", "Mpangilio wa Sarafu" },
            { "key.ca", "Kalenda" },
            { "Laoo", metaValue_lo },
            { "mgo", "Kimeta" },
            { "type.hc.h23", "Kipindi cha saa 24 (0\u201323)" },
            { "type.hc.h24", "Kipindi cha saa 24 (1\u201324)" },
            { "ssy", "Kisaho" },
            { "type.nu.mymr", "Nambari za Myanmar" },
            { "qu", "Kiquechua" },
            { "brx", "Kibodo" },
            { "kde", "Kimakonde" },
            { "Ethi", "Kiethiopia" },
            { "type.hc.h12", "Kipindi cha saa 12 (1\u201312)" },
            { "type.hc.h11", "Kipindi cha saa 12 (0\u201311)" },
            { "rm", "Kiromanshi" },
            { "rn", "Kirundi" },
            { "key.cu", "Sarafu" },
            { "ro", "Kiromania" },
            { "type.nu.orya", "Nambari za Kioriya" },
            { "type.nu.hanidec", "Nambari za Desimali za Kichina" },
            { "ru", "Kirusi" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kikabuverdianu" },
            { "mic", "Mi\u2019kmaq" },
            { "suk", "Kisukuma" },
            { "sa", "Kisanskriti" },
            { "sc", "Kisardinia" },
            { "sus", "Kisusu" },
            { "sd", "Kisindhi" },
            { "se", "Kisami cha Kaskazini" },
            { "min", "Kiminangkabau" },
            { "sg", "Kisango" },
            { "sh", "Kiserbia-kroeshia" },
            { "si", metaValue_si },
            { "sk", "Kislovakia" },
            { "sl", "Kislovenia" },
            { "sm", "Kisamoa" },
            { "sn", "Kishona" },
            { "so", "Kisomali" },
            { "type.nu.arab", "Nambari za Kiarabu/Kihindi" },
            { "sq", "Kialbania" },
            { "sr", "Kiserbia" },
            { "ss", "Kiswati" },
            { "type.cf.account", "Mpangilio wa Kihasibu wa Sarafu" },
            { "st", "Kisotho" },
            { "su", "Kisunda" },
            { "sv", "Kiswidi" },
            { "sw", "Kiswahili" },
            { "type.nu.hantfin", "Nambari za Kifedha za Kichina cha Jadi" },
            { "ibb", "Kiibibio" },
            { "iba", "Kiiban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "143", "Asia ya Kati" },
            { "te", metaValue_te },
            { "145", "Asia ya Magharibi" },
            { "tg", "Kitajiki" },
            { "th", "Kitailandi" },
            { "ti", "Kitigrinya" },
            { "bug", "Lugha ya Buginese" },
            { "kfo", "Kikoro" },
            { "en_CA", "Kiingereza (Canada)" },
            { "tk", "Kiturukimeni" },
            { "tn", "Kitswana" },
            { "to", "Kitonga" },
            { "bum", "Kibulu" },
            { "dyo", "Kijola-Fonyi" },
            { "type.nu.jpan", "Nambari za Kijapani" },
            { "tr", "Kituruki" },
            { "ts", "Kitsonga" },
            { "swb", "Shikomor" },
            { "tt", "Kitatari" },
            { "dyu", "Kijula" },
            { "tw", "Twi" },
            { "ty", "Kitahiti" },
            { "150", "Ulaya" },
            { "151", "Ulaya ya Mashariki" },
            { "154", "Ulaya ya Kaskazini" },
            { "dzg", "Kidazaga" },
            { "155", "Ulaya ya Magharibi" },
            { "ug", "Kiuyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Kawaida" },
            { "uk", "Kiukraine" },
            { "type.ca.coptic", "Kalenda ya Koptiki" },
            { "ur", "Kiurdu" },
            { "xal", "Kikalmyk" },
            { "uz", "Kiuzbeki" },
            { "kha", "Kikhasi" },
            { "ve", "Kivenda" },
            { "type.ca.roc", "Kalenda ya Minguo" },
            { "vi", "Kivietinamu" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Kipindi cha saa (12 au 24)" },
            { "vo", "Kivolapuk" },
            { "quc", "K\u02bciche\u02bc" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Kigagauz" },
            { "syr", "Lugha ya Syriac" },
            { "Grek", metaValue_el },
            { "wo", "Lugha ya Wolof" },
            { "zgh", "Kiberber Sanifu cha Moroko" },
            { "ar_001", "Kiarabu sanifu" },
            { "Mong", metaValue_mn },
            { "gba", "Kigbaya" },
            { "mni", "Kimanipuri" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "Nambari za Kichina Rahisi" },
            { "type.nu.hant", "Nambari za Kichina cha Jadi" },
            { "xh", "Kixhosa" },
            { "type.nu.romanlow", "Nambari Ndogo za Kirumi" },
            { "byn", "Kiblin" },
            { "byv", "Kimedumba" },
            { "moh", "Lugha ya Mohawk" },
            { "kkj", "Lugha ya Kako" },
            { "yi", "Kiyiddi" },
            { "mos", "Kimoore" },
            { "yo", "Kiyoruba" },
            { "type.nu.traditional", "Tarakimu za Jadi" },
            { "es_MX", "Kihispania (Mexico)" },
            { "vai", "Kivai" },
            { "kln", "Kikalenjin" },
            { "zh", "Kichina" },
            { "Bopo", "Kibopomofo" },
            { "key.lb", "Mtindo wa Kukata Mstari" },
            { "zu", "Kizulu" },
            { "type.co.phonebook", "Mpangilio wa Orodha za Nambari za Simu" },
            { "Geor", metaValue_ka },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Nambari za Kifedha za Kijapani" },
            { "gez", "Kige\u2019ez" },
            { "type.co.reformed", "Mpangilio Uliorekebishwa" },
            { "ebu", "Kiembu" },
            { "zh_Hans", "Kichina (Kilichorahisishwa)" },
            { "koi", "Kikomi-Permyak" },
            { "kok", "Kikonkani" },
            { "zh_Hant", "Kichina cha Jadi" },
            { "kpe", "Kikpelle" },
            { "type.nu.khmr", "Nambari za Kikhmer" },
            { "ilo", "Kiilocano" },
            { "mua", "Kimundang" },
            { "type.nu.guru", "Nambari za Kigurmukhi" },
            { "mul", "Lugha Nyingi" },
            { "key.ms", "Mfumo wa Vipimo" },
            { "mus", "Kikriki" },
            { "gil", "Kikiribati" },
            { "type.nu.tamldec", "Nambari za Kitamil" },
            { "krc", "Kikarachay-Balkar" },
            { "inh", "Kiingush" },
            { "krl", "Karjala" },
            { "efi", "Kiefik" },
            { "key.nu", "Nambari" },
            { "kru", "Kurukh" },
            { "ksb", "Kisambaa" },
            { "Telu", metaValue_te },
            { "ksf", "Kibafia" },
        };
        return data;
    }
}
