/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.LogRecord;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;

public class AsyncSocket
extends WebSocketAdapter
implements ConnectionManager.UpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncSocket.class);
    private static final String KEY_DEVICES = "devices";
    private static final String KEY_POSITIONS = "positions";
    private static final String KEY_EVENTS = "events";
    private static final String KEY_LOGS = "logs";
    private final ObjectMapper objectMapper;
    private final ConnectionManager connectionManager;
    private final Storage storage;
    private final long userId;
    private boolean includeLogs;

    public AsyncSocket(ObjectMapper objectMapper, ConnectionManager connectionManager, Storage storage, long userId) {
        this.objectMapper = objectMapper;
        this.connectionManager = connectionManager;
        this.storage = storage;
        this.userId = userId;
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        try {
            HashMap data = new HashMap();
            data.put(KEY_POSITIONS, PositionUtil.getLatestPositions(this.storage, this.userId));
            this.sendData(data);
            this.connectionManager.addListener(this.userId, this);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        this.connectionManager.removeListener(this.userId, this);
    }

    public void onWebSocketText(String message) {
        super.onWebSocketText(message);
        try {
            this.includeLogs = this.objectMapper.readTree(message).get(KEY_LOGS).asBoolean();
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Socket JSON parsing error", (Throwable)e);
        }
    }

    @Override
    public void onKeepalive() {
        this.sendData(new HashMap());
    }

    @Override
    public void onUpdateDevice(Device device) {
        this.sendData(Map.of(KEY_DEVICES, List.of(device)));
    }

    @Override
    public void onUpdatePosition(Position position) {
        this.sendData(Map.of(KEY_POSITIONS, List.of(position)));
    }

    @Override
    public void onUpdateEvent(Event event) {
        this.sendData(Map.of(KEY_EVENTS, List.of(event)));
    }

    @Override
    public void onUpdateLog(LogRecord record) {
        if (this.includeLogs) {
            this.sendData(Map.of(KEY_LOGS, List.of(record)));
        }
    }

    private void sendData(Map<String, Collection<?>> data) {
        if (this.isConnected()) {
            try {
                this.getRemote().sendString(this.objectMapper.writeValueAsString(data), null);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Socket JSON formatting error", (Throwable)e);
            }
        }
    }
}

