/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.broadcast;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.broadcast.BaseBroadcastService;
import org.traccar.broadcast.BroadcastMessage;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public class MulticastBroadcastService
extends BaseBroadcastService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastBroadcastService.class);
    private final ObjectMapper objectMapper;
    private final NetworkInterface networkInterface;
    private final int port;
    private final InetSocketAddress group;
    private DatagramSocket publisherSocket;
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private final byte[] receiverBuffer = new byte[4096];
    private final Runnable receiver = new Runnable(){

        @Override
        public void run() {
            try (MulticastSocket socket = new MulticastSocket(MulticastBroadcastService.this.port);){
                socket.setNetworkInterface(MulticastBroadcastService.this.networkInterface);
                socket.joinGroup(MulticastBroadcastService.this.group, MulticastBroadcastService.this.networkInterface);
                MulticastBroadcastService.this.publisherSocket = socket;
                while (!MulticastBroadcastService.this.service.isShutdown()) {
                    DatagramPacket packet = new DatagramPacket(MulticastBroadcastService.this.receiverBuffer, MulticastBroadcastService.this.receiverBuffer.length);
                    socket.receive(packet);
                    if (!MulticastBroadcastService.this.networkInterface.inetAddresses().noneMatch(a -> a.equals(packet.getAddress()))) continue;
                    String data = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
                    MulticastBroadcastService.this.handleMessage((BroadcastMessage)MulticastBroadcastService.this.objectMapper.readValue(data, BroadcastMessage.class));
                }
                MulticastBroadcastService.this.publisherSocket = null;
                socket.leaveGroup(MulticastBroadcastService.this.group, MulticastBroadcastService.this.networkInterface);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public MulticastBroadcastService(Config config, ObjectMapper objectMapper) throws IOException {
        this.objectMapper = objectMapper;
        this.port = config.getInteger(Keys.BROADCAST_PORT);
        String interfaceName = config.getString(Keys.BROADCAST_INTERFACE);
        this.networkInterface = interfaceName.indexOf(46) >= 0 || interfaceName.indexOf(58) >= 0 ? NetworkInterface.getByInetAddress(InetAddress.getByName(interfaceName)) : NetworkInterface.getByName(interfaceName);
        InetAddress address = InetAddress.getByName(config.getString(Keys.BROADCAST_ADDRESS));
        this.group = new InetSocketAddress(address, this.port);
    }

    @Override
    public boolean singleInstance() {
        return false;
    }

    @Override
    protected void sendMessage(BroadcastMessage message) {
        try {
            byte[] buffer = this.objectMapper.writeValueAsString((Object)message).getBytes(StandardCharsets.UTF_8);
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.group);
            this.publisherSocket.send(packet);
        }
        catch (IOException e) {
            LOGGER.warn("Broadcast failed", (Throwable)e);
        }
    }

    @Override
    public void start() throws IOException {
        this.service.submit(this.receiver);
    }

    @Override
    public void stop() {
        this.service.shutdown();
    }
}

