/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class DriverEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public DriverEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void analyzePosition(Position position, BaseEventHandler.Callback callback) {
        if (!PositionUtil.isLatest(this.cacheManager, position)) {
            return;
        }
        String driverUniqueId = position.getString("driverUniqueId");
        if (driverUniqueId != null) {
            String oldDriverUniqueId = null;
            Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
            if (lastPosition != null) {
                oldDriverUniqueId = lastPosition.getString("driverUniqueId");
            }
            if (!driverUniqueId.equals(oldDriverUniqueId)) {
                Event event = new Event("driverChanged", position);
                event.set("driverUniqueId", driverUniqueId);
                callback.eventDetected(event);
            }
        }
    }
}

