/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public class Xexun2ProtocolEncoder
extends BaseProtocolEncoder {
    public Xexun2ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private static ByteBuf encodeContent(String uniqueId, String content) {
        ByteBuf buf = Unpooled.buffer();
        ByteBuf message = Unpooled.copiedBuffer((byte[])content.getBytes(StandardCharsets.US_ASCII));
        buf.writeShort(64175);
        buf.writeShort(7);
        buf.writeShort(1);
        buf.writeBytes(DataConverter.parseHex(uniqueId + "0"));
        buf.writeShort(message.readableBytes());
        buf.writeShort(Checksum.ip(message.nioBuffer()));
        buf.writeBytes(message);
        buf.writeShort(64175);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        return switch (command.getType()) {
            case "custom" -> Xexun2ProtocolEncoder.encodeContent(uniqueId, command.getString("data"));
            case "positionPeriodic" -> Xexun2ProtocolEncoder.encodeContent(uniqueId, String.format("tracking_send=%1$d,%1$d", command.getInteger("frequency")));
            case "powerOff" -> Xexun2ProtocolEncoder.encodeContent(uniqueId, "of=1");
            case "rebootDevice" -> Xexun2ProtocolEncoder.encodeContent(uniqueId, "reset");
            default -> null;
        };
    }
}

