/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage;

import java.util.List;
import org.traccar.model.BaseModel;
import org.traccar.model.Permission;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Request;

public abstract class Storage {
    public abstract <T> List<T> getObjects(Class<T> var1, Request var2) throws StorageException;

    public abstract <T> long addObject(T var1, Request var2) throws StorageException;

    public abstract <T> void updateObject(T var1, Request var2) throws StorageException;

    public abstract void removeObject(Class<?> var1, Request var2) throws StorageException;

    public abstract List<Permission> getPermissions(Class<? extends BaseModel> var1, long var2, Class<? extends BaseModel> var4, long var5) throws StorageException;

    public abstract void addPermission(Permission var1) throws StorageException;

    public abstract void removePermission(Permission var1) throws StorageException;

    public List<Permission> getPermissions(Class<? extends BaseModel> ownerClass, Class<? extends BaseModel> propertyClass) throws StorageException {
        return this.getPermissions(ownerClass, 0L, propertyClass, 0L);
    }

    public <T> T getObject(Class<T> clazz, Request request) throws StorageException {
        List<T> objects = this.getObjects(clazz, request);
        return objects.isEmpty() ? null : (T)objects.get(0);
    }
}

