/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.eclipse.jetty.servlets.DoSFilter;
import org.traccar.config.Config;
import org.traccar.config.Keys;

@Singleton
public class ThrottlingFilter
extends DoSFilter {
    @Inject
    private Config config;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.config.hasKey(Keys.WEB_MAX_REQUESTS_PER_SECOND)) {
            this.setMaxRequestsPerSec(this.config.getInteger(Keys.WEB_MAX_REQUESTS_PER_SECOND));
        }
        this.setMaxRequestMs((long)this.config.getInteger(Keys.WEB_MAX_REQUEST_SECONDS) * 1000L);
    }

    protected String extractUserId(ServletRequest request) {
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session != null) {
            Object userId = session.getAttribute("userId");
            return userId != null ? userId.toString() : null;
        }
        return null;
    }
}

