/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundRepeat
extends org.w3c.css.properties.css.CssBackgroundRepeat {
    public static final CssIdent repeat;
    private static CssIdent[] allowed_simple_values;
    private static CssIdent[] allowed_double_values;

    public static boolean isMatchingIdent(CssIdent ident) {
        return CssBackgroundRepeat.getMatchingIdent(ident) != null;
    }

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_simple_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        for (CssIdent id : allowed_double_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getSimpleValue(CssIdent ident) {
        for (CssIdent id : allowed_simple_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getDoubleValue(CssIdent ident) {
        for (CssIdent id : allowed_double_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssBackgroundRepeat() {
        this.value = repeat;
    }

    public CssBackgroundRepeat(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        this.value = CssBackgroundRepeat.checkBackgroundRepeat(ac, expression, this);
    }

    public static CssValue checkBackgroundRepeat(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean is_complete = true;
        CssValueList vl = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", expression.getValue(), caller.getPropertyName(), ac);
            }
            CssIdent id_val = val.getIdent();
            if (CssIdent.isCssWide(id_val)) {
                if (values.size() > 0 || expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
                }
                return val;
            }
            if (CssBackgroundRepeat.getSimpleValue(id_val) != null) {
                if (!is_complete) {
                    throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
                }
                values.add(val);
                is_complete = true;
            } else {
                if (CssBackgroundRepeat.getDoubleValue(id_val) == null) {
                    throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
                }
                if (is_complete) {
                    vl = new CssValueList();
                    vl.add(val);
                } else {
                    vl.add(val);
                    values.add(vl);
                }
                is_complete = !is_complete;
            }
            expression.next();
            if (expression.end()) continue;
            if (!is_complete && op == ',') {
                values.add(vl);
                is_complete = true;
            }
            if ((!is_complete || op == ',') && (is_complete || op == ' ')) continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (!is_complete) {
            values.add(vl);
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    public CssBackgroundRepeat(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return repeat == this.value;
    }

    static {
        String[] REPEAT = new String[]{"repeat", "space", "round", "no-repeat"};
        allowed_simple_values = new CssIdent[2];
        CssBackgroundRepeat.allowed_simple_values[0] = CssIdent.getIdent("repeat-x");
        CssBackgroundRepeat.allowed_simple_values[1] = CssIdent.getIdent("repeat-y");
        allowed_double_values = new CssIdent[REPEAT.length];
        int i = 0;
        for (String aREPEAT : REPEAT) {
            CssBackgroundRepeat.allowed_double_values[i++] = CssIdent.getIdent(aREPEAT);
        }
        repeat = CssIdent.getIdent("repeat");
    }
}

