/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.mobile;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public class CssBackgroundColor
extends org.w3c.css.properties.css.CssBackgroundColor {
    public CssValue color;

    public CssBackgroundColor() {
        this.color = transparent;
    }

    public CssBackgroundColor(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 15: {
                CssColor c = new CssColor();
                c.setShortRGBColor(ac, val.toString());
                this.setColor(c);
                break;
            }
            case 3: {
                this.setColor(val);
                break;
            }
            case 0: {
                if (transparent.equals(val)) {
                    this.setColor(transparent);
                    break;
                }
                if (inherit.equals(val)) {
                    this.setColor(inherit);
                    break;
                }
                this.setColor(new CssColor(ac, (String)val.get()));
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssBackgroundColor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void setColor(CssValue color) {
        this.color = color;
    }

    @Override
    public Object get() {
        return this.color;
    }

    @Override
    public final CssValue getColor() {
        return this.color;
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.color.equals(inherit);
    }

    @Override
    public String toString() {
        if (this.color != null) {
            return this.color.toString();
        }
        return "";
    }

    @Override
    public boolean isDefault() {
        return this.color == transparent;
    }
}

