/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import java.util.List;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.conf.EncryptionMethod;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.MemberAttributeType;

public class ConnectedLDAPConfiguration
implements LDAPConfiguration,
AutoCloseable {
    private final LDAPConfiguration config;
    private final LdapNetworkConnection connection;
    private final Dn bindDn;

    public ConnectedLDAPConfiguration(LDAPConfiguration config, Dn bindDn, LdapNetworkConnection connection) {
        this.config = config;
        this.bindDn = bindDn;
        this.connection = connection;
    }

    public LdapNetworkConnection getLDAPConnection() {
        return this.connection;
    }

    public Dn getBindDN() {
        return this.bindDn;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public String appliesTo(String username) throws GuacamoleException {
        return this.config.appliesTo(username);
    }

    @Override
    public String getServerHostname() throws GuacamoleException {
        return this.config.getServerHostname();
    }

    @Override
    public int getServerPort() throws GuacamoleException {
        return this.config.getServerPort();
    }

    @Override
    public List<String> getUsernameAttributes() throws GuacamoleException {
        return this.config.getUsernameAttributes();
    }

    @Override
    public Dn getUserBaseDN() throws GuacamoleException {
        return this.config.getUserBaseDN();
    }

    @Override
    public Dn getConfigurationBaseDN() throws GuacamoleException {
        return this.config.getConfigurationBaseDN();
    }

    @Override
    public List<String> getGroupNameAttributes() throws GuacamoleException {
        return this.config.getGroupNameAttributes();
    }

    @Override
    public Dn getGroupBaseDN() throws GuacamoleException {
        return this.config.getGroupBaseDN();
    }

    @Override
    public String getSearchBindDN() throws GuacamoleException {
        return this.config.getSearchBindDN();
    }

    @Override
    public String getSearchBindPassword() throws GuacamoleException {
        return this.config.getSearchBindPassword();
    }

    @Override
    public EncryptionMethod getEncryptionMethod() throws GuacamoleException {
        return this.config.getEncryptionMethod();
    }

    @Override
    public int getMaxResults() throws GuacamoleException {
        return this.config.getMaxResults();
    }

    @Override
    public AliasDerefMode getDereferenceAliases() throws GuacamoleException {
        return this.config.getDereferenceAliases();
    }

    @Override
    public boolean getFollowReferrals() throws GuacamoleException {
        return this.config.getFollowReferrals();
    }

    @Override
    public int getMaxReferralHops() throws GuacamoleException {
        return this.config.getMaxReferralHops();
    }

    @Override
    public ExprNode getUserSearchFilter() throws GuacamoleException {
        return this.config.getUserSearchFilter();
    }

    @Override
    public ExprNode getGroupSearchFilter() throws GuacamoleException {
        return this.config.getGroupSearchFilter();
    }

    @Override
    public int getOperationTimeout() throws GuacamoleException {
        return this.config.getOperationTimeout();
    }

    @Override
    public int getNetworkTimeout() throws GuacamoleException {
        return this.config.getNetworkTimeout();
    }

    @Override
    public List<String> getAttributes() throws GuacamoleException {
        return this.config.getAttributes();
    }

    @Override
    public String getMemberAttribute() throws GuacamoleException {
        return this.config.getMemberAttribute();
    }

    @Override
    public MemberAttributeType getMemberAttributeType() throws GuacamoleException {
        return this.config.getMemberAttributeType();
    }
}

