<?php
/**
 * ViewsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * ViewsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ViewsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation getDashboardsIDCellsIDView
     *
     * Retrieve the view for a cell
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getDashboardsIDCellsIDView($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        list($response) = $this->getDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getDashboardsIDCellsIDViewWithHttpInfo
     *
     * Retrieve the view for a cell
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $request = $this->getDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\View';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsIDCellsIDView'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling getDashboardsIDCellsIDView'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDashboardsIDCellsIDView
     *
     * Update the view for a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDashboardsIDCellsIDView($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        list($response) = $this->patchDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $view, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchDashboardsIDCellsIDViewWithHttpInfo
     *
     * Update the view for a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        $request = $this->patchDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $view, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\View';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDashboardsIDCellsIDView'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling patchDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling patchDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'view' is set
        if ($view === null || (is_array($view) && count($view) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view when calling patchDashboardsIDCellsIDView'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($view)) {
            $_tempBody = $view;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
