/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import org.apache.log4j.Logger;

public class UsageComponentUI
implements PlayPenComponentUI {
    private static final Logger logger = Logger.getLogger(UsageComponentUI.class);
    private UsageComponent c;
    private int blobRadius = 4;
    private double selectionFuzziness = 3.1415926545;
    private SPListener componentEventHandler = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            if (("topLeftCorner".equals(evt.getPropertyName()) || "lengths".equals(evt.getPropertyName())) && evt.getSource() != UsageComponentUI.this.c) {
                UsageComponentUI.this.revalidate();
                UsageComponentUI.this.c.repaint();
            }
        }
    };

    public boolean intersects(Rectangle rubberBand) {
        Point p1c = this.centreOf(this.c.getPane1().getBounds());
        Point p2c = this.centreOf(this.c.getPane2().getBounds());
        Line2D.Double line = new Line2D.Double(p1c.x, p1c.y, p2c.x, p2c.y);
        return line.intersects(rubberBand.x, rubberBand.y, rubberBand.width, rubberBand.height);
    }

    @Override
    public boolean contains(Point p) {
        Point p1c = this.centreOf(this.c.getPane1().getBounds());
        Point p2c = this.centreOf(this.c.getPane2().getBounds());
        boolean containsPoint = Line2D.ptLineDist(p1c.x, p1c.y, p2c.x, p2c.y, p.x, p.y) <= this.selectionFuzziness;
        logger.debug((Object)("Contains point " + p + "? " + containsPoint));
        return containsPoint;
    }

    @Override
    public Dimension getPreferredSize() {
        Point p1c = this.centreOf(this.c.getPane1().getBounds());
        Point p2c = this.centreOf(this.c.getPane2().getBounds());
        return new Dimension(Math.abs(p1c.x - p2c.x), Math.abs(p1c.y - p2c.y));
    }

    @Override
    public void paint(Graphics2D g2) {
        OLAPPane<?, ?> p1 = this.c.getPane1();
        Rectangle p1b = p1.getBounds();
        Point p1c = this.centreOf(p1b);
        OLAPPane<?, ?> p2 = this.c.getPane2();
        Rectangle p2b = p2.getBounds();
        Point p2c = this.centreOf(p2b);
        Point p1edge = this.insersectionPoint(p1b, p1c, p2c);
        Point p2edge = this.insersectionPoint(p2b, p2c, p1c);
        if (this.c.isSelected()) {
            g2.setColor(Color.RED);
        } else {
            g2.setColor(this.c.getForegroundColor());
        }
        p1c.translate(-this.c.getX(), -this.c.getY());
        p2c.translate(-this.c.getX(), -this.c.getY());
        if (p1edge != null) {
            p1edge.translate(-this.c.getX(), -this.c.getY());
        }
        if (p2edge != null) {
            p2edge.translate(-this.c.getX(), -this.c.getY());
        }
        g2.drawLine(p1c.x, p1c.y, p2c.x, p2c.y);
        if (p1edge != null) {
            g2.fillOval(p1edge.x - this.blobRadius, p1edge.y - this.blobRadius, this.blobRadius * 2, this.blobRadius * 2);
        }
        if (p2edge != null) {
            g2.fillOval(p2edge.x - this.blobRadius, p2edge.y - this.blobRadius, this.blobRadius * 2, this.blobRadius * 2);
        }
    }

    private Point insersectionPoint(Rectangle r, Point p1, Point p2) {
        Point i;
        int outcode = r.outcode(p2.x, p2.y);
        if ((outcode & 5) != 0) {
            int x = (outcode & 1) != 0 ? r.x : r.x + r.width;
            int y = UsageComponentUI.y(p2, p1, x);
            if (y < r.y) {
                y = r.y;
                x = UsageComponentUI.x(p1, p2, y);
            } else if (y > r.y + r.height) {
                y = r.y + r.height;
                x = UsageComponentUI.x(p1, p2, y);
            }
            i = new Point(x, y);
        } else if ((outcode & 2) != 0) {
            int y = r.y;
            int x = UsageComponentUI.x(p1, p2, y);
            i = new Point(x, y);
        } else if ((outcode & 8) != 0) {
            int y = r.y + r.height;
            int x = UsageComponentUI.x(p1, p2, y);
            i = new Point(x, y);
        } else {
            i = null;
        }
        return i;
    }

    @Override
    public void revalidate() {
        Point p1c = this.centreOf(this.c.getPane1().getBounds());
        Point p2c = this.centreOf(this.c.getPane2().getBounds());
        Rectangle r = new Rectangle(p1c.x, p1c.y, 0, 0);
        r.add(p2c);
        this.c.setBounds(r.x, r.y, r.width, r.height);
    }

    public static int y(Point2D p1, Point2D p2, double x) {
        double m1 = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        double a = -m1 * p1.getX() + p1.getY();
        logger.debug((Object)("m1 = " + m1));
        double y = m1 * x + a;
        return (int)y;
    }

    public static int x(Point2D p1, Point2D p2, double y) {
        if (p2.getX() == p1.getX()) {
            return (int)p2.getX();
        }
        double m1 = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        double a = -m1 * p1.getX() + p1.getY();
        double x = (y - a) / m1;
        return (int)x;
    }

    protected Point centreOf(Rectangle r) {
        return new Point((int)r.getCenterX(), (int)r.getCenterY());
    }

    @Override
    public void uninstallUI(PlayPenComponent c) {
        if (c != this.c) {
            throw new IllegalArgumentException("Attempted to uninstall this delegate from the wrong component");
        }
        UsageComponent uc = (UsageComponent)c;
        uc.removeSPListener(this.componentEventHandler);
        uc.getPane1().addSPListener(this.componentEventHandler);
        uc.getPane2().addSPListener(this.componentEventHandler);
        this.c = null;
    }

    @Override
    public void installUI(PlayPenComponent c) {
        UsageComponent uc;
        if (this.c != null) {
            throw new IllegalStateException("This delegate is already installed on a component");
        }
        this.c = uc = (UsageComponent)c;
        uc.addSPListener(this.componentEventHandler);
        uc.getPane1().addSPListener(this.componentEventHandler);
        uc.getPane2().addSPListener(this.componentEventHandler);
    }

    @Override
    public Point getPointForModelObject(Object modelObject) {
        return this.c.getLocation();
    }
}

