/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.lang.reflect.Field;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.MethodWriter;
import org.objectweb.asm.SymbolTable;
import org.objectweb.asm.tree.MethodNode;

public final class AsmBridge {
    public static MethodVisitor searchMethodWriter(MethodVisitor methodVisitor) {
        while (methodVisitor != null && !(methodVisitor instanceof MethodWriter)) {
            methodVisitor = methodVisitor.mv;
        }
        return methodVisitor;
    }

    public static int sizeOfMethodWriter(MethodVisitor methodVisitor) {
        MethodWriter mw = (MethodWriter)methodVisitor;
        return mw.computeMethodInfoSize();
    }

    private static void removeMethodWriter(MethodWriter methodWriter) {
        block7: {
            try {
                ClassWriter classWriter = AsmBridge.reflectForClassWriter(methodWriter);
                Field fmField = ClassWriter.class.getDeclaredField("firstMethod");
                fmField.setAccessible(true);
                MethodWriter firstMethodWriter = (MethodWriter)fmField.get(classWriter);
                Field lmField = ClassWriter.class.getDeclaredField("lastMethod");
                lmField.setAccessible(true);
                MethodWriter lastMethodWriter = (MethodWriter)lmField.get(classWriter);
                if (firstMethodWriter == methodWriter) {
                    fmField.set(classWriter, null);
                    if (lastMethodWriter == methodWriter) {
                        lmField.set(classWriter, null);
                    }
                    break block7;
                }
                while (firstMethodWriter != null) {
                    if (firstMethodWriter.mv == methodWriter) {
                        firstMethodWriter.mv = methodWriter.mv;
                        if (lastMethodWriter == methodWriter) {
                            lmField.set(classWriter, firstMethodWriter);
                        }
                        break;
                    }
                    firstMethodWriter = (MethodWriter)firstMethodWriter.mv;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                exc.printStackTrace();
            }
        }
    }

    private static ClassWriter reflectForClassWriter(MethodWriter methodWriter) throws NoSuchFieldException, IllegalAccessException {
        Field stField = MethodWriter.class.getDeclaredField("symbolTable");
        stField.setAccessible(true);
        SymbolTable symbolTable = (SymbolTable)stField.get(methodWriter);
        return symbolTable.classWriter;
    }

    public static void replaceMethodWriter(MethodVisitor methodVisitor, MethodNode methodNode) {
        MethodWriter methodWriter = (MethodWriter)methodVisitor;
        try {
            ClassWriter classWriter = AsmBridge.reflectForClassWriter(methodWriter);
            methodNode.accept((ClassVisitor)classWriter);
            AsmBridge.removeMethodWriter(methodWriter);
        }
        catch (IllegalAccessException | NoSuchFieldException exc) {
            exc.printStackTrace();
        }
    }

    private AsmBridge() {
        throw new UnsupportedOperationException();
    }
}

