/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { getErrorMessage as getCoreErrorMessage } from '@google/gemini-cli-core';
/**
 * Extracts a human-readable error message specifically for ACP (IDE) clients.
 * This function recursively parses JSON error blobs that are common in
 * Google API responses but ugly to display in an IDE's UI.
 */
export function getAcpErrorMessage(error) {
    const coreMessage = getCoreErrorMessage(error);
    return extractRecursiveMessage(coreMessage);
}
function extractRecursiveMessage(input) {
    const trimmed = input.trim();
    // Attempt to parse JSON error responses (common in Google API errors)
    if ((trimmed.startsWith('{') && trimmed.endsWith('}')) ||
        (trimmed.startsWith('[') && trimmed.endsWith(']'))) {
        try {
            const parsed = JSON.parse(trimmed);
            const next = parsed?.error?.message ||
                parsed?.[0]?.error?.message ||
                parsed?.message;
            if (next && typeof next === 'string' && next !== input) {
                return extractRecursiveMessage(next);
            }
        }
        catch {
            // Fall back to original string if parsing fails
        }
    }
    return input;
}
//# sourceMappingURL=acpErrors.js.map