/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import jdk.jfr.consumer.RecordingFile;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.RecordingInternals;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.PrettyWriter;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Metadata
extends Command {
    Metadata() {
    }

    @Override
    public String getName() {
        return "metadata";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("<file>");
    }

    @Override
    public String getDescription() {
        return "Display event metadata, such as labels, descriptions and field layout";
    }

    @Override
    public void execute(Deque<String> deque) throws UserSyntaxException, UserDataException {
        Path path = this.getJFRInputFile(deque);
        boolean bl = false;
        int n = deque.size();
        while (n > 0) {
            if (this.acceptOption(deque, "--ids")) {
                bl = true;
            }
            if (n == deque.size()) {
                throw new UserSyntaxException("unknown option " + deque.peek());
            }
            n = deque.size();
        }
        try (PrintWriter printWriter = new PrintWriter(System.out);){
            PrettyWriter prettyWriter = new PrettyWriter(printWriter);
            prettyWriter.setShowIds(bl);
            try (RecordingFile recordingFile = new RecordingFile(path);){
                List<Type> list = RecordingInternals.INSTANCE.readTypes(recordingFile);
                Collections.sort(list, new TypeComparator());
                for (Type type : list) {
                    prettyWriter.printType(type);
                }
                prettyWriter.flush(true);
            }
            catch (IOException iOException) {
                this.couldNotReadError(path, iOException);
            }
        }
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type type, Type type2) {
            int n;
            int n2 = this.groupValue(type);
            if (n2 == (n = this.groupValue(type2))) {
                String string;
                String string2 = type.getName();
                String string3 = type2.getName();
                String string4 = string2.substring(0, string2.lastIndexOf(46) + 1);
                if (string4.equals(string = string3.substring(0, string3.lastIndexOf(46) + 1))) {
                    return string2.compareTo(string3);
                }
                if (Type.SUPER_TYPE_EVENT.equals(type.getSuperType()) && !string4.equals(string)) {
                    if (string4.equals("jdk.jfr")) {
                        return -1;
                    }
                    if (string.equals("jdk.jfr")) {
                        return 1;
                    }
                }
                return string4.compareTo(string);
            }
            return Integer.compare(this.groupValue(type), this.groupValue(type2));
        }

        int groupValue(Type type) {
            String string = type.getSuperType();
            if (string == null) {
                return 1;
            }
            if (Type.SUPER_TYPE_ANNOTATION.equals(string)) {
                return 3;
            }
            if (Type.SUPER_TYPE_SETTING.equals(string)) {
                return 4;
            }
            if (Type.SUPER_TYPE_EVENT.equals(string)) {
                return 5;
            }
            return 2;
        }
    }
}

