/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.mutiny.core.Vertx;

@MutinyGen(value=io.vertx.core.VertxBuilder.class)
public class VertxBuilder
implements MutinyDelegate {
    public static final TypeArg<VertxBuilder> __TYPE_ARG = new TypeArg(obj -> new VertxBuilder((io.vertx.core.VertxBuilder)obj), VertxBuilder::getDelegate);
    private final io.vertx.core.VertxBuilder delegate;

    public VertxBuilder(io.vertx.core.VertxBuilder delegate) {
        this.delegate = delegate;
    }

    public VertxBuilder(Object delegate) {
        this.delegate = (io.vertx.core.VertxBuilder)delegate;
    }

    VertxBuilder() {
        this.delegate = null;
    }

    public io.vertx.core.VertxBuilder getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertxBuilder that = (VertxBuilder)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Fluent
    public VertxBuilder with(VertxOptions options) {
        this.delegate.with(options);
        return this;
    }

    public Vertx build() {
        Vertx ret = Vertx.newInstance(this.delegate.build());
        return ret;
    }

    @CheckReturnValue
    public Uni<Vertx> buildClustered() {
        return AsyncResultUni.toUni(handler -> this.delegate.buildClustered(MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> Vertx.newInstance(event)))));
    }

    public Vertx buildClusteredAndAwait() {
        return (Vertx)this.buildClustered().await().indefinitely();
    }

    public void buildClusteredAndForget() {
        this.buildClustered().subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    public VertxBuilder withMetrics(VertxMetricsFactory factory) {
        this.delegate.withMetrics(factory);
        return this;
    }

    @Fluent
    public VertxBuilder withTracer(VertxTracerFactory factory) {
        this.delegate.withTracer(factory);
        return this;
    }

    @Fluent
    public VertxBuilder withClusterManager(ClusterManager clusterManager) {
        this.delegate.withClusterManager(clusterManager);
        return this;
    }

    public static VertxBuilder newInstance(io.vertx.core.VertxBuilder arg) {
        return arg != null ? new VertxBuilder(arg) : null;
    }
}

